# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
"""FFI API."""

# tvm-ffi-stubgen(begin): import
# fmt: off
# isort: off
from __future__ import annotations
from typing import Any, Callable, TYPE_CHECKING
if TYPE_CHECKING:
    from collections.abc import Mapping, Sequence
    from tvm_ffi import Module, Object
    from tvm_ffi.access_path import AccessPath
# isort: on
# fmt: on
# tvm-ffi-stubgen(end)

from . import registry

# tvm-ffi-stubgen(begin): global/ffi
# fmt: off
if TYPE_CHECKING:
    def Array(*args: Any) -> Any: ...
    def ArrayGetItem(_0: Sequence[Any], _1: int, /) -> Any: ...
    def ArraySize(_0: Sequence[Any], /) -> int: ...
    def Bytes(_0: bytes, /) -> bytes: ...
    def FromJSONGraph(_0: Any, /) -> Any: ...
    def FromJSONGraphString(_0: str, /) -> Any: ...
    def FunctionListGlobalNamesFunctor() -> Callable[..., Any]: ...
    def FunctionRemoveGlobal(_0: str, /) -> bool: ...
    def GetFirstStructuralMismatch(_0: Any, _1: Any, _2: bool, _3: bool, /) -> tuple[AccessPath, AccessPath] | None: ...
    def GetGlobalFuncMetadata(_0: str, /) -> str: ...
    def GetRegisteredTypeKeys() -> Sequence[str]: ...
    def MakeObjectFromPackedArgs(*args: Any) -> Any: ...
    def Map(*args: Any) -> Any: ...
    def MapCount(_0: Mapping[Any, Any], _1: Any, /) -> int: ...
    def MapForwardIterFunctor(_0: Mapping[Any, Any], /) -> Callable[..., Any]: ...
    def MapGetItem(_0: Mapping[Any, Any], _1: Any, /) -> Any: ...
    def MapGetItemOrMissing(_0: Mapping[Any, Any], _1: Any, /) -> Any: ...
    def MapGetMissingObject() -> Object: ...
    def MapSize(_0: Mapping[Any, Any], /) -> int: ...
    def ModuleClearImports(_0: Module, /) -> None: ...
    def ModuleGetFunction(_0: Module, _1: str, _2: bool, /) -> Callable[..., Any] | None: ...
    def ModuleGetFunctionDoc(_0: Module, _1: str, _2: bool, /) -> str | None: ...
    def ModuleGetFunctionMetadata(_0: Module, _1: str, _2: bool, /) -> str | None: ...
    def ModuleGetKind(_0: Module, /) -> str: ...
    def ModuleGetPropertyMask(_0: Module, /) -> int: ...
    def ModuleGetWriteFormats(_0: Module, /) -> Sequence[str]: ...
    def ModuleGlobalsAdd(_0: Module, /) -> None: ...
    def ModuleGlobalsRemove(_0: Module, /) -> None: ...
    def ModuleImplementsFunction(_0: Module, _1: str, _2: bool, /) -> bool: ...
    def ModuleImportModule(_0: Module, _1: Module, /) -> None: ...
    def ModuleInspectSource(_0: Module, _1: str, /) -> str: ...
    def ModuleLoadFromFile(_0: str, /) -> Module: ...
    def ModuleWriteToFile(_0: Module, _1: str, _2: str, /) -> None: ...
    def Shape(*args: Any) -> Any: ...
    def String(_0: str, /) -> str: ...
    def StructuralHash(_0: Any, _1: bool, _2: bool, /) -> int: ...
    def SystemLib(*args: Any) -> Any: ...
    def ToJSONGraph(_0: Any, _1: Any, /) -> Any: ...
    def ToJSONGraphString(_0: Any, _1: Any, /) -> str: ...
# fmt: on
# tvm-ffi-stubgen(end)

registry.init_ffi_api("ffi", __name__)


__all__ = [
    # tvm-ffi-stubgen(begin): __all__
    "Array",
    "ArrayGetItem",
    "ArraySize",
    "Bytes",
    "FromJSONGraph",
    "FromJSONGraphString",
    "FunctionListGlobalNamesFunctor",
    "FunctionRemoveGlobal",
    "GetFirstStructuralMismatch",
    "GetGlobalFuncMetadata",
    "GetRegisteredTypeKeys",
    "MakeObjectFromPackedArgs",
    "Map",
    "MapCount",
    "MapForwardIterFunctor",
    "MapGetItem",
    "MapGetItemOrMissing",
    "MapGetMissingObject",
    "MapSize",
    "ModuleClearImports",
    "ModuleGetFunction",
    "ModuleGetFunctionDoc",
    "ModuleGetFunctionMetadata",
    "ModuleGetKind",
    "ModuleGetPropertyMask",
    "ModuleGetWriteFormats",
    "ModuleGlobalsAdd",
    "ModuleGlobalsRemove",
    "ModuleImplementsFunction",
    "ModuleImportModule",
    "ModuleInspectSource",
    "ModuleLoadFromFile",
    "ModuleWriteToFile",
    "Shape",
    "String",
    "StructuralHash",
    "SystemLib",
    "ToJSONGraph",
    "ToJSONGraphString",
    # tvm-ffi-stubgen(end)
]
