/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image;

import java.io.IOException;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.util.image.ImageUtil;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;

public class InlineImage
extends WebComponent {
    private static final long serialVersionUID = 1L;
    private PackageResourceReference packageResourceReference;

    public InlineImage(String id, PackageResourceReference packageResourceReference) {
        this(id, null, packageResourceReference);
    }

    public InlineImage(String id, IModel<?> model, PackageResourceReference packageResourceReference) {
        super(id, model);
        this.packageResourceReference = packageResourceReference;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "img");
        try {
            tag.put("src", ImageUtil.createBase64EncodedImage(this.packageResourceReference, false));
        }
        catch (ResourceStreamNotFoundException e) {
            throw new WicketRuntimeException("Couldn't find the resource stream", e);
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Error while reading the resource stream", e);
        }
    }
}

