/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.Comparator;
import java.util.TreeSet;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.XPath20TypeHelper;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AttrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CommentType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.PIType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.SchemaTypeValueFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.TextType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.utils.ResultSequenceUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public abstract class NodeType
extends AnyType {
    protected static final String SCHEMA_TYPE_IDREF = "IDREF";
    protected static final String SCHEMA_TYPE_ID = "ID";
    private Node _node;
    public static final Comparator NODE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return NodeType.compare_node((NodeType)o1, (NodeType)o2);
        }
    };

    public NodeType(Node node) {
        this._node = node;
    }

    public Node node_value() {
        return this._node;
    }

    public abstract ResultSequence typed_value() throws DynamicError;

    public abstract QName node_name();

    public ResultSequence nilled() {
        return ResultSequenceFactory.create_new();
    }

    public static NodeType dom_to_xpath(Node node) {
        assert (node != null);
        switch (node.getNodeType()) {
            case 1: {
                return new ElementType((Element)node);
            }
            case 8: {
                return new CommentType((Comment)node);
            }
            case 2: {
                return new AttrType((Attr)node);
            }
            case 3: {
                return new TextType((Text)node);
            }
            case 9: {
                return new DocType((Document)node);
            }
            case 7: {
                return new PIType((ProcessingInstruction)node);
            }
        }
        assert (false);
        return null;
    }

    public static ResultSequence linearize(ResultSequence rs) {
        TreeSet all = new TreeSet(NODE_COMPARATOR);
        ResultSequenceUtil.copyToCollection(rs.iterator(), all);
        return ResultSequenceUtil.resultSequenceFromCollection(all);
    }

    public static boolean same(NodeType a, NodeType b) {
        return a.node_value().isSameNode(b.node_value());
    }

    public boolean before(NodeType two) {
        return NodeType.before(this, two);
    }

    public static boolean before(NodeType a, NodeType b) {
        return NodeType.compare_node(a, b) < 0;
    }

    public boolean after(NodeType two) {
        return NodeType.after(this, two);
    }

    public static boolean after(NodeType a, NodeType b) {
        return NodeType.compare_node(a, b) > 0;
    }

    private static int compare_node(NodeType a, NodeType b) {
        Document docB;
        Node nodeB;
        Node nodeA = a.node_value();
        if (nodeA == (nodeB = b.node_value()) || nodeA.isSameNode(nodeB)) {
            return 0;
        }
        Document docA = NodeType.getDocument(nodeA);
        if (docA != (docB = NodeType.getDocument(nodeB))) {
            return NodeType.compareDocuments(docA, docB);
        }
        short relation = nodeA.compareDocumentPosition(nodeB);
        if ((relation & 2) != 0) {
            return 1;
        }
        if ((relation & 4) != 0) {
            return -1;
        }
        throw new RuntimeException("Unexpected result from node comparison: " + relation);
    }

    private static int compareDocuments(Document docA, Document docB) {
        int difference;
        if (docA.isSameNode(docB)) {
            return 0;
        }
        if (docA.getDocumentURI() != null && docB.getDocumentURI() != null && (difference = docB.getDocumentURI().compareTo(docA.getDocumentURI())) != 0) {
            return difference;
        }
        return docA.hashCode() - docB.hashCode();
    }

    private static Document getDocument(Node nodeA) {
        return nodeA instanceof Document ? (Document)nodeA : nodeA.getOwnerDocument();
    }

    protected AnyType getTypedValueForPrimitiveType(XSTypeDefinition typeDef) {
        String strValue = this.string_value();
        if (typeDef == null) {
            return new XSUntypedAtomic(strValue);
        }
        return SchemaTypeValueFactory.newSchemaTypeValue(XPath20TypeHelper.getXSDTypeShortCode(typeDef), strValue);
    }

    protected ResultSequence getXDMTypedValue(XSTypeDefinition typeDef, ShortList itemValTypes) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if ("anyType".equals(typeDef.getName()) || "anySimpleType".equals(typeDef.getName()) || "anyAtomicType".equals(typeDef.getName())) {
            rs.add(new XSUntypedAtomic(this.string_value()));
        } else {
            XSSimpleTypeDefinition simpType = null;
            ResultSequence rsSimpleContent = null;
            if (typeDef instanceof XSComplexTypeDefinition) {
                XSComplexTypeDefinition complexTypeDefinition = (XSComplexTypeDefinition)typeDef;
                simpType = complexTypeDefinition.getSimpleType();
                if (simpType != null) {
                    rsSimpleContent = this.getTypedValueForSimpleContent(simpType, itemValTypes);
                } else {
                    rs.add(new XSUntypedAtomic(this.string_value()));
                }
            } else {
                simpType = (XSSimpleTypeDefinition)typeDef;
                rsSimpleContent = this.getTypedValueForSimpleContent(simpType, itemValTypes);
            }
            if (rsSimpleContent != null) {
                rs = rsSimpleContent;
            }
        }
        return rs;
    }

    private ResultSequence getTypedValueForSimpleContent(XSSimpleTypeDefinition simpType, ShortList itemValueTypes) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (simpType.getVariety() == 1) {
            AnyType schemaTypeValue = SchemaTypeValueFactory.newSchemaTypeValue(XPath20TypeHelper.getXSDTypeShortCode((XSTypeDefinition)simpType), this.string_value());
            if (schemaTypeValue != null) {
                rs.add(schemaTypeValue);
            } else {
                rs.add(new XSUntypedAtomic(this.string_value()));
            }
        } else if (simpType.getVariety() == 2) {
            this.addAtomicListItemsToResultSet(simpType, itemValueTypes, rs);
        } else if (simpType.getVariety() == 3) {
            this.getTypedValueForVarietyUnion(simpType, itemValueTypes, rs);
        }
        return rs;
    }

    private void addAtomicListItemsToResultSet(XSSimpleTypeDefinition simpType, ShortList itemValueTypes, ResultSequence rs) {
        block3: {
            XSSimpleTypeDefinition itemType;
            String[] listItemsStrValues;
            block2: {
                listItemsStrValues = this.string_value().split("\\s+");
                itemType = simpType.getItemType();
                if (itemType.getVariety() != 1) break block2;
                int listItemIdx = 0;
                while (listItemIdx < listItemsStrValues.length) {
                    rs.add(SchemaTypeValueFactory.newSchemaTypeValue(XPath20TypeHelper.getXSDTypeShortCode((XSTypeDefinition)itemType), listItemsStrValues[listItemIdx]));
                    ++listItemIdx;
                }
                break block3;
            }
            if (itemType.getVariety() != 3) break block3;
            int listItemIdx = 0;
            while (listItemIdx < listItemsStrValues.length) {
                String listItem = listItemsStrValues[listItemIdx];
                rs.add(SchemaTypeValueFactory.newSchemaTypeValue(itemValueTypes.item(listItemIdx), listItem));
                ++listItemIdx;
            }
        }
    }

    private void getTypedValueForVarietyUnion(XSSimpleTypeDefinition simpType, ShortList itemValueTypes, ResultSequence rs) {
        XSObjectList memberTypes = simpType.getMemberTypes();
        int memTypeIdx = 0;
        while (memTypeIdx < memberTypes.getLength()) {
            XSSimpleType memSimpleType = (XSSimpleType)memberTypes.item(memTypeIdx);
            if (XPath20TypeHelper.isValueValidForSimpleType(this.string_value(), memSimpleType)) {
                if (memSimpleType.getVariety() == 2) {
                    this.addAtomicListItemsToResultSet((XSSimpleTypeDefinition)memSimpleType, itemValueTypes, rs);
                    break;
                }
                if (memSimpleType.getVariety() == 3) {
                    this.getTypedValueForVarietyUnion((XSSimpleTypeDefinition)memSimpleType, itemValueTypes, rs);
                    break;
                }
                rs.add(SchemaTypeValueFactory.newSchemaTypeValue(XPath20TypeHelper.getXSDTypeShortCode((XSTypeDefinition)memSimpleType), this.string_value()));
                break;
            }
            ++memTypeIdx;
        }
    }

    public abstract boolean isID();

    public abstract boolean isIDREF();

    protected boolean isType(TypeInfo typeInfo, String typeName) {
        String typeInfoName;
        return typeInfo != null && (typeInfoName = typeInfo.getTypeName()) != null && typeInfo.getTypeName().equalsIgnoreCase(typeName);
    }

    public boolean equals(Object obj) {
        return obj instanceof NodeType && NodeType.same(this, (NodeType)obj);
    }

    public int hashCode() {
        return this._node.hashCode();
    }
}

