/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.substitute;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.substitute.AttributeValue;
import org.apache.fop.fonts.substitute.FontWeightRange;

public class FontQualifier {
    private static Log log = LogFactory.getLog(FontQualifier.class);
    private AttributeValue fontFamilyAttributeValue;
    private AttributeValue fontStyleAttributeValue;
    private AttributeValue fontWeightAttributeValue;

    public void setFontFamily(String fontFamily) {
        AttributeValue fontFamilyAttribute = AttributeValue.valueOf(fontFamily);
        if (fontFamilyAttribute == null) {
            log.error("Invalid font-family value '" + fontFamily + "'");
            return;
        }
        this.fontFamilyAttributeValue = fontFamilyAttribute;
    }

    public void setFontStyle(String fontStyle) {
        AttributeValue fontStyleAttribute = AttributeValue.valueOf(fontStyle);
        if (fontStyleAttribute != null) {
            this.fontStyleAttributeValue = fontStyleAttribute;
        }
    }

    public void setFontWeight(String fontWeight) {
        AttributeValue fontWeightAttribute = AttributeValue.valueOf(fontWeight);
        if (fontWeightAttribute != null) {
            for (Object weightObj : fontWeightAttribute) {
                if (!(weightObj instanceof String)) continue;
                String weightString = ((String)weightObj).trim();
                try {
                    FontUtil.parseCSS2FontWeight(weightString);
                }
                catch (IllegalArgumentException ex) {
                    log.error("Invalid font-weight value '" + weightString + "'");
                    return;
                }
            }
            this.fontWeightAttributeValue = fontWeightAttribute;
        }
    }

    public AttributeValue getFontFamily() {
        return this.fontFamilyAttributeValue;
    }

    public AttributeValue getFontStyle() {
        if (this.fontStyleAttributeValue == null) {
            return AttributeValue.valueOf("normal");
        }
        return this.fontStyleAttributeValue;
    }

    public AttributeValue getFontWeight() {
        if (this.fontWeightAttributeValue == null) {
            return AttributeValue.valueOf(Integer.toString(400));
        }
        return this.fontWeightAttributeValue;
    }

    public boolean hasFontWeight() {
        return this.fontWeightAttributeValue != null;
    }

    public boolean hasFontStyle() {
        return this.fontStyleAttributeValue != null;
    }

    protected List<FontTriplet> match(FontInfo fontInfo) {
        AttributeValue fontFamilyValue = this.getFontFamily();
        AttributeValue weightValue = this.getFontWeight();
        AttributeValue styleValue = this.getFontStyle();
        ArrayList<FontTriplet> matchingTriplets = new ArrayList<FontTriplet>();
        for (Object aFontFamilyValue : fontFamilyValue) {
            String fontFamilyString = (String)aFontFamilyValue;
            Map<FontTriplet, String> triplets = fontInfo.getFontTriplets();
            if (triplets == null) continue;
            Set<FontTriplet> tripletSet = triplets.keySet();
            Iterator<FontTriplet> iterator = tripletSet.iterator();
            while (iterator.hasNext()) {
                FontTriplet aTripletSet;
                FontTriplet triplet = aTripletSet = iterator.next();
                String fontName = triplet.getName();
                if (!fontFamilyString.toLowerCase().equals(fontName.toLowerCase())) continue;
                boolean weightMatched = false;
                int fontWeight = triplet.getWeight();
                for (Object weightObj : weightValue) {
                    Integer fontWeightInteger;
                    int fontWeightValue;
                    if (weightObj instanceof FontWeightRange) {
                        FontWeightRange intRange = (FontWeightRange)weightObj;
                        if (!intRange.isWithinRange(fontWeight)) continue;
                        weightMatched = true;
                        continue;
                    }
                    if (weightObj instanceof String) {
                        String fontWeightString = (String)weightObj;
                        fontWeightValue = FontUtil.parseCSS2FontWeight(fontWeightString);
                        if (fontWeightValue != fontWeight) continue;
                        weightMatched = true;
                        continue;
                    }
                    if (!(weightObj instanceof Integer) || (fontWeightValue = (fontWeightInteger = (Integer)weightObj).intValue()) != fontWeight) continue;
                    weightMatched = true;
                }
                boolean styleMatched = false;
                String fontStyleString = triplet.getStyle();
                for (Object aStyleValue : styleValue) {
                    String style = (String)aStyleValue;
                    if (!fontStyleString.equals(style)) continue;
                    styleMatched = true;
                }
                if (!weightMatched || !styleMatched) continue;
                matchingTriplets.add(triplet);
            }
        }
        return matchingTriplets;
    }

    protected FontTriplet bestMatch(FontInfo fontInfo) {
        List<FontTriplet> matchingTriplets = this.match(fontInfo);
        FontTriplet bestTriplet = null;
        if (matchingTriplets.size() == 1) {
            bestTriplet = matchingTriplets.get(0);
        } else {
            Iterator<FontTriplet> iterator = matchingTriplets.iterator();
            while (iterator.hasNext()) {
                FontTriplet matchingTriplet;
                FontTriplet triplet = matchingTriplet = iterator.next();
                if (bestTriplet == null) {
                    bestTriplet = triplet;
                    continue;
                }
                int priority = triplet.getPriority();
                if (priority >= bestTriplet.getPriority()) continue;
                bestTriplet = triplet;
            }
        }
        return bestTriplet;
    }

    public List<FontTriplet> getTriplets() {
        ArrayList<FontTriplet> triplets = new ArrayList<FontTriplet>();
        AttributeValue fontFamilyValue = this.getFontFamily();
        for (Object aFontFamilyValue : fontFamilyValue) {
            String name = (String)aFontFamilyValue;
            AttributeValue styleValue = this.getFontStyle();
            for (Object aStyleValue : styleValue) {
                String style = (String)aStyleValue;
                AttributeValue weightValue = this.getFontWeight();
                for (Object weightObj : weightValue) {
                    if (weightObj instanceof FontWeightRange) {
                        int[] weightRange;
                        FontWeightRange fontWeightRange = (FontWeightRange)weightObj;
                        for (int aWeightRange : weightRange = fontWeightRange.toArray()) {
                            triplets.add(new FontTriplet(name, style, aWeightRange));
                        }
                        continue;
                    }
                    if (weightObj instanceof String) {
                        String weightString = (String)weightObj;
                        int weight = FontUtil.parseCSS2FontWeight(weightString);
                        triplets.add(new FontTriplet(name, style, weight));
                        continue;
                    }
                    if (!(weightObj instanceof Integer)) continue;
                    Integer weightInteger = (Integer)weightObj;
                    int weight = weightInteger;
                    triplets.add(new FontTriplet(name, style, weight));
                }
            }
        }
        return triplets;
    }

    public String toString() {
        String str = "";
        if (this.fontFamilyAttributeValue != null) {
            str = str + "font-family=" + this.fontFamilyAttributeValue;
        }
        if (this.fontStyleAttributeValue != null) {
            if (str.length() > 0) {
                str = str + ", ";
            }
            str = str + "font-style=" + this.fontStyleAttributeValue;
        }
        if (this.fontWeightAttributeValue != null) {
            if (str.length() > 0) {
                str = str + ", ";
            }
            str = str + "font-weight=" + this.fontWeightAttributeValue;
        }
        return str;
    }
}

