/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.ext.awt.geom.AbstractSegment;
import org.apache.batik.ext.awt.geom.Segment;

public class Cubic
extends AbstractSegment {
    public Point2D.Double p1;
    public Point2D.Double p2;
    public Point2D.Double p3;
    public Point2D.Double p4;
    private static int count = 0;

    public Cubic() {
        this.p1 = new Point2D.Double();
        this.p2 = new Point2D.Double();
        this.p3 = new Point2D.Double();
        this.p4 = new Point2D.Double();
    }

    public Cubic(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.p1 = new Point2D.Double(d, d2);
        this.p2 = new Point2D.Double(d3, d4);
        this.p3 = new Point2D.Double(d5, d6);
        this.p4 = new Point2D.Double(d7, d8);
    }

    public Cubic(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3, Point2D.Double double_4) {
        this.p1 = double_;
        this.p2 = double_2;
        this.p3 = double_3;
        this.p4 = double_4;
    }

    public Object clone() {
        return new Cubic(new Point2D.Double(this.p1.x, this.p1.y), new Point2D.Double(this.p2.x, this.p2.y), new Point2D.Double(this.p3.x, this.p3.y), new Point2D.Double(this.p4.x, this.p4.y));
    }

    public Segment reverse() {
        return new Cubic(new Point2D.Double(this.p4.x, this.p4.y), new Point2D.Double(this.p3.x, this.p3.y), new Point2D.Double(this.p2.x, this.p2.y), new Point2D.Double(this.p1.x, this.p1.y));
    }

    private void getMinMax(double d, double d2, double d3, double d4, double[] dArray) {
        if (d4 > d) {
            dArray[0] = d;
            dArray[1] = d4;
        } else {
            dArray[0] = d4;
            dArray[1] = d;
        }
        double d5 = 3.0 * (d2 - d);
        double d6 = 6.0 * (d3 - d2);
        double d7 = 3.0 * (d4 - d3);
        double[] dArray2 = new double[]{d5, d6 - 2.0 * d5, d7 - d6 + d5};
        int n = QuadCurve2D.solveQuadratic(dArray2);
        for (int i = 0; i < n; ++i) {
            double d8 = dArray2[i];
            if (d8 <= 0.0 || d8 >= 1.0) continue;
            if ((d8 = (1.0 - d8) * (1.0 - d8) * (1.0 - d8) * d + 3.0 * d8 * (1.0 - d8) * (1.0 - d8) * d2 + 3.0 * d8 * d8 * (1.0 - d8) * d3 + d8 * d8 * d8 * d4) < dArray[0]) {
                dArray[0] = d8;
                continue;
            }
            if (!(d8 > dArray[1])) continue;
            dArray[1] = d8;
        }
    }

    public double minX() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.x, this.p2.x, this.p3.x, this.p4.x, dArray);
        return dArray[0];
    }

    public double maxX() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.x, this.p2.x, this.p3.x, this.p4.x, dArray);
        return dArray[1];
    }

    public double minY() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.y, this.p2.y, this.p3.y, this.p4.y, dArray);
        return dArray[0];
    }

    public double maxY() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.y, this.p2.y, this.p3.y, this.p4.y, dArray);
        return dArray[1];
    }

    public Rectangle2D getBounds2D() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.x, this.p2.x, this.p3.x, this.p4.x, dArray);
        double[] dArray2 = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.y, this.p2.y, this.p3.y, this.p4.y, dArray2);
        return new Rectangle2D.Double(dArray[0], dArray2[0], dArray[1] - dArray[0], dArray2[1] - dArray2[0]);
    }

    protected int findRoots(double d, double[] dArray) {
        double[] dArray2 = new double[]{this.p1.y - d, 3.0 * (this.p2.y - this.p1.y), 3.0 * (this.p1.y - 2.0 * this.p2.y + this.p3.y), 3.0 * this.p2.y - this.p1.y + this.p4.y - 3.0 * this.p3.y};
        return CubicCurve2D.solveCubic(dArray2, dArray);
    }

    public Point2D.Double evalDt(double d) {
        double d2 = 3.0 * ((this.p2.x - this.p1.x) * (1.0 - d) * (1.0 - d) + 2.0 * (this.p3.x - this.p2.x) * (1.0 - d) * d + (this.p4.x - this.p3.x) * d * d);
        double d3 = 3.0 * ((this.p2.y - this.p1.y) * (1.0 - d) * (1.0 - d) + 2.0 * (this.p3.y - this.p2.y) * (1.0 - d) * d + (this.p4.y - this.p3.y) * d * d);
        return new Point2D.Double(d2, d3);
    }

    public Point2D.Double eval(double d) {
        double d2 = (1.0 - d) * (1.0 - d) * (1.0 - d) * this.p1.x + 3.0 * (d * (1.0 - d) * (1.0 - d) * this.p2.x + d * d * (1.0 - d) * this.p3.x) + d * d * d * this.p4.x;
        double d3 = (1.0 - d) * (1.0 - d) * (1.0 - d) * this.p1.y + 3.0 * (d * (1.0 - d) * (1.0 - d) * this.p2.y + d * d * (1.0 - d) * this.p3.y) + d * d * d * this.p4.y;
        return new Point2D.Double(d2, d3);
    }

    public void subdivide(Segment segment, Segment segment2) {
        Cubic cubic = null;
        Cubic cubic2 = null;
        if (segment instanceof Cubic) {
            cubic = (Cubic)segment;
        }
        if (segment2 instanceof Cubic) {
            cubic2 = (Cubic)segment2;
        }
        this.subdivide(cubic, cubic2);
    }

    public void subdivide(double d, Segment segment, Segment segment2) {
        Cubic cubic = null;
        Cubic cubic2 = null;
        if (segment instanceof Cubic) {
            cubic = (Cubic)segment;
        }
        if (segment2 instanceof Cubic) {
            cubic2 = (Cubic)segment2;
        }
        this.subdivide(d, cubic, cubic2);
    }

    public void subdivide(Cubic cubic, Cubic cubic2) {
        if (cubic == null && cubic2 == null) {
            return;
        }
        double d = (this.p1.x + 3.0 * (this.p2.x + this.p3.x) + this.p4.x) * 0.125;
        double d2 = (this.p1.y + 3.0 * (this.p2.y + this.p3.y) + this.p4.y) * 0.125;
        double d3 = (this.p2.x - this.p1.x + 2.0 * (this.p3.x - this.p2.x) + (this.p4.x - this.p3.x)) * 0.125;
        double d4 = (this.p2.y - this.p1.y + 2.0 * (this.p3.y - this.p2.y) + (this.p4.y - this.p3.y)) * 0.125;
        if (cubic != null) {
            cubic.p1.x = this.p1.x;
            cubic.p1.y = this.p1.y;
            cubic.p2.x = (this.p2.x + this.p1.x) * 0.5;
            cubic.p2.y = (this.p2.y + this.p1.y) * 0.5;
            cubic.p3.x = d - d3;
            cubic.p3.y = d2 - d4;
            cubic.p4.x = d;
            cubic.p4.y = d2;
        }
        if (cubic2 != null) {
            cubic2.p1.x = d;
            cubic2.p1.y = d2;
            cubic2.p2.x = d + d3;
            cubic2.p2.y = d2 + d4;
            cubic2.p3.x = (this.p4.x + this.p3.x) * 0.5;
            cubic2.p3.y = (this.p4.y + this.p3.y) * 0.5;
            cubic2.p4.x = this.p4.x;
            cubic2.p4.y = this.p4.y;
        }
    }

    public void subdivide(double d, Cubic cubic, Cubic cubic2) {
        if (cubic == null && cubic2 == null) {
            return;
        }
        Point2D.Double double_ = this.eval(d);
        Point2D.Double double_2 = this.evalDt(d);
        if (cubic != null) {
            cubic.p1.x = this.p1.x;
            cubic.p1.y = this.p1.y;
            cubic.p2.x = (this.p2.x + this.p1.x) * d;
            cubic.p2.y = (this.p2.y + this.p1.y) * d;
            cubic.p3.x = double_.x - double_2.x * d / 3.0;
            cubic.p3.y = double_.y - double_2.y * d / 3.0;
            cubic.p4.x = double_.x;
            cubic.p4.y = double_.y;
        }
        if (cubic2 != null) {
            cubic2.p1.x = double_.x;
            cubic2.p1.y = double_.y;
            cubic2.p2.x = double_.x + double_2.x * (1.0 - d) / 3.0;
            cubic2.p2.y = double_.y + double_2.y * (1.0 - d) / 3.0;
            cubic2.p3.x = (this.p4.x + this.p3.x) * (1.0 - d);
            cubic2.p3.y = (this.p4.y + this.p3.y) * (1.0 - d);
            cubic2.p4.x = this.p4.x;
            cubic2.p4.y = this.p4.y;
        }
    }

    public Segment getSegment(double d, double d2) {
        double d3 = d2 - d;
        Point2D.Double double_ = this.eval(d);
        Point2D.Double double_2 = this.evalDt(d);
        Point2D.Double double_3 = new Point2D.Double(double_.x + d3 * double_2.x / 3.0, double_.y + d3 * double_2.y / 3.0);
        Point2D.Double double_4 = this.eval(d2);
        Point2D.Double double_5 = this.evalDt(d2);
        Point2D.Double double_6 = new Point2D.Double(double_4.x - d3 * double_5.x / 3.0, double_4.y - d3 * double_5.y / 3.0);
        return new Cubic(double_, double_3, double_6, double_4);
    }

    protected double subLength(double d, double d2, double d3) {
        ++count;
        double d4 = this.p3.x - this.p2.x;
        double d5 = this.p3.y - this.p2.y;
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = this.p4.x - this.p1.x;
        double d8 = this.p4.y - this.p1.y;
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        double d10 = d + d2 + d6;
        if (d10 < d3) {
            return (d10 + d9) / 2.0;
        }
        double d11 = d10 - d9;
        if (d11 < d3) {
            return (d10 + d9) / 2.0;
        }
        Cubic cubic = new Cubic();
        double d12 = (this.p1.x + 3.0 * (this.p2.x + this.p3.x) + this.p4.x) * 0.125;
        double d13 = (this.p1.y + 3.0 * (this.p2.y + this.p3.y) + this.p4.y) * 0.125;
        double d14 = (d4 + d7) * 0.125;
        double d15 = (d5 + d8) * 0.125;
        cubic.p1.x = this.p1.x;
        cubic.p1.y = this.p1.y;
        cubic.p2.x = (this.p2.x + this.p1.x) * 0.5;
        cubic.p2.y = (this.p2.y + this.p1.y) * 0.5;
        cubic.p3.x = d12 - d14;
        cubic.p3.y = d13 - d15;
        cubic.p4.x = d12;
        cubic.p4.y = d13;
        double d16 = Math.sqrt(d14 * d14 + d15 * d15);
        double d17 = cubic.subLength(d / 2.0, d16, d3 / 2.0);
        cubic.p1.x = d12;
        cubic.p1.y = d13;
        cubic.p2.x = d12 + d14;
        cubic.p2.y = d13 + d15;
        cubic.p3.x = (this.p4.x + this.p3.x) * 0.5;
        cubic.p3.y = (this.p4.y + this.p3.y) * 0.5;
        cubic.p4.x = this.p4.x;
        cubic.p4.y = this.p4.y;
        return d17 += cubic.subLength(d16, d2 / 2.0, d3 / 2.0);
    }

    public double getLength() {
        return this.getLength(1.0E-6);
    }

    public double getLength(double d) {
        double d2 = this.p2.x - this.p1.x;
        double d3 = this.p2.y - this.p1.y;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        d2 = this.p4.x - this.p3.x;
        d3 = this.p4.y - this.p3.y;
        double d5 = Math.sqrt(d2 * d2 + d3 * d3);
        d2 = this.p3.x - this.p2.x;
        d3 = this.p3.y - this.p2.y;
        double d6 = Math.sqrt(d2 * d2 + d3 * d3);
        double d7 = d * (d4 + d5 + d6);
        return this.subLength(d4, d5, d7);
    }

    public String toString() {
        return "M" + this.p1.x + "," + this.p1.y + "C" + this.p2.x + "," + this.p2.y + " " + this.p3.x + "," + this.p3.y + " " + this.p4.x + "," + this.p4.y;
    }
}

