#!/usr/bin/tclsh

load /usr/local/pgsql/lib/libpgtcl.so

if {[llength $argv]<2} {

	puts "Usage: client.tcl requests_number port \[sql_sentence\]"
	exit

}

set port [lindex $argv 1]
set times [lindex $argv 0]
if {[llength $argv]==3} {
	set sql [lindex $argv 2]
} else {
	set sql "insert into tb_three values ('Shelovesyou','Yeayeayea')"
}
 
set hora_inicio [clock seconds]

set cont $times
while {$cont>0} {

    set conn [pg_connect -conninfo "user=daniel password=daniel dbname=dbbalancer host=localhost port=$port"]
    
    puts "$port --> $cont "
    set result [pg_exec $conn $sql]
    puts "OID: [pg_result $result -oid]"	
    #after 2000

    pg_disconnect $conn
    incr cont -1

}

set hora_fin [clock seconds]
set dif [expr $hora_fin - $hora_inicio]

puts "\nResults:"
puts "$times iterations"
puts "$dif seconds"
puts "[expr $times.0 / $dif] requests/second."
puts "FIN!"
