#include <sys/time.h>
#include <iostream>
#include <libpq++.h>


int main(int argc, char* argv[]) {

  ExecStatusType status;
  char conninfo[256];
  string query;
  long n;
  long it;
  struct timeval inicio,fin;
  struct timezone tz;
  double segs_inicio,segs_fin,segundos;

  if (argc<3) {

    cout << "Usage: pgtest niterations port [query]" << endl;
    return -1;

  }
  
  if (argc==4) {

    query = argv[3];

  } else {

    query = "SELECT * FROM TB_ONE a, TB_TWO b WHERE a.FIELD2=b.FIELD2";
		   
  }

  sprintf(conninfo,"user=postgres password=postgres host=localhost dbname=dbbalancer port=%s",argv[2]);
  n=atoi(argv[1]);
  it=1;

  cout << endl << endl;

  cout << "Iterations      : " << n << endl;
  cout << "Server Port     : " << argv[2] << endl;
  cout << "Query           : " << query << endl;

  cout << endl << endl;
  

  tz.tz_minuteswest = 0;
  tz.tz_dsttime = 0;

  gettimeofday(&inicio, &tz);
  while (it<=n) {

    PgDatabase *db;

    printf("\r%s -> request %ld",argv[2],it);
    fflush(stdout);

    db = new PgDatabase(conninfo);

    if (db->ConnectionBad()) {

      cerr << "Problem with the connection: " << db->ErrorMessage() << endl;
      return 1;

    }

    int nfields,ntuples;
    const char * campo;

    switch (status = db->Exec(query.c_str())) {

    case PGRES_TUPLES_OK:

      nfields = db->Fields();
      ntuples = db->Tuples();
      
      for (int i=0; i<ntuples; i++) {

	for (int j=0; j<nfields; j++) {

	  campo=db->GetValue(i,j);

	}


      }

      //db->DisplayTuples();
      break;

    case PGRES_COMMAND_OK:
      
      break;

    default:
      
      cerr << "Error executing query (" << query << "). " 
	   << "status = " << (int)status << endl
	   << "Error returned: " << (int)db->ErrorMessage() << endl;
    }
    
    it++;
    delete db;

  }
  gettimeofday(&fin, &tz);
  segs_inicio = inicio.tv_sec + inicio.tv_usec / 1000000;
  segs_fin = fin.tv_sec + fin.tv_usec / 1000000;

  segundos = segs_fin - segs_inicio;

  cout << endl;
  cout << "------------------------------------------" << endl;
  cout << " Executed " << n << " requests. " << endl;
  cout << " In " << segundos << " seconds. " << endl;
  cout << "------------------------------------------" << endl;
  cout << " Results: " << (n/segundos) <<  " requests/second. " << endl << endl;

  return 0;

}
