package com.actelion.research.chem.ugly;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;

import java.util.ArrayList;

public class PainsDetector {
	private static final String[][] PAINS = {
			{ "gJYADEJRkLAmiczFOxap !B_vq?Dw}l_qL", "acyl_het_A(9)" },
			{ "flmp@@@X]dbbbTRTVrMARMktT`@@@D@@@@P !B?g~H@k_}bGvH__x@?g~H@oy?bOrH?Ha}m?vH__x@?g?~_{_}", "amino_acridine_A(1)" },
			{ "foQP@@@FRfYeUz\\e[S`@@@`@@B !BbOs~_xa}?`BH_[_}?g~H?Hc|?g?~_xc}?`Bw?P", "amino_acridine_A(46)" },
			{ "dcoH@DqPRYUUrhYZh@h@C{dcHZNbXVMriPIAXHa@ !B@OxlFBqgXFU`Fh`BbOvH_X`Bb@JH?P", "anil_NH_alk_A(5)" },
			{ "foAP@@@VRfYU_qZTZ`@@B`@CZAoXAEh]@ !BbGvw_Xc|?g?~_{\\BbGvH_[_}m?w~_{\\BbGvH@`", "anil_NH_alk_B(3)" },
			{ "deU@@@iJ[e^f```@OaBD`hjFchFI` !BbGvw_Xc|?g?~@Ha}bGvw@oy?", "anil_NH_alk_C(2)" },
			{ "dcM@@@{IEEEDcNtEPPPe@_BDIEQvCDpn[@ !BbOvw?Xc|?g~w@oy??`BH_Xa}m?w~_p", "anil_NH_alk_D(2)" },
			{ "deW@@@pTieUk``bP@~iHrBchG@ !B?g~w@hc}m?vw_X`BmpJw?Hc}", "anil_NH_no_alk_A(1)" },
			{ "dg_DPL{XP@`yCIHUEEdeJkPPEP@]P[ylah{AcXoHpYRDQbU` !B?`BH_[]}mpJw__x@?g~w@k_|?`C~@K\\Bm?p", "anil_NH_no_alk_B(1)" },
			{ "fhy``@C@\\eLrjkob`mJmP@@DUP@A}HdLcdRaTFbt^pN@ !Bf\\B@LX`BmpKRtBqg?`C~@HAN`Dzw@k\\BKF_~@K]}m?p", "anil_OC_alk_A(4)" },
			{ "fnsQb@DL@jiiAIfYeU{wvgGQrUjiAh@@J`@CjAgrFPwHpLTaDXeX !Bim|kn}CMotxBmx`BL[}SY|wPs\\~H?XPkotz?Soy?bOsMtHa}bGvH@ha}?g|", "anil_OC_alk_B(3)" },
			{ "dgH@BWPRYe_eXSnBBIjD@~xHrBbhZNpX@ !Bmww~_{\\BbOvw?[]}b@Jw@hc}tMINouR{pId", "anil_OC_alk_C(3)" },
			{ "foAq@@JZLAJ[e_eyJsjBBIjD@OnHpdTad\\`VR` !Bmww~@Oy?mpJH?[_}mwvH@k\\BbOwPtdz?UKo@fP", "anil_OC_alk_C(3)" },
			{ "fdya@@J@RfyWVy^RCF``b`H@@CxRLIEHYGHEfl}` !Bmww~@Oy?mpJH?[_}mwvH@k\\BbOvw?Xc|?g~H__x@bGw~_p", "anil_OC_alk_D(2)" },
			{ "fle``@J@\\eMrnmroIASPPQPPP@@_BQaHiCHy@lud\\@ !Bmww~@Oy?mpJH?[_}mwvH@k\\BbOvw?Xc|?g?~@Ha}bGvw?Oy?", "anil_OC_alk_D(2)" },
			{ "dknD@JCTinU~zZBBJbEHCyTphjFchGIaXvCp !BbOs~_?x@bGvw@hc|b@Jw?Xa}mpK~@K_}", "anil_OC_alk_E(1)" },
			{ "dknD`DhPBDfUnUTziBBBHhC{haHzIaXwC` !B?`BH@k\\BbOvw?_y?bOrw?Xa}bGw~_x`B", "anil_OC_alk_F(1)" },
			{ "dg}H@LlDifUWquSh@@@`@ObJN`Xo@ !Bm?vH?_y?m?rH?Oy?mwvw?Xa}bGvw@oy?m?t", "anil_OC_no_alk_A(8)" },
			{ "fdea@@@`RfYVWgqFu[tZ@@@@H@@CzfHIGHE@X@ !BbGvw_Xc|?g?~_{_|bGvH_[]}bOvw__y?m?s~_?y?bGvH?P", "anil_OC_no_alk_B(4)" },
			{ "dmuH@FxDieeQV`bD@CyDsl@ !BbOvw?_y?bOrw@ha}m?vH_[_}b@H", "anil_OC_no_alk_C(3)" },
			{ "foAa@@N@RYWUeZLlz@Bh@@@C{`HQFHIEHy@l@ !BmpK~@K_}mpJw@k_}mpJw?[\\Bm?w~@K\\BmpK~@@", "anil_OH_alk_A(8)" },
			{ "dcNB`MaLd@cIIKDeBJkPAD@GvYDqn@ !B_[\\BbHa}mpJw__x@mpJw@k_}?`Bw@`", "anil_OH_no_alk_A(1)" },
			{ "dg~D@ABdef^]^d{XHH@@@OnJJ`\\VM`xn@ !BmpJw?_y?m?rH?[]}m?w~_{\\BmpJw_[]}m?p", "anil_OH_no_alk_B(1)" },
			{ "f`qq@@JZ\\AJ]VUmuFlzfh@ah`@~DcBYRNPJEQZOP !BbGvw_X`BbGvH@ha}bOs~_xa}bGu`Foy?KF]`YQh_", "anil_alk_A(1)" },
			{ "fdya@@E@RfuuVUv\\|F`@j`@`@CzrLqAHiCHEdlUAhmCh}D\\@ !BmpJH@ox@m?vw@k\\Bm?vw@k_}mpJw?_y?mpJw?[_}mpJw?P", "anil_alk_B(1)" },
			{ "fdya@@I@rQSIYRHqILxFM@AUP@@@GsDYbBQRFQJ@ !BmpJH@ox@mwvw@k\\Bm?vw@k]}_X`BbK\\Bmww~@K_|m?s~@@", "anil_alk_C(1)" },
			{ "do}@@@kIHbeDeeEvjh@J`@~NLSLpljN`XfE`xoGp !Bb@Jw@oy?bGvH@ha}bOs~_xa}bGw~_xa}b@K~_p", "anil_alk_D(1)" },
			{ "fdep@@@TUdbbRRQRbRqSd`qdHHj@B@@OfH`dLbTJcV@ !BXAiSFOx@bOtlFH`Bb@IeXHa}bGvH@ha}bOs~_xa}bGw~_p", "anil_alk_bim(9)" },
			{ "dk~@@@RfVU^nE]N`bHjD@` !B?`Bw?[\\BbOrw@ox@mww~@A}ebOp_FeLX", "anil_alk_ene(51)" },
			{ "fhe`@@@ISLkKnxXHtmNCPT@PDQ@@]p|p !BaBoRtH`B?g~YpH@qbGvH_X`BmpKRtOy??`C~@Ha}mpH", "anil_alk_indane(1)" },
			{ "f`i`A@A@BHAFRIQKRJUKAAZ]zjZj@A`@MhT@ !BOrYN_?uwK|tH?S}YYQ}eGq|ZVT@?VUQ{YQ}eGuQ{", "anil_alk_thio(4)" },
			{ "deU@@@gIHhTmpu@A@A|RYfMGP !BbOvw?_x@bOs~_xa}bGw~_xa}", "anil_di_alk_A(478)" },
			{ "dmu@@@WIHhTinFh@J@CxdsLzIp !BbOvw?_x@bOs~_xa}bGw~_xc|bGt", "anil_di_alk_A(478)" },
			{ "dkmH@FTLdTRbJtFZB`J`@~iLkNc\\O@ !BbOvw?_y?bOrw@k_}bGvH_Xc|bOs~@Hc}", "anil_di_alk_A(478)" },
			{ "dmv@@@rRJEKKaj@BP@{QGc@ !Bb@K~_{\\B?`BH?X`BbOrH_X`BbOt", "anil_di_alk_B(251)" },
			{ "deVH@AAJ[WVz`@h@OhFMhce` !BbOrw?Ox@bOvH?Hc|bOvH?Hc}", "anil_di_alk_C(246)" },
			{ "dmvH@AAJ[WYnh@J`@{qGKU` !Bb@Jw@ox@bOvH@hc|bGvH@ox@bOt", "anil_di_alk_C(246)" },
			{ "dmvH@AAIYWYnh@J`@~`HwdNVk@ !BmpJw?[\\B?g~w?[_}?g~w?_y?mpH", "anil_di_alk_D(198)" },
			{ "dcN@@@rRJEKI\\MP@T`A}FqoD^NV !BbOvw__x@b@K~_xa}bGw~_xa}b@JH_P", "anil_di_alk_D(198)" },
			{ "dkm@@@WIHhTleNFh@Jh@NzQxy^lv !BbOvw__x@b@K~_xa}bGw~_xa}b@K~@Ha}", "anil_di_alk_D(198)" },
			{ "deV@@@rRJEK\\MP@P@_\\fYAQTMGQN@ !BbOw~@K_}bOs~_xa}bGw~_xa}", "anil_di_alk_E(186)" },
			{ "dmv@@@rRJEJ[aj@B`@~yLrBbhzIq\\@ !BbOw~@K_}?g~H?Ha}bGvH@oy?bGt", "anil_di_alk_E(186)" },
			{ "dmv@@@rRJEKKaj@B`@~yLrBbhZNaX@ !BbGw~@K]}bOs~_xa}bGw~_xa}b@H", "anil_di_alk_E(186)" },
			{ "dcN@@@rRJEJ[\\MP@U@A}rYdEEQtSfp !BbOw~@K_}?g~H?Ha}bGvH@oy?bGvH@`", "anil_di_alk_E(186)" },
			{ "foAP@@@NRYWVUzLMZ@B`@`@Cy@M]nx\\X !Bb@JH__x@bOrH@ox@b@JH_Xc|?g~H_Xa}?g~H_P", "anil_di_alk_F(14)" },
			{ "f`qP@@@^Rfuue]gKNh@J@B@@Od@cv{PabX !BmpK~_?x@mwvw@k\\Bm?vw@k]}?g~w@k_}m?vw@k]}", "anil_di_alk_F(14)" },
			{ "fhiP@@@ArRJEKIQI[`g^j@B`@`@Cz@]waCpyL !BmpJH@oy??`Bw_[\\BmpJw?[\\Bmww~_{\\Bm?vw?[\\Bmwt", "anil_di_alk_F(14)" },
			{ "f`qP@@@^Rfuue]gKNh@J@B@@Od@cv{PabX !Bm?vH?[\\B?g~w?[_}?g~w?[\\Bmww~@K_|m?s~@K_|", "anil_di_alk_F(14)" },
			{ "fhiP@@@^Rfuue]Yrsj@B`@h@@~PBOQoBFIaX !BbOw~@Oy?b@JH?Xc}b@JH?X`B?`BH?X`BbOrH_X`BbOt", "anil_di_alk_F(14)" },
			{ "fdyP@@@ArRJEKIQIY\\D{uP@T@E@@Gt@qlbGar\\V !BbOvw__x@?g~H@hc}bOvH@hc}b@K~@Hc}b@JH?Ha}b@JH?P", "anil_di_alk_F(14)" },
			{ "fhiP@@@ArRJEKIQI[`g^j@B`@`@Cz@]waCpyL !Bm?w~@Hc}mpK~_{_}m?w~_{_}mpJw__x@m?rw?Ox@m?p", "anil_di_alk_F(14)" },
			{ "fdyP@@@ArRJEKIQIY\\D{uP@T@E@@Gt@qlbGar\\V !Bm?w~@Hc}mpK~_{_}m?w~_{_}mpJw__x@m?rw?Ox@m?s~@@", "anil_di_alk_F(14)" },
			{ "fleP@@@ArRJEKIQIYS`g^j@B`@j@@NzH^GIqZV !BbOvw__x@?g~H@hc}bOvH@hc}b@K~@Hc}b@JH?Ha}b@K~@Hc}", "anil_di_alk_F(14)" },
			{ "dg}@@@WIHhTlhepg]P@URTRPFt[xbbhZNblRKZH|X !BbGvw__x@bOs~_xa}bGw~_xa}Sk?PtlBYUKl", "anil_di_alk_G(9)" },
			{ "flePb@L^``@QddaTTRRVafgVBmP@@DT@@[PU{fHEDhm@Xcb\\@ !B_X`BbK]}bGvw@hc|?g?~@K]}bGvH_[_|mpK~_?x@m?vw@h`B", "anil_di_alk_H(6)" },
			{ "fdyQ@@DNAdTRbbRRtLUXwfh@@BJ@@OnHcdB`t^`NQp !B?g~w_Xa}mpJH?Oy??`Bw_Xa}bGvw?K\\B?g?~@K_}mpJH@`", "anil_di_alk_I(4)" },
			{ "f`ap@@@PleKKvnvcRuH@U@@_\\q@heBhuCl}` !BbGvw_X`BmpK~_xa}mww~_xc|bGvH_X`BbGvH@oy?", "anil_di_alk_J(3)" },
			{ "deU@@@gIHhTmpu@A@A}DymDnT !Bm?w~@Hc}mpK~_{_}m?w~_{_}", "anil_di_alk_K(2)" },
			{ "ffsP`@DF@IIfYUwnUrLuXJRuZhFBJB@b@@~ISIY{Dx !BaEPq`LBYtMJw?@JH?K^fpK_}@Ox@?k_|?K_OsSF@JxQeG}~fwyg_fVT_", "anil_di_alk_L(1)" },
			{ "fb}P@@@ZRfVW~YWhpRgASd@@HjB@B@@~lbBPrNPJIXjKYz@yFDqf@ !B?g~H?Hc}m?vH?Xc|?g?~_xc|m?vH?]CRSk}Tnqi`pIg@ilBfFf@", "anil_di_alk_M(1)" },
			{ "foQP@@@TRVYWmZ\\djsnjjP@h@CxQLYGHeFhMEh]@ !B@Ox@?bpXKF]`YYg@XAjDUHQTf\\A`YXQTaEQ`YP", "anil_di_alk_N(1)" },
			{ "flepB@DX\\@HRYVYU[{WkAZh@@HJ@@OaHcDLcdZctQqN@ !B?`Bw@h`BmwvH_[\\B?g~H?Oy?mwvw_Xa}bGvw?Oy??g~w__x@", "anil_di_alk_O(1)" },
			{ "dg}@PBt@c@aJYg_XjeZdHBj@C{Np|o@ !BLXC@f[\\BtMHBbOrwmwt@?`C~?K\\@?`JH@k\\", "anil_di_alk_P(1)" },
			{ "fncQ`@M^@aVQQIQHsIIQSITYUkUUSUU@A@@_BqGLEfhMEh]DXjr@dBpH`jBZH !BmpJw?_x@mpJw@ox@m?w~@K\\B?`Bw?[\\Bm?vw@k_}mpK~_{_}?`Bw@k\\B?`@", "anil_di_alk_coum(1)" },
			{ "fnsiB@DXXHhPABSJrnkJ~uNJtgMUUTtBAUP@GrJxwJb@zCdNpxcfBxyk` !BbOs~@Ha}bOrH?Ox@bOvH_X`BbOrH_Xa}b@JH?Oy?bGvH?Xa}?g~H_X`B?g|", "anil_di_alk_dhp(1)" },
			{ "fde`B@K@BLdTTTRbRNgER\\[u@DDDEH@A}aTArN[`A` !BotdBbCnTv]~udHAI[`@_IQ|eGuhLN@pxmpKYwxAIm?w~@@", "anil_di_alk_ene_A(8)" },
			{ "dcn@@@rRJEIIMr{Tu@@@GvIfYV@ !BbOvw?_x@tMINouR{pId@?orw?K\\@?`", "anil_di_alk_ene_B(4)" },
			{ "dkoH@LePrQQQPeHjjVii`CZC}QQT]`xlQ`xX@ !BUGlosPAN?W]N_w_|te@lYw_}]?qw?W_|", "anil_di_alk_furan_A(15)" },
			{ "dcMH@LtLdTTTIQUTmS\\@_TTUCQvC` !BLXC@f[\\BtMHBbMKOm?w~@H@qtl?Rsp", "anil_di_alk_furan_B(2)" },
			{ "foAPb@AF``@QddLTRVVcAJtmPHETPqPCjFKwJQrAQJMQ[GYDAD !Bm?w~@Hc}Sk?PtlBYJ{mTnqh_Fa|knrn{Fa?_i`", "anil_di_alk_indol(1)" },
			{ "daFH@NAIe^f`@`@~iHrBbh{@ !BbGw~_xc|bGvH_Xc|bOt", "anil_no_alk(40)" },
			{ "daE@@@yIe^f`@`@~hLRL`hj@ !BmpJw?_x@mpJw@ox@mpH", "anil_no_alk(40)" },
			{ "daF@@@RYWih@H@OfCDcHJJcl@ !BmpJw?_x@mpJw@ox@mpH", "anil_no_alk(40)" },
			{ "dg}@@@yJYfU~SvyBhEH`Cybbh{AbXNJh[g\\ !Bm?vH?_y?m?s~_xc|bGvw?[_}bGvH_[\\BbOp", "anil_no_alk_A(1)" },
			{ "dg}@@@GIHhdhjdwKmPK@U@A}UPNSAy^@ !BmpKPtdz?mww~@ER{pIg~_{\\BmpK~@Ox@m?p", "anil_no_alk_B(1)" },
			{ "foA``@G@idRbbJbRuNFlsTp@T@A}pdLrTJcTFav@ !BBOpH?UCRSg}T^rY@PEgRKuMg@CGRK}Ho@CGRKp", "anil_no_alk_C(1)" },
			{ "deW@@@rdif{[`bB`@~kLkN`\\g@ !B?g~w@hc}m?w~@K_}mpK~_{\\B", "anil_no_alk_D(1)" },
			{ "dmM@@@UJf]|fFZ`PJ@C{dcLjFchFEp !BTMIN_w_|UGlZXDAYPBY@Iai`PBX", "anil_no_alk_indol_A(1)" },
			{ "fhqa`@D@U{HhddihddSNZj``b`@OeHcFDrf\\rTZbvN`N@ !B?g~w_Xa}mpJH@k]}bGw~_{\\BbGvw?[_}?g~w@k\\B?`@", "anisol_A(5)" },
			{ "fdia`@D@UyIeUnU]LyjjBBJ`@OeHcFDrf\\rTZbvArN@ !B?g~w_Xa}mpJH@k]}bGw~_{\\BbGvw?[_}?g~w@k\\Bm?w~@@", "anisol_A(5)" },
			{ "fhqPb@DXUx@QdTVbtTRRIgMUPPQQ@e@OeHcDDbfLrTZbvN`N@ !BmpJw__x@mpJw__x@mpJw?_x@?g~w@k\\Bm?w~@Ox@bOp", "anisol_A(5)" },
			{ "fdiPb@DXUx@PdsssJnf\\uUAAEQ@e@OeHcDDbfLrTZbvArN@ !BmpJw__x@mpJw__x@mpJw?_x@?g~w@k\\Bm?w~@Ox@mpJH?@", "anisol_A(5)" },
			{ "dcNH@ECIEMDbeptAAT@GwIaQTMgQNKFxu` !BmpK~_{_}?`Bw@oy?m?s~@K\\Bm?vw@`", "anisol_B(2)" },
			{ "dcMD@FdDR[fUqUhHHP@~QHZ@ !Bb@JH?_x@b@Jw@hc}?`C~@H`Bm?rH?P", "anthranil_acid_A(19)" },
			{ "fakQP@DN@JuViLsN{vsKIFJtWkU@`SPPLP@A}bfNal@ !BFfASFF@ZKAa??ox@bOueXH`Bb@JH?Xa}?g~H@ha}bOs~_?x@bGvH_[\\BbOs~_p", "anthranil_acid_B(3)" },
			{ "fleI`@FRldBHiMsKNwjKQgMAAPsSd@GrDQ[@ !BKAcMT@@qKAcRK|uP@CD@LS|f?@cRKsD@@DxkAG_|IdAw?RY@", "anthranil_acid_C(2)" },
			{ "fleqb@JLxhLPAFQJJJHjZIQTyyKMSRDCD@A|afQ` !B]?qw?SE?K}H?VPPkJwmYPLtoGqi?LRqgTqcMK|to_sGRTBqg", "anthranil_acid_C(2)" },
			{ "dk]D`Le]@HRfYUdjDzA`fH@OhgJpkmqm@ !BwyeN`Gvw_XcOth`B_?y??ig@?`BH_WvH", "anthranil_acid_D(2)" },
			{ "fnsPP@JB@`mTfV]eV^^RTlGKVjZB@BAa@@OlL`TU` !Bnro_idz??[_OsXc}osFH@lwOTqbH?[|qosG~_xc|Tqbw?Xa}bGw~_{\\Bb@H", "anthranil_acid_E(2)" },
			{ "do~B@FAMOHihhddiQUhHHfP@~qHZM` !BbGvH?Oy?bGvw?X`B?g?~_xa}mwvw?_y?b@JH_P", "anthranil_acid_F(2)" },
			{ "dg^L@FAMR[fUWEV``bX@OfRJahzEb|@ !Bb@JH?_x@b@Jw?Hc}?`C~@H`Bm?rw?Hc}?`@", "anthranil_acid_G(1)" },
			{ "f`q``@F@PdwLk[hmRTtDEEJH@_HQCH@ !B@EgjWqSx@EgeHGswEO`T~@@fDBweHOak|GqY_?@C", "anthranil_acid_H(1)" },
			{ "fdy`P@F@QjvQSQQIZFIHRoAZBBFfhP@~DbJPrNPJEPz@p !BbGw~_xc|?`BH_[\\BbOrH@ox@bGvH?K\\Bs|tq`BnDwzZ?LP", "anthranil_acid_I(1)" },
			{ "dg]D@FxDR[fUuFV`HJT@OdRNblJH !BbOvH?Oy?m?vH__y?mpK~_xa}mww~_{\\BbGt", "anthranil_acid_J(1)" },
			{ "fakHb@LDXXTPAFRJKYSQQIZFIKEGA[vfZXHHX@H@@~pRFPZ@ !Bs|uTntz?mpI}m{_}mpK~@K_}mpK~_?x@m?vw?[\\B?g~w?_x@mpJH?Ox@?`BH?@", "anthranil_amide_A(1)" },
			{ "dknD@DB\\bRbbTQGV``XP@~aLu@` !B?`Bw?Ox@b@Jw@hc}?`C~@Oy?b@Jw?Hc}", "anthranil_one_A(38)" },
			{ "eFPBbaeC` !B@AL", "azo_A(324)" },
			{ "det@@DjYWkafefiPB !B?`@x\\q}eN@p_FlCFTqc@vQJp", "azulene(4)" },
			{ "daDD@@IIf]n``@@~PHJ@ !BmpJw?_x@?g~w@k\\B?`@", "catechol_A(92)" },
			{ "deU@@@iJ[gQejei@Ohj@ !Bm?vH?Zy?E~pP]SmkgzV?MgUo", "colchicine_A(3)" },
			{ "fbmAb@K^r@HRfuvUf}YqpTyh@JjZeb`@~PcOQU`aRDhVaVExP !Bm?vH?_y?mpJw?[_}mpJw?Vy?E~p{jq|eVa~?MjmDmZ|kn}~Ys}H", "colchicine_B(1)" },
			{ "flupB@LDx@HRfYU_mTeEFbffB`RjjH@OhBrn`B`K@cBlIpoBBJHdbJH !BSk?_ihc}s|w}m?vHbOrYww?~_?zH?_vHZNpQ_v@eQJnJkx@v", "colchicine_het(1)" },
			{ "flu@P@@H\\EIefUUWz\\UXwfh@@BJh@@~xrIQjKQzHxfJd`I@lBRH !B?`BH?K\\B?`C~@K_}mpJH@k\\BmpK~@Ox@m?vw?Xc|b@Jw@hc}", "coumarin_A(2)" },
			{ "flea`@E@QIIef[[]v\\MyjhFBbVHXhA}QdJbvAaNUi@RAXEPRQ@ !Bm?s~@K]}m?s~_{\\Bmww~@Hc}m?vw?K_|b@Jw@ox@?`Bw?X`B", "coumarin_B(2)" },
			{ "dcnD`FgPbDfUm^neX@biH@uja\\HQRHq@ !BbOw~_x`BbOvH?_y?b@JH?Xc}b@JH?P", "coumarin_C(1)" },
			{ "ffc@P@@DT{ILdhdidhcDeKUoEjuPAEM@@QBq@OdXstUiHVaFDxSQ@ !BbGvw_[\\Bmwvw@k_}?`Bw@k\\Bm?w~@K_|mpJw?_x@?`Bw@hc|?`C~@Hc|", "coumarin_D(1)" },
			{ "foQAb@BJtCDRYeYYvBdZshHHijI@CzDhkS@fBDKPoB@ !BmpK~@K_}bOrw@k\\B?`Bw?_x@GvVH?K\\BGqiSF@", "coumarin_E(1)" },
			{ "fbmPR@BTXHu`XbSL\\sjiFN|gMKTuMPAABQ@OdTcTUiHRaFEXSa@ !BaEPq`LBYtMJw@`JHm?w~_{\\B?`Bw_X`BmpJw?K]}mwvw?K_|mwt", "coumarin_F(1)" },
			{ "f`qPa@D\\@qtazPR[fWUdTcVZjZ@JBFB@]H\\~_XQeHyDTNJPbLRl|TaDXeYVfADEPWABD !B?g~H_[]}m?s~_{]}?`Bw__y??g~w_[]}?g~w?Oy?", "coumarin_G(1)" },
			{ "ffcQa@BBT{p@c`PeOJ{\\sjkNAbVkTmSTu@DDMD@~pbAQZJttHpgB|HH` !Bs\\~@Sk|qJxQ}m|?MwzZw@k_}?g~w@ox@mwvH@k\\Bm?rw_[]}m?rw?K]}", "coumarin_H(1)" },
			{ "f`apb@LDTJP@cIEDdheJd{uMTv@@@GrDXRMp@p !BbOvw?_y?b@Jw@k_}bOw~@K_}m?vH?Oy?bGvH__y?", "cyanamide_A(1)" },
			{ "fdyX@@@TXjtTefYuy|Tg^xB`p`l@@~PsKX !B?`C~@H`BmpK~@Hc}m?w~@K\\Bm?vw@ox@m?w~@K\\BmpJw@`", "cyano_amino_het_A(1)" },
			{ "fi{hB@LJmzh@cIEEDhheDl]LeiNMGhz@BHHx`p@@@~PkKYn@F !Bm?vH?_y?m?s~_xc|m?w~@K_}m?vH_Xa}?g~w@ox@m?rH@k_}m?w~@K_}mpJw@ox@", "cyano_amino_het_B(1)" },
			{ "ded`@@hYRVVwjz|@` !B?g?~_{_}bOvw?_y?bOs~_xc|", "cyano_cyano_A(23)" },
			{ "ded`@@hYRVVwjzvBhB !BbOrH?Ha}?`BH_Xc|mpJH?K_}", "cyano_cyano_A(23)" },
			{ "deUH@AdDf[mJfjkzDhCyDbh@ !B?g~w?Xc}_?{}m{\\Bfynw?In[", "cyano_cyano_B(3)" },
			{ "ded`@@HYRUnWfj|@~`l@ !B?`C~@K\\B?`Bw?[_|?g~w?Oy?", "cyano_ene_amine_A(56)" },
			{ "dct`@@jURVVm^Zj}@Ohk@ !B?`C~@K\\BbOrw__y?bOrw@oy?bOs~@@", "cyano_ene_amine_B(4)" },
			{ "dgoD@DePyIefW}jenY@OlRFaX@ !B?g~w_Xa}mpJH?Oy??`Bw_Xc|bGvw@oy?bGt", "cyano_ene_amine_C(3)" },
			{ "gN|@AjdloMHFt_iXcF`@p@ !Bm?vw?[\\B?g~w?Xa}", "cyano_imine_A(37)" },
			{ "dkl`@@rfRVUyWSyk`@@CzJ` !Bb@JH@ha}?`BH@ox@bGvH?Oy?bGvH__y?", "cyano_imine_B(17)" },
			{ "da{D`B[hP@cIHXdlu`GtM@ !Bm?w~@Hc}?g~H?K_}bOp", "cyano_imine_C(12)" },
			{ "digH@BxPRYeVyijx@` !BbGvH?Oy?bGw~@Ha}?g?~@@", "cyano_imine_D(1)" },
			{ "gNy@FDf[ZkbHGrTW@ !B?g~H?[_}bOs~_xc|", "cyano_keto_A(2)" },
			{ "foAp@@@JudRbbTVbJmV]u@`@@PQPB !Bm?vw?_y?mpJH_[_}mww~_xc|?g~w?Xa}bGvH?@", "cyano_misc_A(1)" },
			{ "die@`DD@aIee[fjkhp`MlIn}BQUhD`lEPfDH` !BmpK~@K_}mpK~_{\\Bm?w~_p", "cyano_pyridone_A(54)" },
			{ "dmwH@DzPRYYe[fjjz@MhFLCCAWhD`lEPfEpeD !BbOs~@Ha}bOs~_xc|bGw~@Oy?bOt", "cyano_pyridone_B(27)" },
			{ "dg]D@DdNrJIQQKELMUM\\s@GrKfqT`]Cl\\s` !BbOvH@oy?bOvw_Xc}b@K~_{]}?g~H?X`BbOt", "cyano_pyridone_C(11)" },
			{ "dmwD@DHPUIee}nZjnX@uzAHKATIaBIQ@ !BbOrH__x@b@Jw@hc|?`Bw?H`BbOt", "cyano_pyridone_D(5)" },
			{ "dcMD@DdMrJIQQJmsUU\\pA}bQtCEV`RBpUBXVb@ !Bm?w~_{_|m?w~@K_}mpK~_?x@m?rw?P", "cyano_pyridone_E(4)" },
			{ "fhiI@@DDuxBSLrskoANBuUP\\FP@FkHBPK@fBxHH` !B?`BH?K\\B?`BH_[_}?`Bw@hc|?g~w__x@bGvH__x@?g|", "cyano_pyridone_F(3)" },
			{ "ffch`@DDtYHByEEEDhlehld^B]ENVjjC`hVh`@~aWJl`I@lBXK`jb@ !BmpK~@K_}mpJH@oy?m?rw__x@bGw~_{_|bOrH@l?MLXBH?RnDwzZH@hc}", "cyano_pyridone_G(1)" },
			{ "dmw@`LK`BLdTTVQ[jjif@OdJNbh`JAHHaTIaBIQ@ !BbGw~@H`B?g~w@hc|?`Bw__x@bOp", "dhp_amidine_A(1)" },
			{ "dg]H@LtLdTTtRRmCTmT|tCPGvY`qN@ !B?`BH_[\\BbOrH@oy??`BH?Xc}bOw~@H`BbOt", "dhp_amino_CN_A(13)" },
			{ "foAI@@LTdXFRJJZJIIlEKUSMU\\s@U@OdXpT@ !BbGw~@Oy?b@J{UH`BbOw~@MKPwyfYpHc}b@JH?P", "dhp_amino_CN_B(9)" },
			{ "foAp`@JRLCFRJJZJIIlEKUSMU\\s@U@OdX`T@ !BbGw~@Oy?b@J{UH`BbOw~@MKPwyfYpHc}b@JH?P", "dhp_amino_CN_B(9)" },
			{ "doH@LvprQQSQIIFajVj^v`Z@~SLF@ !B?`BH?[\\Bb@JH?Oy??`BH_Xa}m?w~@H`BbGvH?P", "dhp_amino_CN_C(7)" },
			{ "dg}H`Cm`BDie[U\\kiifjfy`b@~PhO@ !BnuSMs{]}?`B?Sk\\Bm?rH@ox@?`BH?[\\B?`@", "dhp_amino_CN_D(5)" },
			{ "doH`LUq@HRfvY_^fij[ix@~QLzMpC@ !BbOvw?_y?bOrH__x@bGw~_x`B?`BH?Ha}bGvH_P", "dhp_amino_CN_E(4)" },
			{ "fleQb@CNlFH@cIEEihheDi|TUZfZenijhDhA}`dNsv@ !BtLtknsF?bOs|mxa}?`C~_x`BbOrw@oy??`BH__x@?`Bw_[\\B", "dhp_amino_CN_F(3)" },
			{ "dg]D`LN[@HRf^UgkjejZvcb@~cLw@L !B?`Bw_Xc|mpJw@ox@m?vw?Xc|mpJw?[_}mwt", "dhp_amino_CN_G(1)" },
			{ "dg_H`Ld{@HRf^Ugkjejzvcj@~cLw@L !B?`Bw_Xc|mpJw@ox@m?vw?_x@mpJw?[_}mwt", "dhp_amino_CN_G(1)" },
			{ "dmu@PLD@b`aJY{^njZnZNHCyLshwBL !BbGw~@Oy?b@JH?Ha}?`BH_X`BbOt", "dhp_amino_CN_H(1)" },
			{ "dg\\``LiS@HRf[mWXZfZnv@OlsJpX@ !B?`BH?[\\Bb@K~_xc|?`BH_Xa}?`BH@ha}bOt", "dhp_bis_amino_CN(19)" },
			{ "do~D@EA|bbTRbtJWVfjii`CyEb~kEB@ !B?g~H?[_}b@K~_{\\BbOvw?Xa}m?vw?Oy?m?vw?P", "dhp_keto_A(9)" },
			{ "f`a``@E@|drrsvjmMMUSTp@_P]uXTEnEf !B?g~H?[_}b@K~_{\\BbOvw?Xa}m?vw?Oy?mpJw?[_}", "dhp_keto_A(9)" },
			{ "do}H@ElLbbTRbtJTvfjj^`CyEa~kEB@ !B?g~H?[_}b@K~_{\\BbOvw?Xa}m?w~_{_|?g~w?P", "dhp_keto_A(9)" },
			{ "f`aQ@@EN@drrsvjcMMUTwP@_P}uXTEnEf !B?g~H?[_}b@K~_{\\BbOvw?Xa}m?w~_{_|mpK~_{_}", "dhp_keto_A(9)" },
			{ "f`iP`@HHAIJUU]e\\DxIwjVeh@J@@` !BTqaSYq}eGqjw@k_}m?vw@k\\Bm?w~_{\\Bm?vw?[\\B", "diazox_A(3)" },
			{ "deuH`FdPbDfUmkafZVf`B !BbGvH?Oy?bGvH_V@Z?g|lYvAe", "diazox_B(3)" },
			{ "dmM`@@`aeTiYV^dUZYjebj@vchqtL@ !BFf@OgYup?g|_Fa|ZGvV]\\EMgCyt", "diazox_C(1)" },
			{ "dmMD@BDErJJIJUixZfZjPCZN|PQDSBqFNa`@ !BmpJw__x@f]~w@k\\BosF{J?x@mpH", "diazox_D(1)" },
			{ "dmLh@HSeAJUV_BFZViZ`CxfclfEp !BosGRsyg_nrnw?_y?mpK~_{_}m?t", "diazox_E(1)" },
			{ "fluqb@LJCAG`AFRREQQQIISFbyO`kUPLaRPpIPB !B?Xc|bK_}bOvw?Oy?bOrw__x@nrnH?Xc}m?rw?MKOf]~H?Ox@", "diazox_sulfon_A(36)" },
			{ "flupa@LJCA@@cpQddaTTTRRTqhnSxJuTCHTdLBT@` !B?Xc|bK_}bOvw?Oy?bOrw__x@nrnH?Xc}m?rw?MKOf]~H?Ox@", "diazox_sulfon_A(36)" },
			{ "fa{Ha@LZ\\FB@AG`cIICEDeDlikDdiuh~BwjuTtuSP@S@@_DiCHeBh@ !B_X`BbK]}bGvw@oy?b@K~_{_}mwvfpHa}bGw~_xANaES~_{_}?g~w@k_}m?vw@`", "diazox_sulfon_B(5)" },
			{ "diE@B@YirRHiJijPCzBblTK\\Hp !Bm?vH?_x@mpJw?[\\Bm?vw@`", "dyes3A(19)" },
			{ "dee@@@gIHdTeTuT@_QfUrGTKg@ !Bb@Jw@oy?bOvw?[\\Bm?vw@k_}", "dyes5A(27)" },
			{ "ff}P@@@NRfUWuV[WdbudHDfZ`@@@OjBaTFbtAsJHJh !BbGvw_X`B?g~w@ha}bGvw__y?mpJw_[\\Bmwvw@k]}?`C~_{\\Bmwvw_[_|", "dyes7A(2)" },
			{ "dcM@@@iIY^UW^g`@@B !BbGvH?_y?b@K~_xa}bOs~_xa}bGw~_p", "ene_cyano_A(19)" },
			{ "foAH@@@TX{HeEDleD^BUk`HJfq@CzCL@ !BFf@ZXBlDPBXZXC}YFfA@IeCR?@`q@@c}sUCMT@", "ene_cyano_B(7)" },
			{ "dax`@@inrIQP}KPA}EP !BmpJw@ox@m?vw@h`BbOt", "ene_cyano_C(6)" },
			{ "day@PFx@a@aInVfo@H !B?g~H?[_}m?s~_{_|?g|", "ene_cyano_D(3)" },
			{ "gNy@FDeYYk@~b` !BbOvH@hc}bOs~_xc|", "ene_cyano_E(1)" },
			{ "fakpP@LejACMIMsOlklmhiV\\wkPPEMSVuB`A|IDTad\\`TFat^` !B`DxlY}KP`DySFBqgtmCRtELXtmC@igvHShATaH`BbOvH?Oy?bOpXTv]SYQ|ZGp", "ene_cyano_F(1)" },
			{ "foApB@LBT@HRf^wf\\TLzfYzZi@CxgHuAh]@ !BYrqeGv]S?`A??h`BmpJH@k]}s}Hqorn{f\\C_fP", "ene_cyano_G(1)" },
			{ "gOy@FDfYKZfPMihsPp@ !B^rmN_s|fK|tH?_uw", "ene_five_het_A(201)" },
			{ "gOyHJpDISKkTk@P !BSg|?Ib?MBOw}]ud?", "ene_five_het_B(90)" },
			{ "gOp@DjYkiY`Md[EFFBpp@ !BTMHkAEd?BOtq@OpH", "ene_five_het_C(85)" },
			{ "daED@DHNRY[JfjV@H !BId@kAECR?@`q@@c}AEP", "ene_five_het_D(46)" },
			{ "dcnH@EAIfYWKiuhFBH@MhzL]CAfJ` !Bf]}Tn|?M_[\\@?k_|Sk?|m?rwm?t@?`", "ene_five_het_E(44)" },
			{ "fhyAB@I@BLdTTRRQfRqPVoAhIA`@H@@~`rLpi@ !BpIdq`@JH?K_Ptk\\B@Ox@?j[@m?w|m?y?mpJw?[_}mpH", "ene_five_het_F(15)" },
			{ "foAaB@JX@DISM{riJV]SLl@D@Ala`oHy@hb@l@ !BUHPBmyg@tLw@ilwOb@J?LXa}bOs~_xa}bGw~_p", "ene_five_het_G(10)" },
			{ "dg~H`Jp@aJYo^TjNzYefjPC[FG_ItCDXvFC~HG@ !BU@S|]ue@TLu@IltoBOq?LPc}TMIN_uQ{PEd", "ene_five_het_G(10)" },
			{ "f`qQ@@DLAdTTTQRfRHqwfjfd@D@C[EAJ}bd\\aT_pbfJp !Bim|kn}CM@k^?ScF?b@KMsxa}osFH?Oy?bGvH__y?", "ene_five_het_G(10)" },
			{ "foAQ@@DLAdTTTQRfQFV\\uTtmR`AlR`eF}bd\\aTQ`ZFC~DTqV@ !BIc|k^uCM?G]?ScE?BOsMKpc}_sEPtdy?UGm@VP", "ene_five_het_G(10)" },
			{ "gOtHDPDILlZuR`P !BId@kAECR?@`q@@c}", "ene_five_het_H(6)" },
			{ "f`i@`@@FRYfU~tgIZ]yhFBIjD@Mh\\}AdQarFCLJP !Bf]}Tn|?M_[\\@?k\\BSk?|m?rwm?t@?l?RL[|kn}~Y", "ene_five_het_I(6)" },
			{ "dcnD`DFPBLbbTRbk]JmUSSPA|bQlUZAHKATIaZH !BZ?cjHG}YZ?`C}vox_ueR[w|f[rww_@", "ene_five_het_J(4)" },
			{ "dk^H@ACHhhdXhjYSZZijd@vSJ|QQLKAqFLa`kAb@ !BAEPq@DAY]?qPtopH]?totcE?JwmYPC}Y", "ene_five_het_K(4)" },
			{ "f`iQ@@DNAdTRbRRTJIQVg^ZiBAjA@CjEktFQfEH !BIc|k^uCM?G\\q_pc|YQ}T^pc}UGmeGuCRSg}T^tAY", "ene_five_het_L(4)" },
			{ "didL@@HTfY|fZff@MXhP !B^rmN_s|fK|tH?_uwBOpH?P", "ene_five_het_M(3)" },
			{ "didD`FD@cIEDd\\jifX@u`a@ !BTMHkACD@BOw|B@QTBOpH?P", "ene_five_het_M(3)" },
			{ "fdy`c@BTL@HpDQdLdTTQrbbRQFNCTmLDDT@AuBK{GLEGlcBIRDQbU` !B@k]TaLwOpJZYpMCMKF^H@ha}bOs~_?x@bGvH_Xc|?g?~_p", "ene_five_het_N(1)" },
			{ "dclD@@UIfYWIiuhIAH@H !B]?pq@B?MOrYTABlDVS}eXFU`_sETA@", "ene_five_one_A(55)" },
			{ "dk\\H@@rJJIJIDftvib`@@OnsN`\\gEcXN@ !BnuQN`M~Ys}JH@ovHYVBH?_x@wz[_ifU`", "ene_five_one_B(1)" },
			{ "daDL@@qdiibzjjPB !BOrYN_v\\l?W]N@@c}K|t", "ene_misc_A(5)" },
			{ "fhia`@D@E[HhhheDldRLMyjjZiid@OfXbdLcfJsV@ !BGvUgKFT_YuO~@G?~@k\\_Fh`BmpK}mwvwbOvw?PJwmpH", "ene_misc_B(2)" },
			{ "fi{Q`@DX@WnQQQJJQQQU[PkR\\GJZmUATD@DUH@A}SDJsVMp^@ !B?`Bw@h`B?`Bw_Xa}m?rH@k_|@k_}mxc|?g~w__x@?`BH_Xa}b@JH?Oy?bGvH__y?", "ene_misc_C(1)" },
			{ "f`q@b@CV@DISK[jkQbmTuPAU@@GuDXJIP{OX !B?`BH?X`Bm?rH?Hc}?`BH?Xc|b@JH?Xc}bOs~_xc}", "ene_misc_D(1)" },
			{ "dg|D`Et@aJYY}VnFZBHJi@Czd`hZCr|@ !B?`Bw?[\\BbOrw@ox@m?w~@Hc|b@K~@Hc}bOp", "ene_misc_E(1)" },
			{ "fakq@@DQjCHhdhdeELdebhjp\\iJuHP@@@EP@@[LEhw`y|cDT` !B?`BH@k\\BbGvw__y?bOrw@ha}bGw~@K_}b@K~_{\\BmpJH_Xa}mww~_xa}?g~H?@", "ene_one_A(3)" },
			{ "dazH`Dx@aImVfY@OdrJ` !Bb@K~@Hc}b@JH?X`BbOt", "ene_one_B(2)" },
			{ "dcOH@IWPRY[eRYij[h@~`X@ !BXFTZGq`l@O{~@AaSbOrw@f@ZbOrw?P", "ene_one_C(1)" },
			{ "diDD@@EIeYZVh@~QHF@ !B?g~H?[_}b@Jw@hc}?`Bw?P", "ene_one_D(1)" },
			{ "fasQ`@DT@YjSKJmr|{{yIZmTu@p@@T@@_TIEHY@l{` !B?`Bw@h`Bm?w~@Hc}mpJH?H`Bm?w~@Ox@bOvw@k\\BbOs~_?x@bGvH__y?bGvH@`", "ene_one_amide_A(1)" },
			{ "fbmQ@@D\\AdTTQbTRVfRTYwdyZijB@@H@@~IbBYSCQnDf !B?`Bw@h`Bmww~@Ha}?g~H?Ha}bGw~@Hc|b@JH@ox@bOvH?Hc|bOt", "ene_one_amide_B(1)" },
			{ "gGP@DjVePMioJPhcMCAfabkQ` !BmpJH@oy?m?vH?P", "ene_one_ene_A(57)" },
			{ "dmVL@JAIRY[^Zii`CyJah@ !B?`BH@k\\BbOw~@K_}bOrw@ox@m?t", "ene_one_ester(24)" },
			{ "gNqHAYAIfvf`NiVLiRDQbU` !B?g~w?Xc}mpK~_{_}", "ene_one_hal(17)" },
			{ "dmtDPIT@c@aJYm_JjViX@~`h@ !B@?]k~G|fTf}oKRX@tq_w_BCj}pL", "ene_one_one_A(1)" },
			{ "dcNL@ICmrJJIQQlKTsTpA}fXNS@ !Bmww~_{_|mwvH?[_}?g~w?Oy?b@JH?P", "ene_one_one_B(1)" },
			{ "gGQ@@drm^A@ !BmpK~@K_}?`Bw?P", "ene_one_yne_A(1)" },
			{ "didH@@RYWZYjih@v`_ItCETpQBbAp !BmpK~@K]}mpJw@k_}mpJw_P", "ene_quin_methide(10)" },
			{ "dmvH@EAIe]ffZjZx@vb_QLUSADK~Hg@ !BmpK~@K]}mpJw@k_}mpJw__x@mwt", "ene_quin_methide(10)" },
			{ "dif@@@RYWZYjih@r`Gm@~ShFJi`bEDC` !BmpK~@K]}mpJw@k_}mpJw_P", "ene_quin_methide(10)" },
			{ "dmu@@@UIYm\\YyjjX@raWmA^`hjcBxW|PV@ !Bb@JH@ha}?`BH?Oy?bGvH__y?bGt", "ene_quin_methide(10)" },
			{ "daFHPLx@a@aIeTjZiX@` !B]?posSD@JpP?Ig|qsU@", "ene_rhod_A(235)" },
			{ "deVDPAzPqBBDeYYXZZfX@~aH@ !B]?qw?W_|K|tq@BlDAEP?Ig|q", "ene_rhod_B(16)" },
			{ "do~DpBs`BCdGdLdTTJrTVJjZVYj`CiCW_HtSDTLiBHqJqrdHcDk@ !BJxSPtk|q@h`q`Hc}aERH@hc}b@JH?_x@b@JH?P", "ene_rhod_B(16)" },
			{ "dg^DPBs`BCBLdTTJrRQUSRsMPA|SQLKEx !BJpQPtg|q?@`q@@c}AEPH?@c}BOpH?Pc|BOt", "ene_rhod_B(16)" },
			{ "fbeab@BXxd@QdbbaVRRRRRIRfefYfZ`@~PrLx !BJpQPtg|q?@`q@@c}AEPH?@c}BOpH?Pc|BOtH?@c}BOpH?Pc|BOt", "ene_rhod_B(16)" },
			{ "f`qPb@BZqp@QdbbaVbbVISUjZVZfj@CxcHMcl}` !BOueN@Lto?P`ot`c|VT@H?UCRSg}T^rY@PEd@SmHo", "ene_rhod_B(16)" },
			{ "dg]HPEvPbFBLbRRbTQPkSMSLpA|aPl@ !B]?qw?W_|]?uw?B?MLP@kA@QTOrY?L\\to_sD", "ene_rhod_C(13)" },
			{ "fhqPa@EZdDDPpHRUVV]UDjfZfZf`@~pRCX{@ !B]?qw?W_|]?uw?B?MLP@kA@QTOrY?L\\uPsR}?Sg|qsU@", "ene_rhod_C(13)" },
			{ "f`aQA@EZdBHXDIJkKNjIULuLtl@GtBP !B]?qw?W_|]?uw?B?MLP@kA@QTOrY?L\\uPsR|lFG|q", "ene_rhod_C(13)" },
			{ "dcMH`LHPBDif]\\jiifV@MhwrECQFMa`@ !BSg|?I`c}K|w}]|uPBOq?LW}NBOwMT@", "ene_rhod_C(13)" },
			{ "do}D`LJW@HRfYUWrjfffYh@vbXtCayFKa`@ !BSg|?I`c}K|w}]|uPBOqYOw|q_txH?PPksUAYOp", "ene_rhod_C(13)" },
			{ "dg]H`LJPBDifUUrjfffU`CZK}CQFKa`@ !BSg|?I`c}K|w}]|uPBOqYOw|q_txH?Q}esU@", "ene_rhod_C(13)" },
			{ "dmuHPITPbJBDeVV^fYjY`C{LbXVLqL !B]?qw?W_|]?tq_r?ROueYPBm{sR|", "ene_rhod_D(8)" },
			{ "dg_HPIWQBHhHrIIQJHi]LsTsS@GvYDqlYbX !Btb|@L]Ho@CETAOqwTLwMKt@fBOpH?Pc|BOt", "ene_rhod_D(8)" },
			{ "f`aqC@IJLHDQPH|DIJll~krTsTsLt@GrLPjLpe@ !BKF\\@Sbqg@D{|BEQ{PEeYOuCRAEPH?Pc|BOtH?@c}", "ene_rhod_D(8)" },
			{ "flyIC@IJMXPHb`PdHRUYYuU_dififfeh@OdX`tYaJ@ !BKF\\@Sbqg@D{|BEQ{PEeYOuCRAEPH?VAeBOpDU@c}XFTH?@c}", "ene_rhod_D(8)" },
			{ "dcMD`LKe@HrQQPkIEUMKMPA|VPTMFqfD` !BJpQPtg|q?@`q@@c}AEPH?@c}BOpH?P", "ene_rhod_D(8)" },
			{ "doD`LKal@aJYgWWJjZYiZ`CxbahzGcLI@ !BJpQPtg|q?@`q@@c}Tq`DU@c|_sDH?ULXBOpH?P", "ene_rhod_D(8)" },
			{ "fhqpa@LDTJp@`HPeLvkjjReMLrtu@A}cDLctY`b@ !BPEg}]pQTSg}T^w|qBOuYO|toBOq?LPc}sR|H?G|qBOt", "ene_rhod_D(8)" },
			{ "fbeHa@LDxZPPAFPaJYeU]WTeJZZZUij@C{CHyBXsAD !BPEg}]pQTSg}T^w|qXFTH?Ud?sR|DU@c|_sE`YPc}sR|H?G|qBOt", "ene_rhod_D(8)" },
			{ "deVHPDx@b`aIegrijef@OhZ@ !B^rl?Idy??W\\osPc}_sDH?@c}", "ene_rhod_E(8)" },
			{ "dgH@DhpRYY~VJmMjefjfEHCjEkQwdZKrL]C@ !BAEQ@VSD@?@aPtg_|@Dyw?SE?K}H?VRm{VT@", "ene_rhod_F(8)" },
			{ "fbu``@@`QdTtRTJRTTQxHJV`@ffid`@vHkt\\~PbCQGGhXHppYa`@ !Bm?vw@oy?bGvw?_y??g~w?Xc}b@JH?X`BbOwPtdz?UKnfpLBYtl|", "ene_rhod_G(7)" },
			{ "foApb@JLerp@aJYeWWqQQjffifh@OdDavUT@TAHDPUABEHVaNExP !BSk?_il?MbOw}m?vHf]~H@g?~_?zH?_vH_Xa??`", "ene_rhod_H(5)" },
			{ "f`qQA@IVLCD\\DYEDeBheEjLuZ@BZfX`@~qrIQ{@ !B?`Bw@h`B?`C~@Hc|mpJw_SF?s}K_fYg@J{oMs{}N", "ene_rhod_I(3)" },
			{ "foAQB@DRx@HRYe~YRLlyjiZiZ@CZFODibhMehcCDL@ !BVS|osUQ{Sg}w?Ouw^roRKuMg@CGRKw}Ntb|@LP", "ene_rhod_J(3)" },
			{ "foAq@@DBdCHhhhmCDb\\lyjfZiZ@CZGODibhMehcCdL@ !BAEPq@DAYTMIw?MHo?@`fPEMg@CGRKw}Ntb|@LP", "ene_rhod_J(3)" },
			{ "did@@Dj[mafZjcJ@raGlQTw^aHbQPpUC@tLGPpUrgLxW@ !B?`BH?[_}bOrw@k\\B?g~w?P", "ene_six_het_A(483)" },
			{ "fakQ`@DTApNQQJJ[JIIQFYJ`oI[ujeiBA`@H@@~HbJPrEQUdAHE`QA\\EtP !BmpK~@K]}mpJw@oy??`Bw?[_}mpK~_{\\Bmwvw?[_}?g~w@k\\Bmww~@K\\BmpK~@@", "ene_six_het_B(2)" },
			{ "daFH@BAIfUnZeh@~Rh{@ !BbOw~_xc|bGvw?Xa}b@H", "ene_six_het_C(2)" },
			{ "digH@DJ`rJIQFnZii@MhGrM@qDC` !BbGvH?Oy?bGvH_[_}?g~H_P", "ene_six_het_D(1)" },
			{ "dmtD@@{IEEMJljfZnhJ`OjrBbh[Nc\\Jp !BSk?_il?MbOw}m|wP?g~H?Hc|bOp", "furan_A(3)" },
			{ "dklB@@PeR[eWUnZfjiPCxdbhGIp !Btb}SYp@q?G]TAD@fTLtDJpc|BOtH?@c}", "furan_acid_A(4)" },
			{ "dmlD@@iJYWWJxYV``Jb@H !BGqhlFOx@m?uSFK\\Bm?rw?W?~_?x", "het_465_misc(1)" },
			{ "foAqB@J\\DX@QdbRRRRTNBLyUTuKKPYPCzdLQ`hmChw@C@ !BtMHkaCF@@h`BbCF@JxRw@j[@m?v{UOy?mpJw?P", "het_55_A(2)" },
			{ "diTL@@SdfUTjxVjih@~cL@ !B]?posSD@JpP?Ic|fJpPq@@", "het_55_B(1)" },
			{ "f`ip`@NZ|BrRsJkNtyHsoMHPTSQ@A|adV` !BmpJw_\\?RL[|knvU`wyg_im~fs\\}gTvU`YVAgKG?~", "het_565_A(2)" },
			{ "fdeP`@NJAQJ[fVYyEhsoQhHbbjhT@OaHrVFbvNctArL@ !BbGvw_Xc|?g?~@Ha}nrnH_[\\BXAk~_}KOwzZYwrqgFfA`YP", "het_565_indole(1)" },
			{ "dg}D@DHCRYgeUImmjhHDP@{cF !BteC}BD@fU@Q?Sdx@Tv_MT@c|_ty?S`c}sU@", "het_5_A(7)" },
			{ "foAp`@DDdArSL|jnQfkMUAAB`@_Hqdh@ !B@D{|BEQ{PEgMTECR_txlF@c}sUCMT@c|KA`H?P", "het_5_B(4)" },
			{ "ff}QC@FBhBPQHXdLbdLfbrRbRRpeIKUUUM@aBdBT@~QRNX !BHGizWrAzARA{JsD@PEePtg_|?@aw?PAN]?sRTBqg]?t@S`AN]?plYw_}", "het_5_C(2)" },
			{ "fasQ@`DDD@HmHNdORFQQQIRIZSJUIKbj}ZiZjjP`RHTHA|`TJp !BZIHA@K`]aqrxGIzoVc@pISYoISAhwVNxWqdFcq@v?a?oLWJHZMucnFNx?a}rb@", "het_5_C(2)" },
			{ "foAQB@F\\h@HrQSQSFIIgKNjfZ@BHPhA|bDBp !B]?tH?SE?K}HDJs}YJwmYPLtoKF]?L\\tosR}?LP", "het_5_D(2)" },
			{ "fhyQ@@DDAdTTVbTVbIFFmxKUPP@@`@GrLYK@ !BnrmNo}~fs|vH_WvwbOs~_{|qbGw~@Ha}?g~H?Hc|?`@", "het_5_E(1)" },
			{ "fdyP`@JB@aIegf]WIQpVjZ``bP@OjBbVFsvQp !Bnro_idz??[_OsXc}osFH@oy?s\\}SFHc}osF?LX`BTqbH?P", "het_5_ene(1)" },
			{ "fa{H@D@TYjdiSLkKwkNxcJuDk^rEATA@@@PPhPCzBhkP`jBdIPab@ !BbGvw_Xc|?g?OtcF?bGvH_Yg@J{o_f_y?GqjDULwOf\\BYpBqgosFDULwOs\\~?LP", "het_5_inium(1)" },
			{ "dk]H@DHDfYyWImNfhHA@C{`cHzAaXvCc\\Rp !Btb?}]tAYUGm?LTy?sR}SF@c}_sE?LULX", "het_5_pyrazole_OH(14)" },
			{ "dg}H@DHDfYn]rX{fj``DcJ@zcKwAGPLSFp\\WFxU` !Btb?}]tAYUGm?LTy?AESMKuLXBOu?LW|qTq`", "het_5_pyrazole_OH(14)" },
			{ "dk_D@J[`MIYe^VzUYjVjd@~S\\N@ !BBOpH?UCRSg|ZXEQ{PEe@Id@fUGlZXEQ{", "het_65_A(21)" },
			{ "dmMH@DHLbbbaRIiUj`@`@v[FxYWtEER`RBpRb@ !Bf]?OsUR{Sk~w@gvw@O{|m?rw@Ox", "het_65_B(7)" },
			{ "f`qp@@@XdeLrj{nJBtuMLmKP@_HYBh@ !BwyeN`GvH_[_Oth`B_?y??ig@bGu}mq|Zb@JYpHa}", "het_65_C(6)" },
			{ "foAq@@B\\DAJ^VUUYpufiZjUh@H !B^uQYOrY@JpQPtopHLP@H?VU`U@PH?EPDYV@H?P", "het_65_C(6)" },
			{ "dmM@@@aJVY|fePBJd`CjI` !BmpK~_{_}m?vH?_y?m?rYw{lkosD", "het_65_Da(2)" },
			{ "fhyH@@@LUiJYYvuV`iJ|DHIFjeJ@B !B^rmYPBX?Gqh_Fbm{TLuYPOqwLW|H?FT_UGlH?UQ{YQ|", "het_65_Db(5)" },
			{ "fhipR@LRthw``BLdTTRRbgTIPUjejfZZhVHA}SDBbVZ`LUh`SA\\DXTQ@ !BJ{oPsW?~@k\\qox`B?[_}mxPkbOw~@G?~@k_}mpJw_?x", "het_65_E(2)" },
			{ "fluIB@LJt[p@cIEEDedTeDbTDjJZA`bffhP@~PsIX !Bf\\B@L[_|b@KRt@Jw?`C~@LBfb@JH@hc}b@JH?]CRSk}Tn|BY", "het_65_F(1)" },
			{ "dk^h@DH]LDfYVWX^ejifi`C{Ls\\O@ !BPEdZGuPD?W]@VTAYUGmTADy?U@QYOpc}", "het_65_G(1)" },
			{ "fhyi@@DDDYpDfYV}eVByKpVjfZgjd@MZPD`UA\\DDP !B?[_|mw?~pIe}mwvwSk}??eR{bOvYwtz?tMJYw|BYUKl", "het_65_H(1)" },
			{ "fdya`@B@CGHhheELlbirQgMRuTkTp@Zh|xK` !B?`Bw@h`Bs|tq`Hc}JxQeG}~faES_f]~YXFUeG}~YYQ|ka@", "het_65_I(1)" },
			{ "f`qAP@@RTZvRJJIZIEKEAZhFBbj`@ObDcdNsvUPItg@ !BJ{oPsPJw_?xqox`B?[_}m?x@bOu??g?~?[_}bG?~", "het_65_J(1)" },
			{ "diT`@@aLReURka@Bd`CjN` !BGqjfw{lknrnfw?y?Tv\\_YP", "het_65_K(1)" },
			{ "dk_D`Et~d@aJYU[li]ifYjjAhCyD`|kUBxTbTUb@ !BLPA@VUCR]?s|BAi`]?u@IblDPBXZXEQ{", "het_65_L(1)" },
			{ "fbmI@@DXEHFQQIQQIJKHkWcVSej`XJ`@@@CxRHqCHy@XcBXs@ !B?`BH@k\\BbGvw_X`B?g|qo|?RbGvH_]~YJ{nYpOy?_[]??g?~_[\\", "het_65_imidazole(1)" },
			{ "foQ``@E@idbbTVQbQJBeYuADESQ@A}qFLcfBbTFqv@ !BnuSMs?x@mwv?Sk_|bOrw@k]}bOwPtdz?UKo@fP", "het_65_mannich(1)" },
			{ "fhiP`@BR@cHieEDhUMiJMYjjYijh@MdBMzfHYCl}`\\b`TLAhXJtHJ`fBDHHmpM` !B?g~H_[]}mpK~@K]}mpJH@k\\BmwvYpKmTotyTaGvH@h`", "het_65_pyridone_A(3)" },
			{ "flePb@LDlx@QdbfbTRVbQwAF}UUSTuTlHT@vQKWjHqdArNIrJIPpZa`kQ@lBHI`nBwCV@ !B?`Bw_X`BmpK~@Ha}?`Bw@h`Bb@J{UIg@?`BH_]KPUHQ}b@JH", "het_65_pyridone_A(3)" },
			{ "f`qP@@@LrRJIJEJGLEhuTtsMU@AlbfoTQFHmcl}dTTa`uCAV`APE`UA^EnFl !B?`Bw_Xa}mpJH@k\\Bb@Jw_Yg@bGv{UK}NUHQ}b@JH", "het_65_pyridone_A(3)" },
			{ "fdyPB@LD@DIS\\lkkAF]UUSTuRpaPCYDm^hcFQ{@yGHheCAjFBmDBpH`fBxK\\MX !B?`Bw_X`BmpK~@Ha}?`Bw@h`Bb@J{UIg@bGwRtERD_X`Bb@", "het_65_pyridone_A(3)" },
			{ "fduP@@@\\rQQQQQKIHtyJq`~b@@@@@@@@D !Bm?w~@K_|?g~w?H`B?`Bw?[_}bGw~@Ox@?g?~_?y?b@JH_P", "het_6666_A(2)" },
			{ "foQP@@@BRYfYWvBUXsf`B@@`@B !BmpK~@K_}mpJH?K_|?g~w?_x@?`Bw_[_}bOs~_p", "het_666_A(5)" },
			{ "f`ia@@N@RfYeU~gIVtz`B@HJ@@OdFsv@ !BbGw~@H`B?g~H@k_|?`BH?Xc}?`C~@H`B?g~w?Hc}", "het_666_B(3)" },
			{ "fbmq@@DLlCHhhhhTdddlpQgIruU@aA@PPpPC{ELm@\\kR@dBpJ`lb@ !B?g~H_[]}?g~H?Oy?mpJw?Xa}mww~_?y?mpJH?Xa}mww~_?y?bGt", "het_666_C(1)" },
			{ "dk_H@Bi`RUeUWatv`@@@@OhS@ !Bm?rw?[_|?`Bw?[\\BmpJw_[_}mpJw@k]}", "het_66_A(7)" },
			{ "fluh@@@XIhrTsJoN}Txjw``PDCEU@`A|PdFbNIp !B?`Bw_[\\Bb@Jw?Oy?m?vH_[]}mwvH?Oy??g~H_Xa}?g|Bb@C~", "het_66_B(2)" },
			{ "fdyP`@JBAyIgefuYDitYh@`Ph@@MhZ|PDHbT^` !BmpJw__x@mpK~@K]}m?rw@oy?mww~@Ha}m?rw?H`B?g?~@@", "het_66_C(2)" },
			{ "fbuP`@FR@GHheheELdhcKWdmL@PPLH@A|cFJp !BbOrH?_x@?g~w@k_}?`Bw?K\\Bb@K~@K_}bOvw@k_|?g~H@k_}bOt", "het_66_D(1)" },
			{ "fnkQ@@NZ@dsKNw\\jnrVkIjUlD@@P@@@@@A}@D@ !B?g~w_Xc}mpK~_?y??`Bw_Xc}mpJw@oy?m?w~@Ha}mwvw@k\\B?g?~_?x@mwt", "het_66_E(1)" },
			{ "fnsQ`@J^AGNRJZIKSQJJFK\\d{rRtDD@@DQP@@_BQaHiCHyDhkc\\@ !Bmww~@Oy?mpJH_[_}m?vH?K\\BbGw~@Hc|?g~H@ox@bGvw_Xa}b@K~_?y??`@", "het_66_anisole(1)" },
			{ "deWH@D[`rJIJHtsUMMETA|RQfUGP !BbOw~_xc|bOvH?Xc|?g~H@hc}", "het_6_hydropyridone(1)" },
			{ "die`@@SJX\\bbRakfjj`C{DahFJm@dE`bDpaD !BbGvH?Oy?bGvH_Xc|?g~H_P", "het_6_imidate_A(4)" },
			{ "f`qh`@LDipPCISM~sNscoTuUA@P@GwJXJMPZKPzOQU`APE`UALExP !BbOrw@ha}?`Bw?_x@mpJw@k_}m?s~_?x@mwvw__y?", "het_6_imidate_B(1)" },
			{ "dcML@AtDyImf_eVhHB@CZI}fYt[` !B?`Bw@h`BbOw~_xc|m?vH_Xa}b@JH_P", "het_6_pyridone_NH2(1)" },
			{ "daFD@DAdfUjz@H@Cy@ah@ !Bm?vw@oy?m?vw_[\\B?g|", "het_6_pyridone_OH(5)" },
			{ "daE`@@`j[diYbX@b@CzJblLx !BmpK~_{_}mwvH__y?mpH", "het_6_tetrazine(18)" },
			{ "daF`@@`jYJVXn@J@@~QhzJpS` !BbGvw?_y??g~w@ha}mwt", "het_6_tetrazine(18)" },
			{ "die`@@`jX\\dRbeK`Bb@CyF`XkAN@ !BbGvw?_y??g~w@ha}mww~_p", "het_6_tetrazine(18)" },
			{ "die`@@`jX\\dRbeK`Bb@CzJblTx !BmpK~_{_}mwvH_[\\B?g~w?P", "het_6_tetrazine(18)" },
			{ "dif`@@`fEJV[k`Hb@CyFchkFN@ !BbGvw?_y?mpK~_xa}mwvw?P", "het_6_tetrazine(18)" },
			{ "deU`@@`fFTiYok`Hb`@~PhFJqS` !BmpK~_{_}bGvw_[\\B?g?~_{_}", "het_6_tetrazine(18)" },
			{ "difh@LJfDDim]nh@H@OhSJqs` !Bm?vH?[_|?g~w?[]}?g~w?P", "het_6_tetrazine(18)" },
			{ "didh@LiaAJ[W[j@B@CyDphkGN@ !Bm?vH?[_|?g~w?[]}?g~w?P", "het_6_tetrazine(18)" },
			{ "deVh@LindLdTrbKCPAD@GrIgQVA\\ !Bm?vH?[_|?g~w?[]}bGw~_{_}", "het_6_tetrazine(18)" },
			{ "deVh@LJadDimU[j@B`@~aLk@n@ !Bm?vH?[_|?g~w?[]}?g?~_{_}", "het_6_tetrazine(18)" },
			{ "deTh@LhYAJ[UVz`@h@OdSBblBx !Bm?vH?[_|?g~w?[]}?g?~_{_}", "het_6_tetrazine(18)" },
			{ "dmvh@LiiTDimg^F`HJ@CyDqhkDn@ !Bm?vH?[_|?g~w?Xa}mww~_?y?m?t", "het_6_tetrazine(18)" },
			{ "ffsHB@F\\eT@QdbbTJTRRVfRIQQgAKViVhDH@B`@CxbHIEHy@ !BtMHkAHc}LPC|bFcldW~`iTQkBf|LvH@v`Df@R^pWCM`@kfuO{A_lEvuO", "het_76_A(1)" },
			{ "fhqpa@JRTRpIAD`dw[KjkIUSTmUS@A|rd\\`TZpvNp !BKAcMT@@qtb|lF@@q?G]TAD@fTLtH?@c}BOpH?Pc|BOt", "het_pyraz_misc(1)" },
			{ "dmN@B@B\\dbbtQ[iTH@@@@vcoYgUDp !B?`Bw?Xc}mpJH?K\\Bm?w~@Ox@bOp", "het_pyridiniums_A(39)" },
			{ "dcm@B@tIrRJKQEMtjD@@P@Ft]yLzh@ !B?`Bw?Xc}mpJH?K\\Bm?w~@Ox@bOrH?@", "het_pyridiniums_A(39)" },
			{ "dmNHBHBIrJJIQEneX@@@@CZN|eQL[`J !Bm?s~@K_}mpJH?K\\Bm?w~@Ox@bOp", "het_pyridiniums_A(39)" },
			{ "dcmHBHtHgHhheDTwRl@@A@@[QwhjMpE@ !Bm?s~@K_}mpJH?K\\Bm?w~@Ox@bOrH?@", "het_pyridiniums_A(39)" },
			{ "dk^@B@BTjYV_XULHB@P@CZA}VYT]Bqn@ !B?`Bw_Xc}m?rH@k_|b@Jw?_x@?`BH?X`B", "het_pyridiniums_A(39)" },
			{ "dg}@B@lIRieY}XULHB@R@@v`_EfUGQn@ !B?`Bw_Xc}m?rH@k_|b@Jw?_x@?`BH?X`Bb@H", "het_pyridiniums_A(39)" },
			{ "dk^HBLCIrIJJIQDYtz`@@@@MhguADXf]Fp !BmpJw?[\\B?`Bw_[_|b@Jw?K_}?`C~@H`B", "het_pyridiniums_A(39)" },
			{ "dg}HBLlLgHdhheDTLz]P@@D@AmD~HHcDsh@ !BmpJw?[\\B?`Bw_[_|b@Jw?K_}?`C~@H`Bb@H", "het_pyridiniums_A(39)" },
			{ "dg~HBB@irJKQQJHrivu@@@@@[PolSA`x@ !BmpJw?_x@mpK~@K]}m?rH@k_|m?w~@Ox@b@H", "het_pyridiniums_A(39)" },
			{ "foAQ@DBN@R\\bbtTRbJdhufh@@B@@MhJ|aFB` !BmpJw?_x@mpK~@K]}m?rH@k_|m?w~@Ox@b@JH@`", "het_pyridiniums_A(39)" },
			{ "f`qQ@DDTAR\\bbRTtRbNcN|uR@@@@@[PMxbHqbh]@ !B?g~H?[_}b@Jw@hc}?`Bw_[\\Bb@Jw@k]}?`C~@Hc|", "het_pyridiniums_A(39)" },
			{ "fhiq@DDTBBdyEDdiheDUhsoMT`@@P@Am@wlHcFJ` !B?g~H?[_}b@Jw@hc}?`Bw_[\\Bb@Jw@k]}?`C~@Hc|b@H", "het_pyridiniums_A(39)" },
			{ "dcn@B@B\\dbbRbkBna@P@@Am@~KLjNyX@ !BmpK~_x`Bm?w~@K_}bOw~_{\\BmpK~@@", "het_pyridiniums_A(39)" },
			{ "dk]@B@LIrRJIJJiaWP`H@`@MhGvYeQw@ !BmpK~_x`Bm?w~@K_}bGw~_{\\BmpK~@Ox@", "het_pyridiniums_A(39)" },
			{ "dcn@B@B\\dbRTJU\\na@`@@AmdIwhjJpc` !BmpK~_x`Bm?vw?Xc}?g~w@k_}mwvw?@", "het_pyridiniums_B(2)" },
			{ "dk^@B@BTjUYwkmLHDH@@CXhSikBN@ !BmpK~_x`Bm?vw?Xc}?g~w@oy?m?vw_[_|", "het_pyridiniums_B(2)" },
			{ "foQH@D@PhHDiTlj}iF\\dZuUUUTu@AkxChNP{CbNhycnNDzSmNLysoNBx !B`CGMsuLXim~?LXPkosFH?ULX?g~H@oy?bOvH?P", "het_pyridiniums_C(1)" },
			{ "dg}@`LH@aJ[[yVfNzZj@A@C{Drh{Lpun@X !BBOuw?UCRSg}T^tAY^roRKp@qTv_RK}HoTv\\", "het_thio_5_A(8)" },
			{ "dieH`LK`BLdRdJpjZehR`OhJMpC@ !BUGoOs_vwSk~w?E\\cm?t^_p", "het_thio_5_B(2)" },
			{ "dg}D`LiC@HRYWe]Jeujh@JbBhCylchFIaXoJu@dE`bEX` !BtmC@igvHShATaHc|?`BH?Xc|b@JH?Xc|bOt", "het_thio_5_C(2)" },
			{ "gO|HLZ@aJYlzedB !BUGlos_uw@Dyw?Dy?", "het_thio_5_imine_A(1)" },
			{ "do|``DpU@HRYfU}RYjjUiX@~cl@ !B_sG}]rlDOr[RKr?MIdA{JuMg]?pfOw_}^rmw?@", "het_thio_5_imine_B(1)" },
			{ "dkl`PBki@HpHRf[W_FjViY`CzN` !BUGlos_uw@Dyw?Dy?KF]w?Wlk]?pfOwlk", "het_thio_5_imine_C(1)" },
			{ "fbmIB@LDXhP@aJYUWYUWdmFbf``RjBA@@CxbLm`Xs` !Bm?vH?[_|?g~H?K_}m?vH?_y?f]~{J{|qUKn?SeMgpJYSY{}NUKl", "het_thio_656a(5)" },
			{ "fdeIB@LDYhP@cIEDdhdTdeqQkAcPPLTmQH@]P}^XcMPzOPFHqn@GDMD !BbOvw?Xc|?g~w@ha}bGw~@K_}?g~fwxPk`CF@SbqgKF^@S`", "het_thio_656b(3)" },
			{ "flmpBDLDX@HINRJIQKIQIHtYpSoQSSUT@@@`@AwAC@ !B?g~w?K_}aBnw?[\\Bim?Ms{\\BTv_Rs{_}?`CRsuMgmpJw@ox@", "het_thio_656c(1)" },
			{ "fdehB@LDiIP@cIELddhcDdsdeAcP@Tt@A@@_HQflw@C@ !BbGvw_Xc|?g~H_Xa}?g~fwxPk`CDkn|BfFfATn|BfpJYTnp", "het_thio_65_A(3)" },
			{ "dg``LJaeS@HrQSJZIEUr{SUMUJ@_ILG@ !B]?tH?R?RLW|k^uQ{OueeGt@fYQ|?VVT_UGl", "het_thio_65_B(2)" },
			{ "fleIB@LDUZP@cIEDeEDbdbf\\]zfjfBAd@@~XcAXj@qFDp !Bm?vH?\\?RL[~H@bn{wyfDJ?x@bOu??ovwb@K}mw?~bOvH@hc}", "het_thio_65_C(2)" },
			{ "fhiqA@LDdH@PFPRfUY]UYrsjZi``X@@z`E}QFDbTJcTQ`DiBHqJs~HDH !Bm?vH?SF?s}JH@m~YJ{o~@Hc}_[]??h`B_?y}mxc}?[\\", "het_thio_65_D(1)" },
			{ "fgA`A@N@BJABTsLk{NRLkUALEEB@GtKX !B?X`@?`JH_?yTnpJH@O{}bGvHtMK@fW?~bOt", "het_thio_665(1)" },
			{ "fgA`B@N@BDifYWz\\d[Uj@H@B@@OiDad\\`TRaTZ`tV` !Bm?s~_{]}?`Bw_Xa}?g~w@k\\B?g?~_?x@bGt", "het_thio_666_A(13)" },
			{ "foQ`B@N@BDifYU^gIVtz`B@HH@@~dRFPJIPjMP[kPz@ !B?g~H?Hc}m?vH?_x@b@K~_?y?b@JH?Ha}mww~@@", "het_thio_666_A(13)" },
			{ "f`i`B@N@BDifYU_irUmNh@`BB`@CyQHY@heBhuAlmCh}@ !BbOw~@H`B?g~H@k\\B?`BH?Xc}?`C~@H`B?g~w@hc}", "het_thio_666_A(13)" },
			{ "f`iPB@NF@DISLro_SdkZ]PA@DE@@GtbPrNQJEQjCQZGQVFg[ay` !B?`BH?X`BmpJH@oy?bGw~@Ox@bOvH_X`BmpK~_xa}", "het_thio_666_A(13)" },
			{ "fhyPB@NV@DYHhhhddicSdgZ}PA@EAP@A}HdLbTJcTFztNctU`YvxAX !B?`BH?X`BmpJH@oy?bGw~@Ox@bOvH_Xc|b@Jw@oy?bGt", "het_thio_666_A(13)" },
			{ "fdePB@NV@DISLrjwmNR]ku@D@TEP@A|hdLbTJcTFrtNctAblCNwBK@ !B?`BH?X`BmpJH@oy?bOw~@Ox@bOvH?X`Bb@Jw@oy?bOvH_P", "het_thio_666_A(13)" },
			{ "fbm`B@N@BLdTTTRVdfJUNRMhM@D@EHm@@GTLwaDad\\bTJcTF`LU`Yp !BPbogdUU{zJyU^suTm}EBJtHkyyGgd^bne}[~_woKOUREfJSMQwh", "het_thio_666_A(13)" },
			{ "fj}`B@N@BLdTTTRRTduRirUmQh@`BJQZ@@NhEoBICHeBhuAnmDXkBs` !BIMK~ErSM?f`dsUoMog\\dtbSR?a_~EuQu?fbyyp@qKN][sV]iJonENp", "het_thio_666_A(13)" },
			{ "ffc`B@N@BDifYUZouirUmQh@`BJRV`@CjE[tbPrIPjMP[KQFDqVEg@ !B?f`dsRSRV}HdtoxW^Jw~ZOyhILtdsSRrV}Hllrsh@D{~E|Su~Z_hTPKS", "het_thio_666_A(13)" },
			{ "fbm`B@N@BDifYW~mZ\\d[Uj@H@BeZ@@NhYoBICHy@heBhuEhkBs` !BmpJH?Ox@m?w~@Ha}bOrw@k\\BbOrH?K_}bGw~@K_}mpJH?K\\B?`@", "het_thio_666_A(13)" },
			{ "fj}`B@N@BLdTTTRRVLfRirUmNh@`BBeZ@@NhEoBICHEDhUFhMshkAs` !BbOs~_xc}?`BH?[_}?g~H@hc|?g?~_xa}?`Bw_Xc}?`BH@oy?b@JH?P", "het_thio_666_A(13)" },
			{ "ffc`B@N@BLdTTTRRVrdJUNRmiu@D@PUJt@@]Pk^dRFPJIPjMP[GQzJp|x !B?`BH?X`BmpJH@oy?bGw~@Ox@bOvH_X`BmpK~_xa}b@Jw@ox@bOw~@H`B", "het_thio_666_A(13)" },
			{ "ffcPB@NF@DYHhhhdmMeHTj\\e[Sj@H@`jUh@@zaV|HdLcdRaTZ`tNbjMN|{\\OL !B?nbdsZSRf}Jdto{giLw~zO{hiLvdsZSRf}K~yzSMiMJ[to{htPC~z@bR", "het_thio_666_A(13)" },
			{ "fnsPB@NV@DYHhhhddibiBeSdgZ}PA@EATkP@AuAmxQHYDhUFhMuh}ETF\\EvxAX !B?nbdsZSRf}Jdto{giLw~zO{hiLvdsZSRiMJ[to{giLvdtioR?ncQ@O{hBIH", "het_thio_666_A(13)" },
			{ "fakPB@NV@DYHhhhddileITj\\d{Wj@H@hJiV`@CjG[tbPrIPjMP[KQz@qUAgQ]nDV !B?aadSVPrFsIdLoygYDw~FOxXYDudSVPrYCH[LoygYDudSVPrFsK~FND@?a`HT`", "het_thio_666_A(13)" },
			{ "feg`B@N@BDifYWj~e]Z\\d[PZ@H@JReYZ@@NdMiwnDad\\bTJcTAbjCNBx !BNyIDdo{HNzw~rDRmnJH{dcnRQIIDdcnmrJZ]@IK`QJw~rCnmNyHlbsstJBzDDcnR?l`", "het_thio_666_A(13)" },
			{ "fmw`B@N@BLdTTTRRTdqdRVRirUmQh@`BJReYZ@@Nd]ewnDadRaTZ`wQbjKNbx !BUGK~auPM?kaTCRlM_a]T\\eQr?h_~a?SU?kcYApCQg@\\kCUPM?kaT\\`^i^ioyZwyGUGITCP", "het_thio_666_A(13)" },
			{ "fco`B@N@BLdTTTRRTdvTbRJUNRmjM@D@QRUJrt@@]HG[oBICHeBhuAlcBXjbsdn@ !B?f`dsRSRV}HdtoxW^Jw~ZOyhILtdsSRrV}HllppH@D{~E|SuIMI[toyh~Z_XbPKSqLw~ZBSR", "het_thio_666_A(13)" },
			{ "foQPB@NV@DISLrnmNRMiu@D@DP@A}HdLcdBaTZ`tVqt@ !B?`BH_X`BmpJH@oy?bGw~@Ox@bGvH_[\\BmpK~_p", "het_thio_666_A(13)" },
			{ "f`iPB@NN@DISLrjkSdkZ}PA@DQ@@GtbPrAPjMP[kP{OP !BbOs~_xc}?`BH?[_}?g~H@hc|?g?~_xa}?`C~@K]}", "het_thio_666_A(13)" },
			{ "fhyPB@NN@DISLrjktyJvoT@PADT@@_JICHEBhuAlmCl}@X@ !B?`BH?X`BmpJH@oy?bOw~@Ox@bOvH?X`BmpJw@oy?bOt", "het_thio_666_A(13)" },
			{ "fhypB@NF\\@HRfYe^WirUm^h@`BHh@@~dRFQrEQjCQZGYzJpt{\\@l !B?`BH?X`BmpJH@oy?bGw~@Ox@bOvH_X`BmpJw@oy?bGt", "het_thio_666_A(13)" },
			{ "fdepB@NV|@HrQQQQIIQHtyIv`t@PAQE@@GtbPrEQjC]ZGQ{@qVAg[aE` !B?`BH?X`BmpJH@oy?bGw~@Ox@bOvH_Xc|b@Jw@k\\B?g~H_P", "het_thio_666_A(13)" },
			{ "flupB@NV|@HRfYeUevgINtF`B@JHj@@OeDadJcTFrtNcvAbLU`YvxIX !B?`BH?X`BmpJH@oy?bOw~@Ox@bOvH?X`Bb@Jw@k\\B?g~H?Xa}", "het_thio_666_A(13)" },
			{ "fj}PB@NA@DYHhhhdmIDbeSdcZcPA@ASBt@@]PK^DRFQrEQjCPGHqVAg@ !B?f`dsRSRV}HdtoxW^Jw~ZOyhILtdsUoRKKLlz@ANV}K~E?egzEEBJp", "het_thio_666_A(13)" },
			{ "ffcPB@NQ@DYHhhhddiHeTj\\e[RZ@H@bfEh@@zaV|HdLaTZ`wVbNIblKN@ !BIMK~ErSM?f`dsUoMog\\dtbSR?a_~EuQu?fbyyp@qKN_~ZEoMYvdj~xT{", "het_thio_666_A(13)" },
			{ "fnsPB@NQ@DISLrjuKztyJvdt@PAELRt@@]P[^dRFPjMP[KQGDqfJplx !B?f`dsRSRV}HdtoxW^Jw~ZOyhILtdsSRrV}Hllrsh@Dy[toxWqOWyi~aQ@mL", "het_thio_666_A(13)" },
			{ "fj}PB@NV@DYHhhhdleiBeSdcZ]PA@AEJt@@]PK^DRFQrAPjMQ[GQVCg@ !B?`BH_X`BmpJH@oy?bGw~@Ox@bGvH_[\\BmpK~_x`BmpK~@Hc}?`BH?@", "het_thio_666_A(13)" },
			{ "ffcPB@NN@DYHhhhdddcHTj\\e[Wj@H@bJUh@@zaV|HdL`TJcTFyv^blON@ !BbOs~_xc}?`BH?[_}?g~H@hc|?g?~_xa}?`C~@K]}bOw~@H`B?g~H@hc}", "het_thio_666_A(13)" },
			{ "fnsPB@NN@DYHhhhdddliJeSdkZ}PA@DQTkP@AuAmzQHY@hUFhMcl}@Xk@K` !B?`BH?X`BmpJH@oy?bGw~@Ox@bOvH_X`BmpJw@oy?bGvH@k\\B?`BH?_x@b@H", "het_thio_666_A(13)" },
			{ "fnspB@NF\\@HrQQQQIZIYRUJgIVuz`B@HbiV`@CjC[pbPrNPjMPZGYzJhtxKmpBp !B?baDkTRRNyIDdoyWQJw~JOxhQJuDkTRRNyH{doyWQJuDdcnR?b`Q@OxhxIH", "het_thio_666_A(13)" },
			{ "fakpB@NV|@HrQQQQIIQHjRiTyIv`t@PAQERm@@GTNwaDadJcTFzt^pLUPYtW[aE` !B?baDkTRRNyIDdoyWQJw~JOxhQJuDkTRRQIH{dcnR?e]DkTRRNyK~JAD@?bc`d`", "het_thio_666_A(13)" },
			{ "fi{pB@NV|@HrQQQQIIQKIRMJgINtF`B@JHjeZ@@NhCoRICHUFhMeh}`XcETF\\evxIX !B?`cx{_cb~~Kxxoyw~Nw~BOxH~Nwx{_cb~NK{xoob?g_x{_cm~NK{xoxHHPC~BA@Z", "het_thio_666_A(13)" },
			{ "fmwPB@NA@DYHhhhdmIDmHdbeSdcZcPA@ASEJrt@@]H{Ko\\ICHyBhu@\\cETF]Ep !B?f`dsRSRV}HdtoxW^Jw~ZOyhILtdsUoRKKLLB@ANV}K~ErSRV}K~ZOegvHeBJ|SM?f`dt`", "het_thio_666_A(13)" },
			{ "fcoPB@NQ@DYHhhhddiHdYDdTj\\e[RZ@H@bfJUeh@@zPNw^xRFPjMP[hxfJhlyK` !BUGK~auPM?kaTCRlM_a]T\\eQr?h_~a?SU?kcYApCQg@_~nBlMU@w~nEQrAzezf?ek_d]T\\ePM", "het_thio_666_A(13)" },
			{ "fkPB@NQ@DYHhhhddiHeeHdjeSdkZSPA@DTqTkKP@Atb\\^|HdLaTZ`vQqLYbjKNrx !B?f`dsRSRV}HdtoxW^Jw~ZOyhILtdsSRrV}HllppH@Dy[toxWqOTdteoR?fcyi}bI@mODs_yhIMH", "het_thio_666_A(13)" },
			{ "f`iaB@NV@DYHhhhdldZ\\d[Sj@H@Hh@@~DRFQrAPjMPZGQnGf !B?`BH_X`BmpJH@oy?bGw~@Ox@bGvH_[\\BmpK~_{]}", "het_thio_666_A(13)" },
			{ "fhyaB@NN@DYHhhhdddkSdkZ}PA@DQP@A|HdL`TJcTFzt^c\\@l !B?`BH_X`BmpJH@oy?bGw~@Ox@bGvH_Xc|mpJw@oy?mwt", "het_thio_666_A(13)" },
			{ "fdeaB@NN@DISLrjk}NRmku@D@QEP@A}HdL`TJcTFrt^`L[aE` !B?`BH?X`BmpJH@oy?bOw~@Ox@bOvH?X`BmpJw@oy?bOvw?P", "het_thio_666_A(13)" },
			{ "fdeQB@NF\\@HRfYe^Wz\\e[Wj@H@bJ`@CxQHYGHUFhMEh}EXZ]m@WE` !B?`BH_X`BmpJH@oy?bGw~@Ox@bGvH_X`BmpJw@oy?bGvw_P", "het_thio_666_A(13)" },
			{ "fluQB@NV|@HrQQQQIIQHzgINtF`B@JHj@@OaDadJcTFztN`LU`YvtQZV !B?`BH_X`BmpJH@oy?bGw~@Ox@bGvH_Xc|b@Jw@k\\B?g~H_[]}", "het_thio_666_A(13)" },
			{ "fbmQB@NV|@HRfYeUewirSmAh@`BbJh@@~dRFPjMP[KPz@qFJpL{ZDoK@ !B?`BH?X`BmpJH@oy?bOw~@Ox@bOvH?X`Bb@Jw@k\\B?g~H?Xa}m?t", "het_thio_666_A(13)" },
			{ "ffcaB@NA@DYHhhhdmIDbdj\\d[TZ@H@JXVh@@z`V}pdLcdJcTFbLU`YvxUX !B?f`dsRSRV}HdtoxW^Jw~ZOyhILtdsUoRKKLlz@ANV}K~E?egzEEBJuoM", "het_thio_666_A(13)" },
			{ "fnsaB@NQ@DYHhhhddiHeTeSdkZSPA@DTpmP@AuBm{aHYBhuAnmBXkBsmpZp !B?f`dsRSRV}HdtoxW^Jw~ZOyhILtdsSRrV}Hllrsh@Dy[toxW~Z_hTPKSV|t", "het_thio_666_A(13)" },
			{ "fakaB@NQ@DISLrjuKzmNRmiM@D@QSDmP@AuAmxQHYBhuAlmBXsEXV]nGV !B?f`dsRSRV}HdtoxW^Jw~ZOyhILtdsSRrV}Hllrsh@Dy[toxWqOWyi~aQ@mM[sP", "het_thio_666_A(13)" },
			{ "ffcaB@NV@DISLrnoSkSdcZ]PA@AELm@@GTJwnDad\\`TJcTNblGNwAK@ !B?`BH_X`BmpJH@oy?bGw~@Ox@bGvH_[\\BmpK~_x`BmpK~@K]}bOw~@Hc|", "het_thio_666_A(13)" },
			{ "fnsaB@NN@DYHhhhdddcHleSdkZ}PA@DQSKP@AuAm{aHY@hUFhMwhkCsmprp !B?`BH_X`BmpJH@oy?bGw~@Ox@bGvH_Xc|mpJw@oy?b@Jw@ox@mwvH?_x@bOp", "het_thio_666_A(13)" },
			{ "fakaB@NN@DYHhhhdddliDTj\\e[Wj@H@bJfV`@CjG[pbPrAPjMP[OPFJpB{\\Bl !B?`BH?X`BmpJH@oy?bGw~@Ox@bOvH_X`BmpJw@oy?bGvH@k\\B?`Bw_Xc}?`BH@`", "het_thio_666_A(13)" },
			{ "fakQB@NF\\@HrQQQQIZIYRHiTyJvoT@PADULm@@GTNwnDad\\aTZ`t^bjMNB{Z@lk@ !B?`BH_X`BmpJH@oy?bGw~@Ox@bGvH_X`BmpJw@oy?bGvH@k\\B?`Bw_Rxp?`@DI@", "het_thio_666_A(13)" },
			{ "fi{QB@NV|@HrQQQQIIQHjQEJgINtF`B@JHjYZ@@NhCo\\ICHUFhMuhCETF]EvtQ]V !B?`BH_X`BmpJH@oy?bGw~@Ox@bGvH_Xc|b@Jw@k\\B?g~H_X`BmpK~@K]}KcC~@@Pd", "het_thio_666_A(13)" },
			{ "fegQB@NV|@HrQQQQIIQKIRJiTyIv`t@PAQETrt@@]Pg^DRFPjMP[KPFHqUAgI]mBVu` !B?`cx{_cb~~Kxxoyw~Nw~BOxH~Nwx{_cb~NK{xoob?g_x{_cm~NK{xoxH~~ta@OxHDAh", "het_thio_666_A(13)" },
			{ "fcoaB@NA@DISLroToRkkSdcZcPA@ASEJtm@@GRNv{sBPrNPjMQFJhLzKmpFp !B?f`dsRSRV}HdtoxW^Jw~ZOyhILtdsUoRKKLLB@ANV}K~ErSRV}K~ZOegvHeBJuoMqLw~ZBSR", "het_thio_666_A(13)" },
			{ "fkaB@NQ@DYHhhhddiHdYDdleSdkZSPA@DTqRmKP@At`\\^|pdLaTZ`wIbjKNR{\\Il !B?f`dsRSRV}HdtoxW^Jw~ZOyhILtdsSRrV}HllppH@Dy[toxWIMI[toyh~Z_XbPKSV|wDs_yhIMH", "het_thio_666_A(13)" },
			{ "eg`XHH@NH`@cIEEEDdeIDliDdbeQqIYhePA@DTqTkRt@@GRDu]^xHabEHt`sDhrbjEclg[`VX !B?f`dsRSRV}HdtoxW^Jw~ZOyhILtdsSRrV}HllppH@Dy[toxWqOTdteoR?fcyi}bI@mM[s\\SM?f`dt`", "het_thio_666_A(13)" },
			{ "fbmaB@LR@DISJsJ}{|uXJ\\tu@t@@D@@_XQcLufx@X !Bm?vH?_y?mpJH@k]}m?w~@Ox@bOvw@k\\BmpJH?Oy??`BH_Xa}?g|", "het_thio_66_A(3)" },
			{ "dcnH`NT@aJYf_kiv`ZAH@H !BbGw~@H`B?g~H?K\\B?`BH_Xa}mww~_p", "het_thio_66_one(8)" },
			{ "f`i`B@G@BDifYYWEjUc^h@HHH``J`GuBQrIQZGX !B`C[}mtQkql@J[{|vhIjQ_zBZ\\|^`iWOGqlBH?[|v", "het_thio_676_A(10)" },
			{ "fhyaB@GA@DYHhhheDebKTkF}P@PPQPPEPCxaHyDh]` !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOt", "het_thio_676_A(10)" },
			{ "fhy`A@G@B@aFRJJJIQIXbuJqoT@DDDTDAT@~HRNQJGYn@V !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOt", "het_thio_676_A(10)" },
			{ "fhy`B@G@BLdTTTRbRqEjUc^h@HHHhHBhA|Pd\\bTNs\\@l !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOt", "het_thio_676_A(10)" },
			{ "fhyPB@GA@DYHhhheDebKTkF}P@PPQPPEPCzaHyDh]`\\@ !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOt", "het_thio_676_A(10)" },
			{ "f`i`B@G@BDifYYWEjUc^h@HHH``J`GuBQrIQZGX !B`C[}mtQkql@J[{|vhIjQ_zBZ\\|^`iWOGqlBH?[|v", "het_thio_676_A(10)" },
			{ "fhyaB@GA@DYHhhheDebKTkF}P@PPQPPEPCxaHyDh]` !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOt", "het_thio_676_A(10)" },
			{ "fhy`A@G@B@aFRJJJIQIXbuJqoT@DDDTDAT@~HRNQJGYn@V !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOt", "het_thio_676_A(10)" },
			{ "fhy`B@G@BLdTTTRbRqEjUc^h@HHHhHBhA|Pd\\bTNs\\@l !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOt", "het_thio_676_A(10)" },
			{ "fdePB@GA@DYHhhheDebQZeXwj@BBBJ``J`GuBQrIP{@qnDV !BdHheGxc}?`ClEw|Qb@Hvox`B[X|@DVvO?`A`IW|QbOrH?P", "het_thio_676_A(10)" },
			{ "f`i`B@G@BDifYYWEjUc^h@HHH``J`GuBQrIQZGX !B`C[}mtQkql@J[{|vhIjQ_zBZ\\|^`iWOGqlBH?[|v", "het_thio_676_A(10)" },
			{ "fhyaB@GA@DYHhhheDebKTkF}P@PPQPPEPCxaHyDh]` !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOt", "het_thio_676_A(10)" },
			{ "fhy`A@G@B@aFRJJJIQIXbuJqoT@DDDTDAT@~HRNQJGYn@V !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOt", "het_thio_676_A(10)" },
			{ "fhy`B@G@BLdTTTRbRqEjUc^h@HHHhHBhA|Pd\\bTNs\\@l !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOt", "het_thio_676_A(10)" },
			{ "fluPB@GA@DYHhhheDebXKTkF}P@PPQUA@U@ObDcdRav[QEiX !BdHheGxc}?`ClEw|Qb@Hvox`B[X|@DVvO?`A`IW|Qb@K~@Hc}", "het_thio_676_A(10)" },
			{ "fde`B@G@BLdTTTRbRu`mRl[u@AAAEPPEPCxaHyDhmFxAX !Bbi@BmvAZNyR@RWMGqlAhx|[@bj}DeHjoNyRH@gMG?`BH?P", "het_thio_676_A(10)" },
			{ "fluaB@GA@DYHhhheDebhKTkF}P@PPQUA@U@OlDcdRc\\Hl !Bbi@BmvAZNyR@RWMGqlAhx|[@bj}DeHjoNyRH@gMGqlC~@Hc}", "het_thio_676_A(10)" },
			{ "flu`A@G@B@aFRJJJIQIXjBuJqoT@DDDUPPEPC{AHyDhv`Kbp !Bbi@BmvAZNyR@RWMGqlAhx|[@bj}DeHjoNyRH@gMGqlC~@Hc}", "het_thio_676_A(10)" },
			{ "flu`B@G@BLdTTTRbRqTEjUc^h@HHHj``J`GvBQrIQm@WE` !Bbi@BmvAZNyR@RWMGqlAhx|[@bj}DeHjoNyRH@gMGqlC~@Hc}", "het_thio_676_A(10)" },
			{ "fluPB@GA@DYHhhheDebhKTkF}P@PPQUA@U@ObDcdR`N[aE` !Bbi@BmvAZNyR@RWMGqlAhx|[@bj}DeHjoNyRH@gMGqlC~@Hc}", "het_thio_676_A(10)" },
			{ "fde`B@G@BLdTTTRbRu`mRl[u@AAAEPPEPCxaHyDhmFxAX !Bbi@BmvAZNyR@RWMGqlAhx|[@bj}DeHjoNyRH@gMG?`BH?P", "het_thio_676_A(10)" },
			{ "fluaB@GA@DYHhhheDebhKTkF}P@PPQUA@U@OlDcdRc\\Hl !Bbi@BmvAZNyR@RWMGqlAhx|[@bj}DeHjoNyRH@gMGqlC~@Hc}", "het_thio_676_A(10)" },
			{ "flu`A@G@B@aFRJJJIQIXjBuJqoT@DDDUPPEPC{AHyDhv`Kbp !Bbi@BmvAZNyR@RWMGqlAhx|[@bj}DeHjoNyRH@gMGqlC~@Hc}", "het_thio_676_A(10)" },
			{ "flu`B@G@BLdTTTRbRqTEjUc^h@HHHj``J`GvBQrIQm@WE` !Bbi@BmvAZNyR@RWMGqlAhx|[@bj}DeHjoNyRH@gMGqlC~@Hc}", "het_thio_676_A(10)" },
			{ "fbmPB@GA@DYHhhheDebiaZeXwj@BBBJjB@j@_DIGHe@XvbKrp !BdHheGxc}?`ClEw|Qb@Hvox`B[X|@DVvO?`A`IW|QbOqDeL[_bOt", "het_thio_676_A(10)" },
			{ "fde`B@G@BLdTTTRbRu`mRl[u@AAAEPPEPCxaHyDhmFxAX !Bbi@BmvAZNyR@RWMGqlAhx|[@bj}DeHjoNyRH@gMG?`BH?P", "het_thio_676_A(10)" },
			{ "fluaB@GA@DYHhhheDebhKTkF}P@PPQUA@U@OlDcdRc\\Hl !Bbi@BmvAZNyR@RWMGqlAhx|[@bj}DeHjoNyRH@gMGqlC~@Hc}", "het_thio_676_A(10)" },
			{ "flu`A@G@B@aFRJJJIQIXjBuJqoT@DDDUPPEPC{AHyDhv`Kbp !Bbi@BmvAZNyR@RWMGqlAhx|[@bj}DeHjoNyRH@gMGqlC~@Hc}", "het_thio_676_A(10)" },
			{ "flu`B@G@BLdTTTRbRqTEjUc^h@HHHj``J`GvBQrIQm@WE` !Bbi@BmvAZNyR@RWMGqlAhx|[@bj}DeHjoNyRH@gMGqlC~@Hc}", "het_thio_676_A(10)" },
			{ "fj}PB@GA@DYHhhheDebihKTkF}P@PPQUTDAT@~pRNQJMxb|lk@ !BdHheGxc}?`ClEw|Qb@Hvox`B[X|@DVvO?`A`IW|Qb@IDeL[_?`BH?P", "het_thio_676_A(10)" },
			{ "flu`B@G@BLdTTTRbRudEjUc^h@HHHj``J`GqBQrIQZMhBxl !B`C[}mtQkql@J[{|vhIjQ_zBZ\\|^`iWOGqlBH?[|v?[^H?_rH", "het_thio_676_A(10)" },
			{ "fbmaB@GA@DYHhhheDebiAZeXwj@BBBJjB@j@_XIGHeFtQZV !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOw_v\\[_pLX", "het_thio_676_A(10)" },
			{ "fbm`A@G@B@aFRJJJIQIXjPViVMz`@``bj``J`GvBQrIQo@WEiX !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOw_v\\[_pLX", "het_thio_676_A(10)" },
			{ "fbm`B@G@BLdTTTRbRqT`mRl[u@AAAEUA@U@OlDcdRc^@nKRp !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOw_v\\[_pLX", "het_thio_676_A(10)" },
			{ "fbmPB@GA@DYHhhheDebiAZeXwj@BBBJjB@j@_DIGHe@\\vbKRp !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOw_v\\[_pLX", "het_thio_676_A(10)" },
			{ "flu`B@G@BLdTTTRbRudEjUc^h@HHHj``J`GqBQrIQZMhBxl !B`C[}mtQkql@J[{|vhIjQ_zBZ\\|^`iWOGqlBH?[|v?[^H?_rH", "het_thio_676_A(10)" },
			{ "fbmaB@GA@DYHhhheDebiAZeXwj@BBBJjB@j@_XIGHeFtQZV !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOw_v\\[_pLX", "het_thio_676_A(10)" },
			{ "fbm`A@G@B@aFRJJJIQIXjPViVMz`@``bj``J`GvBQrIQo@WEiX !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOw_v\\[_pLX", "het_thio_676_A(10)" },
			{ "fbm`B@G@BLdTTTRbRqT`mRl[u@AAAEUA@U@OlDcdRc^@nKRp !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOw_v\\[_pLX", "het_thio_676_A(10)" },
			{ "fj}PB@GA@DYHhhheDebiLKTkF}P@PPQUTDAT@~HRNQJ@qoDVeeX !BdHheGxc}?`ClEw|Qb@Hvox`B[X|@DVvO?`A`IW|QbOpeGv@eVfBH?P", "het_thio_676_A(10)" },
			{ "flu`B@G@BLdTTTRbRudEjUc^h@HHHj``J`GqBQrIQZMhBxl !B`C[}mtQkql@J[{|vhIjQ_zBZ\\|^`iWOGqlBH?[|v?[^H?_rH", "het_thio_676_A(10)" },
			{ "fbmaB@GA@DYHhhheDebiAZeXwj@BBBJjB@j@_XIGHeFtQZV !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOw_v\\[_pLX", "het_thio_676_A(10)" },
			{ "fbm`A@G@B@aFRJJJIQIXjPViVMz`@``bj``J`GvBQrIQo@WEiX !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOw_v\\[_pLX", "het_thio_676_A(10)" },
			{ "fbm`B@G@BLdTTTRbRqT`mRl[u@AAAEUA@U@OlDcdRc^@nKRp !BNGO_v_y?b@Imc~MhbGuG\\xc}_qDRcw|Qb@KFw~MhbOw_v\\[_pLX", "het_thio_676_A(10)" },
			{ "ffcPB@GA@DYHhhheDebiMAZeXwj@BBBJjhHBhA}`d\\bT[IEiYWU` !BdHheGxc}?`ClEw|Qb@Hvox`B[X|@DVvO?`A`IW|Qb@HeGv@eVfC~@Hc}", "het_thio_676_A(10)" },
			{ "fdeAB@C@BDieeew_daZ\\F`b@HHXH\\hA}IFDadBaTZbtN`L@ !BBn?|BBBenvl@MdX?jNqFOxQkQdB{Zpc}HIh`f`c|Qd@H?P", "het_thio_676_B(1)" },
			{ "dk\\h`LJcD@aJ[UUV{Sh@JeH@~aLw@L !BbOvw?_y?bOrH_Xa}bOpxCCaspMg@qaJO", "het_thio_67_A(1)" },
			{ "die@`Fx@cIEDdZZiVh@` !Bb@Jw@ox@bOw~@K_|b@JH?P", "het_thio_6_ene(2)" },
			{ "fdepb@LDhhp@aJ[UVYUYqw`qh@JfZhT@OnHsTVat^`LQc\\@L !BbGvw_Xc|?g~H_Xa}?g?~_xa}YuLXT}CRSk|ZGvT_UKo@fP", "het_thio_6_furan(4)" },
			{ "foQPB@HD@DYIEEEhblQgAV\\uThPCD@T@vQ`WhZbLLPp@ !B?@`?Idy?JpP@ScD@?W\\os]IPKF]w?@AN@DxlYp", "het_thio_N_55(5)" },
			{ "gF|HHZ@aJVqjjbhFk@hIBpbJb@ !BPEdq@OpHTMIw?@", "het_thio_N_5A(3)" },
			{ "deW@`Hi`BDiWVpjjjjLHCyAr\\jhNarNqqNisNypnep !BpJ[}bDz@UHRH@hc}b@K~@Hc}", "het_thio_N_5B(2)" },
			{ "dklh`Hped@cIDideBljfZVf@OdJE` !B_[\\kaM~filCOs[mTmpJfpOx@m?vw@k_}", "het_thio_N_5C(1)" },
			{ "dclh`HsaX@aJWY]pafeijY@H !BLW}@IeCM?G\\@L_qwU@Q@IeCMBOpH?P", "het_thio_N_5D(1)" },
			{ "deu@PDd@``aIemRXYZjZh@ujAHKATJQ@ !B]?posSD@JpQTAC|fYVAeXC|f", "het_thio_N_65A(3)" },
			{ "fbuQB@LJR@HRfvY_m]xHLZ@`nP@h@@~pbAQg@ !BbOw~@H`B?g~H?[]}bOw~_x`Bmww~_xa}bOvw__y??g~w__y?mwt", "het_thio_pyr_A(3)" },
			{ "dcMH`LjPBDifWWJjViV@OhJ@ !BTMHkACD@BOw|BG|qAEPH?ELXXFTH?P", "het_thio_urea_ene(1)" },
			{ "dknL@N@SrIQQJHi]ZPhB@CyA`xsFP !BmpJw?_y?mpJH?[]}m?vH@oy??g~w?[_}", "hydroquin_A(2)" },
			{ "dg}H@DpDeVUmQd{Z`@@@@OiRLbhZAaXvCbx@ !BmpJw_[\\Bmww~_{\\Bmwvw_[\\B?g~w_[_}?g|", "hzide_naphth(2)" },
			{ "fcPP@IJ@cltfyWUfYUU_xIp\\mjMh@JZ@@@bh`@CyrHIEHYGHeGhcBXKCXGB|w` !Bmww~_{\\B?`Bw_[\\BmpJw?[\\Bmwvw@l?MLX@kaFT_wzYTaM~YwyeeXFU`YQ}eGuRDUHQTn|BY", "hzone_acid_A(1)" },
			{ "fnsP`@IJ@aInUuVWYW`oAjuh@JYj`@D@CZCoDQFhmGh@ !BbGw~_x`B?`BH_X`Bb@JH?X`BbGvH@ha}tMINouR{pIgRsx@qTv_Rs}KOTv\\", "hzone_acid_D(1)" },
			{ "fakQ`@DDAPnQQJIIFIJEIQHTg^[ujej@BjfdP@vpFJ_TQCHy@he@ !B?`BH@k\\BbOtq`L?Mb@K_ibnDbOw~_xc|bGvH_X`B?g~w?_y?m?tqo|?Rwydknp", "hzone_acyl_misc_A(1)" },
			{ "fi{Q`@DDARnQQJIIKSIPiJIBexOQmTmT@EUMH`AmbJ\\~hbFQrIQk@ !B?`BH@k\\BbOtq`L?Mb@K_ibnDbOwMtOy?bOrH_Xa}b@K~_{_}?g~w?SF?s}K_fRn{", "hzone_acyl_misc_A(1)" },
			{ "fi{Q`@DDARnQQJIIPsIPiJIBexOQmTmT@EUMH`AmbJ\\~hbFPJIQk@ !B?`BH@k\\BbOtq`L?Mb@K_ibnDbOw~@Oy?bOrH_Xa}b@K~_{_}?g~w?SF?s}K_fRn{", "hzone_acyl_misc_A(1)" },
			{ "fegQ`@DDAQnQQJIIQZEJEIQHT`qGMjejh@JjZQ@C[B\\e}QDLbTZpv@ !B?`BH@k\\BbOtq`L?Mb@K_ibnDbOw~@LwP?g~H?Ha}bGvH@oy?m?w~_{_}L[?Otm~YJ{l", "hzone_acyl_misc_A(1)" },
			{ "ff}pP@DDhAqZiLljo\\k}KPTmPHPDDS@@GpdPrNPJIQjHyV@ !B?`BH@k\\BbGw~@K]}b@Jw@k\\BbGvw__y?bOrw?Xa}bGw~_x`Bm?vw?Oy?", "hzone_acyl_misc_B(1)" },
			{ "f`qP`@DD@KHheDhbddkSoMPL@@@@GpdPrAQJCQZGQz@ !B?g~H_[]}b@K~_{\\BbGvH?[]}mwvw@k_|mwvw?[\\B", "hzone_acyl_naphthol(22)" },
			{ "deW@@@bTkYWxY`@`@~ZHJJahzIp !BbOvw?[_|mww~@K_|m?s~@K_|", "hzone_anil(14)" },
			{ "fdiIB@LLyz`@aJWmVUvlzfZX@J`DNWpdXJEQjCQZ@yG@ !BmpJH@k]}bGw~_x`BbGvH@ha}?g~H?Ha}bGvH@ha}b@K~_p", "hzone_anil_di_alk(35)" },
			{ "fdiI@@DDexBSJjmkmYsUMH@U@HTmdTyxVLYBhuAhm@\\c` !B?`BH@k\\BbGvw_X`BmpJH_[]}?g~H?Ha}bGvH@ha}b@K~_p", "hzone_anil_di_alk(35)" },
			{ "fhqp`@DD\\CbSJkrnqkMRt@EPBEKxSHyDhUFhMGlC` !B?`BH@k\\BbGvw_X`BmpJH__y?bOrH_Xa}b@JH_X`B?g|", "hzone_anil_di_alk(35)" },
			{ "dg\\`@@bmReVuveYi@BhBHonRFchFI`|o@ !BmpJH@k]}bGvw@oy?bOrH_Xa}b@JH_X`B?g|", "hzone_anil_di_alk(35)" },
			{ "doH@LHpRUUe]evjX@J`HJ~THbDrhzAbXVKq|@ !Bb@JH_X`BbGvH@ha}?g~H?Ha}bGvH@ha}b@K~_p", "hzone_anil_di_alk(35)" },
			{ "fnkP@@@PrQIQQIQQZIHyWkASTkYh@@@@@@@@CzDH@ !Bb@Jw@ha}mwvH?Oy??g~w@ha}bGvw_Xa}mww~@Oy?mpK~_?y?mpJw?Hc}?`@", "hzone_anthran_Z(1)" },
			{ "gN|@AJeZtsPGrdZLpp !BmpJH@hc}b@K~@Hc}", "hzone_enamin(30)" },
			{ "diG@@@cdkZZYj`CZL}DQfF` !BmpJH@hc}b@K|m?vw?`BH?P", "hzone_enamin(30)" },
			{ "gNu@JpdsltpGvDJGFXH !B?g~w?Xc}mpJw?[\\B", "hzone_enamin(30)" },
			{ "diEH@NDLbbdqfjX@vaOHDCFXB@ !B?g~w?Xc}mpK|m?vwm?vw@`", "hzone_enamin(30)" },
			{ "dk_H`LIi@HRf_VWJtzYffi@OjJNaXvC` !BK|uT^ty?]?s}]w_}]?qw?R?RLW|k^s}Y", "hzone_furan_A(6)" },
			{ "dgH`LIi@HRf_VUrmNfYijd@~hhzE`xo@ !BK|uT^ty?]?s}]w_}]?qw?R?RLW|k^s}Y_tx", "hzone_furan_A(6)" },
			{ "dgH`LIe@HRf_YmrcnfYjZd@~hhgM`xn@ !Bs|uTntz?mpI}m{_}mpJw?_x@s}Hqorn{wyd", "hzone_furan_A(6)" },
			{ "foAqB@LDXh@PeL~sZxhZuLsTuR@GuBQKMQZGX !Bs|uTntz?mpI}m{_}mpJw?_x@s}Hqorn{wyf?S`", "hzone_furan_A(6)" },
			{ "dgH@FzpRf_VUrcnfV`@`@~iHrBbhz@ !BtLtknsF?b@HBmxc}b@JH?Xc|?g~H_Xa}?g|", "hzone_furan_B(2)" },
			{ "foAq@@NB\\CIEELThdlTlzfYh@H@CzfHIEHY`h@ !BtLtknsF?b@HBm{}NbOvH@hc}bOs~_xa}bGw~_p", "hzone_furan_B(2)" },
			{ "foAq@@FB\\CIEDh\\hdbTlziVh@H@CzbHIEHy`h@ !BtLtknx`BL[|Bmxc}?`BH@hc}bOs~_xa}bGw~_p", "hzone_furan_B(2)" },
			{ "f`qq@@NR|CIEEEKeDdRcoUKMP@P@GuBQRFXKIP !BtLtknx`BL[|Bm{}NbOw~@H`BbOvH?Oy?bGvH__y?", "hzone_furan_B(2)" },
			{ "ek`TD@@O@`DDfyV{]VYeU~ICKAmecf`BFjZ`@@@P@@v`t|PaBdFPy@ !Bs]B?SbpXs]B@LRpXKAcMtH@q@hc_ibnDLXBw@k]}mpJw__x@?g~w@k\\Bb@Jw_[]}?`C~@K\\Bb@H", "hzone_furan_C(1)" },
			{ "flyPP@KN@`J\\bfbRaRRRfxIh@Iiih@CZBoXQChc` !Bm?s~@K_}mpK~_{_}mww~_{\\Bmwvw@k]}mpJw_[\\B?`Bw_[\\B", "hzone_furan_E(1)" },
			{ "foAP@@@PReVumYJlzZP@@@@CxTHYGHeFhMEh]@ !BbGvw_X`BmpJH__x@m?vw@k\\Bm?w~@K\\Bm?s~@@", "hzone_naphth_A(5)" },
			{ "foAPB@DX@DIJkJvleV\\tp@@@@A|IDLcdRcTFbtN` !BmpJw_[\\Bmwvw@ox@m?vw@k\\Bm?w~@K\\Bm?s~@@", "hzone_naphth_A(5)" },
			{ "deUH@AdLbbbRK]@PL@GtA@ !Bmww~_{_|mwvH?[]}m?rH@hc}", "hzone_phenol_A(479)" },
			{ "deUH@AdDfUuih@I`@~`H@ !BbOvH@oy?bOvH?_y?bOvH@hc}", "hzone_phenol_B(215)" },
			{ "fjmQ@@HF@eJrsJjsnrDmMT@PAP@@GsdXSNXJIPjMQZGQzHxgLpV@ !Bm?vH?[\\Bb@K~@K_}bOvw@hc|?g~w@h`B?`C~@K_}mww~@Hc}bOrw?@", "hzone_phenone(7)" },
			{ "ff}Q@@HFAdbRbTTRRRbs]dIZZh@`B``@CzrLIgLEDhUFhmCh}D\\SfXwBk@ !Bm?vH?[\\Bb@K~@K_}bOvw@hc|?g~w@h`B?`C~@K_}mww~@Hc}bOrw?K_}", "hzone_phenone(7)" },
			{ "ff}QB@AYTBHRYWYYU_ZcOQ`@f``bj@@OkHcDDbdZ`tVqtArLIpnUp !B?g~w?Xc}?g?~_xa}?g~H?[_}b@K~_{\\BbOvw?[]}b@Jw?Hc}b@K~@Hc}", "hzone_phenone(7)" },
			{ "fncQB@AETBHRYWYYU]^hstX@IhHHjh@@~LbLPRJQjCQ[GPGDyWFynFV !B?g~w?Xc}?g?~_xa}?g~H?[_}b@K~_{\\BbOvw?[]}b@Jw?Hc}m?vH@ox@bOt", "hzone_phenone(7)" },
			{ "fbuQ@@H\\AdbRbTTTRRN|fNZZh@h@@@@~lcBXJIPjMP[KXzOPFDqf@ !BmpJH@k_}bOw~_{\\Bb@JH_[_}m?w~@Ox@bOw~_?y?mpJw@k_}?`@", "hzone_phenone(7)" },
			{ "fjmQ@@H\\AdbRbTTTRRNOdqsSU@E@@P@A|YFDpTRaTZ`vVqt^`LIc\\Bl !BmpJH@k_}bOw~_{\\Bb@JH_[_}m?w~@Ox@bOw~_?y?mpJw@k_}?`Bw@`", "hzone_phenone(7)" },
			{ "fjmQB@AITBHRYWYYU_jL}F@BZBBJ`@CxrHqAHiFhMEl]@\\cF\\K` !B?`BH?K\\B?`C~@K\\B?`BH@k\\BbOvw?_x@b@Jw@k\\BbOw~@H`B?`BH?P", "hzone_phenone(7)" },
			{ "ff}QB@AITBHRYWYYU]ZcOQ`@f``bj@@OmHcDDbdZ`tVqtApnUs\\Ll !B?`BH?K\\B?`C~@K\\B?`BH@k\\BbOvw?_x@b@Jw@k\\BbOw~@H`BmpK~@Hc}", "hzone_phenone(7)" },
			{ "fdyH@@@PYsIDhhhhTdmXOhsTp@@@@@_FaCHy`heBhuAhmChCDX@ !BbGvw_X`B?g~w@ox@bGvH_[_}mww~@Oy??g~w@k\\Bm?w~@@", "hzone_phenone(7)" },
			{ "fleH@@@PYsIDhhhhTdl[A}FZf@@@H@@~uBFQsAQJEQjCQZGPFMpRp !BbGvw_X`B?g~w@ox@bGvH_[_}mww~@Oy??g~w@k\\Bm?w~@K\\B", "hzone_phenone(7)" },
			{ "fleHB@AJCDDPdrnrrkMF^S@AMA@p@@_ZQFHIEHUFhMChCD\\S@ !B?`BH?K\\B?`C~@K\\B?`BH@k\\BbGvw__x@b@Jw@k\\B?`BH__x@", "hzone_phenone(7)" },
			{ "fbuHB@AJCDDQdTRVTRbRTUhsrX@IhHFH@@~TbLPRJPjMPZGPFHynFV !B?`BH?K\\B?`C~@K\\B?`BH@k\\BbGvw__x@b@Jw@k\\B?`BH__x@mpH", "hzone_phenone(7)" },
			{ "foA`@@@IKLrjzkF]M@@@@@A|jDTad\\`TRaTZbtN` !BmpJw__y?mpJH?[]}mww~@Oy??g~w?K_|mww~@@", "hzone_phenone(7)" },
			{ "f`q`@@@YDhhhddlUVLzZ@@@H@@~eBJPrNPJIPjMQZMp|p !BmpJw__y?mpJH?[]}mww~@Oy??g~w?K_|mww~@K_|", "hzone_phenone(7)" },
			{ "f`q`B@C@bDfUvYWhqwh@JP`@@CzRHqAHiDhUFhmGh@ !B?`Bw?H`B?`C~@H`B?`Bw@h`Bmww~@Ha}m?rw?Ox@", "hzone_phenone(7)" },
			{ "fhi`B@C@bDfUvYWzL]z@BdHB@@OaHcDDbdRaTZbt[`E` !B?`Bw?H`B?`C~@H`B?`Bw@h`Bmww~@Ha}m?rw?Ox@m?p", "hzone_phenone(7)" },
			{ "deW@@@`Tie_xYjjh@~YHsBrh[Np !BbOvw?_y?bOrw@ha}bGvH@ha}", "hzone_pipzn(79)" },
			{ "dig@@@`dkYeaffi@OljF`X@ !B]?pH?@c}TMIN_uQ{IdA@VP", "hzone_pyrrol(64)" },
			{ "fhypB@LDX@HRf_VYWqSUoAifZ`PJHBhAmBwaH`d\\aTFat^`LQaZF@ !BK|uT^ty?]?s}]w_}]?qw?SE?K}H?VUQ{JwmeGvT_UGl", "hzone_thiophene_A(11)" },
			{ "fdeqB@LDYX@QdbbvRbbbQqSS`qifZ`dBb@j@[P]xRHIGHMEk}@XcDXNa`@ !BK|uT^ty?]?s}]w_}]?qw?SE?K}H?VUQ{VT@k^vT_YQ}T^p", "hzone_thiophene_A(11)" },
			{ "fdepB@LDX@HrQQ[IQQQHxijpXtsMPLAQ@U@MhV|IDDcdFav^`LQbLKPp@ !BK|uT^ty?]?s}]w_}]?qw?SE?K}H?VUQ{JwmYPFT_YQ}T^p", "hzone_thiophene_A(11)" },
			{ "foAP@@@PReVV]yZlzZZ`PH`R`FtM^eBDQRNPJEPZKPzHpuC@ !B]?pH?G_}BOuw?ECRSg}w?UQ{FfA@VT@fPBXZX@", "hzone_thiophene_A(11)" },
			{ "f`qQ@@IFAdTRbRRQRIQVij`Pi`a``FtD^dBvQrAPjMPZGQzHpQC@ !BAEQ@VSD@?@aPtg_|PBXZXG_}FfA@Ig_|]?uw?G_}", "hzone_thiophene_A(11)" },
			{ "f`qP@@@PrQIJIQSHrt{ttu@pDPIPCZFoRaBHi@hUAlmCh}DXZa`@ !B]?pH?G_}BOuw?ECRSg}w?UQ{FfA@VWlkPBY@Iai`", "hzone_thiophene_A(11)" },
			{ "fdyh@@@PhZJTjrrkoKS`sSTBaCDBT@vakwHPbNPjKPz@qFFhX@ !B]?pH?G_}BOuw?ECRSg}w?UQ{FfA@VW_|PBY@Ig_}FfAw?@", "hzone_thiophene_A(11)" },
			{ "flei@@IF\\EHLbbTRRRJRRIQVij`PifPa``FtD^xBvQrAPjMPZHpQC@ !BAEQ@VSD@?@aPtg_|PBXZXG_}FfA@Ig_|]?uw?G_}]?qw?W_|", "hzone_thiophene_A(11)" },
			{ "fleh@@@PiYNRIIQJJIHkRuzLtu@rDLPIPCZFo\\aBHUAl]GhcDXZa`@ !B]?pH?G_}BOuw?ECRSg}w?UQ{FfA@VWlk]?q@Id@f]?tZXG_|", "hzone_thiophene_A(11)" },
			{ "fhiX@@@PQbcDi]UfU}V|EiijA@b@j@[Pm{eHyBhMCh}@XcBtL@ !B]?pH?G_}BOtH?@c}BOpH?UCRSg}T^qi`PEe@Id@fFf@", "hzone_thiophene_A(11)" },
			{ "fdyY@@IF]xLPYEDhdddTdbTUjZhDJY`a``FtD^xBvQrAPjMPZHpQC@ !BAEQ@VSD@?@aPtg_|PBXZXG_}FfA@Ig_|]?uw?G_}]?qw?P", "hzone_thiophene_A(11)" },
			{ "fdyX@@@PQbcLdRrRTTTRNkAbttu@pDPEPCZEo\\iGHMCl}@XcDXVa`@ !B]?pH?G_}BOtH?@c}BOpH?UCRSg}T^qi`PEe{Jt@fPBXZX@", "hzone_thiophene_A(11)" },
			{ "dg}@`Fx@aJY}YWJNzYZ@B@CzdcHJJch@ !BtLtknsF?b@HBmxc}b@JH?Xc|?g~H_Xa}?g|", "hzone_thiophene_B(4)" },
			{ "foAPB@NB@DYHhdbeDebegTsM@A@HLojH`dTafB` !BtLtknsF?b@HBmxPkbOvH@hc}bOs~_xa}bGw~_p", "hzone_thiophene_B(4)" },
			{ "fdeP@@@TrQQQQEJKKDiipXmSA@@AA@e@NhDoHACHb@B@ !BJpQPtg|q?@`q@@c}sR}SFLuP_sE?LW}NKAaSFLuPsU@lF@", "imidazole_A(19)" },
			{ "die@`JD@aJUmxZijPCjFoYFIaX !BBOqw?@c}]?uPtdy?UGm@VP", "imidazole_B(2)" },
			{ "fjcPB@IAAbYEDeLheELdcQfgAcdl@EUTB`EDND@~lbLQRNPKMXZKQzHpfLpV@ !BgzWYwslTgzV_iSlTdW~?RXc}E~O}m}CRSg~_fl[_UGm@fSmkNvoFwp", "imidazole_C(1)" },
			{ "fbmH@@@XIqJYgeUo_CKASejfBP@@`@CzALsAT !BU@S|]uCMVTCMKt@fBOplYw|qABlH?\\tosR}`Fed?_sDDJpPkVS|", "imidazole_amino_A(1)" },
			{ "diE@@@cIEDTijY@OlRJahvfLf !Bb@Jw@ox@bOvw?[\\Bm?vw@`", "imine_ene_A(5)" },
			{ "dk]H@BxDeYVux]Mfi@B@CzD` !Bm?rw?[_|?`Bw_[_|m?rw?_x@m?rw?Ox@", "imine_ene_one_A(3)" },
			{ "dmuH@FDDfUubiiYj`CzNcZRuX !B`CETa@JwtLw@ih`BbOvH@ox@bOt", "imine_ene_one_B(1)" },
			{ "deu@@@EJYU\\kidHD`@r`W@ !B?W]@VUQ{OueN_vT_YQ|H?S}Y", "imine_imine_A(9)" },
			{ "day@@@aJWVVY@OlRBbh@ !B@Fq?[@@S_qM?[G|S_vp", "imine_imine_B(3)" },
			{ "dct`@@birQQQXjSUKT@_TVM`pn[` !BbOvw?X`B?g~w@oy?bOvw?[\\Bm?w~@@", "imine_imine_C(3)" },
			{ "f`qa@@M@rJJJJIPx|Djt@P@qH@A|HDTcdBbTJ`vV` !B?g~w_Xa}?g~w?H`B?g~H_[]}m?vH__x@mpJH@ha}", "imine_naphthol_A(1)" },
			{ "gGP@DjZY`MdcEI@A`J@C@ !Bb@K~_{\\B?`BH?P", "imine_one_A(321)" },
			{ "daxD`HP@cIHXhmK@FrTtTi@A`Y@A`@ !B?`BH?[_}mpK~_?x@m?t", "imine_one_A(321)" },
			{ "dg\\h@BinAIfuyT{ZZh@@@~KLjFch@ !BbGw~_xc|bGvw_X`BmpJH_Xc|?g~H_Xa}?g|", "imine_one_B(4)" },
			{ "doH@Bi`RYmUm[]ijd@@Hq~sLjF` !BbGw~_xc|bGvw_X`BmpJH_[]}bOs~_xa}bGw~_p", "imine_one_B(4)" },
			{ "gOq@@dsI[TrAmmWEZFBh@L@ !B]?posSD@JpQYOs|f", "imine_one_fives(89)" },
			{ "dmNH`Lx@aJYm\\jeZXDB@CJL\\ !BLXC@f[_|tMHBbOrwil@@?`C~?K\\", "imine_one_fives_B(9)" },
			{ "dk]@@@qJYVwV{SZfd@@@r`Gm@q`XX@ !BbOvw?Tz?tMJw?LBYUKnfpOrw@Ox@?orw", "imine_one_fives_C(2)" },
			{ "gOyHJpDISKkTk@[Pqaa`@ !BSg|?Ib?MBOw}]ud?", "imine_one_fives_D(1)" },
			{ "dcoH@DhPRYYUrY]ZfH@@CfB` !BIc|k^uCM?G\\H?CE?YQ|H?UQ{UGmeGp", "imine_one_isatin(189)" },
			{ "deWL@DrPXTfUgkfjYX@` !BbGw~_xc|bGvH__y?bOrH?Hc}", "imine_one_sixes(27)" },
			{ "difH@BAIfUXXHD@CJB_tA@ !BbOs~@Ha}m?rH?H`Bm?vH_P", "imine_phenol_A(3)" },
			{ "dmN@@@RfYWraVPhHbJHCjJoXv]DqnIX !BwzYNowvw?XcOsXc}_?y??ig_?X`", "indol_3yl_alk(461)" },
			{ "dcn@@@RifuzZ]ZifjXj`NdBj|VYvSBqnEX !BLP@osPc}U@P?IblDVS}eXFU`_sD?I`", "indol_3yl_alk(461)" },
			{ "dcn@@@RfYU\\h]dJBbHh`NhjmB~ShfHplLEXdVxe` !BJ{oPsPJw_?xqox`B?[_}mxPkbOu??`", "indol_3yl_alk(461)" },
			{ "dk^@@@RifuVfdvjYjibj@zPJjt[{LrXVHqlLEXTVxU` !BJ{oPsYg@_?xBmsF?b@K}m?vwaBnH?PJw", "indol_3yl_alk(461)" },
			{ "dcm@@@UJYeUravPhJHbb@zbkvMGQL[bV !BJ{oPsPJw_?xqox`B?[_}mxPkbOu??`", "indol_3yl_alk(461)" },
			{ "dk]@@@uJf[UZZSZifjfJhCi@joEf]Dpl[aV !BJ{oPsYg@_?xBmsF?b@K}m?vwaBnH?PJw", "indol_3yl_alk(461)" },
			{ "foAP@@@VrQQQIJHgEAFdJBhj@@zaR}qd\\bTJsVVav[aI` !BJ{oPsPJw_?xqox`B?[_}mxPkbOw~@G?~b@JH?P", "indol_3yl_alk(461)" },
			{ "f`qP@@@NrRJJYIQDtYJsULuUT`At`ER|KF\\bTJcVFqt^s\\EL !BJ{oPsYg@_?xBmsF?b@K}m?vwaBnH?_x@@k^H@hc}", "indol_3yl_alk(461)" },
			{ "dg~@@@RifUWIenhFPd`@~jhfEc\\nLpd !BTMIN_w_|UGlZXDAY^rmw?T@fPB[RKq|ZFf@", "indole_3yl_alk_B(1)" },
			{ "dmLD@@eIfUTfEV``R@CnLX !B]?pq@B?MOrYTABlDYVAeXG|qU@P", "keto_keto_beta_A(68)" },
			{ "gOt`DPtfWMZi`Nyf !B]?posSD@JpP?IluP", "keto_keto_beta_B(12)" },
			{ "dclD@@UIfYWIiuhFBH@OhV@ !B@D{|BEQ{PEeeXECRVS}TAEPDBOueX@", "keto_keto_beta_C(7)" },
			{ "gJP`@TeVXCyZC@ !B@Fp@DpAl@AL", "keto_keto_beta_D(5)" },
			{ "dmTB@@keRY{mZZfPCxdbhzA` !BmpJw?_x@mpK~@K_}?g~w@k_}mpH", "keto_keto_beta_E(1)" },
			{ "dedD@@[HhihbtuV@_EfUCQv@ !B?g~w?Xc}mpK~_?x@m?vw?[_}", "keto_keto_beta_F(1)" },
			{ "dkL`@@`UrQJIFKJZfZd@~jHKJr\\V@ !Bm?vH?[\\Bb@K~_{_}bOvH@oy?bOvH@hc}", "keto_keto_beta_zone(1)" },
			{ "dclD@@UIfV][iuhJAH@Nxq` !BbOw~_xc|bGvw?Xa}b@K~_?y?bGvw?P", "keto_keto_gamma(5)" },
			{ "dg|D@@gHhiheEBI{[P@P@@A}Dp !BmpJw?_x@?g~w?Hc}mwvw?X`B?g?~_{\\Bm?t", "keto_naphthol_A(2)" },
			{ "dg~H@ICHhiheEBI{[P@P@@A}Dx !BmpJw?_x@?g~w?Hc}mwvw?X`B?g?~_{\\Bm?t", "keto_naphthol_A(2)" },
			{ "fgAa@@A@RYfUWHrQmVZ@@@H@@v`X !B]?pq@B?MOrYTABlDYQ}eXFU`Oud?VUPDYQ|", "keto_phenone_A(11)" },
			{ "fgAa@@E@RYfUWHrQmVZB`XhXXhAmBp !B]?posSD@JpQeGs|fU@P?VS}YYVAeXFT_U@P", "keto_phenone_B(1)" },
			{ "flm@`@@NrJJJIIJIYDcIFuzJV`@@B@H@@OhN` !B]?pq@B?MOrYTABlDYQ}eXFU`Oud?VUPDOrYTAFT_YVAeXC|f", "keto_phenone_C(1)" },
			{ "fnkQ@@DD@drrkOMjoHuoIjUkTBE@@@@P@A}AD@ !B?g~H?[_}b@K~_{\\BbOvw_[]}tMINo{\\BUKlZXLBYJ{o@ilBfFa|ZGqi`J{l", "keto_phenone_zone_A(2)" },
			{ "dg|H`A@HrQQQJIEYVwSALDP@_YvSax !BSk?_il?MbOw}m?vHf]?~_x`B_?y??hc}?X`", "keto_thiophene(3)" },
			{ "difH@AAIfU[hBB@Cz@c\\Tp !BbOs~@Ha}bOrw?H`BbGvw?P", "mannich_A(296)" },
			{ "dg~D@J@|dTRbRNU\\JtDQCT@GuIaPt]ex !BbOrw@ox@bGw~@Hc|mpJH?K\\BbGvw_[\\Bmwt", "mannich_B(1)" },
			{ "dk^L@JCSRfVU~nEZBHbh@OjSBah{Ip !BbGw~@H`B?g~H@ha}?`BH__x@?g?~_xa}", "mannich_catechol_A(1)" },
			{ "fa{I@@FBlxBTs{KLn}kbfkARwmLt@AA@@P@@_RQFHIeHYChsCX{@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH?P", "melamine_A(3)" },
			{ "figI@@FBlxBTs{KLn}jxijpTm{SM@@PP@E@@A}IDX`fTadNcL]`^@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH?Xa}", "melamine_A(3)" },
			{ "figIB@NRUZh@aIeWYVUU{ZLLyI^c`@h@``bZ@P@~DbFQrKPGFqvAqn@F !BmpK~@K]}m?rw?K]}mww~_xc}m?w~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "fewH`@FBlx@tigvVY]{U|TuXJV}if`@HH@Bh@@OiHcDDrdLatYclS` !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH?Xc}?g|", "melamine_A(3)" },
			{ "figi@@FBlxXDigvVY]{UqSU`i[vfZ@@``@J@@CxRHqALiCH]FX{FxCX !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH?Xa}", "melamine_A(3)" },
			{ "figI@@FBlxBTs{KLn}kxijpTm{SM@@PP@E@@A}IDX`fTadNcLM`^@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH_X`B", "melamine_A(3)" },
			{ "fewI@@FBlxBTs{KLn}jnJZlEK^tsP@DD@AT@@GtdQbBYRFPzLpOIx !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH_Xa}b@H", "melamine_A(3)" },
			{ "fewIB@AJtyh@aIfWvUeU^ugK^sT\\xBB`BBBIhA@CxULy@h]D\\{@xgFx@X !BmpK~@K]}mpJH@k_|mwvw__y?bOvw__y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fmoH`@FBlx@tigvVY]{UWEMVBeoZYh@BB@@j`@@~dbLPSJPrGQfIxn@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH_Xc}b@K~_p", "melamine_A(3)" },
			{ "fewi@@FBlxXDigvVY]{U\\TuXJV}if`@HH@Bh@@OaHcDDrdLatYb^[`M` !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH_Xa}b@H", "melamine_A(3)" },
			{ "figIB@NRUZh@aIe]YVUU{ZLLyI^c`@h@``bZ@P@~DbJQrKPGFqvAqn@F !Bmww~_{\\Bmwvw_[_|mww~_xc}mww~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "fewIB@AJtyh@cHhhdThdhddeidseoYjN\\AAPAAADt@`A|JfL`TNbN]`\\Sc\\@L !Bmww~_{\\BmwvH_[]}m?rw__y?bOvw__y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fewIA@AJtyh@``PdsN{JrjoZseoYjN\\DAPAAADt@`A}sdBatQslCb\\[PAdX !BmpK~@K]}b@Jw@k_|mwvw__y?bOvw__y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fmoHb@IZMxgPAFQQQIEJIJIIIZYLDxIVsWAAE@DDDSPB@GpfQrIQzDxNIpnMp@p !Bmww~_{\\BbOvw_[]}?g~w?K]}?g~H?[]}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fewiB@BBUisPABSL~lkJj}kNV}fhypPE@DDDSPB@GwFPJGQGNpNIqm@FQ` !Bmww~_{\\BbGvw_[]}m?rw__y?bOvw__y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fewH`@FBlx@tigvVY]{W\\TuXJV}if`@HH@Bh@@OiHcDDrdLatYalS` !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH_X`B?`@", "melamine_A(3)" },
			{ "fmoH`@FBlxDtigvVY]{U_EMVBeoZYh@BB@@j`@@~dbLPSJPrGQfAxn@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH_Xa}b@K~@@", "melamine_A(3)" },
			{ "fmoHb@IZMxgPAFQQQIHjIJIIIZYLDxIVsWAAE@DDDSPB@GpnPJIQzDxNIpnMp@p !BmpK~@K]}b@Jw@k_|?`Bw_[]}?g~H?[]}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fcI`@FBlx@yiSOllr{vjkbfkARwmLt@AA@@UT@@GtdQbBYRFPzLpnMp !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH_Xc}b@K~_?x@", "melamine_A(3)" },
			{ "fmoh`@FBlxXIiSOllr{vj~JZlEK^tsP@DD@AU@@A|IDX`fTadNcLKc\\Al !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH_Xa}b@K~@@", "melamine_A(3)" },
			{ "figi@@FBlxXDigvVY]{WqSU`i[vfZ@@``@J@@CxRHqALiCH]FX[FxCX !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH_X`B", "melamine_A(3)" },
			{ "fewi@@FBlzXDigvVY]{U\\TuXJV}if`@HH@Bh@@OaHcDDrdLatY`^[aM` !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH_Xa}b@H", "melamine_A(3)" },
			{ "fewiB@BBUisPABSL{lkJj}kNV}fhypPE@DDDSPB@GwNPJGQGNpNIqm@FQ` !BmpK~@K]}b@Jw@k_|mwvw__y?bOvw__y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fmoh`@FBlzXAiSOllr{vjnJZlEK^tsP@DD@AU@@A|IDX`fTadNcLKc\\Il !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH_Xc}b@K~_p", "melamine_A(3)" },
			{ "fewY@@FBlx\\pISOllr{vjxijpTm{SM@@PP@EP@@_\\QFHIeHYChsFtC\\v !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bb@JH_Xa}b@H", "melamine_A(3)" },
			{ "figI@@FBlxBTs{KLn}rxijpT}GSM@@PPAA@@A}IDX`fTadNan]`\\@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@hc}", "melamine_A(3)" },
			{ "fewI@@FBlxBTs{KLn}r~JZlEOQtsP@DD@PT@@GtdQbBYRFPzFxNIx !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@hc}bGt", "melamine_A(3)" },
			{ "fewIB@NJtyh@aIeU^UeU^vcK^sT\\x@J`BBBIhA@CxRHy@l]D\\{@xgFx@X !BmpK~@K]}m?rw?K]}mwvw?Oy?bOvw?_y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fmoH`@FBlxDtigvVY]{eEMVBghzYh@BB@HJ`@@~dbLPSJPrGPwApn@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@hc}bOw~_p", "melamine_A(3)" },
			{ "fewi@@FBlzXDigvVY]{e|TuXJ^cif`@HH@`h@@OaHcDDrdLatMp\\[aM` !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@hc}bGt", "melamine_A(3)" },
			{ "fewI@@FBlxFRJKYQJJIYZZIGEMVBghzYh@BB@HJ@@CzRHqALiCH]C\\{D|@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@hc}b@H", "melamine_A(3)" },
			{ "fmoI@@FBlxBTs{KLn}r{bfkASt]Lt@AA@DEP@@_RQFHIeHYCh[d|W` !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@hc}bGvH@`", "melamine_A(3)" },
			{ "fmoIB@AZM{h@aIfWWeYUWmYqpRmfn@`j@HHHf`D@OaTpTRstIp\\Sa\\[`A` !BmpK~@K]}m?rH@k_|mwvw_[_|?g~H?[_}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fcH`@FBlxDtigvVY]{euqSU`izNfZ@@``BBj@@CzRHqALiCH]C\\Wfx@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@hc}bOvH@oy?", "melamine_A(3)" },
			{ "fmoi@@FBlzXDigvVY]{ewEMVBghzYh@BB@HJ`@@~DbLPSJPrGPwEynDv !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@hc}bGvH@`", "melamine_A(3)" },
			{ "fewIB@AJtyh@aIeUvUeU^vcK^sT\\x@J`BBBIhA@CxRHy`h]D\\{@xgFx@X !Bmww~_{_|mwvw_[_|m?rw__y?bOvw?_y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fmoIB@IZM{h@aIfW]eYUWmYqpRmfn@`j@HHHf`D@OaTpVRctIp\\Sa\\[`A` !Bmww~_{_|mwvH_[]}m?rw?K]}?g~H?[_}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fmoIA@AZM{h@``PdsNkrljkvlxxIVsWA@U@DDDSPB@GwAQKOPgAqNEqm@FQ` !BmpK~@K]}b@Jw?K_|mwvw_[_|?g~H?[_}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fcHb@EFlD`pABSLj~rljkvlEzM^kwAAEPAAADt@`A|KdRqTAcNSa\\[c\\@L !Bmww~_{_|bOvw_[]}?g~w?K_|mww~_xc}m?w~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "fmoiB@BRt[wPABSLz{JrjoZsc`e[M\\DAT@PPQM@H@_\\Edh}B\\GDxWFt@YF !Bmww~_{_|bGvw_[]}m?rw?K]}?g~H?[_}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fmoH`@FBlxD|dTVrbTTRrttRJqSU`izNfZ@@``BBh@@OiHcDDrdLatMslK` !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@ha}b@JH_P", "melamine_A(3)" },
			{ "fcH`@FBlxBtigvVY]{ewqSU`izNfZ@@``BBj@@CzRHqALiCH]C\\gfx@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@ha}bGvH@ha}", "melamine_A(3)" },
			{ "fcHb@IFlD`pABSLj{rljkvlEzM^kwAAEPAAADt@`A|KdRaVAcNSa\\[c\\@L !BmpK~@K]}b@Jw@k_|bGvw_[]}m?s~_xc}mww~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "ek`RL@@FAKG@IedigvVY]{eu\\JMK@dnajYh@BB@HJj@@@~dPcBBLhabGHZsZCh@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@ha}bOvH@oy?bGt", "melamine_A(3)" },
			{ "fch`@FBlzXEiSOllr{wKobfkASt]Lt@AA@DET@@GpdQbBYRFPzFynMpfp !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@ha}bGvH@ha}", "melamine_A(3)" },
			{ "fewi@@FBlzXLdTVrbTTRrttRNJZlEOQtsP@DD@PT@@GpdQbBYRFPzFyvMpfp !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@hc}b@H", "melamine_A(3)" },
			{ "fmoi@@FBlyXDigvVY]{ewEMVBghzYh@BB@HJ`@@~DbLPSJPrGPwIynBv !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@hc}bGvH@`", "melamine_A(3)" },
			{ "fmoiB@BBt[wPABSLzoJrjoZsc`e[M\\DAT@PPQM@H@_\\EDl}B\\GDxWFt@YF !BmpK~@K]}b@Jw?K_|mwvw_[_|?g~H?[_}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fch`@FBlyXIiSOllr{wKkbfkASt]Lt@AA@DET@@GpdQbBYRFPzFynMpVp !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@hc}bOvH@oy?", "melamine_A(3)" },
			{ "fmoY@@FBlzZpISOllr{wKnJZlEOQtsP@DD@PU@@A}qDX`fTadNan[QMkX !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?X`Bm?rH@hc}bGvH@`", "melamine_A(3)" },
			{ "figIB@BRUZh@aIfU{VUU{VBLyI^c```@``bZ@P@~DRFPJKPGFqvAqn@F !BbOw~_x`BmwvH?Xc}?g~H@hc}m?w~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "fewIB@BRTyh@aIfUyWeU^u`k^sT\\xHHBBBBIhA@CxQHYFl]D\\{@xgFx@X !BbOw~_x`BmwvH?Xc}?g~H@hc}m?vH__y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fewIA@BRTyh@cPPdsJ|krjoZpUoYjN\\DDAAAADt@`A}pdLatQslCb\\[PAzX !BbOw~_x`BmwvH?Xc}?g~H@hc}m?vH__y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fmoHb@BRU{WPABSLkrjsjoZpU`e[M\\DDAAPPQM@H@_BICH]GhS`xgBxw@C@ !BbOw~_x`BmwvH?Xc}?g~H@hc}m?vH?_y??g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fewiB@BRUisPABSLkroJj}kAV}fhypPPDDDDSPB@GwBPrGQGNpNIqm@Gi` !BbOw~_x`BmwvH?Xc}?g~H@hc}m?vH__y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fewIB@BJtyh@cHhhddhThddeidpUoYjN\\DDPAAADt@`A|HdBbVNbN]`\\Sc\\@L !BbOw~_x`BmwvH?Xc}?g~H@h`BbOvw?_y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fmoIB@BJu{h@aIfUV]yUWmXIpRmfnBBHHHHHf`D@OaDbVFstIp\\Sa\\[`A` !BbOw~_x`BmwvH?Xc}?g~H@h`BbOvw?Xa}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fmoIA@BJu{h@`pPdsJkN|jkvlDxIVsWAADDDDDSPB@GwBQKOPgAqNEqm@FY` !BbOw~_x`BmwvH?Xc}?g~H@h`BbOvw?Xa}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fcHb@BJtDppABSLjlzlzkvlDzM^kwAADDEAADt@`A|HdRstAcNSa\\[c\\@L !BbOw~_x`BmwvH?Xc}?g~H@h`BbOvw?Xc}?g?~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "fmoiB@BJt[wPABSLjl{rjoZpS`e[M\\DDPPPPQM@H@_\\IDl}B\\GDxWFt@Yf !BbOw~_x`BmwvH?Xc}?g~H@h`BbOvw?Xa}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fewIA@BJtyh@bPQdTTRRTJTRRRtrXJwluGNBBH@``bZ@P@~xRAPzHyvAqNMh@yL !BbOw~_x`BmwvH?Xc}?g~H@h`BbOvw?_y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fmoIA@BJu{h@bPPdsJkN|jkvlDxIVsWAADDDDDSPB@GwBP[OPgAqNEqm@GI` !BbOw~_x`BmwvH?Xc}?g~H@h`BbOvw?Xa}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fmoIC@IZM{h@``PHHRYgWYVUU{V\\\\DkYk``J`BBBIhA@Cydh}B\\GDxWF|@YFI` !Bmww~_{_|bGvw_[]}m?rw?K]}?g~H?[_}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fcHa@EFlD`pAD`aIfU_YVUU{VB}FoU{``bh@``bZ@P@~yrEPFLyNEqnMh@yL !Bmww~_{_|bOvw_[]}?g~w?K_|mww~_xc}m?w~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "fmoiA@BJt[wPAD`aIfUV]yUWmXIpRmfnBBHHHHHf`D@OfDctIp\\Sa\\[pArYf !BbOw~_x`BmwvH?Xc}?g~H@h`BbOvw?Xa}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fmoHb@BJuzWPABSLjmkrjoZpS`e[M\\DDPPPPQM@H@_BI@hMGhS`xgBxw@C@ !BbOw~_x`BmwvH?Xa}?g~H@h`BbOvw?Xa}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fcHb@BJtFPpAFQQQIIQIHqIIKSI`oQku^xHH`hHHHf`D@OaD`vV`LYr\\Kc\\[`A` !BbOw~_x`BmwvH?Xa}?g~H@h`BbOvw?Xa}bGw~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "fcHa@IFlD`pAB`aIfU]yVUU{VB}FoU{``bh@``bZ@P@~yrIPFLyNEqnMh@uL !BmpK~@K]}b@Jw@k_|bGvw_[]}m?s~_xc}mww~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "ek`RLH@BEMHiCI`@aIfUVUWgU^u`SqIh[XzBBHJB``bZ@P@OaBHl`JHhJqZMhNc\\@C@ !BbOw~_x`BmwvH?Xa}?g~H@h`BbOvw?Xc}bGw~_?y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fchb@BJtXLa`BLbbbRRbRQbRRVfSA^cWj}pPQAPPPQM@H@_\\IEhCF\\gBxwFt@Yf !BbOw~_x`BmwvH?Xa}?g~H@h`BbOvw?Xa}bGw~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "fewiB@BRUisPAFQQQIIPiQIIKSI`k^sT\\xHH`BBBIhA@C{aHEChcgXGDxv`Cdp !BbOw~_x`BmwvH?Xc}?g~H@h`BbOvw?_y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fmoiB@BRUkwPABSLjl{rjoZpS`e[M\\DDPPPPQM@H@_\\IAl}B\\GDxWFt@\\f !BbOw~_x`BmwvH?Xc}?g~H@h`BbOvw?Xa}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fmoiA@BRUkwPAA`aIfUV]yUWmXIpRmfnBBHHHHHf`D@OfDctIp\\Sa\\[pArYf !BbOw~_x`BmwvH?Xc}?g~H@h`BbOvw?Xa}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fchb@BRUhIa`BDfYUYuYuWmXItZ}WnBBHHJBBIhA@C{aH}@XsdxWFxv`Cdp !BbOw~_x`BmwvH?Xc}?g~H@h`BbOvw?Xc}?g?~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "fmoYB@BRUhwn`BDfYUYweU^u`gAJvZxHH````bZ@P@~XROPgAqNEqo@GIfX !BbOw~_x`BmwvH?Xc}?g~H@h`BbOvw?Xa}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fewH`@FBlxETigvVY]{e\\TuXJ^sif`@HHBBH@@OiHcDDrdLat]`\\S` !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`@", "melamine_A(3)" },
			{ "fmoH`@FBlxETigvVY]{eWEMVBglzYh@BB@`b`@@~dbLPSJPrGPNIpo@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`C~@@", "melamine_A(3)" },
			{ "fmoHb@NZMxWPABSJjkZrjo[Qc`e[M\\@ET@PPQM@H@_BQGHUGhS`xgBxw@C@ !B?g~H?[]}?g?~_{_}mww~_?y?bGvH?[_}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fcI`@FBlxEUyHhmeDhheeihdd\\TuXJ^sif`@HHBBJ`@@~dbLPSJPrGPNIqn@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`C~@H`B", "melamine_A(3)" },
			{ "fmoh`@FBlyXJiSOllr{wJnJZlEOYtsP@DDAAE@@A|IDX`fTadN`\\Sc\\El !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`C~@@", "melamine_A(3)" },
			{ "fmoH`@FBlxE\\dTVrbTTRrttRQqSU`i{NfZ@@``HHh@@OiHcDDrdLat]`\\Kp !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`BH@`", "melamine_A(3)" },
			{ "fcH`@FBlxETigvVY]{eWqSU`i{NfZ@@``HHj@@CzRHqALiCH]@xWf|@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`C~@H`B", "melamine_A(3)" },
			{ "fcHb@AFlFPpABSLnjvljkvlyzM^kw@PUPAAADt@`A|JfBcTAcNSa\\[c\\@L !B?g~H?[]}?g~H@oy?m?vw__y??g~H_Xc}m?w~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "ek`RL@@FAKG@JedigvVY]{eW\\JMK@dnijYh@BB@`bj@@@~dPcBBLhabGHFc[Ch@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`C~@H`Bb@H", "melamine_A(3)" },
			{ "fch`@FBlyXJiSOllr{wJobfkASv]Lt@AA@PQT@@GpdQbBYRFPzAqoMpVp !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`C~@H`B", "melamine_A(3)" },
			{ "fmoHb@AZM{gPABSJjoJrjo[Qc`e[M\\@ET@PPQM@H@_BQ@heGhS`xgBxw@C@ !Bmwvw?Oy?mwvw?_y??g~w_Xa}?g~H?[_}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fcHb@IFlDPpABSLnkrljkvlyzM^kw@PUPAAADt@`A|JfRaTAcNSa\\[c\\@L !Bmwvw?Oy?mww~@K_}?g?~_{]}bGw~_xc}m?w~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "fcHa@IFlDPpAA@aIf]UyVUU{V\\}FoU{``Jh@``bZ@P@~yJEPFLyNEqnMh@rL !Bmwvw?Oy??`Bw_[_}?g?~_{]}bGw~_xc}m?w~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "ek`RLH@EKGHbII`@aIfU]^UeU^u`PIIh[XzBBJh@``bZ@P@OaNHTcRHhJqZMhNc\\@C@ !Bmwvw?Oy??`Bw_[_}b@K~_?y?mwvH__y?bOvw?_y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fchb@BRMXHa`BDfYuWeYUWmYstZ}WnB@j`BBBIhA@C{dhU@XsdxWFxv`CHp !Bmwvw?Oy??`Bw_[_}?g?~_{]}bGw~_xc}m?w~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "fcI`@FBlxEUyHhmeDhheeihdblTuXJ^sif`@HHBBJ`@@~dbLPSJPrGQvAqn@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`BH@ha}", "melamine_A(3)" },
			{ "ek`RL@@FAKG@JmdigvVY]{eW|JMK@dnijYh@BB@`bj@@@~dPcBBLhabGHFa[Ch@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`C~@H`BbGt", "melamine_A(3)" },
			{ "ek`RLH@IKGHbEI`@aIfU]VueU^u`PIIh[XzBBJh@``bZ@P@OaNHd`rHhJqZMhNc\\@C@ !B?g~H?[]}b@K~_?y?bGvw?[]}?g?~_xa}bOvw?_y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "eghRB@@FAKG@JemdigvVY]{eWWBcRpIKjZfZ@@``HHjh@@CzQBLHHrbFH\\`ZChn` !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`C~@H`Bb@JH_P", "melamine_A(3)" },
			{ "ek`ZL@@FAKGE`JmdigvVY]{eW|JMK@dnijYh@BB@`bj@@@~DPcBBLhabGHF`zMpKL !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`C~@H`BbGt", "melamine_A(3)" },
			{ "fmoh`@FBlyXJyHhmeDhheeihdcbfkASv]Lt@AA@PQP@@_BQFHIeHYCh{@xwA[@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`BH@`", "melamine_A(3)" },
			{ "fch`@FBl{XJiSOllr{wJobfkASv]Lt@AA@PQT@@GpdQbBYRFPzApoMpvp !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`C~@H`B", "melamine_A(3)" },
			{ "fchb@BBMXLa`BDfYuUmYUWmYstZ}WnB@j`BBBIhA@C{`hu@XsdxWFxv`CHp !B?g~H?[]}b@K~_?y?m?vw__y??g~H_Xc}m?w~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "ek`ZL@@FAKGM`JedigvVY]{eW\\JMK@dnijYh@BB@`bj@@@~DPcBBLhabGHF`zMp[L !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`C~@H`Bb@H", "melamine_A(3)" },
			{ "fcX`@FBly^pURf_YYewnU_EMVBglzYh@BB@`bh@@OnHcDDrdLatCcZEo[@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy?bOw~@Oy?bOrH@ha}?`C~@H`B", "melamine_A(3)" },
			{ "figi@@FBlzhDigvVY]{gqSU`izNfZ@@``HB@@CxRHqALiCH]GXGFxUX !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@hc}", "melamine_A(3)" },
			{ "fewi@@FBlzhDigvVY]{g\\TuXJ^cif`@HHB@h@@OaHcDDrdLatCb^[aU` !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@hc}bGt", "melamine_A(3)" },
			{ "fewiB@NBUisPABSJj|kJj}mFV}fhyp@U@DDDSPB@GwDQrGQGNpNIqm@FI` !BmpK~@K]}m?rw?K]}mwvw?Oy?bOvw?_y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fmoh`@FBlzhIiSOllr{wN~JZlEOQtsP@DDA@U@@A|IDX`fTadN`\\Kc\\Jl !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@hc}bOw~_p", "melamine_A(3)" },
			{ "fewY@@FBlzlpISOllr{wNxijpT}GSM@@PPDAP@@_\\QFHIeHYChGFtU\\v !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@hc}bGt", "melamine_A(3)" },
			{ "fewi@@FBlzhDigvVY]{g|TuXJ^cif`@HHB@h@@OaHcDDrdLat]b^[aU` !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@hc}b@H", "melamine_A(3)" },
			{ "fmoi@@FBlzhDigvVY]{gWEMVBghzYh@BB@`J`@@~DbLPSJPrGQOEynEV !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@hc}bGvH@`", "melamine_A(3)" },
			{ "fmoiB@ARt[wPABSLnoJrjoZsc`e[M\\AAT@PPQM@H@_\\i`h}B\\GDxWFt@\\f !BmpK~@K]}m?rH@k_|mwvw_[_|?g~H?[_}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fch`@FBlzhIiSOllr{wNkbfkASt]Lt@AA@PET@@GpdQbBYRFPzEynMpjp !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@hc}bOvH@oy?", "melamine_A(3)" },
			{ "fmoY@@FBlzlpISOllr{wNnJZlEOQtsP@DDA@U@@A}qDX`fTadNa^[QUsX !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@hc}bGvH@`", "melamine_A(3)" },
			{ "fewiB@NBUisPABSJklkJj}mFV}fhyp@U@DDDSPB@GwDPJGQGNpNIqm@Gq` !Bmww~_{_|mwvw_[_|m?rw__y?bOvw?_y??g~H_[]}m?vH@oy??g~H_[_}Sk?PtlBYUKl", "melamine_A(3)" },
			{ "fmoiB@ARt[wPABSLn{JrjoZsc`e[M\\AAT@PPQM@H@_\\idh}B\\GDxWFt@Xf !Bmww~_{_|mwvH_[]}m?rw?K]}?g~H?[_}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fmoiA@ARt[wPAA@aIf]WeYUWmYqpRmfnB@j@HHHf`D@OfBctIp\\Sa\\[pAd\\f !BmpK~@K]}b@Jw?K_|mwvw_[_|?g~H?[_}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fchb@IJMXIA`BDfYU}eYUWmXKtZ}WnBBJ`BBBIhA@C{gHU@XsdxWFxv`Cdp !Bmww~_{_|bOvw_[]}?g~w?K_|mww~_xc}m?w~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "fmoYB@BBehwn`BDfYuvUeU^ugGAJvZxHBh@``bZ@P@~YJOPgAqNEqo@FQbX !Bmww~_{_|bGvw_[]}m?rw?K]}?g~H?[_}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fmoh`@FBlzhIiSOllr{wOnJZlEOQtsP@DDA@U@@A|IDX`fTadNclKc\\Jl !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@ha}b@JH_P", "melamine_A(3)" },
			{ "fch`@FBlzhEiSOllr{wNobfkASt]Lt@AA@PET@@GpdQbBYRFPzIynMpjp !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@ha}bGvH@ha}", "melamine_A(3)" },
			{ "fchb@IJMXIA`BDfYUweYUWmXKtZ}WnBBJ`BBBIhA@C{gHe@XsdxWFxv`CTp !BmpK~@K]}b@Jw@k_|bGvw_[]}m?s~_xc}mww~_?y?bGvw_[_}b@K~_?y?bGvw?Tz?tMK@fUR{", "melamine_A(3)" },
			{ "ek`ZL@@FAKGJ`IedigvVY]{gU\\JMK@dnajYh@BB@`Jj@@@~DPcBBLhabGHv`zMpUL !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@ha}bOvH@oy?bGt", "melamine_A(3)" },
			{ "fcX`@FBlzlpKRf_YYewn]_EMVBghzYh@BB@`Jh@@OnHcDDrdLat[cZJn[@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@ha}bGvH@ha}", "melamine_A(3)" },
			{ "fewY@@FBlzlpISOllr{wOxijpT}GSM@@PPDAP@@_\\QFHIeHYCh{FtU\\v !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@hc}b@H", "melamine_A(3)" },
			{ "fmoY@@FBlzjpISOllr{wNnJZlEOQtsP@DDA@U@@A}qDX`fTadNb^[QUkX !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@hc}bGvH@`", "melamine_A(3)" },
			{ "fmoYB@BBehwn`BDfYu^UeU^ugGAJvZxHBh@``bZ@P@~XJOPgAqNEqo@FQrX !BmpK~@K]}b@Jw?K_|mwvw_[_|?g~H?[_}?g?~_xa}mwvw?X`B?g?~_xa}m?uNo}CRpIeTnp", "melamine_A(3)" },
			{ "fcX`@FBlzjpSRf_YYewn]WEMVBghzYh@BB@`Jh@@OnHcDDrdLat[cZJm[@ !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@hc}bOvH@oy?", "melamine_A(3)" },
			{ "fmoy@@FBlzlu`Rf_YYewn]\\TuXJ^cif`@HHB@j@@CybHqALiCH]F|U\\vm` !BLXC@f]CRmpHBbK]}mpK~@K]}m?rw@oy?m?w~@K_}m?vH@oy??`BH?[_|b@JH@hc}bGvH@`", "melamine_A(3)" },
			{ "f`aY@@DTYIV`IKMkOLJST@EUP@GuBP[KX{OX !BmpJw?[\\B?g?~@K_}mpJw@k]}?`Bw?[\\BbOs~_{\\B", "melamine_B(1)" },
			{ "fhi`P@J@PPvQSRISIQHbUxKUUTL@DLT@~pbFY[@ !Bm?vw@oy?mwvH_[_|?g?~_x`BbOvH?Xc}?`C~_?y?bOt", "misc_aminal_acid(1)" },
			{ "fdiab@JBdh@QdbrbTTlRV|FjjY`@bAJ@_JabNqaHiDhMEh]GhwBK@ !Bm?vH?[\\Bm?vw@oy?m?vw_Xc}?g~w@ox@m?vw@k\\Bm?vw@`", "misc_aminoacid_A(1)" },
			{ "fjuP`@DN@GHhdheDebidmVZhHaJZd@CyRHqeLyDhUeh]D\\S` !BbOvH@oy??`Bw_[\\Bb@K~_?x@m?w~@K_}b@JH@hc}?g~H@hc}b@JH?P", "misc_anilide_A(1)" },
			{ "f`aQB@IFtCDrJIJIESITY@AUMT@A}IDXcfBrTFbvNsv@ !Bb@K~@Hc}b@JH@ha}?`BH_X`BbOw~_x`BbOvH@hc}", "misc_anilide_B(1)" },
			{ "feg`P@C@iTZTwJnrJvIV\\UmAA@PT@QT@@GudXRFPKMPZKQ{hpfBqwIx !BmwvH_[\\B?g?~@K_}m?vH?Oy??g~w?Xa}m?w~_?y?m?vw@oy?m?vw_[\\B?g~w_[]}?g|", "misc_anisole_A(1)" },
			{ "ff}a`@F@tGHhhdeEMLdlbHrRmAATAPQ@@GplXRJPJEY{LyW@ !B?g~w?Xc}mpK~_x`Bm?vw?_x@bOvw?Oy?mpJH@ox@m?w~@Ox@mpJH@ox@", "misc_anisole_B(1)" },
			{ "fjuq`@DX\\@pTfUeUmVuUfjBBbji@@~tbLQSFQrAXjMYzD}g` !B?`BH@k\\BbGvw_Xc|?g~w@ha}bGvw_Xc|?g~w@ha}bGvw__x@?g~w@`", "misc_anisole_C(1)" },
			{ "fbuaR@EPQJNPAFRRERZUQIYK`oAVfih@Jh@CxgLEbhS` !BbGvH?Mvw?XcBmyn[?`Bw@e}zAi?kfwi_Wwj[fyn[Wwj[fwi_fyl", "misc_cyclopropane(1)" },
			{ "fakaP@N@txoTifwvWYVwELu[vfZjjh@bhhJhA|HfLpVRqTFrvMp !BtMHkaCF@bGtBbK|qb@KMtHa}b@K~@Ha}bOrH@ha}bOs~_xa}bGu`Foy?KF]`YP", "misc_furan_A(1)" },
			{ "fi{QA@BuDBHsDILklljnmmQghm{@AUAAEMTB@GwdQbBQRNPkMPZKXzOPGFqvA| !Bb@JH__x@b@JH@ox@b@JH__x@b@Jw@hc|bGw~@Ox@b@JH@ha}?`ANo}CRpIeTnz[@", "misc_imidazole(1)" },
			{ "figH`@EZLxBLbbTRRbbRjRRRe[p\\ezMjBAhj@@@@@C{FhMcl@ !B?g~w_Xa}mpJH?Oy?mwvH_Xa}s}Hqoxc|?g?~_rn{wye??gvw?[]??g?~?[_}mw?~", "misc_naphthimidazole(1)" },
			{ "fmwIb@HDhzHy`BDiYygU~yegAK^znej``bXHFH@@~IsAYkIp !BJ{oPsPJwL[~H@lwObOw~@BqgosFH@lwOs\\~H?[|qb@K~@Hc}?g~H?K_}bGvH__y?mpJH@`", "misc_phthal_thio_N(1)" },
			{ "f`aQ`@DFAjvQQJJIFIYQfhJBJ`@OaH`dTad\\pVN{w@ !Bb@JH__x@b@JH@k\\B?`BH__x@?`BH@k\\BmpJH__x@", "misc_pyridine_OC(1)" },
			{ "fbuP`@DR@YIefY^]_WhiZ`jBheR`R`GqdPRFQsAXjMQZGQzHpf@ !B?`BH@k\\BbOw~@K_}b@K~_xc|mpJw@hc}ShCPs[]}b@K@ieRDbOt", "misc_pyrrole_benz(1)" },
			{ "ffcpB@LFR@HRf^WeU~WEGAKVfZhHHfjFAJ@]Ps^xbBPsNYKOXfOx`d` !BtLtknsF?b@K|mxc}?`CMsx`BKF^?LXc}s\\?Msx`BosFH?]CRSk}Tn|BY", "misc_pyrrole_thiaz(1)" },
			{ "f`aA`@@HedTtTRbQREijjfjU@CzbHqAHigL@ !B?`Bw@hc|?`BH?[\\BbOrH?K_}?`BH_Xa}b@K~_xc}", "misc_stilbene(1)" },
			{ "dkLD`ML@aJVeUjZiU`CzC` !Bb@Jw@hc}m?w~@Oy?b@Jw@k\\Bm?w~@Hc}", "misc_trityl_A(1)" },
			{ "facQ@@DXAdTTRRdVaRRfTbUjjjhHJE`@OkX`fTsfBptVat^rLEan]sZEOS@ !B?g~H_[]}b@K~_{\\BbGvH_[]}_X`BbH`B?g~w@ha}mwvw_X`B?g~w@ha}bGvw_P", "misc_urea_A(1)" },
			{ "dk}@@@iJYYvzXUtzB@@H@CT`E@bDX` !Bb@Jw@ox@bOw~@K_|b@JH@ox@bOw~@H`B", "naphth_amino_A(25)" },
			{ "dk}@@@iJYYvzXUtzB@@H@Cy@bhwBL !Bb@Jw@ox@bOw~@K_|b@JH@ox@bOw~@H`B", "naphth_amino_B(25)" },
			{ "dk}@@@aJVUVrXUtz``@@@Cz@bi@JAHJa@ !B?g~H?Ha}bOw~@H`Bb@JH@hc}?`BH?X`B", "naphth_amino_C(2)" },
			{ "dk@@@aDiVUVJiuSj`@@@@MR@TBPVB@ !BbGw~@H`BbOs~@Hc}?`BH@h`Bb@JH?_x@", "naphth_amino_D(2)" },
			{ "f`i@`@@JRYeeVugIVMyhDB@b@@OhNp !B?`Bw@h`B?`Bw__x@b@Jw@k\\Bb@K~@Ox@mwvH_[\\B", "naphth_ene_one_A(1)" },
			{ "fluaC@DvAHHdLRFQRFJIQIJERT[pXuTa@HAP@A@ !B?K^w?_rwbOrH__x@bOs~_xc|?`BH_Xc}?`BH?Oy?bOrH_Xc}", "naphth_ene_one_B(1)" },
			{ "foQP@@@VRYeggfBehsf`P@H`@B !BbOrH__x@bOs~_xc|bGw~@Ha}bOs~_x`BbGw~@@", "naphth_ene_one_C(1)" },
			{ "fleAR@HHqEH@cIHUEEDdelc^\\EZh@@@h@@~QFDp !B?`BH_[]}mpJw__x@?g~w@k\\Bb@Jw?[_}?`C~@K\\Bb@Jw?_x@", "phenol_sulfite_A(1)" },
			{ "fj}aP@D@TgI\\bbbbbRRrQbhpwgQZh@P@aj@@Of\\`TZat^cL@ !BFa}SYvAe_?xlY?y?b@K}bGvwYQ~H?Xc}_?y??hc|b@I}m?x@bOu??`", "phthalimide_misc(2)" },
			{ "dcoH@NgPrQQHqKYTkSMRuPq@]Puxd`ljMp !BUGlos_uw@DyN_}Ho?W]@VUQ{Sg|H?P", "pyrazole_amino_A(1)" },
			{ "dmL``LFU@HRf^yraVfVjd@zckr]Dx !BTMHkACD@BOw|BECRSg}T^rY@PEd", "pyrazole_amino_B(1)" },
			{ "dk^@@@rRJJJIMatz`Y`H@MhKtMFtyrp !BbGtq`L?MbOs~_}~faEPkaIg_bGvH__y?", "pyrrole_A(118)" },
			{ "dg~@@@rRJJJIXlNwTCLBP@[PWhZMqK@ !BABmN@C}YXAiYOr?RBOs}BLtoABlDJpc}VS|", "pyrrole_B(29)" },
			{ "dif@@@rRJJDfjYf@OlJFclwFL !BS`@?VPPkK}HH?OtHsR|H?P", "pyrrole_C(8)" },
			{ "dmw@`Dq`BDf]fQUjijPCydcHKN`XV@ !B?g~H?[_}b@JH?]CRSk}Tnz[@pId", "pyrrole_D(5)" },
			{ "dcn@@@RifYVE]jYfjPC[BW_YTM@qFEa`vgNV !BBOtosSD@TMIN_rlDVS|?I`QTUGm@VP", "pyrrole_E(5)" },
			{ "dcm@@@kHeEDhTwKoMSRt@[PwlFEcXcCPp@ !BVS}YOr?MUGmw?Dy??W\\osSD@JpP?I`", "pyrrole_F(5)" },
			{ "dcm@@@wIHhdd\\wRmPJAP@_\\dYAPt]Dqn@ !BbGwOsSF@bOs~_rnDwzZH_Xa}?g~H_P", "pyrrole_G(4)" },
			{ "dk]@@@EIYWYV{SX@JeH@~[HZIaXvC` !BmpJw?_y?m?rw_[_}mpJw?SF?s}K_fRn{", "pyrrole_G(4)" },
			{ "deu@@@YJe{ZXYZjZd@` !B?`Bw?Xc}m?rw?K_}f\\B{UK}N", "pyrrole_H(3)" },
			{ "dmNH@BAIfV^fzViZjPCyAq\\@ !B_sG}]rlDSg|?Ib?MK|tH?_uwVS|", "pyrrole_I(2)" },
			{ "dk^DPNtpBJBLdTRTrLrfzifjZ`C{Dp\\g@ !BpJXqopJwUHSPs\\BftLvYpHPkb@JH?_x@", "pyrrole_J(1)" },
			{ "foA``@B@PdwJkZlyYsTuP@H@GtdPRJQKEQjCQZGP !BmpK~@K_}s}Hqorn{wyf?SlwOTv_MtK}Not{Mt@", "pyrrole_K(1)" },
			{ "dg^D@JADfVvW^EjZZjhz`Nhz}qYTSbynGeyDTP !B?g~w?Xc}mpINo}CRpIeTnz[@tl~@SeMgKF\\", "pyrrole_L(1)" },
			{ "dg}H@HHLbRbbTJWB]sST@B@GqAEQtC@ !BBOtH?@c}TMIN_rY@UGm@VWmTXAhfPBY@XAh", "pyrrole_M(1)" },
			{ "dg~@@@rRJJIqIDqwTsP@P@_SdEEPt]Dpl[Ap !Bs}Hqox`BJ{nYpM~YaBnH_Xc|?g~H_Xa}?g|", "pyrrole_N(1)" },
			{ "dknH@FCHhihhlVEijZf@Od{Ep !B?g~w?Xc}s}Hqorn{f\\C_fXPkot{Ms{|q", "pyrrole_O(1)" },
			{ "daD@@DjuzYji`CYHzJQCAtLETpQB@ !BmpJH?Oy?bGvH__y?bGt", "quinone_A(370)" },
			{ "fhe``@O@ldsLrj|pRgFC[sPSATLc@A@ !BUxK~HE^}UxHh`e^BR[}Wo_x`?b@oiP~MKyhh`nOXXW|", "quinone_B(5)" },
			{ "fb}a`@K@SeIfYeV_}deNLGtV`@`HbfB@CzBXkPPcB\\HHfb@ !BbGw~_xc|bOvw?Xc}?`C~_xc|?g~H?Hc|bGvw_Xa}?`BH@hc|bGt", "quinone_C(2)" },
			{ "daD@@Dj[vzYj`CYDJJIC@TLEThSB@ !B?`BH?[_}bOrw@k\\Bm?t", "quinone_D(2)" },
			{ "gOyDLpDHHRY\\ujf@{aX !B]?posSD@JpP?IluP", "rhod_sat_A(33)" },
			{ "fleQB@DXT@HrJJJJKJKHzcGAZj`XaI`@MbZ}EObLsfVqL_qAN@ !BId@kAECR_sG|BCD@BOuSFLtosU@H?G|qteA?LPc}sR|H?@c}", "rhod_sat_B(3)" },
			{ "foAPb@LDEH@QdbbRRTJQJV]SUJ@D@A}AF@ !BTMHkA@c}LPC|B@c|AESMT@c}VTA`YPQTAEQ`YP", "rhod_sat_C(3)" },
			{ "fleQb@BVpHp@aJYmVy]rT}FfjXFBFHHhA}aDLrt@ !BwzYNo|wP_[_OsXc}osFYwx`Bs\\}SFOx@bOv?L[|qb@ISFHc}", "rhod_sat_D(3)" },
			{ "fa{Pb@BTqH@QdbbfRTTrTRtUHsvTe[vfjd@@@@HBBJ@_HQEH@ !BJ{oPs[}N@k^H@cF?s\\?~@HPkKF^?L[_|b@KMs|wO?`Bw__x@osFH@k_|m?rw_P", "rhod_sat_E(1)" },
			{ "dk^HPDd@a`aIfV]z[SZjA@`@~cL@ !BnrmNo}~fbGwOsWvwbOs~_yg_bGvH__y?", "rhod_sat_F(1)" },
			{ "fj}Pb@LDEh@PeLjlv|{dhzNRtuRC@@A@@GtDX !BpJY}bHPkShATaIg_b@JYpHPkGvW~@Ha}f]~Ywxc|?g|_YXa}bGw~_p", "rhod_sat_imine_A(1)" },
			{ "flm@`@@FRYVun]VcIZ]zJVfjjZjjh@H !BbGw~_xc|bGvH_Xc|?g~H_Xa}bOs~_?x@bOvH__y?im~DJx@q", "steroid_A(2)" },
			{ "fhy@@@LdbbbTRbqU[WgAi@H``H@@` !BE~rn_xc|gzWFpCmkhJVH?SlT]V|{EL[_os[Fw|[@hJT", "styrene_A(13)" },
			{ "f`i@B@@ABTsLjotyJvgT@P@aP@A}Bt[`A` !B?`BH?X`Bm?rH@oy?bGw~@Ox@bOvH?X`Bm?s~_xc}", "styrene_B(8)" },
			{ "f`i@@@LdbbbTRJOIBL{tDdA@D@@_PEFx\\X !BbGvw__x@?g~H@k_|?g~w?K]}bOvH?_x@?g?~_xc}", "styrene_B(8)" },
			{ "fhy@A@@Q@`aIe[YU^cIZ|F@Bib@@@Cn@f !B?g~H?[]}?g?~_{]}bGw~_?y?b@JH_Xc}bGw~_?y?bOt", "styrene_B(8)" },
			{ "fhy@B@@QBSJwKN}NJuxL@QLD@P@G\\EL !B?g~H?[]}?g?~_xa}mww~_x`B?g~w_Xc}bGw~_?y?bOt", "styrene_B(8)" },
			{ "fhy@B@@ABTsLjomNRmiu@D@HU@@GZ@LK@ !B?`BH_X`Bm?rH@oy?bGw~@Ox@bOvH?X`Bm?s~_xa}?`@", "styrene_B(8)" },
			{ "fhy@@@LdbbbTRrUyHQoA`d`H`H@@{QqvX !BbGvw__x@?g~H@k_|?g~w?K]}bOvH__x@?`C~_?y?bOt", "styrene_B(8)" },
			{ "foQ@A@@AF@aJYV[wXKdkNjZhDA`@H !Bbj?|bAOgXBV@MlrgZNr~_tRkqlBH?VAZXEkFp@", "styrene_C(4)" },
			{ "f`i`@@@ILk[JkQ`iN}@ATa@@@Gr@Xj@ !BFa}@VRm{Fa|ZGrm{TLw|]sE?BOqeGuQ{BOuT^vT_", "styrene_anil_A(1)" },
			{ "dcM@@@qJUuepfffe`CzhaHJJqh@ !BJxQ}m|?MwzZw@k_}mpJw?_x@mpJH?@", "styrene_imidazole_A(1)" },
			{ "dknLpLaN@HvPNPrRRqQZJUV``J@CiMS_Xt]BqEMJPbLRlLiBHqJp !B_[\\BbHa}mpK~@K_}bOrw@k\\Bm?w~@K_}", "sulfonamide_A(43)" },
			{ "dmvL`LaE@HrREQIXYV`@`@~SHV@ !B?`BH?[_}mpK~@K]}m?rw@k]}m?p", "sulfonamide_B(41)" },
			{ "fbm`R@LPQ{H@cIIBhhddmLeiu`irmP@@DUA@AmBOjX`TRbtIrLHpp@ !B_X`BbK]}bGvw@hc|?g~w?_x@bGvH_[\\BmpK~_q}e?`BH_ULXGqh", "sulfonamide_C(5)" },
			{ "dg]BPLVDNpBMBLdaTRVR`rm@AR`A|fPl@ !B?g~w@h`BbGvH@oy?bGvH__y?bGvH@ox@bGt", "sulfonamide_D(2)" },
			{ "diED`LJD@HrRPiIZiPCyL`h@ !BDpAl@G|S@AM?[@Al_qL@Dp", "sulfonamide_E(2)" },
			{ "dkmDPLFD@HxHrRPiSKJUVifiPCzL` !B?G_}]pc|]?pH?W_}Sg}PtdAYUGl@SmIP", "sulfonamide_F(1)" },
			{ "fjmQb@LB`bH@cIIBhhddmLTmNmyZ`@@Bj`@CxvHYGHeBhuEh}@^Sf\\K` !B@k]}mx`BmpJH_[]}?`BH@oy?mpJw@hc}bOw~@Oy?b@Jw@k]}mpJw_P", "sulfonamide_G(1)" },
			{ "fhiHb@LBLFB@AFRREQQII[Z][ru@@@D@@_RqCHyDhUFhmGhC` !B?K_}mx`BmpJH?[]}?`C~_xc|m?rw?Ha}bGw~@Hc|m?p", "sulfonamide_H(1)" },
			{ "fbuib@LLtZtDI@DYIHUEDdmldeZMYZiefjZh@ObXav^sN@ !BS`APtg}Ntb?MTOuwPEg|BC|fUGmN_rlDLP@H?W_|]?uw?G_}]?p", "sulfonamide_I(1)" },
			{ "fbmPa@LF``@PpHrRPjJIJHqYJtzJ\\kUHUAPjP@_TqGhCBXs@ !B_X`BbK_}bOvw@dz?tMJw__x@pIeTn?y?mpJw?F]SFEO~@Ah_YQ|", "sulfonamide_J(1)" },
			{ "fhqa@@J@rQQJKJSVPTjBHJjh@CzRHY@hUvnMsn}p^@ !BbOw~@Oy?bOrw@ha}m?vH?Xc|?Xbw?_rwbGu}mxa}@h`", "tert_butyl_A(2)" },
			{ "fnc@`@@MJDaHRDRHrHPTaDSFBKV@bJjj@B@@Ok@`dLbWJ{WFzwN{vQcLM` !BmpJw?_x@mpK~_{_|bOs~@G?~?g|@?orw?XbH?K\\Bm?w~_{_|m?vw?[\\Bmwt", "tert_butyl_B(1)" },
			{ "dg|h@AgSAJ[WYYntz@BiX`Cyd{HJJaho@ !BbOvw?_y?bOrH_Xa}b@JH_Tz?tMK@fUR{il@", "tetrazole_A(1)" },
			{ "fdyY@@DDEHu`YEDdeEDheSVCEjZXJ`D@CYgEZ|FObHcDDbd@ !B?g~H?[_}b@Jw@hc}m?uNo}CRmpK~_|BYUKnfpK_}m?w~_p", "tetrazole_hzide(1)" },
			{ "gOtHLPDYHhb[SURdCJYYPX^UhEAXQDq@ !B_O@T~rtP@EdPTo@C", "thiaz_ene_A(128)" },
			{ "daE@`LH@cIEEBUTuT@YQc~ph[Nrm@JAXHa\\H !B_O@T~rtP@EdPTee?|@L", "thiaz_ene_A(128)" },
			{ "dieH`LK`BLdTTJIjZf`CJL_rE@yV`E@lEPaD !BOueN@Lto?P`H?B?RBOuYP@", "thiaz_ene_A(128)" },
			{ "daE@`LH@aJYtjijjJHCJL_vICQvUhAPKADKa@ !B_O@T~rtP@EdPTo`T|@L", "thiaz_ene_A(128)" },
			{ "die@`LH@aJYmJjZj`CJL_vMgPNUhAPKADHQ@ !B_O@T~rtP@EdPTee?~ASp@p", "thiaz_ene_A(128)" },
			{ "deUH`LHPBDifuIjZih@rcG|gQNUhAPKATJQ@ !BOueN@Lto?P`H?B?R_txH?Ue@", "thiaz_ene_A(128)" },
			{ "die@`LH@aJYuJjZihh`LhqHd]eZ@TBpQBDP !BEOa|}ud@DBt@IoA|~Fop@p", "thiaz_ene_A(128)" },
			{ "deU@`LH@aJYmrjfjf@LhqHvCeZ@TBpQBdP !BEOa|}ud@DBt@Ibuo|GsxZ?@C", "thiaz_ene_A(128)" },
			{ "dmuH`LHPBDifuRZfjY`CJL_tSeZ@TBpUBTP !BOueN@Lto?P`H?B?R_txH?Ue@sU@", "thiaz_ene_A(128)" },
			{ "daE@`LH@cIEDTUTuMETAeFOyD`hkPB`VBHWB@ !B?Pa@Ig}NU@QN@@c|BOt", "thiaz_ene_A(128)" },
			{ "die@`LH@cIEECbjfjX@rcG|aPvUhAPKADHQ@ !B?Pa@Ig}NU@QN@@PkBOpH?P", "thiaz_ene_A(128)" },
			{ "deUH`LK`BLdTTJqMSTs@FTXhJJt@hE`jEH` !B?Pa@Ig}NU@PDJtx@VS|H?@c}", "thiaz_ene_A(128)" },
			{ "die@`LH@aJYwJjZihj`LhqHdMEZ@TBpQBDP !B?Pa@Ig}NU@QN@Ee@BOpH?P", "thiaz_ene_A(128)" },
			{ "deU@`LH@cIEELbUTuTpAeFOyFshkPB`VBHTb@ !B?Pa@Ig}NU@QN@@PkVT@H?@c}", "thiaz_ene_A(128)" },
			{ "dmuH`LHPBLdTTrQIjZif@LhqQtUhAPKATIQ@ !B?Pa@Ig}NU@PDJtx@VTAYOpc|BOt", "thiaz_ene_A(128)" },
			{ "deU@`LH@aJYuRjfjVbj@rcG}BQV`E@lDPiD !B?Pa@Ig}NU@QN@Ee@BOpDU@c}", "thiaz_ene_A(128)" },
			{ "dmu@`LH@aJYmtjijiX@rcG}CYV`E@lDPeD !B?Pa@Ig}NU@QN@@PkVT@H?@QTBOt", "thiaz_ene_A(128)" },
			{ "dcMH`LHPBDifu\\fijfV@Lhqzt@hE`jEh` !B?Pa@Ig}NU@PDJtx@VTAYOpc|AEPH?P", "thiaz_ene_A(128)" },
			{ "fdipa@LBtkp@a@QdTRbRTRreIQjjiifX@ObLrTVqvY`rkr@dBpH`jBxJH` !B`CDBmuRDpJ[PsYg@aBnH@a|Zf]}`Fox@f\\BDJ{\\Bb@K~@@", "thiaz_ene_B(17)" },
			{ "fhqpa@LRtip@a@QdTRbRTvTIFMUSMSL@GtKYfCJoHBPK@bBhHP`b@ !B`CDBmuRDpJZYpMCMaBl_Fh`BXAjYw?x@aBnw@h`B?`@", "thiaz_ene_B(17)" },
			{ "dg_HPLGU@HPHRYYUoJfjjfZ@Oj[ArXOKsLMUzAHKADJa\\Jq@ !B`DyTn?rHtMK@f\\wPbOvDUK}N?g~H@lwPbOt", "thiaz_ene_B(17)" },
			{ "dkoHPLgU@HPHrJIQIJTfZjfZ`CyIp|sCU^`RBpQBhPbLP !B`DyTn?rHtMKMtLBYbOtlFHQT?g~H@hc}", "thiaz_ene_B(17)" },
			{ "dieHPB{@BAdLdTTJIjZf`CjAXpIRDQbUfXJkPB`VBhPb@ !BOueN@Lto?P`H?B?RBOuYP@", "thiaz_ene_C(11)" },
			{ "dmwHbBx\\@HF\\dTTJtIjZfZ@NXJkPB`VBhRb@ !B?Xc@ik}NUHRDJtz@f]~H@ox@bOt", "thiaz_ene_C(11)" },
			{ "fdePBDLD@DXeJYufUWqRp_Qif`@@B@@H !BLXC@f]CRmpHBbK_}`D{~_{\\Btm@lY{_}m?v@ShANmpHlYp", "thiaz_ene_D(8)" },
			{ "dmvHPBp@c`cIEEBhbjfjj`CJEcrECQV`E@lDPeD !B?Pa@Ig}NU@QN@@PkBOq`Fed?BOt", "thiaz_ene_E(8)" },
			{ "dcNHPBp@`PaJYm[JjZjj`CJMcrMGYV`E@lDPmD !B?Pa@Ig}NU@QN@@PkVT@H?F@ZVS|H?P", "thiaz_ene_E(8)" },
			{ "gOxDB@cABTrfuKPGtl[fX !BLPA@VW_|TMK|BG_}", "thiazol_SC_A(3)" },
			{ "dcl`PLKm@HTHrQQPsIXtkSSKU@GrEfp !BPEdq@OpHtb}w?ECRLP@osS|fJpSMT@", "thiazole_amine_A(4)" },
			{ "dg}@`LH@cIEEChdmeZ]Lt@E@A}aXwW` !B_[\\kaM~ftl?OsZ[@mpJw?_x@mpJw@ox@mpH", "thiazole_amine_B(3)" },
			{ "fdyPb@LDUx@QdbbrRTRRaqRsjYjYjfd@Mb\\dXOaH`dLsTVatAbN_q@N@ !B@haTn|BYs]CPtk}NbOwMtH`BwzXBbHc}LX@kaH`B?g~H?P", "thiazole_amine_C(3)" },
			{ "fhiQB@LDT@HRf]UeVqRsjYjYjZP@vIrQo^DbBPsMQZGQz@yDOX !B_Xc@ieRDotyN`EMgb@J?Shc}J{o}bH`Bs}K_fXc}?`@", "thiazole_amine_C(3)" },
			{ "foAPBDLD@DXeJYU{eqRsjYj@``@ObH`dLpv@ !BtLtknsF?b@HBmxPkbOwMsxc|?g~H__x@bGw~_p", "thiazole_amine_D(3)" },
			{ "f`qPBDLD@DXeJYU{e\\TlzfZ`HF@@~pbBPs@ !BtLtknsF?b@HBmxPkbOwMsxc|?g~H__x@bGw~_{_|", "thiazole_amine_D(3)" },
			{ "dkoH`Lhu@HRfY]TjjVjW`CyLal@ !BLPA@VW_|TMK|BMHo]?tfPEMg]?q`FeMg", "thiazole_amine_E(2)" },
			{ "foQHA@LDDX@QXHRf]ye\\TTZsjYjZif@CyAHY@ !BLPA@VUCR]?s|BG_}@DyT^?pHTMIN_tAYUGm@VP", "thiazole_amine_F(2)" },
			{ "deWDPLKhP@a`cIHThdLkUMHA@ !B?`BH?[_}mpJw?\\?RL[|kn}~Y", "thiazole_amine_G(2)" },
			{ "fakPb@LDrT@QdbbrTTRRTvfLqRt_Iif`@@`Zj@@OfH`dEblMcl@ !BLXC@f]CRmpHBbK_}`Dzw?Oy?tm@lY{_}m?v@ShANm?s~_rqg?`Bw_XANtm@lYp", "thiazole_amine_H(1)" },
			{ "dcL``LIe@HRf]U|jfZVh@~IHJEc\\@ !BK|uT^ty?]?s}]w_}tb}w?@@q]?uw?@", "thiazole_amine_I(1)" },
			{ "dg_DPLjXP@`PcIIBehednkTtuJ@_IdU@ !B?Pc|B@c}]?tH?G_|BOuN_uCRPEeT^pANte@", "thiazole_amine_J(1)" },
			{ "fgAhA@LDyjp@aPQdbbaRRVqPTmFi`@jhP@` !BLXC@f]CRmpHBb@Jw@Ox@?`JwUKo@f]CRbGt", "thiazole_amine_K(1)" },
			{ "dmM@PLH@bPcIEDUDljUifZZ@OdKN` !B?W\\kAC|ftb|osW_|K|tq@BlDOrX", "thiazole_amine_L(1)" },
			{ "foApB@LD\\@HRf]VU|TlzfZP`H@C{BHIFl@ !BTLtk^sE?BOs|]pc}sR|H?Bqg_sDH?\\tosR}?LP", "thiazole_amine_M(1)" },
			{ "fakQb@LDMeh@cIEEdhhhdddjmbcdaKSM@D@QET@@_\\IDhmD\\SE\\{` !BLXC@f]CRmpHBbK]}`Dzw?Oy?tm@lY?x@mwvw_XAN`Dzw?Oy??g|lY{]}`D{Rt@", "thiazole_amine_N(1)" },
			{ "eMB@HRVCzh@ !B_vq?Dp", "thio_aldehyd_A(3)" },
			{ "dk^H`DX@aIfYUYM]ZjZjd@v`LVUgPNSfp !B?g~H?[_}?g~H?L?RL[~H_Xa}J{o_fX`B", "thio_amide_A(6)" },
			{ "do}@`DD@aIeYeUuviB`d@C{DcHFMp[@ !B?`BH@k\\BbOvw?Xc|?g~w@oy?bGvH_[_}mww~_p", "thio_amide_B(2)" },
			{ "f`q`B@D@BDfyfUWtzwfj@@@@@CyBHq@ !B?`Bw@h`B?`BH_[\\Bb@JH?Oy??`C~@Ha}bGvH@oy?", "thio_amide_C(2)" },
			{ "diE@`DX@aIgVZfh@~IHrN`X@ !BmpJw?_x@mpJw?[\\Bm?w~@@", "thio_amide_D(2)" },
			{ "fhiQB@DTt@HRYYeY]TzpVh@B@`@@~PbOX !B?`BH@k\\BbGvw__x@bOs~_{\\BmpK~@Ha}bGw~@K\\B?g|", "thio_amide_E(1)" },
			{ "gGTHDPDIL{U@_EQhLV@ !BmpJw?_x@mpJw?P", "thio_amide_F(1)" },
			{ "daz@PL@HPHRY]ZjPC{L`lk@ !B?`Bw@h`Bm?vH?X`BbOt", "thio_carbam_A(1)" },
			{ "gOxDL@aABSJumUHG\\K@ !BmpJw?_x@m?rw@ox@", "thio_carbam_ene(2)" },
			{ "dmND`Ep`BLdTTJRJaff@B`@uhAPKARIQ@ !BtMHkaHa}LX@BbG?~?Xc}bG?~_?x", "thio_carbonate_A(15)" },
			{ "dmLL`LIPBLdTTJRJaff@B`@uhAPKARIQ@ !BtMHkaHa}LX@BbG?~?Xc}bG?~_?x", "thio_carbonate_A(15)" },
			{ "dmNHPEp@a@aIeUTjFVj@H@CVhD`lDPiD !BmpKOsSF@JxS_ig?~?Xc}bG?~_?x", "thio_carbonate_A(15)" },
			{ "dmLDPLT@a@aIeUTjFVj@H@CVhD`lDPiD !BmpKOsSF@JxS_ig?~?Xc}bG?~_?x", "thio_carbonate_A(15)" },
			{ "dclL`LJPBLdTTJTqTJtpAE@A}FyT`E@lEh` !B`CFYp@JwtmBH@k\\B?`C~@H`BmpJH_P", "thio_carbonate_B(3)" },
			{ "dkm@`Dd@aIefWvyjinV@ObRLahz@ !Bm?vw@oy?m?vH_[_}?g~w@ha}?g~w?[_}", "thio_cyano_A(1)" },
			{ "gOpH@DILkVuU@[Qqca`jlHb@ !BbGvH?Oy?bGvH__y?", "thio_dibenzo(23)" },
			{ "diF@`J@HRV[fZj@ObKFslG@ !BbOvH@hc}?`BH@oy??`BH?P", "thio_ene_amine_A(1)" },
			{ "fhiQA@BRl@HPDYEMHheDlbhw`mUU`hDPpPB !BmpKkj?x@?`BH_[_}mpJH@ha}m?qQs{]}bGvw?T]S?g|", "thio_est_cyano_A(1)" },
			{ "daF@PF@HPHRYVkfjj`j@uzAHKADJaLKa@ !Bb@JH__x@bOrH@hc}?`@", "thio_ester_A(5)" },
			{ "gNpD@DHHRYUjXCyFGftJf !B?g~H?[_}b@Jw@hc}", "thio_ester_B(4)" },
			{ "dax@P@BDBDfUvid@~`hv`UF !B?`BH@k\\BbOvw?X`BbOt", "thio_ester_B(4)" },
			{ "difHPLD@a@aIeYifjihJ`OhZJm@dE`bEPaD !B?g~w?Xa}?g?~_xa}m?vH?P", "thio_ester_C(2)" },
			{ "fbm`b@ER\\@HrQQQIQHkSIBLkR\\tD`tR@A@@_PY@ !BbGvw_Xc|?g?OtcF?bGvH_Yg@J{o_f_y?ot{MsuMgs]B?Sk}Ns]@", "thio_imide_A(1)" },
			{ "gNyILpDZTiyij@~RaqmEu` !Bm?vH?[\\Bm?w~@K\\B", "thio_imine_ium(2)" },
			{ "dmN@`L@HRVYWkiUijeX@` !BBOpH?Ty?TMI@VRm{UGlZGqh_Jwl", "thio_keto_het(2)" },
			{ "gC`H@DILtA@ !B?g~w?Xc}", "thio_ketone(43)" },
			{ "dk_H`LKi@HrQSIPqIntz@Bfa@Mh[vKFp\\[aF !BmwvH__y?mpJw?[_}mpK~_v]SFELZGvT_", "thio_pyridine_A(1)" },
			{ "f`qaA@J\\@DZBDiW[fUIRwjjfBBH@CzbhMEh]gh@ !BmwvH__y??g~H__y?mwvH__y?bOrw?Xa}bGvw@h`B", "thio_thiomorph_Z(1)" },
			{ "fjmpB@DXl@HRYVUWymUFrUj``bh@@@CybHqELEfl}` !B?`Bw@h`Bm?vH?_y?mpJH@k_}m?vH?[\\Bb@K~@Hc}mpJH@ox@?`BH@`", "thio_urea_A(12)" },
			{ "fbupB@DXt@HRYVUWnuTYNVjBBJ@@@@~hbLQSAX{@ !B?g~w?Xc}mpJH@k_}?`BH?[\\BmpJH@ox@bOw~@Hc|?g~H_Xa}?g|", "thio_urea_B(9)" },
			{ "fdyqB@DXih@QdTRTRRbLrUXLVjBAaiH@MdNCyBHiDXAa`kAp` !B?`Bw@h`Bm?vH?_y?mpJH@k_}mww~@Hc}mpINo}CRpIeTnp", "thio_urea_C(9)" },
			{ "fhipB@DXh@HRYVUYwU[pVjB@@@@@~PbJP !B?g~w_Xa}mpJH@k]}?`BH_[\\BmpJH@oy??`BH_Xa}?g|", "thio_urea_D(8)" },
			{ "fhipB@DXt@HRYVUYwU[pVjB@@@@@~pbLQS@ !B?g~w?Xc}mpJH@k_}?`BH?[\\BmpK~_xc|?`BH_Xa}bOp", "thio_urea_E(7)" },
			{ "gOrHEcPDILkVuU@_YPXl@ !BmpK~@K_}mpJw?K_}", "thio_urea_F(6)" },
			{ "dg^``DrmL@aIeYUe[ZhHJ@@rSXNOHdU@ !B?`Bw@h`Bm?vH?_y?mpJH@k_}mww~@Hc}mpH", "thio_urea_G(5)" },
			{ "dgH`Dqe@HRYe]mIcmjjfZfBhCyLblkTBPVBhUb@ !Bim?PsRn{L[~H?OrwaBo~@F@ZYrpXKAi`YV@", "thio_urea_H(3)" },
			{ "fhiHB@DXIx@PdrkJl{iw`mTaAHq@Au@MyBHq@ !B?`BH@k\\BbOvw?X`B?g~w@hc}m?vw_Tz?tMJw@lBYUKl", "thio_urea_I(3)" },
			{ "dcOH`Dpi@HRYufYujYjX@~qHrE` !BmpJw?_x@mpJw?[\\Bs|tq`BnDf]?_i`", "thio_urea_J(2)" },
			{ "dev``Dqnd@aIfUrXYZjjjBHCzLbjpIAXHaTIa\\HQRIQ@ !B]?posSD@JpQeGs|fOud?VVT_", "thio_urea_K(2)" },
			{ "deg@`LI`BDimUijV@Mlki|aQL[PFcbIp !B?g~w?K_}bOvw@h`Bm?vH?[\\B", "thio_urea_L(1)" },
			{ "flypA@DX\\@HUHYEDeDhdbeMjsUADQUH@GTEOeHcDTsdBrTZ`v^rNQ`hiBHqJp !B?`BH@k\\BbOvw?Xc|?g~w@ha}?`BH_[_}?g~w@ha}m?w~@K\\B", "thio_urea_M(1)" },
			{ "fdyQB@DXt@HRYevYUWQ|Ejj`dJA@C{fHIeHYah}@X@ !B?g~H?[_}b@K~_{\\BbOvw?Xc|?g|qo|?RbGvH_]~YJ{o~_p", "thio_urea_N(1)" },
			{ "fbmQb@DXuYH@aIeYUfuUSoAbej``fJjF@CyRHqEHYGHUAhCD\\s@ !B?g~w_Xa}mpJH@k]}?`BH_[_|mpINo}CRGvW~@LBYUKmSFA|Ztl|", "thio_urea_O(1)" },
			{ "dmOH`Dqe@HrJIIJDjxVjjePCyDcHs@uR`RBpQB@ !BId@kAECR?@`q@CD@?@aPtg_|]?t", "thio_urea_P(1)" },
			{ "fbupB@DXH@HrJIIJIPqJH~BgKUMR@@@@@_JQFHeah]GhCDXSFX@ !B?`Bw@h`Bm?vH?[\\Bb@Jw?_x@bOvw?Oy?m?w~@K_}?g~w@k\\B?`@", "thio_urea_Q(1)" },
			{ "doH`Drg@HRYVUWuMj``RP@~IHjAcX@ !B?`Bw@h`Bm?vH?_y?mpJH@k_}mwvH?[_|b@JH?P", "thio_urea_R(1)" },
			{ "do}HPANPBLBLdTTrtJTIjf[Yj`a[{Mb|_Mqc@ !BwzXBbKlkLXB@SbnDmpJ@Sox@m?vw@k_}mpK~_p", "thiophene_C(3)" },
			{ "do~DPCFPBLBLdTTvTJTJjeiYj`a[{Mb|_Mqc@ !BwzXBbKlkLX@kaHANmpKRtOx@m?vw@k_}mpK~_p", "thiophene_C(3)" },
			{ "dmuD`AUn@HRfUorjYfj@OjRJ`XgE` !BtMHkaCF@bOw|bHQT?g~H@ig@bOt", "thiophene_D(2)" },
			{ "dg}HPAw`BEBDig{Y\\h{ifZfi@OjRL`hjA` !BtLtknsF?b@HBmxc}?g~H@hc}tMINouR{pId", "thiophene_E(2)" },
			{ "foAQA@IFD@HtDYHhicLhebegTsSTuH@_TqAHiCLe@ !BtLtknsF?b@HBm{}NbOw~_x`BbOwPtdz?UKo@fP", "thiophene_E(2)" },
			{ "foAQA@IFD@HtDYHhmMBhebegTsSTuLBT@~hbLQRNYJ@ !BtLtknsF?b@HBmxc}?`C~_x`BbOwPtdz?UKo@fP", "thiophene_E(2)" },
			{ "f`qQA@EVd@HLDYHhihXUDlT]zfZfijXDhA}SDTafBqT@ !BtLtknsF?b@HBm{}NbOw~@Oy?b@JH?]CRSk}Tn|BY", "thiophene_E(2)" },
			{ "dg]LPLnDL@b`cIHUDhdipkTuTr@_EdKFq\\@ !BmpK~_x`BbOuNo}CRpIeTnz[@tl~@Sf@ZnuP", "thiophene_F(1)" },
			{ "daFH`Lx@aJY|jjVX@~qHsJ` !BOr[|BGlkLP@kAG_|]?t", "thiophene_amino_Aa(45)" },
			{ "fdyab@LRtX@QdbbRRbbcRIPLZejY`@`@OdHcD@ !BtMHkaHc}LXC|bOy?aESMtK_}bOvYpFAeotxlFLwPs]@lF@", "thiophene_amino_Ab(40)" },
			{ "fleab@LJMX@QdbbbRtTTZQJQSTmTs@A@@_HqCL@ !BtMHkaHc}LXC|bK|q?g~DULwPm?vH?Yg@XFV?SbpXs]CMtBpX", "thiophene_amino_Ab(40)" },
			{ "fbuab@LZlx@QdbbbRRbbgRIQNZejef@B@@~ab@ !BtMHkaHc}LXC|bK|q?g~DULwPTqbw?Xc}f\\A`Y[}NKAcMtLwPKA`", "thiophene_amino_Ab(40)" },
			{ "fhiaa@MFmx@PhHrQQJFIJXpeAJZfViij@CyGHu@ !BpIdq`MKO@hcPtlBY?[]NoxQTUKnH?Yg@XFW~_{_}bOt", "thiophene_amino_Ab(40)" },
			{ "fdyaa@CV\\D@PhHrQQJFJIPfDhISTruSST@GrMXZ@ !BpIdq`MKO@hcPtlBY?[]NoxQTUKn?LXc}f\\A`Y_y?m?vH?P", "thiophene_amino_Ab(40)" },
			{ "fleaa@CV]D@PhHrQQJFJISJpeAJZfVjYfh@OhF` !BpIdq`MKO@hcPtlBY?[]NoxQTUKn?LXc}f\\A`YULX?g~w?Xc}", "thiophene_amino_Ab(40)" },
			{ "fhiqB@LRlh@QdbbbRRbJqJ^CTmTa`P@GtLP !BLXC@f[\\BtMHBbMKOm?vfpHANTv_~_{_|ilBw_[]}m?p", "thiophene_amino_B(12)" },
			{ "fhiHB@LRUX@QdbbbRRbJqF^CTsWA`P@GtLP !BLXC@f[\\BtMKRspJHm?vfpMKO`D{~_{_|ilBw_[]}m?p", "thiophene_amino_B(12)" },
			{ "fdyqB@LR\\h@QdbbbRTTUVIPLZejiC@`@OdXaT@ !BLXC@f[\\BtMHBbMKOm?vfpHAN`CESY?y?m?rfpK]}mwvw?@", "thiophene_amino_B(12)" },
			{ "fdyIB@LRlyP@cIEEDdeEBbR`XuKUHLA@@_Pq@ !BLXC@f[\\BtMHBbMKOm?vfpHANTv_~_{_|nuQ`Fk]}mwvw?@", "thiophene_amino_B(12)" },
			{ "fdyhB@LRUYp@cIEEDdeEBbQ`XuLupLA@@_Pq@ !BLXC@f[\\BtMKRspJHm?vfpMKO`D{~_{_|nuQ`Fk]}mwvw?@", "thiophene_amino_B(12)" },
			{ "fleIB@LR]yP@cIEEDdhhiTRTbfiZjPXB@@~QbEP !BLXC@f[\\BtMHBbMKOm?vfpHAN`CESY?y?m?r{UF@Zmwvw_[_|", "thiophene_amino_B(12)" },
			{ "fdi`R@LZlzH@cIEEDdeEJTReRuTsTp@_DqCLebh@ !BShC_fX`Bs}K}bLwObOvYpK}NKF_~_x`BGqjDUHc}b@JH?P", "thiophene_amino_C(7)" },
			{ "fhqPb@LVtD@QdbbbRRbnQJUKUS]L@GqLPsIXj@ !BShC_fX`Bs}K}bLwObOvYpK}NKF_~_x`Bf\\BH?X`BbOt", "thiophene_amino_C(7)" },
			{ "f`aQb@LNUhp@cIEEDdhhfReRuSMl@GtIP !BLXC@f[\\BtMHBbMKOm?vfpHAN`CESY?y?mpJfpK_}", "thiophene_amino_D(3)" },
			{ "dk^@PF@HdHrQQIEQKJtzYffi@OlJFsh@ !BSg|?Ib?MBOw}]ud?BOpH?UCRSg}T^tAY", "thiophene_amino_E(2)" },
			{ "fnsqB@LTLh@PeLr{K]jnQbZe[TsTv@@@P@AmRshikyFHi` !BtMHkaHa}LXB?L_rHb@JDULwP?`BH_XQTotxlFHc|?g?MtLwPbGvH_RpX?g|", "thiophene_amino_F(2)" },
			{ "fdiab@LJMX@QdbbbVTTSRIRiZeffX@OdXbt@ !BPEdq@MHo?@aPtg_|Tv\\@Sg_}_t{RKrqgteAw?G_}]?qw?P", "thiophene_amino_G(2)" },
			{ "dg]H`LuPBLdTTRQaQUTmTtpA}VPt]Dql@ !BwzXBbKlkLX@kaHANim~w@j[@?`Bw?[\\Bm?t", "thiophene_amino_H(2)" },
			{ "gFqHJ@aJUqiZ@~e` !BEOm||AAR@Egp@p", "thiophene_hydroxy(28)" } };

	private static StereoMolecule[]	sFragmentList;
	private static long[][]			sIndexList;
	private static boolean			sInitialized;

	public PainsDetector() {
		synchronized(PainsDetector.class) {
			if (!sInitialized) {
				try {
					sFragmentList = new StereoMolecule[PAINS.length];
					sIndexList = new long[PAINS.length][];
					SSSearcherWithIndex sss = new SSSearcherWithIndex(SSSearcher.cMatchAtomCharge);
					for (int i=0; i<PAINS.length; i++) {
						sFragmentList[i] = new IDCodeParser(false).getCompactMolecule(PAINS[i][0]);
						sIndexList[i] = sss.createLongIndex(sFragmentList[i]);
					}
					sInitialized = true;
				}
				catch (Exception e) {
					System.out.println("Unable to initialize NastyFunctionDetector");
				}
			}
		}
	}

	/**
	 * @param mol
	 * @param index FragFp descriptor
	 * @return list of names of detected pains fragments or null in case of initialization error
	 */
	public String[] getPainsList(StereoMolecule mol, long[] index) {
		if (!sInitialized)
			return null;

		ArrayList<String> painsList = new ArrayList<>();

		SSSearcherWithIndex sss = new SSSearcherWithIndex(SSSearcher.cMatchAtomCharge);
		sss.setMolecule(mol, index);
		for (int i=0; i<PAINS.length; i++) {
			sss.setFragment(sFragmentList[i], sIndexList[i]);
			if (sss.isFragmentInMolecule())
				painsList.add(PAINS[i][1]);
		}

		return painsList.toArray(new String[0]);
	}

	/**
	 * @param mol
	 * @param index FragFp descriptor
	 * @return '; ' separated list of detected PAINS pattern names
	 */
	public String getPainsString(StereoMolecule mol, long[] index) {
		String[] nfl = getPainsList(mol, index);
		if (nfl == null)
			return "initialization error";
		if (nfl.length == 0)
			return "";
		StringBuilder sb = new StringBuilder(nfl[0]);
		for (int i=1; i<nfl.length; i++)
			sb.append("; "+nfl[i]);
		return sb.toString();
	}

}