# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.paloaltonetworksngfw import PaloAltoNetworksNgfwMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPaloAltoNetworksNgfwMgmtPostRulesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PaloAltoNetworksNgfwMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_post_rules_list(self, resource_group):
        response = self.client.post_rules.list(
            global_rulestack_name="str",
            api_version="2025-10-08",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_post_rules_get(self, resource_group):
        response = self.client.post_rules.get(
            global_rulestack_name="str",
            priority="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_post_rules_begin_create_or_update(self, resource_group):
        response = self.client.post_rules.begin_create_or_update(
            global_rulestack_name="str",
            priority="str",
            resource={
                "ruleName": "str",
                "actionType": "str",
                "applications": ["str"],
                "auditComment": "str",
                "category": {"feeds": ["str"], "urlCustom": ["str"]},
                "decryptionRuleType": "str",
                "description": "str",
                "destination": {
                    "cidrs": ["str"],
                    "countries": ["str"],
                    "feeds": ["str"],
                    "fqdnLists": ["str"],
                    "prefixLists": ["str"],
                },
                "enableLogging": "str",
                "etag": "str",
                "id": "str",
                "inboundInspectionCertificate": "str",
                "name": "str",
                "negateDestination": "str",
                "negateSource": "str",
                "priority": 0,
                "protocol": "application-default",
                "protocolPortList": ["str"],
                "provisioningState": "str",
                "ruleState": "str",
                "source": {"cidrs": ["str"], "countries": ["str"], "feeds": ["str"], "prefixLists": ["str"]},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": [{"key": "str", "value": "str"}],
                "type": "str",
            },
            api_version="2025-10-08",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_post_rules_begin_delete(self, resource_group):
        response = self.client.post_rules.begin_delete(
            global_rulestack_name="str",
            priority="str",
            api_version="2025-10-08",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_post_rules_get_counters(self, resource_group):
        response = self.client.post_rules.get_counters(
            global_rulestack_name="str",
            priority="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_post_rules_refresh_counters(self, resource_group):
        response = self.client.post_rules.refresh_counters(
            global_rulestack_name="str",
            priority="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_post_rules_reset_counters(self, resource_group):
        response = self.client.post_rules.reset_counters(
            global_rulestack_name="str",
            priority="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...
