% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis_canvas.R
\name{insert_xaxis_grob}
\alias{insert_xaxis_grob}
\alias{insert_yaxis_grob}
\title{Insert an axis-like grob on either side of a plot panel in a ggplot2 plot.}
\usage{
insert_xaxis_grob(
  plot,
  grob,
  height = grid::unit(0.2, "null"),
  position = c("top", "bottom"),
  clip = "on"
)

insert_yaxis_grob(
  plot,
  grob,
  width = grid::unit(0.2, "null"),
  position = c("right", "left"),
  clip = "on"
)
}
\arguments{
\item{plot}{The plot into which the grob will be inserted.}

\item{grob}{The grob to insert. This will generally have been obtained via \code{\link[=get_panel]{get_panel()}}
from a ggplot2 object, in particular one generated with \code{\link[=axis_canvas]{axis_canvas()}}. If a ggplot2
plot is provided instead of a grob, then \code{\link[=get_panel]{get_panel()}} is called to extract the
panel grob.}

\item{height}{The height of the grob, in grid units. Used by \code{insert_xaxis_grob()}.}

\item{position}{The position of the grob. Can be \code{"right"} or \code{"left"} for \code{insert_yaxis_grob()}
and \code{"top"} or \code{"botton"} for \code{insert_xaxis_grob()}.}

\item{clip}{Set to "off" to turn off clipping of the inserted grob.}

\item{width}{The width of the grob, in grid units. Used by \code{insert_yaxis_grob()}.}
}
\description{
The function \code{insert_xaxis_grob()} inserts a grob at the top or bottom of the plot panel in a ggplot2 plot.
}
\details{
For usage examples, see \code{\link[=axis_canvas]{axis_canvas()}}.
}
