% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guides-.R
\name{guides}
\alias{guides}
\title{Set guides for each scale}
\usage{
guides(...)
}
\arguments{
\item{...}{List of scale name-guide pairs.  The guide can either
be a string (i.e. "colorbar" or "legend"), or a call to a guide function
(i.e. \code{\link[=guide_colourbar]{guide_colourbar()}} or \code{\link[=guide_legend]{guide_legend()}})
specifying additional arguments.}
}
\value{
A list containing the mapping between scale and guide.
}
\description{
Guides for each scale can be set scale-by-scale with the \code{guide}
argument, or en masse with \code{guides()}.
}
\examples{
\donttest{
# ggplot object

dat <- data.frame(x = 1:5, y = 1:5, p = 1:5, q = factor(1:5),
 r = factor(1:5))
p <-
  ggplot(dat, aes(x, y, colour = p, size = q, shape = r)) +
  geom_point()

# without guide specification
p

# Show colorbar guide for colour.
# All these examples below have a same effect.

p + guides(colour = "colorbar", size = "legend", shape = "legend")
p + guides(colour = guide_colorbar(), size = guide_legend(),
  shape = guide_legend())
p +
 scale_colour_continuous(guide = "colorbar") +
 scale_size_discrete(guide = "legend") +
 scale_shape(guide = "legend")

 # Remove some guides
 p + guides(colour = "none")
 p + guides(colour = "colorbar",size = "none")

# Guides are integrated where possible

p +
  guides(
    colour = guide_legend("title"),
    size = guide_legend("title"),
    shape = guide_legend("title")
 )
# same as
g <- guide_legend("title")
p + guides(colour = g, size = g, shape = g)

p + theme(legend.position = "bottom")

# position of guides

# Set order for multiple guides
ggplot(mpg, aes(displ, cty)) +
  geom_point(aes(size = hwy, colour = cyl, shape = drv)) +
  guides(
   colour = guide_colourbar(order = 1),
   shape = guide_legend(order = 2),
   size = guide_legend(order = 3)
 )
}
}
\seealso{
Other guides: 
\code{\link{guide_bins}()},
\code{\link{guide_colourbar}()},
\code{\link{guide_coloursteps}()},
\code{\link{guide_legend}()}
}
\concept{guides}
