An invalid meta-item was used inside an attribute.

Erroneous code example:

```compile_fail,E0539
#![feature(staged_api)]
#![allow(internal_features)]
#![stable(since = "1.0.0", feature = "test")]

#[deprecated(note)] // error!
#[unstable(feature = "deprecated_fn", issue = "123")]
fn deprecated() {}

#[unstable(feature = "unstable_struct", issue)] // error!
struct Unstable;

#[rustc_const_unstable(feature)] // error!
const fn unstable_fn() {}

#[stable(feature = "stable_struct", since)] // error!
struct Stable;

#[rustc_const_stable(feature)] // error!
const fn stable_fn() {}
```

To fix the above example, you can write the following:

```
#![feature(staged_api)]
#![allow(internal_features)]
#![stable(since = "1.0.0", feature = "test")]

#[deprecated(since = "1.39.0", note = "reason")] // ok!
#[unstable(feature = "deprecated_fn", issue = "123")]
fn deprecated() {}

#[unstable(feature = "unstable_struct", issue = "123")] // ok!
struct Unstable;

#[rustc_const_unstable(feature = "unstable_fn", issue = "124")] // ok!
const fn unstable_fn() {}

#[stable(feature = "stable_struct", since = "1.39.0")] // ok!
struct Stable;

#[stable(feature = "stable_fn", since = "1.39.0")]
#[rustc_const_stable(feature = "stable_fn", since = "1.39.0")] // ok!
const fn stable_fn() {}
```

Several causes of this are,
an attribute may have expected you to give a list but you gave a
`name = value` pair:

```compile_fail,E0539
// wrong, should be `#[repr(C)]`
#[repr = "C"]
struct Foo {}
```

Or a `name = value` pair, but you gave a list:

```compile_fail,E0539
// wrong, should be `note = "reason"`
#[deprecated(since = "1.0.0", note("reason"))]
struct Foo {}
```

Or it expected some specific word but you gave an unexpected one:

```compile_fail,E0539
// should be `always` or `never`
#[inline(maybe_if_you_feel_like_it)]
fn foo() {}
```
