/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef POWERMANAGERBRIGHTNESS_H
#define POWERMANAGERBRIGHTNESS_H

#include <QVariant>
#include <QDBusMessage>
#include <QDBusInterface>

#include "usd_global_define.h"
#include "QGSettings/qgsettings.h"
#include "abstract-brightness.h"

class PowerManagerBrightness : public AbstractBrightness
{
    Q_OBJECT
public:
    PowerManagerBrightness(QObject *parent);

    /**
     * @brief getBrightness
     * @return
     */
    int getBrightness();

    /**
     * @brief setBrightness
     * @param brightness
     * @return
     */
    int setBrightness(int brightness);

    /**
     * @brief connectTheSignal
     * @return
     */
    int connectTheSignal();

    /**
     * @brief isEnable
     * @return
     */
    QString backend();

private Q_SLOTS:
    void doChanged(QString);

private:
    QGSettings *m_pPowerManger;
};

#endif // POWERMANAGERBRIGHTNESS_H
