set(ENV{CC}  gcc)
set(ENV{CXX} g++)
set(ENV{FC}  gfortran)

execute_process(
  COMMAND "python3-config" "--prefix"
  OUTPUT_VARIABLE PY_ROOT
  OUTPUT_STRIP_TRAILING_WHITESPACE)

set(dashboard_cache "
BUILD_SHARED_LIBS=OFF
BUILD_TESTING:BOOL=OFF
ADIOS2_BUILD_EXAMPLES:BOOL=ON

ADIOS2_USE_AWSSDK:STRING=OFF
ADIOS2_USE_Blosc2:BOOL=ON
ADIOS2_USE_BZip2:BOOL=ON
ADIOS2_USE_DataMan:BOOL=OFF
ADIOS2_USE_Fortran:BOOL=ON
ADIOS2_USE_HDF5:BOOL=ON
ADIOS2_USE_MGARD:BOOL=OFF
ADIOS2_USE_MPI:BOOL=ON
ADIOS2_USE_Python:BOOL=ON
ADIOS2_USE_SZ:BOOL=ON
ADIOS2_USE_ZeroMQ:STRING=OFF
ADIOS2_USE_ZFP:BOOL=ON

Python_ROOT_DIR:PATH=${PY_ROOT}
Python_FIND_STRATEGY:STRING=LOCATION
Python_FIND_FRAMEWORK:STRING=FIRST

CMAKE_C_COMPILER_LAUNCHER=ccache
CMAKE_CXX_COMPILER_LAUNCHER=ccache
CMAKE_C_FLAGS:STRING=-Wall
CMAKE_CXX_FLAGS:STRING=-Wall
CMAKE_Fortran_FLAGS:STRING=-Wall
")

set(CTEST_CMAKE_GENERATOR "Ninja")
list(APPEND CTEST_UPDATE_NOTES_FILES "${CMAKE_CURRENT_LIST_FILE}")
include(${CMAKE_CURRENT_LIST_DIR}/ci-common.cmake)
