// Copyright (c) 2023 Bela Schaum, X-Ryl669, Denis Mikhailov, Antony Polukhin.
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

// Generated by misc/generate_fields_names_big.cpp.py

#include <boost/pfr/core_name.hpp>
#include <type_traits>

#include <boost/core/lightweight_test.hpp>

namespace testing {

template <class... Types>
auto make_stdarray(const Types&... t) {
    return std::array<std::common_type_t<Types...>, sizeof...(Types)>{t...};
}

struct Aggregate1 {
    int EXuT_0EBItazIzOuovbOSyOYGqbJw1uQ;

};
struct Aggregate2 {
    int SnihXdx4VbVTcwKm2PGOy8gBYi;
int l_hKC0UCDgf9akyA6pr1IG;

};
struct Aggregate3 {
    int GWYXwjwOCC5uOWkmZjrjk95yaOQbVfUbSJRCoQoRyPXjzp7x2c7WMwvck0JeOg;
int xdtwasd3bFi2mErdk64LyyWKcOb5gudT50eCBMUHraYYmd8Yxp9M0pO1DmDHWQZ4LEshxseqUjzoTeuwnVwA6uvStNpN0ZtZ;
int shqTJk7vA32s2DQB5o7TyecNLMHLUogzWYO_NwRsgX;

};
struct Aggregate4 {
    int ofYcwHz8V6YMDPsHqyIB5TVZckFc3cK0Da;
int HiGE0sOlKCO;
int F5Nrv0LUdUSmrzLgPmtENIEe5uJQyRXC0owDVh9IjRBdA_aSEqiMx_EhWXEkbddK5MCgCv223s9EXlMc55ByxpG6XYbXS6nHywEy;
int emjjbXYK;

};
struct Aggregate5 {
    int M0u7SIZSVWJ0KqQygT_6npmZv1XzZI5dJcwjQuqq6lIdlSJSpnAKhOg82qyVywwNq3cvvmnmAv7;
int SXEUFB6z;
int tDxT;
int sV2m6xg3MxKN1Xln2dXyBh8rkF7lUUfHIK8nK4FRzru2DXeT;
int ycEXe3x03PvbXqFJzOKMq8i4XLAZfyY2i4HONhv1Wx_;

};


void test_get_name_1() {
    BOOST_TEST_EQ( ((boost::pfr::get_name<0, Aggregate1>())), "EXuT_0EBItazIzOuovbOSyOYGqbJw1uQ");

}
void test_get_name_2() {
    BOOST_TEST_EQ( ((boost::pfr::get_name<0, Aggregate2>())), "SnihXdx4VbVTcwKm2PGOy8gBYi");
BOOST_TEST_EQ( ((boost::pfr::get_name<1, Aggregate2>())), "l_hKC0UCDgf9akyA6pr1IG");

}
void test_get_name_3() {
    BOOST_TEST_EQ( ((boost::pfr::get_name<0, Aggregate3>())), "GWYXwjwOCC5uOWkmZjrjk95yaOQbVfUbSJRCoQoRyPXjzp7x2c7WMwvck0JeOg");
BOOST_TEST_EQ( ((boost::pfr::get_name<1, Aggregate3>())), "xdtwasd3bFi2mErdk64LyyWKcOb5gudT50eCBMUHraYYmd8Yxp9M0pO1DmDHWQZ4LEshxseqUjzoTeuwnVwA6uvStNpN0ZtZ");
BOOST_TEST_EQ( ((boost::pfr::get_name<2, Aggregate3>())), "shqTJk7vA32s2DQB5o7TyecNLMHLUogzWYO_NwRsgX");

}
void test_get_name_4() {
    BOOST_TEST_EQ( ((boost::pfr::get_name<0, Aggregate4>())), "ofYcwHz8V6YMDPsHqyIB5TVZckFc3cK0Da");
BOOST_TEST_EQ( ((boost::pfr::get_name<1, Aggregate4>())), "HiGE0sOlKCO");
BOOST_TEST_EQ( ((boost::pfr::get_name<2, Aggregate4>())), "F5Nrv0LUdUSmrzLgPmtENIEe5uJQyRXC0owDVh9IjRBdA_aSEqiMx_EhWXEkbddK5MCgCv223s9EXlMc55ByxpG6XYbXS6nHywEy");
BOOST_TEST_EQ( ((boost::pfr::get_name<3, Aggregate4>())), "emjjbXYK");

}
void test_get_name_5() {
    BOOST_TEST_EQ( ((boost::pfr::get_name<0, Aggregate5>())), "M0u7SIZSVWJ0KqQygT_6npmZv1XzZI5dJcwjQuqq6lIdlSJSpnAKhOg82qyVywwNq3cvvmnmAv7");
BOOST_TEST_EQ( ((boost::pfr::get_name<1, Aggregate5>())), "SXEUFB6z");
BOOST_TEST_EQ( ((boost::pfr::get_name<2, Aggregate5>())), "tDxT");
BOOST_TEST_EQ( ((boost::pfr::get_name<3, Aggregate5>())), "sV2m6xg3MxKN1Xln2dXyBh8rkF7lUUfHIK8nK4FRzru2DXeT");
BOOST_TEST_EQ( ((boost::pfr::get_name<4, Aggregate5>())), "ycEXe3x03PvbXqFJzOKMq8i4XLAZfyY2i4HONhv1Wx_");

}


void test_names_as_array_1() {
    const auto expected = make_stdarray(
        std::string_view{"EXuT_0EBItazIzOuovbOSyOYGqbJw1uQ"}

    );
    const auto value = boost::pfr::names_as_array<Aggregate1>();
    BOOST_TEST_EQ(expected.size(), value.size());
    for (std::size_t i=0;i<expected.size();++i) {
        BOOST_TEST_EQ(value[i], expected[i]);
    }
}
void test_names_as_array_2() {
    const auto expected = make_stdarray(
        std::string_view{"SnihXdx4VbVTcwKm2PGOy8gBYi"}
, std::string_view{"l_hKC0UCDgf9akyA6pr1IG"}

    );
    const auto value = boost::pfr::names_as_array<Aggregate2>();
    BOOST_TEST_EQ(expected.size(), value.size());
    for (std::size_t i=0;i<expected.size();++i) {
        BOOST_TEST_EQ(value[i], expected[i]);
    }
}
void test_names_as_array_3() {
    const auto expected = make_stdarray(
        std::string_view{"GWYXwjwOCC5uOWkmZjrjk95yaOQbVfUbSJRCoQoRyPXjzp7x2c7WMwvck0JeOg"}
, std::string_view{"xdtwasd3bFi2mErdk64LyyWKcOb5gudT50eCBMUHraYYmd8Yxp9M0pO1DmDHWQZ4LEshxseqUjzoTeuwnVwA6uvStNpN0ZtZ"}
, std::string_view{"shqTJk7vA32s2DQB5o7TyecNLMHLUogzWYO_NwRsgX"}

    );
    const auto value = boost::pfr::names_as_array<Aggregate3>();
    BOOST_TEST_EQ(expected.size(), value.size());
    for (std::size_t i=0;i<expected.size();++i) {
        BOOST_TEST_EQ(value[i], expected[i]);
    }
}
void test_names_as_array_4() {
    const auto expected = make_stdarray(
        std::string_view{"ofYcwHz8V6YMDPsHqyIB5TVZckFc3cK0Da"}
, std::string_view{"HiGE0sOlKCO"}
, std::string_view{"F5Nrv0LUdUSmrzLgPmtENIEe5uJQyRXC0owDVh9IjRBdA_aSEqiMx_EhWXEkbddK5MCgCv223s9EXlMc55ByxpG6XYbXS6nHywEy"}
, std::string_view{"emjjbXYK"}

    );
    const auto value = boost::pfr::names_as_array<Aggregate4>();
    BOOST_TEST_EQ(expected.size(), value.size());
    for (std::size_t i=0;i<expected.size();++i) {
        BOOST_TEST_EQ(value[i], expected[i]);
    }
}
void test_names_as_array_5() {
    const auto expected = make_stdarray(
        std::string_view{"M0u7SIZSVWJ0KqQygT_6npmZv1XzZI5dJcwjQuqq6lIdlSJSpnAKhOg82qyVywwNq3cvvmnmAv7"}
, std::string_view{"SXEUFB6z"}
, std::string_view{"tDxT"}
, std::string_view{"sV2m6xg3MxKN1Xln2dXyBh8rkF7lUUfHIK8nK4FRzru2DXeT"}
, std::string_view{"ycEXe3x03PvbXqFJzOKMq8i4XLAZfyY2i4HONhv1Wx_"}

    );
    const auto value = boost::pfr::names_as_array<Aggregate5>();
    BOOST_TEST_EQ(expected.size(), value.size());
    for (std::size_t i=0;i<expected.size();++i) {
        BOOST_TEST_EQ(value[i], expected[i]);
    }
}



} // namespace testing

int main() {
    testing::test_get_name_1();
testing::test_get_name_2();
testing::test_get_name_3();
testing::test_get_name_4();
testing::test_get_name_5();

    testing::test_names_as_array_1();
testing::test_names_as_array_2();
testing::test_names_as_array_3();
testing::test_names_as_array_4();
testing::test_names_as_array_5();


    return boost::report_errors();
}

