# casupload-oci

`casupload-oci` downloads OCI/Docker container images from registries and uploads them to a previously configured Content Addressable Store (CAS) and Asset service (such as BuildGrid, Buildbarn or Buildfarm).

The tool fetches container image layers from the specified OCI registry, merges them into a directory tree, and uploads the result to the Content Addressable Storage (CAS) service.

## Usage

```
Usage: ./casupload-oci
   --help                      Display usage and exit.
   --version                   Print version information and exit. [optional]
   --remote                    URL for all services [optional]
   --instance                  Instance for all services [optional]
   --server-cert               Server TLS certificate for all services (PEM-encoded) [optional]
   --client-key                Client private TLS key for all services (PEM-encoded) [optional]
   --client-cert               Client TLS certificate for all services (PEM-encoded) [optional]
   --access-token              Authentication token for all services (JWT, OAuth token etc), will be included as an HTTP Authorization bearer token [optional]
   --token-reload-interval     Default access token refresh timeout [optional]
   --googleapi-auth            Use GoogleAPIAuth for all services [optional]
   --retry-limit               Retry limit for gRPC errors for all services [optional]
   --retry-delay               Retry delay for gRPC errors for all services [optional]
   --retry-on-code             gRPC status code(s) as string(s) to retry on for all services, e.g. 'UNKNOWN', 'INTERNAL' [optional]
   --request-timeout           Timeout for gRPC requests for all services (set to 0 to disable timeout) [optional]
   --min-throughput            Minimum throughput for gRPC requests for all services, bytes per seconds. The value may be suffixed with K, M, G or T. [optional]
   --keepalive-time            gRPC keepalive pings period for all services (set to 0 to disable keepalive pings) [optional]
   --load-balancing-policy     gRPC load balancing policy for all services (valid options are 'round_robin' and 'grpclb') [optional]
   --cas-remote                URL for the CAS service [optional]
   --cas-instance              Name of the CAS instance [optional]
   --cas-server-cert           Server TLS certificate for CAS (PEM-encoded) [optional]
   --cas-client-key            Client private TLS key for CAS (PEM-encoded) [optional]
   --cas-client-cert           Client TLS certificate for CAS (PEM-encoded) [optional]
   --cas-access-token          Authentication token for CAS (JWT, OAuth token etc), will be included as an HTTP Authorization bearer token [optional]
   --cas-token-reload-interval Access token refresh timeout for CAS service [optional]
   --cas-googleapi-auth        Use GoogleAPIAuth for CAS service [optional]
   --cas-retry-limit           Retry limit for gRPC errors for CAS service [optional]
   --cas-retry-delay           Retry delay for gRPC errors for CAS service [optional]
   --cas-retry-on-code         gRPC status code(s) as string(s) to retry on for CAS service e.g., 'UNKNOWN', 'INTERNAL' [optional]
   --cas-request-timeout       Timeout for gRPC requests for CAS service (set to 0 to disable timeout) [optional]
   --cas-min-throughput        Minimum throughput for gRPC requests for CAS service, bytes per seconds. The value may be suffixed with K, M, G or T. [optional]
   --cas-keepalive-time        gRPC keepalive pings period for CAS service (set to 0 to disable keepalive pings) [optional]
   --cas-load-balancing-policy gRPC load balancing policy for CAS service (valid options are 'round_robin' and 'grpclb') [optional]
   --ra-remote                 URL for the Asset service [optional]
   --ra-instance               Name of the Asset instance [optional]
   --ra-server-cert            Server TLS certificate for Asset (PEM-encoded) [optional]
   --ra-client-key             Client private TLS key for Asset (PEM-encoded) [optional]
   --ra-client-cert            Client TLS certificate for Asset (PEM-encoded) [optional]
   --ra-access-token           Authentication token for Asset (JWT, OAuth token etc), will be included as an HTTP Authorization bearer token [optional]
   --ra-token-reload-interval  Access token refresh timeout for Asset service [optional]
   --ra-googleapi-auth         Use GoogleAPIAuth for Asset service [optional]
   --ra-retry-limit            Retry limit for gRPC errors for Asset service [optional]
   --ra-retry-delay            Retry delay for gRPC errors for Asset service [optional]
   --ra-retry-on-code          gRPC status code(s) as string(s) to retry on for Asset service e.g., 'UNKNOWN', 'INTERNAL' [optional]
   --ra-request-timeout        Timeout for gRPC requests for Asset service (set to 0 to disable timeout) [optional]
   --ra-min-throughput         Minimum throughput for gRPC requests for Asset service, bytes per seconds. The value may be suffixed with K, M, G or T. [optional]
   --ra-keepalive-time         gRPC keepalive pings period for Asset service (set to 0 to disable keepalive pings) [optional]
   --ra-load-balancing-policy  gRPC load balancing policy for Asset service (valid options are 'round_robin' and 'grpclb') [optional]
   --oci-auth-token-path       Path to file containing Bearer token for OCI registry authentication [optional]
   --digest-function           Set a custom digest function. Default: SHA256
                                  Supported functions: SHA512, MD5, SHA1, SHA256, SHA384 [optional]
   --num-parallel-layer-threads     Set the number of parallel threads for OCI layer processing. Default: min(hardware-concurrency, 8) [optional]
   --output-digest-file        Write output root digest to the file in the form "<HASH>/<SIZE_BYTES>" [optional]
   --output-tree-digest-file   Write output tree digest to the file in the form "<HASH>/<SIZE_BYTES>" [optional]
   --log-level                 Log level (debug, error, info, trace, warning) [optional, default = "error"]
   --verbose                   Set log level to 'debug' [optional]
                               POSITIONAL [required]

Downloads the specified OCI/Docker container image from a registry, processes
the image layers into a directory tree, and uploads the result to CAS.

The tool connects to OCI-compatible registries (Docker Hub, Amazon ECR, Google
Container Registry, etc.) to fetch container images. It then merges all the
image layers into a single directory tree and uploads this tree to the
specified Content Addressable Storage service.

The output includes both root directory digest and tree digest that can be
used for remote execution or other BuildBox operations.

Example usage: casupload-oci --remote=http://localhost:50051 docker.io/alpine:latest
```

## Authentication

Most registries, including public ones like Docker Hub, require authentication tokens. You can obtain a token for Docker Hub using:

```bash
echo $(curl -s "https://auth.docker.io/token?service=registry.docker.io&scope=repository:frolvlad/alpine-gxx:pull" | jq -r .token) > .oci_token
casupload-oci --oci-auth-token-path=.oci_token --remote=http://localhost:50051 docker.io/frolvlad/alpine-gxx:latest
```
