/*******************************************************************************

Copyright (c) 2013 - 2015, Intel Corporation
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

 3. Neither the name of the Intel Corporation nor the names of its
    contributors may be used to endorse or promote products derived from
    this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

***************************************************************************/

#ifndef _AVF_STATUS_H_
#define _AVF_STATUS_H_

/* Error Codes */
enum avf_status_code {
	AVF_SUCCESS				= 0,
	AVF_ERR_NVM				= -1,
	AVF_ERR_NVM_CHECKSUM			= -2,
	AVF_ERR_PHY				= -3,
	AVF_ERR_CONFIG				= -4,
	AVF_ERR_PARAM				= -5,
	AVF_ERR_MAC_TYPE			= -6,
	AVF_ERR_UNKNOWN_PHY			= -7,
	AVF_ERR_LINK_SETUP			= -8,
	AVF_ERR_ADAPTER_STOPPED		= -9,
	AVF_ERR_INVALID_MAC_ADDR		= -10,
	AVF_ERR_DEVICE_NOT_SUPPORTED		= -11,
	AVF_ERR_MASTER_REQUESTS_PENDING	= -12,
	AVF_ERR_INVALID_LINK_SETTINGS		= -13,
	AVF_ERR_AUTONEG_NOT_COMPLETE		= -14,
	AVF_ERR_RESET_FAILED			= -15,
	AVF_ERR_SWFW_SYNC			= -16,
	AVF_ERR_NO_AVAILABLE_VSI		= -17,
	AVF_ERR_NO_MEMORY			= -18,
	AVF_ERR_BAD_PTR			= -19,
	AVF_ERR_RING_FULL			= -20,
	AVF_ERR_INVALID_PD_ID			= -21,
	AVF_ERR_INVALID_QP_ID			= -22,
	AVF_ERR_INVALID_CQ_ID			= -23,
	AVF_ERR_INVALID_CEQ_ID			= -24,
	AVF_ERR_INVALID_AEQ_ID			= -25,
	AVF_ERR_INVALID_SIZE			= -26,
	AVF_ERR_INVALID_ARP_INDEX		= -27,
	AVF_ERR_INVALID_FPM_FUNC_ID		= -28,
	AVF_ERR_QP_INVALID_MSG_SIZE		= -29,
	AVF_ERR_QP_TOOMANY_WRS_POSTED		= -30,
	AVF_ERR_INVALID_FRAG_COUNT		= -31,
	AVF_ERR_QUEUE_EMPTY			= -32,
	AVF_ERR_INVALID_ALIGNMENT		= -33,
	AVF_ERR_FLUSHED_QUEUE			= -34,
	AVF_ERR_INVALID_PUSH_PAGE_INDEX	= -35,
	AVF_ERR_INVALID_IMM_DATA_SIZE		= -36,
	AVF_ERR_TIMEOUT			= -37,
	AVF_ERR_OPCODE_MISMATCH		= -38,
	AVF_ERR_CQP_COMPL_ERROR		= -39,
	AVF_ERR_INVALID_VF_ID			= -40,
	AVF_ERR_INVALID_HMCFN_ID		= -41,
	AVF_ERR_BACKING_PAGE_ERROR		= -42,
	AVF_ERR_NO_PBLCHUNKS_AVAILABLE		= -43,
	AVF_ERR_INVALID_PBLE_INDEX		= -44,
	AVF_ERR_INVALID_SD_INDEX		= -45,
	AVF_ERR_INVALID_PAGE_DESC_INDEX	= -46,
	AVF_ERR_INVALID_SD_TYPE		= -47,
	AVF_ERR_MEMCPY_FAILED			= -48,
	AVF_ERR_INVALID_HMC_OBJ_INDEX		= -49,
	AVF_ERR_INVALID_HMC_OBJ_COUNT		= -50,
	AVF_ERR_INVALID_SRQ_ARM_LIMIT		= -51,
	AVF_ERR_SRQ_ENABLED			= -52,
	AVF_ERR_ADMIN_QUEUE_ERROR		= -53,
	AVF_ERR_ADMIN_QUEUE_TIMEOUT		= -54,
	AVF_ERR_BUF_TOO_SHORT			= -55,
	AVF_ERR_ADMIN_QUEUE_FULL		= -56,
	AVF_ERR_ADMIN_QUEUE_NO_WORK		= -57,
	AVF_ERR_BAD_IWARP_CQE			= -58,
	AVF_ERR_NVM_BLANK_MODE			= -59,
	AVF_ERR_NOT_IMPLEMENTED		= -60,
	AVF_ERR_PE_DOORBELL_NOT_ENABLED	= -61,
	AVF_ERR_DIAG_TEST_FAILED		= -62,
	AVF_ERR_NOT_READY			= -63,
	AVF_NOT_SUPPORTED			= -64,
	AVF_ERR_FIRMWARE_API_VERSION		= -65,
	AVF_ERR_ADMIN_QUEUE_CRITICAL_ERROR	= -66,
};

#endif /* _AVF_STATUS_H_ */
