#!/bin/sh

# $Id: check.sh,v 1.23 2009/01/27 16:09:11 potyra Exp $
#
# Copyright (C) 2007-2009 FAUcc Team.
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.
#


file=$1

f=`echo ${file} | sed -e 's/\..$//'`

ulimit -S -t 10
ulimit -S -m 1000000

#
# Generate pre-compile file.
#
if [ -f ${f}.c ] ; then
	gcc -m32 -D_GNU_SOURCE -E ${f}.c > ${f}.i
fi

#
# Generate optimized C file.
#
# ./faucc -b i386 < ${f}.i > ${f}.simple
# 
# if [ ! -s ${f}.simple ] ; then
# 	rm ${f}.simple
# else
# 	#
# 	# Try to compile generated file.
# 	#
# 	cp ${f}.simple gcc.c
# 	gcc -fno-builtin -m32 -S gcc.c > ${f}.simple.log 2>&1
# 	if [ -s ${f}.simple.log ] ; then
# 		head -10 ${f}.simple.log
# 	else
# 		rm ${f}.simple.log
# 	fi
# 	rm -f gcc.c gcc.s
# fi

#
# Generate optimized assembler file.
#
for t in i286 i386 ; do
	for sizeof_int in 2 4 ; do
		echo "target=${t}, sizeof(int)=${sizeof_int}"

		./faucc -S -b ${t} -f sizeof_int=${sizeof_int} -o ${f}.${t}.${sizeof_int}.s ${f}.i

		if [ ! -s ${f}.${t}.${sizeof_int}.s ] ; then
			rm -f ${f}.${t}.${sizeof_int}.s
		else
			#
			# Try to assemble generated file.
			#
			cp ${f}.${t}.${sizeof_int}.s ${t}.${sizeof_int}.s
			gcc -m32 -c ${t}.${sizeof_int}.s > ${f}.${t}.${sizeof_int}.s.log 2>&1
			if [ -s ${f}.${t}.${sizeof_int}.s.log ] ; then
				head -10 ${f}.${t}.${sizeof_int}.s.log
			else
				rm ${f}.${t}.${sizeof_int}.s.log
			fi
			rm -f ${t}.${sizeof_int}.s ${t}.${sizeof_int}.o
		fi
	done
done

ulimit -S -m unlimited
ulimit -S -t unlimited
