// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateGatewayRoute = "CreateGatewayRoute"

// CreateGatewayRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateGatewayRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGatewayRoute for more information on using the CreateGatewayRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGatewayRouteRequest method.
//	req, resp := client.CreateGatewayRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateGatewayRoute
func (c *AppMesh) CreateGatewayRouteRequest(input *CreateGatewayRouteInput) (req *request.Request, output *CreateGatewayRouteOutput) {
	op := &request.Operation{
		Name:       opCreateGatewayRoute,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes",
	}

	if input == nil {
		input = &CreateGatewayRouteInput{}
	}

	output = &CreateGatewayRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGatewayRoute API operation for AWS App Mesh.
//
// Creates a gateway route.
//
// A gateway route is attached to a virtual gateway and routes traffic to an
// existing virtual service. If a route matches a request, it can distribute
// traffic to a target virtual service.
//
// For more information about gateway routes, see Gateway routes (https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateGatewayRoute for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - LimitExceededException
//     You have exceeded a service limit for your account. For more information,
//     see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
//     in the App Mesh User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateGatewayRoute
func (c *AppMesh) CreateGatewayRoute(input *CreateGatewayRouteInput) (*CreateGatewayRouteOutput, error) {
	req, out := c.CreateGatewayRouteRequest(input)
	return out, req.Send()
}

// CreateGatewayRouteWithContext is the same as CreateGatewayRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGatewayRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateGatewayRouteWithContext(ctx aws.Context, input *CreateGatewayRouteInput, opts ...request.Option) (*CreateGatewayRouteOutput, error) {
	req, out := c.CreateGatewayRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMesh = "CreateMesh"

// CreateMeshRequest generates a "aws/request.Request" representing the
// client's request for the CreateMesh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMesh for more information on using the CreateMesh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMeshRequest method.
//	req, resp := client.CreateMeshRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateMesh
func (c *AppMesh) CreateMeshRequest(input *CreateMeshInput) (req *request.Request, output *CreateMeshOutput) {
	op := &request.Operation{
		Name:       opCreateMesh,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes",
	}

	if input == nil {
		input = &CreateMeshInput{}
	}

	output = &CreateMeshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMesh API operation for AWS App Mesh.
//
// Creates a service mesh.
//
// A service mesh is a logical boundary for network traffic between services
// that are represented by resources within the mesh. After you create your
// service mesh, you can create virtual services, virtual nodes, virtual routers,
// and routes to distribute traffic between the applications in your mesh.
//
// For more information about service meshes, see Service meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateMesh for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - LimitExceededException
//     You have exceeded a service limit for your account. For more information,
//     see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
//     in the App Mesh User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateMesh
func (c *AppMesh) CreateMesh(input *CreateMeshInput) (*CreateMeshOutput, error) {
	req, out := c.CreateMeshRequest(input)
	return out, req.Send()
}

// CreateMeshWithContext is the same as CreateMesh with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMesh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateMeshWithContext(ctx aws.Context, input *CreateMeshInput, opts ...request.Option) (*CreateMeshOutput, error) {
	req, out := c.CreateMeshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoute = "CreateRoute"

// CreateRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoute for more information on using the CreateRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRouteRequest method.
//	req, resp := client.CreateRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateRoute
func (c *AppMesh) CreateRouteRequest(input *CreateRouteInput) (req *request.Request, output *CreateRouteOutput) {
	op := &request.Operation{
		Name:       opCreateRoute,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes",
	}

	if input == nil {
		input = &CreateRouteInput{}
	}

	output = &CreateRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoute API operation for AWS App Mesh.
//
// Creates a route that is associated with a virtual router.
//
// You can route several different protocols and define a retry policy for a
// route. Traffic can be routed to one or more virtual nodes.
//
// For more information about routes, see Routes (https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateRoute for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - LimitExceededException
//     You have exceeded a service limit for your account. For more information,
//     see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
//     in the App Mesh User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateRoute
func (c *AppMesh) CreateRoute(input *CreateRouteInput) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	return out, req.Send()
}

// CreateRouteWithContext is the same as CreateRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateRouteWithContext(ctx aws.Context, input *CreateRouteInput, opts ...request.Option) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVirtualGateway = "CreateVirtualGateway"

// CreateVirtualGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateVirtualGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVirtualGateway for more information on using the CreateVirtualGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVirtualGatewayRequest method.
//	req, resp := client.CreateVirtualGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualGateway
func (c *AppMesh) CreateVirtualGatewayRequest(input *CreateVirtualGatewayInput) (req *request.Request, output *CreateVirtualGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateVirtualGateway,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateways",
	}

	if input == nil {
		input = &CreateVirtualGatewayInput{}
	}

	output = &CreateVirtualGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVirtualGateway API operation for AWS App Mesh.
//
// Creates a virtual gateway.
//
// A virtual gateway allows resources outside your mesh to communicate to resources
// that are inside your mesh. The virtual gateway represents an Envoy proxy
// running in an Amazon ECS task, in a Kubernetes service, or on an Amazon EC2
// instance. Unlike a virtual node, which represents an Envoy running with an
// application, a virtual gateway represents Envoy deployed by itself.
//
// For more information about virtual gateways, see Virtual gateways (https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateVirtualGateway for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - LimitExceededException
//     You have exceeded a service limit for your account. For more information,
//     see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
//     in the App Mesh User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualGateway
func (c *AppMesh) CreateVirtualGateway(input *CreateVirtualGatewayInput) (*CreateVirtualGatewayOutput, error) {
	req, out := c.CreateVirtualGatewayRequest(input)
	return out, req.Send()
}

// CreateVirtualGatewayWithContext is the same as CreateVirtualGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVirtualGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateVirtualGatewayWithContext(ctx aws.Context, input *CreateVirtualGatewayInput, opts ...request.Option) (*CreateVirtualGatewayOutput, error) {
	req, out := c.CreateVirtualGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVirtualNode = "CreateVirtualNode"

// CreateVirtualNodeRequest generates a "aws/request.Request" representing the
// client's request for the CreateVirtualNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVirtualNode for more information on using the CreateVirtualNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVirtualNodeRequest method.
//	req, resp := client.CreateVirtualNodeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualNode
func (c *AppMesh) CreateVirtualNodeRequest(input *CreateVirtualNodeInput) (req *request.Request, output *CreateVirtualNodeOutput) {
	op := &request.Operation{
		Name:       opCreateVirtualNode,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualNodes",
	}

	if input == nil {
		input = &CreateVirtualNodeInput{}
	}

	output = &CreateVirtualNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVirtualNode API operation for AWS App Mesh.
//
// Creates a virtual node within a service mesh.
//
// A virtual node acts as a logical pointer to a particular task group, such
// as an Amazon ECS service or a Kubernetes deployment. When you create a virtual
// node, you can specify the service discovery information for your task group,
// and whether the proxy running in a task group will communicate with other
// proxies using Transport Layer Security (TLS).
//
// You define a listener for any inbound traffic that your virtual node expects.
// Any virtual service that your virtual node expects to communicate to is specified
// as a backend.
//
// The response metadata for your new virtual node contains the arn that is
// associated with the virtual node. Set this value to the full ARN; for example,
// arn:aws:appmesh:us-west-2:123456789012:myMesh/default/virtualNode/myApp)
// as the APPMESH_RESOURCE_ARN environment variable for your task group's Envoy
// proxy container in your task definition or pod spec. This is then mapped
// to the node.id and node.cluster Envoy parameters.
//
// By default, App Mesh uses the name of the resource you specified in APPMESH_RESOURCE_ARN
// when Envoy is referring to itself in metrics and traces. You can override
// this behavior by setting the APPMESH_RESOURCE_CLUSTER environment variable
// with your own name.
//
// For more information about virtual nodes, see Virtual nodes (https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html).
// You must be using 1.15.0 or later of the Envoy image when setting these variables.
// For more information aboutApp Mesh Envoy variables, see Envoy image (https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html)
// in the App Mesh User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateVirtualNode for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - LimitExceededException
//     You have exceeded a service limit for your account. For more information,
//     see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
//     in the App Mesh User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualNode
func (c *AppMesh) CreateVirtualNode(input *CreateVirtualNodeInput) (*CreateVirtualNodeOutput, error) {
	req, out := c.CreateVirtualNodeRequest(input)
	return out, req.Send()
}

// CreateVirtualNodeWithContext is the same as CreateVirtualNode with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVirtualNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateVirtualNodeWithContext(ctx aws.Context, input *CreateVirtualNodeInput, opts ...request.Option) (*CreateVirtualNodeOutput, error) {
	req, out := c.CreateVirtualNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVirtualRouter = "CreateVirtualRouter"

// CreateVirtualRouterRequest generates a "aws/request.Request" representing the
// client's request for the CreateVirtualRouter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVirtualRouter for more information on using the CreateVirtualRouter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVirtualRouterRequest method.
//	req, resp := client.CreateVirtualRouterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualRouter
func (c *AppMesh) CreateVirtualRouterRequest(input *CreateVirtualRouterInput) (req *request.Request, output *CreateVirtualRouterOutput) {
	op := &request.Operation{
		Name:       opCreateVirtualRouter,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouters",
	}

	if input == nil {
		input = &CreateVirtualRouterInput{}
	}

	output = &CreateVirtualRouterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVirtualRouter API operation for AWS App Mesh.
//
// Creates a virtual router within a service mesh.
//
// Specify a listener for any inbound traffic that your virtual router receives.
// Create a virtual router for each protocol and port that you need to route.
// Virtual routers handle traffic for one or more virtual services within your
// mesh. After you create your virtual router, create and associate routes for
// your virtual router that direct incoming requests to different virtual nodes.
//
// For more information about virtual routers, see Virtual routers (https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateVirtualRouter for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - LimitExceededException
//     You have exceeded a service limit for your account. For more information,
//     see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
//     in the App Mesh User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualRouter
func (c *AppMesh) CreateVirtualRouter(input *CreateVirtualRouterInput) (*CreateVirtualRouterOutput, error) {
	req, out := c.CreateVirtualRouterRequest(input)
	return out, req.Send()
}

// CreateVirtualRouterWithContext is the same as CreateVirtualRouter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVirtualRouter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateVirtualRouterWithContext(ctx aws.Context, input *CreateVirtualRouterInput, opts ...request.Option) (*CreateVirtualRouterOutput, error) {
	req, out := c.CreateVirtualRouterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVirtualService = "CreateVirtualService"

// CreateVirtualServiceRequest generates a "aws/request.Request" representing the
// client's request for the CreateVirtualService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVirtualService for more information on using the CreateVirtualService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVirtualServiceRequest method.
//	req, resp := client.CreateVirtualServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualService
func (c *AppMesh) CreateVirtualServiceRequest(input *CreateVirtualServiceInput) (req *request.Request, output *CreateVirtualServiceOutput) {
	op := &request.Operation{
		Name:       opCreateVirtualService,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualServices",
	}

	if input == nil {
		input = &CreateVirtualServiceInput{}
	}

	output = &CreateVirtualServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVirtualService API operation for AWS App Mesh.
//
// Creates a virtual service within a service mesh.
//
// A virtual service is an abstraction of a real service that is provided by
// a virtual node directly or indirectly by means of a virtual router. Dependent
// services call your virtual service by its virtualServiceName, and those requests
// are routed to the virtual node or virtual router that is specified as the
// provider for the virtual service.
//
// For more information about virtual services, see Virtual services (https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateVirtualService for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - LimitExceededException
//     You have exceeded a service limit for your account. For more information,
//     see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
//     in the App Mesh User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualService
func (c *AppMesh) CreateVirtualService(input *CreateVirtualServiceInput) (*CreateVirtualServiceOutput, error) {
	req, out := c.CreateVirtualServiceRequest(input)
	return out, req.Send()
}

// CreateVirtualServiceWithContext is the same as CreateVirtualService with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVirtualService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateVirtualServiceWithContext(ctx aws.Context, input *CreateVirtualServiceInput, opts ...request.Option) (*CreateVirtualServiceOutput, error) {
	req, out := c.CreateVirtualServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGatewayRoute = "DeleteGatewayRoute"

// DeleteGatewayRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGatewayRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGatewayRoute for more information on using the DeleteGatewayRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGatewayRouteRequest method.
//	req, resp := client.DeleteGatewayRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteGatewayRoute
func (c *AppMesh) DeleteGatewayRouteRequest(input *DeleteGatewayRouteInput) (req *request.Request, output *DeleteGatewayRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteGatewayRoute,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}",
	}

	if input == nil {
		input = &DeleteGatewayRouteInput{}
	}

	output = &DeleteGatewayRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGatewayRoute API operation for AWS App Mesh.
//
// Deletes an existing gateway route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteGatewayRoute for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ResourceInUseException
//     You can't delete the specified resource because it's in use or required by
//     another resource.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteGatewayRoute
func (c *AppMesh) DeleteGatewayRoute(input *DeleteGatewayRouteInput) (*DeleteGatewayRouteOutput, error) {
	req, out := c.DeleteGatewayRouteRequest(input)
	return out, req.Send()
}

// DeleteGatewayRouteWithContext is the same as DeleteGatewayRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGatewayRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteGatewayRouteWithContext(ctx aws.Context, input *DeleteGatewayRouteInput, opts ...request.Option) (*DeleteGatewayRouteOutput, error) {
	req, out := c.DeleteGatewayRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMesh = "DeleteMesh"

// DeleteMeshRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMesh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMesh for more information on using the DeleteMesh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMeshRequest method.
//	req, resp := client.DeleteMeshRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteMesh
func (c *AppMesh) DeleteMeshRequest(input *DeleteMeshInput) (req *request.Request, output *DeleteMeshOutput) {
	op := &request.Operation{
		Name:       opDeleteMesh,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}",
	}

	if input == nil {
		input = &DeleteMeshInput{}
	}

	output = &DeleteMeshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMesh API operation for AWS App Mesh.
//
// Deletes an existing service mesh.
//
// You must delete all resources (virtual services, routes, virtual routers,
// and virtual nodes) in the service mesh before you can delete the mesh itself.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteMesh for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ResourceInUseException
//     You can't delete the specified resource because it's in use or required by
//     another resource.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteMesh
func (c *AppMesh) DeleteMesh(input *DeleteMeshInput) (*DeleteMeshOutput, error) {
	req, out := c.DeleteMeshRequest(input)
	return out, req.Send()
}

// DeleteMeshWithContext is the same as DeleteMesh with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMesh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteMeshWithContext(ctx aws.Context, input *DeleteMeshInput, opts ...request.Option) (*DeleteMeshOutput, error) {
	req, out := c.DeleteMeshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoute = "DeleteRoute"

// DeleteRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoute for more information on using the DeleteRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRouteRequest method.
//	req, resp := client.DeleteRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteRoute
func (c *AppMesh) DeleteRouteRequest(input *DeleteRouteInput) (req *request.Request, output *DeleteRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteRoute,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
	}

	if input == nil {
		input = &DeleteRouteInput{}
	}

	output = &DeleteRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRoute API operation for AWS App Mesh.
//
// Deletes an existing route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteRoute for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ResourceInUseException
//     You can't delete the specified resource because it's in use or required by
//     another resource.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteRoute
func (c *AppMesh) DeleteRoute(input *DeleteRouteInput) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	return out, req.Send()
}

// DeleteRouteWithContext is the same as DeleteRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteRouteWithContext(ctx aws.Context, input *DeleteRouteInput, opts ...request.Option) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVirtualGateway = "DeleteVirtualGateway"

// DeleteVirtualGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVirtualGateway for more information on using the DeleteVirtualGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVirtualGatewayRequest method.
//	req, resp := client.DeleteVirtualGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualGateway
func (c *AppMesh) DeleteVirtualGatewayRequest(input *DeleteVirtualGatewayInput) (req *request.Request, output *DeleteVirtualGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualGateway,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
	}

	if input == nil {
		input = &DeleteVirtualGatewayInput{}
	}

	output = &DeleteVirtualGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVirtualGateway API operation for AWS App Mesh.
//
// Deletes an existing virtual gateway. You cannot delete a virtual gateway
// if any gateway routes are associated to it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteVirtualGateway for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ResourceInUseException
//     You can't delete the specified resource because it's in use or required by
//     another resource.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualGateway
func (c *AppMesh) DeleteVirtualGateway(input *DeleteVirtualGatewayInput) (*DeleteVirtualGatewayOutput, error) {
	req, out := c.DeleteVirtualGatewayRequest(input)
	return out, req.Send()
}

// DeleteVirtualGatewayWithContext is the same as DeleteVirtualGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVirtualGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteVirtualGatewayWithContext(ctx aws.Context, input *DeleteVirtualGatewayInput, opts ...request.Option) (*DeleteVirtualGatewayOutput, error) {
	req, out := c.DeleteVirtualGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVirtualNode = "DeleteVirtualNode"

// DeleteVirtualNodeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVirtualNode for more information on using the DeleteVirtualNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVirtualNodeRequest method.
//	req, resp := client.DeleteVirtualNodeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualNode
func (c *AppMesh) DeleteVirtualNodeRequest(input *DeleteVirtualNodeInput) (req *request.Request, output *DeleteVirtualNodeOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualNode,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
	}

	if input == nil {
		input = &DeleteVirtualNodeInput{}
	}

	output = &DeleteVirtualNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVirtualNode API operation for AWS App Mesh.
//
// Deletes an existing virtual node.
//
// You must delete any virtual services that list a virtual node as a service
// provider before you can delete the virtual node itself.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteVirtualNode for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ResourceInUseException
//     You can't delete the specified resource because it's in use or required by
//     another resource.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualNode
func (c *AppMesh) DeleteVirtualNode(input *DeleteVirtualNodeInput) (*DeleteVirtualNodeOutput, error) {
	req, out := c.DeleteVirtualNodeRequest(input)
	return out, req.Send()
}

// DeleteVirtualNodeWithContext is the same as DeleteVirtualNode with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVirtualNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteVirtualNodeWithContext(ctx aws.Context, input *DeleteVirtualNodeInput, opts ...request.Option) (*DeleteVirtualNodeOutput, error) {
	req, out := c.DeleteVirtualNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVirtualRouter = "DeleteVirtualRouter"

// DeleteVirtualRouterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualRouter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVirtualRouter for more information on using the DeleteVirtualRouter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVirtualRouterRequest method.
//	req, resp := client.DeleteVirtualRouterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualRouter
func (c *AppMesh) DeleteVirtualRouterRequest(input *DeleteVirtualRouterInput) (req *request.Request, output *DeleteVirtualRouterOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualRouter,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
	}

	if input == nil {
		input = &DeleteVirtualRouterInput{}
	}

	output = &DeleteVirtualRouterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVirtualRouter API operation for AWS App Mesh.
//
// Deletes an existing virtual router.
//
// You must delete any routes associated with the virtual router before you
// can delete the router itself.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteVirtualRouter for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ResourceInUseException
//     You can't delete the specified resource because it's in use or required by
//     another resource.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualRouter
func (c *AppMesh) DeleteVirtualRouter(input *DeleteVirtualRouterInput) (*DeleteVirtualRouterOutput, error) {
	req, out := c.DeleteVirtualRouterRequest(input)
	return out, req.Send()
}

// DeleteVirtualRouterWithContext is the same as DeleteVirtualRouter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVirtualRouter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteVirtualRouterWithContext(ctx aws.Context, input *DeleteVirtualRouterInput, opts ...request.Option) (*DeleteVirtualRouterOutput, error) {
	req, out := c.DeleteVirtualRouterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVirtualService = "DeleteVirtualService"

// DeleteVirtualServiceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVirtualService for more information on using the DeleteVirtualService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVirtualServiceRequest method.
//	req, resp := client.DeleteVirtualServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualService
func (c *AppMesh) DeleteVirtualServiceRequest(input *DeleteVirtualServiceInput) (req *request.Request, output *DeleteVirtualServiceOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualService,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
	}

	if input == nil {
		input = &DeleteVirtualServiceInput{}
	}

	output = &DeleteVirtualServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVirtualService API operation for AWS App Mesh.
//
// Deletes an existing virtual service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteVirtualService for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ResourceInUseException
//     You can't delete the specified resource because it's in use or required by
//     another resource.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualService
func (c *AppMesh) DeleteVirtualService(input *DeleteVirtualServiceInput) (*DeleteVirtualServiceOutput, error) {
	req, out := c.DeleteVirtualServiceRequest(input)
	return out, req.Send()
}

// DeleteVirtualServiceWithContext is the same as DeleteVirtualService with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVirtualService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteVirtualServiceWithContext(ctx aws.Context, input *DeleteVirtualServiceInput, opts ...request.Option) (*DeleteVirtualServiceOutput, error) {
	req, out := c.DeleteVirtualServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGatewayRoute = "DescribeGatewayRoute"

// DescribeGatewayRouteRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGatewayRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGatewayRoute for more information on using the DescribeGatewayRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGatewayRouteRequest method.
//	req, resp := client.DescribeGatewayRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeGatewayRoute
func (c *AppMesh) DescribeGatewayRouteRequest(input *DescribeGatewayRouteInput) (req *request.Request, output *DescribeGatewayRouteOutput) {
	op := &request.Operation{
		Name:       opDescribeGatewayRoute,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}",
	}

	if input == nil {
		input = &DescribeGatewayRouteInput{}
	}

	output = &DescribeGatewayRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGatewayRoute API operation for AWS App Mesh.
//
// Describes an existing gateway route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeGatewayRoute for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeGatewayRoute
func (c *AppMesh) DescribeGatewayRoute(input *DescribeGatewayRouteInput) (*DescribeGatewayRouteOutput, error) {
	req, out := c.DescribeGatewayRouteRequest(input)
	return out, req.Send()
}

// DescribeGatewayRouteWithContext is the same as DescribeGatewayRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGatewayRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeGatewayRouteWithContext(ctx aws.Context, input *DescribeGatewayRouteInput, opts ...request.Option) (*DescribeGatewayRouteOutput, error) {
	req, out := c.DescribeGatewayRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMesh = "DescribeMesh"

// DescribeMeshRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMesh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMesh for more information on using the DescribeMesh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMeshRequest method.
//	req, resp := client.DescribeMeshRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeMesh
func (c *AppMesh) DescribeMeshRequest(input *DescribeMeshInput) (req *request.Request, output *DescribeMeshOutput) {
	op := &request.Operation{
		Name:       opDescribeMesh,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}",
	}

	if input == nil {
		input = &DescribeMeshInput{}
	}

	output = &DescribeMeshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMesh API operation for AWS App Mesh.
//
// Describes an existing service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeMesh for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeMesh
func (c *AppMesh) DescribeMesh(input *DescribeMeshInput) (*DescribeMeshOutput, error) {
	req, out := c.DescribeMeshRequest(input)
	return out, req.Send()
}

// DescribeMeshWithContext is the same as DescribeMesh with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMesh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeMeshWithContext(ctx aws.Context, input *DescribeMeshInput, opts ...request.Option) (*DescribeMeshOutput, error) {
	req, out := c.DescribeMeshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRoute = "DescribeRoute"

// DescribeRouteRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRoute for more information on using the DescribeRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRouteRequest method.
//	req, resp := client.DescribeRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeRoute
func (c *AppMesh) DescribeRouteRequest(input *DescribeRouteInput) (req *request.Request, output *DescribeRouteOutput) {
	op := &request.Operation{
		Name:       opDescribeRoute,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
	}

	if input == nil {
		input = &DescribeRouteInput{}
	}

	output = &DescribeRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRoute API operation for AWS App Mesh.
//
// Describes an existing route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeRoute for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeRoute
func (c *AppMesh) DescribeRoute(input *DescribeRouteInput) (*DescribeRouteOutput, error) {
	req, out := c.DescribeRouteRequest(input)
	return out, req.Send()
}

// DescribeRouteWithContext is the same as DescribeRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeRouteWithContext(ctx aws.Context, input *DescribeRouteInput, opts ...request.Option) (*DescribeRouteOutput, error) {
	req, out := c.DescribeRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualGateway = "DescribeVirtualGateway"

// DescribeVirtualGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualGateway for more information on using the DescribeVirtualGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeVirtualGatewayRequest method.
//	req, resp := client.DescribeVirtualGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualGateway
func (c *AppMesh) DescribeVirtualGatewayRequest(input *DescribeVirtualGatewayInput) (req *request.Request, output *DescribeVirtualGatewayOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualGateway,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
	}

	if input == nil {
		input = &DescribeVirtualGatewayInput{}
	}

	output = &DescribeVirtualGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualGateway API operation for AWS App Mesh.
//
// Describes an existing virtual gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeVirtualGateway for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualGateway
func (c *AppMesh) DescribeVirtualGateway(input *DescribeVirtualGatewayInput) (*DescribeVirtualGatewayOutput, error) {
	req, out := c.DescribeVirtualGatewayRequest(input)
	return out, req.Send()
}

// DescribeVirtualGatewayWithContext is the same as DescribeVirtualGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeVirtualGatewayWithContext(ctx aws.Context, input *DescribeVirtualGatewayInput, opts ...request.Option) (*DescribeVirtualGatewayOutput, error) {
	req, out := c.DescribeVirtualGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualNode = "DescribeVirtualNode"

// DescribeVirtualNodeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualNode for more information on using the DescribeVirtualNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeVirtualNodeRequest method.
//	req, resp := client.DescribeVirtualNodeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualNode
func (c *AppMesh) DescribeVirtualNodeRequest(input *DescribeVirtualNodeInput) (req *request.Request, output *DescribeVirtualNodeOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualNode,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
	}

	if input == nil {
		input = &DescribeVirtualNodeInput{}
	}

	output = &DescribeVirtualNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualNode API operation for AWS App Mesh.
//
// Describes an existing virtual node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeVirtualNode for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualNode
func (c *AppMesh) DescribeVirtualNode(input *DescribeVirtualNodeInput) (*DescribeVirtualNodeOutput, error) {
	req, out := c.DescribeVirtualNodeRequest(input)
	return out, req.Send()
}

// DescribeVirtualNodeWithContext is the same as DescribeVirtualNode with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeVirtualNodeWithContext(ctx aws.Context, input *DescribeVirtualNodeInput, opts ...request.Option) (*DescribeVirtualNodeOutput, error) {
	req, out := c.DescribeVirtualNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualRouter = "DescribeVirtualRouter"

// DescribeVirtualRouterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualRouter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualRouter for more information on using the DescribeVirtualRouter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeVirtualRouterRequest method.
//	req, resp := client.DescribeVirtualRouterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualRouter
func (c *AppMesh) DescribeVirtualRouterRequest(input *DescribeVirtualRouterInput) (req *request.Request, output *DescribeVirtualRouterOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualRouter,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
	}

	if input == nil {
		input = &DescribeVirtualRouterInput{}
	}

	output = &DescribeVirtualRouterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualRouter API operation for AWS App Mesh.
//
// Describes an existing virtual router.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeVirtualRouter for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualRouter
func (c *AppMesh) DescribeVirtualRouter(input *DescribeVirtualRouterInput) (*DescribeVirtualRouterOutput, error) {
	req, out := c.DescribeVirtualRouterRequest(input)
	return out, req.Send()
}

// DescribeVirtualRouterWithContext is the same as DescribeVirtualRouter with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualRouter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeVirtualRouterWithContext(ctx aws.Context, input *DescribeVirtualRouterInput, opts ...request.Option) (*DescribeVirtualRouterOutput, error) {
	req, out := c.DescribeVirtualRouterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualService = "DescribeVirtualService"

// DescribeVirtualServiceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualService for more information on using the DescribeVirtualService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeVirtualServiceRequest method.
//	req, resp := client.DescribeVirtualServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualService
func (c *AppMesh) DescribeVirtualServiceRequest(input *DescribeVirtualServiceInput) (req *request.Request, output *DescribeVirtualServiceOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualService,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
	}

	if input == nil {
		input = &DescribeVirtualServiceInput{}
	}

	output = &DescribeVirtualServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualService API operation for AWS App Mesh.
//
// Describes an existing virtual service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeVirtualService for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualService
func (c *AppMesh) DescribeVirtualService(input *DescribeVirtualServiceInput) (*DescribeVirtualServiceOutput, error) {
	req, out := c.DescribeVirtualServiceRequest(input)
	return out, req.Send()
}

// DescribeVirtualServiceWithContext is the same as DescribeVirtualService with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeVirtualServiceWithContext(ctx aws.Context, input *DescribeVirtualServiceInput, opts ...request.Option) (*DescribeVirtualServiceOutput, error) {
	req, out := c.DescribeVirtualServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGatewayRoutes = "ListGatewayRoutes"

// ListGatewayRoutesRequest generates a "aws/request.Request" representing the
// client's request for the ListGatewayRoutes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGatewayRoutes for more information on using the ListGatewayRoutes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGatewayRoutesRequest method.
//	req, resp := client.ListGatewayRoutesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListGatewayRoutes
func (c *AppMesh) ListGatewayRoutesRequest(input *ListGatewayRoutesInput) (req *request.Request, output *ListGatewayRoutesOutput) {
	op := &request.Operation{
		Name:       opListGatewayRoutes,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewayRoutesInput{}
	}

	output = &ListGatewayRoutesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGatewayRoutes API operation for AWS App Mesh.
//
// Returns a list of existing gateway routes that are associated to a virtual
// gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListGatewayRoutes for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListGatewayRoutes
func (c *AppMesh) ListGatewayRoutes(input *ListGatewayRoutesInput) (*ListGatewayRoutesOutput, error) {
	req, out := c.ListGatewayRoutesRequest(input)
	return out, req.Send()
}

// ListGatewayRoutesWithContext is the same as ListGatewayRoutes with the addition of
// the ability to pass a context and additional request options.
//
// See ListGatewayRoutes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListGatewayRoutesWithContext(ctx aws.Context, input *ListGatewayRoutesInput, opts ...request.Option) (*ListGatewayRoutesOutput, error) {
	req, out := c.ListGatewayRoutesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGatewayRoutesPages iterates over the pages of a ListGatewayRoutes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGatewayRoutes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGatewayRoutes operation.
//	pageNum := 0
//	err := client.ListGatewayRoutesPages(params,
//	    func(page *appmesh.ListGatewayRoutesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppMesh) ListGatewayRoutesPages(input *ListGatewayRoutesInput, fn func(*ListGatewayRoutesOutput, bool) bool) error {
	return c.ListGatewayRoutesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGatewayRoutesPagesWithContext same as ListGatewayRoutesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListGatewayRoutesPagesWithContext(ctx aws.Context, input *ListGatewayRoutesInput, fn func(*ListGatewayRoutesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGatewayRoutesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGatewayRoutesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGatewayRoutesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMeshes = "ListMeshes"

// ListMeshesRequest generates a "aws/request.Request" representing the
// client's request for the ListMeshes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMeshes for more information on using the ListMeshes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMeshesRequest method.
//	req, resp := client.ListMeshesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListMeshes
func (c *AppMesh) ListMeshesRequest(input *ListMeshesInput) (req *request.Request, output *ListMeshesOutput) {
	op := &request.Operation{
		Name:       opListMeshes,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMeshesInput{}
	}

	output = &ListMeshesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMeshes API operation for AWS App Mesh.
//
// Returns a list of existing service meshes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListMeshes for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListMeshes
func (c *AppMesh) ListMeshes(input *ListMeshesInput) (*ListMeshesOutput, error) {
	req, out := c.ListMeshesRequest(input)
	return out, req.Send()
}

// ListMeshesWithContext is the same as ListMeshes with the addition of
// the ability to pass a context and additional request options.
//
// See ListMeshes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListMeshesWithContext(ctx aws.Context, input *ListMeshesInput, opts ...request.Option) (*ListMeshesOutput, error) {
	req, out := c.ListMeshesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMeshesPages iterates over the pages of a ListMeshes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMeshes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMeshes operation.
//	pageNum := 0
//	err := client.ListMeshesPages(params,
//	    func(page *appmesh.ListMeshesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppMesh) ListMeshesPages(input *ListMeshesInput, fn func(*ListMeshesOutput, bool) bool) error {
	return c.ListMeshesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMeshesPagesWithContext same as ListMeshesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListMeshesPagesWithContext(ctx aws.Context, input *ListMeshesInput, fn func(*ListMeshesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMeshesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMeshesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMeshesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRoutes = "ListRoutes"

// ListRoutesRequest generates a "aws/request.Request" representing the
// client's request for the ListRoutes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoutes for more information on using the ListRoutes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRoutesRequest method.
//	req, resp := client.ListRoutesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListRoutes
func (c *AppMesh) ListRoutesRequest(input *ListRoutesInput) (req *request.Request, output *ListRoutesOutput) {
	op := &request.Operation{
		Name:       opListRoutes,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoutesInput{}
	}

	output = &ListRoutesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoutes API operation for AWS App Mesh.
//
// Returns a list of existing routes in a service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListRoutes for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListRoutes
func (c *AppMesh) ListRoutes(input *ListRoutesInput) (*ListRoutesOutput, error) {
	req, out := c.ListRoutesRequest(input)
	return out, req.Send()
}

// ListRoutesWithContext is the same as ListRoutes with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoutes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListRoutesWithContext(ctx aws.Context, input *ListRoutesInput, opts ...request.Option) (*ListRoutesOutput, error) {
	req, out := c.ListRoutesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoutesPages iterates over the pages of a ListRoutes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoutes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRoutes operation.
//	pageNum := 0
//	err := client.ListRoutesPages(params,
//	    func(page *appmesh.ListRoutesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppMesh) ListRoutesPages(input *ListRoutesInput, fn func(*ListRoutesOutput, bool) bool) error {
	return c.ListRoutesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoutesPagesWithContext same as ListRoutesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListRoutesPagesWithContext(ctx aws.Context, input *ListRoutesInput, fn func(*ListRoutesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoutesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoutesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRoutesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListTagsForResource
func (c *AppMesh) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/tags",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS App Mesh.
//
// List the tags for an App Mesh resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListTagsForResource
func (c *AppMesh) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTagsForResource operation.
//	pageNum := 0
//	err := client.ListTagsForResourcePages(params,
//	    func(page *appmesh.ListTagsForResourceOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppMesh) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVirtualGateways = "ListVirtualGateways"

// ListVirtualGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the ListVirtualGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVirtualGateways for more information on using the ListVirtualGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVirtualGatewaysRequest method.
//	req, resp := client.ListVirtualGatewaysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualGateways
func (c *AppMesh) ListVirtualGatewaysRequest(input *ListVirtualGatewaysInput) (req *request.Request, output *ListVirtualGatewaysOutput) {
	op := &request.Operation{
		Name:       opListVirtualGateways,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateways",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVirtualGatewaysInput{}
	}

	output = &ListVirtualGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVirtualGateways API operation for AWS App Mesh.
//
// Returns a list of existing virtual gateways in a service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListVirtualGateways for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualGateways
func (c *AppMesh) ListVirtualGateways(input *ListVirtualGatewaysInput) (*ListVirtualGatewaysOutput, error) {
	req, out := c.ListVirtualGatewaysRequest(input)
	return out, req.Send()
}

// ListVirtualGatewaysWithContext is the same as ListVirtualGateways with the addition of
// the ability to pass a context and additional request options.
//
// See ListVirtualGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualGatewaysWithContext(ctx aws.Context, input *ListVirtualGatewaysInput, opts ...request.Option) (*ListVirtualGatewaysOutput, error) {
	req, out := c.ListVirtualGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVirtualGatewaysPages iterates over the pages of a ListVirtualGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVirtualGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVirtualGateways operation.
//	pageNum := 0
//	err := client.ListVirtualGatewaysPages(params,
//	    func(page *appmesh.ListVirtualGatewaysOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppMesh) ListVirtualGatewaysPages(input *ListVirtualGatewaysInput, fn func(*ListVirtualGatewaysOutput, bool) bool) error {
	return c.ListVirtualGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVirtualGatewaysPagesWithContext same as ListVirtualGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualGatewaysPagesWithContext(ctx aws.Context, input *ListVirtualGatewaysInput, fn func(*ListVirtualGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVirtualGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVirtualGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVirtualGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVirtualNodes = "ListVirtualNodes"

// ListVirtualNodesRequest generates a "aws/request.Request" representing the
// client's request for the ListVirtualNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVirtualNodes for more information on using the ListVirtualNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVirtualNodesRequest method.
//	req, resp := client.ListVirtualNodesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualNodes
func (c *AppMesh) ListVirtualNodesRequest(input *ListVirtualNodesInput) (req *request.Request, output *ListVirtualNodesOutput) {
	op := &request.Operation{
		Name:       opListVirtualNodes,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualNodes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVirtualNodesInput{}
	}

	output = &ListVirtualNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVirtualNodes API operation for AWS App Mesh.
//
// Returns a list of existing virtual nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListVirtualNodes for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualNodes
func (c *AppMesh) ListVirtualNodes(input *ListVirtualNodesInput) (*ListVirtualNodesOutput, error) {
	req, out := c.ListVirtualNodesRequest(input)
	return out, req.Send()
}

// ListVirtualNodesWithContext is the same as ListVirtualNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListVirtualNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualNodesWithContext(ctx aws.Context, input *ListVirtualNodesInput, opts ...request.Option) (*ListVirtualNodesOutput, error) {
	req, out := c.ListVirtualNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVirtualNodesPages iterates over the pages of a ListVirtualNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVirtualNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVirtualNodes operation.
//	pageNum := 0
//	err := client.ListVirtualNodesPages(params,
//	    func(page *appmesh.ListVirtualNodesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppMesh) ListVirtualNodesPages(input *ListVirtualNodesInput, fn func(*ListVirtualNodesOutput, bool) bool) error {
	return c.ListVirtualNodesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVirtualNodesPagesWithContext same as ListVirtualNodesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualNodesPagesWithContext(ctx aws.Context, input *ListVirtualNodesInput, fn func(*ListVirtualNodesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVirtualNodesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVirtualNodesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVirtualNodesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVirtualRouters = "ListVirtualRouters"

// ListVirtualRoutersRequest generates a "aws/request.Request" representing the
// client's request for the ListVirtualRouters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVirtualRouters for more information on using the ListVirtualRouters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVirtualRoutersRequest method.
//	req, resp := client.ListVirtualRoutersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualRouters
func (c *AppMesh) ListVirtualRoutersRequest(input *ListVirtualRoutersInput) (req *request.Request, output *ListVirtualRoutersOutput) {
	op := &request.Operation{
		Name:       opListVirtualRouters,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouters",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVirtualRoutersInput{}
	}

	output = &ListVirtualRoutersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVirtualRouters API operation for AWS App Mesh.
//
// Returns a list of existing virtual routers in a service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListVirtualRouters for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualRouters
func (c *AppMesh) ListVirtualRouters(input *ListVirtualRoutersInput) (*ListVirtualRoutersOutput, error) {
	req, out := c.ListVirtualRoutersRequest(input)
	return out, req.Send()
}

// ListVirtualRoutersWithContext is the same as ListVirtualRouters with the addition of
// the ability to pass a context and additional request options.
//
// See ListVirtualRouters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualRoutersWithContext(ctx aws.Context, input *ListVirtualRoutersInput, opts ...request.Option) (*ListVirtualRoutersOutput, error) {
	req, out := c.ListVirtualRoutersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVirtualRoutersPages iterates over the pages of a ListVirtualRouters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVirtualRouters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVirtualRouters operation.
//	pageNum := 0
//	err := client.ListVirtualRoutersPages(params,
//	    func(page *appmesh.ListVirtualRoutersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppMesh) ListVirtualRoutersPages(input *ListVirtualRoutersInput, fn func(*ListVirtualRoutersOutput, bool) bool) error {
	return c.ListVirtualRoutersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVirtualRoutersPagesWithContext same as ListVirtualRoutersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualRoutersPagesWithContext(ctx aws.Context, input *ListVirtualRoutersInput, fn func(*ListVirtualRoutersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVirtualRoutersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVirtualRoutersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVirtualRoutersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVirtualServices = "ListVirtualServices"

// ListVirtualServicesRequest generates a "aws/request.Request" representing the
// client's request for the ListVirtualServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVirtualServices for more information on using the ListVirtualServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVirtualServicesRequest method.
//	req, resp := client.ListVirtualServicesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualServices
func (c *AppMesh) ListVirtualServicesRequest(input *ListVirtualServicesInput) (req *request.Request, output *ListVirtualServicesOutput) {
	op := &request.Operation{
		Name:       opListVirtualServices,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualServices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVirtualServicesInput{}
	}

	output = &ListVirtualServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVirtualServices API operation for AWS App Mesh.
//
// Returns a list of existing virtual services in a service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListVirtualServices for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualServices
func (c *AppMesh) ListVirtualServices(input *ListVirtualServicesInput) (*ListVirtualServicesOutput, error) {
	req, out := c.ListVirtualServicesRequest(input)
	return out, req.Send()
}

// ListVirtualServicesWithContext is the same as ListVirtualServices with the addition of
// the ability to pass a context and additional request options.
//
// See ListVirtualServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualServicesWithContext(ctx aws.Context, input *ListVirtualServicesInput, opts ...request.Option) (*ListVirtualServicesOutput, error) {
	req, out := c.ListVirtualServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVirtualServicesPages iterates over the pages of a ListVirtualServices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVirtualServices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVirtualServices operation.
//	pageNum := 0
//	err := client.ListVirtualServicesPages(params,
//	    func(page *appmesh.ListVirtualServicesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppMesh) ListVirtualServicesPages(input *ListVirtualServicesInput, fn func(*ListVirtualServicesOutput, bool) bool) error {
	return c.ListVirtualServicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVirtualServicesPagesWithContext same as ListVirtualServicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualServicesPagesWithContext(ctx aws.Context, input *ListVirtualServicesInput, fn func(*ListVirtualServicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVirtualServicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVirtualServicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVirtualServicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/TagResource
func (c *AppMesh) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/tag",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS App Mesh.
//
// Associates the specified tags to a resource with the specified resourceArn.
// If existing tags on a resource aren't specified in the request parameters,
// they aren't changed. When a resource is deleted, the tags associated with
// that resource are also deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyTagsException
//     The request exceeds the maximum allowed number of tags allowed per resource.
//     The current limit is 50 user tags per resource. You must reduce the number
//     of tags in the request. None of the tags in this request were applied.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/TagResource
func (c *AppMesh) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UntagResource
func (c *AppMesh) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/untag",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS App Mesh.
//
// Deletes specified tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UntagResource
func (c *AppMesh) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGatewayRoute = "UpdateGatewayRoute"

// UpdateGatewayRouteRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGatewayRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGatewayRoute for more information on using the UpdateGatewayRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGatewayRouteRequest method.
//	req, resp := client.UpdateGatewayRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateGatewayRoute
func (c *AppMesh) UpdateGatewayRouteRequest(input *UpdateGatewayRouteInput) (req *request.Request, output *UpdateGatewayRouteOutput) {
	op := &request.Operation{
		Name:       opUpdateGatewayRoute,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}",
	}

	if input == nil {
		input = &UpdateGatewayRouteInput{}
	}

	output = &UpdateGatewayRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGatewayRoute API operation for AWS App Mesh.
//
// Updates an existing gateway route that is associated to a specified virtual
// gateway in a service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateGatewayRoute for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - LimitExceededException
//     You have exceeded a service limit for your account. For more information,
//     see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
//     in the App Mesh User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateGatewayRoute
func (c *AppMesh) UpdateGatewayRoute(input *UpdateGatewayRouteInput) (*UpdateGatewayRouteOutput, error) {
	req, out := c.UpdateGatewayRouteRequest(input)
	return out, req.Send()
}

// UpdateGatewayRouteWithContext is the same as UpdateGatewayRoute with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGatewayRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateGatewayRouteWithContext(ctx aws.Context, input *UpdateGatewayRouteInput, opts ...request.Option) (*UpdateGatewayRouteOutput, error) {
	req, out := c.UpdateGatewayRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMesh = "UpdateMesh"

// UpdateMeshRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMesh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMesh for more information on using the UpdateMesh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMeshRequest method.
//	req, resp := client.UpdateMeshRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateMesh
func (c *AppMesh) UpdateMeshRequest(input *UpdateMeshInput) (req *request.Request, output *UpdateMeshOutput) {
	op := &request.Operation{
		Name:       opUpdateMesh,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}",
	}

	if input == nil {
		input = &UpdateMeshInput{}
	}

	output = &UpdateMeshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMesh API operation for AWS App Mesh.
//
// Updates an existing service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateMesh for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateMesh
func (c *AppMesh) UpdateMesh(input *UpdateMeshInput) (*UpdateMeshOutput, error) {
	req, out := c.UpdateMeshRequest(input)
	return out, req.Send()
}

// UpdateMeshWithContext is the same as UpdateMesh with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMesh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateMeshWithContext(ctx aws.Context, input *UpdateMeshInput, opts ...request.Option) (*UpdateMeshOutput, error) {
	req, out := c.UpdateMeshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoute = "UpdateRoute"

// UpdateRouteRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoute for more information on using the UpdateRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRouteRequest method.
//	req, resp := client.UpdateRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateRoute
func (c *AppMesh) UpdateRouteRequest(input *UpdateRouteInput) (req *request.Request, output *UpdateRouteOutput) {
	op := &request.Operation{
		Name:       opUpdateRoute,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
	}

	if input == nil {
		input = &UpdateRouteInput{}
	}

	output = &UpdateRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoute API operation for AWS App Mesh.
//
// Updates an existing route for a specified service mesh and virtual router.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateRoute for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - LimitExceededException
//     You have exceeded a service limit for your account. For more information,
//     see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
//     in the App Mesh User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateRoute
func (c *AppMesh) UpdateRoute(input *UpdateRouteInput) (*UpdateRouteOutput, error) {
	req, out := c.UpdateRouteRequest(input)
	return out, req.Send()
}

// UpdateRouteWithContext is the same as UpdateRoute with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateRouteWithContext(ctx aws.Context, input *UpdateRouteInput, opts ...request.Option) (*UpdateRouteOutput, error) {
	req, out := c.UpdateRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVirtualGateway = "UpdateVirtualGateway"

// UpdateVirtualGatewayRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVirtualGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVirtualGateway for more information on using the UpdateVirtualGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVirtualGatewayRequest method.
//	req, resp := client.UpdateVirtualGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualGateway
func (c *AppMesh) UpdateVirtualGatewayRequest(input *UpdateVirtualGatewayInput) (req *request.Request, output *UpdateVirtualGatewayOutput) {
	op := &request.Operation{
		Name:       opUpdateVirtualGateway,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
	}

	if input == nil {
		input = &UpdateVirtualGatewayInput{}
	}

	output = &UpdateVirtualGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVirtualGateway API operation for AWS App Mesh.
//
// Updates an existing virtual gateway in a specified service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateVirtualGateway for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - LimitExceededException
//     You have exceeded a service limit for your account. For more information,
//     see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
//     in the App Mesh User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualGateway
func (c *AppMesh) UpdateVirtualGateway(input *UpdateVirtualGatewayInput) (*UpdateVirtualGatewayOutput, error) {
	req, out := c.UpdateVirtualGatewayRequest(input)
	return out, req.Send()
}

// UpdateVirtualGatewayWithContext is the same as UpdateVirtualGateway with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVirtualGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateVirtualGatewayWithContext(ctx aws.Context, input *UpdateVirtualGatewayInput, opts ...request.Option) (*UpdateVirtualGatewayOutput, error) {
	req, out := c.UpdateVirtualGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVirtualNode = "UpdateVirtualNode"

// UpdateVirtualNodeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVirtualNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVirtualNode for more information on using the UpdateVirtualNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVirtualNodeRequest method.
//	req, resp := client.UpdateVirtualNodeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualNode
func (c *AppMesh) UpdateVirtualNodeRequest(input *UpdateVirtualNodeInput) (req *request.Request, output *UpdateVirtualNodeOutput) {
	op := &request.Operation{
		Name:       opUpdateVirtualNode,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
	}

	if input == nil {
		input = &UpdateVirtualNodeInput{}
	}

	output = &UpdateVirtualNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVirtualNode API operation for AWS App Mesh.
//
// Updates an existing virtual node in a specified service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateVirtualNode for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - LimitExceededException
//     You have exceeded a service limit for your account. For more information,
//     see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
//     in the App Mesh User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualNode
func (c *AppMesh) UpdateVirtualNode(input *UpdateVirtualNodeInput) (*UpdateVirtualNodeOutput, error) {
	req, out := c.UpdateVirtualNodeRequest(input)
	return out, req.Send()
}

// UpdateVirtualNodeWithContext is the same as UpdateVirtualNode with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVirtualNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateVirtualNodeWithContext(ctx aws.Context, input *UpdateVirtualNodeInput, opts ...request.Option) (*UpdateVirtualNodeOutput, error) {
	req, out := c.UpdateVirtualNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVirtualRouter = "UpdateVirtualRouter"

// UpdateVirtualRouterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVirtualRouter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVirtualRouter for more information on using the UpdateVirtualRouter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVirtualRouterRequest method.
//	req, resp := client.UpdateVirtualRouterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualRouter
func (c *AppMesh) UpdateVirtualRouterRequest(input *UpdateVirtualRouterInput) (req *request.Request, output *UpdateVirtualRouterOutput) {
	op := &request.Operation{
		Name:       opUpdateVirtualRouter,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
	}

	if input == nil {
		input = &UpdateVirtualRouterInput{}
	}

	output = &UpdateVirtualRouterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVirtualRouter API operation for AWS App Mesh.
//
// Updates an existing virtual router in a specified service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateVirtualRouter for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - LimitExceededException
//     You have exceeded a service limit for your account. For more information,
//     see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
//     in the App Mesh User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualRouter
func (c *AppMesh) UpdateVirtualRouter(input *UpdateVirtualRouterInput) (*UpdateVirtualRouterOutput, error) {
	req, out := c.UpdateVirtualRouterRequest(input)
	return out, req.Send()
}

// UpdateVirtualRouterWithContext is the same as UpdateVirtualRouter with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVirtualRouter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateVirtualRouterWithContext(ctx aws.Context, input *UpdateVirtualRouterInput, opts ...request.Option) (*UpdateVirtualRouterOutput, error) {
	req, out := c.UpdateVirtualRouterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVirtualService = "UpdateVirtualService"

// UpdateVirtualServiceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVirtualService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVirtualService for more information on using the UpdateVirtualService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVirtualServiceRequest method.
//	req, resp := client.UpdateVirtualServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualService
func (c *AppMesh) UpdateVirtualServiceRequest(input *UpdateVirtualServiceInput) (req *request.Request, output *UpdateVirtualServiceOutput) {
	op := &request.Operation{
		Name:       opUpdateVirtualService,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
	}

	if input == nil {
		input = &UpdateVirtualServiceInput{}
	}

	output = &UpdateVirtualServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVirtualService API operation for AWS App Mesh.
//
// Updates an existing virtual service in a specified service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateVirtualService for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified resource doesn't exist. Check your request syntax and try again.
//
//   - BadRequestException
//     The request syntax was malformed. Check your request syntax and try again.
//
//   - ConflictException
//     The request contains a client token that was used for a previous update resource
//     call with different specifications. Try the request again with a new client
//     token.
//
//   - TooManyRequestsException
//     The maximum request rate permitted by the App Mesh APIs has been exceeded
//     for your account. For best results, use an increasing or variable sleep interval
//     between requests.
//
//   - ForbiddenException
//     You don't have permissions to perform this action.
//
//   - ServiceUnavailableException
//     The request has failed due to a temporary failure of the service.
//
//   - InternalServerErrorException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - LimitExceededException
//     You have exceeded a service limit for your account. For more information,
//     see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
//     in the App Mesh User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualService
func (c *AppMesh) UpdateVirtualService(input *UpdateVirtualServiceInput) (*UpdateVirtualServiceOutput, error) {
	req, out := c.UpdateVirtualServiceRequest(input)
	return out, req.Send()
}

// UpdateVirtualServiceWithContext is the same as UpdateVirtualService with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVirtualService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateVirtualServiceWithContext(ctx aws.Context, input *UpdateVirtualServiceInput, opts ...request.Option) (*UpdateVirtualServiceOutput, error) {
	req, out := c.UpdateVirtualServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An object that represents the access logging information for a virtual node.
type AccessLog struct {
	_ struct{} `type:"structure"`

	// The file object to send virtual node access logs to.
	File *FileAccessLog `locationName:"file" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessLog) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessLog) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessLog"}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *AccessLog) SetFile(v *FileAccessLog) *AccessLog {
	s.File = v
	return s
}

// An object that represents the Cloud Map attribute information for your virtual
// node.
//
// Cloud Map is not available in the eu-south-1 Region.
type AwsCloudMapInstanceAttribute struct {
	_ struct{} `type:"structure"`

	// The name of an Cloud Map service instance attribute key. Any Cloud Map service
	// instance that contains the specified key and value is returned.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value of an Cloud Map service instance attribute key. Any Cloud Map service
	// instance that contains the specified key and value is returned.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudMapInstanceAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudMapInstanceAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsCloudMapInstanceAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsCloudMapInstanceAttribute"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AwsCloudMapInstanceAttribute) SetKey(v string) *AwsCloudMapInstanceAttribute {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsCloudMapInstanceAttribute) SetValue(v string) *AwsCloudMapInstanceAttribute {
	s.Value = &v
	return s
}

// An object that represents the Cloud Map service discovery information for
// your virtual node.
//
// Cloud Map is not available in the eu-south-1 Region.
type AwsCloudMapServiceDiscovery struct {
	_ struct{} `type:"structure"`

	// A string map that contains attributes with values that you can use to filter
	// instances by any custom attribute that you specified when you registered
	// the instance. Only instances that match all of the specified key/value pairs
	// will be returned.
	Attributes []*AwsCloudMapInstanceAttribute `locationName:"attributes" type:"list"`

	// The preferred IP version that this virtual node uses. Setting the IP preference
	// on the virtual node only overrides the IP preference set for the mesh on
	// this specific node.
	IpPreference *string `locationName:"ipPreference" type:"string" enum:"IpPreference"`

	// The name of the Cloud Map namespace to use.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" min:"1" type:"string" required:"true"`

	// The name of the Cloud Map service to use.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudMapServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudMapServiceDiscovery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsCloudMapServiceDiscovery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsCloudMapServiceDiscovery"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *AwsCloudMapServiceDiscovery) SetAttributes(v []*AwsCloudMapInstanceAttribute) *AwsCloudMapServiceDiscovery {
	s.Attributes = v
	return s
}

// SetIpPreference sets the IpPreference field's value.
func (s *AwsCloudMapServiceDiscovery) SetIpPreference(v string) *AwsCloudMapServiceDiscovery {
	s.IpPreference = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *AwsCloudMapServiceDiscovery) SetNamespaceName(v string) *AwsCloudMapServiceDiscovery {
	s.NamespaceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *AwsCloudMapServiceDiscovery) SetServiceName(v string) *AwsCloudMapServiceDiscovery {
	s.ServiceName = &v
	return s
}

// An object that represents the backends that a virtual node is expected to
// send outbound traffic to.
type Backend struct {
	_ struct{} `type:"structure"`

	// Specifies a virtual service to use as a backend.
	VirtualService *VirtualServiceBackend `locationName:"virtualService" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Backend) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Backend) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Backend) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Backend"}
	if s.VirtualService != nil {
		if err := s.VirtualService.Validate(); err != nil {
			invalidParams.AddNested("VirtualService", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualService sets the VirtualService field's value.
func (s *Backend) SetVirtualService(v *VirtualServiceBackend) *Backend {
	s.VirtualService = v
	return s
}

// An object that represents the default properties for a backend.
type BackendDefaults struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents a client policy.
	ClientPolicy *ClientPolicy `locationName:"clientPolicy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendDefaults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendDefaults) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BackendDefaults) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BackendDefaults"}
	if s.ClientPolicy != nil {
		if err := s.ClientPolicy.Validate(); err != nil {
			invalidParams.AddNested("ClientPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientPolicy sets the ClientPolicy field's value.
func (s *BackendDefaults) SetClientPolicy(v *ClientPolicy) *BackendDefaults {
	s.ClientPolicy = v
	return s
}

// The request syntax was malformed. Check your request syntax and try again.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents a client policy.
type ClientPolicy struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents a Transport Layer Security (TLS)
	// client policy.
	Tls *ClientPolicyTls `locationName:"tls" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClientPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClientPolicy"}
	if s.Tls != nil {
		if err := s.Tls.Validate(); err != nil {
			invalidParams.AddNested("Tls", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTls sets the Tls field's value.
func (s *ClientPolicy) SetTls(v *ClientPolicyTls) *ClientPolicy {
	s.Tls = v
	return s
}

// A reference to an object that represents a Transport Layer Security (TLS)
// client policy.
type ClientPolicyTls struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents a client's TLS certificate.
	Certificate *ClientTlsCertificate `locationName:"certificate" type:"structure"`

	// Whether the policy is enforced. The default is True, if a value isn't specified.
	Enforce *bool `locationName:"enforce" type:"boolean"`

	// One or more ports that the policy is enforced for.
	Ports []*int64 `locationName:"ports" type:"list"`

	// A reference to an object that represents a TLS validation context.
	//
	// Validation is a required field
	Validation *TlsValidationContext `locationName:"validation" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientPolicyTls) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientPolicyTls) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClientPolicyTls) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClientPolicyTls"}
	if s.Validation == nil {
		invalidParams.Add(request.NewErrParamRequired("Validation"))
	}
	if s.Certificate != nil {
		if err := s.Certificate.Validate(); err != nil {
			invalidParams.AddNested("Certificate", err.(request.ErrInvalidParams))
		}
	}
	if s.Validation != nil {
		if err := s.Validation.Validate(); err != nil {
			invalidParams.AddNested("Validation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *ClientPolicyTls) SetCertificate(v *ClientTlsCertificate) *ClientPolicyTls {
	s.Certificate = v
	return s
}

// SetEnforce sets the Enforce field's value.
func (s *ClientPolicyTls) SetEnforce(v bool) *ClientPolicyTls {
	s.Enforce = &v
	return s
}

// SetPorts sets the Ports field's value.
func (s *ClientPolicyTls) SetPorts(v []*int64) *ClientPolicyTls {
	s.Ports = v
	return s
}

// SetValidation sets the Validation field's value.
func (s *ClientPolicyTls) SetValidation(v *TlsValidationContext) *ClientPolicyTls {
	s.Validation = v
	return s
}

// An object that represents the client's certificate.
type ClientTlsCertificate struct {
	_ struct{} `type:"structure"`

	// An object that represents a local file certificate. The certificate must
	// meet specific requirements and you must have proxy authorization enabled.
	// For more information, see Transport Layer Security (TLS) (https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html).
	File *ListenerTlsFileCertificate `locationName:"file" type:"structure"`

	// A reference to an object that represents a client's TLS Secret Discovery
	// Service certificate.
	Sds *ListenerTlsSdsCertificate `locationName:"sds" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientTlsCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientTlsCertificate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClientTlsCertificate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClientTlsCertificate"}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}
	if s.Sds != nil {
		if err := s.Sds.Validate(); err != nil {
			invalidParams.AddNested("Sds", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *ClientTlsCertificate) SetFile(v *ListenerTlsFileCertificate) *ClientTlsCertificate {
	s.File = v
	return s
}

// SetSds sets the Sds field's value.
func (s *ClientTlsCertificate) SetSds(v *ListenerTlsSdsCertificate) *ClientTlsCertificate {
	s.Sds = v
	return s
}

// The request contains a client token that was used for a previous update resource
// call with different specifications. Try the request again with a new client
// token.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateGatewayRouteInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name to use for the gateway route.
	//
	// GatewayRouteName is a required field
	GatewayRouteName *string `locationName:"gatewayRouteName" min:"1" type:"string" required:"true"`

	// The name of the service mesh to create the gateway route in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then the account that you specify must share
	// the mesh with your account before you can create the resource in the service
	// mesh. For more information about mesh sharing, see Working with shared meshes
	// (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The gateway route specification to apply.
	//
	// Spec is a required field
	Spec *GatewayRouteSpec `locationName:"spec" type:"structure" required:"true"`

	// Optional metadata that you can apply to the gateway route to assist with
	// categorization and organization. Each tag consists of a key and an optional
	// value, both of which you define. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	Tags []*TagRef `locationName:"tags" type:"list"`

	// The name of the virtual gateway to associate the gateway route with. If the
	// virtual gateway is in a shared mesh, then you must be the owner of the virtual
	// gateway resource.
	//
	// VirtualGatewayName is a required field
	VirtualGatewayName *string `location:"uri" locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGatewayRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGatewayRouteInput"}
	if s.GatewayRouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayRouteName"))
	}
	if s.GatewayRouteName != nil && len(*s.GatewayRouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayRouteName", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualGatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualGatewayName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateGatewayRouteInput) SetClientToken(v string) *CreateGatewayRouteInput {
	s.ClientToken = &v
	return s
}

// SetGatewayRouteName sets the GatewayRouteName field's value.
func (s *CreateGatewayRouteInput) SetGatewayRouteName(v string) *CreateGatewayRouteInput {
	s.GatewayRouteName = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateGatewayRouteInput) SetMeshName(v string) *CreateGatewayRouteInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *CreateGatewayRouteInput) SetMeshOwner(v string) *CreateGatewayRouteInput {
	s.MeshOwner = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateGatewayRouteInput) SetSpec(v *GatewayRouteSpec) *CreateGatewayRouteInput {
	s.Spec = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGatewayRouteInput) SetTags(v []*TagRef) *CreateGatewayRouteInput {
	s.Tags = v
	return s
}

// SetVirtualGatewayName sets the VirtualGatewayName field's value.
func (s *CreateGatewayRouteInput) SetVirtualGatewayName(v string) *CreateGatewayRouteInput {
	s.VirtualGatewayName = &v
	return s
}

type CreateGatewayRouteOutput struct {
	_ struct{} `type:"structure" payload:"GatewayRoute"`

	// The full description of your gateway route following the create call.
	//
	// GatewayRoute is a required field
	GatewayRoute *GatewayRouteData `locationName:"gatewayRoute" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayRouteOutput) GoString() string {
	return s.String()
}

// SetGatewayRoute sets the GatewayRoute field's value.
func (s *CreateGatewayRouteOutput) SetGatewayRoute(v *GatewayRouteData) *CreateGatewayRouteOutput {
	s.GatewayRoute = v
	return s
}

type CreateMeshInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name to use for the service mesh.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The service mesh specification to apply.
	Spec *MeshSpec `locationName:"spec" type:"structure"`

	// Optional metadata that you can apply to the service mesh to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Tag keys can have a maximum character length of 128
	// characters, and tag values can have a maximum length of 256 characters.
	Tags []*TagRef `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeshInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeshInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMeshInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMeshInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateMeshInput) SetClientToken(v string) *CreateMeshInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateMeshInput) SetMeshName(v string) *CreateMeshInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateMeshInput) SetSpec(v *MeshSpec) *CreateMeshInput {
	s.Spec = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMeshInput) SetTags(v []*TagRef) *CreateMeshInput {
	s.Tags = v
	return s
}

type CreateMeshOutput struct {
	_ struct{} `type:"structure" payload:"Mesh"`

	// The full description of your service mesh following the create call.
	//
	// Mesh is a required field
	Mesh *MeshData `locationName:"mesh" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeshOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeshOutput) GoString() string {
	return s.String()
}

// SetMesh sets the Mesh field's value.
func (s *CreateMeshOutput) SetMesh(v *MeshData) *CreateMeshOutput {
	s.Mesh = v
	return s
}

type CreateRouteInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh to create the route in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then the account that you specify must share
	// the mesh with your account before you can create the resource in the service
	// mesh. For more information about mesh sharing, see Working with shared meshes
	// (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name to use for the route.
	//
	// RouteName is a required field
	RouteName *string `locationName:"routeName" min:"1" type:"string" required:"true"`

	// The route specification to apply.
	//
	// Spec is a required field
	Spec *RouteSpec `locationName:"spec" type:"structure" required:"true"`

	// Optional metadata that you can apply to the route to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Tag keys can have a maximum character length of 128
	// characters, and tag values can have a maximum length of 256 characters.
	Tags []*TagRef `locationName:"tags" type:"list"`

	// The name of the virtual router in which to create the route. If the virtual
	// router is in a shared mesh, then you must be the owner of the virtual router
	// resource.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRouteInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.RouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteName"))
	}
	if s.RouteName != nil && len(*s.RouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRouteInput) SetClientToken(v string) *CreateRouteInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateRouteInput) SetMeshName(v string) *CreateRouteInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *CreateRouteInput) SetMeshOwner(v string) *CreateRouteInput {
	s.MeshOwner = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *CreateRouteInput) SetRouteName(v string) *CreateRouteInput {
	s.RouteName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateRouteInput) SetSpec(v *RouteSpec) *CreateRouteInput {
	s.Spec = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRouteInput) SetTags(v []*TagRef) *CreateRouteInput {
	s.Tags = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *CreateRouteInput) SetVirtualRouterName(v string) *CreateRouteInput {
	s.VirtualRouterName = &v
	return s
}

type CreateRouteOutput struct {
	_ struct{} `type:"structure" payload:"Route"`

	// The full description of your mesh following the create call.
	//
	// Route is a required field
	Route *RouteData `locationName:"route" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRouteOutput) GoString() string {
	return s.String()
}

// SetRoute sets the Route field's value.
func (s *CreateRouteOutput) SetRoute(v *RouteData) *CreateRouteOutput {
	s.Route = v
	return s
}

type CreateVirtualGatewayInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh to create the virtual gateway in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then the account that you specify must share
	// the mesh with your account before you can create the resource in the service
	// mesh. For more information about mesh sharing, see Working with shared meshes
	// (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The virtual gateway specification to apply.
	//
	// Spec is a required field
	Spec *VirtualGatewaySpec `locationName:"spec" type:"structure" required:"true"`

	// Optional metadata that you can apply to the virtual gateway to assist with
	// categorization and organization. Each tag consists of a key and an optional
	// value, both of which you define. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	Tags []*TagRef `locationName:"tags" type:"list"`

	// The name to use for the virtual gateway.
	//
	// VirtualGatewayName is a required field
	VirtualGatewayName *string `locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVirtualGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVirtualGatewayInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualGatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualGatewayName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVirtualGatewayInput) SetClientToken(v string) *CreateVirtualGatewayInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateVirtualGatewayInput) SetMeshName(v string) *CreateVirtualGatewayInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *CreateVirtualGatewayInput) SetMeshOwner(v string) *CreateVirtualGatewayInput {
	s.MeshOwner = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateVirtualGatewayInput) SetSpec(v *VirtualGatewaySpec) *CreateVirtualGatewayInput {
	s.Spec = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVirtualGatewayInput) SetTags(v []*TagRef) *CreateVirtualGatewayInput {
	s.Tags = v
	return s
}

// SetVirtualGatewayName sets the VirtualGatewayName field's value.
func (s *CreateVirtualGatewayInput) SetVirtualGatewayName(v string) *CreateVirtualGatewayInput {
	s.VirtualGatewayName = &v
	return s
}

type CreateVirtualGatewayOutput struct {
	_ struct{} `type:"structure" payload:"VirtualGateway"`

	// The full description of your virtual gateway following the create call.
	//
	// VirtualGateway is a required field
	VirtualGateway *VirtualGatewayData `locationName:"virtualGateway" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualGatewayOutput) GoString() string {
	return s.String()
}

// SetVirtualGateway sets the VirtualGateway field's value.
func (s *CreateVirtualGatewayOutput) SetVirtualGateway(v *VirtualGatewayData) *CreateVirtualGatewayOutput {
	s.VirtualGateway = v
	return s
}

type CreateVirtualNodeInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh to create the virtual node in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then the account that you specify must share
	// the mesh with your account before you can create the resource in the service
	// mesh. For more information about mesh sharing, see Working with shared meshes
	// (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The virtual node specification to apply.
	//
	// Spec is a required field
	Spec *VirtualNodeSpec `locationName:"spec" type:"structure" required:"true"`

	// Optional metadata that you can apply to the virtual node to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Tag keys can have a maximum character length of 128
	// characters, and tag values can have a maximum length of 256 characters.
	Tags []*TagRef `locationName:"tags" type:"list"`

	// The name to use for the virtual node.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVirtualNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVirtualNodeInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVirtualNodeInput) SetClientToken(v string) *CreateVirtualNodeInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateVirtualNodeInput) SetMeshName(v string) *CreateVirtualNodeInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *CreateVirtualNodeInput) SetMeshOwner(v string) *CreateVirtualNodeInput {
	s.MeshOwner = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateVirtualNodeInput) SetSpec(v *VirtualNodeSpec) *CreateVirtualNodeInput {
	s.Spec = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVirtualNodeInput) SetTags(v []*TagRef) *CreateVirtualNodeInput {
	s.Tags = v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *CreateVirtualNodeInput) SetVirtualNodeName(v string) *CreateVirtualNodeInput {
	s.VirtualNodeName = &v
	return s
}

type CreateVirtualNodeOutput struct {
	_ struct{} `type:"structure" payload:"VirtualNode"`

	// The full description of your virtual node following the create call.
	//
	// VirtualNode is a required field
	VirtualNode *VirtualNodeData `locationName:"virtualNode" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualNodeOutput) GoString() string {
	return s.String()
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *CreateVirtualNodeOutput) SetVirtualNode(v *VirtualNodeData) *CreateVirtualNodeOutput {
	s.VirtualNode = v
	return s
}

type CreateVirtualRouterInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh to create the virtual router in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then the account that you specify must share
	// the mesh with your account before you can create the resource in the service
	// mesh. For more information about mesh sharing, see Working with shared meshes
	// (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The virtual router specification to apply.
	//
	// Spec is a required field
	Spec *VirtualRouterSpec `locationName:"spec" type:"structure" required:"true"`

	// Optional metadata that you can apply to the virtual router to assist with
	// categorization and organization. Each tag consists of a key and an optional
	// value, both of which you define. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	Tags []*TagRef `locationName:"tags" type:"list"`

	// The name to use for the virtual router.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualRouterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVirtualRouterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVirtualRouterInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVirtualRouterInput) SetClientToken(v string) *CreateVirtualRouterInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateVirtualRouterInput) SetMeshName(v string) *CreateVirtualRouterInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *CreateVirtualRouterInput) SetMeshOwner(v string) *CreateVirtualRouterInput {
	s.MeshOwner = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateVirtualRouterInput) SetSpec(v *VirtualRouterSpec) *CreateVirtualRouterInput {
	s.Spec = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVirtualRouterInput) SetTags(v []*TagRef) *CreateVirtualRouterInput {
	s.Tags = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *CreateVirtualRouterInput) SetVirtualRouterName(v string) *CreateVirtualRouterInput {
	s.VirtualRouterName = &v
	return s
}

type CreateVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// The full description of your virtual router following the create call.
	//
	// VirtualRouter is a required field
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualRouterOutput) GoString() string {
	return s.String()
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *CreateVirtualRouterOutput) SetVirtualRouter(v *VirtualRouterData) *CreateVirtualRouterOutput {
	s.VirtualRouter = v
	return s
}

type CreateVirtualServiceInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh to create the virtual service in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then the account that you specify must share
	// the mesh with your account before you can create the resource in the service
	// mesh. For more information about mesh sharing, see Working with shared meshes
	// (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The virtual service specification to apply.
	//
	// Spec is a required field
	Spec *VirtualServiceSpec `locationName:"spec" type:"structure" required:"true"`

	// Optional metadata that you can apply to the virtual service to assist with
	// categorization and organization. Each tag consists of a key and an optional
	// value, both of which you define. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	Tags []*TagRef `locationName:"tags" type:"list"`

	// The name to use for the virtual service.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVirtualServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVirtualServiceInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualServiceName"))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVirtualServiceInput) SetClientToken(v string) *CreateVirtualServiceInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateVirtualServiceInput) SetMeshName(v string) *CreateVirtualServiceInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *CreateVirtualServiceInput) SetMeshOwner(v string) *CreateVirtualServiceInput {
	s.MeshOwner = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateVirtualServiceInput) SetSpec(v *VirtualServiceSpec) *CreateVirtualServiceInput {
	s.Spec = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVirtualServiceInput) SetTags(v []*TagRef) *CreateVirtualServiceInput {
	s.Tags = v
	return s
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *CreateVirtualServiceInput) SetVirtualServiceName(v string) *CreateVirtualServiceInput {
	s.VirtualServiceName = &v
	return s
}

type CreateVirtualServiceOutput struct {
	_ struct{} `type:"structure" payload:"VirtualService"`

	// The full description of your virtual service following the create call.
	//
	// VirtualService is a required field
	VirtualService *VirtualServiceData `locationName:"virtualService" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualServiceOutput) GoString() string {
	return s.String()
}

// SetVirtualService sets the VirtualService field's value.
func (s *CreateVirtualServiceOutput) SetVirtualService(v *VirtualServiceData) *CreateVirtualServiceOutput {
	s.VirtualService = v
	return s
}

type DeleteGatewayRouteInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the gateway route to delete.
	//
	// GatewayRouteName is a required field
	GatewayRouteName *string `location:"uri" locationName:"gatewayRouteName" min:"1" type:"string" required:"true"`

	// The name of the service mesh to delete the gateway route from.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name of the virtual gateway to delete the route from.
	//
	// VirtualGatewayName is a required field
	VirtualGatewayName *string `location:"uri" locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGatewayRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGatewayRouteInput"}
	if s.GatewayRouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayRouteName"))
	}
	if s.GatewayRouteName != nil && len(*s.GatewayRouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayRouteName", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.VirtualGatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualGatewayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayRouteName sets the GatewayRouteName field's value.
func (s *DeleteGatewayRouteInput) SetGatewayRouteName(v string) *DeleteGatewayRouteInput {
	s.GatewayRouteName = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteGatewayRouteInput) SetMeshName(v string) *DeleteGatewayRouteInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *DeleteGatewayRouteInput) SetMeshOwner(v string) *DeleteGatewayRouteInput {
	s.MeshOwner = &v
	return s
}

// SetVirtualGatewayName sets the VirtualGatewayName field's value.
func (s *DeleteGatewayRouteInput) SetVirtualGatewayName(v string) *DeleteGatewayRouteInput {
	s.VirtualGatewayName = &v
	return s
}

type DeleteGatewayRouteOutput struct {
	_ struct{} `type:"structure" payload:"GatewayRoute"`

	// The gateway route that was deleted.
	//
	// GatewayRoute is a required field
	GatewayRoute *GatewayRouteData `locationName:"gatewayRoute" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayRouteOutput) GoString() string {
	return s.String()
}

// SetGatewayRoute sets the GatewayRoute field's value.
func (s *DeleteGatewayRouteOutput) SetGatewayRoute(v *GatewayRouteData) *DeleteGatewayRouteOutput {
	s.GatewayRoute = v
	return s
}

type DeleteMeshInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the service mesh to delete.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeshInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeshInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMeshInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMeshInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteMeshInput) SetMeshName(v string) *DeleteMeshInput {
	s.MeshName = &v
	return s
}

type DeleteMeshOutput struct {
	_ struct{} `type:"structure" payload:"Mesh"`

	// The service mesh that was deleted.
	//
	// Mesh is a required field
	Mesh *MeshData `locationName:"mesh" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeshOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeshOutput) GoString() string {
	return s.String()
}

// SetMesh sets the Mesh field's value.
func (s *DeleteMeshOutput) SetMesh(v *MeshData) *DeleteMeshOutput {
	s.Mesh = v
	return s
}

type DeleteRouteInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the service mesh to delete the route in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name of the route to delete.
	//
	// RouteName is a required field
	RouteName *string `location:"uri" locationName:"routeName" min:"1" type:"string" required:"true"`

	// The name of the virtual router to delete the route in.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRouteInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.RouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteName"))
	}
	if s.RouteName != nil && len(*s.RouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteName", 1))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteRouteInput) SetMeshName(v string) *DeleteRouteInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *DeleteRouteInput) SetMeshOwner(v string) *DeleteRouteInput {
	s.MeshOwner = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *DeleteRouteInput) SetRouteName(v string) *DeleteRouteInput {
	s.RouteName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *DeleteRouteInput) SetVirtualRouterName(v string) *DeleteRouteInput {
	s.VirtualRouterName = &v
	return s
}

type DeleteRouteOutput struct {
	_ struct{} `type:"structure" payload:"Route"`

	// The route that was deleted.
	//
	// Route is a required field
	Route *RouteData `locationName:"route" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRouteOutput) GoString() string {
	return s.String()
}

// SetRoute sets the Route field's value.
func (s *DeleteRouteOutput) SetRoute(v *RouteData) *DeleteRouteOutput {
	s.Route = v
	return s
}

type DeleteVirtualGatewayInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the service mesh to delete the virtual gateway from.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name of the virtual gateway to delete.
	//
	// VirtualGatewayName is a required field
	VirtualGatewayName *string `location:"uri" locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualGatewayInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.VirtualGatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualGatewayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteVirtualGatewayInput) SetMeshName(v string) *DeleteVirtualGatewayInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *DeleteVirtualGatewayInput) SetMeshOwner(v string) *DeleteVirtualGatewayInput {
	s.MeshOwner = &v
	return s
}

// SetVirtualGatewayName sets the VirtualGatewayName field's value.
func (s *DeleteVirtualGatewayInput) SetVirtualGatewayName(v string) *DeleteVirtualGatewayInput {
	s.VirtualGatewayName = &v
	return s
}

type DeleteVirtualGatewayOutput struct {
	_ struct{} `type:"structure" payload:"VirtualGateway"`

	// The virtual gateway that was deleted.
	//
	// VirtualGateway is a required field
	VirtualGateway *VirtualGatewayData `locationName:"virtualGateway" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualGatewayOutput) GoString() string {
	return s.String()
}

// SetVirtualGateway sets the VirtualGateway field's value.
func (s *DeleteVirtualGatewayOutput) SetVirtualGateway(v *VirtualGatewayData) *DeleteVirtualGatewayOutput {
	s.VirtualGateway = v
	return s
}

// Deletes a virtual node input.
type DeleteVirtualNodeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the service mesh to delete the virtual node in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name of the virtual node to delete.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `location:"uri" locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualNodeInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteVirtualNodeInput) SetMeshName(v string) *DeleteVirtualNodeInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *DeleteVirtualNodeInput) SetMeshOwner(v string) *DeleteVirtualNodeInput {
	s.MeshOwner = &v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *DeleteVirtualNodeInput) SetVirtualNodeName(v string) *DeleteVirtualNodeInput {
	s.VirtualNodeName = &v
	return s
}

type DeleteVirtualNodeOutput struct {
	_ struct{} `type:"structure" payload:"VirtualNode"`

	// The virtual node that was deleted.
	//
	// VirtualNode is a required field
	VirtualNode *VirtualNodeData `locationName:"virtualNode" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualNodeOutput) GoString() string {
	return s.String()
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *DeleteVirtualNodeOutput) SetVirtualNode(v *VirtualNodeData) *DeleteVirtualNodeOutput {
	s.VirtualNode = v
	return s
}

type DeleteVirtualRouterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the service mesh to delete the virtual router in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name of the virtual router to delete.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualRouterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualRouterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualRouterInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteVirtualRouterInput) SetMeshName(v string) *DeleteVirtualRouterInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *DeleteVirtualRouterInput) SetMeshOwner(v string) *DeleteVirtualRouterInput {
	s.MeshOwner = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *DeleteVirtualRouterInput) SetVirtualRouterName(v string) *DeleteVirtualRouterInput {
	s.VirtualRouterName = &v
	return s
}

type DeleteVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// The virtual router that was deleted.
	//
	// VirtualRouter is a required field
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualRouterOutput) GoString() string {
	return s.String()
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *DeleteVirtualRouterOutput) SetVirtualRouter(v *VirtualRouterData) *DeleteVirtualRouterOutput {
	s.VirtualRouter = v
	return s
}

type DeleteVirtualServiceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the service mesh to delete the virtual service in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name of the virtual service to delete.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `location:"uri" locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualServiceInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.VirtualServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualServiceName"))
	}
	if s.VirtualServiceName != nil && len(*s.VirtualServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteVirtualServiceInput) SetMeshName(v string) *DeleteVirtualServiceInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *DeleteVirtualServiceInput) SetMeshOwner(v string) *DeleteVirtualServiceInput {
	s.MeshOwner = &v
	return s
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *DeleteVirtualServiceInput) SetVirtualServiceName(v string) *DeleteVirtualServiceInput {
	s.VirtualServiceName = &v
	return s
}

type DeleteVirtualServiceOutput struct {
	_ struct{} `type:"structure" payload:"VirtualService"`

	// The virtual service that was deleted.
	//
	// VirtualService is a required field
	VirtualService *VirtualServiceData `locationName:"virtualService" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualServiceOutput) GoString() string {
	return s.String()
}

// SetVirtualService sets the VirtualService field's value.
func (s *DeleteVirtualServiceOutput) SetVirtualService(v *VirtualServiceData) *DeleteVirtualServiceOutput {
	s.VirtualService = v
	return s
}

type DescribeGatewayRouteInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the gateway route to describe.
	//
	// GatewayRouteName is a required field
	GatewayRouteName *string `location:"uri" locationName:"gatewayRouteName" min:"1" type:"string" required:"true"`

	// The name of the service mesh that the gateway route resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name of the virtual gateway that the gateway route is associated with.
	//
	// VirtualGatewayName is a required field
	VirtualGatewayName *string `location:"uri" locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGatewayRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGatewayRouteInput"}
	if s.GatewayRouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayRouteName"))
	}
	if s.GatewayRouteName != nil && len(*s.GatewayRouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayRouteName", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.VirtualGatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualGatewayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayRouteName sets the GatewayRouteName field's value.
func (s *DescribeGatewayRouteInput) SetGatewayRouteName(v string) *DescribeGatewayRouteInput {
	s.GatewayRouteName = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeGatewayRouteInput) SetMeshName(v string) *DescribeGatewayRouteInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *DescribeGatewayRouteInput) SetMeshOwner(v string) *DescribeGatewayRouteInput {
	s.MeshOwner = &v
	return s
}

// SetVirtualGatewayName sets the VirtualGatewayName field's value.
func (s *DescribeGatewayRouteInput) SetVirtualGatewayName(v string) *DescribeGatewayRouteInput {
	s.VirtualGatewayName = &v
	return s
}

type DescribeGatewayRouteOutput struct {
	_ struct{} `type:"structure" payload:"GatewayRoute"`

	// The full description of your gateway route.
	//
	// GatewayRoute is a required field
	GatewayRoute *GatewayRouteData `locationName:"gatewayRoute" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayRouteOutput) GoString() string {
	return s.String()
}

// SetGatewayRoute sets the GatewayRoute field's value.
func (s *DescribeGatewayRouteOutput) SetGatewayRoute(v *GatewayRouteData) *DescribeGatewayRouteOutput {
	s.GatewayRoute = v
	return s
}

type DescribeMeshInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the service mesh to describe.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMeshInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMeshInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMeshInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMeshInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeMeshInput) SetMeshName(v string) *DescribeMeshInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *DescribeMeshInput) SetMeshOwner(v string) *DescribeMeshInput {
	s.MeshOwner = &v
	return s
}

type DescribeMeshOutput struct {
	_ struct{} `type:"structure" payload:"Mesh"`

	// The full description of your service mesh.
	//
	// Mesh is a required field
	Mesh *MeshData `locationName:"mesh" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMeshOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMeshOutput) GoString() string {
	return s.String()
}

// SetMesh sets the Mesh field's value.
func (s *DescribeMeshOutput) SetMesh(v *MeshData) *DescribeMeshOutput {
	s.Mesh = v
	return s
}

type DescribeRouteInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the service mesh that the route resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name of the route to describe.
	//
	// RouteName is a required field
	RouteName *string `location:"uri" locationName:"routeName" min:"1" type:"string" required:"true"`

	// The name of the virtual router that the route is associated with.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRouteInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.RouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteName"))
	}
	if s.RouteName != nil && len(*s.RouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteName", 1))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeRouteInput) SetMeshName(v string) *DescribeRouteInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *DescribeRouteInput) SetMeshOwner(v string) *DescribeRouteInput {
	s.MeshOwner = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *DescribeRouteInput) SetRouteName(v string) *DescribeRouteInput {
	s.RouteName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *DescribeRouteInput) SetVirtualRouterName(v string) *DescribeRouteInput {
	s.VirtualRouterName = &v
	return s
}

type DescribeRouteOutput struct {
	_ struct{} `type:"structure" payload:"Route"`

	// The full description of your route.
	//
	// Route is a required field
	Route *RouteData `locationName:"route" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRouteOutput) GoString() string {
	return s.String()
}

// SetRoute sets the Route field's value.
func (s *DescribeRouteOutput) SetRoute(v *RouteData) *DescribeRouteOutput {
	s.Route = v
	return s
}

type DescribeVirtualGatewayInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the service mesh that the gateway route resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name of the virtual gateway to describe.
	//
	// VirtualGatewayName is a required field
	VirtualGatewayName *string `location:"uri" locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVirtualGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVirtualGatewayInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.VirtualGatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualGatewayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeVirtualGatewayInput) SetMeshName(v string) *DescribeVirtualGatewayInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *DescribeVirtualGatewayInput) SetMeshOwner(v string) *DescribeVirtualGatewayInput {
	s.MeshOwner = &v
	return s
}

// SetVirtualGatewayName sets the VirtualGatewayName field's value.
func (s *DescribeVirtualGatewayInput) SetVirtualGatewayName(v string) *DescribeVirtualGatewayInput {
	s.VirtualGatewayName = &v
	return s
}

type DescribeVirtualGatewayOutput struct {
	_ struct{} `type:"structure" payload:"VirtualGateway"`

	// The full description of your virtual gateway.
	//
	// VirtualGateway is a required field
	VirtualGateway *VirtualGatewayData `locationName:"virtualGateway" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualGatewayOutput) GoString() string {
	return s.String()
}

// SetVirtualGateway sets the VirtualGateway field's value.
func (s *DescribeVirtualGatewayOutput) SetVirtualGateway(v *VirtualGatewayData) *DescribeVirtualGatewayOutput {
	s.VirtualGateway = v
	return s
}

type DescribeVirtualNodeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the service mesh that the virtual node resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name of the virtual node to describe.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `location:"uri" locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVirtualNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVirtualNodeInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeVirtualNodeInput) SetMeshName(v string) *DescribeVirtualNodeInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *DescribeVirtualNodeInput) SetMeshOwner(v string) *DescribeVirtualNodeInput {
	s.MeshOwner = &v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *DescribeVirtualNodeInput) SetVirtualNodeName(v string) *DescribeVirtualNodeInput {
	s.VirtualNodeName = &v
	return s
}

type DescribeVirtualNodeOutput struct {
	_ struct{} `type:"structure" payload:"VirtualNode"`

	// The full description of your virtual node.
	//
	// VirtualNode is a required field
	VirtualNode *VirtualNodeData `locationName:"virtualNode" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualNodeOutput) GoString() string {
	return s.String()
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *DescribeVirtualNodeOutput) SetVirtualNode(v *VirtualNodeData) *DescribeVirtualNodeOutput {
	s.VirtualNode = v
	return s
}

type DescribeVirtualRouterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the service mesh that the virtual router resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name of the virtual router to describe.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualRouterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVirtualRouterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVirtualRouterInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeVirtualRouterInput) SetMeshName(v string) *DescribeVirtualRouterInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *DescribeVirtualRouterInput) SetMeshOwner(v string) *DescribeVirtualRouterInput {
	s.MeshOwner = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *DescribeVirtualRouterInput) SetVirtualRouterName(v string) *DescribeVirtualRouterInput {
	s.VirtualRouterName = &v
	return s
}

type DescribeVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// The full description of your virtual router.
	//
	// VirtualRouter is a required field
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualRouterOutput) GoString() string {
	return s.String()
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *DescribeVirtualRouterOutput) SetVirtualRouter(v *VirtualRouterData) *DescribeVirtualRouterOutput {
	s.VirtualRouter = v
	return s
}

type DescribeVirtualServiceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the service mesh that the virtual service resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name of the virtual service to describe.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `location:"uri" locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVirtualServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVirtualServiceInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.VirtualServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualServiceName"))
	}
	if s.VirtualServiceName != nil && len(*s.VirtualServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeVirtualServiceInput) SetMeshName(v string) *DescribeVirtualServiceInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *DescribeVirtualServiceInput) SetMeshOwner(v string) *DescribeVirtualServiceInput {
	s.MeshOwner = &v
	return s
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *DescribeVirtualServiceInput) SetVirtualServiceName(v string) *DescribeVirtualServiceInput {
	s.VirtualServiceName = &v
	return s
}

type DescribeVirtualServiceOutput struct {
	_ struct{} `type:"structure" payload:"VirtualService"`

	// The full description of your virtual service.
	//
	// VirtualService is a required field
	VirtualService *VirtualServiceData `locationName:"virtualService" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualServiceOutput) GoString() string {
	return s.String()
}

// SetVirtualService sets the VirtualService field's value.
func (s *DescribeVirtualServiceOutput) SetVirtualService(v *VirtualServiceData) *DescribeVirtualServiceOutput {
	s.VirtualService = v
	return s
}

// An object that represents the DNS service discovery information for your
// virtual node.
type DnsServiceDiscovery struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS service discovery hostname for the virtual node.
	//
	// Hostname is a required field
	Hostname *string `locationName:"hostname" type:"string" required:"true"`

	// The preferred IP version that this virtual node uses. Setting the IP preference
	// on the virtual node only overrides the IP preference set for the mesh on
	// this specific node.
	IpPreference *string `locationName:"ipPreference" type:"string" enum:"IpPreference"`

	// Specifies the DNS response type for the virtual node.
	ResponseType *string `locationName:"responseType" type:"string" enum:"DnsResponseType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DnsServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DnsServiceDiscovery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DnsServiceDiscovery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DnsServiceDiscovery"}
	if s.Hostname == nil {
		invalidParams.Add(request.NewErrParamRequired("Hostname"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostname sets the Hostname field's value.
func (s *DnsServiceDiscovery) SetHostname(v string) *DnsServiceDiscovery {
	s.Hostname = &v
	return s
}

// SetIpPreference sets the IpPreference field's value.
func (s *DnsServiceDiscovery) SetIpPreference(v string) *DnsServiceDiscovery {
	s.IpPreference = &v
	return s
}

// SetResponseType sets the ResponseType field's value.
func (s *DnsServiceDiscovery) SetResponseType(v string) *DnsServiceDiscovery {
	s.ResponseType = &v
	return s
}

// An object that represents a duration of time.
type Duration struct {
	_ struct{} `type:"structure"`

	// A unit of time.
	Unit *string `locationName:"unit" type:"string" enum:"DurationUnit"`

	// A number of time units.
	Value *int64 `locationName:"value" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Duration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Duration) GoString() string {
	return s.String()
}

// SetUnit sets the Unit field's value.
func (s *Duration) SetUnit(v string) *Duration {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Duration) SetValue(v int64) *Duration {
	s.Value = &v
	return s
}

// An object that represents the egress filter rules for a service mesh.
type EgressFilter struct {
	_ struct{} `type:"structure"`

	// The egress filter type. By default, the type is DROP_ALL, which allows egress
	// only from virtual nodes to other defined resources in the service mesh (and
	// any traffic to *.amazonaws.com for Amazon Web Services API calls). You can
	// set the egress filter type to ALLOW_ALL to allow egress to any endpoint inside
	// or outside of the service mesh.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"EgressFilterType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EgressFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EgressFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EgressFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EgressFilter"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *EgressFilter) SetType(v string) *EgressFilter {
	s.Type = &v
	return s
}

// An object that represents an access log file.
type FileAccessLog struct {
	_ struct{} `type:"structure"`

	// The specified format for the logs. The format is either json_format or text_format.
	Format *LoggingFormat `locationName:"format" type:"structure"`

	// The file path to write access logs to. You can use /dev/stdout to send access
	// logs to standard out and configure your Envoy container to use a log driver,
	// such as awslogs, to export the access logs to a log storage service such
	// as Amazon CloudWatch Logs. You can also specify a path in the Envoy container's
	// file system to write the files to disk.
	//
	// The Envoy process must have write permissions to the path that you specify
	// here. Otherwise, Envoy fails to bootstrap properly.
	//
	// Path is a required field
	Path *string `locationName:"path" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileAccessLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileAccessLog) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FileAccessLog) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FileAccessLog"}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}
	if s.Format != nil {
		if err := s.Format.Validate(); err != nil {
			invalidParams.AddNested("Format", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFormat sets the Format field's value.
func (s *FileAccessLog) SetFormat(v *LoggingFormat) *FileAccessLog {
	s.Format = v
	return s
}

// SetPath sets the Path field's value.
func (s *FileAccessLog) SetPath(v string) *FileAccessLog {
	s.Path = &v
	return s
}

// You don't have permissions to perform this action.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents a gateway route returned by a describe operation.
type GatewayRouteData struct {
	_ struct{} `type:"structure"`

	// The name of the gateway route.
	//
	// GatewayRouteName is a required field
	GatewayRouteName *string `locationName:"gatewayRouteName" min:"1" type:"string" required:"true"`

	// The name of the service mesh that the resource resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// An object that represents metadata for a resource.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The specifications of the gateway route.
	//
	// Spec is a required field
	Spec *GatewayRouteSpec `locationName:"spec" type:"structure" required:"true"`

	// The status of the gateway route.
	//
	// Status is a required field
	Status *GatewayRouteStatus `locationName:"status" type:"structure" required:"true"`

	// The virtual gateway that the gateway route is associated with.
	//
	// VirtualGatewayName is a required field
	VirtualGatewayName *string `locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteData) GoString() string {
	return s.String()
}

// SetGatewayRouteName sets the GatewayRouteName field's value.
func (s *GatewayRouteData) SetGatewayRouteName(v string) *GatewayRouteData {
	s.GatewayRouteName = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *GatewayRouteData) SetMeshName(v string) *GatewayRouteData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GatewayRouteData) SetMetadata(v *ResourceMetadata) *GatewayRouteData {
	s.Metadata = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *GatewayRouteData) SetSpec(v *GatewayRouteSpec) *GatewayRouteData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GatewayRouteData) SetStatus(v *GatewayRouteStatus) *GatewayRouteData {
	s.Status = v
	return s
}

// SetVirtualGatewayName sets the VirtualGatewayName field's value.
func (s *GatewayRouteData) SetVirtualGatewayName(v string) *GatewayRouteData {
	s.VirtualGatewayName = &v
	return s
}

// An object representing the gateway route host name to match.
type GatewayRouteHostnameMatch struct {
	_ struct{} `type:"structure"`

	// The exact host name to match on.
	Exact *string `locationName:"exact" min:"1" type:"string"`

	// The specified ending characters of the host name to match on.
	Suffix *string `locationName:"suffix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteHostnameMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteHostnameMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GatewayRouteHostnameMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GatewayRouteHostnameMatch"}
	if s.Exact != nil && len(*s.Exact) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Exact", 1))
	}
	if s.Suffix != nil && len(*s.Suffix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Suffix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExact sets the Exact field's value.
func (s *GatewayRouteHostnameMatch) SetExact(v string) *GatewayRouteHostnameMatch {
	s.Exact = &v
	return s
}

// SetSuffix sets the Suffix field's value.
func (s *GatewayRouteHostnameMatch) SetSuffix(v string) *GatewayRouteHostnameMatch {
	s.Suffix = &v
	return s
}

// An object representing the gateway route host name to rewrite.
type GatewayRouteHostnameRewrite struct {
	_ struct{} `type:"structure"`

	// The default target host name to write to.
	DefaultTargetHostname *string `locationName:"defaultTargetHostname" type:"string" enum:"DefaultGatewayRouteRewrite"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteHostnameRewrite) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteHostnameRewrite) GoString() string {
	return s.String()
}

// SetDefaultTargetHostname sets the DefaultTargetHostname field's value.
func (s *GatewayRouteHostnameRewrite) SetDefaultTargetHostname(v string) *GatewayRouteHostnameRewrite {
	s.DefaultTargetHostname = &v
	return s
}

// An object that represents a gateway route returned by a list operation.
type GatewayRouteRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the gateway route.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The name of the gateway route.
	//
	// GatewayRouteName is a required field
	GatewayRouteName *string `locationName:"gatewayRouteName" min:"1" type:"string" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" required:"true"`

	// The name of the service mesh that the resource resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// MeshOwner is a required field
	MeshOwner *string `locationName:"meshOwner" min:"12" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the resource owner. If the account
	// ID is not your own, then it's the ID of the mesh owner or of another account
	// that the mesh is shared with. For more information about mesh sharing, see
	// Working with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" min:"12" type:"string" required:"true"`

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// Version is a required field
	Version *int64 `locationName:"version" type:"long" required:"true"`

	// The virtual gateway that the gateway route is associated with.
	//
	// VirtualGatewayName is a required field
	VirtualGatewayName *string `locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GatewayRouteRef) SetArn(v string) *GatewayRouteRef {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GatewayRouteRef) SetCreatedAt(v time.Time) *GatewayRouteRef {
	s.CreatedAt = &v
	return s
}

// SetGatewayRouteName sets the GatewayRouteName field's value.
func (s *GatewayRouteRef) SetGatewayRouteName(v string) *GatewayRouteRef {
	s.GatewayRouteName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GatewayRouteRef) SetLastUpdatedAt(v time.Time) *GatewayRouteRef {
	s.LastUpdatedAt = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *GatewayRouteRef) SetMeshName(v string) *GatewayRouteRef {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *GatewayRouteRef) SetMeshOwner(v string) *GatewayRouteRef {
	s.MeshOwner = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *GatewayRouteRef) SetResourceOwner(v string) *GatewayRouteRef {
	s.ResourceOwner = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GatewayRouteRef) SetVersion(v int64) *GatewayRouteRef {
	s.Version = &v
	return s
}

// SetVirtualGatewayName sets the VirtualGatewayName field's value.
func (s *GatewayRouteRef) SetVirtualGatewayName(v string) *GatewayRouteRef {
	s.VirtualGatewayName = &v
	return s
}

// An object that represents a gateway route specification. Specify one gateway
// route type.
type GatewayRouteSpec struct {
	_ struct{} `type:"structure"`

	// An object that represents the specification of a gRPC gateway route.
	GrpcRoute *GrpcGatewayRoute `locationName:"grpcRoute" type:"structure"`

	// An object that represents the specification of an HTTP/2 gateway route.
	Http2Route *HttpGatewayRoute `locationName:"http2Route" type:"structure"`

	// An object that represents the specification of an HTTP gateway route.
	HttpRoute *HttpGatewayRoute `locationName:"httpRoute" type:"structure"`

	// The ordering of the gateway routes spec.
	Priority *int64 `locationName:"priority" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GatewayRouteSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GatewayRouteSpec"}
	if s.GrpcRoute != nil {
		if err := s.GrpcRoute.Validate(); err != nil {
			invalidParams.AddNested("GrpcRoute", err.(request.ErrInvalidParams))
		}
	}
	if s.Http2Route != nil {
		if err := s.Http2Route.Validate(); err != nil {
			invalidParams.AddNested("Http2Route", err.(request.ErrInvalidParams))
		}
	}
	if s.HttpRoute != nil {
		if err := s.HttpRoute.Validate(); err != nil {
			invalidParams.AddNested("HttpRoute", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrpcRoute sets the GrpcRoute field's value.
func (s *GatewayRouteSpec) SetGrpcRoute(v *GrpcGatewayRoute) *GatewayRouteSpec {
	s.GrpcRoute = v
	return s
}

// SetHttp2Route sets the Http2Route field's value.
func (s *GatewayRouteSpec) SetHttp2Route(v *HttpGatewayRoute) *GatewayRouteSpec {
	s.Http2Route = v
	return s
}

// SetHttpRoute sets the HttpRoute field's value.
func (s *GatewayRouteSpec) SetHttpRoute(v *HttpGatewayRoute) *GatewayRouteSpec {
	s.HttpRoute = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *GatewayRouteSpec) SetPriority(v int64) *GatewayRouteSpec {
	s.Priority = &v
	return s
}

// An object that represents the current status of a gateway route.
type GatewayRouteStatus struct {
	_ struct{} `type:"structure"`

	// The current status for the gateway route.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"GatewayRouteStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *GatewayRouteStatus) SetStatus(v string) *GatewayRouteStatus {
	s.Status = &v
	return s
}

// An object that represents a gateway route target.
type GatewayRouteTarget struct {
	_ struct{} `type:"structure"`

	// The port number of the gateway route target.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// An object that represents a virtual service gateway route target.
	//
	// VirtualService is a required field
	VirtualService *GatewayRouteVirtualService `locationName:"virtualService" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GatewayRouteTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GatewayRouteTarget"}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.VirtualService == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualService"))
	}
	if s.VirtualService != nil {
		if err := s.VirtualService.Validate(); err != nil {
			invalidParams.AddNested("VirtualService", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPort sets the Port field's value.
func (s *GatewayRouteTarget) SetPort(v int64) *GatewayRouteTarget {
	s.Port = &v
	return s
}

// SetVirtualService sets the VirtualService field's value.
func (s *GatewayRouteTarget) SetVirtualService(v *GatewayRouteVirtualService) *GatewayRouteTarget {
	s.VirtualService = v
	return s
}

// An object that represents the virtual service that traffic is routed to.
type GatewayRouteVirtualService struct {
	_ struct{} `type:"structure"`

	// The name of the virtual service that traffic is routed to.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteVirtualService) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayRouteVirtualService) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GatewayRouteVirtualService) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GatewayRouteVirtualService"}
	if s.VirtualServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualServiceName"))
	}
	if s.VirtualServiceName != nil && len(*s.VirtualServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *GatewayRouteVirtualService) SetVirtualServiceName(v string) *GatewayRouteVirtualService {
	s.VirtualServiceName = &v
	return s
}

// An object that represents a gRPC gateway route.
type GrpcGatewayRoute struct {
	_ struct{} `type:"structure"`

	// An object that represents the action to take if a match is determined.
	//
	// Action is a required field
	Action *GrpcGatewayRouteAction `locationName:"action" type:"structure" required:"true"`

	// An object that represents the criteria for determining a request match.
	//
	// Match is a required field
	Match *GrpcGatewayRouteMatch `locationName:"match" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcGatewayRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcGatewayRoute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcGatewayRoute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrpcGatewayRoute"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Match == nil {
		invalidParams.Add(request.NewErrParamRequired("Match"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *GrpcGatewayRoute) SetAction(v *GrpcGatewayRouteAction) *GrpcGatewayRoute {
	s.Action = v
	return s
}

// SetMatch sets the Match field's value.
func (s *GrpcGatewayRoute) SetMatch(v *GrpcGatewayRouteMatch) *GrpcGatewayRoute {
	s.Match = v
	return s
}

// An object that represents the action to take if a match is determined.
type GrpcGatewayRouteAction struct {
	_ struct{} `type:"structure"`

	// The gateway route action to rewrite.
	Rewrite *GrpcGatewayRouteRewrite `locationName:"rewrite" type:"structure"`

	// An object that represents the target that traffic is routed to when a request
	// matches the gateway route.
	//
	// Target is a required field
	Target *GatewayRouteTarget `locationName:"target" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcGatewayRouteAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcGatewayRouteAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcGatewayRouteAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrpcGatewayRouteAction"}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRewrite sets the Rewrite field's value.
func (s *GrpcGatewayRouteAction) SetRewrite(v *GrpcGatewayRouteRewrite) *GrpcGatewayRouteAction {
	s.Rewrite = v
	return s
}

// SetTarget sets the Target field's value.
func (s *GrpcGatewayRouteAction) SetTarget(v *GatewayRouteTarget) *GrpcGatewayRouteAction {
	s.Target = v
	return s
}

// An object that represents the criteria for determining a request match.
type GrpcGatewayRouteMatch struct {
	_ struct{} `type:"structure"`

	// The gateway route host name to be matched on.
	Hostname *GatewayRouteHostnameMatch `locationName:"hostname" type:"structure"`

	// The gateway route metadata to be matched on.
	Metadata []*GrpcGatewayRouteMetadata `locationName:"metadata" min:"1" type:"list"`

	// The gateway route port to be matched on.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The fully qualified domain name for the service to match from the request.
	ServiceName *string `locationName:"serviceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcGatewayRouteMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcGatewayRouteMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcGatewayRouteMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrpcGatewayRouteMatch"}
	if s.Metadata != nil && len(s.Metadata) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Metadata", 1))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Hostname != nil {
		if err := s.Hostname.Validate(); err != nil {
			invalidParams.AddNested("Hostname", err.(request.ErrInvalidParams))
		}
	}
	if s.Metadata != nil {
		for i, v := range s.Metadata {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Metadata", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostname sets the Hostname field's value.
func (s *GrpcGatewayRouteMatch) SetHostname(v *GatewayRouteHostnameMatch) *GrpcGatewayRouteMatch {
	s.Hostname = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GrpcGatewayRouteMatch) SetMetadata(v []*GrpcGatewayRouteMetadata) *GrpcGatewayRouteMatch {
	s.Metadata = v
	return s
}

// SetPort sets the Port field's value.
func (s *GrpcGatewayRouteMatch) SetPort(v int64) *GrpcGatewayRouteMatch {
	s.Port = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *GrpcGatewayRouteMatch) SetServiceName(v string) *GrpcGatewayRouteMatch {
	s.ServiceName = &v
	return s
}

// An object representing the metadata of the gateway route.
type GrpcGatewayRouteMetadata struct {
	_ struct{} `type:"structure"`

	// Specify True to match anything except the match criteria. The default value
	// is False.
	Invert *bool `locationName:"invert" type:"boolean"`

	// The criteria for determining a metadata match.
	Match *GrpcMetadataMatchMethod `locationName:"match" type:"structure"`

	// A name for the gateway route metadata.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcGatewayRouteMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcGatewayRouteMetadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcGatewayRouteMetadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrpcGatewayRouteMetadata"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvert sets the Invert field's value.
func (s *GrpcGatewayRouteMetadata) SetInvert(v bool) *GrpcGatewayRouteMetadata {
	s.Invert = &v
	return s
}

// SetMatch sets the Match field's value.
func (s *GrpcGatewayRouteMetadata) SetMatch(v *GrpcMetadataMatchMethod) *GrpcGatewayRouteMetadata {
	s.Match = v
	return s
}

// SetName sets the Name field's value.
func (s *GrpcGatewayRouteMetadata) SetName(v string) *GrpcGatewayRouteMetadata {
	s.Name = &v
	return s
}

// An object that represents the gateway route to rewrite.
type GrpcGatewayRouteRewrite struct {
	_ struct{} `type:"structure"`

	// The host name of the gateway route to rewrite.
	Hostname *GatewayRouteHostnameRewrite `locationName:"hostname" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcGatewayRouteRewrite) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcGatewayRouteRewrite) GoString() string {
	return s.String()
}

// SetHostname sets the Hostname field's value.
func (s *GrpcGatewayRouteRewrite) SetHostname(v *GatewayRouteHostnameRewrite) *GrpcGatewayRouteRewrite {
	s.Hostname = v
	return s
}

// An object representing the method header to be matched.
type GrpcMetadataMatchMethod struct {
	_ struct{} `type:"structure"`

	// The exact method header to be matched on.
	Exact *string `locationName:"exact" min:"1" type:"string"`

	// The specified beginning characters of the method header to be matched on.
	Prefix *string `locationName:"prefix" min:"1" type:"string"`

	// An object that represents the range of values to match on. The first character
	// of the range is included in the range, though the last character is not.
	// For example, if the range specified were 1-100, only values 1-99 would be
	// matched.
	Range *MatchRange `locationName:"range" type:"structure"`

	// The regex used to match the method header.
	Regex *string `locationName:"regex" min:"1" type:"string"`

	// The specified ending characters of the method header to match on.
	Suffix *string `locationName:"suffix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcMetadataMatchMethod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcMetadataMatchMethod) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcMetadataMatchMethod) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrpcMetadataMatchMethod"}
	if s.Exact != nil && len(*s.Exact) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Exact", 1))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}
	if s.Regex != nil && len(*s.Regex) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Regex", 1))
	}
	if s.Suffix != nil && len(*s.Suffix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Suffix", 1))
	}
	if s.Range != nil {
		if err := s.Range.Validate(); err != nil {
			invalidParams.AddNested("Range", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExact sets the Exact field's value.
func (s *GrpcMetadataMatchMethod) SetExact(v string) *GrpcMetadataMatchMethod {
	s.Exact = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *GrpcMetadataMatchMethod) SetPrefix(v string) *GrpcMetadataMatchMethod {
	s.Prefix = &v
	return s
}

// SetRange sets the Range field's value.
func (s *GrpcMetadataMatchMethod) SetRange(v *MatchRange) *GrpcMetadataMatchMethod {
	s.Range = v
	return s
}

// SetRegex sets the Regex field's value.
func (s *GrpcMetadataMatchMethod) SetRegex(v string) *GrpcMetadataMatchMethod {
	s.Regex = &v
	return s
}

// SetSuffix sets the Suffix field's value.
func (s *GrpcMetadataMatchMethod) SetSuffix(v string) *GrpcMetadataMatchMethod {
	s.Suffix = &v
	return s
}

// An object that represents a retry policy. Specify at least one value for
// at least one of the types of RetryEvents, a value for maxRetries, and a value
// for perRetryTimeout. Both server-error and gateway-error under httpRetryEvents
// include the Envoy reset policy. For more information on the reset policy,
// see the Envoy documentation (https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-on).
type GrpcRetryPolicy struct {
	_ struct{} `type:"structure"`

	// Specify at least one of the valid values.
	GrpcRetryEvents []*string `locationName:"grpcRetryEvents" min:"1" type:"list" enum:"GrpcRetryPolicyEvent"`

	// Specify at least one of the following values.
	//
	//    * server-error – HTTP status codes 500, 501, 502, 503, 504, 505, 506,
	//    507, 508, 510, and 511
	//
	//    * gateway-error – HTTP status codes 502, 503, and 504
	//
	//    * client-error – HTTP status code 409
	//
	//    * stream-error – Retry on refused stream
	HttpRetryEvents []*string `locationName:"httpRetryEvents" min:"1" type:"list"`

	// The maximum number of retry attempts.
	//
	// MaxRetries is a required field
	MaxRetries *int64 `locationName:"maxRetries" type:"long" required:"true"`

	// The timeout for each retry attempt.
	//
	// PerRetryTimeout is a required field
	PerRetryTimeout *Duration `locationName:"perRetryTimeout" type:"structure" required:"true"`

	// Specify a valid value. The event occurs before any processing of a request
	// has started and is encountered when the upstream is temporarily or permanently
	// unavailable.
	TcpRetryEvents []*string `locationName:"tcpRetryEvents" min:"1" type:"list" enum:"TcpRetryPolicyEvent"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcRetryPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcRetryPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcRetryPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrpcRetryPolicy"}
	if s.GrpcRetryEvents != nil && len(s.GrpcRetryEvents) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrpcRetryEvents", 1))
	}
	if s.HttpRetryEvents != nil && len(s.HttpRetryEvents) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpRetryEvents", 1))
	}
	if s.MaxRetries == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxRetries"))
	}
	if s.PerRetryTimeout == nil {
		invalidParams.Add(request.NewErrParamRequired("PerRetryTimeout"))
	}
	if s.TcpRetryEvents != nil && len(s.TcpRetryEvents) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TcpRetryEvents", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrpcRetryEvents sets the GrpcRetryEvents field's value.
func (s *GrpcRetryPolicy) SetGrpcRetryEvents(v []*string) *GrpcRetryPolicy {
	s.GrpcRetryEvents = v
	return s
}

// SetHttpRetryEvents sets the HttpRetryEvents field's value.
func (s *GrpcRetryPolicy) SetHttpRetryEvents(v []*string) *GrpcRetryPolicy {
	s.HttpRetryEvents = v
	return s
}

// SetMaxRetries sets the MaxRetries field's value.
func (s *GrpcRetryPolicy) SetMaxRetries(v int64) *GrpcRetryPolicy {
	s.MaxRetries = &v
	return s
}

// SetPerRetryTimeout sets the PerRetryTimeout field's value.
func (s *GrpcRetryPolicy) SetPerRetryTimeout(v *Duration) *GrpcRetryPolicy {
	s.PerRetryTimeout = v
	return s
}

// SetTcpRetryEvents sets the TcpRetryEvents field's value.
func (s *GrpcRetryPolicy) SetTcpRetryEvents(v []*string) *GrpcRetryPolicy {
	s.TcpRetryEvents = v
	return s
}

// An object that represents a gRPC route type.
type GrpcRoute struct {
	_ struct{} `type:"structure"`

	// An object that represents the action to take if a match is determined.
	//
	// Action is a required field
	Action *GrpcRouteAction `locationName:"action" type:"structure" required:"true"`

	// An object that represents the criteria for determining a request match.
	//
	// Match is a required field
	Match *GrpcRouteMatch `locationName:"match" type:"structure" required:"true"`

	// An object that represents a retry policy.
	RetryPolicy *GrpcRetryPolicy `locationName:"retryPolicy" type:"structure"`

	// An object that represents types of timeouts.
	Timeout *GrpcTimeout `locationName:"timeout" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcRoute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcRoute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrpcRoute"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Match == nil {
		invalidParams.Add(request.NewErrParamRequired("Match"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}
	if s.RetryPolicy != nil {
		if err := s.RetryPolicy.Validate(); err != nil {
			invalidParams.AddNested("RetryPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *GrpcRoute) SetAction(v *GrpcRouteAction) *GrpcRoute {
	s.Action = v
	return s
}

// SetMatch sets the Match field's value.
func (s *GrpcRoute) SetMatch(v *GrpcRouteMatch) *GrpcRoute {
	s.Match = v
	return s
}

// SetRetryPolicy sets the RetryPolicy field's value.
func (s *GrpcRoute) SetRetryPolicy(v *GrpcRetryPolicy) *GrpcRoute {
	s.RetryPolicy = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *GrpcRoute) SetTimeout(v *GrpcTimeout) *GrpcRoute {
	s.Timeout = v
	return s
}

// An object that represents the action to take if a match is determined.
type GrpcRouteAction struct {
	_ struct{} `type:"structure"`

	// An object that represents the targets that traffic is routed to when a request
	// matches the route.
	//
	// WeightedTargets is a required field
	WeightedTargets []*WeightedTarget `locationName:"weightedTargets" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcRouteAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcRouteAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcRouteAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrpcRouteAction"}
	if s.WeightedTargets == nil {
		invalidParams.Add(request.NewErrParamRequired("WeightedTargets"))
	}
	if s.WeightedTargets != nil && len(s.WeightedTargets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WeightedTargets", 1))
	}
	if s.WeightedTargets != nil {
		for i, v := range s.WeightedTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WeightedTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWeightedTargets sets the WeightedTargets field's value.
func (s *GrpcRouteAction) SetWeightedTargets(v []*WeightedTarget) *GrpcRouteAction {
	s.WeightedTargets = v
	return s
}

// An object that represents the criteria for determining a request match.
type GrpcRouteMatch struct {
	_ struct{} `type:"structure"`

	// An object that represents the data to match from the request.
	Metadata []*GrpcRouteMetadata `locationName:"metadata" min:"1" type:"list"`

	// The method name to match from the request. If you specify a name, you must
	// also specify a serviceName.
	MethodName *string `locationName:"methodName" min:"1" type:"string"`

	// The port number to match on.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The fully qualified domain name for the service to match from the request.
	ServiceName *string `locationName:"serviceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcRouteMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcRouteMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcRouteMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrpcRouteMatch"}
	if s.Metadata != nil && len(s.Metadata) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Metadata", 1))
	}
	if s.MethodName != nil && len(*s.MethodName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MethodName", 1))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Metadata != nil {
		for i, v := range s.Metadata {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Metadata", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetadata sets the Metadata field's value.
func (s *GrpcRouteMatch) SetMetadata(v []*GrpcRouteMetadata) *GrpcRouteMatch {
	s.Metadata = v
	return s
}

// SetMethodName sets the MethodName field's value.
func (s *GrpcRouteMatch) SetMethodName(v string) *GrpcRouteMatch {
	s.MethodName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *GrpcRouteMatch) SetPort(v int64) *GrpcRouteMatch {
	s.Port = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *GrpcRouteMatch) SetServiceName(v string) *GrpcRouteMatch {
	s.ServiceName = &v
	return s
}

// An object that represents the match metadata for the route.
type GrpcRouteMetadata struct {
	_ struct{} `type:"structure"`

	// Specify True to match anything except the match criteria. The default value
	// is False.
	Invert *bool `locationName:"invert" type:"boolean"`

	// An object that represents the data to match from the request.
	Match *GrpcRouteMetadataMatchMethod `locationName:"match" type:"structure"`

	// The name of the route.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcRouteMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcRouteMetadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcRouteMetadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrpcRouteMetadata"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvert sets the Invert field's value.
func (s *GrpcRouteMetadata) SetInvert(v bool) *GrpcRouteMetadata {
	s.Invert = &v
	return s
}

// SetMatch sets the Match field's value.
func (s *GrpcRouteMetadata) SetMatch(v *GrpcRouteMetadataMatchMethod) *GrpcRouteMetadata {
	s.Match = v
	return s
}

// SetName sets the Name field's value.
func (s *GrpcRouteMetadata) SetName(v string) *GrpcRouteMetadata {
	s.Name = &v
	return s
}

// An object that represents the match method. Specify one of the match values.
type GrpcRouteMetadataMatchMethod struct {
	_ struct{} `type:"structure"`

	// The value sent by the client must match the specified value exactly.
	Exact *string `locationName:"exact" min:"1" type:"string"`

	// The value sent by the client must begin with the specified characters.
	Prefix *string `locationName:"prefix" min:"1" type:"string"`

	// An object that represents the range of values to match on.
	Range *MatchRange `locationName:"range" type:"structure"`

	// The value sent by the client must include the specified characters.
	Regex *string `locationName:"regex" min:"1" type:"string"`

	// The value sent by the client must end with the specified characters.
	Suffix *string `locationName:"suffix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcRouteMetadataMatchMethod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcRouteMetadataMatchMethod) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcRouteMetadataMatchMethod) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrpcRouteMetadataMatchMethod"}
	if s.Exact != nil && len(*s.Exact) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Exact", 1))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}
	if s.Regex != nil && len(*s.Regex) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Regex", 1))
	}
	if s.Suffix != nil && len(*s.Suffix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Suffix", 1))
	}
	if s.Range != nil {
		if err := s.Range.Validate(); err != nil {
			invalidParams.AddNested("Range", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExact sets the Exact field's value.
func (s *GrpcRouteMetadataMatchMethod) SetExact(v string) *GrpcRouteMetadataMatchMethod {
	s.Exact = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *GrpcRouteMetadataMatchMethod) SetPrefix(v string) *GrpcRouteMetadataMatchMethod {
	s.Prefix = &v
	return s
}

// SetRange sets the Range field's value.
func (s *GrpcRouteMetadataMatchMethod) SetRange(v *MatchRange) *GrpcRouteMetadataMatchMethod {
	s.Range = v
	return s
}

// SetRegex sets the Regex field's value.
func (s *GrpcRouteMetadataMatchMethod) SetRegex(v string) *GrpcRouteMetadataMatchMethod {
	s.Regex = &v
	return s
}

// SetSuffix sets the Suffix field's value.
func (s *GrpcRouteMetadataMatchMethod) SetSuffix(v string) *GrpcRouteMetadataMatchMethod {
	s.Suffix = &v
	return s
}

// An object that represents types of timeouts.
type GrpcTimeout struct {
	_ struct{} `type:"structure"`

	// An object that represents an idle timeout. An idle timeout bounds the amount
	// of time that a connection may be idle. The default value is none.
	Idle *Duration `locationName:"idle" type:"structure"`

	// An object that represents a per request timeout. The default value is 15
	// seconds. If you set a higher timeout, then make sure that the higher value
	// is set for each App Mesh resource in a conversation. For example, if a virtual
	// node backend uses a virtual router provider to route to another virtual node,
	// then the timeout should be greater than 15 seconds for the source and destination
	// virtual node and the route.
	PerRequest *Duration `locationName:"perRequest" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcTimeout) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrpcTimeout) GoString() string {
	return s.String()
}

// SetIdle sets the Idle field's value.
func (s *GrpcTimeout) SetIdle(v *Duration) *GrpcTimeout {
	s.Idle = v
	return s
}

// SetPerRequest sets the PerRequest field's value.
func (s *GrpcTimeout) SetPerRequest(v *Duration) *GrpcTimeout {
	s.PerRequest = v
	return s
}

// An object that represents the method and value to match with the header value
// sent in a request. Specify one match method.
type HeaderMatchMethod struct {
	_ struct{} `type:"structure"`

	// The value sent by the client must match the specified value exactly.
	Exact *string `locationName:"exact" min:"1" type:"string"`

	// The value sent by the client must begin with the specified characters.
	Prefix *string `locationName:"prefix" min:"1" type:"string"`

	// An object that represents the range of values to match on.
	Range *MatchRange `locationName:"range" type:"structure"`

	// The value sent by the client must include the specified characters.
	Regex *string `locationName:"regex" min:"1" type:"string"`

	// The value sent by the client must end with the specified characters.
	Suffix *string `locationName:"suffix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeaderMatchMethod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeaderMatchMethod) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeaderMatchMethod) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HeaderMatchMethod"}
	if s.Exact != nil && len(*s.Exact) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Exact", 1))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}
	if s.Regex != nil && len(*s.Regex) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Regex", 1))
	}
	if s.Suffix != nil && len(*s.Suffix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Suffix", 1))
	}
	if s.Range != nil {
		if err := s.Range.Validate(); err != nil {
			invalidParams.AddNested("Range", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExact sets the Exact field's value.
func (s *HeaderMatchMethod) SetExact(v string) *HeaderMatchMethod {
	s.Exact = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *HeaderMatchMethod) SetPrefix(v string) *HeaderMatchMethod {
	s.Prefix = &v
	return s
}

// SetRange sets the Range field's value.
func (s *HeaderMatchMethod) SetRange(v *MatchRange) *HeaderMatchMethod {
	s.Range = v
	return s
}

// SetRegex sets the Regex field's value.
func (s *HeaderMatchMethod) SetRegex(v string) *HeaderMatchMethod {
	s.Regex = &v
	return s
}

// SetSuffix sets the Suffix field's value.
func (s *HeaderMatchMethod) SetSuffix(v string) *HeaderMatchMethod {
	s.Suffix = &v
	return s
}

// An object that represents the health check policy for a virtual node's listener.
type HealthCheckPolicy struct {
	_ struct{} `type:"structure"`

	// The number of consecutive successful health checks that must occur before
	// declaring listener healthy.
	//
	// HealthyThreshold is a required field
	HealthyThreshold *int64 `locationName:"healthyThreshold" min:"2" type:"integer" required:"true"`

	// The time period in milliseconds between each health check execution.
	//
	// IntervalMillis is a required field
	IntervalMillis *int64 `locationName:"intervalMillis" min:"5000" type:"long" required:"true"`

	// The destination path for the health check request. This value is only used
	// if the specified protocol is HTTP or HTTP/2. For any other protocol, this
	// value is ignored.
	Path *string `locationName:"path" type:"string"`

	// The destination port for the health check request. This port must match the
	// port defined in the PortMapping for the listener.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The protocol for the health check request. If you specify grpc, then your
	// service must conform to the GRPC Health Checking Protocol (https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"PortProtocol"`

	// The amount of time to wait when receiving a response from the health check,
	// in milliseconds.
	//
	// TimeoutMillis is a required field
	TimeoutMillis *int64 `locationName:"timeoutMillis" min:"2000" type:"long" required:"true"`

	// The number of consecutive failed health checks that must occur before declaring
	// a virtual node unhealthy.
	//
	// UnhealthyThreshold is a required field
	UnhealthyThreshold *int64 `locationName:"unhealthyThreshold" min:"2" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HealthCheckPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HealthCheckPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheckPolicy"}
	if s.HealthyThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthyThreshold"))
	}
	if s.HealthyThreshold != nil && *s.HealthyThreshold < 2 {
		invalidParams.Add(request.NewErrParamMinValue("HealthyThreshold", 2))
	}
	if s.IntervalMillis == nil {
		invalidParams.Add(request.NewErrParamRequired("IntervalMillis"))
	}
	if s.IntervalMillis != nil && *s.IntervalMillis < 5000 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalMillis", 5000))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.TimeoutMillis == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeoutMillis"))
	}
	if s.TimeoutMillis != nil && *s.TimeoutMillis < 2000 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutMillis", 2000))
	}
	if s.UnhealthyThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("UnhealthyThreshold"))
	}
	if s.UnhealthyThreshold != nil && *s.UnhealthyThreshold < 2 {
		invalidParams.Add(request.NewErrParamMinValue("UnhealthyThreshold", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthyThreshold sets the HealthyThreshold field's value.
func (s *HealthCheckPolicy) SetHealthyThreshold(v int64) *HealthCheckPolicy {
	s.HealthyThreshold = &v
	return s
}

// SetIntervalMillis sets the IntervalMillis field's value.
func (s *HealthCheckPolicy) SetIntervalMillis(v int64) *HealthCheckPolicy {
	s.IntervalMillis = &v
	return s
}

// SetPath sets the Path field's value.
func (s *HealthCheckPolicy) SetPath(v string) *HealthCheckPolicy {
	s.Path = &v
	return s
}

// SetPort sets the Port field's value.
func (s *HealthCheckPolicy) SetPort(v int64) *HealthCheckPolicy {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *HealthCheckPolicy) SetProtocol(v string) *HealthCheckPolicy {
	s.Protocol = &v
	return s
}

// SetTimeoutMillis sets the TimeoutMillis field's value.
func (s *HealthCheckPolicy) SetTimeoutMillis(v int64) *HealthCheckPolicy {
	s.TimeoutMillis = &v
	return s
}

// SetUnhealthyThreshold sets the UnhealthyThreshold field's value.
func (s *HealthCheckPolicy) SetUnhealthyThreshold(v int64) *HealthCheckPolicy {
	s.UnhealthyThreshold = &v
	return s
}

// An object that represents an HTTP gateway route.
type HttpGatewayRoute struct {
	_ struct{} `type:"structure"`

	// An object that represents the action to take if a match is determined.
	//
	// Action is a required field
	Action *HttpGatewayRouteAction `locationName:"action" type:"structure" required:"true"`

	// An object that represents the criteria for determining a request match.
	//
	// Match is a required field
	Match *HttpGatewayRouteMatch `locationName:"match" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRoute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpGatewayRoute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpGatewayRoute"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Match == nil {
		invalidParams.Add(request.NewErrParamRequired("Match"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *HttpGatewayRoute) SetAction(v *HttpGatewayRouteAction) *HttpGatewayRoute {
	s.Action = v
	return s
}

// SetMatch sets the Match field's value.
func (s *HttpGatewayRoute) SetMatch(v *HttpGatewayRouteMatch) *HttpGatewayRoute {
	s.Match = v
	return s
}

// An object that represents the action to take if a match is determined.
type HttpGatewayRouteAction struct {
	_ struct{} `type:"structure"`

	// The gateway route action to rewrite.
	Rewrite *HttpGatewayRouteRewrite `locationName:"rewrite" type:"structure"`

	// An object that represents the target that traffic is routed to when a request
	// matches the gateway route.
	//
	// Target is a required field
	Target *GatewayRouteTarget `locationName:"target" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRouteAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRouteAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpGatewayRouteAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpGatewayRouteAction"}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Rewrite != nil {
		if err := s.Rewrite.Validate(); err != nil {
			invalidParams.AddNested("Rewrite", err.(request.ErrInvalidParams))
		}
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRewrite sets the Rewrite field's value.
func (s *HttpGatewayRouteAction) SetRewrite(v *HttpGatewayRouteRewrite) *HttpGatewayRouteAction {
	s.Rewrite = v
	return s
}

// SetTarget sets the Target field's value.
func (s *HttpGatewayRouteAction) SetTarget(v *GatewayRouteTarget) *HttpGatewayRouteAction {
	s.Target = v
	return s
}

// An object that represents the HTTP header in the gateway route.
type HttpGatewayRouteHeader struct {
	_ struct{} `type:"structure"`

	// Specify True to match anything except the match criteria. The default value
	// is False.
	Invert *bool `locationName:"invert" type:"boolean"`

	// An object that represents the method and value to match with the header value
	// sent in a request. Specify one match method.
	Match *HeaderMatchMethod `locationName:"match" type:"structure"`

	// A name for the HTTP header in the gateway route that will be matched on.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRouteHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRouteHeader) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpGatewayRouteHeader) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpGatewayRouteHeader"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvert sets the Invert field's value.
func (s *HttpGatewayRouteHeader) SetInvert(v bool) *HttpGatewayRouteHeader {
	s.Invert = &v
	return s
}

// SetMatch sets the Match field's value.
func (s *HttpGatewayRouteHeader) SetMatch(v *HeaderMatchMethod) *HttpGatewayRouteHeader {
	s.Match = v
	return s
}

// SetName sets the Name field's value.
func (s *HttpGatewayRouteHeader) SetName(v string) *HttpGatewayRouteHeader {
	s.Name = &v
	return s
}

// An object that represents the criteria for determining a request match.
type HttpGatewayRouteMatch struct {
	_ struct{} `type:"structure"`

	// The client request headers to match on.
	Headers []*HttpGatewayRouteHeader `locationName:"headers" min:"1" type:"list"`

	// The host name to match on.
	Hostname *GatewayRouteHostnameMatch `locationName:"hostname" type:"structure"`

	// The method to match on.
	Method *string `locationName:"method" type:"string" enum:"HttpMethod"`

	// The path to match on.
	Path *HttpPathMatch `locationName:"path" type:"structure"`

	// The port number to match on.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// Specifies the path to match requests with. This parameter must always start
	// with /, which by itself matches all requests to the virtual service name.
	// You can also match for path-based routing of requests. For example, if your
	// virtual service name is my-service.local and you want the route to match
	// requests to my-service.local/metrics, your prefix should be /metrics.
	Prefix *string `locationName:"prefix" type:"string"`

	// The query parameter to match on.
	QueryParameters []*HttpQueryParameter `locationName:"queryParameters" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRouteMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRouteMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpGatewayRouteMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpGatewayRouteMatch"}
	if s.Headers != nil && len(s.Headers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Headers", 1))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.QueryParameters != nil && len(s.QueryParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryParameters", 1))
	}
	if s.Headers != nil {
		for i, v := range s.Headers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Headers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Hostname != nil {
		if err := s.Hostname.Validate(); err != nil {
			invalidParams.AddNested("Hostname", err.(request.ErrInvalidParams))
		}
	}
	if s.Path != nil {
		if err := s.Path.Validate(); err != nil {
			invalidParams.AddNested("Path", err.(request.ErrInvalidParams))
		}
	}
	if s.QueryParameters != nil {
		for i, v := range s.QueryParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QueryParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeaders sets the Headers field's value.
func (s *HttpGatewayRouteMatch) SetHeaders(v []*HttpGatewayRouteHeader) *HttpGatewayRouteMatch {
	s.Headers = v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *HttpGatewayRouteMatch) SetHostname(v *GatewayRouteHostnameMatch) *HttpGatewayRouteMatch {
	s.Hostname = v
	return s
}

// SetMethod sets the Method field's value.
func (s *HttpGatewayRouteMatch) SetMethod(v string) *HttpGatewayRouteMatch {
	s.Method = &v
	return s
}

// SetPath sets the Path field's value.
func (s *HttpGatewayRouteMatch) SetPath(v *HttpPathMatch) *HttpGatewayRouteMatch {
	s.Path = v
	return s
}

// SetPort sets the Port field's value.
func (s *HttpGatewayRouteMatch) SetPort(v int64) *HttpGatewayRouteMatch {
	s.Port = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *HttpGatewayRouteMatch) SetPrefix(v string) *HttpGatewayRouteMatch {
	s.Prefix = &v
	return s
}

// SetQueryParameters sets the QueryParameters field's value.
func (s *HttpGatewayRouteMatch) SetQueryParameters(v []*HttpQueryParameter) *HttpGatewayRouteMatch {
	s.QueryParameters = v
	return s
}

// An object that represents the path to rewrite.
type HttpGatewayRoutePathRewrite struct {
	_ struct{} `type:"structure"`

	// The exact path to rewrite.
	Exact *string `locationName:"exact" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRoutePathRewrite) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRoutePathRewrite) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpGatewayRoutePathRewrite) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpGatewayRoutePathRewrite"}
	if s.Exact != nil && len(*s.Exact) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Exact", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExact sets the Exact field's value.
func (s *HttpGatewayRoutePathRewrite) SetExact(v string) *HttpGatewayRoutePathRewrite {
	s.Exact = &v
	return s
}

// An object representing the beginning characters of the route to rewrite.
type HttpGatewayRoutePrefixRewrite struct {
	_ struct{} `type:"structure"`

	// The default prefix used to replace the incoming route prefix when rewritten.
	DefaultPrefix *string `locationName:"defaultPrefix" type:"string" enum:"DefaultGatewayRouteRewrite"`

	// The value used to replace the incoming route prefix when rewritten.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRoutePrefixRewrite) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRoutePrefixRewrite) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpGatewayRoutePrefixRewrite) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpGatewayRoutePrefixRewrite"}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultPrefix sets the DefaultPrefix field's value.
func (s *HttpGatewayRoutePrefixRewrite) SetDefaultPrefix(v string) *HttpGatewayRoutePrefixRewrite {
	s.DefaultPrefix = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HttpGatewayRoutePrefixRewrite) SetValue(v string) *HttpGatewayRoutePrefixRewrite {
	s.Value = &v
	return s
}

// An object representing the gateway route to rewrite.
type HttpGatewayRouteRewrite struct {
	_ struct{} `type:"structure"`

	// The host name to rewrite.
	Hostname *GatewayRouteHostnameRewrite `locationName:"hostname" type:"structure"`

	// The path to rewrite.
	Path *HttpGatewayRoutePathRewrite `locationName:"path" type:"structure"`

	// The specified beginning characters to rewrite.
	Prefix *HttpGatewayRoutePrefixRewrite `locationName:"prefix" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRouteRewrite) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpGatewayRouteRewrite) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpGatewayRouteRewrite) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpGatewayRouteRewrite"}
	if s.Path != nil {
		if err := s.Path.Validate(); err != nil {
			invalidParams.AddNested("Path", err.(request.ErrInvalidParams))
		}
	}
	if s.Prefix != nil {
		if err := s.Prefix.Validate(); err != nil {
			invalidParams.AddNested("Prefix", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostname sets the Hostname field's value.
func (s *HttpGatewayRouteRewrite) SetHostname(v *GatewayRouteHostnameRewrite) *HttpGatewayRouteRewrite {
	s.Hostname = v
	return s
}

// SetPath sets the Path field's value.
func (s *HttpGatewayRouteRewrite) SetPath(v *HttpGatewayRoutePathRewrite) *HttpGatewayRouteRewrite {
	s.Path = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *HttpGatewayRouteRewrite) SetPrefix(v *HttpGatewayRoutePrefixRewrite) *HttpGatewayRouteRewrite {
	s.Prefix = v
	return s
}

// An object representing the path to match in the request.
type HttpPathMatch struct {
	_ struct{} `type:"structure"`

	// The exact path to match on.
	Exact *string `locationName:"exact" min:"1" type:"string"`

	// The regex used to match the path.
	Regex *string `locationName:"regex" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpPathMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpPathMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpPathMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpPathMatch"}
	if s.Exact != nil && len(*s.Exact) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Exact", 1))
	}
	if s.Regex != nil && len(*s.Regex) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Regex", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExact sets the Exact field's value.
func (s *HttpPathMatch) SetExact(v string) *HttpPathMatch {
	s.Exact = &v
	return s
}

// SetRegex sets the Regex field's value.
func (s *HttpPathMatch) SetRegex(v string) *HttpPathMatch {
	s.Regex = &v
	return s
}

// An object that represents the query parameter in the request.
type HttpQueryParameter struct {
	_ struct{} `type:"structure"`

	// The query parameter to match on.
	Match *QueryParameterMatch `locationName:"match" type:"structure"`

	// A name for the query parameter that will be matched on.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpQueryParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpQueryParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpQueryParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpQueryParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMatch sets the Match field's value.
func (s *HttpQueryParameter) SetMatch(v *QueryParameterMatch) *HttpQueryParameter {
	s.Match = v
	return s
}

// SetName sets the Name field's value.
func (s *HttpQueryParameter) SetName(v string) *HttpQueryParameter {
	s.Name = &v
	return s
}

// An object that represents a retry policy. Specify at least one value for
// at least one of the types of RetryEvents, a value for maxRetries, and a value
// for perRetryTimeout. Both server-error and gateway-error under httpRetryEvents
// include the Envoy reset policy. For more information on the reset policy,
// see the Envoy documentation (https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-on).
type HttpRetryPolicy struct {
	_ struct{} `type:"structure"`

	// Specify at least one of the following values.
	//
	//    * server-error – HTTP status codes 500, 501, 502, 503, 504, 505, 506,
	//    507, 508, 510, and 511
	//
	//    * gateway-error – HTTP status codes 502, 503, and 504
	//
	//    * client-error – HTTP status code 409
	//
	//    * stream-error – Retry on refused stream
	HttpRetryEvents []*string `locationName:"httpRetryEvents" min:"1" type:"list"`

	// The maximum number of retry attempts.
	//
	// MaxRetries is a required field
	MaxRetries *int64 `locationName:"maxRetries" type:"long" required:"true"`

	// The timeout for each retry attempt.
	//
	// PerRetryTimeout is a required field
	PerRetryTimeout *Duration `locationName:"perRetryTimeout" type:"structure" required:"true"`

	// Specify a valid value. The event occurs before any processing of a request
	// has started and is encountered when the upstream is temporarily or permanently
	// unavailable.
	TcpRetryEvents []*string `locationName:"tcpRetryEvents" min:"1" type:"list" enum:"TcpRetryPolicyEvent"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpRetryPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpRetryPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRetryPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpRetryPolicy"}
	if s.HttpRetryEvents != nil && len(s.HttpRetryEvents) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpRetryEvents", 1))
	}
	if s.MaxRetries == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxRetries"))
	}
	if s.PerRetryTimeout == nil {
		invalidParams.Add(request.NewErrParamRequired("PerRetryTimeout"))
	}
	if s.TcpRetryEvents != nil && len(s.TcpRetryEvents) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TcpRetryEvents", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpRetryEvents sets the HttpRetryEvents field's value.
func (s *HttpRetryPolicy) SetHttpRetryEvents(v []*string) *HttpRetryPolicy {
	s.HttpRetryEvents = v
	return s
}

// SetMaxRetries sets the MaxRetries field's value.
func (s *HttpRetryPolicy) SetMaxRetries(v int64) *HttpRetryPolicy {
	s.MaxRetries = &v
	return s
}

// SetPerRetryTimeout sets the PerRetryTimeout field's value.
func (s *HttpRetryPolicy) SetPerRetryTimeout(v *Duration) *HttpRetryPolicy {
	s.PerRetryTimeout = v
	return s
}

// SetTcpRetryEvents sets the TcpRetryEvents field's value.
func (s *HttpRetryPolicy) SetTcpRetryEvents(v []*string) *HttpRetryPolicy {
	s.TcpRetryEvents = v
	return s
}

// An object that represents an HTTP or HTTP/2 route type.
type HttpRoute struct {
	_ struct{} `type:"structure"`

	// An object that represents the action to take if a match is determined.
	//
	// Action is a required field
	Action *HttpRouteAction `locationName:"action" type:"structure" required:"true"`

	// An object that represents the criteria for determining a request match.
	//
	// Match is a required field
	Match *HttpRouteMatch `locationName:"match" type:"structure" required:"true"`

	// An object that represents a retry policy.
	RetryPolicy *HttpRetryPolicy `locationName:"retryPolicy" type:"structure"`

	// An object that represents types of timeouts.
	Timeout *HttpTimeout `locationName:"timeout" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpRoute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRoute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpRoute"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Match == nil {
		invalidParams.Add(request.NewErrParamRequired("Match"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}
	if s.RetryPolicy != nil {
		if err := s.RetryPolicy.Validate(); err != nil {
			invalidParams.AddNested("RetryPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *HttpRoute) SetAction(v *HttpRouteAction) *HttpRoute {
	s.Action = v
	return s
}

// SetMatch sets the Match field's value.
func (s *HttpRoute) SetMatch(v *HttpRouteMatch) *HttpRoute {
	s.Match = v
	return s
}

// SetRetryPolicy sets the RetryPolicy field's value.
func (s *HttpRoute) SetRetryPolicy(v *HttpRetryPolicy) *HttpRoute {
	s.RetryPolicy = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *HttpRoute) SetTimeout(v *HttpTimeout) *HttpRoute {
	s.Timeout = v
	return s
}

// An object that represents the action to take if a match is determined.
type HttpRouteAction struct {
	_ struct{} `type:"structure"`

	// An object that represents the targets that traffic is routed to when a request
	// matches the route.
	//
	// WeightedTargets is a required field
	WeightedTargets []*WeightedTarget `locationName:"weightedTargets" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpRouteAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpRouteAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRouteAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpRouteAction"}
	if s.WeightedTargets == nil {
		invalidParams.Add(request.NewErrParamRequired("WeightedTargets"))
	}
	if s.WeightedTargets != nil && len(s.WeightedTargets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WeightedTargets", 1))
	}
	if s.WeightedTargets != nil {
		for i, v := range s.WeightedTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WeightedTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWeightedTargets sets the WeightedTargets field's value.
func (s *HttpRouteAction) SetWeightedTargets(v []*WeightedTarget) *HttpRouteAction {
	s.WeightedTargets = v
	return s
}

// An object that represents the HTTP header in the request.
type HttpRouteHeader struct {
	_ struct{} `type:"structure"`

	// Specify True to match anything except the match criteria. The default value
	// is False.
	Invert *bool `locationName:"invert" type:"boolean"`

	// The HeaderMatchMethod object.
	Match *HeaderMatchMethod `locationName:"match" type:"structure"`

	// A name for the HTTP header in the client request that will be matched on.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpRouteHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpRouteHeader) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRouteHeader) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpRouteHeader"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvert sets the Invert field's value.
func (s *HttpRouteHeader) SetInvert(v bool) *HttpRouteHeader {
	s.Invert = &v
	return s
}

// SetMatch sets the Match field's value.
func (s *HttpRouteHeader) SetMatch(v *HeaderMatchMethod) *HttpRouteHeader {
	s.Match = v
	return s
}

// SetName sets the Name field's value.
func (s *HttpRouteHeader) SetName(v string) *HttpRouteHeader {
	s.Name = &v
	return s
}

// An object that represents the requirements for a route to match HTTP requests
// for a virtual router.
type HttpRouteMatch struct {
	_ struct{} `type:"structure"`

	// The client request headers to match on.
	Headers []*HttpRouteHeader `locationName:"headers" min:"1" type:"list"`

	// The client request method to match on. Specify only one.
	Method *string `locationName:"method" type:"string" enum:"HttpMethod"`

	// The client request path to match on.
	Path *HttpPathMatch `locationName:"path" type:"structure"`

	// The port number to match on.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// Specifies the path to match requests with. This parameter must always start
	// with /, which by itself matches all requests to the virtual service name.
	// You can also match for path-based routing of requests. For example, if your
	// virtual service name is my-service.local and you want the route to match
	// requests to my-service.local/metrics, your prefix should be /metrics.
	Prefix *string `locationName:"prefix" type:"string"`

	// The client request query parameters to match on.
	QueryParameters []*HttpQueryParameter `locationName:"queryParameters" min:"1" type:"list"`

	// The client request scheme to match on. Specify only one. Applicable only
	// for HTTP2 routes.
	Scheme *string `locationName:"scheme" type:"string" enum:"HttpScheme"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpRouteMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpRouteMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRouteMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpRouteMatch"}
	if s.Headers != nil && len(s.Headers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Headers", 1))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.QueryParameters != nil && len(s.QueryParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryParameters", 1))
	}
	if s.Headers != nil {
		for i, v := range s.Headers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Headers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Path != nil {
		if err := s.Path.Validate(); err != nil {
			invalidParams.AddNested("Path", err.(request.ErrInvalidParams))
		}
	}
	if s.QueryParameters != nil {
		for i, v := range s.QueryParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QueryParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeaders sets the Headers field's value.
func (s *HttpRouteMatch) SetHeaders(v []*HttpRouteHeader) *HttpRouteMatch {
	s.Headers = v
	return s
}

// SetMethod sets the Method field's value.
func (s *HttpRouteMatch) SetMethod(v string) *HttpRouteMatch {
	s.Method = &v
	return s
}

// SetPath sets the Path field's value.
func (s *HttpRouteMatch) SetPath(v *HttpPathMatch) *HttpRouteMatch {
	s.Path = v
	return s
}

// SetPort sets the Port field's value.
func (s *HttpRouteMatch) SetPort(v int64) *HttpRouteMatch {
	s.Port = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *HttpRouteMatch) SetPrefix(v string) *HttpRouteMatch {
	s.Prefix = &v
	return s
}

// SetQueryParameters sets the QueryParameters field's value.
func (s *HttpRouteMatch) SetQueryParameters(v []*HttpQueryParameter) *HttpRouteMatch {
	s.QueryParameters = v
	return s
}

// SetScheme sets the Scheme field's value.
func (s *HttpRouteMatch) SetScheme(v string) *HttpRouteMatch {
	s.Scheme = &v
	return s
}

// An object that represents types of timeouts.
type HttpTimeout struct {
	_ struct{} `type:"structure"`

	// An object that represents an idle timeout. An idle timeout bounds the amount
	// of time that a connection may be idle. The default value is none.
	Idle *Duration `locationName:"idle" type:"structure"`

	// An object that represents a per request timeout. The default value is 15
	// seconds. If you set a higher timeout, then make sure that the higher value
	// is set for each App Mesh resource in a conversation. For example, if a virtual
	// node backend uses a virtual router provider to route to another virtual node,
	// then the timeout should be greater than 15 seconds for the source and destination
	// virtual node and the route.
	PerRequest *Duration `locationName:"perRequest" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpTimeout) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpTimeout) GoString() string {
	return s.String()
}

// SetIdle sets the Idle field's value.
func (s *HttpTimeout) SetIdle(v *Duration) *HttpTimeout {
	s.Idle = v
	return s
}

// SetPerRequest sets the PerRequest field's value.
func (s *HttpTimeout) SetPerRequest(v *Duration) *HttpTimeout {
	s.PerRequest = v
	return s
}

// The request processing has failed because of an unknown error, exception,
// or failure.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents the key value pairs for the JSON.
type JsonFormatRef struct {
	_ struct{} `type:"structure"`

	// The specified key for the JSON.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The specified value for the JSON.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JsonFormatRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JsonFormatRef) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JsonFormatRef) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JsonFormatRef"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *JsonFormatRef) SetKey(v string) *JsonFormatRef {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *JsonFormatRef) SetValue(v string) *JsonFormatRef {
	s.Value = &v
	return s
}

// You have exceeded a service limit for your account. For more information,
// see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html)
// in the App Mesh User Guide.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListGatewayRoutesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results returned by ListGatewayRoutes in paginated
	// output. When you use this parameter, ListGatewayRoutes returns only limit
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListGatewayRoutes
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListGatewayRoutes returns up to 100
	// results and a nextToken value if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The name of the service mesh to list gateway routes in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The nextToken value returned from a previous paginated ListGatewayRoutes
	// request where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the virtual gateway to list gateway routes in.
	//
	// VirtualGatewayName is a required field
	VirtualGatewayName *string `location:"uri" locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewayRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewayRoutesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewayRoutesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGatewayRoutesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.VirtualGatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualGatewayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListGatewayRoutesInput) SetLimit(v int64) *ListGatewayRoutesInput {
	s.Limit = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *ListGatewayRoutesInput) SetMeshName(v string) *ListGatewayRoutesInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *ListGatewayRoutesInput) SetMeshOwner(v string) *ListGatewayRoutesInput {
	s.MeshOwner = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewayRoutesInput) SetNextToken(v string) *ListGatewayRoutesInput {
	s.NextToken = &v
	return s
}

// SetVirtualGatewayName sets the VirtualGatewayName field's value.
func (s *ListGatewayRoutesInput) SetVirtualGatewayName(v string) *ListGatewayRoutesInput {
	s.VirtualGatewayName = &v
	return s
}

type ListGatewayRoutesOutput struct {
	_ struct{} `type:"structure"`

	// The list of existing gateway routes for the specified service mesh and virtual
	// gateway.
	//
	// GatewayRoutes is a required field
	GatewayRoutes []*GatewayRouteRef `locationName:"gatewayRoutes" type:"list" required:"true"`

	// The nextToken value to include in a future ListGatewayRoutes request. When
	// the results of a ListGatewayRoutes request exceed limit, you can use this
	// value to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewayRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewayRoutesOutput) GoString() string {
	return s.String()
}

// SetGatewayRoutes sets the GatewayRoutes field's value.
func (s *ListGatewayRoutesOutput) SetGatewayRoutes(v []*GatewayRouteRef) *ListGatewayRoutesOutput {
	s.GatewayRoutes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewayRoutesOutput) SetNextToken(v string) *ListGatewayRoutesOutput {
	s.NextToken = &v
	return s
}

type ListMeshesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results returned by ListMeshes in paginated output.
	// When you use this parameter, ListMeshes returns only limit results in a single
	// page along with a nextToken response element. You can see the remaining results
	// of the initial request by sending another ListMeshes request with the returned
	// nextToken value. This value can be between 1 and 100. If you don't use this
	// parameter, ListMeshes returns up to 100 results and a nextToken value if
	// applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListMeshes request
	// where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMeshesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMeshesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMeshesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMeshesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListMeshesInput) SetLimit(v int64) *ListMeshesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMeshesInput) SetNextToken(v string) *ListMeshesInput {
	s.NextToken = &v
	return s
}

type ListMeshesOutput struct {
	_ struct{} `type:"structure"`

	// The list of existing service meshes.
	//
	// Meshes is a required field
	Meshes []*MeshRef `locationName:"meshes" type:"list" required:"true"`

	// The nextToken value to include in a future ListMeshes request. When the results
	// of a ListMeshes request exceed limit, you can use this value to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMeshesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMeshesOutput) GoString() string {
	return s.String()
}

// SetMeshes sets the Meshes field's value.
func (s *ListMeshesOutput) SetMeshes(v []*MeshRef) *ListMeshesOutput {
	s.Meshes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMeshesOutput) SetNextToken(v string) *ListMeshesOutput {
	s.NextToken = &v
	return s
}

type ListRoutesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results returned by ListRoutes in paginated output.
	// When you use this parameter, ListRoutes returns only limit results in a single
	// page along with a nextToken response element. You can see the remaining results
	// of the initial request by sending another ListRoutes request with the returned
	// nextToken value. This value can be between 1 and 100. If you don't use this
	// parameter, ListRoutes returns up to 100 results and a nextToken value if
	// applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The name of the service mesh to list routes in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The nextToken value returned from a previous paginated ListRoutes request
	// where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the virtual router to list routes in.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoutesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRoutesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRoutesInput) SetLimit(v int64) *ListRoutesInput {
	s.Limit = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *ListRoutesInput) SetMeshName(v string) *ListRoutesInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *ListRoutesInput) SetMeshOwner(v string) *ListRoutesInput {
	s.MeshOwner = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutesInput) SetNextToken(v string) *ListRoutesInput {
	s.NextToken = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *ListRoutesInput) SetVirtualRouterName(v string) *ListRoutesInput {
	s.VirtualRouterName = &v
	return s
}

type ListRoutesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListRoutes request. When the results
	// of a ListRoutes request exceed limit, you can use this value to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing routes for the specified service mesh and virtual router.
	//
	// Routes is a required field
	Routes []*RouteRef `locationName:"routes" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutesOutput) SetNextToken(v string) *ListRoutesOutput {
	s.NextToken = &v
	return s
}

// SetRoutes sets the Routes field's value.
func (s *ListRoutesOutput) SetRoutes(v []*RouteRef) *ListRoutesOutput {
	s.Routes = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of tag results returned by ListTagsForResource in paginated
	// output. When this parameter is used, ListTagsForResource returns only limit
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListTagsForResource
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListTagsForResource returns up to 100
	// results and a nextToken value if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListTagsForResource
	// request where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the resource to list the tags
	// for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTagsForResourceInput) SetLimit(v int64) *ListTagsForResourceInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListTagsForResource request. When
	// the results of a ListTagsForResource request exceed limit, you can use this
	// value to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The tags for the resource.
	//
	// Tags is a required field
	Tags []*TagRef `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*TagRef) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListVirtualGatewaysInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results returned by ListVirtualGateways in paginated
	// output. When you use this parameter, ListVirtualGateways returns only limit
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListVirtualGateways
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListVirtualGateways returns up to 100
	// results and a nextToken value if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The name of the service mesh to list virtual gateways in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The nextToken value returned from a previous paginated ListVirtualGateways
	// request where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualGatewaysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVirtualGatewaysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVirtualGatewaysInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListVirtualGatewaysInput) SetLimit(v int64) *ListVirtualGatewaysInput {
	s.Limit = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *ListVirtualGatewaysInput) SetMeshName(v string) *ListVirtualGatewaysInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *ListVirtualGatewaysInput) SetMeshOwner(v string) *ListVirtualGatewaysInput {
	s.MeshOwner = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualGatewaysInput) SetNextToken(v string) *ListVirtualGatewaysInput {
	s.NextToken = &v
	return s
}

type ListVirtualGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListVirtualGateways request. When
	// the results of a ListVirtualGateways request exceed limit, you can use this
	// value to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing virtual gateways for the specified service mesh.
	//
	// VirtualGateways is a required field
	VirtualGateways []*VirtualGatewayRef `locationName:"virtualGateways" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualGatewaysOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualGatewaysOutput) SetNextToken(v string) *ListVirtualGatewaysOutput {
	s.NextToken = &v
	return s
}

// SetVirtualGateways sets the VirtualGateways field's value.
func (s *ListVirtualGatewaysOutput) SetVirtualGateways(v []*VirtualGatewayRef) *ListVirtualGatewaysOutput {
	s.VirtualGateways = v
	return s
}

type ListVirtualNodesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results returned by ListVirtualNodes in paginated output.
	// When you use this parameter, ListVirtualNodes returns only limit results
	// in a single page along with a nextToken response element. You can see the
	// remaining results of the initial request by sending another ListVirtualNodes
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListVirtualNodes returns up to 100
	// results and a nextToken value if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The name of the service mesh to list virtual nodes in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The nextToken value returned from a previous paginated ListVirtualNodes request
	// where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVirtualNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVirtualNodesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListVirtualNodesInput) SetLimit(v int64) *ListVirtualNodesInput {
	s.Limit = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *ListVirtualNodesInput) SetMeshName(v string) *ListVirtualNodesInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *ListVirtualNodesInput) SetMeshOwner(v string) *ListVirtualNodesInput {
	s.MeshOwner = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualNodesInput) SetNextToken(v string) *ListVirtualNodesInput {
	s.NextToken = &v
	return s
}

type ListVirtualNodesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListVirtualNodes request. When
	// the results of a ListVirtualNodes request exceed limit, you can use this
	// value to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing virtual nodes for the specified service mesh.
	//
	// VirtualNodes is a required field
	VirtualNodes []*VirtualNodeRef `locationName:"virtualNodes" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualNodesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualNodesOutput) SetNextToken(v string) *ListVirtualNodesOutput {
	s.NextToken = &v
	return s
}

// SetVirtualNodes sets the VirtualNodes field's value.
func (s *ListVirtualNodesOutput) SetVirtualNodes(v []*VirtualNodeRef) *ListVirtualNodesOutput {
	s.VirtualNodes = v
	return s
}

type ListVirtualRoutersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results returned by ListVirtualRouters in paginated
	// output. When you use this parameter, ListVirtualRouters returns only limit
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListVirtualRouters
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListVirtualRouters returns up to 100
	// results and a nextToken value if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The name of the service mesh to list virtual routers in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The nextToken value returned from a previous paginated ListVirtualRouters
	// request where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualRoutersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualRoutersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVirtualRoutersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVirtualRoutersInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListVirtualRoutersInput) SetLimit(v int64) *ListVirtualRoutersInput {
	s.Limit = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *ListVirtualRoutersInput) SetMeshName(v string) *ListVirtualRoutersInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *ListVirtualRoutersInput) SetMeshOwner(v string) *ListVirtualRoutersInput {
	s.MeshOwner = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualRoutersInput) SetNextToken(v string) *ListVirtualRoutersInput {
	s.NextToken = &v
	return s
}

type ListVirtualRoutersOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListVirtualRouters request. When
	// the results of a ListVirtualRouters request exceed limit, you can use this
	// value to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing virtual routers for the specified service mesh.
	//
	// VirtualRouters is a required field
	VirtualRouters []*VirtualRouterRef `locationName:"virtualRouters" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualRoutersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualRoutersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualRoutersOutput) SetNextToken(v string) *ListVirtualRoutersOutput {
	s.NextToken = &v
	return s
}

// SetVirtualRouters sets the VirtualRouters field's value.
func (s *ListVirtualRoutersOutput) SetVirtualRouters(v []*VirtualRouterRef) *ListVirtualRoutersOutput {
	s.VirtualRouters = v
	return s
}

type ListVirtualServicesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results returned by ListVirtualServices in paginated
	// output. When you use this parameter, ListVirtualServices returns only limit
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListVirtualServices
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListVirtualServices returns up to 100
	// results and a nextToken value if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The name of the service mesh to list virtual services in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The nextToken value returned from a previous paginated ListVirtualServices
	// request where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualServicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVirtualServicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVirtualServicesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListVirtualServicesInput) SetLimit(v int64) *ListVirtualServicesInput {
	s.Limit = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *ListVirtualServicesInput) SetMeshName(v string) *ListVirtualServicesInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *ListVirtualServicesInput) SetMeshOwner(v string) *ListVirtualServicesInput {
	s.MeshOwner = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualServicesInput) SetNextToken(v string) *ListVirtualServicesInput {
	s.NextToken = &v
	return s
}

type ListVirtualServicesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListVirtualServices request. When
	// the results of a ListVirtualServices request exceed limit, you can use this
	// value to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing virtual services for the specified service mesh.
	//
	// VirtualServices is a required field
	VirtualServices []*VirtualServiceRef `locationName:"virtualServices" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualServicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualServicesOutput) SetNextToken(v string) *ListVirtualServicesOutput {
	s.NextToken = &v
	return s
}

// SetVirtualServices sets the VirtualServices field's value.
func (s *ListVirtualServicesOutput) SetVirtualServices(v []*VirtualServiceRef) *ListVirtualServicesOutput {
	s.VirtualServices = v
	return s
}

// An object that represents a listener for a virtual node.
type Listener struct {
	_ struct{} `type:"structure"`

	// The connection pool information for the listener.
	ConnectionPool *VirtualNodeConnectionPool `locationName:"connectionPool" type:"structure"`

	// The health check information for the listener.
	HealthCheck *HealthCheckPolicy `locationName:"healthCheck" type:"structure"`

	// The outlier detection information for the listener.
	OutlierDetection *OutlierDetection `locationName:"outlierDetection" type:"structure"`

	// The port mapping information for the listener.
	//
	// PortMapping is a required field
	PortMapping *PortMapping `locationName:"portMapping" type:"structure" required:"true"`

	// An object that represents timeouts for different protocols.
	Timeout *ListenerTimeout `locationName:"timeout" type:"structure"`

	// A reference to an object that represents the Transport Layer Security (TLS)
	// properties for a listener.
	Tls *ListenerTls `locationName:"tls" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Listener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Listener) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Listener) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Listener"}
	if s.PortMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("PortMapping"))
	}
	if s.ConnectionPool != nil {
		if err := s.ConnectionPool.Validate(); err != nil {
			invalidParams.AddNested("ConnectionPool", err.(request.ErrInvalidParams))
		}
	}
	if s.HealthCheck != nil {
		if err := s.HealthCheck.Validate(); err != nil {
			invalidParams.AddNested("HealthCheck", err.(request.ErrInvalidParams))
		}
	}
	if s.OutlierDetection != nil {
		if err := s.OutlierDetection.Validate(); err != nil {
			invalidParams.AddNested("OutlierDetection", err.(request.ErrInvalidParams))
		}
	}
	if s.PortMapping != nil {
		if err := s.PortMapping.Validate(); err != nil {
			invalidParams.AddNested("PortMapping", err.(request.ErrInvalidParams))
		}
	}
	if s.Tls != nil {
		if err := s.Tls.Validate(); err != nil {
			invalidParams.AddNested("Tls", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionPool sets the ConnectionPool field's value.
func (s *Listener) SetConnectionPool(v *VirtualNodeConnectionPool) *Listener {
	s.ConnectionPool = v
	return s
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *Listener) SetHealthCheck(v *HealthCheckPolicy) *Listener {
	s.HealthCheck = v
	return s
}

// SetOutlierDetection sets the OutlierDetection field's value.
func (s *Listener) SetOutlierDetection(v *OutlierDetection) *Listener {
	s.OutlierDetection = v
	return s
}

// SetPortMapping sets the PortMapping field's value.
func (s *Listener) SetPortMapping(v *PortMapping) *Listener {
	s.PortMapping = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *Listener) SetTimeout(v *ListenerTimeout) *Listener {
	s.Timeout = v
	return s
}

// SetTls sets the Tls field's value.
func (s *Listener) SetTls(v *ListenerTls) *Listener {
	s.Tls = v
	return s
}

// An object that represents timeouts for different protocols.
type ListenerTimeout struct {
	_ struct{} `type:"structure"`

	// An object that represents types of timeouts.
	Grpc *GrpcTimeout `locationName:"grpc" type:"structure"`

	// An object that represents types of timeouts.
	Http *HttpTimeout `locationName:"http" type:"structure"`

	// An object that represents types of timeouts.
	Http2 *HttpTimeout `locationName:"http2" type:"structure"`

	// An object that represents types of timeouts.
	Tcp *TcpTimeout `locationName:"tcp" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTimeout) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTimeout) GoString() string {
	return s.String()
}

// SetGrpc sets the Grpc field's value.
func (s *ListenerTimeout) SetGrpc(v *GrpcTimeout) *ListenerTimeout {
	s.Grpc = v
	return s
}

// SetHttp sets the Http field's value.
func (s *ListenerTimeout) SetHttp(v *HttpTimeout) *ListenerTimeout {
	s.Http = v
	return s
}

// SetHttp2 sets the Http2 field's value.
func (s *ListenerTimeout) SetHttp2(v *HttpTimeout) *ListenerTimeout {
	s.Http2 = v
	return s
}

// SetTcp sets the Tcp field's value.
func (s *ListenerTimeout) SetTcp(v *TcpTimeout) *ListenerTimeout {
	s.Tcp = v
	return s
}

// An object that represents the Transport Layer Security (TLS) properties for
// a listener.
type ListenerTls struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents a listener's Transport Layer Security
	// (TLS) certificate.
	//
	// Certificate is a required field
	Certificate *ListenerTlsCertificate `locationName:"certificate" type:"structure" required:"true"`

	// Specify one of the following modes.
	//
	//    * STRICT – Listener only accepts connections with TLS enabled.
	//
	//    * PERMISSIVE – Listener accepts connections with or without TLS enabled.
	//
	//    * DISABLED – Listener only accepts connections without TLS.
	//
	// Mode is a required field
	Mode *string `locationName:"mode" type:"string" required:"true" enum:"ListenerTlsMode"`

	// A reference to an object that represents a listener's Transport Layer Security
	// (TLS) validation context.
	Validation *ListenerTlsValidationContext `locationName:"validation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTls) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTls) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListenerTls) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListenerTls"}
	if s.Certificate == nil {
		invalidParams.Add(request.NewErrParamRequired("Certificate"))
	}
	if s.Mode == nil {
		invalidParams.Add(request.NewErrParamRequired("Mode"))
	}
	if s.Certificate != nil {
		if err := s.Certificate.Validate(); err != nil {
			invalidParams.AddNested("Certificate", err.(request.ErrInvalidParams))
		}
	}
	if s.Validation != nil {
		if err := s.Validation.Validate(); err != nil {
			invalidParams.AddNested("Validation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *ListenerTls) SetCertificate(v *ListenerTlsCertificate) *ListenerTls {
	s.Certificate = v
	return s
}

// SetMode sets the Mode field's value.
func (s *ListenerTls) SetMode(v string) *ListenerTls {
	s.Mode = &v
	return s
}

// SetValidation sets the Validation field's value.
func (s *ListenerTls) SetValidation(v *ListenerTlsValidationContext) *ListenerTls {
	s.Validation = v
	return s
}

// An object that represents an Certificate Manager certificate.
type ListenerTlsAcmCertificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate. The certificate must
	// meet specific requirements and you must have proxy authorization enabled.
	// For more information, see Transport Layer Security (TLS) (https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites).
	//
	// CertificateArn is a required field
	CertificateArn *string `locationName:"certificateArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTlsAcmCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTlsAcmCertificate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListenerTlsAcmCertificate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListenerTlsAcmCertificate"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *ListenerTlsAcmCertificate) SetCertificateArn(v string) *ListenerTlsAcmCertificate {
	s.CertificateArn = &v
	return s
}

// An object that represents a listener's Transport Layer Security (TLS) certificate.
type ListenerTlsCertificate struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents an Certificate Manager certificate.
	Acm *ListenerTlsAcmCertificate `locationName:"acm" type:"structure"`

	// A reference to an object that represents a local file certificate.
	File *ListenerTlsFileCertificate `locationName:"file" type:"structure"`

	// A reference to an object that represents a listener's Secret Discovery Service
	// certificate.
	Sds *ListenerTlsSdsCertificate `locationName:"sds" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTlsCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTlsCertificate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListenerTlsCertificate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListenerTlsCertificate"}
	if s.Acm != nil {
		if err := s.Acm.Validate(); err != nil {
			invalidParams.AddNested("Acm", err.(request.ErrInvalidParams))
		}
	}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}
	if s.Sds != nil {
		if err := s.Sds.Validate(); err != nil {
			invalidParams.AddNested("Sds", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcm sets the Acm field's value.
func (s *ListenerTlsCertificate) SetAcm(v *ListenerTlsAcmCertificate) *ListenerTlsCertificate {
	s.Acm = v
	return s
}

// SetFile sets the File field's value.
func (s *ListenerTlsCertificate) SetFile(v *ListenerTlsFileCertificate) *ListenerTlsCertificate {
	s.File = v
	return s
}

// SetSds sets the Sds field's value.
func (s *ListenerTlsCertificate) SetSds(v *ListenerTlsSdsCertificate) *ListenerTlsCertificate {
	s.Sds = v
	return s
}

// An object that represents a local file certificate. The certificate must
// meet specific requirements and you must have proxy authorization enabled.
// For more information, see Transport Layer Security (TLS) (https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites).
type ListenerTlsFileCertificate struct {
	_ struct{} `type:"structure"`

	// The certificate chain for the certificate.
	//
	// CertificateChain is a required field
	CertificateChain *string `locationName:"certificateChain" min:"1" type:"string" required:"true"`

	// The private key for a certificate stored on the file system of the virtual
	// node that the proxy is running on.
	//
	// PrivateKey is a required field
	PrivateKey *string `locationName:"privateKey" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTlsFileCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTlsFileCertificate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListenerTlsFileCertificate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListenerTlsFileCertificate"}
	if s.CertificateChain == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateChain"))
	}
	if s.CertificateChain != nil && len(*s.CertificateChain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateChain", 1))
	}
	if s.PrivateKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateKey"))
	}
	if s.PrivateKey != nil && len(*s.PrivateKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrivateKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *ListenerTlsFileCertificate) SetCertificateChain(v string) *ListenerTlsFileCertificate {
	s.CertificateChain = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *ListenerTlsFileCertificate) SetPrivateKey(v string) *ListenerTlsFileCertificate {
	s.PrivateKey = &v
	return s
}

// An object that represents the listener's Secret Discovery Service certificate.
// The proxy must be configured with a local SDS provider via a Unix Domain
// Socket. See App Mesh TLS documentation (https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html)
// for more info.
type ListenerTlsSdsCertificate struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents the name of the secret requested
	// from the Secret Discovery Service provider representing Transport Layer Security
	// (TLS) materials like a certificate or certificate chain.
	//
	// SecretName is a required field
	SecretName *string `locationName:"secretName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTlsSdsCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTlsSdsCertificate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListenerTlsSdsCertificate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListenerTlsSdsCertificate"}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretName sets the SecretName field's value.
func (s *ListenerTlsSdsCertificate) SetSecretName(v string) *ListenerTlsSdsCertificate {
	s.SecretName = &v
	return s
}

// An object that represents a listener's Transport Layer Security (TLS) validation
// context.
type ListenerTlsValidationContext struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents the SANs for a listener's Transport
	// Layer Security (TLS) validation context.
	SubjectAlternativeNames *SubjectAlternativeNames `locationName:"subjectAlternativeNames" type:"structure"`

	// A reference to where to retrieve the trust chain when validating a peer’s
	// Transport Layer Security (TLS) certificate.
	//
	// Trust is a required field
	Trust *ListenerTlsValidationContextTrust `locationName:"trust" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTlsValidationContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTlsValidationContext) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListenerTlsValidationContext) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListenerTlsValidationContext"}
	if s.Trust == nil {
		invalidParams.Add(request.NewErrParamRequired("Trust"))
	}
	if s.SubjectAlternativeNames != nil {
		if err := s.SubjectAlternativeNames.Validate(); err != nil {
			invalidParams.AddNested("SubjectAlternativeNames", err.(request.ErrInvalidParams))
		}
	}
	if s.Trust != nil {
		if err := s.Trust.Validate(); err != nil {
			invalidParams.AddNested("Trust", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubjectAlternativeNames sets the SubjectAlternativeNames field's value.
func (s *ListenerTlsValidationContext) SetSubjectAlternativeNames(v *SubjectAlternativeNames) *ListenerTlsValidationContext {
	s.SubjectAlternativeNames = v
	return s
}

// SetTrust sets the Trust field's value.
func (s *ListenerTlsValidationContext) SetTrust(v *ListenerTlsValidationContextTrust) *ListenerTlsValidationContext {
	s.Trust = v
	return s
}

// An object that represents a listener's Transport Layer Security (TLS) validation
// context trust.
type ListenerTlsValidationContextTrust struct {
	_ struct{} `type:"structure"`

	// An object that represents a Transport Layer Security (TLS) validation context
	// trust for a local file.
	File *TlsValidationContextFileTrust `locationName:"file" type:"structure"`

	// A reference to an object that represents a listener's Transport Layer Security
	// (TLS) Secret Discovery Service validation context trust.
	Sds *TlsValidationContextSdsTrust `locationName:"sds" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTlsValidationContextTrust) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerTlsValidationContextTrust) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListenerTlsValidationContextTrust) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListenerTlsValidationContextTrust"}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}
	if s.Sds != nil {
		if err := s.Sds.Validate(); err != nil {
			invalidParams.AddNested("Sds", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *ListenerTlsValidationContextTrust) SetFile(v *TlsValidationContextFileTrust) *ListenerTlsValidationContextTrust {
	s.File = v
	return s
}

// SetSds sets the Sds field's value.
func (s *ListenerTlsValidationContextTrust) SetSds(v *TlsValidationContextSdsTrust) *ListenerTlsValidationContextTrust {
	s.Sds = v
	return s
}

// An object that represents the logging information for a virtual node.
type Logging struct {
	_ struct{} `type:"structure"`

	// The access log configuration for a virtual node.
	AccessLog *AccessLog `locationName:"accessLog" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Logging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Logging) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Logging) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Logging"}
	if s.AccessLog != nil {
		if err := s.AccessLog.Validate(); err != nil {
			invalidParams.AddNested("AccessLog", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessLog sets the AccessLog field's value.
func (s *Logging) SetAccessLog(v *AccessLog) *Logging {
	s.AccessLog = v
	return s
}

// An object that represents the format for the logs.
type LoggingFormat struct {
	_ struct{} `type:"structure"`

	Json []*JsonFormatRef `locationName:"json" type:"list"`

	Text *string `locationName:"text" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingFormat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingFormat) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingFormat) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingFormat"}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}
	if s.Json != nil {
		for i, v := range s.Json {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Json", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJson sets the Json field's value.
func (s *LoggingFormat) SetJson(v []*JsonFormatRef) *LoggingFormat {
	s.Json = v
	return s
}

// SetText sets the Text field's value.
func (s *LoggingFormat) SetText(v string) *LoggingFormat {
	s.Text = &v
	return s
}

// An object that represents the range of values to match on. The first character
// of the range is included in the range, though the last character is not.
// For example, if the range specified were 1-100, only values 1-99 would be
// matched.
type MatchRange struct {
	_ struct{} `type:"structure"`

	// The end of the range.
	//
	// End is a required field
	End *int64 `locationName:"end" type:"long" required:"true"`

	// The start of the range.
	//
	// Start is a required field
	Start *int64 `locationName:"start" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MatchRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MatchRange"}
	if s.End == nil {
		invalidParams.Add(request.NewErrParamRequired("End"))
	}
	if s.Start == nil {
		invalidParams.Add(request.NewErrParamRequired("Start"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnd sets the End field's value.
func (s *MatchRange) SetEnd(v int64) *MatchRange {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *MatchRange) SetStart(v int64) *MatchRange {
	s.Start = &v
	return s
}

// An object that represents a service mesh returned by a describe operation.
type MeshData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the service mesh.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The associated specification for the service mesh.
	//
	// Spec is a required field
	Spec *MeshSpec `locationName:"spec" type:"structure" required:"true"`

	// The status of the service mesh.
	//
	// Status is a required field
	Status *MeshStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeshData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeshData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *MeshData) SetMeshName(v string) *MeshData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *MeshData) SetMetadata(v *ResourceMetadata) *MeshData {
	s.Metadata = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *MeshData) SetSpec(v *MeshSpec) *MeshData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *MeshData) SetStatus(v *MeshStatus) *MeshData {
	s.Status = v
	return s
}

// An object that represents a service mesh returned by a list operation.
type MeshRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) of the service mesh.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" required:"true"`

	// The name of the service mesh.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// MeshOwner is a required field
	MeshOwner *string `locationName:"meshOwner" min:"12" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the resource owner. If the account
	// ID is not your own, then it's the ID of the mesh owner or of another account
	// that the mesh is shared with. For more information about mesh sharing, see
	// Working with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" min:"12" type:"string" required:"true"`

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// Version is a required field
	Version *int64 `locationName:"version" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeshRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeshRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *MeshRef) SetArn(v string) *MeshRef {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *MeshRef) SetCreatedAt(v time.Time) *MeshRef {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *MeshRef) SetLastUpdatedAt(v time.Time) *MeshRef {
	s.LastUpdatedAt = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *MeshRef) SetMeshName(v string) *MeshRef {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *MeshRef) SetMeshOwner(v string) *MeshRef {
	s.MeshOwner = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *MeshRef) SetResourceOwner(v string) *MeshRef {
	s.ResourceOwner = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *MeshRef) SetVersion(v int64) *MeshRef {
	s.Version = &v
	return s
}

// An object that represents the service discovery information for a service
// mesh.
type MeshServiceDiscovery struct {
	_ struct{} `type:"structure"`

	// The IP version to use to control traffic within the mesh.
	IpPreference *string `locationName:"ipPreference" type:"string" enum:"IpPreference"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeshServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeshServiceDiscovery) GoString() string {
	return s.String()
}

// SetIpPreference sets the IpPreference field's value.
func (s *MeshServiceDiscovery) SetIpPreference(v string) *MeshServiceDiscovery {
	s.IpPreference = &v
	return s
}

// An object that represents the specification of a service mesh.
type MeshSpec struct {
	_ struct{} `type:"structure"`

	// The egress filter rules for the service mesh.
	EgressFilter *EgressFilter `locationName:"egressFilter" type:"structure"`

	// An object that represents the service discovery information for a service
	// mesh.
	ServiceDiscovery *MeshServiceDiscovery `locationName:"serviceDiscovery" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeshSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeshSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MeshSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MeshSpec"}
	if s.EgressFilter != nil {
		if err := s.EgressFilter.Validate(); err != nil {
			invalidParams.AddNested("EgressFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEgressFilter sets the EgressFilter field's value.
func (s *MeshSpec) SetEgressFilter(v *EgressFilter) *MeshSpec {
	s.EgressFilter = v
	return s
}

// SetServiceDiscovery sets the ServiceDiscovery field's value.
func (s *MeshSpec) SetServiceDiscovery(v *MeshServiceDiscovery) *MeshSpec {
	s.ServiceDiscovery = v
	return s
}

// An object that represents the status of a service mesh.
type MeshStatus struct {
	_ struct{} `type:"structure"`

	// The current mesh status.
	Status *string `locationName:"status" type:"string" enum:"MeshStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeshStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeshStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *MeshStatus) SetStatus(v string) *MeshStatus {
	s.Status = &v
	return s
}

// The specified resource doesn't exist. Check your request syntax and try again.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents the outlier detection for a virtual node's listener.
type OutlierDetection struct {
	_ struct{} `type:"structure"`

	// The base amount of time for which a host is ejected.
	//
	// BaseEjectionDuration is a required field
	BaseEjectionDuration *Duration `locationName:"baseEjectionDuration" type:"structure" required:"true"`

	// The time interval between ejection sweep analysis.
	//
	// Interval is a required field
	Interval *Duration `locationName:"interval" type:"structure" required:"true"`

	// Maximum percentage of hosts in load balancing pool for upstream service that
	// can be ejected. Will eject at least one host regardless of the value.
	//
	// MaxEjectionPercent is a required field
	MaxEjectionPercent *int64 `locationName:"maxEjectionPercent" type:"integer" required:"true"`

	// Number of consecutive 5xx errors required for ejection.
	//
	// MaxServerErrors is a required field
	MaxServerErrors *int64 `locationName:"maxServerErrors" min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutlierDetection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutlierDetection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutlierDetection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutlierDetection"}
	if s.BaseEjectionDuration == nil {
		invalidParams.Add(request.NewErrParamRequired("BaseEjectionDuration"))
	}
	if s.Interval == nil {
		invalidParams.Add(request.NewErrParamRequired("Interval"))
	}
	if s.MaxEjectionPercent == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxEjectionPercent"))
	}
	if s.MaxServerErrors == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxServerErrors"))
	}
	if s.MaxServerErrors != nil && *s.MaxServerErrors < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxServerErrors", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseEjectionDuration sets the BaseEjectionDuration field's value.
func (s *OutlierDetection) SetBaseEjectionDuration(v *Duration) *OutlierDetection {
	s.BaseEjectionDuration = v
	return s
}

// SetInterval sets the Interval field's value.
func (s *OutlierDetection) SetInterval(v *Duration) *OutlierDetection {
	s.Interval = v
	return s
}

// SetMaxEjectionPercent sets the MaxEjectionPercent field's value.
func (s *OutlierDetection) SetMaxEjectionPercent(v int64) *OutlierDetection {
	s.MaxEjectionPercent = &v
	return s
}

// SetMaxServerErrors sets the MaxServerErrors field's value.
func (s *OutlierDetection) SetMaxServerErrors(v int64) *OutlierDetection {
	s.MaxServerErrors = &v
	return s
}

// An object that represents a port mapping.
type PortMapping struct {
	_ struct{} `type:"structure"`

	// The port used for the port mapping.
	//
	// Port is a required field
	Port *int64 `locationName:"port" min:"1" type:"integer" required:"true"`

	// The protocol used for the port mapping. Specify one protocol.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"PortProtocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortMapping"}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPort sets the Port field's value.
func (s *PortMapping) SetPort(v int64) *PortMapping {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *PortMapping) SetProtocol(v string) *PortMapping {
	s.Protocol = &v
	return s
}

// An object representing the query parameter to match.
type QueryParameterMatch struct {
	_ struct{} `type:"structure"`

	// The exact query parameter to match on.
	Exact *string `locationName:"exact" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryParameterMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryParameterMatch) GoString() string {
	return s.String()
}

// SetExact sets the Exact field's value.
func (s *QueryParameterMatch) SetExact(v string) *QueryParameterMatch {
	s.Exact = &v
	return s
}

// You can't delete the specified resource because it's in use or required by
// another resource.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents metadata for a resource.
type ResourceMetadata struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the resource.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// MeshOwner is a required field
	MeshOwner *string `locationName:"meshOwner" min:"12" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the resource owner. If the account
	// ID is not your own, then it's the ID of the mesh owner or of another account
	// that the mesh is shared with. For more information about mesh sharing, see
	// Working with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" min:"12" type:"string" required:"true"`

	// The unique identifier for the resource.
	//
	// Uid is a required field
	Uid *string `locationName:"uid" type:"string" required:"true"`

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// Version is a required field
	Version *int64 `locationName:"version" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceMetadata) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResourceMetadata) SetArn(v string) *ResourceMetadata {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ResourceMetadata) SetCreatedAt(v time.Time) *ResourceMetadata {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ResourceMetadata) SetLastUpdatedAt(v time.Time) *ResourceMetadata {
	s.LastUpdatedAt = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *ResourceMetadata) SetMeshOwner(v string) *ResourceMetadata {
	s.MeshOwner = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *ResourceMetadata) SetResourceOwner(v string) *ResourceMetadata {
	s.ResourceOwner = &v
	return s
}

// SetUid sets the Uid field's value.
func (s *ResourceMetadata) SetUid(v string) *ResourceMetadata {
	s.Uid = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ResourceMetadata) SetVersion(v int64) *ResourceMetadata {
	s.Version = &v
	return s
}

// An object that represents a route returned by a describe operation.
type RouteData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the route resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the route.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The name of the route.
	//
	// RouteName is a required field
	RouteName *string `locationName:"routeName" min:"1" type:"string" required:"true"`

	// The specifications of the route.
	//
	// Spec is a required field
	Spec *RouteSpec `locationName:"spec" type:"structure" required:"true"`

	// The status of the route.
	//
	// Status is a required field
	Status *RouteStatus `locationName:"status" type:"structure" required:"true"`

	// The virtual router that the route is associated with.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *RouteData) SetMeshName(v string) *RouteData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *RouteData) SetMetadata(v *ResourceMetadata) *RouteData {
	s.Metadata = v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *RouteData) SetRouteName(v string) *RouteData {
	s.RouteName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *RouteData) SetSpec(v *RouteSpec) *RouteData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *RouteData) SetStatus(v *RouteStatus) *RouteData {
	s.Status = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *RouteData) SetVirtualRouterName(v string) *RouteData {
	s.VirtualRouterName = &v
	return s
}

// An object that represents a route returned by a list operation.
type RouteRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the route.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" required:"true"`

	// The name of the service mesh that the route resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// MeshOwner is a required field
	MeshOwner *string `locationName:"meshOwner" min:"12" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the resource owner. If the account
	// ID is not your own, then it's the ID of the mesh owner or of another account
	// that the mesh is shared with. For more information about mesh sharing, see
	// Working with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" min:"12" type:"string" required:"true"`

	// The name of the route.
	//
	// RouteName is a required field
	RouteName *string `locationName:"routeName" min:"1" type:"string" required:"true"`

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// Version is a required field
	Version *int64 `locationName:"version" type:"long" required:"true"`

	// The virtual router that the route is associated with.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RouteRef) SetArn(v string) *RouteRef {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RouteRef) SetCreatedAt(v time.Time) *RouteRef {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *RouteRef) SetLastUpdatedAt(v time.Time) *RouteRef {
	s.LastUpdatedAt = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *RouteRef) SetMeshName(v string) *RouteRef {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *RouteRef) SetMeshOwner(v string) *RouteRef {
	s.MeshOwner = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *RouteRef) SetResourceOwner(v string) *RouteRef {
	s.ResourceOwner = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *RouteRef) SetRouteName(v string) *RouteRef {
	s.RouteName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *RouteRef) SetVersion(v int64) *RouteRef {
	s.Version = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *RouteRef) SetVirtualRouterName(v string) *RouteRef {
	s.VirtualRouterName = &v
	return s
}

// An object that represents a route specification. Specify one route type.
type RouteSpec struct {
	_ struct{} `type:"structure"`

	// An object that represents the specification of a gRPC route.
	GrpcRoute *GrpcRoute `locationName:"grpcRoute" type:"structure"`

	// An object that represents the specification of an HTTP/2 route.
	Http2Route *HttpRoute `locationName:"http2Route" type:"structure"`

	// An object that represents the specification of an HTTP route.
	HttpRoute *HttpRoute `locationName:"httpRoute" type:"structure"`

	// The priority for the route. Routes are matched based on the specified value,
	// where 0 is the highest priority.
	Priority *int64 `locationName:"priority" type:"integer"`

	// An object that represents the specification of a TCP route.
	TcpRoute *TcpRoute `locationName:"tcpRoute" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RouteSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RouteSpec"}
	if s.GrpcRoute != nil {
		if err := s.GrpcRoute.Validate(); err != nil {
			invalidParams.AddNested("GrpcRoute", err.(request.ErrInvalidParams))
		}
	}
	if s.Http2Route != nil {
		if err := s.Http2Route.Validate(); err != nil {
			invalidParams.AddNested("Http2Route", err.(request.ErrInvalidParams))
		}
	}
	if s.HttpRoute != nil {
		if err := s.HttpRoute.Validate(); err != nil {
			invalidParams.AddNested("HttpRoute", err.(request.ErrInvalidParams))
		}
	}
	if s.TcpRoute != nil {
		if err := s.TcpRoute.Validate(); err != nil {
			invalidParams.AddNested("TcpRoute", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrpcRoute sets the GrpcRoute field's value.
func (s *RouteSpec) SetGrpcRoute(v *GrpcRoute) *RouteSpec {
	s.GrpcRoute = v
	return s
}

// SetHttp2Route sets the Http2Route field's value.
func (s *RouteSpec) SetHttp2Route(v *HttpRoute) *RouteSpec {
	s.Http2Route = v
	return s
}

// SetHttpRoute sets the HttpRoute field's value.
func (s *RouteSpec) SetHttpRoute(v *HttpRoute) *RouteSpec {
	s.HttpRoute = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *RouteSpec) SetPriority(v int64) *RouteSpec {
	s.Priority = &v
	return s
}

// SetTcpRoute sets the TcpRoute field's value.
func (s *RouteSpec) SetTcpRoute(v *TcpRoute) *RouteSpec {
	s.TcpRoute = v
	return s
}

// An object that represents the current status of a route.
type RouteStatus struct {
	_ struct{} `type:"structure"`

	// The current status for the route.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RouteStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *RouteStatus) SetStatus(v string) *RouteStatus {
	s.Status = &v
	return s
}

// An object that represents the service discovery information for a virtual
// node.
type ServiceDiscovery struct {
	_ struct{} `type:"structure"`

	// Specifies any Cloud Map information for the virtual node.
	AwsCloudMap *AwsCloudMapServiceDiscovery `locationName:"awsCloudMap" type:"structure"`

	// Specifies the DNS information for the virtual node.
	Dns *DnsServiceDiscovery `locationName:"dns" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceDiscovery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceDiscovery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceDiscovery"}
	if s.AwsCloudMap != nil {
		if err := s.AwsCloudMap.Validate(); err != nil {
			invalidParams.AddNested("AwsCloudMap", err.(request.ErrInvalidParams))
		}
	}
	if s.Dns != nil {
		if err := s.Dns.Validate(); err != nil {
			invalidParams.AddNested("Dns", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsCloudMap sets the AwsCloudMap field's value.
func (s *ServiceDiscovery) SetAwsCloudMap(v *AwsCloudMapServiceDiscovery) *ServiceDiscovery {
	s.AwsCloudMap = v
	return s
}

// SetDns sets the Dns field's value.
func (s *ServiceDiscovery) SetDns(v *DnsServiceDiscovery) *ServiceDiscovery {
	s.Dns = v
	return s
}

// The request has failed due to a temporary failure of the service.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents the methods by which a subject alternative name
// on a peer Transport Layer Security (TLS) certificate can be matched.
type SubjectAlternativeNameMatchers struct {
	_ struct{} `type:"structure"`

	// The values sent must match the specified values exactly.
	//
	// Exact is a required field
	Exact []*string `locationName:"exact" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectAlternativeNameMatchers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectAlternativeNameMatchers) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubjectAlternativeNameMatchers) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubjectAlternativeNameMatchers"}
	if s.Exact == nil {
		invalidParams.Add(request.NewErrParamRequired("Exact"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExact sets the Exact field's value.
func (s *SubjectAlternativeNameMatchers) SetExact(v []*string) *SubjectAlternativeNameMatchers {
	s.Exact = v
	return s
}

// An object that represents the subject alternative names secured by the certificate.
type SubjectAlternativeNames struct {
	_ struct{} `type:"structure"`

	// An object that represents the criteria for determining a SANs match.
	//
	// Match is a required field
	Match *SubjectAlternativeNameMatchers `locationName:"match" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectAlternativeNames) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectAlternativeNames) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubjectAlternativeNames) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubjectAlternativeNames"}
	if s.Match == nil {
		invalidParams.Add(request.NewErrParamRequired("Match"))
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMatch sets the Match field's value.
func (s *SubjectAlternativeNames) SetMatch(v *SubjectAlternativeNameMatchers) *SubjectAlternativeNames {
	s.Match = v
	return s
}

// Optional metadata that you apply to a resource to assist with categorization
// and organization. Each tag consists of a key and an optional value, both
// of which you define. Tag keys can have a maximum character length of 128
// characters, and tag values can have a maximum length of 256 characters.
type TagRef struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that make up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagRef) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagRef) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagRef"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagRef) SetKey(v string) *TagRef {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagRef) SetValue(v string) *TagRef {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to add tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string" required:"true"`

	// The tags to add to the resource. A tag is an array of key-value pairs. Tag
	// keys can have a maximum character length of 128 characters, and tag values
	// can have a maximum length of 256 characters.
	//
	// Tags is a required field
	Tags []*TagRef `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*TagRef) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// An object that represents a TCP route type.
type TcpRoute struct {
	_ struct{} `type:"structure"`

	// The action to take if a match is determined.
	//
	// Action is a required field
	Action *TcpRouteAction `locationName:"action" type:"structure" required:"true"`

	// An object that represents the criteria for determining a request match.
	Match *TcpRouteMatch `locationName:"match" type:"structure"`

	// An object that represents types of timeouts.
	Timeout *TcpTimeout `locationName:"timeout" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TcpRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TcpRoute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TcpRoute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TcpRoute"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *TcpRoute) SetAction(v *TcpRouteAction) *TcpRoute {
	s.Action = v
	return s
}

// SetMatch sets the Match field's value.
func (s *TcpRoute) SetMatch(v *TcpRouteMatch) *TcpRoute {
	s.Match = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *TcpRoute) SetTimeout(v *TcpTimeout) *TcpRoute {
	s.Timeout = v
	return s
}

// An object that represents the action to take if a match is determined.
type TcpRouteAction struct {
	_ struct{} `type:"structure"`

	// An object that represents the targets that traffic is routed to when a request
	// matches the route.
	//
	// WeightedTargets is a required field
	WeightedTargets []*WeightedTarget `locationName:"weightedTargets" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TcpRouteAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TcpRouteAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TcpRouteAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TcpRouteAction"}
	if s.WeightedTargets == nil {
		invalidParams.Add(request.NewErrParamRequired("WeightedTargets"))
	}
	if s.WeightedTargets != nil && len(s.WeightedTargets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WeightedTargets", 1))
	}
	if s.WeightedTargets != nil {
		for i, v := range s.WeightedTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WeightedTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWeightedTargets sets the WeightedTargets field's value.
func (s *TcpRouteAction) SetWeightedTargets(v []*WeightedTarget) *TcpRouteAction {
	s.WeightedTargets = v
	return s
}

// An object representing the TCP route to match.
type TcpRouteMatch struct {
	_ struct{} `type:"structure"`

	// The port number to match on.
	Port *int64 `locationName:"port" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TcpRouteMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TcpRouteMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TcpRouteMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TcpRouteMatch"}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPort sets the Port field's value.
func (s *TcpRouteMatch) SetPort(v int64) *TcpRouteMatch {
	s.Port = &v
	return s
}

// An object that represents types of timeouts.
type TcpTimeout struct {
	_ struct{} `type:"structure"`

	// An object that represents an idle timeout. An idle timeout bounds the amount
	// of time that a connection may be idle. The default value is none.
	Idle *Duration `locationName:"idle" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TcpTimeout) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TcpTimeout) GoString() string {
	return s.String()
}

// SetIdle sets the Idle field's value.
func (s *TcpTimeout) SetIdle(v *Duration) *TcpTimeout {
	s.Idle = v
	return s
}

// An object that represents how the proxy will validate its peer during Transport
// Layer Security (TLS) negotiation.
type TlsValidationContext struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents the SANs for a Transport Layer Security
	// (TLS) validation context. If you don't specify SANs on the terminating mesh
	// endpoint, the Envoy proxy for that node doesn't verify the SAN on a peer
	// client certificate. If you don't specify SANs on the originating mesh endpoint,
	// the SAN on the certificate provided by the terminating endpoint must match
	// the mesh endpoint service discovery configuration. Since SPIRE vended certificates
	// have a SPIFFE ID as a name, you must set the SAN since the name doesn't match
	// the service discovery name.
	SubjectAlternativeNames *SubjectAlternativeNames `locationName:"subjectAlternativeNames" type:"structure"`

	// A reference to where to retrieve the trust chain when validating a peer’s
	// Transport Layer Security (TLS) certificate.
	//
	// Trust is a required field
	Trust *TlsValidationContextTrust `locationName:"trust" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TlsValidationContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TlsValidationContext) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TlsValidationContext) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TlsValidationContext"}
	if s.Trust == nil {
		invalidParams.Add(request.NewErrParamRequired("Trust"))
	}
	if s.SubjectAlternativeNames != nil {
		if err := s.SubjectAlternativeNames.Validate(); err != nil {
			invalidParams.AddNested("SubjectAlternativeNames", err.(request.ErrInvalidParams))
		}
	}
	if s.Trust != nil {
		if err := s.Trust.Validate(); err != nil {
			invalidParams.AddNested("Trust", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubjectAlternativeNames sets the SubjectAlternativeNames field's value.
func (s *TlsValidationContext) SetSubjectAlternativeNames(v *SubjectAlternativeNames) *TlsValidationContext {
	s.SubjectAlternativeNames = v
	return s
}

// SetTrust sets the Trust field's value.
func (s *TlsValidationContext) SetTrust(v *TlsValidationContextTrust) *TlsValidationContext {
	s.Trust = v
	return s
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust for an Certificate Manager certificate.
type TlsValidationContextAcmTrust struct {
	_ struct{} `type:"structure"`

	// One or more ACM Amazon Resource Name (ARN)s.
	//
	// CertificateAuthorityArns is a required field
	CertificateAuthorityArns []*string `locationName:"certificateAuthorityArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TlsValidationContextAcmTrust) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TlsValidationContextAcmTrust) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TlsValidationContextAcmTrust) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TlsValidationContextAcmTrust"}
	if s.CertificateAuthorityArns == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArns"))
	}
	if s.CertificateAuthorityArns != nil && len(s.CertificateAuthorityArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArns sets the CertificateAuthorityArns field's value.
func (s *TlsValidationContextAcmTrust) SetCertificateAuthorityArns(v []*string) *TlsValidationContextAcmTrust {
	s.CertificateAuthorityArns = v
	return s
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust for a local file.
type TlsValidationContextFileTrust struct {
	_ struct{} `type:"structure"`

	// The certificate trust chain for a certificate stored on the file system of
	// the virtual node that the proxy is running on.
	//
	// CertificateChain is a required field
	CertificateChain *string `locationName:"certificateChain" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TlsValidationContextFileTrust) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TlsValidationContextFileTrust) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TlsValidationContextFileTrust) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TlsValidationContextFileTrust"}
	if s.CertificateChain == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateChain"))
	}
	if s.CertificateChain != nil && len(*s.CertificateChain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateChain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *TlsValidationContextFileTrust) SetCertificateChain(v string) *TlsValidationContextFileTrust {
	s.CertificateChain = &v
	return s
}

// An object that represents a Transport Layer Security (TLS) Secret Discovery
// Service validation context trust. The proxy must be configured with a local
// SDS provider via a Unix Domain Socket. See App Mesh TLS documentation (https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html)
// for more info.
type TlsValidationContextSdsTrust struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents the name of the secret for a Transport
	// Layer Security (TLS) Secret Discovery Service validation context trust.
	//
	// SecretName is a required field
	SecretName *string `locationName:"secretName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TlsValidationContextSdsTrust) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TlsValidationContextSdsTrust) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TlsValidationContextSdsTrust) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TlsValidationContextSdsTrust"}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretName sets the SecretName field's value.
func (s *TlsValidationContextSdsTrust) SetSecretName(v string) *TlsValidationContextSdsTrust {
	s.SecretName = &v
	return s
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust.
type TlsValidationContextTrust struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents a Transport Layer Security (TLS)
	// validation context trust for an Certificate Manager certificate.
	Acm *TlsValidationContextAcmTrust `locationName:"acm" type:"structure"`

	// An object that represents a Transport Layer Security (TLS) validation context
	// trust for a local file.
	File *TlsValidationContextFileTrust `locationName:"file" type:"structure"`

	// A reference to an object that represents a Transport Layer Security (TLS)
	// Secret Discovery Service validation context trust.
	Sds *TlsValidationContextSdsTrust `locationName:"sds" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TlsValidationContextTrust) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TlsValidationContextTrust) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TlsValidationContextTrust) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TlsValidationContextTrust"}
	if s.Acm != nil {
		if err := s.Acm.Validate(); err != nil {
			invalidParams.AddNested("Acm", err.(request.ErrInvalidParams))
		}
	}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}
	if s.Sds != nil {
		if err := s.Sds.Validate(); err != nil {
			invalidParams.AddNested("Sds", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcm sets the Acm field's value.
func (s *TlsValidationContextTrust) SetAcm(v *TlsValidationContextAcmTrust) *TlsValidationContextTrust {
	s.Acm = v
	return s
}

// SetFile sets the File field's value.
func (s *TlsValidationContextTrust) SetFile(v *TlsValidationContextFileTrust) *TlsValidationContextTrust {
	s.File = v
	return s
}

// SetSds sets the Sds field's value.
func (s *TlsValidationContextTrust) SetSds(v *TlsValidationContextSdsTrust) *TlsValidationContextTrust {
	s.Sds = v
	return s
}

// The maximum request rate permitted by the App Mesh APIs has been exceeded
// for your account. For best results, use an increasing or variable sleep interval
// between requests.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request exceeds the maximum allowed number of tags allowed per resource.
// The current limit is 50 user tags per resource. You must reduce the number
// of tags in the request. None of the tags in this request were applied.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to delete tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string" required:"true"`

	// The keys of the tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateGatewayRouteInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the gateway route to update.
	//
	// GatewayRouteName is a required field
	GatewayRouteName *string `location:"uri" locationName:"gatewayRouteName" min:"1" type:"string" required:"true"`

	// The name of the service mesh that the gateway route resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The new gateway route specification to apply. This overwrites the existing
	// data.
	//
	// Spec is a required field
	Spec *GatewayRouteSpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual gateway that the gateway route is associated with.
	//
	// VirtualGatewayName is a required field
	VirtualGatewayName *string `location:"uri" locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewayRouteInput"}
	if s.GatewayRouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayRouteName"))
	}
	if s.GatewayRouteName != nil && len(*s.GatewayRouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayRouteName", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualGatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualGatewayName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateGatewayRouteInput) SetClientToken(v string) *UpdateGatewayRouteInput {
	s.ClientToken = &v
	return s
}

// SetGatewayRouteName sets the GatewayRouteName field's value.
func (s *UpdateGatewayRouteInput) SetGatewayRouteName(v string) *UpdateGatewayRouteInput {
	s.GatewayRouteName = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateGatewayRouteInput) SetMeshName(v string) *UpdateGatewayRouteInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *UpdateGatewayRouteInput) SetMeshOwner(v string) *UpdateGatewayRouteInput {
	s.MeshOwner = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateGatewayRouteInput) SetSpec(v *GatewayRouteSpec) *UpdateGatewayRouteInput {
	s.Spec = v
	return s
}

// SetVirtualGatewayName sets the VirtualGatewayName field's value.
func (s *UpdateGatewayRouteInput) SetVirtualGatewayName(v string) *UpdateGatewayRouteInput {
	s.VirtualGatewayName = &v
	return s
}

type UpdateGatewayRouteOutput struct {
	_ struct{} `type:"structure" payload:"GatewayRoute"`

	// A full description of the gateway route that was updated.
	//
	// GatewayRoute is a required field
	GatewayRoute *GatewayRouteData `locationName:"gatewayRoute" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayRouteOutput) GoString() string {
	return s.String()
}

// SetGatewayRoute sets the GatewayRoute field's value.
func (s *UpdateGatewayRouteOutput) SetGatewayRoute(v *GatewayRouteData) *UpdateGatewayRouteOutput {
	s.GatewayRoute = v
	return s
}

type UpdateMeshInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh to update.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The service mesh specification to apply.
	Spec *MeshSpec `locationName:"spec" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMeshInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMeshInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMeshInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMeshInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateMeshInput) SetClientToken(v string) *UpdateMeshInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateMeshInput) SetMeshName(v string) *UpdateMeshInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateMeshInput) SetSpec(v *MeshSpec) *UpdateMeshInput {
	s.Spec = v
	return s
}

type UpdateMeshOutput struct {
	_ struct{} `type:"structure" payload:"Mesh"`

	// An object that represents a service mesh returned by a describe operation.
	//
	// Mesh is a required field
	Mesh *MeshData `locationName:"mesh" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMeshOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMeshOutput) GoString() string {
	return s.String()
}

// SetMesh sets the Mesh field's value.
func (s *UpdateMeshOutput) SetMesh(v *MeshData) *UpdateMeshOutput {
	s.Mesh = v
	return s
}

type UpdateRouteInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh that the route resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The name of the route to update.
	//
	// RouteName is a required field
	RouteName *string `location:"uri" locationName:"routeName" min:"1" type:"string" required:"true"`

	// The new route specification to apply. This overwrites the existing data.
	//
	// Spec is a required field
	Spec *RouteSpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual router that the route is associated with.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRouteInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.RouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteName"))
	}
	if s.RouteName != nil && len(*s.RouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateRouteInput) SetClientToken(v string) *UpdateRouteInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateRouteInput) SetMeshName(v string) *UpdateRouteInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *UpdateRouteInput) SetMeshOwner(v string) *UpdateRouteInput {
	s.MeshOwner = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *UpdateRouteInput) SetRouteName(v string) *UpdateRouteInput {
	s.RouteName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateRouteInput) SetSpec(v *RouteSpec) *UpdateRouteInput {
	s.Spec = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *UpdateRouteInput) SetVirtualRouterName(v string) *UpdateRouteInput {
	s.VirtualRouterName = &v
	return s
}

type UpdateRouteOutput struct {
	_ struct{} `type:"structure" payload:"Route"`

	// A full description of the route that was updated.
	//
	// Route is a required field
	Route *RouteData `locationName:"route" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRouteOutput) GoString() string {
	return s.String()
}

// SetRoute sets the Route field's value.
func (s *UpdateRouteOutput) SetRoute(v *RouteData) *UpdateRouteOutput {
	s.Route = v
	return s
}

type UpdateVirtualGatewayInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh that the virtual gateway resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The new virtual gateway specification to apply. This overwrites the existing
	// data.
	//
	// Spec is a required field
	Spec *VirtualGatewaySpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual gateway to update.
	//
	// VirtualGatewayName is a required field
	VirtualGatewayName *string `location:"uri" locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVirtualGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVirtualGatewayInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualGatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualGatewayName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateVirtualGatewayInput) SetClientToken(v string) *UpdateVirtualGatewayInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateVirtualGatewayInput) SetMeshName(v string) *UpdateVirtualGatewayInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *UpdateVirtualGatewayInput) SetMeshOwner(v string) *UpdateVirtualGatewayInput {
	s.MeshOwner = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateVirtualGatewayInput) SetSpec(v *VirtualGatewaySpec) *UpdateVirtualGatewayInput {
	s.Spec = v
	return s
}

// SetVirtualGatewayName sets the VirtualGatewayName field's value.
func (s *UpdateVirtualGatewayInput) SetVirtualGatewayName(v string) *UpdateVirtualGatewayInput {
	s.VirtualGatewayName = &v
	return s
}

type UpdateVirtualGatewayOutput struct {
	_ struct{} `type:"structure" payload:"VirtualGateway"`

	// A full description of the virtual gateway that was updated.
	//
	// VirtualGateway is a required field
	VirtualGateway *VirtualGatewayData `locationName:"virtualGateway" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualGatewayOutput) GoString() string {
	return s.String()
}

// SetVirtualGateway sets the VirtualGateway field's value.
func (s *UpdateVirtualGatewayOutput) SetVirtualGateway(v *VirtualGatewayData) *UpdateVirtualGatewayOutput {
	s.VirtualGateway = v
	return s
}

type UpdateVirtualNodeInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh that the virtual node resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The new virtual node specification to apply. This overwrites the existing
	// data.
	//
	// Spec is a required field
	Spec *VirtualNodeSpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual node to update.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `location:"uri" locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVirtualNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVirtualNodeInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateVirtualNodeInput) SetClientToken(v string) *UpdateVirtualNodeInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateVirtualNodeInput) SetMeshName(v string) *UpdateVirtualNodeInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *UpdateVirtualNodeInput) SetMeshOwner(v string) *UpdateVirtualNodeInput {
	s.MeshOwner = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateVirtualNodeInput) SetSpec(v *VirtualNodeSpec) *UpdateVirtualNodeInput {
	s.Spec = v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *UpdateVirtualNodeInput) SetVirtualNodeName(v string) *UpdateVirtualNodeInput {
	s.VirtualNodeName = &v
	return s
}

type UpdateVirtualNodeOutput struct {
	_ struct{} `type:"structure" payload:"VirtualNode"`

	// A full description of the virtual node that was updated.
	//
	// VirtualNode is a required field
	VirtualNode *VirtualNodeData `locationName:"virtualNode" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualNodeOutput) GoString() string {
	return s.String()
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *UpdateVirtualNodeOutput) SetVirtualNode(v *VirtualNodeData) *UpdateVirtualNodeOutput {
	s.VirtualNode = v
	return s
}

type UpdateVirtualRouterInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh that the virtual router resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The new virtual router specification to apply. This overwrites the existing
	// data.
	//
	// Spec is a required field
	Spec *VirtualRouterSpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual router to update.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualRouterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVirtualRouterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVirtualRouterInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateVirtualRouterInput) SetClientToken(v string) *UpdateVirtualRouterInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateVirtualRouterInput) SetMeshName(v string) *UpdateVirtualRouterInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *UpdateVirtualRouterInput) SetMeshOwner(v string) *UpdateVirtualRouterInput {
	s.MeshOwner = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateVirtualRouterInput) SetSpec(v *VirtualRouterSpec) *UpdateVirtualRouterInput {
	s.Spec = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *UpdateVirtualRouterInput) SetVirtualRouterName(v string) *UpdateVirtualRouterInput {
	s.VirtualRouterName = &v
	return s
}

type UpdateVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// A full description of the virtual router that was updated.
	//
	// VirtualRouter is a required field
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualRouterOutput) GoString() string {
	return s.String()
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *UpdateVirtualRouterOutput) SetVirtualRouter(v *VirtualRouterData) *UpdateVirtualRouterOutput {
	s.VirtualRouter = v
	return s
}

type UpdateVirtualServiceInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh that the virtual service resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// The new virtual service specification to apply. This overwrites the existing
	// data.
	//
	// Spec is a required field
	Spec *VirtualServiceSpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual service to update.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `location:"uri" locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVirtualServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVirtualServiceInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MeshOwner", 12))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualServiceName"))
	}
	if s.VirtualServiceName != nil && len(*s.VirtualServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualServiceName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateVirtualServiceInput) SetClientToken(v string) *UpdateVirtualServiceInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateVirtualServiceInput) SetMeshName(v string) *UpdateVirtualServiceInput {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *UpdateVirtualServiceInput) SetMeshOwner(v string) *UpdateVirtualServiceInput {
	s.MeshOwner = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateVirtualServiceInput) SetSpec(v *VirtualServiceSpec) *UpdateVirtualServiceInput {
	s.Spec = v
	return s
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *UpdateVirtualServiceInput) SetVirtualServiceName(v string) *UpdateVirtualServiceInput {
	s.VirtualServiceName = &v
	return s
}

type UpdateVirtualServiceOutput struct {
	_ struct{} `type:"structure" payload:"VirtualService"`

	// A full description of the virtual service that was updated.
	//
	// VirtualService is a required field
	VirtualService *VirtualServiceData `locationName:"virtualService" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVirtualServiceOutput) GoString() string {
	return s.String()
}

// SetVirtualService sets the VirtualService field's value.
func (s *UpdateVirtualServiceOutput) SetVirtualService(v *VirtualServiceData) *UpdateVirtualServiceOutput {
	s.VirtualService = v
	return s
}

// The access log configuration for a virtual gateway.
type VirtualGatewayAccessLog struct {
	_ struct{} `type:"structure"`

	// The file object to send virtual gateway access logs to.
	File *VirtualGatewayFileAccessLog `locationName:"file" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayAccessLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayAccessLog) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayAccessLog) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayAccessLog"}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *VirtualGatewayAccessLog) SetFile(v *VirtualGatewayFileAccessLog) *VirtualGatewayAccessLog {
	s.File = v
	return s
}

// An object that represents the default properties for a backend.
type VirtualGatewayBackendDefaults struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents a client policy.
	ClientPolicy *VirtualGatewayClientPolicy `locationName:"clientPolicy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayBackendDefaults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayBackendDefaults) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayBackendDefaults) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayBackendDefaults"}
	if s.ClientPolicy != nil {
		if err := s.ClientPolicy.Validate(); err != nil {
			invalidParams.AddNested("ClientPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientPolicy sets the ClientPolicy field's value.
func (s *VirtualGatewayBackendDefaults) SetClientPolicy(v *VirtualGatewayClientPolicy) *VirtualGatewayBackendDefaults {
	s.ClientPolicy = v
	return s
}

// An object that represents a client policy.
type VirtualGatewayClientPolicy struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents a Transport Layer Security (TLS)
	// client policy.
	Tls *VirtualGatewayClientPolicyTls `locationName:"tls" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayClientPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayClientPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayClientPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayClientPolicy"}
	if s.Tls != nil {
		if err := s.Tls.Validate(); err != nil {
			invalidParams.AddNested("Tls", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTls sets the Tls field's value.
func (s *VirtualGatewayClientPolicy) SetTls(v *VirtualGatewayClientPolicyTls) *VirtualGatewayClientPolicy {
	s.Tls = v
	return s
}

// An object that represents a Transport Layer Security (TLS) client policy.
type VirtualGatewayClientPolicyTls struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents a virtual gateway's client's Transport
	// Layer Security (TLS) certificate.
	Certificate *VirtualGatewayClientTlsCertificate `locationName:"certificate" type:"structure"`

	// Whether the policy is enforced. The default is True, if a value isn't specified.
	Enforce *bool `locationName:"enforce" type:"boolean"`

	// One or more ports that the policy is enforced for.
	Ports []*int64 `locationName:"ports" type:"list"`

	// A reference to an object that represents a Transport Layer Security (TLS)
	// validation context.
	//
	// Validation is a required field
	Validation *VirtualGatewayTlsValidationContext `locationName:"validation" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayClientPolicyTls) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayClientPolicyTls) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayClientPolicyTls) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayClientPolicyTls"}
	if s.Validation == nil {
		invalidParams.Add(request.NewErrParamRequired("Validation"))
	}
	if s.Certificate != nil {
		if err := s.Certificate.Validate(); err != nil {
			invalidParams.AddNested("Certificate", err.(request.ErrInvalidParams))
		}
	}
	if s.Validation != nil {
		if err := s.Validation.Validate(); err != nil {
			invalidParams.AddNested("Validation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *VirtualGatewayClientPolicyTls) SetCertificate(v *VirtualGatewayClientTlsCertificate) *VirtualGatewayClientPolicyTls {
	s.Certificate = v
	return s
}

// SetEnforce sets the Enforce field's value.
func (s *VirtualGatewayClientPolicyTls) SetEnforce(v bool) *VirtualGatewayClientPolicyTls {
	s.Enforce = &v
	return s
}

// SetPorts sets the Ports field's value.
func (s *VirtualGatewayClientPolicyTls) SetPorts(v []*int64) *VirtualGatewayClientPolicyTls {
	s.Ports = v
	return s
}

// SetValidation sets the Validation field's value.
func (s *VirtualGatewayClientPolicyTls) SetValidation(v *VirtualGatewayTlsValidationContext) *VirtualGatewayClientPolicyTls {
	s.Validation = v
	return s
}

// An object that represents the virtual gateway's client's Transport Layer
// Security (TLS) certificate.
type VirtualGatewayClientTlsCertificate struct {
	_ struct{} `type:"structure"`

	// An object that represents a local file certificate. The certificate must
	// meet specific requirements and you must have proxy authorization enabled.
	// For more information, see Transport Layer Security (TLS) (https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html).
	File *VirtualGatewayListenerTlsFileCertificate `locationName:"file" type:"structure"`

	// A reference to an object that represents a virtual gateway's client's Secret
	// Discovery Service certificate.
	Sds *VirtualGatewayListenerTlsSdsCertificate `locationName:"sds" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayClientTlsCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayClientTlsCertificate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayClientTlsCertificate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayClientTlsCertificate"}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}
	if s.Sds != nil {
		if err := s.Sds.Validate(); err != nil {
			invalidParams.AddNested("Sds", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *VirtualGatewayClientTlsCertificate) SetFile(v *VirtualGatewayListenerTlsFileCertificate) *VirtualGatewayClientTlsCertificate {
	s.File = v
	return s
}

// SetSds sets the Sds field's value.
func (s *VirtualGatewayClientTlsCertificate) SetSds(v *VirtualGatewayListenerTlsSdsCertificate) *VirtualGatewayClientTlsCertificate {
	s.Sds = v
	return s
}

// An object that represents the type of virtual gateway connection pool.
//
// Only one protocol is used at a time and should be the same protocol as the
// one chosen under port mapping.
//
// If not present the default value for maxPendingRequests is 2147483647.
type VirtualGatewayConnectionPool struct {
	_ struct{} `type:"structure"`

	// An object that represents a type of connection pool.
	Grpc *VirtualGatewayGrpcConnectionPool `locationName:"grpc" type:"structure"`

	// An object that represents a type of connection pool.
	Http *VirtualGatewayHttpConnectionPool `locationName:"http" type:"structure"`

	// An object that represents a type of connection pool.
	Http2 *VirtualGatewayHttp2ConnectionPool `locationName:"http2" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayConnectionPool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayConnectionPool) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayConnectionPool) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayConnectionPool"}
	if s.Grpc != nil {
		if err := s.Grpc.Validate(); err != nil {
			invalidParams.AddNested("Grpc", err.(request.ErrInvalidParams))
		}
	}
	if s.Http != nil {
		if err := s.Http.Validate(); err != nil {
			invalidParams.AddNested("Http", err.(request.ErrInvalidParams))
		}
	}
	if s.Http2 != nil {
		if err := s.Http2.Validate(); err != nil {
			invalidParams.AddNested("Http2", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrpc sets the Grpc field's value.
func (s *VirtualGatewayConnectionPool) SetGrpc(v *VirtualGatewayGrpcConnectionPool) *VirtualGatewayConnectionPool {
	s.Grpc = v
	return s
}

// SetHttp sets the Http field's value.
func (s *VirtualGatewayConnectionPool) SetHttp(v *VirtualGatewayHttpConnectionPool) *VirtualGatewayConnectionPool {
	s.Http = v
	return s
}

// SetHttp2 sets the Http2 field's value.
func (s *VirtualGatewayConnectionPool) SetHttp2(v *VirtualGatewayHttp2ConnectionPool) *VirtualGatewayConnectionPool {
	s.Http2 = v
	return s
}

// An object that represents a virtual gateway returned by a describe operation.
type VirtualGatewayData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the virtual gateway resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// An object that represents metadata for a resource.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The specifications of the virtual gateway.
	//
	// Spec is a required field
	Spec *VirtualGatewaySpec `locationName:"spec" type:"structure" required:"true"`

	// The current status of the virtual gateway.
	//
	// Status is a required field
	Status *VirtualGatewayStatus `locationName:"status" type:"structure" required:"true"`

	// The name of the virtual gateway.
	//
	// VirtualGatewayName is a required field
	VirtualGatewayName *string `locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualGatewayData) SetMeshName(v string) *VirtualGatewayData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *VirtualGatewayData) SetMetadata(v *ResourceMetadata) *VirtualGatewayData {
	s.Metadata = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *VirtualGatewayData) SetSpec(v *VirtualGatewaySpec) *VirtualGatewayData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VirtualGatewayData) SetStatus(v *VirtualGatewayStatus) *VirtualGatewayData {
	s.Status = v
	return s
}

// SetVirtualGatewayName sets the VirtualGatewayName field's value.
func (s *VirtualGatewayData) SetVirtualGatewayName(v string) *VirtualGatewayData {
	s.VirtualGatewayName = &v
	return s
}

// An object that represents an access log file.
type VirtualGatewayFileAccessLog struct {
	_ struct{} `type:"structure"`

	// The specified format for the virtual gateway access logs. It can be either
	// json_format or text_format.
	Format *LoggingFormat `locationName:"format" type:"structure"`

	// The file path to write access logs to. You can use /dev/stdout to send access
	// logs to standard out and configure your Envoy container to use a log driver,
	// such as awslogs, to export the access logs to a log storage service such
	// as Amazon CloudWatch Logs. You can also specify a path in the Envoy container's
	// file system to write the files to disk.
	//
	// Path is a required field
	Path *string `locationName:"path" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayFileAccessLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayFileAccessLog) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayFileAccessLog) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayFileAccessLog"}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}
	if s.Format != nil {
		if err := s.Format.Validate(); err != nil {
			invalidParams.AddNested("Format", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFormat sets the Format field's value.
func (s *VirtualGatewayFileAccessLog) SetFormat(v *LoggingFormat) *VirtualGatewayFileAccessLog {
	s.Format = v
	return s
}

// SetPath sets the Path field's value.
func (s *VirtualGatewayFileAccessLog) SetPath(v string) *VirtualGatewayFileAccessLog {
	s.Path = &v
	return s
}

// An object that represents a type of connection pool.
type VirtualGatewayGrpcConnectionPool struct {
	_ struct{} `type:"structure"`

	// Maximum number of inflight requests Envoy can concurrently support across
	// hosts in upstream cluster.
	//
	// MaxRequests is a required field
	MaxRequests *int64 `locationName:"maxRequests" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayGrpcConnectionPool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayGrpcConnectionPool) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayGrpcConnectionPool) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayGrpcConnectionPool"}
	if s.MaxRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxRequests"))
	}
	if s.MaxRequests != nil && *s.MaxRequests < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxRequests sets the MaxRequests field's value.
func (s *VirtualGatewayGrpcConnectionPool) SetMaxRequests(v int64) *VirtualGatewayGrpcConnectionPool {
	s.MaxRequests = &v
	return s
}

// An object that represents the health check policy for a virtual gateway's
// listener.
type VirtualGatewayHealthCheckPolicy struct {
	_ struct{} `type:"structure"`

	// The number of consecutive successful health checks that must occur before
	// declaring the listener healthy.
	//
	// HealthyThreshold is a required field
	HealthyThreshold *int64 `locationName:"healthyThreshold" min:"2" type:"integer" required:"true"`

	// The time period in milliseconds between each health check execution.
	//
	// IntervalMillis is a required field
	IntervalMillis *int64 `locationName:"intervalMillis" min:"5000" type:"long" required:"true"`

	// The destination path for the health check request. This value is only used
	// if the specified protocol is HTTP or HTTP/2. For any other protocol, this
	// value is ignored.
	Path *string `locationName:"path" type:"string"`

	// The destination port for the health check request. This port must match the
	// port defined in the PortMapping for the listener.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The protocol for the health check request. If you specify grpc, then your
	// service must conform to the GRPC Health Checking Protocol (https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"VirtualGatewayPortProtocol"`

	// The amount of time to wait when receiving a response from the health check,
	// in milliseconds.
	//
	// TimeoutMillis is a required field
	TimeoutMillis *int64 `locationName:"timeoutMillis" min:"2000" type:"long" required:"true"`

	// The number of consecutive failed health checks that must occur before declaring
	// a virtual gateway unhealthy.
	//
	// UnhealthyThreshold is a required field
	UnhealthyThreshold *int64 `locationName:"unhealthyThreshold" min:"2" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayHealthCheckPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayHealthCheckPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayHealthCheckPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayHealthCheckPolicy"}
	if s.HealthyThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthyThreshold"))
	}
	if s.HealthyThreshold != nil && *s.HealthyThreshold < 2 {
		invalidParams.Add(request.NewErrParamMinValue("HealthyThreshold", 2))
	}
	if s.IntervalMillis == nil {
		invalidParams.Add(request.NewErrParamRequired("IntervalMillis"))
	}
	if s.IntervalMillis != nil && *s.IntervalMillis < 5000 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalMillis", 5000))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.TimeoutMillis == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeoutMillis"))
	}
	if s.TimeoutMillis != nil && *s.TimeoutMillis < 2000 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutMillis", 2000))
	}
	if s.UnhealthyThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("UnhealthyThreshold"))
	}
	if s.UnhealthyThreshold != nil && *s.UnhealthyThreshold < 2 {
		invalidParams.Add(request.NewErrParamMinValue("UnhealthyThreshold", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthyThreshold sets the HealthyThreshold field's value.
func (s *VirtualGatewayHealthCheckPolicy) SetHealthyThreshold(v int64) *VirtualGatewayHealthCheckPolicy {
	s.HealthyThreshold = &v
	return s
}

// SetIntervalMillis sets the IntervalMillis field's value.
func (s *VirtualGatewayHealthCheckPolicy) SetIntervalMillis(v int64) *VirtualGatewayHealthCheckPolicy {
	s.IntervalMillis = &v
	return s
}

// SetPath sets the Path field's value.
func (s *VirtualGatewayHealthCheckPolicy) SetPath(v string) *VirtualGatewayHealthCheckPolicy {
	s.Path = &v
	return s
}

// SetPort sets the Port field's value.
func (s *VirtualGatewayHealthCheckPolicy) SetPort(v int64) *VirtualGatewayHealthCheckPolicy {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *VirtualGatewayHealthCheckPolicy) SetProtocol(v string) *VirtualGatewayHealthCheckPolicy {
	s.Protocol = &v
	return s
}

// SetTimeoutMillis sets the TimeoutMillis field's value.
func (s *VirtualGatewayHealthCheckPolicy) SetTimeoutMillis(v int64) *VirtualGatewayHealthCheckPolicy {
	s.TimeoutMillis = &v
	return s
}

// SetUnhealthyThreshold sets the UnhealthyThreshold field's value.
func (s *VirtualGatewayHealthCheckPolicy) SetUnhealthyThreshold(v int64) *VirtualGatewayHealthCheckPolicy {
	s.UnhealthyThreshold = &v
	return s
}

// An object that represents a type of connection pool.
type VirtualGatewayHttp2ConnectionPool struct {
	_ struct{} `type:"structure"`

	// Maximum number of inflight requests Envoy can concurrently support across
	// hosts in upstream cluster.
	//
	// MaxRequests is a required field
	MaxRequests *int64 `locationName:"maxRequests" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayHttp2ConnectionPool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayHttp2ConnectionPool) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayHttp2ConnectionPool) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayHttp2ConnectionPool"}
	if s.MaxRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxRequests"))
	}
	if s.MaxRequests != nil && *s.MaxRequests < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxRequests sets the MaxRequests field's value.
func (s *VirtualGatewayHttp2ConnectionPool) SetMaxRequests(v int64) *VirtualGatewayHttp2ConnectionPool {
	s.MaxRequests = &v
	return s
}

// An object that represents a type of connection pool.
type VirtualGatewayHttpConnectionPool struct {
	_ struct{} `type:"structure"`

	// Maximum number of outbound TCP connections Envoy can establish concurrently
	// with all hosts in upstream cluster.
	//
	// MaxConnections is a required field
	MaxConnections *int64 `locationName:"maxConnections" min:"1" type:"integer" required:"true"`

	// Number of overflowing requests after max_connections Envoy will queue to
	// upstream cluster.
	MaxPendingRequests *int64 `locationName:"maxPendingRequests" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayHttpConnectionPool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayHttpConnectionPool) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayHttpConnectionPool) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayHttpConnectionPool"}
	if s.MaxConnections == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxConnections"))
	}
	if s.MaxConnections != nil && *s.MaxConnections < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxConnections", 1))
	}
	if s.MaxPendingRequests != nil && *s.MaxPendingRequests < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxPendingRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxConnections sets the MaxConnections field's value.
func (s *VirtualGatewayHttpConnectionPool) SetMaxConnections(v int64) *VirtualGatewayHttpConnectionPool {
	s.MaxConnections = &v
	return s
}

// SetMaxPendingRequests sets the MaxPendingRequests field's value.
func (s *VirtualGatewayHttpConnectionPool) SetMaxPendingRequests(v int64) *VirtualGatewayHttpConnectionPool {
	s.MaxPendingRequests = &v
	return s
}

// An object that represents a listener for a virtual gateway.
type VirtualGatewayListener struct {
	_ struct{} `type:"structure"`

	// The connection pool information for the virtual gateway listener.
	ConnectionPool *VirtualGatewayConnectionPool `locationName:"connectionPool" type:"structure"`

	// The health check information for the listener.
	HealthCheck *VirtualGatewayHealthCheckPolicy `locationName:"healthCheck" type:"structure"`

	// The port mapping information for the listener.
	//
	// PortMapping is a required field
	PortMapping *VirtualGatewayPortMapping `locationName:"portMapping" type:"structure" required:"true"`

	// A reference to an object that represents the Transport Layer Security (TLS)
	// properties for the listener.
	Tls *VirtualGatewayListenerTls `locationName:"tls" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListener) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayListener) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayListener"}
	if s.PortMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("PortMapping"))
	}
	if s.ConnectionPool != nil {
		if err := s.ConnectionPool.Validate(); err != nil {
			invalidParams.AddNested("ConnectionPool", err.(request.ErrInvalidParams))
		}
	}
	if s.HealthCheck != nil {
		if err := s.HealthCheck.Validate(); err != nil {
			invalidParams.AddNested("HealthCheck", err.(request.ErrInvalidParams))
		}
	}
	if s.PortMapping != nil {
		if err := s.PortMapping.Validate(); err != nil {
			invalidParams.AddNested("PortMapping", err.(request.ErrInvalidParams))
		}
	}
	if s.Tls != nil {
		if err := s.Tls.Validate(); err != nil {
			invalidParams.AddNested("Tls", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionPool sets the ConnectionPool field's value.
func (s *VirtualGatewayListener) SetConnectionPool(v *VirtualGatewayConnectionPool) *VirtualGatewayListener {
	s.ConnectionPool = v
	return s
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *VirtualGatewayListener) SetHealthCheck(v *VirtualGatewayHealthCheckPolicy) *VirtualGatewayListener {
	s.HealthCheck = v
	return s
}

// SetPortMapping sets the PortMapping field's value.
func (s *VirtualGatewayListener) SetPortMapping(v *VirtualGatewayPortMapping) *VirtualGatewayListener {
	s.PortMapping = v
	return s
}

// SetTls sets the Tls field's value.
func (s *VirtualGatewayListener) SetTls(v *VirtualGatewayListenerTls) *VirtualGatewayListener {
	s.Tls = v
	return s
}

// An object that represents the Transport Layer Security (TLS) properties for
// a listener.
type VirtualGatewayListenerTls struct {
	_ struct{} `type:"structure"`

	// An object that represents a Transport Layer Security (TLS) certificate.
	//
	// Certificate is a required field
	Certificate *VirtualGatewayListenerTlsCertificate `locationName:"certificate" type:"structure" required:"true"`

	// Specify one of the following modes.
	//
	//    * STRICT – Listener only accepts connections with TLS enabled.
	//
	//    * PERMISSIVE – Listener accepts connections with or without TLS enabled.
	//
	//    * DISABLED – Listener only accepts connections without TLS.
	//
	// Mode is a required field
	Mode *string `locationName:"mode" type:"string" required:"true" enum:"VirtualGatewayListenerTlsMode"`

	// A reference to an object that represents a virtual gateway's listener's Transport
	// Layer Security (TLS) validation context.
	Validation *VirtualGatewayListenerTlsValidationContext `locationName:"validation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTls) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTls) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayListenerTls) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayListenerTls"}
	if s.Certificate == nil {
		invalidParams.Add(request.NewErrParamRequired("Certificate"))
	}
	if s.Mode == nil {
		invalidParams.Add(request.NewErrParamRequired("Mode"))
	}
	if s.Certificate != nil {
		if err := s.Certificate.Validate(); err != nil {
			invalidParams.AddNested("Certificate", err.(request.ErrInvalidParams))
		}
	}
	if s.Validation != nil {
		if err := s.Validation.Validate(); err != nil {
			invalidParams.AddNested("Validation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *VirtualGatewayListenerTls) SetCertificate(v *VirtualGatewayListenerTlsCertificate) *VirtualGatewayListenerTls {
	s.Certificate = v
	return s
}

// SetMode sets the Mode field's value.
func (s *VirtualGatewayListenerTls) SetMode(v string) *VirtualGatewayListenerTls {
	s.Mode = &v
	return s
}

// SetValidation sets the Validation field's value.
func (s *VirtualGatewayListenerTls) SetValidation(v *VirtualGatewayListenerTlsValidationContext) *VirtualGatewayListenerTls {
	s.Validation = v
	return s
}

// An object that represents an Certificate Manager certificate.
type VirtualGatewayListenerTlsAcmCertificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate. The certificate must
	// meet specific requirements and you must have proxy authorization enabled.
	// For more information, see Transport Layer Security (TLS) (https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites).
	//
	// CertificateArn is a required field
	CertificateArn *string `locationName:"certificateArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTlsAcmCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTlsAcmCertificate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayListenerTlsAcmCertificate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayListenerTlsAcmCertificate"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *VirtualGatewayListenerTlsAcmCertificate) SetCertificateArn(v string) *VirtualGatewayListenerTlsAcmCertificate {
	s.CertificateArn = &v
	return s
}

// An object that represents a listener's Transport Layer Security (TLS) certificate.
type VirtualGatewayListenerTlsCertificate struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents an Certificate Manager certificate.
	Acm *VirtualGatewayListenerTlsAcmCertificate `locationName:"acm" type:"structure"`

	// A reference to an object that represents a local file certificate.
	File *VirtualGatewayListenerTlsFileCertificate `locationName:"file" type:"structure"`

	// A reference to an object that represents a virtual gateway's listener's Secret
	// Discovery Service certificate.
	Sds *VirtualGatewayListenerTlsSdsCertificate `locationName:"sds" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTlsCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTlsCertificate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayListenerTlsCertificate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayListenerTlsCertificate"}
	if s.Acm != nil {
		if err := s.Acm.Validate(); err != nil {
			invalidParams.AddNested("Acm", err.(request.ErrInvalidParams))
		}
	}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}
	if s.Sds != nil {
		if err := s.Sds.Validate(); err != nil {
			invalidParams.AddNested("Sds", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcm sets the Acm field's value.
func (s *VirtualGatewayListenerTlsCertificate) SetAcm(v *VirtualGatewayListenerTlsAcmCertificate) *VirtualGatewayListenerTlsCertificate {
	s.Acm = v
	return s
}

// SetFile sets the File field's value.
func (s *VirtualGatewayListenerTlsCertificate) SetFile(v *VirtualGatewayListenerTlsFileCertificate) *VirtualGatewayListenerTlsCertificate {
	s.File = v
	return s
}

// SetSds sets the Sds field's value.
func (s *VirtualGatewayListenerTlsCertificate) SetSds(v *VirtualGatewayListenerTlsSdsCertificate) *VirtualGatewayListenerTlsCertificate {
	s.Sds = v
	return s
}

// An object that represents a local file certificate. The certificate must
// meet specific requirements and you must have proxy authorization enabled.
// For more information, see Transport Layer Security (TLS) (https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites).
type VirtualGatewayListenerTlsFileCertificate struct {
	_ struct{} `type:"structure"`

	// The certificate chain for the certificate.
	//
	// CertificateChain is a required field
	CertificateChain *string `locationName:"certificateChain" min:"1" type:"string" required:"true"`

	// The private key for a certificate stored on the file system of the mesh endpoint
	// that the proxy is running on.
	//
	// PrivateKey is a required field
	PrivateKey *string `locationName:"privateKey" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTlsFileCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTlsFileCertificate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayListenerTlsFileCertificate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayListenerTlsFileCertificate"}
	if s.CertificateChain == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateChain"))
	}
	if s.CertificateChain != nil && len(*s.CertificateChain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateChain", 1))
	}
	if s.PrivateKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateKey"))
	}
	if s.PrivateKey != nil && len(*s.PrivateKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrivateKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *VirtualGatewayListenerTlsFileCertificate) SetCertificateChain(v string) *VirtualGatewayListenerTlsFileCertificate {
	s.CertificateChain = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *VirtualGatewayListenerTlsFileCertificate) SetPrivateKey(v string) *VirtualGatewayListenerTlsFileCertificate {
	s.PrivateKey = &v
	return s
}

// An object that represents the virtual gateway's listener's Secret Discovery
// Service certificate.The proxy must be configured with a local SDS provider
// via a Unix Domain Socket. See App MeshTLS documentation (https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html)
// for more info.
type VirtualGatewayListenerTlsSdsCertificate struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents the name of the secret secret requested
	// from the Secret Discovery Service provider representing Transport Layer Security
	// (TLS) materials like a certificate or certificate chain.
	//
	// SecretName is a required field
	SecretName *string `locationName:"secretName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTlsSdsCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTlsSdsCertificate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayListenerTlsSdsCertificate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayListenerTlsSdsCertificate"}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretName sets the SecretName field's value.
func (s *VirtualGatewayListenerTlsSdsCertificate) SetSecretName(v string) *VirtualGatewayListenerTlsSdsCertificate {
	s.SecretName = &v
	return s
}

// An object that represents a virtual gateway's listener's Transport Layer
// Security (TLS) validation context.
type VirtualGatewayListenerTlsValidationContext struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents the SANs for a virtual gateway listener's
	// Transport Layer Security (TLS) validation context.
	SubjectAlternativeNames *SubjectAlternativeNames `locationName:"subjectAlternativeNames" type:"structure"`

	// A reference to where to retrieve the trust chain when validating a peer’s
	// Transport Layer Security (TLS) certificate.
	//
	// Trust is a required field
	Trust *VirtualGatewayListenerTlsValidationContextTrust `locationName:"trust" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTlsValidationContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTlsValidationContext) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayListenerTlsValidationContext) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayListenerTlsValidationContext"}
	if s.Trust == nil {
		invalidParams.Add(request.NewErrParamRequired("Trust"))
	}
	if s.SubjectAlternativeNames != nil {
		if err := s.SubjectAlternativeNames.Validate(); err != nil {
			invalidParams.AddNested("SubjectAlternativeNames", err.(request.ErrInvalidParams))
		}
	}
	if s.Trust != nil {
		if err := s.Trust.Validate(); err != nil {
			invalidParams.AddNested("Trust", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubjectAlternativeNames sets the SubjectAlternativeNames field's value.
func (s *VirtualGatewayListenerTlsValidationContext) SetSubjectAlternativeNames(v *SubjectAlternativeNames) *VirtualGatewayListenerTlsValidationContext {
	s.SubjectAlternativeNames = v
	return s
}

// SetTrust sets the Trust field's value.
func (s *VirtualGatewayListenerTlsValidationContext) SetTrust(v *VirtualGatewayListenerTlsValidationContextTrust) *VirtualGatewayListenerTlsValidationContext {
	s.Trust = v
	return s
}

// An object that represents a virtual gateway's listener's Transport Layer
// Security (TLS) validation context trust.
type VirtualGatewayListenerTlsValidationContextTrust struct {
	_ struct{} `type:"structure"`

	// An object that represents a Transport Layer Security (TLS) validation context
	// trust for a local file.
	File *VirtualGatewayTlsValidationContextFileTrust `locationName:"file" type:"structure"`

	// A reference to an object that represents a virtual gateway's listener's Transport
	// Layer Security (TLS) Secret Discovery Service validation context trust.
	Sds *VirtualGatewayTlsValidationContextSdsTrust `locationName:"sds" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTlsValidationContextTrust) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayListenerTlsValidationContextTrust) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayListenerTlsValidationContextTrust) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayListenerTlsValidationContextTrust"}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}
	if s.Sds != nil {
		if err := s.Sds.Validate(); err != nil {
			invalidParams.AddNested("Sds", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *VirtualGatewayListenerTlsValidationContextTrust) SetFile(v *VirtualGatewayTlsValidationContextFileTrust) *VirtualGatewayListenerTlsValidationContextTrust {
	s.File = v
	return s
}

// SetSds sets the Sds field's value.
func (s *VirtualGatewayListenerTlsValidationContextTrust) SetSds(v *VirtualGatewayTlsValidationContextSdsTrust) *VirtualGatewayListenerTlsValidationContextTrust {
	s.Sds = v
	return s
}

// An object that represents logging information.
type VirtualGatewayLogging struct {
	_ struct{} `type:"structure"`

	// The access log configuration.
	AccessLog *VirtualGatewayAccessLog `locationName:"accessLog" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayLogging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayLogging) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayLogging) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayLogging"}
	if s.AccessLog != nil {
		if err := s.AccessLog.Validate(); err != nil {
			invalidParams.AddNested("AccessLog", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessLog sets the AccessLog field's value.
func (s *VirtualGatewayLogging) SetAccessLog(v *VirtualGatewayAccessLog) *VirtualGatewayLogging {
	s.AccessLog = v
	return s
}

// An object that represents a port mapping.
type VirtualGatewayPortMapping struct {
	_ struct{} `type:"structure"`

	// The port used for the port mapping. Specify one protocol.
	//
	// Port is a required field
	Port *int64 `locationName:"port" min:"1" type:"integer" required:"true"`

	// The protocol used for the port mapping.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"VirtualGatewayPortProtocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayPortMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayPortMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayPortMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayPortMapping"}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPort sets the Port field's value.
func (s *VirtualGatewayPortMapping) SetPort(v int64) *VirtualGatewayPortMapping {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *VirtualGatewayPortMapping) SetProtocol(v string) *VirtualGatewayPortMapping {
	s.Protocol = &v
	return s
}

// An object that represents a virtual gateway returned by a list operation.
type VirtualGatewayRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the resource.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" required:"true"`

	// The name of the service mesh that the resource resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// MeshOwner is a required field
	MeshOwner *string `locationName:"meshOwner" min:"12" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the resource owner. If the account
	// ID is not your own, then it's the ID of the mesh owner or of another account
	// that the mesh is shared with. For more information about mesh sharing, see
	// Working with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" min:"12" type:"string" required:"true"`

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// Version is a required field
	Version *int64 `locationName:"version" type:"long" required:"true"`

	// The name of the resource.
	//
	// VirtualGatewayName is a required field
	VirtualGatewayName *string `locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VirtualGatewayRef) SetArn(v string) *VirtualGatewayRef {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *VirtualGatewayRef) SetCreatedAt(v time.Time) *VirtualGatewayRef {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *VirtualGatewayRef) SetLastUpdatedAt(v time.Time) *VirtualGatewayRef {
	s.LastUpdatedAt = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualGatewayRef) SetMeshName(v string) *VirtualGatewayRef {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *VirtualGatewayRef) SetMeshOwner(v string) *VirtualGatewayRef {
	s.MeshOwner = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *VirtualGatewayRef) SetResourceOwner(v string) *VirtualGatewayRef {
	s.ResourceOwner = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *VirtualGatewayRef) SetVersion(v int64) *VirtualGatewayRef {
	s.Version = &v
	return s
}

// SetVirtualGatewayName sets the VirtualGatewayName field's value.
func (s *VirtualGatewayRef) SetVirtualGatewayName(v string) *VirtualGatewayRef {
	s.VirtualGatewayName = &v
	return s
}

// An object that represents the specification of a service mesh resource.
type VirtualGatewaySpec struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents the defaults for backends.
	BackendDefaults *VirtualGatewayBackendDefaults `locationName:"backendDefaults" type:"structure"`

	// The listeners that the mesh endpoint is expected to receive inbound traffic
	// from. You can specify one listener.
	//
	// Listeners is a required field
	Listeners []*VirtualGatewayListener `locationName:"listeners" type:"list" required:"true"`

	// An object that represents logging information.
	Logging *VirtualGatewayLogging `locationName:"logging" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewaySpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewaySpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewaySpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewaySpec"}
	if s.Listeners == nil {
		invalidParams.Add(request.NewErrParamRequired("Listeners"))
	}
	if s.BackendDefaults != nil {
		if err := s.BackendDefaults.Validate(); err != nil {
			invalidParams.AddNested("BackendDefaults", err.(request.ErrInvalidParams))
		}
	}
	if s.Listeners != nil {
		for i, v := range s.Listeners {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Listeners", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackendDefaults sets the BackendDefaults field's value.
func (s *VirtualGatewaySpec) SetBackendDefaults(v *VirtualGatewayBackendDefaults) *VirtualGatewaySpec {
	s.BackendDefaults = v
	return s
}

// SetListeners sets the Listeners field's value.
func (s *VirtualGatewaySpec) SetListeners(v []*VirtualGatewayListener) *VirtualGatewaySpec {
	s.Listeners = v
	return s
}

// SetLogging sets the Logging field's value.
func (s *VirtualGatewaySpec) SetLogging(v *VirtualGatewayLogging) *VirtualGatewaySpec {
	s.Logging = v
	return s
}

// An object that represents the status of the mesh resource.
type VirtualGatewayStatus struct {
	_ struct{} `type:"structure"`

	// The current status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"VirtualGatewayStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VirtualGatewayStatus) SetStatus(v string) *VirtualGatewayStatus {
	s.Status = &v
	return s
}

// An object that represents a Transport Layer Security (TLS) validation context.
type VirtualGatewayTlsValidationContext struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents the SANs for a virtual gateway's
	// listener's Transport Layer Security (TLS) validation context.
	SubjectAlternativeNames *SubjectAlternativeNames `locationName:"subjectAlternativeNames" type:"structure"`

	// A reference to where to retrieve the trust chain when validating a peer’s
	// Transport Layer Security (TLS) certificate.
	//
	// Trust is a required field
	Trust *VirtualGatewayTlsValidationContextTrust `locationName:"trust" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayTlsValidationContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayTlsValidationContext) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayTlsValidationContext) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayTlsValidationContext"}
	if s.Trust == nil {
		invalidParams.Add(request.NewErrParamRequired("Trust"))
	}
	if s.SubjectAlternativeNames != nil {
		if err := s.SubjectAlternativeNames.Validate(); err != nil {
			invalidParams.AddNested("SubjectAlternativeNames", err.(request.ErrInvalidParams))
		}
	}
	if s.Trust != nil {
		if err := s.Trust.Validate(); err != nil {
			invalidParams.AddNested("Trust", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubjectAlternativeNames sets the SubjectAlternativeNames field's value.
func (s *VirtualGatewayTlsValidationContext) SetSubjectAlternativeNames(v *SubjectAlternativeNames) *VirtualGatewayTlsValidationContext {
	s.SubjectAlternativeNames = v
	return s
}

// SetTrust sets the Trust field's value.
func (s *VirtualGatewayTlsValidationContext) SetTrust(v *VirtualGatewayTlsValidationContextTrust) *VirtualGatewayTlsValidationContext {
	s.Trust = v
	return s
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust for an Certificate Manager certificate.
type VirtualGatewayTlsValidationContextAcmTrust struct {
	_ struct{} `type:"structure"`

	// One or more ACM Amazon Resource Name (ARN)s.
	//
	// CertificateAuthorityArns is a required field
	CertificateAuthorityArns []*string `locationName:"certificateAuthorityArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayTlsValidationContextAcmTrust) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayTlsValidationContextAcmTrust) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayTlsValidationContextAcmTrust) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayTlsValidationContextAcmTrust"}
	if s.CertificateAuthorityArns == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArns"))
	}
	if s.CertificateAuthorityArns != nil && len(s.CertificateAuthorityArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArns sets the CertificateAuthorityArns field's value.
func (s *VirtualGatewayTlsValidationContextAcmTrust) SetCertificateAuthorityArns(v []*string) *VirtualGatewayTlsValidationContextAcmTrust {
	s.CertificateAuthorityArns = v
	return s
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust for a local file.
type VirtualGatewayTlsValidationContextFileTrust struct {
	_ struct{} `type:"structure"`

	// The certificate trust chain for a certificate stored on the file system of
	// the virtual node that the proxy is running on.
	//
	// CertificateChain is a required field
	CertificateChain *string `locationName:"certificateChain" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayTlsValidationContextFileTrust) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayTlsValidationContextFileTrust) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayTlsValidationContextFileTrust) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayTlsValidationContextFileTrust"}
	if s.CertificateChain == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateChain"))
	}
	if s.CertificateChain != nil && len(*s.CertificateChain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateChain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *VirtualGatewayTlsValidationContextFileTrust) SetCertificateChain(v string) *VirtualGatewayTlsValidationContextFileTrust {
	s.CertificateChain = &v
	return s
}

// An object that represents a virtual gateway's listener's Transport Layer
// Security (TLS) Secret Discovery Service validation context trust. The proxy
// must be configured with a local SDS provider via a Unix Domain Socket. See
// App Mesh TLS documentation (https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html)
// for more info.
type VirtualGatewayTlsValidationContextSdsTrust struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents the name of the secret for a virtual
	// gateway's Transport Layer Security (TLS) Secret Discovery Service validation
	// context trust.
	//
	// SecretName is a required field
	SecretName *string `locationName:"secretName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayTlsValidationContextSdsTrust) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayTlsValidationContextSdsTrust) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayTlsValidationContextSdsTrust) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayTlsValidationContextSdsTrust"}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretName sets the SecretName field's value.
func (s *VirtualGatewayTlsValidationContextSdsTrust) SetSecretName(v string) *VirtualGatewayTlsValidationContextSdsTrust {
	s.SecretName = &v
	return s
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust.
type VirtualGatewayTlsValidationContextTrust struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents a Transport Layer Security (TLS)
	// validation context trust for an Certificate Manager certificate.
	Acm *VirtualGatewayTlsValidationContextAcmTrust `locationName:"acm" type:"structure"`

	// An object that represents a Transport Layer Security (TLS) validation context
	// trust for a local file.
	File *VirtualGatewayTlsValidationContextFileTrust `locationName:"file" type:"structure"`

	// A reference to an object that represents a virtual gateway's Transport Layer
	// Security (TLS) Secret Discovery Service validation context trust.
	Sds *VirtualGatewayTlsValidationContextSdsTrust `locationName:"sds" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayTlsValidationContextTrust) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualGatewayTlsValidationContextTrust) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualGatewayTlsValidationContextTrust) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualGatewayTlsValidationContextTrust"}
	if s.Acm != nil {
		if err := s.Acm.Validate(); err != nil {
			invalidParams.AddNested("Acm", err.(request.ErrInvalidParams))
		}
	}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}
	if s.Sds != nil {
		if err := s.Sds.Validate(); err != nil {
			invalidParams.AddNested("Sds", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcm sets the Acm field's value.
func (s *VirtualGatewayTlsValidationContextTrust) SetAcm(v *VirtualGatewayTlsValidationContextAcmTrust) *VirtualGatewayTlsValidationContextTrust {
	s.Acm = v
	return s
}

// SetFile sets the File field's value.
func (s *VirtualGatewayTlsValidationContextTrust) SetFile(v *VirtualGatewayTlsValidationContextFileTrust) *VirtualGatewayTlsValidationContextTrust {
	s.File = v
	return s
}

// SetSds sets the Sds field's value.
func (s *VirtualGatewayTlsValidationContextTrust) SetSds(v *VirtualGatewayTlsValidationContextSdsTrust) *VirtualGatewayTlsValidationContextTrust {
	s.Sds = v
	return s
}

// An object that represents the type of virtual node connection pool.
//
// Only one protocol is used at a time and should be the same protocol as the
// one chosen under port mapping.
//
// If not present the default value for maxPendingRequests is 2147483647.
type VirtualNodeConnectionPool struct {
	_ struct{} `type:"structure"`

	// An object that represents a type of connection pool.
	Grpc *VirtualNodeGrpcConnectionPool `locationName:"grpc" type:"structure"`

	// An object that represents a type of connection pool.
	Http *VirtualNodeHttpConnectionPool `locationName:"http" type:"structure"`

	// An object that represents a type of connection pool.
	Http2 *VirtualNodeHttp2ConnectionPool `locationName:"http2" type:"structure"`

	// An object that represents a type of connection pool.
	Tcp *VirtualNodeTcpConnectionPool `locationName:"tcp" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeConnectionPool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeConnectionPool) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeConnectionPool) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualNodeConnectionPool"}
	if s.Grpc != nil {
		if err := s.Grpc.Validate(); err != nil {
			invalidParams.AddNested("Grpc", err.(request.ErrInvalidParams))
		}
	}
	if s.Http != nil {
		if err := s.Http.Validate(); err != nil {
			invalidParams.AddNested("Http", err.(request.ErrInvalidParams))
		}
	}
	if s.Http2 != nil {
		if err := s.Http2.Validate(); err != nil {
			invalidParams.AddNested("Http2", err.(request.ErrInvalidParams))
		}
	}
	if s.Tcp != nil {
		if err := s.Tcp.Validate(); err != nil {
			invalidParams.AddNested("Tcp", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrpc sets the Grpc field's value.
func (s *VirtualNodeConnectionPool) SetGrpc(v *VirtualNodeGrpcConnectionPool) *VirtualNodeConnectionPool {
	s.Grpc = v
	return s
}

// SetHttp sets the Http field's value.
func (s *VirtualNodeConnectionPool) SetHttp(v *VirtualNodeHttpConnectionPool) *VirtualNodeConnectionPool {
	s.Http = v
	return s
}

// SetHttp2 sets the Http2 field's value.
func (s *VirtualNodeConnectionPool) SetHttp2(v *VirtualNodeHttp2ConnectionPool) *VirtualNodeConnectionPool {
	s.Http2 = v
	return s
}

// SetTcp sets the Tcp field's value.
func (s *VirtualNodeConnectionPool) SetTcp(v *VirtualNodeTcpConnectionPool) *VirtualNodeConnectionPool {
	s.Tcp = v
	return s
}

// An object that represents a virtual node returned by a describe operation.
type VirtualNodeData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the virtual node resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the virtual node.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The specifications of the virtual node.
	//
	// Spec is a required field
	Spec *VirtualNodeSpec `locationName:"spec" type:"structure" required:"true"`

	// The current status for the virtual node.
	//
	// Status is a required field
	Status *VirtualNodeStatus `locationName:"status" type:"structure" required:"true"`

	// The name of the virtual node.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualNodeData) SetMeshName(v string) *VirtualNodeData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *VirtualNodeData) SetMetadata(v *ResourceMetadata) *VirtualNodeData {
	s.Metadata = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *VirtualNodeData) SetSpec(v *VirtualNodeSpec) *VirtualNodeData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VirtualNodeData) SetStatus(v *VirtualNodeStatus) *VirtualNodeData {
	s.Status = v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *VirtualNodeData) SetVirtualNodeName(v string) *VirtualNodeData {
	s.VirtualNodeName = &v
	return s
}

// An object that represents a type of connection pool.
type VirtualNodeGrpcConnectionPool struct {
	_ struct{} `type:"structure"`

	// Maximum number of inflight requests Envoy can concurrently support across
	// hosts in upstream cluster.
	//
	// MaxRequests is a required field
	MaxRequests *int64 `locationName:"maxRequests" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeGrpcConnectionPool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeGrpcConnectionPool) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeGrpcConnectionPool) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualNodeGrpcConnectionPool"}
	if s.MaxRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxRequests"))
	}
	if s.MaxRequests != nil && *s.MaxRequests < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxRequests sets the MaxRequests field's value.
func (s *VirtualNodeGrpcConnectionPool) SetMaxRequests(v int64) *VirtualNodeGrpcConnectionPool {
	s.MaxRequests = &v
	return s
}

// An object that represents a type of connection pool.
type VirtualNodeHttp2ConnectionPool struct {
	_ struct{} `type:"structure"`

	// Maximum number of inflight requests Envoy can concurrently support across
	// hosts in upstream cluster.
	//
	// MaxRequests is a required field
	MaxRequests *int64 `locationName:"maxRequests" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeHttp2ConnectionPool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeHttp2ConnectionPool) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeHttp2ConnectionPool) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualNodeHttp2ConnectionPool"}
	if s.MaxRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxRequests"))
	}
	if s.MaxRequests != nil && *s.MaxRequests < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxRequests sets the MaxRequests field's value.
func (s *VirtualNodeHttp2ConnectionPool) SetMaxRequests(v int64) *VirtualNodeHttp2ConnectionPool {
	s.MaxRequests = &v
	return s
}

// An object that represents a type of connection pool.
type VirtualNodeHttpConnectionPool struct {
	_ struct{} `type:"structure"`

	// Maximum number of outbound TCP connections Envoy can establish concurrently
	// with all hosts in upstream cluster.
	//
	// MaxConnections is a required field
	MaxConnections *int64 `locationName:"maxConnections" min:"1" type:"integer" required:"true"`

	// Number of overflowing requests after max_connections Envoy will queue to
	// upstream cluster.
	MaxPendingRequests *int64 `locationName:"maxPendingRequests" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeHttpConnectionPool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeHttpConnectionPool) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeHttpConnectionPool) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualNodeHttpConnectionPool"}
	if s.MaxConnections == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxConnections"))
	}
	if s.MaxConnections != nil && *s.MaxConnections < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxConnections", 1))
	}
	if s.MaxPendingRequests != nil && *s.MaxPendingRequests < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxPendingRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxConnections sets the MaxConnections field's value.
func (s *VirtualNodeHttpConnectionPool) SetMaxConnections(v int64) *VirtualNodeHttpConnectionPool {
	s.MaxConnections = &v
	return s
}

// SetMaxPendingRequests sets the MaxPendingRequests field's value.
func (s *VirtualNodeHttpConnectionPool) SetMaxPendingRequests(v int64) *VirtualNodeHttpConnectionPool {
	s.MaxPendingRequests = &v
	return s
}

// An object that represents a virtual node returned by a list operation.
type VirtualNodeRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the virtual node.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" required:"true"`

	// The name of the service mesh that the virtual node resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// MeshOwner is a required field
	MeshOwner *string `locationName:"meshOwner" min:"12" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the resource owner. If the account
	// ID is not your own, then it's the ID of the mesh owner or of another account
	// that the mesh is shared with. For more information about mesh sharing, see
	// Working with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" min:"12" type:"string" required:"true"`

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// Version is a required field
	Version *int64 `locationName:"version" type:"long" required:"true"`

	// The name of the virtual node.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VirtualNodeRef) SetArn(v string) *VirtualNodeRef {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *VirtualNodeRef) SetCreatedAt(v time.Time) *VirtualNodeRef {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *VirtualNodeRef) SetLastUpdatedAt(v time.Time) *VirtualNodeRef {
	s.LastUpdatedAt = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualNodeRef) SetMeshName(v string) *VirtualNodeRef {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *VirtualNodeRef) SetMeshOwner(v string) *VirtualNodeRef {
	s.MeshOwner = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *VirtualNodeRef) SetResourceOwner(v string) *VirtualNodeRef {
	s.ResourceOwner = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *VirtualNodeRef) SetVersion(v int64) *VirtualNodeRef {
	s.Version = &v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *VirtualNodeRef) SetVirtualNodeName(v string) *VirtualNodeRef {
	s.VirtualNodeName = &v
	return s
}

// An object that represents a virtual node service provider.
type VirtualNodeServiceProvider struct {
	_ struct{} `type:"structure"`

	// The name of the virtual node that is acting as a service provider.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeServiceProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeServiceProvider) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeServiceProvider) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualNodeServiceProvider"}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *VirtualNodeServiceProvider) SetVirtualNodeName(v string) *VirtualNodeServiceProvider {
	s.VirtualNodeName = &v
	return s
}

// An object that represents the specification of a virtual node.
type VirtualNodeSpec struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents the defaults for backends.
	BackendDefaults *BackendDefaults `locationName:"backendDefaults" type:"structure"`

	// The backends that the virtual node is expected to send outbound traffic to.
	Backends []*Backend `locationName:"backends" type:"list"`

	// The listener that the virtual node is expected to receive inbound traffic
	// from. You can specify one listener.
	Listeners []*Listener `locationName:"listeners" type:"list"`

	// The inbound and outbound access logging information for the virtual node.
	Logging *Logging `locationName:"logging" type:"structure"`

	// The service discovery information for the virtual node. If your virtual node
	// does not expect ingress traffic, you can omit this parameter. If you specify
	// a listener, then you must specify service discovery information.
	ServiceDiscovery *ServiceDiscovery `locationName:"serviceDiscovery" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualNodeSpec"}
	if s.BackendDefaults != nil {
		if err := s.BackendDefaults.Validate(); err != nil {
			invalidParams.AddNested("BackendDefaults", err.(request.ErrInvalidParams))
		}
	}
	if s.Backends != nil {
		for i, v := range s.Backends {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Backends", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Listeners != nil {
		for i, v := range s.Listeners {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Listeners", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(request.ErrInvalidParams))
		}
	}
	if s.ServiceDiscovery != nil {
		if err := s.ServiceDiscovery.Validate(); err != nil {
			invalidParams.AddNested("ServiceDiscovery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackendDefaults sets the BackendDefaults field's value.
func (s *VirtualNodeSpec) SetBackendDefaults(v *BackendDefaults) *VirtualNodeSpec {
	s.BackendDefaults = v
	return s
}

// SetBackends sets the Backends field's value.
func (s *VirtualNodeSpec) SetBackends(v []*Backend) *VirtualNodeSpec {
	s.Backends = v
	return s
}

// SetListeners sets the Listeners field's value.
func (s *VirtualNodeSpec) SetListeners(v []*Listener) *VirtualNodeSpec {
	s.Listeners = v
	return s
}

// SetLogging sets the Logging field's value.
func (s *VirtualNodeSpec) SetLogging(v *Logging) *VirtualNodeSpec {
	s.Logging = v
	return s
}

// SetServiceDiscovery sets the ServiceDiscovery field's value.
func (s *VirtualNodeSpec) SetServiceDiscovery(v *ServiceDiscovery) *VirtualNodeSpec {
	s.ServiceDiscovery = v
	return s
}

// An object that represents the current status of the virtual node.
type VirtualNodeStatus struct {
	_ struct{} `type:"structure"`

	// The current status of the virtual node.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"VirtualNodeStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VirtualNodeStatus) SetStatus(v string) *VirtualNodeStatus {
	s.Status = &v
	return s
}

// An object that represents a type of connection pool.
type VirtualNodeTcpConnectionPool struct {
	_ struct{} `type:"structure"`

	// Maximum number of outbound TCP connections Envoy can establish concurrently
	// with all hosts in upstream cluster.
	//
	// MaxConnections is a required field
	MaxConnections *int64 `locationName:"maxConnections" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeTcpConnectionPool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualNodeTcpConnectionPool) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeTcpConnectionPool) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualNodeTcpConnectionPool"}
	if s.MaxConnections == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxConnections"))
	}
	if s.MaxConnections != nil && *s.MaxConnections < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxConnections", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxConnections sets the MaxConnections field's value.
func (s *VirtualNodeTcpConnectionPool) SetMaxConnections(v int64) *VirtualNodeTcpConnectionPool {
	s.MaxConnections = &v
	return s
}

// An object that represents a virtual router returned by a describe operation.
type VirtualRouterData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the virtual router resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the virtual router.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The specifications of the virtual router.
	//
	// Spec is a required field
	Spec *VirtualRouterSpec `locationName:"spec" type:"structure" required:"true"`

	// The current status of the virtual router.
	//
	// Status is a required field
	Status *VirtualRouterStatus `locationName:"status" type:"structure" required:"true"`

	// The name of the virtual router.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualRouterData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualRouterData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualRouterData) SetMeshName(v string) *VirtualRouterData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *VirtualRouterData) SetMetadata(v *ResourceMetadata) *VirtualRouterData {
	s.Metadata = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *VirtualRouterData) SetSpec(v *VirtualRouterSpec) *VirtualRouterData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VirtualRouterData) SetStatus(v *VirtualRouterStatus) *VirtualRouterData {
	s.Status = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *VirtualRouterData) SetVirtualRouterName(v string) *VirtualRouterData {
	s.VirtualRouterName = &v
	return s
}

// An object that represents a virtual router listener.
type VirtualRouterListener struct {
	_ struct{} `type:"structure"`

	// An object that represents a port mapping.
	//
	// PortMapping is a required field
	PortMapping *PortMapping `locationName:"portMapping" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualRouterListener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualRouterListener) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualRouterListener) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualRouterListener"}
	if s.PortMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("PortMapping"))
	}
	if s.PortMapping != nil {
		if err := s.PortMapping.Validate(); err != nil {
			invalidParams.AddNested("PortMapping", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortMapping sets the PortMapping field's value.
func (s *VirtualRouterListener) SetPortMapping(v *PortMapping) *VirtualRouterListener {
	s.PortMapping = v
	return s
}

// An object that represents a virtual router returned by a list operation.
type VirtualRouterRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the virtual router.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" required:"true"`

	// The name of the service mesh that the virtual router resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// MeshOwner is a required field
	MeshOwner *string `locationName:"meshOwner" min:"12" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the resource owner. If the account
	// ID is not your own, then it's the ID of the mesh owner or of another account
	// that the mesh is shared with. For more information about mesh sharing, see
	// Working with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" min:"12" type:"string" required:"true"`

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// Version is a required field
	Version *int64 `locationName:"version" type:"long" required:"true"`

	// The name of the virtual router.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualRouterRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualRouterRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VirtualRouterRef) SetArn(v string) *VirtualRouterRef {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *VirtualRouterRef) SetCreatedAt(v time.Time) *VirtualRouterRef {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *VirtualRouterRef) SetLastUpdatedAt(v time.Time) *VirtualRouterRef {
	s.LastUpdatedAt = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualRouterRef) SetMeshName(v string) *VirtualRouterRef {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *VirtualRouterRef) SetMeshOwner(v string) *VirtualRouterRef {
	s.MeshOwner = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *VirtualRouterRef) SetResourceOwner(v string) *VirtualRouterRef {
	s.ResourceOwner = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *VirtualRouterRef) SetVersion(v int64) *VirtualRouterRef {
	s.Version = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *VirtualRouterRef) SetVirtualRouterName(v string) *VirtualRouterRef {
	s.VirtualRouterName = &v
	return s
}

// An object that represents a virtual node service provider.
type VirtualRouterServiceProvider struct {
	_ struct{} `type:"structure"`

	// The name of the virtual router that is acting as a service provider.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualRouterServiceProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualRouterServiceProvider) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualRouterServiceProvider) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualRouterServiceProvider"}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *VirtualRouterServiceProvider) SetVirtualRouterName(v string) *VirtualRouterServiceProvider {
	s.VirtualRouterName = &v
	return s
}

// An object that represents the specification of a virtual router.
type VirtualRouterSpec struct {
	_ struct{} `type:"structure"`

	// The listeners that the virtual router is expected to receive inbound traffic
	// from. You can specify one listener.
	Listeners []*VirtualRouterListener `locationName:"listeners" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualRouterSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualRouterSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualRouterSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualRouterSpec"}
	if s.Listeners != nil {
		for i, v := range s.Listeners {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Listeners", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListeners sets the Listeners field's value.
func (s *VirtualRouterSpec) SetListeners(v []*VirtualRouterListener) *VirtualRouterSpec {
	s.Listeners = v
	return s
}

// An object that represents the status of a virtual router.
type VirtualRouterStatus struct {
	_ struct{} `type:"structure"`

	// The current status of the virtual router.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"VirtualRouterStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualRouterStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualRouterStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VirtualRouterStatus) SetStatus(v string) *VirtualRouterStatus {
	s.Status = &v
	return s
}

// An object that represents a virtual service backend for a virtual node.
type VirtualServiceBackend struct {
	_ struct{} `type:"structure"`

	// A reference to an object that represents the client policy for a backend.
	ClientPolicy *ClientPolicy `locationName:"clientPolicy" type:"structure"`

	// The name of the virtual service that is acting as a virtual node backend.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualServiceBackend) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualServiceBackend) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualServiceBackend) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualServiceBackend"}
	if s.VirtualServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualServiceName"))
	}
	if s.ClientPolicy != nil {
		if err := s.ClientPolicy.Validate(); err != nil {
			invalidParams.AddNested("ClientPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientPolicy sets the ClientPolicy field's value.
func (s *VirtualServiceBackend) SetClientPolicy(v *ClientPolicy) *VirtualServiceBackend {
	s.ClientPolicy = v
	return s
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *VirtualServiceBackend) SetVirtualServiceName(v string) *VirtualServiceBackend {
	s.VirtualServiceName = &v
	return s
}

// An object that represents a virtual service returned by a describe operation.
type VirtualServiceData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the virtual service resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// An object that represents metadata for a resource.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The specifications of the virtual service.
	//
	// Spec is a required field
	Spec *VirtualServiceSpec `locationName:"spec" type:"structure" required:"true"`

	// The current status of the virtual service.
	//
	// Status is a required field
	Status *VirtualServiceStatus `locationName:"status" type:"structure" required:"true"`

	// The name of the virtual service.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualServiceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualServiceData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualServiceData) SetMeshName(v string) *VirtualServiceData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *VirtualServiceData) SetMetadata(v *ResourceMetadata) *VirtualServiceData {
	s.Metadata = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *VirtualServiceData) SetSpec(v *VirtualServiceSpec) *VirtualServiceData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VirtualServiceData) SetStatus(v *VirtualServiceStatus) *VirtualServiceData {
	s.Status = v
	return s
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *VirtualServiceData) SetVirtualServiceName(v string) *VirtualServiceData {
	s.VirtualServiceName = &v
	return s
}

// An object that represents the provider for a virtual service.
type VirtualServiceProvider struct {
	_ struct{} `type:"structure"`

	// The virtual node associated with a virtual service.
	VirtualNode *VirtualNodeServiceProvider `locationName:"virtualNode" type:"structure"`

	// The virtual router associated with a virtual service.
	VirtualRouter *VirtualRouterServiceProvider `locationName:"virtualRouter" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualServiceProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualServiceProvider) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualServiceProvider) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualServiceProvider"}
	if s.VirtualNode != nil {
		if err := s.VirtualNode.Validate(); err != nil {
			invalidParams.AddNested("VirtualNode", err.(request.ErrInvalidParams))
		}
	}
	if s.VirtualRouter != nil {
		if err := s.VirtualRouter.Validate(); err != nil {
			invalidParams.AddNested("VirtualRouter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *VirtualServiceProvider) SetVirtualNode(v *VirtualNodeServiceProvider) *VirtualServiceProvider {
	s.VirtualNode = v
	return s
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *VirtualServiceProvider) SetVirtualRouter(v *VirtualRouterServiceProvider) *VirtualServiceProvider {
	s.VirtualRouter = v
	return s
}

// An object that represents a virtual service returned by a list operation.
type VirtualServiceRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the virtual service.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" required:"true"`

	// The name of the service mesh that the virtual service resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the
	// mesh with your account. For more information about mesh sharing, see Working
	// with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// MeshOwner is a required field
	MeshOwner *string `locationName:"meshOwner" min:"12" type:"string" required:"true"`

	// The Amazon Web Services IAM account ID of the resource owner. If the account
	// ID is not your own, then it's the ID of the mesh owner or of another account
	// that the mesh is shared with. For more information about mesh sharing, see
	// Working with shared meshes (https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" min:"12" type:"string" required:"true"`

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// Version is a required field
	Version *int64 `locationName:"version" type:"long" required:"true"`

	// The name of the virtual service.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualServiceRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualServiceRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VirtualServiceRef) SetArn(v string) *VirtualServiceRef {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *VirtualServiceRef) SetCreatedAt(v time.Time) *VirtualServiceRef {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *VirtualServiceRef) SetLastUpdatedAt(v time.Time) *VirtualServiceRef {
	s.LastUpdatedAt = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualServiceRef) SetMeshName(v string) *VirtualServiceRef {
	s.MeshName = &v
	return s
}

// SetMeshOwner sets the MeshOwner field's value.
func (s *VirtualServiceRef) SetMeshOwner(v string) *VirtualServiceRef {
	s.MeshOwner = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *VirtualServiceRef) SetResourceOwner(v string) *VirtualServiceRef {
	s.ResourceOwner = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *VirtualServiceRef) SetVersion(v int64) *VirtualServiceRef {
	s.Version = &v
	return s
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *VirtualServiceRef) SetVirtualServiceName(v string) *VirtualServiceRef {
	s.VirtualServiceName = &v
	return s
}

// An object that represents the specification of a virtual service.
type VirtualServiceSpec struct {
	_ struct{} `type:"structure"`

	// The App Mesh object that is acting as the provider for a virtual service.
	// You can specify a single virtual node or virtual router.
	Provider *VirtualServiceProvider `locationName:"provider" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualServiceSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualServiceSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualServiceSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualServiceSpec"}
	if s.Provider != nil {
		if err := s.Provider.Validate(); err != nil {
			invalidParams.AddNested("Provider", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProvider sets the Provider field's value.
func (s *VirtualServiceSpec) SetProvider(v *VirtualServiceProvider) *VirtualServiceSpec {
	s.Provider = v
	return s
}

// An object that represents the status of a virtual service.
type VirtualServiceStatus struct {
	_ struct{} `type:"structure"`

	// The current status of the virtual service.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"VirtualServiceStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualServiceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualServiceStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VirtualServiceStatus) SetStatus(v string) *VirtualServiceStatus {
	s.Status = &v
	return s
}

// An object that represents a target and its relative weight. Traffic is distributed
// across targets according to their relative weight. For example, a weighted
// target with a relative weight of 50 receives five times as much traffic as
// one with a relative weight of 10. The total weight for all targets combined
// must be less than or equal to 100.
type WeightedTarget struct {
	_ struct{} `type:"structure"`

	// The targeted port of the weighted object.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The virtual node to associate with the weighted target.
	//
	// VirtualNode is a required field
	VirtualNode *string `locationName:"virtualNode" min:"1" type:"string" required:"true"`

	// The relative weight of the weighted target.
	//
	// Weight is a required field
	Weight *int64 `locationName:"weight" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WeightedTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WeightedTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WeightedTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WeightedTarget"}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.VirtualNode == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNode"))
	}
	if s.VirtualNode != nil && len(*s.VirtualNode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNode", 1))
	}
	if s.Weight == nil {
		invalidParams.Add(request.NewErrParamRequired("Weight"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPort sets the Port field's value.
func (s *WeightedTarget) SetPort(v int64) *WeightedTarget {
	s.Port = &v
	return s
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *WeightedTarget) SetVirtualNode(v string) *WeightedTarget {
	s.VirtualNode = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *WeightedTarget) SetWeight(v int64) *WeightedTarget {
	s.Weight = &v
	return s
}

const (
	// DefaultGatewayRouteRewriteEnabled is a DefaultGatewayRouteRewrite enum value
	DefaultGatewayRouteRewriteEnabled = "ENABLED"

	// DefaultGatewayRouteRewriteDisabled is a DefaultGatewayRouteRewrite enum value
	DefaultGatewayRouteRewriteDisabled = "DISABLED"
)

// DefaultGatewayRouteRewrite_Values returns all elements of the DefaultGatewayRouteRewrite enum
func DefaultGatewayRouteRewrite_Values() []string {
	return []string{
		DefaultGatewayRouteRewriteEnabled,
		DefaultGatewayRouteRewriteDisabled,
	}
}

const (
	// DnsResponseTypeLoadbalancer is a DnsResponseType enum value
	DnsResponseTypeLoadbalancer = "LOADBALANCER"

	// DnsResponseTypeEndpoints is a DnsResponseType enum value
	DnsResponseTypeEndpoints = "ENDPOINTS"
)

// DnsResponseType_Values returns all elements of the DnsResponseType enum
func DnsResponseType_Values() []string {
	return []string{
		DnsResponseTypeLoadbalancer,
		DnsResponseTypeEndpoints,
	}
}

const (
	// DurationUnitS is a DurationUnit enum value
	DurationUnitS = "s"

	// DurationUnitMs is a DurationUnit enum value
	DurationUnitMs = "ms"
)

// DurationUnit_Values returns all elements of the DurationUnit enum
func DurationUnit_Values() []string {
	return []string{
		DurationUnitS,
		DurationUnitMs,
	}
}

const (
	// EgressFilterTypeAllowAll is a EgressFilterType enum value
	EgressFilterTypeAllowAll = "ALLOW_ALL"

	// EgressFilterTypeDropAll is a EgressFilterType enum value
	EgressFilterTypeDropAll = "DROP_ALL"
)

// EgressFilterType_Values returns all elements of the EgressFilterType enum
func EgressFilterType_Values() []string {
	return []string{
		EgressFilterTypeAllowAll,
		EgressFilterTypeDropAll,
	}
}

const (
	// GatewayRouteStatusCodeActive is a GatewayRouteStatusCode enum value
	GatewayRouteStatusCodeActive = "ACTIVE"

	// GatewayRouteStatusCodeInactive is a GatewayRouteStatusCode enum value
	GatewayRouteStatusCodeInactive = "INACTIVE"

	// GatewayRouteStatusCodeDeleted is a GatewayRouteStatusCode enum value
	GatewayRouteStatusCodeDeleted = "DELETED"
)

// GatewayRouteStatusCode_Values returns all elements of the GatewayRouteStatusCode enum
func GatewayRouteStatusCode_Values() []string {
	return []string{
		GatewayRouteStatusCodeActive,
		GatewayRouteStatusCodeInactive,
		GatewayRouteStatusCodeDeleted,
	}
}

const (
	// GrpcRetryPolicyEventCancelled is a GrpcRetryPolicyEvent enum value
	GrpcRetryPolicyEventCancelled = "cancelled"

	// GrpcRetryPolicyEventDeadlineExceeded is a GrpcRetryPolicyEvent enum value
	GrpcRetryPolicyEventDeadlineExceeded = "deadline-exceeded"

	// GrpcRetryPolicyEventInternal is a GrpcRetryPolicyEvent enum value
	GrpcRetryPolicyEventInternal = "internal"

	// GrpcRetryPolicyEventResourceExhausted is a GrpcRetryPolicyEvent enum value
	GrpcRetryPolicyEventResourceExhausted = "resource-exhausted"

	// GrpcRetryPolicyEventUnavailable is a GrpcRetryPolicyEvent enum value
	GrpcRetryPolicyEventUnavailable = "unavailable"
)

// GrpcRetryPolicyEvent_Values returns all elements of the GrpcRetryPolicyEvent enum
func GrpcRetryPolicyEvent_Values() []string {
	return []string{
		GrpcRetryPolicyEventCancelled,
		GrpcRetryPolicyEventDeadlineExceeded,
		GrpcRetryPolicyEventInternal,
		GrpcRetryPolicyEventResourceExhausted,
		GrpcRetryPolicyEventUnavailable,
	}
}

const (
	// HttpMethodGet is a HttpMethod enum value
	HttpMethodGet = "GET"

	// HttpMethodHead is a HttpMethod enum value
	HttpMethodHead = "HEAD"

	// HttpMethodPost is a HttpMethod enum value
	HttpMethodPost = "POST"

	// HttpMethodPut is a HttpMethod enum value
	HttpMethodPut = "PUT"

	// HttpMethodDelete is a HttpMethod enum value
	HttpMethodDelete = "DELETE"

	// HttpMethodConnect is a HttpMethod enum value
	HttpMethodConnect = "CONNECT"

	// HttpMethodOptions is a HttpMethod enum value
	HttpMethodOptions = "OPTIONS"

	// HttpMethodTrace is a HttpMethod enum value
	HttpMethodTrace = "TRACE"

	// HttpMethodPatch is a HttpMethod enum value
	HttpMethodPatch = "PATCH"
)

// HttpMethod_Values returns all elements of the HttpMethod enum
func HttpMethod_Values() []string {
	return []string{
		HttpMethodGet,
		HttpMethodHead,
		HttpMethodPost,
		HttpMethodPut,
		HttpMethodDelete,
		HttpMethodConnect,
		HttpMethodOptions,
		HttpMethodTrace,
		HttpMethodPatch,
	}
}

const (
	// HttpSchemeHttp is a HttpScheme enum value
	HttpSchemeHttp = "http"

	// HttpSchemeHttps is a HttpScheme enum value
	HttpSchemeHttps = "https"
)

// HttpScheme_Values returns all elements of the HttpScheme enum
func HttpScheme_Values() []string {
	return []string{
		HttpSchemeHttp,
		HttpSchemeHttps,
	}
}

const (
	// IpPreferenceIpv6Preferred is a IpPreference enum value
	IpPreferenceIpv6Preferred = "IPv6_PREFERRED"

	// IpPreferenceIpv4Preferred is a IpPreference enum value
	IpPreferenceIpv4Preferred = "IPv4_PREFERRED"

	// IpPreferenceIpv4Only is a IpPreference enum value
	IpPreferenceIpv4Only = "IPv4_ONLY"

	// IpPreferenceIpv6Only is a IpPreference enum value
	IpPreferenceIpv6Only = "IPv6_ONLY"
)

// IpPreference_Values returns all elements of the IpPreference enum
func IpPreference_Values() []string {
	return []string{
		IpPreferenceIpv6Preferred,
		IpPreferenceIpv4Preferred,
		IpPreferenceIpv4Only,
		IpPreferenceIpv6Only,
	}
}

const (
	// ListenerTlsModeStrict is a ListenerTlsMode enum value
	ListenerTlsModeStrict = "STRICT"

	// ListenerTlsModePermissive is a ListenerTlsMode enum value
	ListenerTlsModePermissive = "PERMISSIVE"

	// ListenerTlsModeDisabled is a ListenerTlsMode enum value
	ListenerTlsModeDisabled = "DISABLED"
)

// ListenerTlsMode_Values returns all elements of the ListenerTlsMode enum
func ListenerTlsMode_Values() []string {
	return []string{
		ListenerTlsModeStrict,
		ListenerTlsModePermissive,
		ListenerTlsModeDisabled,
	}
}

const (
	// MeshStatusCodeActive is a MeshStatusCode enum value
	MeshStatusCodeActive = "ACTIVE"

	// MeshStatusCodeInactive is a MeshStatusCode enum value
	MeshStatusCodeInactive = "INACTIVE"

	// MeshStatusCodeDeleted is a MeshStatusCode enum value
	MeshStatusCodeDeleted = "DELETED"
)

// MeshStatusCode_Values returns all elements of the MeshStatusCode enum
func MeshStatusCode_Values() []string {
	return []string{
		MeshStatusCodeActive,
		MeshStatusCodeInactive,
		MeshStatusCodeDeleted,
	}
}

const (
	// PortProtocolHttp is a PortProtocol enum value
	PortProtocolHttp = "http"

	// PortProtocolTcp is a PortProtocol enum value
	PortProtocolTcp = "tcp"

	// PortProtocolHttp2 is a PortProtocol enum value
	PortProtocolHttp2 = "http2"

	// PortProtocolGrpc is a PortProtocol enum value
	PortProtocolGrpc = "grpc"
)

// PortProtocol_Values returns all elements of the PortProtocol enum
func PortProtocol_Values() []string {
	return []string{
		PortProtocolHttp,
		PortProtocolTcp,
		PortProtocolHttp2,
		PortProtocolGrpc,
	}
}

const (
	// RouteStatusCodeActive is a RouteStatusCode enum value
	RouteStatusCodeActive = "ACTIVE"

	// RouteStatusCodeInactive is a RouteStatusCode enum value
	RouteStatusCodeInactive = "INACTIVE"

	// RouteStatusCodeDeleted is a RouteStatusCode enum value
	RouteStatusCodeDeleted = "DELETED"
)

// RouteStatusCode_Values returns all elements of the RouteStatusCode enum
func RouteStatusCode_Values() []string {
	return []string{
		RouteStatusCodeActive,
		RouteStatusCodeInactive,
		RouteStatusCodeDeleted,
	}
}

const (
	// TcpRetryPolicyEventConnectionError is a TcpRetryPolicyEvent enum value
	TcpRetryPolicyEventConnectionError = "connection-error"
)

// TcpRetryPolicyEvent_Values returns all elements of the TcpRetryPolicyEvent enum
func TcpRetryPolicyEvent_Values() []string {
	return []string{
		TcpRetryPolicyEventConnectionError,
	}
}

const (
	// VirtualGatewayListenerTlsModeStrict is a VirtualGatewayListenerTlsMode enum value
	VirtualGatewayListenerTlsModeStrict = "STRICT"

	// VirtualGatewayListenerTlsModePermissive is a VirtualGatewayListenerTlsMode enum value
	VirtualGatewayListenerTlsModePermissive = "PERMISSIVE"

	// VirtualGatewayListenerTlsModeDisabled is a VirtualGatewayListenerTlsMode enum value
	VirtualGatewayListenerTlsModeDisabled = "DISABLED"
)

// VirtualGatewayListenerTlsMode_Values returns all elements of the VirtualGatewayListenerTlsMode enum
func VirtualGatewayListenerTlsMode_Values() []string {
	return []string{
		VirtualGatewayListenerTlsModeStrict,
		VirtualGatewayListenerTlsModePermissive,
		VirtualGatewayListenerTlsModeDisabled,
	}
}

const (
	// VirtualGatewayPortProtocolHttp is a VirtualGatewayPortProtocol enum value
	VirtualGatewayPortProtocolHttp = "http"

	// VirtualGatewayPortProtocolHttp2 is a VirtualGatewayPortProtocol enum value
	VirtualGatewayPortProtocolHttp2 = "http2"

	// VirtualGatewayPortProtocolGrpc is a VirtualGatewayPortProtocol enum value
	VirtualGatewayPortProtocolGrpc = "grpc"
)

// VirtualGatewayPortProtocol_Values returns all elements of the VirtualGatewayPortProtocol enum
func VirtualGatewayPortProtocol_Values() []string {
	return []string{
		VirtualGatewayPortProtocolHttp,
		VirtualGatewayPortProtocolHttp2,
		VirtualGatewayPortProtocolGrpc,
	}
}

const (
	// VirtualGatewayStatusCodeActive is a VirtualGatewayStatusCode enum value
	VirtualGatewayStatusCodeActive = "ACTIVE"

	// VirtualGatewayStatusCodeInactive is a VirtualGatewayStatusCode enum value
	VirtualGatewayStatusCodeInactive = "INACTIVE"

	// VirtualGatewayStatusCodeDeleted is a VirtualGatewayStatusCode enum value
	VirtualGatewayStatusCodeDeleted = "DELETED"
)

// VirtualGatewayStatusCode_Values returns all elements of the VirtualGatewayStatusCode enum
func VirtualGatewayStatusCode_Values() []string {
	return []string{
		VirtualGatewayStatusCodeActive,
		VirtualGatewayStatusCodeInactive,
		VirtualGatewayStatusCodeDeleted,
	}
}

const (
	// VirtualNodeStatusCodeActive is a VirtualNodeStatusCode enum value
	VirtualNodeStatusCodeActive = "ACTIVE"

	// VirtualNodeStatusCodeInactive is a VirtualNodeStatusCode enum value
	VirtualNodeStatusCodeInactive = "INACTIVE"

	// VirtualNodeStatusCodeDeleted is a VirtualNodeStatusCode enum value
	VirtualNodeStatusCodeDeleted = "DELETED"
)

// VirtualNodeStatusCode_Values returns all elements of the VirtualNodeStatusCode enum
func VirtualNodeStatusCode_Values() []string {
	return []string{
		VirtualNodeStatusCodeActive,
		VirtualNodeStatusCodeInactive,
		VirtualNodeStatusCodeDeleted,
	}
}

const (
	// VirtualRouterStatusCodeActive is a VirtualRouterStatusCode enum value
	VirtualRouterStatusCodeActive = "ACTIVE"

	// VirtualRouterStatusCodeInactive is a VirtualRouterStatusCode enum value
	VirtualRouterStatusCodeInactive = "INACTIVE"

	// VirtualRouterStatusCodeDeleted is a VirtualRouterStatusCode enum value
	VirtualRouterStatusCodeDeleted = "DELETED"
)

// VirtualRouterStatusCode_Values returns all elements of the VirtualRouterStatusCode enum
func VirtualRouterStatusCode_Values() []string {
	return []string{
		VirtualRouterStatusCodeActive,
		VirtualRouterStatusCodeInactive,
		VirtualRouterStatusCodeDeleted,
	}
}

const (
	// VirtualServiceStatusCodeActive is a VirtualServiceStatusCode enum value
	VirtualServiceStatusCodeActive = "ACTIVE"

	// VirtualServiceStatusCodeInactive is a VirtualServiceStatusCode enum value
	VirtualServiceStatusCodeInactive = "INACTIVE"

	// VirtualServiceStatusCodeDeleted is a VirtualServiceStatusCode enum value
	VirtualServiceStatusCodeDeleted = "DELETED"
)

// VirtualServiceStatusCode_Values returns all elements of the VirtualServiceStatusCode enum
func VirtualServiceStatusCode_Values() []string {
	return []string{
		VirtualServiceStatusCodeActive,
		VirtualServiceStatusCodeInactive,
		VirtualServiceStatusCodeDeleted,
	}
}
