/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// Condition struct for Condition
type Condition struct {
	Name string `json:"name"yaml:"name"`
	// A Google CEL expression, expressed as a string.
	Expression string `json:"expression"yaml:"expression"`
	// A map of parameter names to the parameter's defined type reference.
	Parameters *map[string]ConditionParamTypeRef `json:"parameters,omitempty"yaml:"parameters,omitempty"`
	Metadata   *ConditionMetadata                `json:"metadata,omitempty"yaml:"metadata,omitempty"`
}

// NewCondition instantiates a new Condition object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCondition(name string, expression string) *Condition {
	this := Condition{}
	this.Name = name
	this.Expression = expression
	return &this
}

// NewConditionWithDefaults instantiates a new Condition object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewConditionWithDefaults() *Condition {
	this := Condition{}
	return &this
}

// GetName returns the Name field value
func (o *Condition) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *Condition) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *Condition) SetName(v string) {
	o.Name = v
}

// GetExpression returns the Expression field value
func (o *Condition) GetExpression() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Expression
}

// GetExpressionOk returns a tuple with the Expression field value
// and a boolean to check if the value has been set.
func (o *Condition) GetExpressionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Expression, true
}

// SetExpression sets field value
func (o *Condition) SetExpression(v string) {
	o.Expression = v
}

// GetParameters returns the Parameters field value if set, zero value otherwise.
func (o *Condition) GetParameters() map[string]ConditionParamTypeRef {
	if o == nil || o.Parameters == nil {
		var ret map[string]ConditionParamTypeRef
		return ret
	}
	return *o.Parameters
}

// GetParametersOk returns a tuple with the Parameters field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Condition) GetParametersOk() (*map[string]ConditionParamTypeRef, bool) {
	if o == nil || o.Parameters == nil {
		return nil, false
	}
	return o.Parameters, true
}

// HasParameters returns a boolean if a field has been set.
func (o *Condition) HasParameters() bool {
	if o != nil && o.Parameters != nil {
		return true
	}

	return false
}

// SetParameters gets a reference to the given map[string]ConditionParamTypeRef and assigns it to the Parameters field.
func (o *Condition) SetParameters(v map[string]ConditionParamTypeRef) {
	o.Parameters = &v
}

// GetMetadata returns the Metadata field value if set, zero value otherwise.
func (o *Condition) GetMetadata() ConditionMetadata {
	if o == nil || o.Metadata == nil {
		var ret ConditionMetadata
		return ret
	}
	return *o.Metadata
}

// GetMetadataOk returns a tuple with the Metadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Condition) GetMetadataOk() (*ConditionMetadata, bool) {
	if o == nil || o.Metadata == nil {
		return nil, false
	}
	return o.Metadata, true
}

// HasMetadata returns a boolean if a field has been set.
func (o *Condition) HasMetadata() bool {
	if o != nil && o.Metadata != nil {
		return true
	}

	return false
}

// SetMetadata gets a reference to the given ConditionMetadata and assigns it to the Metadata field.
func (o *Condition) SetMetadata(v ConditionMetadata) {
	o.Metadata = &v
}

func (o Condition) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["name"] = o.Name
	toSerialize["expression"] = o.Expression
	if o.Parameters != nil {
		toSerialize["parameters"] = o.Parameters
	}
	if o.Metadata != nil {
		toSerialize["metadata"] = o.Metadata
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableCondition struct {
	value *Condition
	isSet bool
}

func (v NullableCondition) Get() *Condition {
	return v.value
}

func (v *NullableCondition) Set(val *Condition) {
	v.value = val
	v.isSet = true
}

func (v NullableCondition) IsSet() bool {
	return v.isSet
}

func (v *NullableCondition) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCondition(val *Condition) *NullableCondition {
	return &NullableCondition{value: val, isSet: true}
}

func (v NullableCondition) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCondition) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
