(****************************************************************************)
(*                           the diy toolsuite                              *)
(*                                                                          *)
(* Jade Alglave, University College London, UK.                             *)
(* Luc Maranget, INRIA Paris-Rocquencourt, France.                          *)
(*                                                                          *)
(* Copyright 2015-present Institut National de Recherche en Informatique et *)
(* en Automatique and the authors. All rights reserved.                     *)
(*                                                                          *)
(* This software is governed by the CeCILL-B license under French law and   *)
(* abiding by the rules of distribution of free software. You can use,      *)
(* modify and/ or redistribute the software under the terms of the CeCILL-B *)
(* license as circulated by CEA, CNRS and INRIA at the following URL        *)
(* "http://www.cecill.info". We also give a copy in LICENSE.txt.            *)
(****************************************************************************)

module type Config = sig
  val verbose : int
  val back : bool (* Backward compatibility *)
  val ppinfo : Lexing.position -> string -> unit
  val env : string StringMap.t
  val map : (string->string) StringMap.t
  val check_name : string -> bool
end

module Make :
 functor (C:Config) -> sig

   val check : string -> unit
   val rewrite : string -> unit

   val check_chan : in_channel -> unit
   val rewrite_chan : in_channel -> unit

 end
