export function deepFreeze(obj) {
  // On récupère les noms des propriétés définies sur obj
  var propNames = Object.getOwnPropertyNames(obj);

  // On gèle les propriétés avant de geler l'objet
  for (let name of propNames) {
    let value = obj[name];
    obj[name] = value && typeof value === "object" ? deepFreeze(value) : value;
  }

  // On gèle l'objet initial
  return Object.freeze(obj);
}

export default deepFreeze
