#ifndef JGMENU_SCHEMA_H
#define JGMENU_SCHEMA_H

/*
 * Schema to map categories to directories without involving XDG menu spec.
 *
 * Translations are copied from xfce's libgarcon under GPL2
 */

struct key_value_pair {
	char *key;
	char *value;
};

/* clang-format off */
static struct key_value_pair schema_builtin[] = {
	{ "Name", "Accessories" },
	{ "Name[am]", "ተጨማሪዎች" },
	{ "Name[ar]", "ملحقات" },
	{ "Name[ast]", "Accesorios" },
	{ "Name[be]", "Інструменты" },
	{ "Name[bg]", "Помощни програми" },
	{ "Name[ca]", "Accessoris" },
	{ "Name[cs]", "Příslušenství" },
	{ "Name[cy]", "Ategolion" },
	{ "Name[da]", "Tilbehør" },
	{ "Name[de]", "Zubehör" },
	{ "Name[el]", "Βοηθήματα" },
	{ "Name[en_AU]", "Accessories" },
	{ "Name[en_GB]", "Accessories" },
	{ "Name[eo]", "Akcesoraĵoj" },
	{ "Name[es]", "Accesorios" },
	{ "Name[et]", "Tarvikud" },
	{ "Name[eu]", "Gehigarriak" },
	{ "Name[fi]", "Apuohjelmat" },
	{ "Name[fr]", "Accessoires" },
	{ "Name[gl]", "Accesorios" },
	{ "Name[he]", "עזרים" },
	{ "Name[hr]", "Pomagala" },
	{ "Name[hu]", "Kellékek" },
	{ "Name[id]", "Aksesoris" },
	{ "Name[is]", "Aukahlutir" },
	{ "Name[it]", "Accessori" },
	{ "Name[ja]", "アクセサリ" },
	{ "Name[kk]", "Қалыпты" },
	{ "Name[ko]", "보조프로그램" },
	{ "Name[lt]", "Reikmenys" },
	{ "Name[ms]", "Aksesori" },
	{ "Name[nb]", "Tilbehør" },
	{ "Name[nl]", "Hulpmiddelen" },
	{ "Name[nn]", "Ymse" },
	{ "Name[oc]", "Accessòris" },
	{ "Name[pl]", "Akcesoria" },
	{ "Name[pt]", "Acessórios" },
	{ "Name[pt_BR]", "Acessórios" },
	{ "Name[ro]", "Accesorii" },
	{ "Name[ru]", "Инструменты" },
	{ "Name[sk]", "Príslušenstvo" },
	{ "Name[sl]", "Pripomočki" },
	{ "Name[sq]", "Aksesorë" },
	{ "Name[sr]", "Прибор" },
	{ "Name[sv]", "Tillbehör" },
	{ "Name[te]", "సహాయకాలు" },
	{ "Name[th]", "เครื่องใช้ไม้สอย" },
	{ "Name[tr]", "Donatılar" },
	{ "Name[ug]", "قوشۇمچە دېتاللار" },
	{ "Name[uk]", "Інструменти" },
	{ "Name[uz]", "Tizim vositalari" },
	{ "Name[uz@Latn]", "Tizim vositalari" },
	{ "Name[zh_CN]", "附件" },
	{ "Name[zh_HK]", "附屬應用" },
	{ "Name[zh_TW]", "附屬應用" },
	{ "Icon", "applications-accessories" },
	{ "Categories", "Accessibility;Core;Utility;" },

	{ "Name", "Development" },
	{ "Name[am]", "አበልፃጊዎች" },
	{ "Name[ar]", "تطوير" },
	{ "Name[ast]", "Desendolcu" },
	{ "Name[be]", "Распрацоўка" },
	{ "Name[bg]", "Разработка" },
	{ "Name[ca]", "Desenvolupament" },
	{ "Name[cs]", "Vývoj" },
	{ "Name[cy]", "Datblygu" },
	{ "Name[da]", "Udvikling" },
	{ "Name[de]", "Entwicklung" },
	{ "Name[el]", "Ανάπτυξη" },
	{ "Name[en_AU]", "Development" },
	{ "Name[en_GB]", "Development" },
	{ "Name[eo]", "Programado" },
	{ "Name[es]", "Desarrollo" },
	{ "Name[et]", "Arendus" },
	{ "Name[eu]", "Garapena" },
	{ "Name[fi]", "Ohjelmistokehitys" },
	{ "Name[fr]", "Développement" },
	{ "Name[gl]", "Desenvolvemento" },
	{ "Name[he]", "פיתוח" },
	{ "Name[hr]", "Razvoj" },
	{ "Name[hu]", "Fejlesztés" },
	{ "Name[id]", "Pengembangan" },
	{ "Name[is]", "Forritun" },
	{ "Name[it]", "Sviluppo" },
	{ "Name[ja]", "開発" },
	{ "Name[kk]", "Өндіру" },
	{ "Name[ko]", "개발" },
	{ "Name[lt]", "Kūrimas" },
	{ "Name[ms]", "Pembangunan" },
	{ "Name[nb]", "Utvikling" },
	{ "Name[nl]", "Ontwikkeling" },
	{ "Name[nn]", "Utvikling" },
	{ "Name[oc]", "Desvolopament" },
	{ "Name[pl]", "Programowanie" },
	{ "Name[pt]", "Desenvolvimento" },
	{ "Name[pt_BR]", "Desenvolvimento" },
	{ "Name[ro]", "Dezvoltare" },
	{ "Name[ru]", "Разработка" },
	{ "Name[sk]", "Vývoj" },
	{ "Name[sl]", "Razvoj" },
	{ "Name[sq]", "Zhvillim" },
	{ "Name[sr]", "Развој" },
	{ "Name[sv]", "Utveckling" },
	{ "Name[te]", "అభివృద్ధి" },
	{ "Name[th]", "พัฒนาโปรแกรม" },
	{ "Name[tr]", "Geliştirme" },
	{ "Name[ug]", "ئىجادىيەت" },
	{ "Name[uk]", "Розробка" },
	{ "Name[uz]", "Tuzish" },
	{ "Name[uz@Latn]", "Tuzish" },
	{ "Name[zh_CN]", "开发" },
	{ "Name[zh_HK]", "開發" },
	{ "Name[zh_TW]", "開發" },
	{ "Icon", "applications-development" },
	{ "Categories", "Development;" },

	{ "Name", "Education" },
	{ "Name[am]", "ትምህርት" },
	{ "Name[ar]", "تعليم" },
	{ "Name[ast]", "Educación" },
	{ "Name[be]", "Адукацыя" },
	{ "Name[bg]", "Образование" },
	{ "Name[ca]", "Educació" },
	{ "Name[cs]", "Vzdělávání" },
	{ "Name[cy]", "Addysg" },
	{ "Name[da]", "Uddannelse" },
	{ "Name[de]", "Bildung" },
	{ "Name[el]", "Εκπαίδευση" },
	{ "Name[en_AU]", "Education" },
	{ "Name[en_GB]", "Education" },
	{ "Name[eo]", "Edukado" },
	{ "Name[es]", "Educación" },
	{ "Name[et]", "Haridus" },
	{ "Name[eu]", "Hezkuntza" },
	{ "Name[fi]", "Opetus" },
	{ "Name[fr]", "Éducation" },
	{ "Name[gl]", "Educación" },
	{ "Name[he]", "לומדות" },
	{ "Name[hi]", "शिक्षा" },
	{ "Name[hr]", "Obrazovanje" },
	{ "Name[hu]", "Oktatás" },
	{ "Name[id]", "Edukasi" },
	{ "Name[is]", "Menntun" },
	{ "Name[it]", "Istruzione" },
	{ "Name[ja]", "教育" },
	{ "Name[kk]", "Білім алу" },
	{ "Name[ko]", "교육" },
	{ "Name[lt]", "Švietimas" },
	{ "Name[ms]", "Pendidikan" },
	{ "Name[nb]", "Utdannelse" },
	{ "Name[nl]", "Onderwijs" },
	{ "Name[nn]", "Læring" },
	{ "Name[oc]", "Educacion" },
	{ "Name[pl]", "Edukacja" },
	{ "Name[pt]", "Educação" },
	{ "Name[pt_BR]", "Educação" },
	{ "Name[ro]", "Educație" },
	{ "Name[ru]", "Образование" },
	{ "Name[sk]", "Vzdelávanie" },
	{ "Name[sl]", "Izobraževanje" },
	{ "Name[sq]", "Edukim" },
	{ "Name[sr]", "Образовање" },
	{ "Name[sv]", "Utbildning" },
	{ "Name[te]", "విద్య" },
	{ "Name[th]", "การศึกษา" },
	{ "Name[tr]", "Eğitim" },
	{ "Name[ug]", "مائارىپ" },
	{ "Name[uk]", "Навчання" },
	{ "Name[uz]", "Ta'lim" },
	{ "Name[uz@Latn]", "Ta'lim" },
	{ "Name[zh_CN]", "教育" },
	{ "Name[zh_HK]", "教育" },
	{ "Name[zh_TW]", "教育" },
	{ "Icon", "applications-science" },
	{ "Categories", "Education;" },

	{ "Name", "Games" },
	{ "Name[am]", "ጨዋታዎች" },
	{ "Name[ar]", "ألعاب" },
	{ "Name[ast]", "Xuegos" },
	{ "Name[be]", "Гульні" },
	{ "Name[bg]", "Игри" },
	{ "Name[ca]", "Jocs" },
	{ "Name[cs]", "Hry" },
	{ "Name[cy]", "Gemau" },
	{ "Name[da]", "Spil" },
	{ "Name[de]", "Spiele" },
	{ "Name[el]", "Παιχνίδια" },
	{ "Name[en_AU]", "Games" },
	{ "Name[en_GB]", "Games" },
	{ "Name[eo]", "Ludoj" },
	{ "Name[es]", "Juegos" },
	{ "Name[et]", "Mängud" },
	{ "Name[eu]", "Jokoak" },
	{ "Name[fi]", "Pelit" },
	{ "Name[fr]", "Jeux" },
	{ "Name[gl]", "Xogos" },
	{ "Name[he]", "משחקים" },
	{ "Name[hi]", "खेल" },
	{ "Name[hr]", "Igre" },
	{ "Name[hu]", "Játékok" },
	{ "Name[id]", "Permainan" },
	{ "Name[is]", "Leikir" },
	{ "Name[it]", "Giochi" },
	{ "Name[ja]", "ゲーム" },
	{ "Name[kk]", "Ойындар" },
	{ "Name[ko]", "게임" },
	{ "Name[lt]", "Žaidimai" },
	{ "Name[ms]", "Permainan" },
	{ "Name[nb]", "Spill" },
	{ "Name[nl]", "Spelletjes" },
	{ "Name[nn]", "Spel" },
	{ "Name[oc]", "Jòcs" },
	{ "Name[pl]", "Gry" },
	{ "Name[pt]", "Jogos" },
	{ "Name[pt_BR]", "Jogos" },
	{ "Name[ro]", "Jocuri" },
	{ "Name[ru]", "Игры" },
	{ "Name[sk]", "Hry" },
	{ "Name[sl]", "Igre" },
	{ "Name[sq]", "Lojëra" },
	{ "Name[sr]", "Игре" },
	{ "Name[sv]", "Spel" },
	{ "Name[te]", "ఆటలు" },
	{ "Name[th]", "เกม" },
	{ "Name[tr]", "Oyunlar" },
	{ "Name[ug]", "ئويۇن" },
	{ "Name[uk]", "Ігри" },
	{ "Name[uz]", "O'yinlar" },
	{ "Name[uz@Latn]", "O'yinlar" },
	{ "Name[zh_CN]", "游戏" },
	{ "Name[zh_HK]", "遊戲" },
	{ "Name[zh_TW]", "遊戲" },
	{ "Icon", "applications-games" },
	{ "Categories", "Game;" },

	{ "Name", "Graphics" },
	{ "Name[am]", "ንድፎች" },
	{ "Name[ar]", "رسوميات" },
	{ "Name[ast]", "Gráficos" },
	{ "Name[be]", "Графіка" },
	{ "Name[bg]", "Графика" },
	{ "Name[ca]", "Gràfics" },
	{ "Name[cs]", "Grafika" },
	{ "Name[cy]", "Graffeg" },
	{ "Name[da]", "Grafik" },
	{ "Name[de]", "Grafik" },
	{ "Name[el]", "Γραφικά" },
	{ "Name[en_AU]", "Graphics" },
	{ "Name[en_GB]", "Graphics" },
	{ "Name[eo]", "Grafikoj" },
	{ "Name[es]", "Gráficos" },
	{ "Name[et]", "Graafika" },
	{ "Name[eu]", "Grafikoak" },
	{ "Name[fi]", "Grafiikka" },
	{ "Name[fr]", "Graphisme" },
	{ "Name[gl]", "Imaxes" },
	{ "Name[he]", "גרפיקה" },
	{ "Name[hi]", "ग्राफ़िक्स" },
	{ "Name[hr]", "Grafika" },
	{ "Name[hu]", "Grafika" },
	{ "Name[id]", "Grafis" },
	{ "Name[is]", "Myndvinnsla" },
	{ "Name[it]", "Grafica" },
	{ "Name[ja]", "グラフィックス" },
	{ "Name[kk]", "Бейнелеу" },
	{ "Name[ko]", "그래픽" },
	{ "Name[lt]", "Grafika" },
	{ "Name[ms]", "Grafik" },
	{ "Name[nb]", "Grafikk" },
	{ "Name[nl]", "Afbeeldingen" },
	{ "Name[nn]", "Grafikk" },
	{ "Name[oc]", "Infografia" },
	{ "Name[pl]", "Grafika" },
	{ "Name[pt]", "Gráficos" },
	{ "Name[pt_BR]", "Gráficos" },
	{ "Name[ro]", "Grafică" },
	{ "Name[ru]", "Графика" },
	{ "Name[sk]", "Grafika" },
	{ "Name[sl]", "Grafika" },
	{ "Name[sq]", "Grafika" },
	{ "Name[sr]", "Цртање" },
	{ "Name[sv]", "Grafik" },
	{ "Name[te]", "రేఖాచిత్రాలు" },
	{ "Name[th]", "รูปภาพ" },
	{ "Name[tr]", "Grafikler" },
	{ "Name[ug]", "گرافىك" },
	{ "Name[uk]", "Графіка" },
	{ "Name[uz]", "Grafika" },
	{ "Name[uz@Latn]", "Grafika" },
	{ "Name[zh_CN]", "图形" },
	{ "Name[zh_HK]", "美工繪圖" },
	{ "Name[zh_TW]", "美工繪圖" },
	{ "Icon", "applications-graphics" },
	{ "Categories", "Graphics;" },

	{ "Name", "Multimedia" },
	{ "Name[am]", "ብዙሀን መገናኛ" },
	{ "Name[ar]", "وسائط المتعددة" },
	{ "Name[ast]", "Multimedia" },
	{ "Name[be]", "Мультымедыя" },
	{ "Name[bg]", "Мултимедия" },
	{ "Name[ca]", "Multimèdia" },
	{ "Name[cs]", "Multimédia" },
	{ "Name[cy]", "Amlgyfryngau" },
	{ "Name[da]", "Multimedie" },
	{ "Name[de]", "Multimedia" },
	{ "Name[el]", "Πολυμέσα" },
	{ "Name[en_AU]", "Multimedia" },
	{ "Name[en_GB]", "Multimedia" },
	{ "Name[eo]", "Plurmedio" },
	{ "Name[es]", "Multimedia" },
	{ "Name[et]", "Multimeedia" },
	{ "Name[eu]", "Multimedia" },
	{ "Name[fi]", "Ääni ja video" },
	{ "Name[fr]", "Multimédia" },
	{ "Name[gl]", "Multimedia" },
	{ "Name[he]", "מולטימדיה" },
	{ "Name[hi]", "मल्टीमीडिया" },
	{ "Name[hr]", "Multimedija" },
	{ "Name[hu]", "Multimédia" },
	{ "Name[id]", "Multimedia" },
	{ "Name[is]", "Margmiðlun" },
	{ "Name[it]", "Multimedia" },
	{ "Name[ja]", "マルチメディア" },
	{ "Name[kk]", "Мультимедиа" },
	{ "Name[ko]", "멀티미디어" },
	{ "Name[lt]", "Garsas ir vaizdas" },
	{ "Name[ms]", "Multimedia" },
	{ "Name[nb]", "Multimedia" },
	{ "Name[nl]", "Multimedia" },
	{ "Name[nn]", "Multimedia" },
	{ "Name[oc]", "Multimèdia" },
	{ "Name[pl]", "Multimedia" },
	{ "Name[pt]", "Multimédia" },
	{ "Name[pt_BR]", "Multimídia" },
	{ "Name[ro]", "Multimedia" },
	{ "Name[ru]", "Мультимедиа" },
	{ "Name[sk]", "Multimédiá" },
	{ "Name[sl]", "Predstavnost" },
	{ "Name[sq]", "Multimedia" },
	{ "Name[sr]", "Звук и видео" },
	{ "Name[sv]", "Multimedia" },
	{ "Name[te]", "బహుళమాధ్యమం" },
	{ "Name[th]", "สื่อผสม" },
	{ "Name[tr]", "Çokluortam" },
	{ "Name[ug]", "كۆپ ۋاسىتە" },
	{ "Name[uk]", "Мультимедіа" },
	{ "Name[uz]", "Multimedia" },
	{ "Name[uz@Latn]", "Multimedia" },
	{ "Name[zh_CN]", "多媒体" },
	{ "Name[zh_HK]", "多媒體" },
	{ "Name[zh_TW]", "多媒體" },
	{ "Icon", "applications-multimedia" },
	{ "Categories", "Audio;Video;AudioVideo;" },

	{ "Name", "Internet" },
	{ "Name[am]", "ኢንተርኔት" },
	{ "Name[ar]", "إنترنت" },
	{ "Name[ast]", "Internet" },
	{ "Name[be]", "Інтэрнэт" },
	{ "Name[bg]", "Интернет" },
	{ "Name[ca]", "Internet" },
	{ "Name[cs]", "Internet" },
	{ "Name[cy]", "Rhyngrwyd" },
	{ "Name[da]", "Internet" },
	{ "Name[de]", "Internet" },
	{ "Name[el]", "Διαδίκτυο" },
	{ "Name[en_AU]", "Internet" },
	{ "Name[en_GB]", "Internet" },
	{ "Name[eo]", "Interreto" },
	{ "Name[es]", "Internet" },
	{ "Name[et]", "Internet" },
	{ "Name[eu]", "Internet" },
	{ "Name[fi]", "Internet" },
	{ "Name[fr]", "Internet" },
	{ "Name[gl]", "Internet" },
	{ "Name[he]", "אינטרנט" },
	{ "Name[hi]", "इंटरनेट" },
	{ "Name[hr]", "Internet" },
	{ "Name[hu]", "Internet" },
	{ "Name[id]", "Internet" },
	{ "Name[is]", "Internetið" },
	{ "Name[it]", "Internet" },
	{ "Name[ja]", "インターネット" },
	{ "Name[kk]", "Интернет" },
	{ "Name[ko]", "인터넷" },
	{ "Name[lt]", "Internetas" },
	{ "Name[ms]", "Internet" },
	{ "Name[nb]", "Internett" },
	{ "Name[nl]", "Internet" },
	{ "Name[nn]", "Internett" },
	{ "Name[oc]", "Internet" },
	{ "Name[pl]", "Internet" },
	{ "Name[pt]", "Internet" },
	{ "Name[pt_BR]", "Internet" },
	{ "Name[ro]", "Internet" },
	{ "Name[ru]", "Интернет" },
	{ "Name[sk]", "Internet" },
	{ "Name[sl]", "Internet" },
	{ "Name[sq]", "Internet" },
	{ "Name[sr]", "Интернет" },
	{ "Name[sv]", "Internet" },
	{ "Name[te]", "అంతర్జాలం" },
	{ "Name[th]", "อินเทอร์เน็ต" },
	{ "Name[tr]", "İnternet" },
	{ "Name[ug]", "ئىنتېرنېت" },
	{ "Name[uk]", "Інтернет" },
	{ "Name[uz]", "Internet" },
	{ "Name[uz@Latn]", "Internet" },
	{ "Name[zh_CN]", "互联网" },
	{ "Name[zh_HK]", "互聯網" },
	{ "Name[zh_TW]", "網際網路" },
	{ "Icon", "applications-internet" },
	{ "Categories", "Network;" },

	{ "Name", "Office" },
	{ "Name[am]", "ቢሮ" },
	{ "Name[ar]", "مكتب" },
	{ "Name[ast]", "Oficina" },
	{ "Name[be]", "Офіс" },
	{ "Name[bg]", "Офис" },
	{ "Name[ca]", "Ofimàtica" },
	{ "Name[cs]", "Kancelář" },
	{ "Name[cy]", "Swyddfa" },
	{ "Name[da]", "Kontor" },
	{ "Name[de]", "Büro" },
	{ "Name[el]", "Γραφείο" },
	{ "Name[en_AU]", "Office" },
	{ "Name[en_GB]", "Office" },
	{ "Name[eo]", "Oficejo" },
	{ "Name[es]", "Oficina" },
	{ "Name[et]", "Kontor" },
	{ "Name[eu]", "Bulegoa" },
	{ "Name[fi]", "Toimisto" },
	{ "Name[fr]", "Bureautique" },
	{ "Name[gl]", "Oficina" },
	{ "Name[he]", "משרד" },
	{ "Name[hi]", "ऑफिस" },
	{ "Name[hr]", "Ured" },
	{ "Name[hu]", "Iroda" },
	{ "Name[id]", "Perkantoran" },
	{ "Name[is]", "Skrifstofuforrit" },
	{ "Name[it]", "Ufficio" },
	{ "Name[ja]", "オフィス" },
	{ "Name[kk]", "Кеңселік" },
	{ "Name[ko]", "사무" },
	{ "Name[lt]", "Raštinė" },
	{ "Name[ms]", "Pejabat" },
	{ "Name[nb]", "Kontor" },
	{ "Name[nl]", "Kantoor" },
	{ "Name[nn]", "Kontor" },
	{ "Name[oc]", "Burèu" },
	{ "Name[pl]", "Biuro" },
	{ "Name[pt]", "Produtividade" },
	{ "Name[pt_BR]", "Escritório" },
	{ "Name[ro]", "Birou" },
	{ "Name[ru]", "Офис" },
	{ "Name[sk]", "Kancelária" },
	{ "Name[sl]", "Pisarna" },
	{ "Name[sq]", "Zyrë" },
	{ "Name[sr]", "Уред" },
	{ "Name[sv]", "Kontorsprogram" },
	{ "Name[te]", "కార్యాలయం" },
	{ "Name[th]", "สำนักงาน" },
	{ "Name[tr]", "Ofis" },
	{ "Name[ug]", "ئىشخانا" },
	{ "Name[uk]", "Офісні" },
	{ "Name[uz]", "Ofis" },
	{ "Name[uz@Latn]", "Ofis" },
	{ "Name[zh_CN]", "办公" },
	{ "Name[zh_HK]", "辦公" },
	{ "Name[zh_TW]", "辦公" },
	{ "Icon", "applications-office" },
	{ "Categories", "Office;" },

	{ "Name", "Other" },
	{ "Name[am]", "ሌላ" },
	{ "Name[ar]", "أخرى" },
	{ "Name[ast]", "Otru" },
	{ "Name[be]", "Іншыя праграмы" },
	{ "Name[bg]", "Други" },
	{ "Name[ca]", "Altres" },
	{ "Name[cs]", "Ostatní" },
	{ "Name[cy]", "Arall" },
	{ "Name[da]", "Andre" },
	{ "Name[de]", "Sonstiges" },
	{ "Name[el]", "Άλλα" },
	{ "Name[en_AU]", "Other" },
	{ "Name[en_GB]", "Other" },
	{ "Name[eo]", "Alio" },
	{ "Name[es]", "Otras" },
	{ "Name[et]", "Teised" },
	{ "Name[eu]", "Besteak" },
	{ "Name[fi]", "Muut" },
	{ "Name[fr]", "Autres" },
	{ "Name[gl]", "Outro" },
	{ "Name[he]", "שונות" },
	{ "Name[hi]", "अन्य" },
	{ "Name[hr]", "Ostalo" },
	{ "Name[hu]", "Egyéb" },
	{ "Name[id]", "Lainnya" },
	{ "Name[is]", "Annað" },
	{ "Name[it]", "Altro" },
	{ "Name[ja]", "その他" },
	{ "Name[kk]", "Басқалар" },
	{ "Name[ko]", "기타" },
	{ "Name[lt]", "Kita" },
	{ "Name[ms]", "Lain-lain" },
	{ "Name[nb]", "Diverse" },
	{ "Name[nl]", "Overige" },
	{ "Name[nn]", "Andre" },
	{ "Name[oc]", "Autres" },
	{ "Name[pl]", "Inne" },
	{ "Name[pt]", "Outras" },
	{ "Name[pt_BR]", "Outros" },
	{ "Name[ro]", "Altele" },
	{ "Name[ru]", "Прочее" },
	{ "Name[sk]", "Ostatné" },
	{ "Name[sl]", "Ostalo" },
	{ "Name[sq]", "Tjetër" },
	{ "Name[sr]", "Остало" },
	{ "Name[sv]", "Övrigt" },
	{ "Name[te]", "ఇతర" },
	{ "Name[th]", "อื่นๆ" },
	{ "Name[tr]", "Diğer" },
	{ "Name[ug]", "باشقىلار" },
	{ "Name[uk]", "Інше" },
	{ "Name[uz]", "Boshqa" },
	{ "Name[uz@Latn]", "Boshqa" },
	{ "Name[zh_CN]", "其它" },
	{ "Name[zh_HK]", "其他" },
	{ "Name[zh_TW]", "其他" },
	{ "Icon", "applications-other" },

	{ "Name", "Settings" },
	{ "Name[am]", "ማሰናጃዎች" },
	{ "Name[ar]", "الإعدادات" },
	{ "Name[ast]", "Axustes" },
	{ "Name[be]", "Налады" },
	{ "Name[bg]", "Настройки" },
	{ "Name[ca]", "Ajusts" },
	{ "Name[cs]", "Nastavení" },
	{ "Name[cy]", "Gosodiadau" },
	{ "Name[da]", "Indstillinger" },
	{ "Name[de]", "Einstellungen" },
	{ "Name[el]", "Ρυθμίσεις" },
	{ "Name[en_AU]", "Settings" },
	{ "Name[en_GB]", "Settings" },
	{ "Name[eo]", "Agordoj" },
	{ "Name[es]", "Configuración" },
	{ "Name[et]", "Seaded" },
	{ "Name[eu]", "Ezarpenak" },
	{ "Name[fi]", "Asetukset" },
	{ "Name[fr]", "Paramètres" },
	{ "Name[gl]", "Configuración" },
	{ "Name[he]", "הגדרות" },
	{ "Name[hi]", "सेटिंग्स" },
	{ "Name[hr]", "Postavke" },
	{ "Name[hu]", "Beállítások" },
	{ "Name[id]", "Konfigurasi" },
	{ "Name[is]", "Stillingar" },
	{ "Name[it]", "Impostazioni" },
	{ "Name[ja]", "設定" },
	{ "Name[kk]", "Баптаулар" },
	{ "Name[ko]", "설정" },
	{ "Name[lt]", "Nustatymai" },
	{ "Name[ms]", "Tetapan" },
	{ "Name[nb]", "Innstillinger" },
	{ "Name[nl]", "Instellingen" },
	{ "Name[nn]", "Innstillingar" },
	{ "Name[oc]", "Paramètres" },
	{ "Name[pl]", "Ustawienia" },
	{ "Name[pt]", "Definições" },
	{ "Name[pt_BR]", "Configurações" },
	{ "Name[ro]", "Opțiuni" },
	{ "Name[ru]", "Настройки" },
	{ "Name[sk]", "Nastavenia" },
	{ "Name[sl]", "Nastavitve" },
	{ "Name[sq]", "Rregullime" },
	{ "Name[sr]", "Поставке" },
	{ "Name[sv]", "Inställningar" },
	{ "Name[te]", "అమరికలు" },
	{ "Name[th]", "ตั้งค่า" },
	{ "Name[tr]", "Ayarlar" },
	{ "Name[ug]", "تەڭشەكلەر" },
	{ "Name[uk]", "Налаштування" },
	{ "Name[uz]", "Moslamalar" },
	{ "Name[uz@Latn]", "Moslamalar" },
	{ "Name[zh_CN]", "设置" },
	{ "Name[zh_HK]", "設定" },
	{ "Name[zh_TW]", "設定值" },
	{ "Icon", "preferences-desktop" },
	{ "Categories", "Settings;Screensaver;" },

	{ "Name", "System" },
	{ "Name[am]", "ስርአት" },
	{ "Name[ar]", "النّظام" },
	{ "Name[ast]", "Sistema" },
	{ "Name[be]", "Сістэма" },
	{ "Name[bg]", "Система" },
	{ "Name[ca]", "Sistema" },
	{ "Name[cs]", "Systém" },
	{ "Name[cy]", "System" },
	{ "Name[da]", "System" },
	{ "Name[de]", "System" },
	{ "Name[el]", "Σύστημα" },
	{ "Name[en_AU]", "System" },
	{ "Name[en_GB]", "System" },
	{ "Name[eo]", "Sistemo" },
	{ "Name[es]", "Sistema" },
	{ "Name[et]", "Süsteem" },
	{ "Name[eu]", "Sistema" },
	{ "Name[fi]", "Järjestelmä" },
	{ "Name[fr]", "Système" },
	{ "Name[gl]", "Sistema" },
	{ "Name[he]", "מערכת" },
	{ "Name[hi]", "सिस्टम" },
	{ "Name[hr]", "Sustav" },
	{ "Name[hu]", "Rendszer" },
	{ "Name[id]", "Sistem" },
	{ "Name[is]", "Kerfið" },
	{ "Name[it]", "Sistema" },
	{ "Name[ja]", "システム" },
	{ "Name[kk]", "Жүйелік" },
	{ "Name[ko]", "시스템" },
	{ "Name[lt]", "Sistema" },
	{ "Name[ms]", "Sistem" },
	{ "Name[nb]", "System" },
	{ "Name[nl]", "Systeem" },
	{ "Name[nn]", "System" },
	{ "Name[oc]", "Sistèma" },
	{ "Name[pl]", "System" },
	{ "Name[pt]", "Sistema" },
	{ "Name[pt_BR]", "Sistema" },
	{ "Name[ro]", "Sistem" },
	{ "Name[ru]", "Система" },
	{ "Name[sk]", "Systém" },
	{ "Name[sl]", "Sistem" },
	{ "Name[sq]", "Sistem" },
	{ "Name[sr]", "Систем" },
	{ "Name[sv]", "System" },
	{ "Name[te]", "వ్యవస్థ" },
	{ "Name[th]", "ระบบ" },
	{ "Name[tr]", "Sistem" },
	{ "Name[ug]", "سىستېما" },
	{ "Name[uk]", "Система" },
	{ "Name[uz]", "Tizim" },
	{ "Name[uz@Latn]", "Tizim" },
	{ "Name[zh_CN]", "系统" },
	{ "Name[zh_HK]", "系統" },
	{ "Name[zh_TW]", "系統" },
	{ "Icon", "applications-system" },
	{ "Categories", "Emulator;System;" },

	{ NULL, NULL }
};

/* clang-format on */

#endif /* JGMENU_SCHEMA_H */
