// Copyright Keith D Gregory
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package net.sf.kdgcommons.net;


/**
 *  Static defines for standard HTTP headers, to prevent typos.
 */
public class HttpHeaders
{
    public final static String  ACCEPT                  = "Accept";
    public final static String  ACCEPT_CHARSET          = "Accept-Charset";
    public final static String  ACCEPT_ENCODING         = "Accept-Encoding";
    public final static String  ACCEPT_LANGUAGE         = "Accept-Language";
    public final static String  ACCEPT_RANGES           = "Accept-Ranges";
    public final static String  AGE                     = "Age";
    public final static String  ALLOW                   = "Allow";
    public final static String  AUTHORIZATION           = "Authorization";
    public final static String  CACHE_CONTROL           = "Cache-Control";
    public final static String  CONNECTION              = "Connection";
    public final static String  CONTENT_ENCODING        = "Content-Encoding";
    public final static String  CONTENT_LANGUAGE        = "Content-Language";
    public final static String  CONTENT_LENGTH          = "Content-Length";
    public final static String  CONTENT_LOCATION        = "Content-Location";
    public final static String  CONTENT_MD5             = "Content-MD5";
    public final static String  CONTENT_RANGE           = "Content-Range";
    public final static String  CONTENT_TYPE            = "Content-Type";
    public final static String  DATE                    = "Date";
    public final static String  ETAG                    = "ETag";
    public final static String  EXPECT                  = "Expect";
    public final static String  EXPIRES                 = "Expires";
    public final static String  FROM                    = "From";
    public final static String  HOST                    = "Host";
    public final static String  IF_MATCH                = "If-Match";
    public final static String  IF_MODIFIED_SINCE       = "If-Modified-Since";
    public final static String  IF_NONE_MATCH           = "If-None-Match";
    public final static String  IF_RANGE                = "If-Range";
    public final static String  IF_UNMODIFIED_SINCE     = "If-Unmodified-Since";
    public final static String  LAST_MODIFIED           = "Last-Modified";
    public final static String  LOCATION                = "Location";
    public final static String  MAX_FORWARDS            = "Max-Forwards";
    public final static String  PRAGMA                  = "Pragma";
    public final static String  PROXY_AUTHENTICATE      = "Proxy-Authenticate";
    public final static String  PROXY_AUTHORIZATION     = "Proxy-Authorization";
    public final static String  RANGE                   = "Range";
    public final static String  REFERER                 = "Referer";
    public final static String  RETRY_AFTER             = "Retry-After";
    public final static String  SERVER                  = "Server";
    public final static String  TE                      = "TE";
    public final static String  TRAILER                 = "Trailer";
    public final static String  TRANSFER_ENCODING       = "Transfer-Encoding";
    public final static String  UPGRADE                 = "Upgrade";
    public final static String  USER_AGENT              = "User-Agent";
    public final static String  VARY                    = "Vary";
    public final static String  VIA                     = "Via";
    public final static String  WARNING                 = "Warning";
    public final static String  WWW_AUTHENTICATE        = "WWW-Authenticate";
}
