# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.context_item import ContextItem


class ChartXYZ(ContextItem):
    r"""
    ChartXYZ - Factory class for drawing 3D XYZ charts.
    
    Superclass: ContextItem
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkChartXYZ, obj, update, **traits)
    
    def get_axis(self, *args):
        """
        get_axis(self, axis:int) -> Axis
        C++: Axis *get_axis(int axis)
        Get the x (0), y (1) or z (2) axis.
        """
        ret = self._wrap_call(self._vtk_obj.GetAxis, *args)
        return wrap_vtk(ret)

    def set_axis(self, *args):
        """
        set_axis(self, axisIndex:int, axis:Axis) -> None
        C++: virtual void set_axis(int axisIndex, Axis *axis)
        Set the x (0), y (1) or z (2) axis.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetAxis, *my_args)
        return ret

    clipping_planes_enabled = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        r"""
        Hide data outside the box.
        """
    )

    def _clipping_planes_enabled_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetClippingPlanesEnabled,
                        self.clipping_planes_enabled)

    scale_box_with_plot = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        r"""
        When rotating the mousewheel, scale not only the plot but also
        the box.
        """
    )

    def _scale_box_with_plot_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScaleBoxWithPlot,
                        self.scale_box_with_plot)

    def _get_axes_text_property(self):
        return wrap_vtk(self._vtk_obj.GetAxesTextProperty())
    axes_text_property = traits.Property(_get_axes_text_property, desc=\
        r"""
        Get the text property for axes. Useful for changing font size,
        font family, font file.
        
        For example to use a larger font which is capable of displaying
        unicode values change the property like this:
        
        
          chart->get_axes_text_property()->set_font_family(VTK_FONT_FILE);
         
        chart->get_axes_text_property()->set_font_file("fonts/deja_vu_sans.ttf");
        
          chart->get_axes_text_property()->set_font_size(32);
        
        You'll need a unicode capable font in a suitable location.
        
        Now to get the X axis to display Theta subscript (0) set the
        label like this using the hex unicode representation:
        
        
         
        chart->set_x_axis_label("\xcf\xb4\xe2\x82\x8d\xe2\x82\x80\xe2\x82\x8e"
        );
        
        @return
        """
    )

    def add_plot(self, *args):
        """
        add_plot(self, plot:Plot3D) -> int
        C++: virtual IdType add_plot(Plot3D *plot)
        Adds a plot to the chart.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddPlot, *my_args)
        return ret

    def clear_plots(self):
        """
        clear_plots(self) -> None
        C++: void clear_plots()
        Remove all the plots from this chart.
        """
        ret = self._vtk_obj.ClearPlots()
        return ret
        

    def recalculate_bounds(self):
        """
        recalculate_bounds(self) -> None
        C++: void recalculate_bounds()
        Determine the XYZ bounds of the plots within this chart. This
        information is then used to set the range of the axes.
        """
        ret = self._vtk_obj.RecalculateBounds()
        return ret
        

    def recalculate_transform(self):
        """
        recalculate_transform(self) -> None
        C++: void recalculate_transform()
        Use this chart's Geometry to set the endpoints of its axes. This
        method also sets up a transformation that is used to properly
        render the data within the chart.
        """
        ret = self._vtk_obj.RecalculateTransform()
        return ret
        

    def remove_plot(self, *args):
        """
        remove_plot(self, plot:Plot3D) -> bool
        C++: virtual bool remove_plot(Plot3D *plot)
        Removes a plot from the chart.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemovePlot, *my_args)
        return ret

    def set_angle(self, *args):
        """
        set_angle(self, _arg:float) -> None
        C++: virtual void set_angle(double _arg)
        Set the rotation angle for the chart (auto_rotate mode only).
        """
        ret = self._wrap_call(self._vtk_obj.SetAngle, *args)
        return ret

    def set_annotation_link(self, *args):
        """
        set_annotation_link(self, link:AnnotationLink) -> None
        C++: virtual void set_annotation_link(AnnotationLink *link)
        Set the AnnotationLink for the chart.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetAnnotationLink, *my_args)
        return ret

    def set_around_x(self, *args):
        """
        set_around_x(self, isX:bool) -> None
        C++: void set_around_x(bool isX)
        Set whether or not we're rotating about the X axis.
        """
        ret = self._wrap_call(self._vtk_obj.SetAroundX, *args)
        return ret

    def set_auto_rotate(self, *args):
        """
        set_auto_rotate(self, _arg:bool) -> None
        C++: virtual void set_auto_rotate(bool _arg)
        Set whether or not we're using this chart to rotate on a timer.
        Default value is false.
        """
        ret = self._wrap_call(self._vtk_obj.SetAutoRotate, *args)
        return ret

    def set_decorate_axes(self, *args):
        """
        set_decorate_axes(self, b:bool) -> None
        C++: void set_decorate_axes(bool b)
        Set whether or not axes labels & tick marks should be drawn.
        Default value is true.
        """
        ret = self._wrap_call(self._vtk_obj.SetDecorateAxes, *args)
        return ret

    def set_ensure_outer_edge_axis_labelling(self, *args):
        """
        set_ensure_outer_edge_axis_labelling(self, _arg:bool) -> None
        C++: virtual void set_ensure_outer_edge_axis_labelling(bool _arg)
        Set to true to ensure that axis labels are always on the outer
        edges of the chart. Default is false, the legacy behaviour, for
        backwards compatibility, where axis labelling may occur on inner
        or back edges.
        """
        ret = self._wrap_call(self._vtk_obj.SetEnsureOuterEdgeAxisLabelling, *args)
        return ret

    def set_fit_to_scene(self, *args):
        """
        set_fit_to_scene(self, b:bool) -> None
        C++: void set_fit_to_scene(bool b)
        Set whether or not the chart should automatically resize itself
        to fill the scene.  Default value is true.
        """
        ret = self._wrap_call(self._vtk_obj.SetFitToScene, *args)
        return ret

    def set_geometry(self, *args):
        """
        set_geometry(self, bounds:Rectf) -> None
        C++: void set_geometry(const Rectf &bounds)
        Set the geometry in pixel coordinates (origin and width/height).
        This method also sets up the end points of the axes of the chart.
        For this reason, if you call set_around_x(), you should call
        set_geometry() afterwards.
        
        This method will result in a plot with a fixed size. If you want
        it to scale with the scene then use set_margins.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetGeometry, *my_args)
        return ret

    def set_margins(self, *args):
        """
        set_margins(self, margins:Vector4i) -> None
        C++: void set_margins(const Vector4i &margins)
        Set the margins in pixels ordered top right bottom left The box
        will be drawn inside those margins, but the labels and
        textdecorations will still escape. Note that the width and height
        automatically adapt to those of the scene.
        
        If you want a fixed size instead then use set_geometry.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetMargins, *my_args)
        return ret

    def set_x_axis_label(self, *args):
        """
        set_x_axis_label(self, _arg:str) -> None
        C++: virtual void set_x_axis_label(StdString _arg)
        Set the X axis label
        """
        ret = self._wrap_call(self._vtk_obj.SetXAxisLabel, *args)
        return ret

    def set_y_axis_label(self, *args):
        """
        set_y_axis_label(self, _arg:str) -> None
        C++: virtual void set_y_axis_label(StdString _arg)
        Set the Y axis label
        """
        ret = self._wrap_call(self._vtk_obj.SetYAxisLabel, *args)
        return ret

    def set_z_axis_label(self, *args):
        """
        set_z_axis_label(self, _arg:str) -> None
        C++: virtual void set_z_axis_label(StdString _arg)
        Set the Z axis label
        """
        ret = self._wrap_call(self._vtk_obj.SetZAxisLabel, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('clipping_planes_enabled',
    'GetClippingPlanesEnabled'), ('scale_box_with_plot',
    'GetScaleBoxWithPlot'), ('opacity', 'GetOpacity'), ('interactive',
    'GetInteractive'), ('visible', 'GetVisible'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'clipping_planes_enabled',
    'interactive', 'opacity', 'scale_box_with_plot', 'visible'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ChartXYZ, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ChartXYZ properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['clipping_planes_enabled', 'interactive', 'opacity',
            'scale_box_with_plot', 'visible']),
            title='Edit ChartXYZ properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ChartXYZ properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

