(external_tools)=

# External tools

Here external tools related to phonopy but supported by the groups out of the
phonopy project are introduced.

Each of the tools is not supported by the phonopy project because of the
difficulties of the maintenance and the test by main developers of phonopy under
current style of phonopy development. However useful tools should be known. If
developers want to use here to notify their tools, please contact via the
phonopy mailing list.

```{contents}
:depth: 2
:local:
```

## Phonopy-Spectroscopy

Phonopy-Spectroscopy is a project to add the capability to simulate vibrational
spectra to the phonopy code.

https://github.com/JMSkelton/Phonopy-Spectroscopy

### Features

- Calculate infrared (IR) intensities from phonopy or VASP calculations.
- Calculate Raman-activity tensors and scalar-averaged intensities within the
  far-from-resonance approximation.
- Prepare peak tables including assigning modes to irreducible representations
  (phonopy interface).
- Output customisable simulated spectra with support for multiple unit systems
  and simulated instrumental broadening.
- Include first-principles mode linewidths from Phono3py calculations (phonopy
  interface).

### Examples

- https://github.com/JMSkelton/Phonopy-Spectroscopy/tree/master/Examples/a-SiO2
- https://github.com/JMSkelton/Phonopy-Spectroscopy/tree/master/Examples/Benzene-Derivatives

(external_tools_phonolammps)=

## phonolammps

LAMMPS interface for phonon calculations using phonopy

https://github.com/abelcarreras/phonolammps

## LADYtools

A set of helpful tolls for ab initio calculation software packages like ABINIT
VASP CRYSTAL etc.

https://github.com/ladyteam/ladytools/wiki

## SNAXS interface

Simulating Neutron And X-ray Scans; a tool for condensed-matter scientists
studying phonons using neutron scattering.

https://github.com/danparshall/snaxs

## Ascii-phonons

Ascii-phonons is a visualisation code which uses Blender (an open-source 3D
graphics package) to generate animated GIFs and static arrow diagrams of phonon
eigenmodes. These may be rendered at publication quality. The input format is
the .ascii file generated by phonopy when called with the --anime flag, and
supercells can be used to visualise off-gamma phonon modes. The code is still
being developed but the core features are in place and new users are welcome.

https://github.com/ajjackson/ascii-phonons
