# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.domain import Domain
from twilio.rest.messaging.v1 import V1


class Messaging(Domain):

    def __init__(self, twilio):
        """
        Initialize the Messaging Domain

        :returns: Domain for Messaging
        :rtype: twilio.rest.messaging.Messaging
        """
        super(Messaging, self).__init__(twilio)

        self.base_url = 'https://messaging.twilio.com'

        # Versions
        self._v1 = None

    @property
    def v1(self):
        """
        :returns: Version v1 of messaging
        :rtype: twilio.rest.messaging.v1.V1
        """
        if self._v1 is None:
            self._v1 = V1(self)
        return self._v1

    @property
    def deactivations(self):
        """
        :rtype: twilio.rest.messaging.v1.deactivation.DeactivationsList
        """
        return self.v1.deactivations

    @property
    def services(self):
        """
        :rtype: twilio.rest.messaging.v1.service.ServiceList
        """
        return self.v1.services

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging>'
