% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_geometry.R
\name{st_geometry}
\alias{st_geometry}
\alias{st_drop_geometry.sftime}
\title{Drops the geometry column of \code{sftime} objects}
\usage{
\method{st_drop_geometry}{sftime}(x, ...)
}
\arguments{
\item{x}{An \code{sftime} object.}

\item{...}{ignored}
}
\value{
\code{x} without geometry column and without \code{sftime} and 
\code{sf} class.
}
\description{
Drops the geometry column of an \code{sftime} object. This will also drop 
the \code{sftime} class attribute and \code{time_column} attribute.
}
\examples{
# dropping the geometry column will also drop the `sftime` class:
g <- st_sfc(st_point(1:2))
time <- Sys.time()
x <- st_sftime(a = 3, g, time = time)
st_drop_geometry(x)

}
