---
layout: post
title: Polyglot 1.2.0
lang: nl
---
Een nieuwe versie van Polyglot is gepubliceerd! Probeer het uit!

{% highlight yaml %}
gem install jekyll-polyglot
{% endhighlight %}

en neem `jekyll-polyglot` op in je lijst van gems in je `_config.yml`

Het gaat vooral om voorbereidingen voor nieuwe features en betere meertalig contentbeheer. Het heeft ook een nieuwe feature:

## {% raw %} {% I18n_Headers %} {% endraw %}

Plaats deze tag met de [URL van je website](https://github.com/untra/polyglot/blob/site/_includes/head.html#L6) in je `head.html` om de maximale SEO te krijgen van een meertalige website. Het is hetzelfde als de volgende liquid code:

{% highlight html %}{% raw %}
<meta http-equiv="Content-Language" content="{{site.active_lang}}">
<link rel="alternate"
      hreflang="{{site.default_lang}}"
      href="http://yoursite.com{{page.permalink}}" />
{% for lang in site.languages %}
{% if lang == site.default_lang %}
  {% continue %}
{% endif %}
<link rel="alternate"
    hreflang="{{lang}}"
    href="http://yoursite.com/{{lang}}{{page.permalink}}" />
{% endfor %}
{% endraw %}
{% endhighlight %}

In je header, maar sneller en netter! Voor meer informatie, zie [de SEO-pagina](/seo)
