/*--------------------------------------------------------------------
 * Symbols referenced in this file:
 * - scanner_init
 * - core_yylex_init
 * - core_yyalloc
 * - yy_init_globals
 * - core_yyset_extra
 * - backslash_quote
 * - escape_string_warning
 * - standard_conforming_strings
 * - core_yy_scan_buffer
 * - core_yy_switch_to_buffer
 * - core_yyensure_buffer_stack
 * - core_yyrealloc
 * - core_yy_load_buffer_state
 * - yy_fatal_error
 * - fprintf_to_ereport
 * - ScanKeywordTokens
 * - core_yylex
 * - core_yy_create_buffer
 * - core_yy_init_buffer
 * - core_yy_flush_buffer
 * - core_yyrestart
 * - yy_start_state_list
 * - yy_transition
 * - addlitchar
 * - addlit
 * - litbufdup
 * - check_escape_warning
 * - addunicode
 * - setup_scanner_errposition_callback
 * - scb_error_callback
 * - cancel_scanner_errposition_callback
 * - check_string_escape_warning
 * - unescape_single_char
 * - process_integer_literal
 * - yy_get_previous_state
 * - yy_try_NUL_trans
 * - yy_get_next_buffer
 * - scanner_errposition
 * - scanner_yyerror
 * - scanner_finish
 *--------------------------------------------------------------------
 */

#line 1 "scan.c"
/*-------------------------------------------------------------------------
 *
 * scan.l
 *	  lexical scanner for PostgreSQL
 *
 * NOTE NOTE NOTE:
 *
 * The rules in this file must be kept in sync with src/fe_utils/psqlscan.l
 * and src/interfaces/ecpg/preproc/pgc.l!
 *
 * The rules are designed so that the scanner never has to backtrack,
 * in the sense that there is always a rule that can match the input
 * consumed so far (the rule action may internally throw back some input
 * with yyless(), however).  As explained in the flex manual, this makes
 * for a useful speed increase --- several percent faster when measuring
 * raw parsing (Flex + Bison).  The extra complexity is mostly in the rules
 * for handling float numbers and continued string literals.  If you change
 * the lexical rules, verify that you haven't broken the no-backtrack
 * property by running flex with the "-b" option and checking that the
 * resulting "lex.backup" file says that no backing up is needed.  (As of
 * Postgres 9.2, this check is made automatically by the Makefile.)
 *
 *
 * Portions Copyright (c) 1996-2023, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/backend/parser/scan.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"

#include <ctype.h>
#include <unistd.h>

#include "common/string.h"
#include "gramparse.h"
#include "nodes/miscnodes.h"
#include "parser/parser.h"		/* only needed for GUC variables */
#include "parser/scansup.h"
#include "port/pg_bitutils.h"
#include "mb/pg_wchar.h"
#include "utils/builtins.h"

#line 47 "scan.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define core_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer core_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define core_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer core_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define core_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer core_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define core_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string core_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define core_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes core_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define core_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer core_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define core_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer core_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define core_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state core_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define core_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer core_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define core_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state core_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define core_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state core_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define core_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack core_yyensure_buffer_stack
#endif

#ifdef yylex
#define core_yylex_ALREADY_DEFINED
#else
#define yylex core_yylex
#endif

#ifdef yyrestart
#define core_yyrestart_ALREADY_DEFINED
#else
#define yyrestart core_yyrestart
#endif

#ifdef yylex_init
#define core_yylex_init_ALREADY_DEFINED
#else
#define yylex_init core_yylex_init
#endif

#ifdef yylex_init_extra
#define core_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra core_yylex_init_extra
#endif

#ifdef yylex_destroy
#define core_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy core_yylex_destroy
#endif

#ifdef yyget_debug
#define core_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug core_yyget_debug
#endif

#ifdef yyset_debug
#define core_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug core_yyset_debug
#endif

#ifdef yyget_extra
#define core_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra core_yyget_extra
#endif

#ifdef yyset_extra
#define core_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra core_yyset_extra
#endif

#ifdef yyget_in
#define core_yyget_in_ALREADY_DEFINED
#else
#define yyget_in core_yyget_in
#endif

#ifdef yyset_in
#define core_yyset_in_ALREADY_DEFINED
#else
#define yyset_in core_yyset_in
#endif

#ifdef yyget_out
#define core_yyget_out_ALREADY_DEFINED
#else
#define yyget_out core_yyget_out
#endif

#ifdef yyset_out
#define core_yyset_out_ALREADY_DEFINED
#else
#define yyset_out core_yyset_out
#endif

#ifdef yyget_leng
#define core_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng core_yyget_leng
#endif

#ifdef yyget_text
#define core_yyget_text_ALREADY_DEFINED
#else
#define yyget_text core_yyget_text
#endif

#ifdef yyget_lineno
#define core_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno core_yyget_lineno
#endif

#ifdef yyset_lineno
#define core_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno core_yyset_lineno
#endif

#ifdef yyget_column
#define core_yyget_column_ALREADY_DEFINED
#else
#define yyget_column core_yyget_column
#endif

#ifdef yyset_column
#define core_yyset_column_ALREADY_DEFINED
#else
#define yyset_column core_yyset_column
#endif

#ifdef yywrap
#define core_yywrap_ALREADY_DEFINED
#else
#define yywrap core_yywrap
#endif

#ifdef yyget_lval
#define core_yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval core_yyget_lval
#endif

#ifdef yyset_lval
#define core_yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval core_yyset_lval
#endif

#ifdef yyget_lloc
#define core_yyget_lloc_ALREADY_DEFINED
#else
#define yyget_lloc core_yyget_lloc
#endif

#ifdef yyset_lloc
#define core_yyset_lloc_ALREADY_DEFINED
#else
#define yyset_lloc core_yyset_lloc
#endif

#ifdef yyalloc
#define core_yyalloc_ALREADY_DEFINED
#else
#define yyalloc core_yyalloc
#endif

#ifdef yyrealloc
#define core_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc core_yyrealloc
#endif

#ifdef yyfree
#define core_yyfree_ALREADY_DEFINED
#else
#define yyfree core_yyfree
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
typedef uint64_t flex_uint64_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, yy_size_t len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define core_yywrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef const struct yy_trans_info *yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (yy_size_t) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 76
#define YY_END_OF_BUFFER 77
struct yy_trans_info
	{
	flex_int16_t yy_verify;
	flex_int16_t yy_nxt;
	};
static const struct yy_trans_info yy_transition[21803] =
    {
 {   0,   0 }, {   0,21547 }, {   0,   0 }, {   0,21545 }, {   1,6192 },
 {   2,6192 }, {   3,6192 }, {   4,6192 }, {   5,6192 }, {   6,6192 },
 {   7,6192 }, {   8,6192 }, {   9,6194 }, {  10,6199 }, {  11,6192 },
 {  12,6194 }, {  13,6194 }, {  14,6192 }, {  15,6192 }, {  16,6192 },
 {  17,6192 }, {  18,6192 }, {  19,6192 }, {  20,6192 }, {  21,6192 },
 {  22,6192 }, {  23,6192 }, {  24,6192 }, {  25,6192 }, {  26,6192 },
 {  27,6192 }, {  28,6192 }, {  29,6192 }, {  30,6192 }, {  31,6192 },
 {  32,6194 }, {  33,6201 }, {  34,6196 }, {  35,6241 }, {  36,6307 },
 {  37,6564 }, {  38,6241 }, {  39,6214 }, {  40,6216 }, {  41,6216 },
 {  42,6564 }, {  43,6564 }, {  44,6216 }, {  45,6575 }, {  46,6594 },

 {  47,6665 }, {  48,6697 }, {  49,6954 }, {  50,6954 }, {  51,6954 },
 {  52,6954 }, {  53,6954 }, {  54,6954 }, {  55,6954 }, {  56,6954 },
 {  57,6954 }, {  58,6219 }, {  59,6216 }, {  60,7211 }, {  61,7222 },
 {  62,7289 }, {  63,6241 }, {  64,6241 }, {  65,7321 }, {  66,7578 },
 {  67,7321 }, {  68,7321 }, {  69,7835 }, {  70,7321 }, {  71,7321 },
 {  72,7321 }, {  73,7321 }, {  74,7321 }, {  75,7321 }, {  76,7321 },
 {  77,7321 }, {  78,8092 }, {  79,7321 }, {  80,7321 }, {  81,7321 },
 {  82,7321 }, {  83,7321 }, {  84,7321 }, {  85,8349 }, {  86,7321 },
 {  87,7321 }, {  88,8606 }, {  89,7321 }, {  90,7321 }, {  91,6216 },
 {  92,6192 }, {  93,6216 }, {  94,6564 }, {  95,7321 }, {  96,6241 },

 {  97,7321 }, {  98,7578 }, {  99,7321 }, { 100,7321 }, { 101,7835 },
 { 102,7321 }, { 103,7321 }, { 104,7321 }, { 105,7321 }, { 106,7321 },
 { 107,7321 }, { 108,7321 }, { 109,7321 }, { 110,8092 }, { 111,7321 },
 { 112,7321 }, { 113,7321 }, { 114,7321 }, { 115,7321 }, { 116,7321 },
 { 117,8349 }, { 118,7321 }, { 119,7321 }, { 120,8606 }, { 121,7321 },
 { 122,7321 }, { 123,6192 }, { 124,6241 }, { 125,6192 }, { 126,6241 },
 { 127,6192 }, { 128,7321 }, { 129,7321 }, { 130,7321 }, { 131,7321 },
 { 132,7321 }, { 133,7321 }, { 134,7321 }, { 135,7321 }, { 136,7321 },
 { 137,7321 }, { 138,7321 }, { 139,7321 }, { 140,7321 }, { 141,7321 },
 { 142,7321 }, { 143,7321 }, { 144,7321 }, { 145,7321 }, { 146,7321 },

 { 147,7321 }, { 148,7321 }, { 149,7321 }, { 150,7321 }, { 151,7321 },
 { 152,7321 }, { 153,7321 }, { 154,7321 }, { 155,7321 }, { 156,7321 },
 { 157,7321 }, { 158,7321 }, { 159,7321 }, { 160,7321 }, { 161,7321 },
 { 162,7321 }, { 163,7321 }, { 164,7321 }, { 165,7321 }, { 166,7321 },
 { 167,7321 }, { 168,7321 }, { 169,7321 }, { 170,7321 }, { 171,7321 },
 { 172,7321 }, { 173,7321 }, { 174,7321 }, { 175,7321 }, { 176,7321 },
 { 177,7321 }, { 178,7321 }, { 179,7321 }, { 180,7321 }, { 181,7321 },
 { 182,7321 }, { 183,7321 }, { 184,7321 }, { 185,7321 }, { 186,7321 },
 { 187,7321 }, { 188,7321 }, { 189,7321 }, { 190,7321 }, { 191,7321 },
 { 192,7321 }, { 193,7321 }, { 194,7321 }, { 195,7321 }, { 196,7321 },

 { 197,7321 }, { 198,7321 }, { 199,7321 }, { 200,7321 }, { 201,7321 },
 { 202,7321 }, { 203,7321 }, { 204,7321 }, { 205,7321 }, { 206,7321 },
 { 207,7321 }, { 208,7321 }, { 209,7321 }, { 210,7321 }, { 211,7321 },
 { 212,7321 }, { 213,7321 }, { 214,7321 }, { 215,7321 }, { 216,7321 },
 { 217,7321 }, { 218,7321 }, { 219,7321 }, { 220,7321 }, { 221,7321 },
 { 222,7321 }, { 223,7321 }, { 224,7321 }, { 225,7321 }, { 226,7321 },
 { 227,7321 }, { 228,7321 }, { 229,7321 }, { 230,7321 }, { 231,7321 },
 { 232,7321 }, { 233,7321 }, { 234,7321 }, { 235,7321 }, { 236,7321 },
 { 237,7321 }, { 238,7321 }, { 239,7321 }, { 240,7321 }, { 241,7321 },
 { 242,7321 }, { 243,7321 }, { 244,7321 }, { 245,7321 }, { 246,7321 },

 { 247,7321 }, { 248,7321 }, { 249,7321 }, { 250,7321 }, { 251,7321 },
 { 252,7321 }, { 253,7321 }, { 254,7321 }, { 255,7321 }, { 256,6192 },
 {   0,   0 }, {   0,21287 }, {   1,5934 }, {   2,5934 }, {   3,5934 },
 {   4,5934 }, {   5,5934 }, {   6,5934 }, {   7,5934 }, {   8,5934 },
 {   9,5936 }, {  10,5941 }, {  11,5934 }, {  12,5936 }, {  13,5936 },
 {  14,5934 }, {  15,5934 }, {  16,5934 }, {  17,5934 }, {  18,5934 },
 {  19,5934 }, {  20,5934 }, {  21,5934 }, {  22,5934 }, {  23,5934 },
 {  24,5934 }, {  25,5934 }, {  26,5934 }, {  27,5934 }, {  28,5934 },
 {  29,5934 }, {  30,5934 }, {  31,5934 }, {  32,5936 }, {  33,5943 },
 {  34,5938 }, {  35,5983 }, {  36,6049 }, {  37,6306 }, {  38,5983 },

 {  39,5956 }, {  40,5958 }, {  41,5958 }, {  42,6306 }, {  43,6306 },
 {  44,5958 }, {  45,6317 }, {  46,6336 }, {  47,6407 }, {  48,6439 },
 {  49,6696 }, {  50,6696 }, {  51,6696 }, {  52,6696 }, {  53,6696 },
 {  54,6696 }, {  55,6696 }, {  56,6696 }, {  57,6696 }, {  58,5961 },
 {  59,5958 }, {  60,6953 }, {  61,6964 }, {  62,7031 }, {  63,5983 },
 {  64,5983 }, {  65,7063 }, {  66,7320 }, {  67,7063 }, {  68,7063 },
 {  69,7577 }, {  70,7063 }, {  71,7063 }, {  72,7063 }, {  73,7063 },
 {  74,7063 }, {  75,7063 }, {  76,7063 }, {  77,7063 }, {  78,7834 },
 {  79,7063 }, {  80,7063 }, {  81,7063 }, {  82,7063 }, {  83,7063 },
 {  84,7063 }, {  85,8091 }, {  86,7063 }, {  87,7063 }, {  88,8348 },

 {  89,7063 }, {  90,7063 }, {  91,5958 }, {  92,5934 }, {  93,5958 },
 {  94,6306 }, {  95,7063 }, {  96,5983 }, {  97,7063 }, {  98,7320 },
 {  99,7063 }, { 100,7063 }, { 101,7577 }, { 102,7063 }, { 103,7063 },
 { 104,7063 }, { 105,7063 }, { 106,7063 }, { 107,7063 }, { 108,7063 },
 { 109,7063 }, { 110,7834 }, { 111,7063 }, { 112,7063 }, { 113,7063 },
 { 114,7063 }, { 115,7063 }, { 116,7063 }, { 117,8091 }, { 118,7063 },
 { 119,7063 }, { 120,8348 }, { 121,7063 }, { 122,7063 }, { 123,5934 },
 { 124,5983 }, { 125,5934 }, { 126,5983 }, { 127,5934 }, { 128,7063 },
 { 129,7063 }, { 130,7063 }, { 131,7063 }, { 132,7063 }, { 133,7063 },
 { 134,7063 }, { 135,7063 }, { 136,7063 }, { 137,7063 }, { 138,7063 },

 { 139,7063 }, { 140,7063 }, { 141,7063 }, { 142,7063 }, { 143,7063 },
 { 144,7063 }, { 145,7063 }, { 146,7063 }, { 147,7063 }, { 148,7063 },
 { 149,7063 }, { 150,7063 }, { 151,7063 }, { 152,7063 }, { 153,7063 },
 { 154,7063 }, { 155,7063 }, { 156,7063 }, { 157,7063 }, { 158,7063 },
 { 159,7063 }, { 160,7063 }, { 161,7063 }, { 162,7063 }, { 163,7063 },
 { 164,7063 }, { 165,7063 }, { 166,7063 }, { 167,7063 }, { 168,7063 },
 { 169,7063 }, { 170,7063 }, { 171,7063 }, { 172,7063 }, { 173,7063 },
 { 174,7063 }, { 175,7063 }, { 176,7063 }, { 177,7063 }, { 178,7063 },
 { 179,7063 }, { 180,7063 }, { 181,7063 }, { 182,7063 }, { 183,7063 },
 { 184,7063 }, { 185,7063 }, { 186,7063 }, { 187,7063 }, { 188,7063 },

 { 189,7063 }, { 190,7063 }, { 191,7063 }, { 192,7063 }, { 193,7063 },
 { 194,7063 }, { 195,7063 }, { 196,7063 }, { 197,7063 }, { 198,7063 },
 { 199,7063 }, { 200,7063 }, { 201,7063 }, { 202,7063 }, { 203,7063 },
 { 204,7063 }, { 205,7063 }, { 206,7063 }, { 207,7063 }, { 208,7063 },
 { 209,7063 }, { 210,7063 }, { 211,7063 }, { 212,7063 }, { 213,7063 },
 { 214,7063 }, { 215,7063 }, { 216,7063 }, { 217,7063 }, { 218,7063 },
 { 219,7063 }, { 220,7063 }, { 221,7063 }, { 222,7063 }, { 223,7063 },
 { 224,7063 }, { 225,7063 }, { 226,7063 }, { 227,7063 }, { 228,7063 },
 { 229,7063 }, { 230,7063 }, { 231,7063 }, { 232,7063 }, { 233,7063 },
 { 234,7063 }, { 235,7063 }, { 236,7063 }, { 237,7063 }, { 238,7063 },

 { 239,7063 }, { 240,7063 }, { 241,7063 }, { 242,7063 }, { 243,7063 },
 { 244,7063 }, { 245,7063 }, { 246,7063 }, { 247,7063 }, { 248,7063 },
 { 249,7063 }, { 250,7063 }, { 251,7063 }, { 252,7063 }, { 253,7063 },
 { 254,7063 }, { 255,7063 }, { 256,5934 }, {   0,  11 }, {   0,21029 },
 {   1,8347 }, {   2,8347 }, {   3,8347 }, {   4,8347 }, {   5,8347 },
 {   6,8347 }, {   7,8347 }, {   8,8347 }, {   9,8347 }, {  10,8347 },
 {  11,8347 }, {  12,8347 }, {  13,8347 }, {  14,8347 }, {  15,8347 },
 {  16,8347 }, {  17,8347 }, {  18,8347 }, {  19,8347 }, {  20,8347 },
 {  21,8347 }, {  22,8347 }, {  23,8347 }, {  24,8347 }, {  25,8347 },
 {  26,8347 }, {  27,8347 }, {  28,8347 }, {  29,8347 }, {  30,8347 },

 {  31,8347 }, {  32,8347 }, {  33,8347 }, {  34,8347 }, {  35,8347 },
 {  36,8347 }, {  37,8347 }, {  38,8347 }, {  39,5705 }, {  40,8347 },
 {  41,8347 }, {  42,8347 }, {  43,8347 }, {  44,8347 }, {  45,8347 },
 {  46,8347 }, {  47,8347 }, {  48,8347 }, {  49,8347 }, {  50,8347 },
 {  51,8347 }, {  52,8347 }, {  53,8347 }, {  54,8347 }, {  55,8347 },
 {  56,8347 }, {  57,8347 }, {  58,8347 }, {  59,8347 }, {  60,8347 },
 {  61,8347 }, {  62,8347 }, {  63,8347 }, {  64,8347 }, {  65,8347 },
 {  66,8347 }, {  67,8347 }, {  68,8347 }, {  69,8347 }, {  70,8347 },
 {  71,8347 }, {  72,8347 }, {  73,8347 }, {  74,8347 }, {  75,8347 },
 {  76,8347 }, {  77,8347 }, {  78,8347 }, {  79,8347 }, {  80,8347 },

 {  81,8347 }, {  82,8347 }, {  83,8347 }, {  84,8347 }, {  85,8347 },
 {  86,8347 }, {  87,8347 }, {  88,8347 }, {  89,8347 }, {  90,8347 },
 {  91,8347 }, {  92,8347 }, {  93,8347 }, {  94,8347 }, {  95,8347 },
 {  96,8347 }, {  97,8347 }, {  98,8347 }, {  99,8347 }, { 100,8347 },
 { 101,8347 }, { 102,8347 }, { 103,8347 }, { 104,8347 }, { 105,8347 },
 { 106,8347 }, { 107,8347 }, { 108,8347 }, { 109,8347 }, { 110,8347 },
 { 111,8347 }, { 112,8347 }, { 113,8347 }, { 114,8347 }, { 115,8347 },
 { 116,8347 }, { 117,8347 }, { 118,8347 }, { 119,8347 }, { 120,8347 },
 { 121,8347 }, { 122,8347 }, { 123,8347 }, { 124,8347 }, { 125,8347 },
 { 126,8347 }, { 127,8347 }, { 128,8347 }, { 129,8347 }, { 130,8347 },

 { 131,8347 }, { 132,8347 }, { 133,8347 }, { 134,8347 }, { 135,8347 },
 { 136,8347 }, { 137,8347 }, { 138,8347 }, { 139,8347 }, { 140,8347 },
 { 141,8347 }, { 142,8347 }, { 143,8347 }, { 144,8347 }, { 145,8347 },
 { 146,8347 }, { 147,8347 }, { 148,8347 }, { 149,8347 }, { 150,8347 },
 { 151,8347 }, { 152,8347 }, { 153,8347 }, { 154,8347 }, { 155,8347 },
 { 156,8347 }, { 157,8347 }, { 158,8347 }, { 159,8347 }, { 160,8347 },
 { 161,8347 }, { 162,8347 }, { 163,8347 }, { 164,8347 }, { 165,8347 },
 { 166,8347 }, { 167,8347 }, { 168,8347 }, { 169,8347 }, { 170,8347 },
 { 171,8347 }, { 172,8347 }, { 173,8347 }, { 174,8347 }, { 175,8347 },
 { 176,8347 }, { 177,8347 }, { 178,8347 }, { 179,8347 }, { 180,8347 },

 { 181,8347 }, { 182,8347 }, { 183,8347 }, { 184,8347 }, { 185,8347 },
 { 186,8347 }, { 187,8347 }, { 188,8347 }, { 189,8347 }, { 190,8347 },
 { 191,8347 }, { 192,8347 }, { 193,8347 }, { 194,8347 }, { 195,8347 },
 { 196,8347 }, { 197,8347 }, { 198,8347 }, { 199,8347 }, { 200,8347 },
 { 201,8347 }, { 202,8347 }, { 203,8347 }, { 204,8347 }, { 205,8347 },
 { 206,8347 }, { 207,8347 }, { 208,8347 }, { 209,8347 }, { 210,8347 },
 { 211,8347 }, { 212,8347 }, { 213,8347 }, { 214,8347 }, { 215,8347 },
 { 216,8347 }, { 217,8347 }, { 218,8347 }, { 219,8347 }, { 220,8347 },
 { 221,8347 }, { 222,8347 }, { 223,8347 }, { 224,8347 }, { 225,8347 },
 { 226,8347 }, { 227,8347 }, { 228,8347 }, { 229,8347 }, { 230,8347 },

 { 231,8347 }, { 232,8347 }, { 233,8347 }, { 234,8347 }, { 235,8347 },
 { 236,8347 }, { 237,8347 }, { 238,8347 }, { 239,8347 }, { 240,8347 },
 { 241,8347 }, { 242,8347 }, { 243,8347 }, { 244,8347 }, { 245,8347 },
 { 246,8347 }, { 247,8347 }, { 248,8347 }, { 249,8347 }, { 250,8347 },
 { 251,8347 }, { 252,8347 }, { 253,8347 }, { 254,8347 }, { 255,8347 },
 { 256,8347 }, {   0,  11 }, {   0,20771 }, {   1,8089 }, {   2,8089 },
 {   3,8089 }, {   4,8089 }, {   5,8089 }, {   6,8089 }, {   7,8089 },
 {   8,8089 }, {   9,8089 }, {  10,8089 }, {  11,8089 }, {  12,8089 },
 {  13,8089 }, {  14,8089 }, {  15,8089 }, {  16,8089 }, {  17,8089 },
 {  18,8089 }, {  19,8089 }, {  20,8089 }, {  21,8089 }, {  22,8089 },

 {  23,8089 }, {  24,8089 }, {  25,8089 }, {  26,8089 }, {  27,8089 },
 {  28,8089 }, {  29,8089 }, {  30,8089 }, {  31,8089 }, {  32,8089 },
 {  33,8089 }, {  34,8089 }, {  35,8089 }, {  36,8089 }, {  37,8089 },
 {  38,8089 }, {  39,5447 }, {  40,8089 }, {  41,8089 }, {  42,8089 },
 {  43,8089 }, {  44,8089 }, {  45,8089 }, {  46,8089 }, {  47,8089 },
 {  48,8089 }, {  49,8089 }, {  50,8089 }, {  51,8089 }, {  52,8089 },
 {  53,8089 }, {  54,8089 }, {  55,8089 }, {  56,8089 }, {  57,8089 },
 {  58,8089 }, {  59,8089 }, {  60,8089 }, {  61,8089 }, {  62,8089 },
 {  63,8089 }, {  64,8089 }, {  65,8089 }, {  66,8089 }, {  67,8089 },
 {  68,8089 }, {  69,8089 }, {  70,8089 }, {  71,8089 }, {  72,8089 },

 {  73,8089 }, {  74,8089 }, {  75,8089 }, {  76,8089 }, {  77,8089 },
 {  78,8089 }, {  79,8089 }, {  80,8089 }, {  81,8089 }, {  82,8089 },
 {  83,8089 }, {  84,8089 }, {  85,8089 }, {  86,8089 }, {  87,8089 },
 {  88,8089 }, {  89,8089 }, {  90,8089 }, {  91,8089 }, {  92,8089 },
 {  93,8089 }, {  94,8089 }, {  95,8089 }, {  96,8089 }, {  97,8089 },
 {  98,8089 }, {  99,8089 }, { 100,8089 }, { 101,8089 }, { 102,8089 },
 { 103,8089 }, { 104,8089 }, { 105,8089 }, { 106,8089 }, { 107,8089 },
 { 108,8089 }, { 109,8089 }, { 110,8089 }, { 111,8089 }, { 112,8089 },
 { 113,8089 }, { 114,8089 }, { 115,8089 }, { 116,8089 }, { 117,8089 },
 { 118,8089 }, { 119,8089 }, { 120,8089 }, { 121,8089 }, { 122,8089 },

 { 123,8089 }, { 124,8089 }, { 125,8089 }, { 126,8089 }, { 127,8089 },
 { 128,8089 }, { 129,8089 }, { 130,8089 }, { 131,8089 }, { 132,8089 },
 { 133,8089 }, { 134,8089 }, { 135,8089 }, { 136,8089 }, { 137,8089 },
 { 138,8089 }, { 139,8089 }, { 140,8089 }, { 141,8089 }, { 142,8089 },
 { 143,8089 }, { 144,8089 }, { 145,8089 }, { 146,8089 }, { 147,8089 },
 { 148,8089 }, { 149,8089 }, { 150,8089 }, { 151,8089 }, { 152,8089 },
 { 153,8089 }, { 154,8089 }, { 155,8089 }, { 156,8089 }, { 157,8089 },
 { 158,8089 }, { 159,8089 }, { 160,8089 }, { 161,8089 }, { 162,8089 },
 { 163,8089 }, { 164,8089 }, { 165,8089 }, { 166,8089 }, { 167,8089 },
 { 168,8089 }, { 169,8089 }, { 170,8089 }, { 171,8089 }, { 172,8089 },

 { 173,8089 }, { 174,8089 }, { 175,8089 }, { 176,8089 }, { 177,8089 },
 { 178,8089 }, { 179,8089 }, { 180,8089 }, { 181,8089 }, { 182,8089 },
 { 183,8089 }, { 184,8089 }, { 185,8089 }, { 186,8089 }, { 187,8089 },
 { 188,8089 }, { 189,8089 }, { 190,8089 }, { 191,8089 }, { 192,8089 },
 { 193,8089 }, { 194,8089 }, { 195,8089 }, { 196,8089 }, { 197,8089 },
 { 198,8089 }, { 199,8089 }, { 200,8089 }, { 201,8089 }, { 202,8089 },
 { 203,8089 }, { 204,8089 }, { 205,8089 }, { 206,8089 }, { 207,8089 },
 { 208,8089 }, { 209,8089 }, { 210,8089 }, { 211,8089 }, { 212,8089 },
 { 213,8089 }, { 214,8089 }, { 215,8089 }, { 216,8089 }, { 217,8089 },
 { 218,8089 }, { 219,8089 }, { 220,8089 }, { 221,8089 }, { 222,8089 },

 { 223,8089 }, { 224,8089 }, { 225,8089 }, { 226,8089 }, { 227,8089 },
 { 228,8089 }, { 229,8089 }, { 230,8089 }, { 231,8089 }, { 232,8089 },
 { 233,8089 }, { 234,8089 }, { 235,8089 }, { 236,8089 }, { 237,8089 },
 { 238,8089 }, { 239,8089 }, { 240,8089 }, { 241,8089 }, { 242,8089 },
 { 243,8089 }, { 244,8089 }, { 245,8089 }, { 246,8089 }, { 247,8089 },
 { 248,8089 }, { 249,8089 }, { 250,8089 }, { 251,8089 }, { 252,8089 },
 { 253,8089 }, { 254,8089 }, { 255,8089 }, { 256,8089 }, {   0,   0 },
 {   0,20513 }, {   1,8089 }, {   2,8089 }, {   3,8089 }, {   4,8089 },
 {   5,8089 }, {   6,8089 }, {   7,8089 }, {   8,8089 }, {   9,8089 },
 {  10,8089 }, {  11,8089 }, {  12,8089 }, {  13,8089 }, {  14,8089 },

 {  15,8089 }, {  16,8089 }, {  17,8089 }, {  18,8089 }, {  19,8089 },
 {  20,8089 }, {  21,8089 }, {  22,8089 }, {  23,8089 }, {  24,8089 },
 {  25,8089 }, {  26,8089 }, {  27,8089 }, {  28,8089 }, {  29,8089 },
 {  30,8089 }, {  31,8089 }, {  32,8089 }, {  33,8347 }, {  34,8089 },
 {  35,8347 }, {  36,8089 }, {  37,8347 }, {  38,8347 }, {  39,8089 },
 {  40,8089 }, {  41,8089 }, {  42,5192 }, {  43,8347 }, {  44,8089 },
 {  45,8347 }, {  46,8089 }, {  47,5196 }, {  48,8089 }, {  49,8089 },
 {  50,8089 }, {  51,8089 }, {  52,8089 }, {  53,8089 }, {  54,8089 },
 {  55,8089 }, {  56,8089 }, {  57,8089 }, {  58,8089 }, {  59,8089 },
 {  60,8347 }, {  61,8347 }, {  62,8347 }, {  63,8347 }, {  64,8347 },

 {  65,8089 }, {  66,8089 }, {  67,8089 }, {  68,8089 }, {  69,8089 },
 {  70,8089 }, {  71,8089 }, {  72,8089 }, {  73,8089 }, {  74,8089 },
 {  75,8089 }, {  76,8089 }, {  77,8089 }, {  78,8089 }, {  79,8089 },
 {  80,8089 }, {  81,8089 }, {  82,8089 }, {  83,8089 }, {  84,8089 },
 {  85,8089 }, {  86,8089 }, {  87,8089 }, {  88,8089 }, {  89,8089 },
 {  90,8089 }, {  91,8089 }, {  92,8089 }, {  93,8089 }, {  94,8347 },
 {  95,8089 }, {  96,8347 }, {  97,8089 }, {  98,8089 }, {  99,8089 },
 { 100,8089 }, { 101,8089 }, { 102,8089 }, { 103,8089 }, { 104,8089 },
 { 105,8089 }, { 106,8089 }, { 107,8089 }, { 108,8089 }, { 109,8089 },
 { 110,8089 }, { 111,8089 }, { 112,8089 }, { 113,8089 }, { 114,8089 },

 { 115,8089 }, { 116,8089 }, { 117,8089 }, { 118,8089 }, { 119,8089 },
 { 120,8089 }, { 121,8089 }, { 122,8089 }, { 123,8089 }, { 124,8347 },
 { 125,8089 }, { 126,8347 }, { 127,8089 }, { 128,8089 }, { 129,8089 },
 { 130,8089 }, { 131,8089 }, { 132,8089 }, { 133,8089 }, { 134,8089 },
 { 135,8089 }, { 136,8089 }, { 137,8089 }, { 138,8089 }, { 139,8089 },
 { 140,8089 }, { 141,8089 }, { 142,8089 }, { 143,8089 }, { 144,8089 },
 { 145,8089 }, { 146,8089 }, { 147,8089 }, { 148,8089 }, { 149,8089 },
 { 150,8089 }, { 151,8089 }, { 152,8089 }, { 153,8089 }, { 154,8089 },
 { 155,8089 }, { 156,8089 }, { 157,8089 }, { 158,8089 }, { 159,8089 },
 { 160,8089 }, { 161,8089 }, { 162,8089 }, { 163,8089 }, { 164,8089 },

 { 165,8089 }, { 166,8089 }, { 167,8089 }, { 168,8089 }, { 169,8089 },
 { 170,8089 }, { 171,8089 }, { 172,8089 }, { 173,8089 }, { 174,8089 },
 { 175,8089 }, { 176,8089 }, { 177,8089 }, { 178,8089 }, { 179,8089 },
 { 180,8089 }, { 181,8089 }, { 182,8089 }, { 183,8089 }, { 184,8089 },
 { 185,8089 }, { 186,8089 }, { 187,8089 }, { 188,8089 }, { 189,8089 },
 { 190,8089 }, { 191,8089 }, { 192,8089 }, { 193,8089 }, { 194,8089 },
 { 195,8089 }, { 196,8089 }, { 197,8089 }, { 198,8089 }, { 199,8089 },
 { 200,8089 }, { 201,8089 }, { 202,8089 }, { 203,8089 }, { 204,8089 },
 { 205,8089 }, { 206,8089 }, { 207,8089 }, { 208,8089 }, { 209,8089 },
 { 210,8089 }, { 211,8089 }, { 212,8089 }, { 213,8089 }, { 214,8089 },

 { 215,8089 }, { 216,8089 }, { 217,8089 }, { 218,8089 }, { 219,8089 },
 { 220,8089 }, { 221,8089 }, { 222,8089 }, { 223,8089 }, { 224,8089 },
 { 225,8089 }, { 226,8089 }, { 227,8089 }, { 228,8089 }, { 229,8089 },
 { 230,8089 }, { 231,8089 }, { 232,8089 }, { 233,8089 }, { 234,8089 },
 { 235,8089 }, { 236,8089 }, { 237,8089 }, { 238,8089 }, { 239,8089 },
 { 240,8089 }, { 241,8089 }, { 242,8089 }, { 243,8089 }, { 244,8089 },
 { 245,8089 }, { 246,8089 }, { 247,8089 }, { 248,8089 }, { 249,8089 },
 { 250,8089 }, { 251,8089 }, { 252,8089 }, { 253,8089 }, { 254,8089 },
 { 255,8089 }, { 256,8089 }, {   0,   0 }, {   0,20255 }, {   1,7831 },
 {   2,7831 }, {   3,7831 }, {   4,7831 }, {   5,7831 }, {   6,7831 },

 {   7,7831 }, {   8,7831 }, {   9,7831 }, {  10,7831 }, {  11,7831 },
 {  12,7831 }, {  13,7831 }, {  14,7831 }, {  15,7831 }, {  16,7831 },
 {  17,7831 }, {  18,7831 }, {  19,7831 }, {  20,7831 }, {  21,7831 },
 {  22,7831 }, {  23,7831 }, {  24,7831 }, {  25,7831 }, {  26,7831 },
 {  27,7831 }, {  28,7831 }, {  29,7831 }, {  30,7831 }, {  31,7831 },
 {  32,7831 }, {  33,8089 }, {  34,7831 }, {  35,8089 }, {  36,7831 },
 {  37,8089 }, {  38,8089 }, {  39,7831 }, {  40,7831 }, {  41,7831 },
 {  42,4934 }, {  43,8089 }, {  44,7831 }, {  45,8089 }, {  46,7831 },
 {  47,4938 }, {  48,7831 }, {  49,7831 }, {  50,7831 }, {  51,7831 },
 {  52,7831 }, {  53,7831 }, {  54,7831 }, {  55,7831 }, {  56,7831 },

 {  57,7831 }, {  58,7831 }, {  59,7831 }, {  60,8089 }, {  61,8089 },
 {  62,8089 }, {  63,8089 }, {  64,8089 }, {  65,7831 }, {  66,7831 },
 {  67,7831 }, {  68,7831 }, {  69,7831 }, {  70,7831 }, {  71,7831 },
 {  72,7831 }, {  73,7831 }, {  74,7831 }, {  75,7831 }, {  76,7831 },
 {  77,7831 }, {  78,7831 }, {  79,7831 }, {  80,7831 }, {  81,7831 },
 {  82,7831 }, {  83,7831 }, {  84,7831 }, {  85,7831 }, {  86,7831 },
 {  87,7831 }, {  88,7831 }, {  89,7831 }, {  90,7831 }, {  91,7831 },
 {  92,7831 }, {  93,7831 }, {  94,8089 }, {  95,7831 }, {  96,8089 },
 {  97,7831 }, {  98,7831 }, {  99,7831 }, { 100,7831 }, { 101,7831 },
 { 102,7831 }, { 103,7831 }, { 104,7831 }, { 105,7831 }, { 106,7831 },

 { 107,7831 }, { 108,7831 }, { 109,7831 }, { 110,7831 }, { 111,7831 },
 { 112,7831 }, { 113,7831 }, { 114,7831 }, { 115,7831 }, { 116,7831 },
 { 117,7831 }, { 118,7831 }, { 119,7831 }, { 120,7831 }, { 121,7831 },
 { 122,7831 }, { 123,7831 }, { 124,8089 }, { 125,7831 }, { 126,8089 },
 { 127,7831 }, { 128,7831 }, { 129,7831 }, { 130,7831 }, { 131,7831 },
 { 132,7831 }, { 133,7831 }, { 134,7831 }, { 135,7831 }, { 136,7831 },
 { 137,7831 }, { 138,7831 }, { 139,7831 }, { 140,7831 }, { 141,7831 },
 { 142,7831 }, { 143,7831 }, { 144,7831 }, { 145,7831 }, { 146,7831 },
 { 147,7831 }, { 148,7831 }, { 149,7831 }, { 150,7831 }, { 151,7831 },
 { 152,7831 }, { 153,7831 }, { 154,7831 }, { 155,7831 }, { 156,7831 },

 { 157,7831 }, { 158,7831 }, { 159,7831 }, { 160,7831 }, { 161,7831 },
 { 162,7831 }, { 163,7831 }, { 164,7831 }, { 165,7831 }, { 166,7831 },
 { 167,7831 }, { 168,7831 }, { 169,7831 }, { 170,7831 }, { 171,7831 },
 { 172,7831 }, { 173,7831 }, { 174,7831 }, { 175,7831 }, { 176,7831 },
 { 177,7831 }, { 178,7831 }, { 179,7831 }, { 180,7831 }, { 181,7831 },
 { 182,7831 }, { 183,7831 }, { 184,7831 }, { 185,7831 }, { 186,7831 },
 { 187,7831 }, { 188,7831 }, { 189,7831 }, { 190,7831 }, { 191,7831 },
 { 192,7831 }, { 193,7831 }, { 194,7831 }, { 195,7831 }, { 196,7831 },
 { 197,7831 }, { 198,7831 }, { 199,7831 }, { 200,7831 }, { 201,7831 },
 { 202,7831 }, { 203,7831 }, { 204,7831 }, { 205,7831 }, { 206,7831 },

 { 207,7831 }, { 208,7831 }, { 209,7831 }, { 210,7831 }, { 211,7831 },
 { 212,7831 }, { 213,7831 }, { 214,7831 }, { 215,7831 }, { 216,7831 },
 { 217,7831 }, { 218,7831 }, { 219,7831 }, { 220,7831 }, { 221,7831 },
 { 222,7831 }, { 223,7831 }, { 224,7831 }, { 225,7831 }, { 226,7831 },
 { 227,7831 }, { 228,7831 }, { 229,7831 }, { 230,7831 }, { 231,7831 },
 { 232,7831 }, { 233,7831 }, { 234,7831 }, { 235,7831 }, { 236,7831 },
 { 237,7831 }, { 238,7831 }, { 239,7831 }, { 240,7831 }, { 241,7831 },
 { 242,7831 }, { 243,7831 }, { 244,7831 }, { 245,7831 }, { 246,7831 },
 { 247,7831 }, { 248,7831 }, { 249,7831 }, { 250,7831 }, { 251,7831 },
 { 252,7831 }, { 253,7831 }, { 254,7831 }, { 255,7831 }, { 256,7831 },

 {   0,   0 }, {   0,19997 }, {   1,8089 }, {   2,8089 }, {   3,8089 },
 {   4,8089 }, {   5,8089 }, {   6,8089 }, {   7,8089 }, {   8,8089 },
 {   9,8089 }, {  10,8089 }, {  11,8089 }, {  12,8089 }, {  13,8089 },
 {  14,8089 }, {  15,8089 }, {  16,8089 }, {  17,8089 }, {  18,8089 },
 {  19,8089 }, {  20,8089 }, {  21,8089 }, {  22,8089 }, {  23,8089 },
 {  24,8089 }, {  25,8089 }, {  26,8089 }, {  27,8089 }, {  28,8089 },
 {  29,8089 }, {  30,8089 }, {  31,8089 }, {  32,8089 }, {  33,8089 },
 {  34,4685 }, {  35,8089 }, {  36,8089 }, {  37,8089 }, {  38,8089 },
 {  39,8089 }, {  40,8089 }, {  41,8089 }, {  42,8089 }, {  43,8089 },
 {  44,8089 }, {  45,8089 }, {  46,8089 }, {  47,8089 }, {  48,8089 },

 {  49,8089 }, {  50,8089 }, {  51,8089 }, {  52,8089 }, {  53,8089 },
 {  54,8089 }, {  55,8089 }, {  56,8089 }, {  57,8089 }, {  58,8089 },
 {  59,8089 }, {  60,8089 }, {  61,8089 }, {  62,8089 }, {  63,8089 },
 {  64,8089 }, {  65,8089 }, {  66,8089 }, {  67,8089 }, {  68,8089 },
 {  69,8089 }, {  70,8089 }, {  71,8089 }, {  72,8089 }, {  73,8089 },
 {  74,8089 }, {  75,8089 }, {  76,8089 }, {  77,8089 }, {  78,8089 },
 {  79,8089 }, {  80,8089 }, {  81,8089 }, {  82,8089 }, {  83,8089 },
 {  84,8089 }, {  85,8089 }, {  86,8089 }, {  87,8089 }, {  88,8089 },
 {  89,8089 }, {  90,8089 }, {  91,8089 }, {  92,8089 }, {  93,8089 },
 {  94,8089 }, {  95,8089 }, {  96,8089 }, {  97,8089 }, {  98,8089 },

 {  99,8089 }, { 100,8089 }, { 101,8089 }, { 102,8089 }, { 103,8089 },
 { 104,8089 }, { 105,8089 }, { 106,8089 }, { 107,8089 }, { 108,8089 },
 { 109,8089 }, { 110,8089 }, { 111,8089 }, { 112,8089 }, { 113,8089 },
 { 114,8089 }, { 115,8089 }, { 116,8089 }, { 117,8089 }, { 118,8089 },
 { 119,8089 }, { 120,8089 }, { 121,8089 }, { 122,8089 }, { 123,8089 },
 { 124,8089 }, { 125,8089 }, { 126,8089 }, { 127,8089 }, { 128,8089 },
 { 129,8089 }, { 130,8089 }, { 131,8089 }, { 132,8089 }, { 133,8089 },
 { 134,8089 }, { 135,8089 }, { 136,8089 }, { 137,8089 }, { 138,8089 },
 { 139,8089 }, { 140,8089 }, { 141,8089 }, { 142,8089 }, { 143,8089 },
 { 144,8089 }, { 145,8089 }, { 146,8089 }, { 147,8089 }, { 148,8089 },

 { 149,8089 }, { 150,8089 }, { 151,8089 }, { 152,8089 }, { 153,8089 },
 { 154,8089 }, { 155,8089 }, { 156,8089 }, { 157,8089 }, { 158,8089 },
 { 159,8089 }, { 160,8089 }, { 161,8089 }, { 162,8089 }, { 163,8089 },
 { 164,8089 }, { 165,8089 }, { 166,8089 }, { 167,8089 }, { 168,8089 },
 { 169,8089 }, { 170,8089 }, { 171,8089 }, { 172,8089 }, { 173,8089 },
 { 174,8089 }, { 175,8089 }, { 176,8089 }, { 177,8089 }, { 178,8089 },
 { 179,8089 }, { 180,8089 }, { 181,8089 }, { 182,8089 }, { 183,8089 },
 { 184,8089 }, { 185,8089 }, { 186,8089 }, { 187,8089 }, { 188,8089 },
 { 189,8089 }, { 190,8089 }, { 191,8089 }, { 192,8089 }, { 193,8089 },
 { 194,8089 }, { 195,8089 }, { 196,8089 }, { 197,8089 }, { 198,8089 },

 { 199,8089 }, { 200,8089 }, { 201,8089 }, { 202,8089 }, { 203,8089 },
 { 204,8089 }, { 205,8089 }, { 206,8089 }, { 207,8089 }, { 208,8089 },
 { 209,8089 }, { 210,8089 }, { 211,8089 }, { 212,8089 }, { 213,8089 },
 { 214,8089 }, { 215,8089 }, { 216,8089 }, { 217,8089 }, { 218,8089 },
 { 219,8089 }, { 220,8089 }, { 221,8089 }, { 222,8089 }, { 223,8089 },
 { 224,8089 }, { 225,8089 }, { 226,8089 }, { 227,8089 }, { 228,8089 },
 { 229,8089 }, { 230,8089 }, { 231,8089 }, { 232,8089 }, { 233,8089 },
 { 234,8089 }, { 235,8089 }, { 236,8089 }, { 237,8089 }, { 238,8089 },
 { 239,8089 }, { 240,8089 }, { 241,8089 }, { 242,8089 }, { 243,8089 },
 { 244,8089 }, { 245,8089 }, { 246,8089 }, { 247,8089 }, { 248,8089 },

 { 249,8089 }, { 250,8089 }, { 251,8089 }, { 252,8089 }, { 253,8089 },
 { 254,8089 }, { 255,8089 }, { 256,8089 }, {   0,   0 }, {   0,19739 },
 {   1,7831 }, {   2,7831 }, {   3,7831 }, {   4,7831 }, {   5,7831 },
 {   6,7831 }, {   7,7831 }, {   8,7831 }, {   9,7831 }, {  10,7831 },
 {  11,7831 }, {  12,7831 }, {  13,7831 }, {  14,7831 }, {  15,7831 },
 {  16,7831 }, {  17,7831 }, {  18,7831 }, {  19,7831 }, {  20,7831 },
 {  21,7831 }, {  22,7831 }, {  23,7831 }, {  24,7831 }, {  25,7831 },
 {  26,7831 }, {  27,7831 }, {  28,7831 }, {  29,7831 }, {  30,7831 },
 {  31,7831 }, {  32,7831 }, {  33,7831 }, {  34,4427 }, {  35,7831 },
 {  36,7831 }, {  37,7831 }, {  38,7831 }, {  39,7831 }, {  40,7831 },

 {  41,7831 }, {  42,7831 }, {  43,7831 }, {  44,7831 }, {  45,7831 },
 {  46,7831 }, {  47,7831 }, {  48,7831 }, {  49,7831 }, {  50,7831 },
 {  51,7831 }, {  52,7831 }, {  53,7831 }, {  54,7831 }, {  55,7831 },
 {  56,7831 }, {  57,7831 }, {  58,7831 }, {  59,7831 }, {  60,7831 },
 {  61,7831 }, {  62,7831 }, {  63,7831 }, {  64,7831 }, {  65,7831 },
 {  66,7831 }, {  67,7831 }, {  68,7831 }, {  69,7831 }, {  70,7831 },
 {  71,7831 }, {  72,7831 }, {  73,7831 }, {  74,7831 }, {  75,7831 },
 {  76,7831 }, {  77,7831 }, {  78,7831 }, {  79,7831 }, {  80,7831 },
 {  81,7831 }, {  82,7831 }, {  83,7831 }, {  84,7831 }, {  85,7831 },
 {  86,7831 }, {  87,7831 }, {  88,7831 }, {  89,7831 }, {  90,7831 },

 {  91,7831 }, {  92,7831 }, {  93,7831 }, {  94,7831 }, {  95,7831 },
 {  96,7831 }, {  97,7831 }, {  98,7831 }, {  99,7831 }, { 100,7831 },
 { 101,7831 }, { 102,7831 }, { 103,7831 }, { 104,7831 }, { 105,7831 },
 { 106,7831 }, { 107,7831 }, { 108,7831 }, { 109,7831 }, { 110,7831 },
 { 111,7831 }, { 112,7831 }, { 113,7831 }, { 114,7831 }, { 115,7831 },
 { 116,7831 }, { 117,7831 }, { 118,7831 }, { 119,7831 }, { 120,7831 },
 { 121,7831 }, { 122,7831 }, { 123,7831 }, { 124,7831 }, { 125,7831 },
 { 126,7831 }, { 127,7831 }, { 128,7831 }, { 129,7831 }, { 130,7831 },
 { 131,7831 }, { 132,7831 }, { 133,7831 }, { 134,7831 }, { 135,7831 },
 { 136,7831 }, { 137,7831 }, { 138,7831 }, { 139,7831 }, { 140,7831 },

 { 141,7831 }, { 142,7831 }, { 143,7831 }, { 144,7831 }, { 145,7831 },
 { 146,7831 }, { 147,7831 }, { 148,7831 }, { 149,7831 }, { 150,7831 },
 { 151,7831 }, { 152,7831 }, { 153,7831 }, { 154,7831 }, { 155,7831 },
 { 156,7831 }, { 157,7831 }, { 158,7831 }, { 159,7831 }, { 160,7831 },
 { 161,7831 }, { 162,7831 }, { 163,7831 }, { 164,7831 }, { 165,7831 },
 { 166,7831 }, { 167,7831 }, { 168,7831 }, { 169,7831 }, { 170,7831 },
 { 171,7831 }, { 172,7831 }, { 173,7831 }, { 174,7831 }, { 175,7831 },
 { 176,7831 }, { 177,7831 }, { 178,7831 }, { 179,7831 }, { 180,7831 },
 { 181,7831 }, { 182,7831 }, { 183,7831 }, { 184,7831 }, { 185,7831 },
 { 186,7831 }, { 187,7831 }, { 188,7831 }, { 189,7831 }, { 190,7831 },

 { 191,7831 }, { 192,7831 }, { 193,7831 }, { 194,7831 }, { 195,7831 },
 { 196,7831 }, { 197,7831 }, { 198,7831 }, { 199,7831 }, { 200,7831 },
 { 201,7831 }, { 202,7831 }, { 203,7831 }, { 204,7831 }, { 205,7831 },
 { 206,7831 }, { 207,7831 }, { 208,7831 }, { 209,7831 }, { 210,7831 },
 { 211,7831 }, { 212,7831 }, { 213,7831 }, { 214,7831 }, { 215,7831 },
 { 216,7831 }, { 217,7831 }, { 218,7831 }, { 219,7831 }, { 220,7831 },
 { 221,7831 }, { 222,7831 }, { 223,7831 }, { 224,7831 }, { 225,7831 },
 { 226,7831 }, { 227,7831 }, { 228,7831 }, { 229,7831 }, { 230,7831 },
 { 231,7831 }, { 232,7831 }, { 233,7831 }, { 234,7831 }, { 235,7831 },
 { 236,7831 }, { 237,7831 }, { 238,7831 }, { 239,7831 }, { 240,7831 },

 { 241,7831 }, { 242,7831 }, { 243,7831 }, { 244,7831 }, { 245,7831 },
 { 246,7831 }, { 247,7831 }, { 248,7831 }, { 249,7831 }, { 250,7831 },
 { 251,7831 }, { 252,7831 }, { 253,7831 }, { 254,7831 }, { 255,7831 },
 { 256,7831 }, {   0,  10 }, {   0,19481 }, {   1,7831 }, {   2,7831 },
 {   3,7831 }, {   4,7831 }, {   5,7831 }, {   6,7831 }, {   7,7831 },
 {   8,7831 }, {   9,7831 }, {  10,7831 }, {  11,7831 }, {  12,7831 },
 {  13,7831 }, {  14,7831 }, {  15,7831 }, {  16,7831 }, {  17,7831 },
 {  18,7831 }, {  19,7831 }, {  20,7831 }, {  21,7831 }, {  22,7831 },
 {  23,7831 }, {  24,7831 }, {  25,7831 }, {  26,7831 }, {  27,7831 },
 {  28,7831 }, {  29,7831 }, {  30,7831 }, {  31,7831 }, {  32,7831 },

 {  33,7831 }, {  34,7831 }, {  35,7831 }, {  36,7831 }, {  37,7831 },
 {  38,7831 }, {  39,4157 }, {  40,7831 }, {  41,7831 }, {  42,7831 },
 {  43,7831 }, {  44,7831 }, {  45,7831 }, {  46,7831 }, {  47,7831 },
 {  48,7831 }, {  49,7831 }, {  50,7831 }, {  51,7831 }, {  52,7831 },
 {  53,7831 }, {  54,7831 }, {  55,7831 }, {  56,7831 }, {  57,7831 },
 {  58,7831 }, {  59,7831 }, {  60,7831 }, {  61,7831 }, {  62,7831 },
 {  63,7831 }, {  64,7831 }, {  65,7831 }, {  66,7831 }, {  67,7831 },
 {  68,7831 }, {  69,7831 }, {  70,7831 }, {  71,7831 }, {  72,7831 },
 {  73,7831 }, {  74,7831 }, {  75,7831 }, {  76,7831 }, {  77,7831 },
 {  78,7831 }, {  79,7831 }, {  80,7831 }, {  81,7831 }, {  82,7831 },

 {  83,7831 }, {  84,7831 }, {  85,7831 }, {  86,7831 }, {  87,7831 },
 {  88,7831 }, {  89,7831 }, {  90,7831 }, {  91,7831 }, {  92,7831 },
 {  93,7831 }, {  94,7831 }, {  95,7831 }, {  96,7831 }, {  97,7831 },
 {  98,7831 }, {  99,7831 }, { 100,7831 }, { 101,7831 }, { 102,7831 },
 { 103,7831 }, { 104,7831 }, { 105,7831 }, { 106,7831 }, { 107,7831 },
 { 108,7831 }, { 109,7831 }, { 110,7831 }, { 111,7831 }, { 112,7831 },
 { 113,7831 }, { 114,7831 }, { 115,7831 }, { 116,7831 }, { 117,7831 },
 { 118,7831 }, { 119,7831 }, { 120,7831 }, { 121,7831 }, { 122,7831 },
 { 123,7831 }, { 124,7831 }, { 125,7831 }, { 126,7831 }, { 127,7831 },
 { 128,7831 }, { 129,7831 }, { 130,7831 }, { 131,7831 }, { 132,7831 },

 { 133,7831 }, { 134,7831 }, { 135,7831 }, { 136,7831 }, { 137,7831 },
 { 138,7831 }, { 139,7831 }, { 140,7831 }, { 141,7831 }, { 142,7831 },
 { 143,7831 }, { 144,7831 }, { 145,7831 }, { 146,7831 }, { 147,7831 },
 { 148,7831 }, { 149,7831 }, { 150,7831 }, { 151,7831 }, { 152,7831 },
 { 153,7831 }, { 154,7831 }, { 155,7831 }, { 156,7831 }, { 157,7831 },
 { 158,7831 }, { 159,7831 }, { 160,7831 }, { 161,7831 }, { 162,7831 },
 { 163,7831 }, { 164,7831 }, { 165,7831 }, { 166,7831 }, { 167,7831 },
 { 168,7831 }, { 169,7831 }, { 170,7831 }, { 171,7831 }, { 172,7831 },
 { 173,7831 }, { 174,7831 }, { 175,7831 }, { 176,7831 }, { 177,7831 },
 { 178,7831 }, { 179,7831 }, { 180,7831 }, { 181,7831 }, { 182,7831 },

 { 183,7831 }, { 184,7831 }, { 185,7831 }, { 186,7831 }, { 187,7831 },
 { 188,7831 }, { 189,7831 }, { 190,7831 }, { 191,7831 }, { 192,7831 },
 { 193,7831 }, { 194,7831 }, { 195,7831 }, { 196,7831 }, { 197,7831 },
 { 198,7831 }, { 199,7831 }, { 200,7831 }, { 201,7831 }, { 202,7831 },
 { 203,7831 }, { 204,7831 }, { 205,7831 }, { 206,7831 }, { 207,7831 },
 { 208,7831 }, { 209,7831 }, { 210,7831 }, { 211,7831 }, { 212,7831 },
 { 213,7831 }, { 214,7831 }, { 215,7831 }, { 216,7831 }, { 217,7831 },
 { 218,7831 }, { 219,7831 }, { 220,7831 }, { 221,7831 }, { 222,7831 },
 { 223,7831 }, { 224,7831 }, { 225,7831 }, { 226,7831 }, { 227,7831 },
 { 228,7831 }, { 229,7831 }, { 230,7831 }, { 231,7831 }, { 232,7831 },

 { 233,7831 }, { 234,7831 }, { 235,7831 }, { 236,7831 }, { 237,7831 },
 { 238,7831 }, { 239,7831 }, { 240,7831 }, { 241,7831 }, { 242,7831 },
 { 243,7831 }, { 244,7831 }, { 245,7831 }, { 246,7831 }, { 247,7831 },
 { 248,7831 }, { 249,7831 }, { 250,7831 }, { 251,7831 }, { 252,7831 },
 { 253,7831 }, { 254,7831 }, { 255,7831 }, { 256,7831 }, {   0,  10 },
 {   0,19223 }, {   1,7573 }, {   2,7573 }, {   3,7573 }, {   4,7573 },
 {   5,7573 }, {   6,7573 }, {   7,7573 }, {   8,7573 }, {   9,7573 },
 {  10,7573 }, {  11,7573 }, {  12,7573 }, {  13,7573 }, {  14,7573 },
 {  15,7573 }, {  16,7573 }, {  17,7573 }, {  18,7573 }, {  19,7573 },
 {  20,7573 }, {  21,7573 }, {  22,7573 }, {  23,7573 }, {  24,7573 },

 {  25,7573 }, {  26,7573 }, {  27,7573 }, {  28,7573 }, {  29,7573 },
 {  30,7573 }, {  31,7573 }, {  32,7573 }, {  33,7573 }, {  34,7573 },
 {  35,7573 }, {  36,7573 }, {  37,7573 }, {  38,7573 }, {  39,3899 },
 {  40,7573 }, {  41,7573 }, {  42,7573 }, {  43,7573 }, {  44,7573 },
 {  45,7573 }, {  46,7573 }, {  47,7573 }, {  48,7573 }, {  49,7573 },
 {  50,7573 }, {  51,7573 }, {  52,7573 }, {  53,7573 }, {  54,7573 },
 {  55,7573 }, {  56,7573 }, {  57,7573 }, {  58,7573 }, {  59,7573 },
 {  60,7573 }, {  61,7573 }, {  62,7573 }, {  63,7573 }, {  64,7573 },
 {  65,7573 }, {  66,7573 }, {  67,7573 }, {  68,7573 }, {  69,7573 },
 {  70,7573 }, {  71,7573 }, {  72,7573 }, {  73,7573 }, {  74,7573 },

 {  75,7573 }, {  76,7573 }, {  77,7573 }, {  78,7573 }, {  79,7573 },
 {  80,7573 }, {  81,7573 }, {  82,7573 }, {  83,7573 }, {  84,7573 },
 {  85,7573 }, {  86,7573 }, {  87,7573 }, {  88,7573 }, {  89,7573 },
 {  90,7573 }, {  91,7573 }, {  92,7573 }, {  93,7573 }, {  94,7573 },
 {  95,7573 }, {  96,7573 }, {  97,7573 }, {  98,7573 }, {  99,7573 },
 { 100,7573 }, { 101,7573 }, { 102,7573 }, { 103,7573 }, { 104,7573 },
 { 105,7573 }, { 106,7573 }, { 107,7573 }, { 108,7573 }, { 109,7573 },
 { 110,7573 }, { 111,7573 }, { 112,7573 }, { 113,7573 }, { 114,7573 },
 { 115,7573 }, { 116,7573 }, { 117,7573 }, { 118,7573 }, { 119,7573 },
 { 120,7573 }, { 121,7573 }, { 122,7573 }, { 123,7573 }, { 124,7573 },

 { 125,7573 }, { 126,7573 }, { 127,7573 }, { 128,7573 }, { 129,7573 },
 { 130,7573 }, { 131,7573 }, { 132,7573 }, { 133,7573 }, { 134,7573 },
 { 135,7573 }, { 136,7573 }, { 137,7573 }, { 138,7573 }, { 139,7573 },
 { 140,7573 }, { 141,7573 }, { 142,7573 }, { 143,7573 }, { 144,7573 },
 { 145,7573 }, { 146,7573 }, { 147,7573 }, { 148,7573 }, { 149,7573 },
 { 150,7573 }, { 151,7573 }, { 152,7573 }, { 153,7573 }, { 154,7573 },
 { 155,7573 }, { 156,7573 }, { 157,7573 }, { 158,7573 }, { 159,7573 },
 { 160,7573 }, { 161,7573 }, { 162,7573 }, { 163,7573 }, { 164,7573 },
 { 165,7573 }, { 166,7573 }, { 167,7573 }, { 168,7573 }, { 169,7573 },
 { 170,7573 }, { 171,7573 }, { 172,7573 }, { 173,7573 }, { 174,7573 },

 { 175,7573 }, { 176,7573 }, { 177,7573 }, { 178,7573 }, { 179,7573 },
 { 180,7573 }, { 181,7573 }, { 182,7573 }, { 183,7573 }, { 184,7573 },
 { 185,7573 }, { 186,7573 }, { 187,7573 }, { 188,7573 }, { 189,7573 },
 { 190,7573 }, { 191,7573 }, { 192,7573 }, { 193,7573 }, { 194,7573 },
 { 195,7573 }, { 196,7573 }, { 197,7573 }, { 198,7573 }, { 199,7573 },
 { 200,7573 }, { 201,7573 }, { 202,7573 }, { 203,7573 }, { 204,7573 },
 { 205,7573 }, { 206,7573 }, { 207,7573 }, { 208,7573 }, { 209,7573 },
 { 210,7573 }, { 211,7573 }, { 212,7573 }, { 213,7573 }, { 214,7573 },
 { 215,7573 }, { 216,7573 }, { 217,7573 }, { 218,7573 }, { 219,7573 },
 { 220,7573 }, { 221,7573 }, { 222,7573 }, { 223,7573 }, { 224,7573 },

 { 225,7573 }, { 226,7573 }, { 227,7573 }, { 228,7573 }, { 229,7573 },
 { 230,7573 }, { 231,7573 }, { 232,7573 }, { 233,7573 }, { 234,7573 },
 { 235,7573 }, { 236,7573 }, { 237,7573 }, { 238,7573 }, { 239,7573 },
 { 240,7573 }, { 241,7573 }, { 242,7573 }, { 243,7573 }, { 244,7573 },
 { 245,7573 }, { 246,7573 }, { 247,7573 }, { 248,7573 }, { 249,7573 },
 { 250,7573 }, { 251,7573 }, { 252,7573 }, { 253,7573 }, { 254,7573 },
 { 255,7573 }, { 256,7573 }, {   0,   0 }, {   0,18965 }, {   1,7573 },
 {   2,7573 }, {   3,7573 }, {   4,7573 }, {   5,7573 }, {   6,7573 },
 {   7,7573 }, {   8,7573 }, {   9,7573 }, {  10,7573 }, {  11,7573 },
 {  12,7573 }, {  13,7573 }, {  14,7573 }, {  15,7573 }, {  16,7573 },

 {  17,7573 }, {  18,7573 }, {  19,7573 }, {  20,7573 }, {  21,7573 },
 {  22,7573 }, {  23,7573 }, {  24,7573 }, {  25,7573 }, {  26,7573 },
 {  27,7573 }, {  28,7573 }, {  29,7573 }, {  30,7573 }, {  31,7573 },
 {  32,7573 }, {  33,7573 }, {  34,7573 }, {  35,7573 }, {  36,7573 },
 {  37,7573 }, {  38,7573 }, {  39,3670 }, {  40,7573 }, {  41,7573 },
 {  42,7573 }, {  43,7573 }, {  44,7573 }, {  45,7573 }, {  46,7573 },
 {  47,7573 }, {  48,7573 }, {  49,7573 }, {  50,7573 }, {  51,7573 },
 {  52,7573 }, {  53,7573 }, {  54,7573 }, {  55,7573 }, {  56,7573 },
 {  57,7573 }, {  58,7573 }, {  59,7573 }, {  60,7573 }, {  61,7573 },
 {  62,7573 }, {  63,7573 }, {  64,7573 }, {  65,7573 }, {  66,7573 },

 {  67,7573 }, {  68,7573 }, {  69,7573 }, {  70,7573 }, {  71,7573 },
 {  72,7573 }, {  73,7573 }, {  74,7573 }, {  75,7573 }, {  76,7573 },
 {  77,7573 }, {  78,7573 }, {  79,7573 }, {  80,7573 }, {  81,7573 },
 {  82,7573 }, {  83,7573 }, {  84,7573 }, {  85,7573 }, {  86,7573 },
 {  87,7573 }, {  88,7573 }, {  89,7573 }, {  90,7573 }, {  91,7573 },
 {  92,7573 }, {  93,7573 }, {  94,7573 }, {  95,7573 }, {  96,7573 },
 {  97,7573 }, {  98,7573 }, {  99,7573 }, { 100,7573 }, { 101,7573 },
 { 102,7573 }, { 103,7573 }, { 104,7573 }, { 105,7573 }, { 106,7573 },
 { 107,7573 }, { 108,7573 }, { 109,7573 }, { 110,7573 }, { 111,7573 },
 { 112,7573 }, { 113,7573 }, { 114,7573 }, { 115,7573 }, { 116,7573 },

 { 117,7573 }, { 118,7573 }, { 119,7573 }, { 120,7573 }, { 121,7573 },
 { 122,7573 }, { 123,7573 }, { 124,7573 }, { 125,7573 }, { 126,7573 },
 { 127,7573 }, { 128,7573 }, { 129,7573 }, { 130,7573 }, { 131,7573 },
 { 132,7573 }, { 133,7573 }, { 134,7573 }, { 135,7573 }, { 136,7573 },
 { 137,7573 }, { 138,7573 }, { 139,7573 }, { 140,7573 }, { 141,7573 },
 { 142,7573 }, { 143,7573 }, { 144,7573 }, { 145,7573 }, { 146,7573 },
 { 147,7573 }, { 148,7573 }, { 149,7573 }, { 150,7573 }, { 151,7573 },
 { 152,7573 }, { 153,7573 }, { 154,7573 }, { 155,7573 }, { 156,7573 },
 { 157,7573 }, { 158,7573 }, { 159,7573 }, { 160,7573 }, { 161,7573 },
 { 162,7573 }, { 163,7573 }, { 164,7573 }, { 165,7573 }, { 166,7573 },

 { 167,7573 }, { 168,7573 }, { 169,7573 }, { 170,7573 }, { 171,7573 },
 { 172,7573 }, { 173,7573 }, { 174,7573 }, { 175,7573 }, { 176,7573 },
 { 177,7573 }, { 178,7573 }, { 179,7573 }, { 180,7573 }, { 181,7573 },
 { 182,7573 }, { 183,7573 }, { 184,7573 }, { 185,7573 }, { 186,7573 },
 { 187,7573 }, { 188,7573 }, { 189,7573 }, { 190,7573 }, { 191,7573 },
 { 192,7573 }, { 193,7573 }, { 194,7573 }, { 195,7573 }, { 196,7573 },
 { 197,7573 }, { 198,7573 }, { 199,7573 }, { 200,7573 }, { 201,7573 },
 { 202,7573 }, { 203,7573 }, { 204,7573 }, { 205,7573 }, { 206,7573 },
 { 207,7573 }, { 208,7573 }, { 209,7573 }, { 210,7573 }, { 211,7573 },
 { 212,7573 }, { 213,7573 }, { 214,7573 }, { 215,7573 }, { 216,7573 },

 { 217,7573 }, { 218,7573 }, { 219,7573 }, { 220,7573 }, { 221,7573 },
 { 222,7573 }, { 223,7573 }, { 224,7573 }, { 225,7573 }, { 226,7573 },
 { 227,7573 }, { 228,7573 }, { 229,7573 }, { 230,7573 }, { 231,7573 },
 { 232,7573 }, { 233,7573 }, { 234,7573 }, { 235,7573 }, { 236,7573 },
 { 237,7573 }, { 238,7573 }, { 239,7573 }, { 240,7573 }, { 241,7573 },
 { 242,7573 }, { 243,7573 }, { 244,7573 }, { 245,7573 }, { 246,7573 },
 { 247,7573 }, { 248,7573 }, { 249,7573 }, { 250,7573 }, { 251,7573 },
 { 252,7573 }, { 253,7573 }, { 254,7573 }, { 255,7573 }, { 256,7573 },
 {   0,   0 }, {   0,18707 }, {   1,7315 }, {   2,7315 }, {   3,7315 },
 {   4,7315 }, {   5,7315 }, {   6,7315 }, {   7,7315 }, {   8,7315 },

 {   9,7315 }, {  10,7315 }, {  11,7315 }, {  12,7315 }, {  13,7315 },
 {  14,7315 }, {  15,7315 }, {  16,7315 }, {  17,7315 }, {  18,7315 },
 {  19,7315 }, {  20,7315 }, {  21,7315 }, {  22,7315 }, {  23,7315 },
 {  24,7315 }, {  25,7315 }, {  26,7315 }, {  27,7315 }, {  28,7315 },
 {  29,7315 }, {  30,7315 }, {  31,7315 }, {  32,7315 }, {  33,7315 },
 {  34,7315 }, {  35,7315 }, {  36,7315 }, {  37,7315 }, {  38,7315 },
 {  39,3412 }, {  40,7315 }, {  41,7315 }, {  42,7315 }, {  43,7315 },
 {  44,7315 }, {  45,7315 }, {  46,7315 }, {  47,7315 }, {  48,7315 },
 {  49,7315 }, {  50,7315 }, {  51,7315 }, {  52,7315 }, {  53,7315 },
 {  54,7315 }, {  55,7315 }, {  56,7315 }, {  57,7315 }, {  58,7315 },

 {  59,7315 }, {  60,7315 }, {  61,7315 }, {  62,7315 }, {  63,7315 },
 {  64,7315 }, {  65,7315 }, {  66,7315 }, {  67,7315 }, {  68,7315 },
 {  69,7315 }, {  70,7315 }, {  71,7315 }, {  72,7315 }, {  73,7315 },
 {  74,7315 }, {  75,7315 }, {  76,7315 }, {  77,7315 }, {  78,7315 },
 {  79,7315 }, {  80,7315 }, {  81,7315 }, {  82,7315 }, {  83,7315 },
 {  84,7315 }, {  85,7315 }, {  86,7315 }, {  87,7315 }, {  88,7315 },
 {  89,7315 }, {  90,7315 }, {  91,7315 }, {  92,7315 }, {  93,7315 },
 {  94,7315 }, {  95,7315 }, {  96,7315 }, {  97,7315 }, {  98,7315 },
 {  99,7315 }, { 100,7315 }, { 101,7315 }, { 102,7315 }, { 103,7315 },
 { 104,7315 }, { 105,7315 }, { 106,7315 }, { 107,7315 }, { 108,7315 },

 { 109,7315 }, { 110,7315 }, { 111,7315 }, { 112,7315 }, { 113,7315 },
 { 114,7315 }, { 115,7315 }, { 116,7315 }, { 117,7315 }, { 118,7315 },
 { 119,7315 }, { 120,7315 }, { 121,7315 }, { 122,7315 }, { 123,7315 },
 { 124,7315 }, { 125,7315 }, { 126,7315 }, { 127,7315 }, { 128,7315 },
 { 129,7315 }, { 130,7315 }, { 131,7315 }, { 132,7315 }, { 133,7315 },
 { 134,7315 }, { 135,7315 }, { 136,7315 }, { 137,7315 }, { 138,7315 },
 { 139,7315 }, { 140,7315 }, { 141,7315 }, { 142,7315 }, { 143,7315 },
 { 144,7315 }, { 145,7315 }, { 146,7315 }, { 147,7315 }, { 148,7315 },
 { 149,7315 }, { 150,7315 }, { 151,7315 }, { 152,7315 }, { 153,7315 },
 { 154,7315 }, { 155,7315 }, { 156,7315 }, { 157,7315 }, { 158,7315 },

 { 159,7315 }, { 160,7315 }, { 161,7315 }, { 162,7315 }, { 163,7315 },
 { 164,7315 }, { 165,7315 }, { 166,7315 }, { 167,7315 }, { 168,7315 },
 { 169,7315 }, { 170,7315 }, { 171,7315 }, { 172,7315 }, { 173,7315 },
 { 174,7315 }, { 175,7315 }, { 176,7315 }, { 177,7315 }, { 178,7315 },
 { 179,7315 }, { 180,7315 }, { 181,7315 }, { 182,7315 }, { 183,7315 },
 { 184,7315 }, { 185,7315 }, { 186,7315 }, { 187,7315 }, { 188,7315 },
 { 189,7315 }, { 190,7315 }, { 191,7315 }, { 192,7315 }, { 193,7315 },
 { 194,7315 }, { 195,7315 }, { 196,7315 }, { 197,7315 }, { 198,7315 },
 { 199,7315 }, { 200,7315 }, { 201,7315 }, { 202,7315 }, { 203,7315 },
 { 204,7315 }, { 205,7315 }, { 206,7315 }, { 207,7315 }, { 208,7315 },

 { 209,7315 }, { 210,7315 }, { 211,7315 }, { 212,7315 }, { 213,7315 },
 { 214,7315 }, { 215,7315 }, { 216,7315 }, { 217,7315 }, { 218,7315 },
 { 219,7315 }, { 220,7315 }, { 221,7315 }, { 222,7315 }, { 223,7315 },
 { 224,7315 }, { 225,7315 }, { 226,7315 }, { 227,7315 }, { 228,7315 },
 { 229,7315 }, { 230,7315 }, { 231,7315 }, { 232,7315 }, { 233,7315 },
 { 234,7315 }, { 235,7315 }, { 236,7315 }, { 237,7315 }, { 238,7315 },
 { 239,7315 }, { 240,7315 }, { 241,7315 }, { 242,7315 }, { 243,7315 },
 { 244,7315 }, { 245,7315 }, { 246,7315 }, { 247,7315 }, { 248,7315 },
 { 249,7315 }, { 250,7315 }, { 251,7315 }, { 252,7315 }, { 253,7315 },
 { 254,7315 }, { 255,7315 }, { 256,7315 }, {   0,  19 }, {   0,18449 },

 {   1,3156 }, {   2,3156 }, {   3,3156 }, {   4,3156 }, {   5,3156 },
 {   6,3156 }, {   7,3156 }, {   8,3156 }, {   9,7315 }, {  10,7320 },
 {  11,3156 }, {  12,7315 }, {  13,7336 }, {  14,3156 }, {  15,3156 },
 {  16,3156 }, {  17,3156 }, {  18,3156 }, {  19,3156 }, {  20,3156 },
 {  21,3156 }, {  22,3156 }, {  23,3156 }, {  24,3156 }, {  25,3156 },
 {  26,3156 }, {  27,3156 }, {  28,3156 }, {  29,3156 }, {  30,3156 },
 {  31,3156 }, {  32,7315 }, {  33,3156 }, {  34,3156 }, {  35,3156 },
 {  36,3156 }, {  37,3156 }, {  38,3156 }, {  39,3156 }, {  40,3156 },
 {  41,3156 }, {  42,3156 }, {  43,3156 }, {  44,3156 }, {  45,3158 },
 {  46,3156 }, {  47,3156 }, {  48,3156 }, {  49,3156 }, {  50,3156 },

 {  51,3156 }, {  52,3156 }, {  53,3156 }, {  54,3156 }, {  55,3156 },
 {  56,3156 }, {  57,3156 }, {  58,3156 }, {  59,3156 }, {  60,3156 },
 {  61,3156 }, {  62,3156 }, {  63,3156 }, {  64,3156 }, {  65,3156 },
 {  66,3156 }, {  67,3156 }, {  68,3156 }, {  69,3156 }, {  70,3156 },
 {  71,3156 }, {  72,3156 }, {  73,3156 }, {  74,3156 }, {  75,3156 },
 {  76,3156 }, {  77,3156 }, {  78,3156 }, {  79,3156 }, {  80,3156 },
 {  81,3156 }, {  82,3156 }, {  83,3156 }, {  84,3156 }, {  85,3156 },
 {  86,3156 }, {  87,3156 }, {  88,3156 }, {  89,3156 }, {  90,3156 },
 {  91,3156 }, {  92,3156 }, {  93,3156 }, {  94,3156 }, {  95,3156 },
 {  96,3156 }, {  97,3156 }, {  98,3156 }, {  99,3156 }, { 100,3156 },

 { 101,3156 }, { 102,3156 }, { 103,3156 }, { 104,3156 }, { 105,3156 },
 { 106,3156 }, { 107,3156 }, { 108,3156 }, { 109,3156 }, { 110,3156 },
 { 111,3156 }, { 112,3156 }, { 113,3156 }, { 114,3156 }, { 115,3156 },
 { 116,3156 }, { 117,3156 }, { 118,3156 }, { 119,3156 }, { 120,3156 },
 { 121,3156 }, { 122,3156 }, { 123,3156 }, { 124,3156 }, { 125,3156 },
 { 126,3156 }, { 127,3156 }, { 128,3156 }, { 129,3156 }, { 130,3156 },
 { 131,3156 }, { 132,3156 }, { 133,3156 }, { 134,3156 }, { 135,3156 },
 { 136,3156 }, { 137,3156 }, { 138,3156 }, { 139,3156 }, { 140,3156 },
 { 141,3156 }, { 142,3156 }, { 143,3156 }, { 144,3156 }, { 145,3156 },
 { 146,3156 }, { 147,3156 }, { 148,3156 }, { 149,3156 }, { 150,3156 },

 { 151,3156 }, { 152,3156 }, { 153,3156 }, { 154,3156 }, { 155,3156 },
 { 156,3156 }, { 157,3156 }, { 158,3156 }, { 159,3156 }, { 160,3156 },
 { 161,3156 }, { 162,3156 }, { 163,3156 }, { 164,3156 }, { 165,3156 },
 { 166,3156 }, { 167,3156 }, { 168,3156 }, { 169,3156 }, { 170,3156 },
 { 171,3156 }, { 172,3156 }, { 173,3156 }, { 174,3156 }, { 175,3156 },
 { 176,3156 }, { 177,3156 }, { 178,3156 }, { 179,3156 }, { 180,3156 },
 { 181,3156 }, { 182,3156 }, { 183,3156 }, { 184,3156 }, { 185,3156 },
 { 186,3156 }, { 187,3156 }, { 188,3156 }, { 189,3156 }, { 190,3156 },
 { 191,3156 }, { 192,3156 }, { 193,3156 }, { 194,3156 }, { 195,3156 },
 { 196,3156 }, { 197,3156 }, { 198,3156 }, { 199,3156 }, { 200,3156 },

 { 201,3156 }, { 202,3156 }, { 203,3156 }, { 204,3156 }, { 205,3156 },
 { 206,3156 }, { 207,3156 }, { 208,3156 }, { 209,3156 }, { 210,3156 },
 { 211,3156 }, { 212,3156 }, { 213,3156 }, { 214,3156 }, { 215,3156 },
 { 216,3156 }, { 217,3156 }, { 218,3156 }, { 219,3156 }, { 220,3156 },
 { 221,3156 }, { 222,3156 }, { 223,3156 }, { 224,3156 }, { 225,3156 },
 { 226,3156 }, { 227,3156 }, { 228,3156 }, { 229,3156 }, { 230,3156 },
 { 231,3156 }, { 232,3156 }, { 233,3156 }, { 234,3156 }, { 235,3156 },
 { 236,3156 }, { 237,3156 }, { 238,3156 }, { 239,3156 }, { 240,3156 },
 { 241,3156 }, { 242,3156 }, { 243,3156 }, { 244,3156 }, { 245,3156 },
 { 246,3156 }, { 247,3156 }, { 248,3156 }, { 249,3156 }, { 250,3156 },

 { 251,3156 }, { 252,3156 }, { 253,3156 }, { 254,3156 }, { 255,3156 },
 { 256,3156 }, {   0,  19 }, {   0,18191 }, {   1,2898 }, {   2,2898 },
 {   3,2898 }, {   4,2898 }, {   5,2898 }, {   6,2898 }, {   7,2898 },
 {   8,2898 }, {   9,7057 }, {  10,7062 }, {  11,2898 }, {  12,7057 },
 {  13,7078 }, {  14,2898 }, {  15,2898 }, {  16,2898 }, {  17,2898 },
 {  18,2898 }, {  19,2898 }, {  20,2898 }, {  21,2898 }, {  22,2898 },
 {  23,2898 }, {  24,2898 }, {  25,2898 }, {  26,2898 }, {  27,2898 },
 {  28,2898 }, {  29,2898 }, {  30,2898 }, {  31,2898 }, {  32,7057 },
 {  33,2898 }, {  34,2898 }, {  35,2898 }, {  36,2898 }, {  37,2898 },
 {  38,2898 }, {  39,2898 }, {  40,2898 }, {  41,2898 }, {  42,2898 },

 {  43,2898 }, {  44,2898 }, {  45,2900 }, {  46,2898 }, {  47,2898 },
 {  48,2898 }, {  49,2898 }, {  50,2898 }, {  51,2898 }, {  52,2898 },
 {  53,2898 }, {  54,2898 }, {  55,2898 }, {  56,2898 }, {  57,2898 },
 {  58,2898 }, {  59,2898 }, {  60,2898 }, {  61,2898 }, {  62,2898 },
 {  63,2898 }, {  64,2898 }, {  65,2898 }, {  66,2898 }, {  67,2898 },
 {  68,2898 }, {  69,2898 }, {  70,2898 }, {  71,2898 }, {  72,2898 },
 {  73,2898 }, {  74,2898 }, {  75,2898 }, {  76,2898 }, {  77,2898 },
 {  78,2898 }, {  79,2898 }, {  80,2898 }, {  81,2898 }, {  82,2898 },
 {  83,2898 }, {  84,2898 }, {  85,2898 }, {  86,2898 }, {  87,2898 },
 {  88,2898 }, {  89,2898 }, {  90,2898 }, {  91,2898 }, {  92,2898 },

 {  93,2898 }, {  94,2898 }, {  95,2898 }, {  96,2898 }, {  97,2898 },
 {  98,2898 }, {  99,2898 }, { 100,2898 }, { 101,2898 }, { 102,2898 },
 { 103,2898 }, { 104,2898 }, { 105,2898 }, { 106,2898 }, { 107,2898 },
 { 108,2898 }, { 109,2898 }, { 110,2898 }, { 111,2898 }, { 112,2898 },
 { 113,2898 }, { 114,2898 }, { 115,2898 }, { 116,2898 }, { 117,2898 },
 { 118,2898 }, { 119,2898 }, { 120,2898 }, { 121,2898 }, { 122,2898 },
 { 123,2898 }, { 124,2898 }, { 125,2898 }, { 126,2898 }, { 127,2898 },
 { 128,2898 }, { 129,2898 }, { 130,2898 }, { 131,2898 }, { 132,2898 },
 { 133,2898 }, { 134,2898 }, { 135,2898 }, { 136,2898 }, { 137,2898 },
 { 138,2898 }, { 139,2898 }, { 140,2898 }, { 141,2898 }, { 142,2898 },

 { 143,2898 }, { 144,2898 }, { 145,2898 }, { 146,2898 }, { 147,2898 },
 { 148,2898 }, { 149,2898 }, { 150,2898 }, { 151,2898 }, { 152,2898 },
 { 153,2898 }, { 154,2898 }, { 155,2898 }, { 156,2898 }, { 157,2898 },
 { 158,2898 }, { 159,2898 }, { 160,2898 }, { 161,2898 }, { 162,2898 },
 { 163,2898 }, { 164,2898 }, { 165,2898 }, { 166,2898 }, { 167,2898 },
 { 168,2898 }, { 169,2898 }, { 170,2898 }, { 171,2898 }, { 172,2898 },
 { 173,2898 }, { 174,2898 }, { 175,2898 }, { 176,2898 }, { 177,2898 },
 { 178,2898 }, { 179,2898 }, { 180,2898 }, { 181,2898 }, { 182,2898 },
 { 183,2898 }, { 184,2898 }, { 185,2898 }, { 186,2898 }, { 187,2898 },
 { 188,2898 }, { 189,2898 }, { 190,2898 }, { 191,2898 }, { 192,2898 },

 { 193,2898 }, { 194,2898 }, { 195,2898 }, { 196,2898 }, { 197,2898 },
 { 198,2898 }, { 199,2898 }, { 200,2898 }, { 201,2898 }, { 202,2898 },
 { 203,2898 }, { 204,2898 }, { 205,2898 }, { 206,2898 }, { 207,2898 },
 { 208,2898 }, { 209,2898 }, { 210,2898 }, { 211,2898 }, { 212,2898 },
 { 213,2898 }, { 214,2898 }, { 215,2898 }, { 216,2898 }, { 217,2898 },
 { 218,2898 }, { 219,2898 }, { 220,2898 }, { 221,2898 }, { 222,2898 },
 { 223,2898 }, { 224,2898 }, { 225,2898 }, { 226,2898 }, { 227,2898 },
 { 228,2898 }, { 229,2898 }, { 230,2898 }, { 231,2898 }, { 232,2898 },
 { 233,2898 }, { 234,2898 }, { 235,2898 }, { 236,2898 }, { 237,2898 },
 { 238,2898 }, { 239,2898 }, { 240,2898 }, { 241,2898 }, { 242,2898 },

 { 243,2898 }, { 244,2898 }, { 245,2898 }, { 246,2898 }, { 247,2898 },
 { 248,2898 }, { 249,2898 }, { 250,2898 }, { 251,2898 }, { 252,2898 },
 { 253,2898 }, { 254,2898 }, { 255,2898 }, { 256,2898 }, {   0,   0 },
 {   0,17933 }, {   1,6867 }, {   2,6867 }, {   3,6867 }, {   4,6867 },
 {   5,6867 }, {   6,6867 }, {   7,6867 }, {   8,6867 }, {   9,6867 },
 {  10,7125 }, {  11,6867 }, {  12,6867 }, {  13,6867 }, {  14,6867 },
 {  15,6867 }, {  16,6867 }, {  17,6867 }, {  18,6867 }, {  19,6867 },
 {  20,6867 }, {  21,6867 }, {  22,6867 }, {  23,6867 }, {  24,6867 },
 {  25,6867 }, {  26,6867 }, {  27,6867 }, {  28,6867 }, {  29,6867 },
 {  30,6867 }, {  31,6867 }, {  32,6867 }, {  33,6867 }, {  34,6867 },

 {  35,6867 }, {  36,6867 }, {  37,6867 }, {  38,6867 }, {  39,2645 },
 {  40,6867 }, {  41,6867 }, {  42,6867 }, {  43,6867 }, {  44,6867 },
 {  45,6867 }, {  46,6867 }, {  47,6867 }, {  48,6867 }, {  49,6867 },
 {  50,6867 }, {  51,6867 }, {  52,6867 }, {  53,6867 }, {  54,6867 },
 {  55,6867 }, {  56,6867 }, {  57,6867 }, {  58,6867 }, {  59,6867 },
 {  60,6867 }, {  61,6867 }, {  62,6867 }, {  63,6867 }, {  64,6867 },
 {  65,6867 }, {  66,6867 }, {  67,6867 }, {  68,6867 }, {  69,6867 },
 {  70,6867 }, {  71,6867 }, {  72,6867 }, {  73,6867 }, {  74,6867 },
 {  75,6867 }, {  76,6867 }, {  77,6867 }, {  78,6867 }, {  79,6867 },
 {  80,6867 }, {  81,6867 }, {  82,6867 }, {  83,6867 }, {  84,6867 },

 {  85,6867 }, {  86,6867 }, {  87,6867 }, {  88,6867 }, {  89,6867 },
 {  90,6867 }, {  91,6867 }, {  92,7383 }, {  93,6867 }, {  94,6867 },
 {  95,6867 }, {  96,6867 }, {  97,6867 }, {  98,6867 }, {  99,6867 },
 { 100,6867 }, { 101,6867 }, { 102,6867 }, { 103,6867 }, { 104,6867 },
 { 105,6867 }, { 106,6867 }, { 107,6867 }, { 108,6867 }, { 109,6867 },
 { 110,6867 }, { 111,6867 }, { 112,6867 }, { 113,6867 }, { 114,6867 },
 { 115,6867 }, { 116,6867 }, { 117,6867 }, { 118,6867 }, { 119,6867 },
 { 120,6867 }, { 121,6867 }, { 122,6867 }, { 123,6867 }, { 124,6867 },
 { 125,6867 }, { 126,6867 }, { 127,6867 }, { 128,6867 }, { 129,6867 },
 { 130,6867 }, { 131,6867 }, { 132,6867 }, { 133,6867 }, { 134,6867 },

 { 135,6867 }, { 136,6867 }, { 137,6867 }, { 138,6867 }, { 139,6867 },
 { 140,6867 }, { 141,6867 }, { 142,6867 }, { 143,6867 }, { 144,6867 },
 { 145,6867 }, { 146,6867 }, { 147,6867 }, { 148,6867 }, { 149,6867 },
 { 150,6867 }, { 151,6867 }, { 152,6867 }, { 153,6867 }, { 154,6867 },
 { 155,6867 }, { 156,6867 }, { 157,6867 }, { 158,6867 }, { 159,6867 },
 { 160,6867 }, { 161,6867 }, { 162,6867 }, { 163,6867 }, { 164,6867 },
 { 165,6867 }, { 166,6867 }, { 167,6867 }, { 168,6867 }, { 169,6867 },
 { 170,6867 }, { 171,6867 }, { 172,6867 }, { 173,6867 }, { 174,6867 },
 { 175,6867 }, { 176,6867 }, { 177,6867 }, { 178,6867 }, { 179,6867 },
 { 180,6867 }, { 181,6867 }, { 182,6867 }, { 183,6867 }, { 184,6867 },

 { 185,6867 }, { 186,6867 }, { 187,6867 }, { 188,6867 }, { 189,6867 },
 { 190,6867 }, { 191,6867 }, { 192,6867 }, { 193,6867 }, { 194,6867 },
 { 195,6867 }, { 196,6867 }, { 197,6867 }, { 198,6867 }, { 199,6867 },
 { 200,6867 }, { 201,6867 }, { 202,6867 }, { 203,6867 }, { 204,6867 },
 { 205,6867 }, { 206,6867 }, { 207,6867 }, { 208,6867 }, { 209,6867 },
 { 210,6867 }, { 211,6867 }, { 212,6867 }, { 213,6867 }, { 214,6867 },
 { 215,6867 }, { 216,6867 }, { 217,6867 }, { 218,6867 }, { 219,6867 },
 { 220,6867 }, { 221,6867 }, { 222,6867 }, { 223,6867 }, { 224,6867 },
 { 225,6867 }, { 226,6867 }, { 227,6867 }, { 228,6867 }, { 229,6867 },
 { 230,6867 }, { 231,6867 }, { 232,6867 }, { 233,6867 }, { 234,6867 },

 { 235,6867 }, { 236,6867 }, { 237,6867 }, { 238,6867 }, { 239,6867 },
 { 240,6867 }, { 241,6867 }, { 242,6867 }, { 243,6867 }, { 244,6867 },
 { 245,6867 }, { 246,6867 }, { 247,6867 }, { 248,6867 }, { 249,6867 },
 { 250,6867 }, { 251,6867 }, { 252,6867 }, { 253,6867 }, { 254,6867 },
 { 255,6867 }, { 256,6867 }, {   0,   0 }, {   0,17675 }, {   1,6609 },
 {   2,6609 }, {   3,6609 }, {   4,6609 }, {   5,6609 }, {   6,6609 },
 {   7,6609 }, {   8,6609 }, {   9,6609 }, {  10,6867 }, {  11,6609 },
 {  12,6609 }, {  13,6609 }, {  14,6609 }, {  15,6609 }, {  16,6609 },
 {  17,6609 }, {  18,6609 }, {  19,6609 }, {  20,6609 }, {  21,6609 },
 {  22,6609 }, {  23,6609 }, {  24,6609 }, {  25,6609 }, {  26,6609 },

 {  27,6609 }, {  28,6609 }, {  29,6609 }, {  30,6609 }, {  31,6609 },
 {  32,6609 }, {  33,6609 }, {  34,6609 }, {  35,6609 }, {  36,6609 },
 {  37,6609 }, {  38,6609 }, {  39,2387 }, {  40,6609 }, {  41,6609 },
 {  42,6609 }, {  43,6609 }, {  44,6609 }, {  45,6609 }, {  46,6609 },
 {  47,6609 }, {  48,6609 }, {  49,6609 }, {  50,6609 }, {  51,6609 },
 {  52,6609 }, {  53,6609 }, {  54,6609 }, {  55,6609 }, {  56,6609 },
 {  57,6609 }, {  58,6609 }, {  59,6609 }, {  60,6609 }, {  61,6609 },
 {  62,6609 }, {  63,6609 }, {  64,6609 }, {  65,6609 }, {  66,6609 },
 {  67,6609 }, {  68,6609 }, {  69,6609 }, {  70,6609 }, {  71,6609 },
 {  72,6609 }, {  73,6609 }, {  74,6609 }, {  75,6609 }, {  76,6609 },

 {  77,6609 }, {  78,6609 }, {  79,6609 }, {  80,6609 }, {  81,6609 },
 {  82,6609 }, {  83,6609 }, {  84,6609 }, {  85,6609 }, {  86,6609 },
 {  87,6609 }, {  88,6609 }, {  89,6609 }, {  90,6609 }, {  91,6609 },
 {  92,7125 }, {  93,6609 }, {  94,6609 }, {  95,6609 }, {  96,6609 },
 {  97,6609 }, {  98,6609 }, {  99,6609 }, { 100,6609 }, { 101,6609 },
 { 102,6609 }, { 103,6609 }, { 104,6609 }, { 105,6609 }, { 106,6609 },
 { 107,6609 }, { 108,6609 }, { 109,6609 }, { 110,6609 }, { 111,6609 },
 { 112,6609 }, { 113,6609 }, { 114,6609 }, { 115,6609 }, { 116,6609 },
 { 117,6609 }, { 118,6609 }, { 119,6609 }, { 120,6609 }, { 121,6609 },
 { 122,6609 }, { 123,6609 }, { 124,6609 }, { 125,6609 }, { 126,6609 },

 { 127,6609 }, { 128,6609 }, { 129,6609 }, { 130,6609 }, { 131,6609 },
 { 132,6609 }, { 133,6609 }, { 134,6609 }, { 135,6609 }, { 136,6609 },
 { 137,6609 }, { 138,6609 }, { 139,6609 }, { 140,6609 }, { 141,6609 },
 { 142,6609 }, { 143,6609 }, { 144,6609 }, { 145,6609 }, { 146,6609 },
 { 147,6609 }, { 148,6609 }, { 149,6609 }, { 150,6609 }, { 151,6609 },
 { 152,6609 }, { 153,6609 }, { 154,6609 }, { 155,6609 }, { 156,6609 },
 { 157,6609 }, { 158,6609 }, { 159,6609 }, { 160,6609 }, { 161,6609 },
 { 162,6609 }, { 163,6609 }, { 164,6609 }, { 165,6609 }, { 166,6609 },
 { 167,6609 }, { 168,6609 }, { 169,6609 }, { 170,6609 }, { 171,6609 },
 { 172,6609 }, { 173,6609 }, { 174,6609 }, { 175,6609 }, { 176,6609 },

 { 177,6609 }, { 178,6609 }, { 179,6609 }, { 180,6609 }, { 181,6609 },
 { 182,6609 }, { 183,6609 }, { 184,6609 }, { 185,6609 }, { 186,6609 },
 { 187,6609 }, { 188,6609 }, { 189,6609 }, { 190,6609 }, { 191,6609 },
 { 192,6609 }, { 193,6609 }, { 194,6609 }, { 195,6609 }, { 196,6609 },
 { 197,6609 }, { 198,6609 }, { 199,6609 }, { 200,6609 }, { 201,6609 },
 { 202,6609 }, { 203,6609 }, { 204,6609 }, { 205,6609 }, { 206,6609 },
 { 207,6609 }, { 208,6609 }, { 209,6609 }, { 210,6609 }, { 211,6609 },
 { 212,6609 }, { 213,6609 }, { 214,6609 }, { 215,6609 }, { 216,6609 },
 { 217,6609 }, { 218,6609 }, { 219,6609 }, { 220,6609 }, { 221,6609 },
 { 222,6609 }, { 223,6609 }, { 224,6609 }, { 225,6609 }, { 226,6609 },

 { 227,6609 }, { 228,6609 }, { 229,6609 }, { 230,6609 }, { 231,6609 },
 { 232,6609 }, { 233,6609 }, { 234,6609 }, { 235,6609 }, { 236,6609 },
 { 237,6609 }, { 238,6609 }, { 239,6609 }, { 240,6609 }, { 241,6609 },
 { 242,6609 }, { 243,6609 }, { 244,6609 }, { 245,6609 }, { 246,6609 },
 { 247,6609 }, { 248,6609 }, { 249,6609 }, { 250,6609 }, { 251,6609 },
 { 252,6609 }, { 253,6609 }, { 254,6609 }, { 255,6609 }, { 256,6609 },
 {   0,   0 }, {   0,17417 }, {   1,7125 }, {   2,7125 }, {   3,7125 },
 {   4,7125 }, {   5,7125 }, {   6,7125 }, {   7,7125 }, {   8,7125 },
 {   9,7125 }, {  10,7383 }, {  11,7125 }, {  12,7125 }, {  13,7125 },
 {  14,7125 }, {  15,7125 }, {  16,7125 }, {  17,7125 }, {  18,7125 },

 {  19,7125 }, {  20,7125 }, {  21,7125 }, {  22,7125 }, {  23,7125 },
 {  24,7125 }, {  25,7125 }, {  26,7125 }, {  27,7125 }, {  28,7125 },
 {  29,7125 }, {  30,7125 }, {  31,7125 }, {  32,7125 }, {  33,7125 },
 {  34,7125 }, {  35,7125 }, {  36,7641 }, {  37,7125 }, {  38,7125 },
 {  39,7125 }, {  40,7125 }, {  41,7125 }, {  42,7125 }, {  43,7125 },
 {  44,7125 }, {  45,7125 }, {  46,7125 }, {  47,7125 }, {  48,7125 },
 {  49,7125 }, {  50,7125 }, {  51,7125 }, {  52,7125 }, {  53,7125 },
 {  54,7125 }, {  55,7125 }, {  56,7125 }, {  57,7125 }, {  58,7125 },
 {  59,7125 }, {  60,7125 }, {  61,7125 }, {  62,7125 }, {  63,7125 },
 {  64,7125 }, {  65,7125 }, {  66,7125 }, {  67,7125 }, {  68,7125 },

 {  69,7125 }, {  70,7125 }, {  71,7125 }, {  72,7125 }, {  73,7125 },
 {  74,7125 }, {  75,7125 }, {  76,7125 }, {  77,7125 }, {  78,7125 },
 {  79,7125 }, {  80,7125 }, {  81,7125 }, {  82,7125 }, {  83,7125 },
 {  84,7125 }, {  85,7125 }, {  86,7125 }, {  87,7125 }, {  88,7125 },
 {  89,7125 }, {  90,7125 }, {  91,7125 }, {  92,7125 }, {  93,7125 },
 {  94,7125 }, {  95,7125 }, {  96,7125 }, {  97,7125 }, {  98,7125 },
 {  99,7125 }, { 100,7125 }, { 101,7125 }, { 102,7125 }, { 103,7125 },
 { 104,7125 }, { 105,7125 }, { 106,7125 }, { 107,7125 }, { 108,7125 },
 { 109,7125 }, { 110,7125 }, { 111,7125 }, { 112,7125 }, { 113,7125 },
 { 114,7125 }, { 115,7125 }, { 116,7125 }, { 117,7125 }, { 118,7125 },

 { 119,7125 }, { 120,7125 }, { 121,7125 }, { 122,7125 }, { 123,7125 },
 { 124,7125 }, { 125,7125 }, { 126,7125 }, { 127,7125 }, { 128,7125 },
 { 129,7125 }, { 130,7125 }, { 131,7125 }, { 132,7125 }, { 133,7125 },
 { 134,7125 }, { 135,7125 }, { 136,7125 }, { 137,7125 }, { 138,7125 },
 { 139,7125 }, { 140,7125 }, { 141,7125 }, { 142,7125 }, { 143,7125 },
 { 144,7125 }, { 145,7125 }, { 146,7125 }, { 147,7125 }, { 148,7125 },
 { 149,7125 }, { 150,7125 }, { 151,7125 }, { 152,7125 }, { 153,7125 },
 { 154,7125 }, { 155,7125 }, { 156,7125 }, { 157,7125 }, { 158,7125 },
 { 159,7125 }, { 160,7125 }, { 161,7125 }, { 162,7125 }, { 163,7125 },
 { 164,7125 }, { 165,7125 }, { 166,7125 }, { 167,7125 }, { 168,7125 },

 { 169,7125 }, { 170,7125 }, { 171,7125 }, { 172,7125 }, { 173,7125 },
 { 174,7125 }, { 175,7125 }, { 176,7125 }, { 177,7125 }, { 178,7125 },
 { 179,7125 }, { 180,7125 }, { 181,7125 }, { 182,7125 }, { 183,7125 },
 { 184,7125 }, { 185,7125 }, { 186,7125 }, { 187,7125 }, { 188,7125 },
 { 189,7125 }, { 190,7125 }, { 191,7125 }, { 192,7125 }, { 193,7125 },
 { 194,7125 }, { 195,7125 }, { 196,7125 }, { 197,7125 }, { 198,7125 },
 { 199,7125 }, { 200,7125 }, { 201,7125 }, { 202,7125 }, { 203,7125 },
 { 204,7125 }, { 205,7125 }, { 206,7125 }, { 207,7125 }, { 208,7125 },
 { 209,7125 }, { 210,7125 }, { 211,7125 }, { 212,7125 }, { 213,7125 },
 { 214,7125 }, { 215,7125 }, { 216,7125 }, { 217,7125 }, { 218,7125 },

 { 219,7125 }, { 220,7125 }, { 221,7125 }, { 222,7125 }, { 223,7125 },
 { 224,7125 }, { 225,7125 }, { 226,7125 }, { 227,7125 }, { 228,7125 },
 { 229,7125 }, { 230,7125 }, { 231,7125 }, { 232,7125 }, { 233,7125 },
 { 234,7125 }, { 235,7125 }, { 236,7125 }, { 237,7125 }, { 238,7125 },
 { 239,7125 }, { 240,7125 }, { 241,7125 }, { 242,7125 }, { 243,7125 },
 { 244,7125 }, { 245,7125 }, { 246,7125 }, { 247,7125 }, { 248,7125 },
 { 249,7125 }, { 250,7125 }, { 251,7125 }, { 252,7125 }, { 253,7125 },
 { 254,7125 }, { 255,7125 }, { 256,7125 }, {   0,   0 }, {   0,17159 },
 {   1,6867 }, {   2,6867 }, {   3,6867 }, {   4,6867 }, {   5,6867 },
 {   6,6867 }, {   7,6867 }, {   8,6867 }, {   9,6867 }, {  10,7125 },

 {  11,6867 }, {  12,6867 }, {  13,6867 }, {  14,6867 }, {  15,6867 },
 {  16,6867 }, {  17,6867 }, {  18,6867 }, {  19,6867 }, {  20,6867 },
 {  21,6867 }, {  22,6867 }, {  23,6867 }, {  24,6867 }, {  25,6867 },
 {  26,6867 }, {  27,6867 }, {  28,6867 }, {  29,6867 }, {  30,6867 },
 {  31,6867 }, {  32,6867 }, {  33,6867 }, {  34,6867 }, {  35,6867 },
 {  36,7383 }, {  37,6867 }, {  38,6867 }, {  39,6867 }, {  40,6867 },
 {  41,6867 }, {  42,6867 }, {  43,6867 }, {  44,6867 }, {  45,6867 },
 {  46,6867 }, {  47,6867 }, {  48,6867 }, {  49,6867 }, {  50,6867 },
 {  51,6867 }, {  52,6867 }, {  53,6867 }, {  54,6867 }, {  55,6867 },
 {  56,6867 }, {  57,6867 }, {  58,6867 }, {  59,6867 }, {  60,6867 },

 {  61,6867 }, {  62,6867 }, {  63,6867 }, {  64,6867 }, {  65,6867 },
 {  66,6867 }, {  67,6867 }, {  68,6867 }, {  69,6867 }, {  70,6867 },
 {  71,6867 }, {  72,6867 }, {  73,6867 }, {  74,6867 }, {  75,6867 },
 {  76,6867 }, {  77,6867 }, {  78,6867 }, {  79,6867 }, {  80,6867 },
 {  81,6867 }, {  82,6867 }, {  83,6867 }, {  84,6867 }, {  85,6867 },
 {  86,6867 }, {  87,6867 }, {  88,6867 }, {  89,6867 }, {  90,6867 },
 {  91,6867 }, {  92,6867 }, {  93,6867 }, {  94,6867 }, {  95,6867 },
 {  96,6867 }, {  97,6867 }, {  98,6867 }, {  99,6867 }, { 100,6867 },
 { 101,6867 }, { 102,6867 }, { 103,6867 }, { 104,6867 }, { 105,6867 },
 { 106,6867 }, { 107,6867 }, { 108,6867 }, { 109,6867 }, { 110,6867 },

 { 111,6867 }, { 112,6867 }, { 113,6867 }, { 114,6867 }, { 115,6867 },
 { 116,6867 }, { 117,6867 }, { 118,6867 }, { 119,6867 }, { 120,6867 },
 { 121,6867 }, { 122,6867 }, { 123,6867 }, { 124,6867 }, { 125,6867 },
 { 126,6867 }, { 127,6867 }, { 128,6867 }, { 129,6867 }, { 130,6867 },
 { 131,6867 }, { 132,6867 }, { 133,6867 }, { 134,6867 }, { 135,6867 },
 { 136,6867 }, { 137,6867 }, { 138,6867 }, { 139,6867 }, { 140,6867 },
 { 141,6867 }, { 142,6867 }, { 143,6867 }, { 144,6867 }, { 145,6867 },
 { 146,6867 }, { 147,6867 }, { 148,6867 }, { 149,6867 }, { 150,6867 },
 { 151,6867 }, { 152,6867 }, { 153,6867 }, { 154,6867 }, { 155,6867 },
 { 156,6867 }, { 157,6867 }, { 158,6867 }, { 159,6867 }, { 160,6867 },

 { 161,6867 }, { 162,6867 }, { 163,6867 }, { 164,6867 }, { 165,6867 },
 { 166,6867 }, { 167,6867 }, { 168,6867 }, { 169,6867 }, { 170,6867 },
 { 171,6867 }, { 172,6867 }, { 173,6867 }, { 174,6867 }, { 175,6867 },
 { 176,6867 }, { 177,6867 }, { 178,6867 }, { 179,6867 }, { 180,6867 },
 { 181,6867 }, { 182,6867 }, { 183,6867 }, { 184,6867 }, { 185,6867 },
 { 186,6867 }, { 187,6867 }, { 188,6867 }, { 189,6867 }, { 190,6867 },
 { 191,6867 }, { 192,6867 }, { 193,6867 }, { 194,6867 }, { 195,6867 },
 { 196,6867 }, { 197,6867 }, { 198,6867 }, { 199,6867 }, { 200,6867 },
 { 201,6867 }, { 202,6867 }, { 203,6867 }, { 204,6867 }, { 205,6867 },
 { 206,6867 }, { 207,6867 }, { 208,6867 }, { 209,6867 }, { 210,6867 },

 { 211,6867 }, { 212,6867 }, { 213,6867 }, { 214,6867 }, { 215,6867 },
 { 216,6867 }, { 217,6867 }, { 218,6867 }, { 219,6867 }, { 220,6867 },
 { 221,6867 }, { 222,6867 }, { 223,6867 }, { 224,6867 }, { 225,6867 },
 { 226,6867 }, { 227,6867 }, { 228,6867 }, { 229,6867 }, { 230,6867 },
 { 231,6867 }, { 232,6867 }, { 233,6867 }, { 234,6867 }, { 235,6867 },
 { 236,6867 }, { 237,6867 }, { 238,6867 }, { 239,6867 }, { 240,6867 },
 { 241,6867 }, { 242,6867 }, { 243,6867 }, { 244,6867 }, { 245,6867 },
 { 246,6867 }, { 247,6867 }, { 248,6867 }, { 249,6867 }, { 250,6867 },
 { 251,6867 }, { 252,6867 }, { 253,6867 }, { 254,6867 }, { 255,6867 },
 { 256,6867 }, {   0,   0 }, {   0,16901 }, {   1,4993 }, {   2,4993 },

 {   3,4993 }, {   4,4993 }, {   5,4993 }, {   6,4993 }, {   7,4993 },
 {   8,4993 }, {   9,4993 }, {  10,4993 }, {  11,4993 }, {  12,4993 },
 {  13,4993 }, {  14,4993 }, {  15,4993 }, {  16,4993 }, {  17,4993 },
 {  18,4993 }, {  19,4993 }, {  20,4993 }, {  21,4993 }, {  22,4993 },
 {  23,4993 }, {  24,4993 }, {  25,4993 }, {  26,4993 }, {  27,4993 },
 {  28,4993 }, {  29,4993 }, {  30,4993 }, {  31,4993 }, {  32,4993 },
 {  33,4993 }, {  34,1615 }, {  35,4993 }, {  36,4993 }, {  37,4993 },
 {  38,4993 }, {  39,4993 }, {  40,4993 }, {  41,4993 }, {  42,4993 },
 {  43,4993 }, {  44,4993 }, {  45,4993 }, {  46,4993 }, {  47,4993 },
 {  48,4993 }, {  49,4993 }, {  50,4993 }, {  51,4993 }, {  52,4993 },

 {  53,4993 }, {  54,4993 }, {  55,4993 }, {  56,4993 }, {  57,4993 },
 {  58,4993 }, {  59,4993 }, {  60,4993 }, {  61,4993 }, {  62,4993 },
 {  63,4993 }, {  64,4993 }, {  65,4993 }, {  66,4993 }, {  67,4993 },
 {  68,4993 }, {  69,4993 }, {  70,4993 }, {  71,4993 }, {  72,4993 },
 {  73,4993 }, {  74,4993 }, {  75,4993 }, {  76,4993 }, {  77,4993 },
 {  78,4993 }, {  79,4993 }, {  80,4993 }, {  81,4993 }, {  82,4993 },
 {  83,4993 }, {  84,4993 }, {  85,4993 }, {  86,4993 }, {  87,4993 },
 {  88,4993 }, {  89,4993 }, {  90,4993 }, {  91,4993 }, {  92,4993 },
 {  93,4993 }, {  94,4993 }, {  95,4993 }, {  96,4993 }, {  97,4993 },
 {  98,4993 }, {  99,4993 }, { 100,4993 }, { 101,4993 }, { 102,4993 },

 { 103,4993 }, { 104,4993 }, { 105,4993 }, { 106,4993 }, { 107,4993 },
 { 108,4993 }, { 109,4993 }, { 110,4993 }, { 111,4993 }, { 112,4993 },
 { 113,4993 }, { 114,4993 }, { 115,4993 }, { 116,4993 }, { 117,4993 },
 { 118,4993 }, { 119,4993 }, { 120,4993 }, { 121,4993 }, { 122,4993 },
 { 123,4993 }, { 124,4993 }, { 125,4993 }, { 126,4993 }, { 127,4993 },
 { 128,4993 }, { 129,4993 }, { 130,4993 }, { 131,4993 }, { 132,4993 },
 { 133,4993 }, { 134,4993 }, { 135,4993 }, { 136,4993 }, { 137,4993 },
 { 138,4993 }, { 139,4993 }, { 140,4993 }, { 141,4993 }, { 142,4993 },
 { 143,4993 }, { 144,4993 }, { 145,4993 }, { 146,4993 }, { 147,4993 },
 { 148,4993 }, { 149,4993 }, { 150,4993 }, { 151,4993 }, { 152,4993 },

 { 153,4993 }, { 154,4993 }, { 155,4993 }, { 156,4993 }, { 157,4993 },
 { 158,4993 }, { 159,4993 }, { 160,4993 }, { 161,4993 }, { 162,4993 },
 { 163,4993 }, { 164,4993 }, { 165,4993 }, { 166,4993 }, { 167,4993 },
 { 168,4993 }, { 169,4993 }, { 170,4993 }, { 171,4993 }, { 172,4993 },
 { 173,4993 }, { 174,4993 }, { 175,4993 }, { 176,4993 }, { 177,4993 },
 { 178,4993 }, { 179,4993 }, { 180,4993 }, { 181,4993 }, { 182,4993 },
 { 183,4993 }, { 184,4993 }, { 185,4993 }, { 186,4993 }, { 187,4993 },
 { 188,4993 }, { 189,4993 }, { 190,4993 }, { 191,4993 }, { 192,4993 },
 { 193,4993 }, { 194,4993 }, { 195,4993 }, { 196,4993 }, { 197,4993 },
 { 198,4993 }, { 199,4993 }, { 200,4993 }, { 201,4993 }, { 202,4993 },

 { 203,4993 }, { 204,4993 }, { 205,4993 }, { 206,4993 }, { 207,4993 },
 { 208,4993 }, { 209,4993 }, { 210,4993 }, { 211,4993 }, { 212,4993 },
 { 213,4993 }, { 214,4993 }, { 215,4993 }, { 216,4993 }, { 217,4993 },
 { 218,4993 }, { 219,4993 }, { 220,4993 }, { 221,4993 }, { 222,4993 },
 { 223,4993 }, { 224,4993 }, { 225,4993 }, { 226,4993 }, { 227,4993 },
 { 228,4993 }, { 229,4993 }, { 230,4993 }, { 231,4993 }, { 232,4993 },
 { 233,4993 }, { 234,4993 }, { 235,4993 }, { 236,4993 }, { 237,4993 },
 { 238,4993 }, { 239,4993 }, { 240,4993 }, { 241,4993 }, { 242,4993 },
 { 243,4993 }, { 244,4993 }, { 245,4993 }, { 246,4993 }, { 247,4993 },
 { 248,4993 }, { 249,4993 }, { 250,4993 }, { 251,4993 }, { 252,4993 },

 { 253,4993 }, { 254,4993 }, { 255,4993 }, { 256,4993 }, {   0,   0 },
 {   0,16643 }, {   1,4735 }, {   2,4735 }, {   3,4735 }, {   4,4735 },
 {   5,4735 }, {   6,4735 }, {   7,4735 }, {   8,4735 }, {   9,4735 },
 {  10,4735 }, {  11,4735 }, {  12,4735 }, {  13,4735 }, {  14,4735 },
 {  15,4735 }, {  16,4735 }, {  17,4735 }, {  18,4735 }, {  19,4735 },
 {  20,4735 }, {  21,4735 }, {  22,4735 }, {  23,4735 }, {  24,4735 },
 {  25,4735 }, {  26,4735 }, {  27,4735 }, {  28,4735 }, {  29,4735 },
 {  30,4735 }, {  31,4735 }, {  32,4735 }, {  33,4735 }, {  34,1357 },
 {  35,4735 }, {  36,4735 }, {  37,4735 }, {  38,4735 }, {  39,4735 },
 {  40,4735 }, {  41,4735 }, {  42,4735 }, {  43,4735 }, {  44,4735 },

 {  45,4735 }, {  46,4735 }, {  47,4735 }, {  48,4735 }, {  49,4735 },
 {  50,4735 }, {  51,4735 }, {  52,4735 }, {  53,4735 }, {  54,4735 },
 {  55,4735 }, {  56,4735 }, {  57,4735 }, {  58,4735 }, {  59,4735 },
 {  60,4735 }, {  61,4735 }, {  62,4735 }, {  63,4735 }, {  64,4735 },
 {  65,4735 }, {  66,4735 }, {  67,4735 }, {  68,4735 }, {  69,4735 },
 {  70,4735 }, {  71,4735 }, {  72,4735 }, {  73,4735 }, {  74,4735 },
 {  75,4735 }, {  76,4735 }, {  77,4735 }, {  78,4735 }, {  79,4735 },
 {  80,4735 }, {  81,4735 }, {  82,4735 }, {  83,4735 }, {  84,4735 },
 {  85,4735 }, {  86,4735 }, {  87,4735 }, {  88,4735 }, {  89,4735 },
 {  90,4735 }, {  91,4735 }, {  92,4735 }, {  93,4735 }, {  94,4735 },

 {  95,4735 }, {  96,4735 }, {  97,4735 }, {  98,4735 }, {  99,4735 },
 { 100,4735 }, { 101,4735 }, { 102,4735 }, { 103,4735 }, { 104,4735 },
 { 105,4735 }, { 106,4735 }, { 107,4735 }, { 108,4735 }, { 109,4735 },
 { 110,4735 }, { 111,4735 }, { 112,4735 }, { 113,4735 }, { 114,4735 },
 { 115,4735 }, { 116,4735 }, { 117,4735 }, { 118,4735 }, { 119,4735 },
 { 120,4735 }, { 121,4735 }, { 122,4735 }, { 123,4735 }, { 124,4735 },
 { 125,4735 }, { 126,4735 }, { 127,4735 }, { 128,4735 }, { 129,4735 },
 { 130,4735 }, { 131,4735 }, { 132,4735 }, { 133,4735 }, { 134,4735 },
 { 135,4735 }, { 136,4735 }, { 137,4735 }, { 138,4735 }, { 139,4735 },
 { 140,4735 }, { 141,4735 }, { 142,4735 }, { 143,4735 }, { 144,4735 },

 { 145,4735 }, { 146,4735 }, { 147,4735 }, { 148,4735 }, { 149,4735 },
 { 150,4735 }, { 151,4735 }, { 152,4735 }, { 153,4735 }, { 154,4735 },
 { 155,4735 }, { 156,4735 }, { 157,4735 }, { 158,4735 }, { 159,4735 },
 { 160,4735 }, { 161,4735 }, { 162,4735 }, { 163,4735 }, { 164,4735 },
 { 165,4735 }, { 166,4735 }, { 167,4735 }, { 168,4735 }, { 169,4735 },
 { 170,4735 }, { 171,4735 }, { 172,4735 }, { 173,4735 }, { 174,4735 },
 { 175,4735 }, { 176,4735 }, { 177,4735 }, { 178,4735 }, { 179,4735 },
 { 180,4735 }, { 181,4735 }, { 182,4735 }, { 183,4735 }, { 184,4735 },
 { 185,4735 }, { 186,4735 }, { 187,4735 }, { 188,4735 }, { 189,4735 },
 { 190,4735 }, { 191,4735 }, { 192,4735 }, { 193,4735 }, { 194,4735 },

 { 195,4735 }, { 196,4735 }, { 197,4735 }, { 198,4735 }, { 199,4735 },
 { 200,4735 }, { 201,4735 }, { 202,4735 }, { 203,4735 }, { 204,4735 },
 { 205,4735 }, { 206,4735 }, { 207,4735 }, { 208,4735 }, { 209,4735 },
 { 210,4735 }, { 211,4735 }, { 212,4735 }, { 213,4735 }, { 214,4735 },
 { 215,4735 }, { 216,4735 }, { 217,4735 }, { 218,4735 }, { 219,4735 },
 { 220,4735 }, { 221,4735 }, { 222,4735 }, { 223,4735 }, { 224,4735 },
 { 225,4735 }, { 226,4735 }, { 227,4735 }, { 228,4735 }, { 229,4735 },
 { 230,4735 }, { 231,4735 }, { 232,4735 }, { 233,4735 }, { 234,4735 },
 { 235,4735 }, { 236,4735 }, { 237,4735 }, { 238,4735 }, { 239,4735 },
 { 240,4735 }, { 241,4735 }, { 242,4735 }, { 243,4735 }, { 244,4735 },

 { 245,4735 }, { 246,4735 }, { 247,4735 }, { 248,4735 }, { 249,4735 },
 { 250,4735 }, { 251,4735 }, { 252,4735 }, { 253,4735 }, { 254,4735 },
 { 255,4735 }, { 256,4735 }, {   0,   0 }, {   0,16385 }, {   1,4993 },
 {   2,4993 }, {   3,4993 }, {   4,4993 }, {   5,4993 }, {   6,4993 },
 {   7,4993 }, {   8,4993 }, {   9,4993 }, {  10,4993 }, {  11,4993 },
 {  12,4993 }, {  13,4993 }, {  14,4993 }, {  15,4993 }, {  16,4993 },
 {  17,4993 }, {  18,4993 }, {  19,4993 }, {  20,4993 }, {  21,4993 },
 {  22,4993 }, {  23,4993 }, {  24,4993 }, {  25,4993 }, {  26,4993 },
 {  27,4993 }, {  28,4993 }, {  29,4993 }, {  30,4993 }, {  31,4993 },
 {  32,4993 }, {  33,4993 }, {  34,4993 }, {  35,4993 }, {  36,4993 },

 {  37,4993 }, {  38,4993 }, {  39,1090 }, {  40,4993 }, {  41,4993 },
 {  42,4993 }, {  43,4993 }, {  44,4993 }, {  45,4993 }, {  46,4993 },
 {  47,4993 }, {  48,4993 }, {  49,4993 }, {  50,4993 }, {  51,4993 },
 {  52,4993 }, {  53,4993 }, {  54,4993 }, {  55,4993 }, {  56,4993 },
 {  57,4993 }, {  58,4993 }, {  59,4993 }, {  60,4993 }, {  61,4993 },
 {  62,4993 }, {  63,4993 }, {  64,4993 }, {  65,4993 }, {  66,4993 },
 {  67,4993 }, {  68,4993 }, {  69,4993 }, {  70,4993 }, {  71,4993 },
 {  72,4993 }, {  73,4993 }, {  74,4993 }, {  75,4993 }, {  76,4993 },
 {  77,4993 }, {  78,4993 }, {  79,4993 }, {  80,4993 }, {  81,4993 },
 {  82,4993 }, {  83,4993 }, {  84,4993 }, {  85,4993 }, {  86,4993 },

 {  87,4993 }, {  88,4993 }, {  89,4993 }, {  90,4993 }, {  91,4993 },
 {  92,4993 }, {  93,4993 }, {  94,4993 }, {  95,4993 }, {  96,4993 },
 {  97,4993 }, {  98,4993 }, {  99,4993 }, { 100,4993 }, { 101,4993 },
 { 102,4993 }, { 103,4993 }, { 104,4993 }, { 105,4993 }, { 106,4993 },
 { 107,4993 }, { 108,4993 }, { 109,4993 }, { 110,4993 }, { 111,4993 },
 { 112,4993 }, { 113,4993 }, { 114,4993 }, { 115,4993 }, { 116,4993 },
 { 117,4993 }, { 118,4993 }, { 119,4993 }, { 120,4993 }, { 121,4993 },
 { 122,4993 }, { 123,4993 }, { 124,4993 }, { 125,4993 }, { 126,4993 },
 { 127,4993 }, { 128,4993 }, { 129,4993 }, { 130,4993 }, { 131,4993 },
 { 132,4993 }, { 133,4993 }, { 134,4993 }, { 135,4993 }, { 136,4993 },

 { 137,4993 }, { 138,4993 }, { 139,4993 }, { 140,4993 }, { 141,4993 },
 { 142,4993 }, { 143,4993 }, { 144,4993 }, { 145,4993 }, { 146,4993 },
 { 147,4993 }, { 148,4993 }, { 149,4993 }, { 150,4993 }, { 151,4993 },
 { 152,4993 }, { 153,4993 }, { 154,4993 }, { 155,4993 }, { 156,4993 },
 { 157,4993 }, { 158,4993 }, { 159,4993 }, { 160,4993 }, { 161,4993 },
 { 162,4993 }, { 163,4993 }, { 164,4993 }, { 165,4993 }, { 166,4993 },
 { 167,4993 }, { 168,4993 }, { 169,4993 }, { 170,4993 }, { 171,4993 },
 { 172,4993 }, { 173,4993 }, { 174,4993 }, { 175,4993 }, { 176,4993 },
 { 177,4993 }, { 178,4993 }, { 179,4993 }, { 180,4993 }, { 181,4993 },
 { 182,4993 }, { 183,4993 }, { 184,4993 }, { 185,4993 }, { 186,4993 },

 { 187,4993 }, { 188,4993 }, { 189,4993 }, { 190,4993 }, { 191,4993 },
 { 192,4993 }, { 193,4993 }, { 194,4993 }, { 195,4993 }, { 196,4993 },
 { 197,4993 }, { 198,4993 }, { 199,4993 }, { 200,4993 }, { 201,4993 },
 { 202,4993 }, { 203,4993 }, { 204,4993 }, { 205,4993 }, { 206,4993 },
 { 207,4993 }, { 208,4993 }, { 209,4993 }, { 210,4993 }, { 211,4993 },
 { 212,4993 }, { 213,4993 }, { 214,4993 }, { 215,4993 }, { 216,4993 },
 { 217,4993 }, { 218,4993 }, { 219,4993 }, { 220,4993 }, { 221,4993 },
 { 222,4993 }, { 223,4993 }, { 224,4993 }, { 225,4993 }, { 226,4993 },
 { 227,4993 }, { 228,4993 }, { 229,4993 }, { 230,4993 }, { 231,4993 },
 { 232,4993 }, { 233,4993 }, { 234,4993 }, { 235,4993 }, { 236,4993 },

 { 237,4993 }, { 238,4993 }, { 239,4993 }, { 240,4993 }, { 241,4993 },
 { 242,4993 }, { 243,4993 }, { 244,4993 }, { 245,4993 }, { 246,4993 },
 { 247,4993 }, { 248,4993 }, { 249,4993 }, { 250,4993 }, { 251,4993 },
 { 252,4993 }, { 253,4993 }, { 254,4993 }, { 255,4993 }, { 256,4993 },
 {   0,   0 }, {   0,16127 }, {   1,4735 }, {   2,4735 }, {   3,4735 },
 {   4,4735 }, {   5,4735 }, {   6,4735 }, {   7,4735 }, {   8,4735 },
 {   9,4735 }, {  10,4735 }, {  11,4735 }, {  12,4735 }, {  13,4735 },
 {  14,4735 }, {  15,4735 }, {  16,4735 }, {  17,4735 }, {  18,4735 },
 {  19,4735 }, {  20,4735 }, {  21,4735 }, {  22,4735 }, {  23,4735 },
 {  24,4735 }, {  25,4735 }, {  26,4735 }, {  27,4735 }, {  28,4735 },

 {  29,4735 }, {  30,4735 }, {  31,4735 }, {  32,4735 }, {  33,4735 },
 {  34,4735 }, {  35,4735 }, {  36,4735 }, {  37,4735 }, {  38,4735 },
 {  39, 832 }, {  40,4735 }, {  41,4735 }, {  42,4735 }, {  43,4735 },
 {  44,4735 }, {  45,4735 }, {  46,4735 }, {  47,4735 }, {  48,4735 },
 {  49,4735 }, {  50,4735 }, {  51,4735 }, {  52,4735 }, {  53,4735 },
 {  54,4735 }, {  55,4735 }, {  56,4735 }, {  57,4735 }, {  58,4735 },
 {  59,4735 }, {  60,4735 }, {  61,4735 }, {  62,4735 }, {  63,4735 },
 {  64,4735 }, {  65,4735 }, {  66,4735 }, {  67,4735 }, {  68,4735 },
 {  69,4735 }, {  70,4735 }, {  71,4735 }, {  72,4735 }, {  73,4735 },
 {  74,4735 }, {  75,4735 }, {  76,4735 }, {  77,4735 }, {  78,4735 },

 {  79,4735 }, {  80,4735 }, {  81,4735 }, {  82,4735 }, {  83,4735 },
 {  84,4735 }, {  85,4735 }, {  86,4735 }, {  87,4735 }, {  88,4735 },
 {  89,4735 }, {  90,4735 }, {  91,4735 }, {  92,4735 }, {  93,4735 },
 {  94,4735 }, {  95,4735 }, {  96,4735 }, {  97,4735 }, {  98,4735 },
 {  99,4735 }, { 100,4735 }, { 101,4735 }, { 102,4735 }, { 103,4735 },
 { 104,4735 }, { 105,4735 }, { 106,4735 }, { 107,4735 }, { 108,4735 },
 { 109,4735 }, { 110,4735 }, { 111,4735 }, { 112,4735 }, { 113,4735 },
 { 114,4735 }, { 115,4735 }, { 116,4735 }, { 117,4735 }, { 118,4735 },
 { 119,4735 }, { 120,4735 }, { 121,4735 }, { 122,4735 }, { 123,4735 },
 { 124,4735 }, { 125,4735 }, { 126,4735 }, { 127,4735 }, { 128,4735 },

 { 129,4735 }, { 130,4735 }, { 131,4735 }, { 132,4735 }, { 133,4735 },
 { 134,4735 }, { 135,4735 }, { 136,4735 }, { 137,4735 }, { 138,4735 },
 { 139,4735 }, { 140,4735 }, { 141,4735 }, { 142,4735 }, { 143,4735 },
 { 144,4735 }, { 145,4735 }, { 146,4735 }, { 147,4735 }, { 148,4735 },
 { 149,4735 }, { 150,4735 }, { 151,4735 }, { 152,4735 }, { 153,4735 },
 { 154,4735 }, { 155,4735 }, { 156,4735 }, { 157,4735 }, { 158,4735 },
 { 159,4735 }, { 160,4735 }, { 161,4735 }, { 162,4735 }, { 163,4735 },
 { 164,4735 }, { 165,4735 }, { 166,4735 }, { 167,4735 }, { 168,4735 },
 { 169,4735 }, { 170,4735 }, { 171,4735 }, { 172,4735 }, { 173,4735 },
 { 174,4735 }, { 175,4735 }, { 176,4735 }, { 177,4735 }, { 178,4735 },

 { 179,4735 }, { 180,4735 }, { 181,4735 }, { 182,4735 }, { 183,4735 },
 { 184,4735 }, { 185,4735 }, { 186,4735 }, { 187,4735 }, { 188,4735 },
 { 189,4735 }, { 190,4735 }, { 191,4735 }, { 192,4735 }, { 193,4735 },
 { 194,4735 }, { 195,4735 }, { 196,4735 }, { 197,4735 }, { 198,4735 },
 { 199,4735 }, { 200,4735 }, { 201,4735 }, { 202,4735 }, { 203,4735 },
 { 204,4735 }, { 205,4735 }, { 206,4735 }, { 207,4735 }, { 208,4735 },
 { 209,4735 }, { 210,4735 }, { 211,4735 }, { 212,4735 }, { 213,4735 },
 { 214,4735 }, { 215,4735 }, { 216,4735 }, { 217,4735 }, { 218,4735 },
 { 219,4735 }, { 220,4735 }, { 221,4735 }, { 222,4735 }, { 223,4735 },
 { 224,4735 }, { 225,4735 }, { 226,4735 }, { 227,4735 }, { 228,4735 },

 { 229,4735 }, { 230,4735 }, { 231,4735 }, { 232,4735 }, { 233,4735 },
 { 234,4735 }, { 235,4735 }, { 236,4735 }, { 237,4735 }, { 238,4735 },
 { 239,4735 }, { 240,4735 }, { 241,4735 }, { 242,4735 }, { 243,4735 },
 { 244,4735 }, { 245,4735 }, { 246,4735 }, { 247,4735 }, { 248,4735 },
 { 249,4735 }, { 250,4735 }, { 251,4735 }, { 252,4735 }, { 253,4735 },
 { 254,4735 }, { 255,4735 }, { 256,4735 }, {   0,   0 }, {   0,15869 },
 {   1, 593 }, {   2, 593 }, {   3, 593 }, {   4, 593 }, {   5, 593 },
 {   6, 593 }, {   7, 593 }, {   8, 593 }, {   9, 593 }, {  10, 597 },
 {  11, 593 }, {  12, 593 }, {  13, 593 }, {  14, 593 }, {  15, 593 },
 {  16, 593 }, {  17, 593 }, {  18, 593 }, {  19, 593 }, {  20, 593 },

 {  21, 593 }, {  22, 593 }, {  23, 593 }, {  24, 593 }, {  25, 593 },
 {  26, 593 }, {  27, 593 }, {  28, 593 }, {  29, 593 }, {  30, 593 },
 {  31, 593 }, {  32, 593 }, {  33, 593 }, {  34, 593 }, {  35, 593 },
 {  36, 593 }, {  37, 593 }, {  38, 593 }, {  39, 593 }, {  40, 593 },
 {  41, 593 }, {  42, 593 }, {  43, 593 }, {  44, 593 }, {  45, 593 },
 {  46, 593 }, {  47, 593 }, {  48, 593 }, {  49, 593 }, {  50, 593 },
 {  51, 593 }, {  52, 593 }, {  53, 593 }, {  54, 593 }, {  55, 593 },
 {  56, 593 }, {  57, 593 }, {  58, 593 }, {  59, 593 }, {  60, 593 },
 {  61, 593 }, {  62, 593 }, {  63, 593 }, {  64, 593 }, {  65, 593 },
 {  66, 593 }, {  67, 593 }, {  68, 593 }, {  69, 593 }, {  70, 593 },

 {  71, 593 }, {  72, 593 }, {  73, 593 }, {  74, 593 }, {  75, 593 },
 {  76, 593 }, {  77, 593 }, {  78, 593 }, {  79, 593 }, {  80, 593 },
 {  81, 593 }, {  82, 593 }, {  83, 593 }, {  84, 593 }, {  85, 593 },
 {  86, 593 }, {  87, 593 }, {  88, 593 }, {  89, 593 }, {  90, 593 },
 {  91, 593 }, {  92, 637 }, {  93, 593 }, {  94, 593 }, {  95, 593 },
 {  96, 593 }, {  97, 593 }, {  98, 593 }, {  99, 593 }, { 100, 593 },
 { 101, 593 }, { 102, 593 }, { 103, 593 }, { 104, 593 }, { 105, 593 },
 { 106, 593 }, { 107, 593 }, { 108, 593 }, { 109, 593 }, { 110, 593 },
 { 111, 593 }, { 112, 593 }, { 113, 593 }, { 114, 593 }, { 115, 593 },
 { 116, 593 }, { 117, 593 }, { 118, 593 }, { 119, 593 }, { 120, 593 },

 { 121, 593 }, { 122, 593 }, { 123, 593 }, { 124, 593 }, { 125, 593 },
 { 126, 593 }, { 127, 593 }, { 128, 593 }, { 129, 593 }, { 130, 593 },
 { 131, 593 }, { 132, 593 }, { 133, 593 }, { 134, 593 }, { 135, 593 },
 { 136, 593 }, { 137, 593 }, { 138, 593 }, { 139, 593 }, { 140, 593 },
 { 141, 593 }, { 142, 593 }, { 143, 593 }, { 144, 593 }, { 145, 593 },
 { 146, 593 }, { 147, 593 }, { 148, 593 }, { 149, 593 }, { 150, 593 },
 { 151, 593 }, { 152, 593 }, { 153, 593 }, { 154, 593 }, { 155, 593 },
 { 156, 593 }, { 157, 593 }, { 158, 593 }, { 159, 593 }, { 160, 593 },
 { 161, 593 }, { 162, 593 }, { 163, 593 }, { 164, 593 }, { 165, 593 },
 { 166, 593 }, { 167, 593 }, { 168, 593 }, { 169, 593 }, { 170, 593 },

 { 171, 593 }, { 172, 593 }, { 173, 593 }, { 174, 593 }, { 175, 593 },
 { 176, 593 }, { 177, 593 }, { 178, 593 }, { 179, 593 }, { 180, 593 },
 { 181, 593 }, { 182, 593 }, { 183, 593 }, { 184, 593 }, { 185, 593 },
 { 186, 593 }, { 187, 593 }, { 188, 593 }, { 189, 593 }, { 190, 593 },
 { 191, 593 }, { 192, 593 }, { 193, 593 }, { 194, 593 }, { 195, 593 },
 { 196, 593 }, { 197, 593 }, { 198, 593 }, { 199, 593 }, { 200, 593 },
 { 201, 593 }, { 202, 593 }, { 203, 593 }, { 204, 593 }, { 205, 593 },
 { 206, 593 }, { 207, 593 }, { 208, 593 }, { 209, 593 }, { 210, 593 },
 { 211, 593 }, { 212, 593 }, { 213, 593 }, { 214, 593 }, { 215, 593 },
 { 216, 593 }, { 217, 593 }, { 218, 593 }, { 219, 593 }, { 220, 593 },

 { 221, 593 }, { 222, 593 }, { 223, 593 }, { 224, 593 }, { 225, 593 },
 { 226, 593 }, { 227, 593 }, { 228, 593 }, { 229, 593 }, { 230, 593 },
 { 231, 593 }, { 232, 593 }, { 233, 593 }, { 234, 593 }, { 235, 593 },
 { 236, 593 }, { 237, 593 }, { 238, 593 }, { 239, 593 }, { 240, 593 },
 { 241, 593 }, { 242, 593 }, { 243, 593 }, { 244, 593 }, { 245, 593 },
 { 246, 593 }, { 247, 593 }, { 248, 593 }, { 249, 593 }, { 250, 593 },
 { 251, 593 }, { 252, 593 }, { 253, 593 }, { 254, 593 }, { 255, 593 },
 { 256, 593 }, {   0,   0 }, {   0,15611 }, {   1, 335 }, {   2, 335 },
 {   3, 335 }, {   4, 335 }, {   5, 335 }, {   6, 335 }, {   7, 335 },
 {   8, 335 }, {   9, 335 }, {  10, 339 }, {  11, 335 }, {  12, 335 },

 {  13, 335 }, {  14, 335 }, {  15, 335 }, {  16, 335 }, {  17, 335 },
 {  18, 335 }, {  19, 335 }, {  20, 335 }, {  21, 335 }, {  22, 335 },
 {  23, 335 }, {  24, 335 }, {  25, 335 }, {  26, 335 }, {  27, 335 },
 {  28, 335 }, {  29, 335 }, {  30, 335 }, {  31, 335 }, {  32, 335 },
 {  33, 335 }, {  34, 335 }, {  35, 335 }, {  36, 335 }, {  37, 335 },
 {  38, 335 }, {  39, 335 }, {  40, 335 }, {  41, 335 }, {  42, 335 },
 {  43, 335 }, {  44, 335 }, {  45, 335 }, {  46, 335 }, {  47, 335 },
 {  48, 335 }, {  49, 335 }, {  50, 335 }, {  51, 335 }, {  52, 335 },
 {  53, 335 }, {  54, 335 }, {  55, 335 }, {  56, 335 }, {  57, 335 },
 {  58, 335 }, {  59, 335 }, {  60, 335 }, {  61, 335 }, {  62, 335 },

 {  63, 335 }, {  64, 335 }, {  65, 335 }, {  66, 335 }, {  67, 335 },
 {  68, 335 }, {  69, 335 }, {  70, 335 }, {  71, 335 }, {  72, 335 },
 {  73, 335 }, {  74, 335 }, {  75, 335 }, {  76, 335 }, {  77, 335 },
 {  78, 335 }, {  79, 335 }, {  80, 335 }, {  81, 335 }, {  82, 335 },
 {  83, 335 }, {  84, 335 }, {  85, 335 }, {  86, 335 }, {  87, 335 },
 {  88, 335 }, {  89, 335 }, {  90, 335 }, {  91, 335 }, {  92, 379 },
 {  93, 335 }, {  94, 335 }, {  95, 335 }, {  96, 335 }, {  97, 335 },
 {  98, 335 }, {  99, 335 }, { 100, 335 }, { 101, 335 }, { 102, 335 },
 { 103, 335 }, { 104, 335 }, { 105, 335 }, { 106, 335 }, { 107, 335 },
 { 108, 335 }, { 109, 335 }, { 110, 335 }, { 111, 335 }, { 112, 335 },

 { 113, 335 }, { 114, 335 }, { 115, 335 }, { 116, 335 }, { 117, 335 },
 { 118, 335 }, { 119, 335 }, { 120, 335 }, { 121, 335 }, { 122, 335 },
 { 123, 335 }, { 124, 335 }, { 125, 335 }, { 126, 335 }, { 127, 335 },
 { 128, 335 }, { 129, 335 }, { 130, 335 }, { 131, 335 }, { 132, 335 },
 { 133, 335 }, { 134, 335 }, { 135, 335 }, { 136, 335 }, { 137, 335 },
 { 138, 335 }, { 139, 335 }, { 140, 335 }, { 141, 335 }, { 142, 335 },
 { 143, 335 }, { 144, 335 }, { 145, 335 }, { 146, 335 }, { 147, 335 },
 { 148, 335 }, { 149, 335 }, { 150, 335 }, { 151, 335 }, { 152, 335 },
 { 153, 335 }, { 154, 335 }, { 155, 335 }, { 156, 335 }, { 157, 335 },
 { 158, 335 }, { 159, 335 }, { 160, 335 }, { 161, 335 }, { 162, 335 },

 { 163, 335 }, { 164, 335 }, { 165, 335 }, { 166, 335 }, { 167, 335 },
 { 168, 335 }, { 169, 335 }, { 170, 335 }, { 171, 335 }, { 172, 335 },
 { 173, 335 }, { 174, 335 }, { 175, 335 }, { 176, 335 }, { 177, 335 },
 { 178, 335 }, { 179, 335 }, { 180, 335 }, { 181, 335 }, { 182, 335 },
 { 183, 335 }, { 184, 335 }, { 185, 335 }, { 186, 335 }, { 187, 335 },
 { 188, 335 }, { 189, 335 }, { 190, 335 }, { 191, 335 }, { 192, 335 },
 { 193, 335 }, { 194, 335 }, { 195, 335 }, { 196, 335 }, { 197, 335 },
 { 198, 335 }, { 199, 335 }, { 200, 335 }, { 201, 335 }, { 202, 335 },
 { 203, 335 }, { 204, 335 }, { 205, 335 }, { 206, 335 }, { 207, 335 },
 { 208, 335 }, { 209, 335 }, { 210, 335 }, { 211, 335 }, { 212, 335 },

 { 213, 335 }, { 214, 335 }, { 215, 335 }, { 216, 335 }, { 217, 335 },
 { 218, 335 }, { 219, 335 }, { 220, 335 }, { 221, 335 }, { 222, 335 },
 { 223, 335 }, { 224, 335 }, { 225, 335 }, { 226, 335 }, { 227, 335 },
 { 228, 335 }, { 229, 335 }, { 230, 335 }, { 231, 335 }, { 232, 335 },
 { 233, 335 }, { 234, 335 }, { 235, 335 }, { 236, 335 }, { 237, 335 },
 { 238, 335 }, { 239, 335 }, { 240, 335 }, { 241, 335 }, { 242, 335 },
 { 243, 335 }, { 244, 335 }, { 245, 335 }, { 246, 335 }, { 247, 335 },
 { 248, 335 }, { 249, 335 }, { 250, 335 }, { 251, 335 }, { 252, 335 },
 { 253, 335 }, { 254, 335 }, { 255, 335 }, { 256, 335 }, {   0,  75 },
 {   0,15353 }, {   0,   1 }, {   0,15351 }, {   0,  39 }, {   0,15349 },

 {   0,   0 }, {   0,   1 }, {   0,15346 }, {   0,  55 }, {   0,15344 },
 {   0,   0 }, {   9,5577 }, {  10,5577 }, {   0,   0 }, {  12,5577 },
 {  13,5577 }, {   9,5572 }, {  10,5572 }, {   0,   0 }, {  12,5572 },
 {  13,5572 }, {   0,  14 }, {   0,15331 }, {   0,  54 }, {   0,15329 },
 {   0,   0 }, {   0,  54 }, {   0,15326 }, {   0,  17 }, {   0,15324 },
 {   0,   0 }, {   0,   7 }, {   0,15321 }, {   0,   0 }, {  32,5577 },
 {   0,   7 }, {   0,15317 }, {   0,   0 }, {   0,   0 }, {  32,5572 },
 {   0,  41 }, {   0,15312 }, {  33,5825 }, {   0,   0 }, {  35,5825 },
 {   0,   0 }, {  37,5825 }, {  38,5825 }, {   0,  55 }, {   0,15304 },
 {   0,   0 }, {  42,5825 }, {  43,5825 }, {   0,   0 }, {  45,5825 },

 {   0,   0 }, {  47,5825 }, {   0,  17 }, {   0,15295 }, {   0,  20 },
 {   0,15293 }, {   0,  19 }, {   0,15291 }, {   0,   0 }, {   0,  17 },
 {   0,15288 }, {   0,  42 }, {   0,15286 }, {   0,   0 }, {  60,5825 },
 {  61,5836 }, {  62,5825 }, {  63,5825 }, {  64,5825 }, {  42, 363 },
 {  34, 358 }, {   0,  26 }, {   0,15276 }, {  42,8264 }, {  47, 365 },
 {   0,  27 }, {   0,15272 }, {  33,5785 }, {   0,   0 }, {  35,5785 },
 {  58, 349 }, {  37,5785 }, {  38,5785 }, {  61, 351 }, {   0,   0 },
 {   0,   0 }, {  42,5785 }, {  43,5785 }, {   0,   0 }, {  45,5785 },
 {   0,   0 }, {  47,5785 }, {  39, 346 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  34, 332 }, {   0,   0 }, {  94,5825 }, {  39, 339 },

 {  96,5825 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,5785 },
 {  61,5785 }, {  62,5785 }, {  63,5785 }, {  64,5785 }, {   0,  75 },
 {   0,15238 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  26 }, {   0,15232 }, {   0,  33 }, {   0,15230 }, {   0,  47 },
 {   0,15228 }, {   0,  68 }, {   0,15226 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,5825 }, {   0,   0 },
 { 126,5825 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,5785 }, {   0,   0 },
 {  96,5785 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,   8 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5747 }, {  49,5747 },
 {  50,5747 }, {  51,5747 }, {  52,5747 }, {  53,5747 }, {  54,5747 },
 {  55,5747 }, {  56,5747 }, {  57,5747 }, { 124,5785 }, {   0,   0 },
 { 126,5785 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,5810 }, {  66,5810 }, {  67,5810 }, {  68,5810 }, {  69,5810 },
 {  70,5810 }, {  71,5810 }, {  72,5810 }, {  73,5810 }, {  74,5810 },
 {  75,5810 }, {  76,5810 }, {  77,5810 }, {  78,5810 }, {  79,5810 },
 {  80,5810 }, {  81,5810 }, {  82,5810 }, {  83,5810 }, {  84,5810 },
 {  85,5810 }, {  86,5810 }, {  87,5810 }, {  88,5810 }, {  89,5810 },

 {  90,5810 }, {  85,10095 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,5810 }, {   0,   0 }, {  97,5810 }, {  98,5810 }, {  99,5810 },
 { 100,5810 }, { 101,5810 }, { 102,5810 }, { 103,5810 }, { 104,5810 },
 { 105,5810 }, { 106,5810 }, { 107,5810 }, { 108,5810 }, { 109,5810 },
 { 110,5810 }, { 111,5810 }, { 112,5810 }, { 113,5810 }, { 114,5810 },
 { 115,5810 }, { 116,5810 }, { 117,5810 }, { 118,5810 }, { 119,5810 },
 { 120,5810 }, { 121,5810 }, { 122,5810 }, { 117,10118 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5810 }, { 129,5810 },
 { 130,5810 }, { 131,5810 }, { 132,5810 }, { 133,5810 }, { 134,5810 },
 { 135,5810 }, { 136,5810 }, { 137,5810 }, { 138,5810 }, { 139,5810 },

 { 140,5810 }, { 141,5810 }, { 142,5810 }, { 143,5810 }, { 144,5810 },
 { 145,5810 }, { 146,5810 }, { 147,5810 }, { 148,5810 }, { 149,5810 },
 { 150,5810 }, { 151,5810 }, { 152,5810 }, { 153,5810 }, { 154,5810 },
 { 155,5810 }, { 156,5810 }, { 157,5810 }, { 158,5810 }, { 159,5810 },
 { 160,5810 }, { 161,5810 }, { 162,5810 }, { 163,5810 }, { 164,5810 },
 { 165,5810 }, { 166,5810 }, { 167,5810 }, { 168,5810 }, { 169,5810 },
 { 170,5810 }, { 171,5810 }, { 172,5810 }, { 173,5810 }, { 174,5810 },
 { 175,5810 }, { 176,5810 }, { 177,5810 }, { 178,5810 }, { 179,5810 },
 { 180,5810 }, { 181,5810 }, { 182,5810 }, { 183,5810 }, { 184,5810 },
 { 185,5810 }, { 186,5810 }, { 187,5810 }, { 188,5810 }, { 189,5810 },

 { 190,5810 }, { 191,5810 }, { 192,5810 }, { 193,5810 }, { 194,5810 },
 { 195,5810 }, { 196,5810 }, { 197,5810 }, { 198,5810 }, { 199,5810 },
 { 200,5810 }, { 201,5810 }, { 202,5810 }, { 203,5810 }, { 204,5810 },
 { 205,5810 }, { 206,5810 }, { 207,5810 }, { 208,5810 }, { 209,5810 },
 { 210,5810 }, { 211,5810 }, { 212,5810 }, { 213,5810 }, { 214,5810 },
 { 215,5810 }, { 216,5810 }, { 217,5810 }, { 218,5810 }, { 219,5810 },
 { 220,5810 }, { 221,5810 }, { 222,5810 }, { 223,5810 }, { 224,5810 },
 { 225,5810 }, { 226,5810 }, { 227,5810 }, { 228,5810 }, { 229,5810 },
 { 230,5810 }, { 231,5810 }, { 232,5810 }, { 233,5810 }, { 234,5810 },
 { 235,5810 }, { 236,5810 }, { 237,5810 }, { 238,5810 }, { 239,5810 },

 { 240,5810 }, { 241,5810 }, { 242,5810 }, { 243,5810 }, { 244,5810 },
 { 245,5810 }, { 246,5810 }, { 247,5810 }, { 248,5810 }, { 249,5810 },
 { 250,5810 }, { 251,5810 }, { 252,5810 }, { 253,5810 }, { 254,5810 },
 { 255,5810 }, {   0,  54 }, {   0,14981 }, {   0,  63 }, {   0,14979 },
 {   0,  46 }, {   0,14977 }, {   0,  48 }, {   0,14975 }, {   0,   9 },
 {   0,14973 }, {   0,   0 }, {   0,  54 }, {   0,14970 }, {   0,  15 },
 {   0,14968 }, {   0,  13 }, {   0,14966 }, {   0,   0 }, {   0,  45 },
 {   0,14963 }, {   0,  12 }, {   0,14961 }, {   0,   0 }, {   0,   8 },
 {   0,14958 }, {   0,   5 }, {   0,14956 }, {   0,  43 }, {   0,14954 },
 {   0,   0 }, {   0,  54 }, {   0,14951 }, {   0,  21 }, {   0,14949 },

 {  33,5462 }, {   0,   0 }, {  35,5462 }, {   0,   0 }, {  37,5462 },
 {  38,5462 }, {   0,  19 }, {   0,14941 }, {   0,   0 }, {  42,5462 },
 {  43,5462 }, {  33,5451 }, {  45,5462 }, {  35,5451 }, {  47,5462 },
 {  37,5451 }, {  38,5451 }, {  48,11312 }, {  49,11312 }, {  34,  91 },
 {  42,5451 }, {  43,5451 }, {   0,   0 }, {  45,5799 }, {  39,  93 },
 {  47,5451 }, {   0,   0 }, {  60,5462 }, {  61,5462 }, {  62,5462 },
 {  63,5462 }, {  64,5462 }, {  42,   0 }, {   0,  18 }, {   0,14914 },
 {   0,  29 }, {   0,14912 }, {  47,   2 }, {  60,5451 }, {  61,5451 },
 {  62,5451 }, {  63,5451 }, {  64,5451 }, {  46,-277 }, {   0,   0 },
 {  48,6038 }, {  49,6038 }, {  50,6038 }, {  51,6038 }, {  52,6038 },

 {  53,6038 }, {  54,6038 }, {  55,6038 }, {  56,6038 }, {  57,6038 },
 {   0,  35 }, {   0,14892 }, {   0,  72 }, {   0,14890 }, {   0,  65 },
 {   0,14888 }, {  94,5462 }, {   0,   0 }, {  96,5462 }, {  95, 101 },
 {   0,   0 }, {   0,   0 }, {   0,  54 }, {   0,14880 }, {   0,  63 },
 {   0,14878 }, {   0,   0 }, {  94,5451 }, {   0,   0 }, {  96,5451 },
 {   0,  40 }, {   0,14872 }, {   0,  16 }, {   0,14870 }, {   0,  71 },
 {   0,14868 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  71 },
 {   0,14863 }, {   0,  73 }, {   0,14861 }, {   0,  70 }, {   0,14859 },
 {   0,   0 }, { 124,5462 }, {   0,   0 }, { 126,5462 }, {   0,  69 },
 {   0,14853 }, {   0,  30 }, {   0,14851 }, {   0,   0 }, {   0,  57 },

 {   0,14848 }, {  33,5361 }, { 124,5451 }, {  35,5361 }, { 126,5451 },
 {  37,5361 }, {  38,5361 }, {   0,  31 }, {   0,14840 }, {   0,   0 },
 {  42,6224 }, {  43,5361 }, {   0,   0 }, {  45,5361 }, {   0,   0 },
 {  47,5361 }, {   0,  24 }, {   0,14831 }, {  48,11211 }, {  49,11211 },
 {   0,  25 }, {   0,14827 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,5361 }, {  61,5361 },
 {  62,5361 }, {  63,5361 }, {  64,5361 }, {  48,11196 }, {  49,11196 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  46,6224 }, {   0,   0 }, {  48,6481 }, {  49,6481 },

 {  50,6481 }, {  51,6481 }, {  52,6481 }, {  53,6481 }, {  54,6481 },
 {  55,6481 }, {  56,6481 }, {  57,6481 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,5361 }, {   0,   0 }, {  96,5361 },
 {  65,-378 }, {  66,-131 }, {  67,-378 }, {  68,-378 }, {  69,6738 },
 {  70,-378 }, {  71,-378 }, {  72,-378 }, {  73,-378 }, {  74,-378 },
 {  75,-378 }, {  76,-378 }, {  77,-378 }, {  78,-378 }, {  79,6748 },
 {  80,-378 }, {  81,-378 }, {  82,-378 }, {  83,-378 }, {  84,-378 },
 {  85,-378 }, {  86,-378 }, {  87,-378 }, {  88,6756 }, {  89,-378 },
 {  90,-378 }, {   0,   0 }, { 124,5361 }, {   0,   0 }, { 126,5361 },
 {  95,6779 }, {   0,   0 }, {  97,-378 }, {  98,-131 }, {  99,-378 },

 { 100,-378 }, { 101,6738 }, { 102,-378 }, { 103,-378 }, { 104,-378 },
 { 105,-378 }, { 106,-378 }, { 107,-378 }, { 108,-378 }, { 109,-378 },
 { 110,-378 }, { 111,6748 }, { 112,-378 }, { 113,-378 }, { 114,-378 },
 { 115,-378 }, { 116,-378 }, { 117,-378 }, { 118,-378 }, { 119,-378 },
 { 120,6756 }, { 121,-378 }, { 122,-378 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-378 }, { 129,-378 },
 { 130,-378 }, { 131,-378 }, { 132,-378 }, { 133,-378 }, { 134,-378 },
 { 135,-378 }, { 136,-378 }, { 137,-378 }, { 138,-378 }, { 139,-378 },
 { 140,-378 }, { 141,-378 }, { 142,-378 }, { 143,-378 }, { 144,-378 },
 { 145,-378 }, { 146,-378 }, { 147,-378 }, { 148,-378 }, { 149,-378 },

 { 150,-378 }, { 151,-378 }, { 152,-378 }, { 153,-378 }, { 154,-378 },
 { 155,-378 }, { 156,-378 }, { 157,-378 }, { 158,-378 }, { 159,-378 },
 { 160,-378 }, { 161,-378 }, { 162,-378 }, { 163,-378 }, { 164,-378 },
 { 165,-378 }, { 166,-378 }, { 167,-378 }, { 168,-378 }, { 169,-378 },
 { 170,-378 }, { 171,-378 }, { 172,-378 }, { 173,-378 }, { 174,-378 },
 { 175,-378 }, { 176,-378 }, { 177,-378 }, { 178,-378 }, { 179,-378 },
 { 180,-378 }, { 181,-378 }, { 182,-378 }, { 183,-378 }, { 184,-378 },
 { 185,-378 }, { 186,-378 }, { 187,-378 }, { 188,-378 }, { 189,-378 },
 { 190,-378 }, { 191,-378 }, { 192,-378 }, { 193,-378 }, { 194,-378 },
 { 195,-378 }, { 196,-378 }, { 197,-378 }, { 198,-378 }, { 199,-378 },

 { 200,-378 }, { 201,-378 }, { 202,-378 }, { 203,-378 }, { 204,-378 },
 { 205,-378 }, { 206,-378 }, { 207,-378 }, { 208,-378 }, { 209,-378 },
 { 210,-378 }, { 211,-378 }, { 212,-378 }, { 213,-378 }, { 214,-378 },
 { 215,-378 }, { 216,-378 }, { 217,-378 }, { 218,-378 }, { 219,-378 },
 { 220,-378 }, { 221,-378 }, { 222,-378 }, { 223,-378 }, { 224,-378 },
 { 225,-378 }, { 226,-378 }, { 227,-378 }, { 228,-378 }, { 229,-378 },
 { 230,-378 }, { 231,-378 }, { 232,-378 }, { 233,-378 }, { 234,-378 },
 { 235,-378 }, { 236,-378 }, { 237,-378 }, { 238,-378 }, { 239,-378 },
 { 240,-378 }, { 241,-378 }, { 242,-378 }, { 243,-378 }, { 244,-378 },
 { 245,-378 }, { 246,-378 }, { 247,-378 }, { 248,-378 }, { 249,-378 },

 { 250,-378 }, { 251,-378 }, { 252,-378 }, { 253,-378 }, { 254,-378 },
 { 255,-378 }, {   0,  57 }, {   0,14591 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46,5967 }, {   0,   0 },
 {  48,6224 }, {  49,6224 }, {  50,6224 }, {  51,6224 }, {  52,6224 },
 {  53,6224 }, {  54,6224 }, {  55,6224 }, {  56,6224 }, {  57,6224 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-635 }, {  66,-635 }, {  67,-635 },
 {  68,-635 }, {  69,6481 }, {  70,-635 }, {  71,-635 }, {  72,-635 },
 {  73,-635 }, {  74,-635 }, {  75,-635 }, {  76,-635 }, {  77,-635 },
 {  78,-635 }, {  79,-635 }, {  80,-635 }, {  81,-635 }, {  82,-635 },
 {  83,-635 }, {  84,-635 }, {  85,-635 }, {  86,-635 }, {  87,-635 },
 {  88,-635 }, {  89,-635 }, {  90,-635 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  95,6522 }, {   0,   0 }, {  97,-635 },
 {  98,-635 }, {  99,-635 }, { 100,-635 }, { 101,6481 }, { 102,-635 },
 { 103,-635 }, { 104,-635 }, { 105,-635 }, { 106,-635 }, { 107,-635 },
 { 108,-635 }, { 109,-635 }, { 110,-635 }, { 111,-635 }, { 112,-635 },
 { 113,-635 }, { 114,-635 }, { 115,-635 }, { 116,-635 }, { 117,-635 },
 { 118,-635 }, { 119,-635 }, { 120,-635 }, { 121,-635 }, { 122,-635 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-635 }, { 129,-635 }, { 130,-635 }, { 131,-635 }, { 132,-635 },
 { 133,-635 }, { 134,-635 }, { 135,-635 }, { 136,-635 }, { 137,-635 },
 { 138,-635 }, { 139,-635 }, { 140,-635 }, { 141,-635 }, { 142,-635 },

 { 143,-635 }, { 144,-635 }, { 145,-635 }, { 146,-635 }, { 147,-635 },
 { 148,-635 }, { 149,-635 }, { 150,-635 }, { 151,-635 }, { 152,-635 },
 { 153,-635 }, { 154,-635 }, { 155,-635 }, { 156,-635 }, { 157,-635 },
 { 158,-635 }, { 159,-635 }, { 160,-635 }, { 161,-635 }, { 162,-635 },
 { 163,-635 }, { 164,-635 }, { 165,-635 }, { 166,-635 }, { 167,-635 },
 { 168,-635 }, { 169,-635 }, { 170,-635 }, { 171,-635 }, { 172,-635 },
 { 173,-635 }, { 174,-635 }, { 175,-635 }, { 176,-635 }, { 177,-635 },
 { 178,-635 }, { 179,-635 }, { 180,-635 }, { 181,-635 }, { 182,-635 },
 { 183,-635 }, { 184,-635 }, { 185,-635 }, { 186,-635 }, { 187,-635 },
 { 188,-635 }, { 189,-635 }, { 190,-635 }, { 191,-635 }, { 192,-635 },

 { 193,-635 }, { 194,-635 }, { 195,-635 }, { 196,-635 }, { 197,-635 },
 { 198,-635 }, { 199,-635 }, { 200,-635 }, { 201,-635 }, { 202,-635 },
 { 203,-635 }, { 204,-635 }, { 205,-635 }, { 206,-635 }, { 207,-635 },
 { 208,-635 }, { 209,-635 }, { 210,-635 }, { 211,-635 }, { 212,-635 },
 { 213,-635 }, { 214,-635 }, { 215,-635 }, { 216,-635 }, { 217,-635 },
 { 218,-635 }, { 219,-635 }, { 220,-635 }, { 221,-635 }, { 222,-635 },
 { 223,-635 }, { 224,-635 }, { 225,-635 }, { 226,-635 }, { 227,-635 },
 { 228,-635 }, { 229,-635 }, { 230,-635 }, { 231,-635 }, { 232,-635 },
 { 233,-635 }, { 234,-635 }, { 235,-635 }, { 236,-635 }, { 237,-635 },
 { 238,-635 }, { 239,-635 }, { 240,-635 }, { 241,-635 }, { 242,-635 },

 { 243,-635 }, { 244,-635 }, { 245,-635 }, { 246,-635 }, { 247,-635 },
 { 248,-635 }, { 249,-635 }, { 250,-635 }, { 251,-635 }, { 252,-635 },
 { 253,-635 }, { 254,-635 }, { 255,-635 }, {   0,  54 }, {   0,14334 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  54 },
 {   0,14323 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  33,4815 }, {   0,   0 }, {  35,4815 },

 {   0,   0 }, {  37,4815 }, {  38,4815 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,4815 }, {  43,4815 }, {  33,4804 }, {  45,4815 },
 {  35,4804 }, {  47,4815 }, {  37,4804 }, {  38,4804 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,4804 }, {  43,4804 }, {   0,   0 },
 {  45,4804 }, {   0,   0 }, {  47,4804 }, {   0,   0 }, {  60,4815 },
 {  61,6324 }, {  62,6335 }, {  63,4815 }, {  64,4815 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,4804 }, {  61,4804 }, {  62,6391 }, {  63,4804 }, {  64,4804 },
 {   0,   0 }, {   0,  54 }, {   0,14256 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,4815 }, {   0,   0 },
 {  96,4815 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,4804 },
 {   0,   0 }, {  96,4804 }, {   0,   0 }, {   0,  74 }, {   0,14224 },
 {  33,4737 }, {   0,   0 }, {  35,4737 }, {   0,   0 }, {  37,4737 },
 {  38,4737 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,4737 },
 {  43,4737 }, {   0,   0 }, {  45,4737 }, { 124,4815 }, {  47,4737 },
 { 126,4815 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,4804 },

 {   0,   0 }, { 126,4804 }, {  60,4737 }, {  61,6364 }, {  62,4737 },
 {  63,4737 }, {  64,4737 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,6398 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,6398 }, {  49,6398 }, {  50,6398 },
 {  51,6398 }, {  52,6398 }, {  53,6398 }, {  54,6398 }, {  55,6398 },
 {  56,6398 }, {  57,6398 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,4737 }, {   0,   0 }, {  96,4737 }, {  65,6398 },
 {  66,6398 }, {  67,6398 }, {  68,6398 }, {  69,6398 }, {  70,6398 },
 {  71,6398 }, {  72,6398 }, {  73,6398 }, {  74,6398 }, {  75,6398 },

 {  76,6398 }, {  77,6398 }, {  78,6398 }, {  79,6398 }, {  80,6398 },
 {  81,6398 }, {  82,6398 }, {  83,6398 }, {  84,6398 }, {  85,6398 },
 {  86,6398 }, {  87,6398 }, {  88,6398 }, {  89,6398 }, {  90,6398 },
 {   0,   0 }, { 124,4737 }, {   0,   0 }, { 126,4737 }, {  95,6398 },
 {   0,   0 }, {  97,6398 }, {  98,6398 }, {  99,6398 }, { 100,6398 },
 { 101,6398 }, { 102,6398 }, { 103,6398 }, { 104,6398 }, { 105,6398 },
 { 106,6398 }, { 107,6398 }, { 108,6398 }, { 109,6398 }, { 110,6398 },
 { 111,6398 }, { 112,6398 }, { 113,6398 }, { 114,6398 }, { 115,6398 },
 { 116,6398 }, { 117,6398 }, { 118,6398 }, { 119,6398 }, { 120,6398 },
 { 121,6398 }, { 122,6398 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 128,6398 }, { 129,6398 }, { 130,6398 },
 { 131,6398 }, { 132,6398 }, { 133,6398 }, { 134,6398 }, { 135,6398 },
 { 136,6398 }, { 137,6398 }, { 138,6398 }, { 139,6398 }, { 140,6398 },
 { 141,6398 }, { 142,6398 }, { 143,6398 }, { 144,6398 }, { 145,6398 },
 { 146,6398 }, { 147,6398 }, { 148,6398 }, { 149,6398 }, { 150,6398 },
 { 151,6398 }, { 152,6398 }, { 153,6398 }, { 154,6398 }, { 155,6398 },
 { 156,6398 }, { 157,6398 }, { 158,6398 }, { 159,6398 }, { 160,6398 },
 { 161,6398 }, { 162,6398 }, { 163,6398 }, { 164,6398 }, { 165,6398 },
 { 166,6398 }, { 167,6398 }, { 168,6398 }, { 169,6398 }, { 170,6398 },
 { 171,6398 }, { 172,6398 }, { 173,6398 }, { 174,6398 }, { 175,6398 },

 { 176,6398 }, { 177,6398 }, { 178,6398 }, { 179,6398 }, { 180,6398 },
 { 181,6398 }, { 182,6398 }, { 183,6398 }, { 184,6398 }, { 185,6398 },
 { 186,6398 }, { 187,6398 }, { 188,6398 }, { 189,6398 }, { 190,6398 },
 { 191,6398 }, { 192,6398 }, { 193,6398 }, { 194,6398 }, { 195,6398 },
 { 196,6398 }, { 197,6398 }, { 198,6398 }, { 199,6398 }, { 200,6398 },
 { 201,6398 }, { 202,6398 }, { 203,6398 }, { 204,6398 }, { 205,6398 },
 { 206,6398 }, { 207,6398 }, { 208,6398 }, { 209,6398 }, { 210,6398 },
 { 211,6398 }, { 212,6398 }, { 213,6398 }, { 214,6398 }, { 215,6398 },
 { 216,6398 }, { 217,6398 }, { 218,6398 }, { 219,6398 }, { 220,6398 },
 { 221,6398 }, { 222,6398 }, { 223,6398 }, { 224,6398 }, { 225,6398 },

 { 226,6398 }, { 227,6398 }, { 228,6398 }, { 229,6398 }, { 230,6398 },
 { 231,6398 }, { 232,6398 }, { 233,6398 }, { 234,6398 }, { 235,6398 },
 { 236,6398 }, { 237,6398 }, { 238,6398 }, { 239,6398 }, { 240,6398 },
 { 241,6398 }, { 242,6398 }, { 243,6398 }, { 244,6398 }, { 245,6398 },
 { 246,6398 }, { 247,6398 }, { 248,6398 }, { 249,6398 }, { 250,6398 },
 { 251,6398 }, { 252,6398 }, { 253,6398 }, { 254,6398 }, { 255,6398 },
 {   0,  74 }, {   0,13967 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,6141 }, {   0,   0 }, {   0,   0 },
 {  39,-1006 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,6141 },
 {  49,6141 }, {  50,6141 }, {  51,6141 }, {  52,6141 }, {  53,6141 },
 {  54,6141 }, {  55,6141 }, {  56,6141 }, {  57,6141 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,6141 }, {  66,6141 }, {  67,6141 }, {  68,6141 },

 {  69,6141 }, {  70,6141 }, {  71,6141 }, {  72,6141 }, {  73,6141 },
 {  74,6141 }, {  75,6141 }, {  76,6141 }, {  77,6141 }, {  78,6141 },
 {  79,6141 }, {  80,6141 }, {  81,6141 }, {  82,6141 }, {  83,6141 },
 {  84,6141 }, {  85,6141 }, {  86,6141 }, {  87,6141 }, {  88,6141 },
 {  89,6141 }, {  90,6141 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,6141 }, {   0,   0 }, {  97,6141 }, {  98,6141 },
 {  99,6141 }, { 100,6141 }, { 101,6141 }, { 102,6141 }, { 103,6141 },
 { 104,6141 }, { 105,6141 }, { 106,6141 }, { 107,6141 }, { 108,6141 },
 { 109,6141 }, { 110,6141 }, { 111,6141 }, { 112,6141 }, { 113,6141 },
 { 114,6141 }, { 115,6141 }, { 116,6141 }, { 117,6141 }, { 118,6141 },

 { 119,6141 }, { 120,6141 }, { 121,6141 }, { 122,6141 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6141 },
 { 129,6141 }, { 130,6141 }, { 131,6141 }, { 132,6141 }, { 133,6141 },
 { 134,6141 }, { 135,6141 }, { 136,6141 }, { 137,6141 }, { 138,6141 },
 { 139,6141 }, { 140,6141 }, { 141,6141 }, { 142,6141 }, { 143,6141 },
 { 144,6141 }, { 145,6141 }, { 146,6141 }, { 147,6141 }, { 148,6141 },
 { 149,6141 }, { 150,6141 }, { 151,6141 }, { 152,6141 }, { 153,6141 },
 { 154,6141 }, { 155,6141 }, { 156,6141 }, { 157,6141 }, { 158,6141 },
 { 159,6141 }, { 160,6141 }, { 161,6141 }, { 162,6141 }, { 163,6141 },
 { 164,6141 }, { 165,6141 }, { 166,6141 }, { 167,6141 }, { 168,6141 },

 { 169,6141 }, { 170,6141 }, { 171,6141 }, { 172,6141 }, { 173,6141 },
 { 174,6141 }, { 175,6141 }, { 176,6141 }, { 177,6141 }, { 178,6141 },
 { 179,6141 }, { 180,6141 }, { 181,6141 }, { 182,6141 }, { 183,6141 },
 { 184,6141 }, { 185,6141 }, { 186,6141 }, { 187,6141 }, { 188,6141 },
 { 189,6141 }, { 190,6141 }, { 191,6141 }, { 192,6141 }, { 193,6141 },
 { 194,6141 }, { 195,6141 }, { 196,6141 }, { 197,6141 }, { 198,6141 },
 { 199,6141 }, { 200,6141 }, { 201,6141 }, { 202,6141 }, { 203,6141 },
 { 204,6141 }, { 205,6141 }, { 206,6141 }, { 207,6141 }, { 208,6141 },
 { 209,6141 }, { 210,6141 }, { 211,6141 }, { 212,6141 }, { 213,6141 },
 { 214,6141 }, { 215,6141 }, { 216,6141 }, { 217,6141 }, { 218,6141 },

 { 219,6141 }, { 220,6141 }, { 221,6141 }, { 222,6141 }, { 223,6141 },
 { 224,6141 }, { 225,6141 }, { 226,6141 }, { 227,6141 }, { 228,6141 },
 { 229,6141 }, { 230,6141 }, { 231,6141 }, { 232,6141 }, { 233,6141 },
 { 234,6141 }, { 235,6141 }, { 236,6141 }, { 237,6141 }, { 238,6141 },
 { 239,6141 }, { 240,6141 }, { 241,6141 }, { 242,6141 }, { 243,6141 },
 { 244,6141 }, { 245,6141 }, { 246,6141 }, { 247,6141 }, { 248,6141 },
 { 249,6141 }, { 250,6141 }, { 251,6141 }, { 252,6141 }, { 253,6141 },
 { 254,6141 }, { 255,6141 }, {   0,  74 }, {   0,13710 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5884 },
 {   0,   0 }, {   0,   0 }, {  39,-1258 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,5884 }, {  49,5884 }, {  50,5884 }, {  51,5884 },
 {  52,5884 }, {  53,5884 }, {  54,5884 }, {  55,5884 }, {  56,5884 },
 {  57,5884 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5884 }, {  66,5884 },
 {  67,5884 }, {  68,5884 }, {  69,5884 }, {  70,5884 }, {  71,5884 },
 {  72,5884 }, {  73,5884 }, {  74,5884 }, {  75,5884 }, {  76,5884 },
 {  77,5884 }, {  78,5884 }, {  79,5884 }, {  80,5884 }, {  81,5884 },
 {  82,5884 }, {  83,5884 }, {  84,5884 }, {  85,5884 }, {  86,5884 },
 {  87,5884 }, {  88,5884 }, {  89,5884 }, {  90,5884 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5884 }, {   0,   0 },
 {  97,5884 }, {  98,5884 }, {  99,5884 }, { 100,5884 }, { 101,5884 },
 { 102,5884 }, { 103,5884 }, { 104,5884 }, { 105,5884 }, { 106,5884 },
 { 107,5884 }, { 108,5884 }, { 109,5884 }, { 110,5884 }, { 111,5884 },

 { 112,5884 }, { 113,5884 }, { 114,5884 }, { 115,5884 }, { 116,5884 },
 { 117,5884 }, { 118,5884 }, { 119,5884 }, { 120,5884 }, { 121,5884 },
 { 122,5884 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,5884 }, { 129,5884 }, { 130,5884 }, { 131,5884 },
 { 132,5884 }, { 133,5884 }, { 134,5884 }, { 135,5884 }, { 136,5884 },
 { 137,5884 }, { 138,5884 }, { 139,5884 }, { 140,5884 }, { 141,5884 },
 { 142,5884 }, { 143,5884 }, { 144,5884 }, { 145,5884 }, { 146,5884 },
 { 147,5884 }, { 148,5884 }, { 149,5884 }, { 150,5884 }, { 151,5884 },
 { 152,5884 }, { 153,5884 }, { 154,5884 }, { 155,5884 }, { 156,5884 },
 { 157,5884 }, { 158,5884 }, { 159,5884 }, { 160,5884 }, { 161,5884 },

 { 162,5884 }, { 163,5884 }, { 164,5884 }, { 165,5884 }, { 166,5884 },
 { 167,5884 }, { 168,5884 }, { 169,5884 }, { 170,5884 }, { 171,5884 },
 { 172,5884 }, { 173,5884 }, { 174,5884 }, { 175,5884 }, { 176,5884 },
 { 177,5884 }, { 178,5884 }, { 179,5884 }, { 180,5884 }, { 181,5884 },
 { 182,5884 }, { 183,5884 }, { 184,5884 }, { 185,5884 }, { 186,5884 },
 { 187,5884 }, { 188,5884 }, { 189,5884 }, { 190,5884 }, { 191,5884 },
 { 192,5884 }, { 193,5884 }, { 194,5884 }, { 195,5884 }, { 196,5884 },
 { 197,5884 }, { 198,5884 }, { 199,5884 }, { 200,5884 }, { 201,5884 },
 { 202,5884 }, { 203,5884 }, { 204,5884 }, { 205,5884 }, { 206,5884 },
 { 207,5884 }, { 208,5884 }, { 209,5884 }, { 210,5884 }, { 211,5884 },

 { 212,5884 }, { 213,5884 }, { 214,5884 }, { 215,5884 }, { 216,5884 },
 { 217,5884 }, { 218,5884 }, { 219,5884 }, { 220,5884 }, { 221,5884 },
 { 222,5884 }, { 223,5884 }, { 224,5884 }, { 225,5884 }, { 226,5884 },
 { 227,5884 }, { 228,5884 }, { 229,5884 }, { 230,5884 }, { 231,5884 },
 { 232,5884 }, { 233,5884 }, { 234,5884 }, { 235,5884 }, { 236,5884 },
 { 237,5884 }, { 238,5884 }, { 239,5884 }, { 240,5884 }, { 241,5884 },
 { 242,5884 }, { 243,5884 }, { 244,5884 }, { 245,5884 }, { 246,5884 },
 { 247,5884 }, { 248,5884 }, { 249,5884 }, { 250,5884 }, { 251,5884 },
 { 252,5884 }, { 253,5884 }, { 254,5884 }, { 255,5884 }, {   0,  74 },
 {   0,13453 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,5627 }, {   0,   0 }, {   0,   0 }, {  39,-1513 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5627 }, {  49,5627 },
 {  50,5627 }, {  51,5627 }, {  52,5627 }, {  53,5627 }, {  54,5627 },

 {  55,5627 }, {  56,5627 }, {  57,5627 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,5627 }, {  66,5627 }, {  67,5627 }, {  68,5627 }, {  69,5627 },
 {  70,5627 }, {  71,5627 }, {  72,5627 }, {  73,5627 }, {  74,5627 },
 {  75,5627 }, {  76,5627 }, {  77,5627 }, {  78,5627 }, {  79,5627 },
 {  80,5627 }, {  81,5627 }, {  82,5627 }, {  83,5627 }, {  84,5627 },
 {  85,5627 }, {  86,5627 }, {  87,5627 }, {  88,5627 }, {  89,5627 },
 {  90,5627 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,5627 }, {   0,   0 }, {  97,5627 }, {  98,5627 }, {  99,5627 },
 { 100,5627 }, { 101,5627 }, { 102,5627 }, { 103,5627 }, { 104,5627 },

 { 105,5627 }, { 106,5627 }, { 107,5627 }, { 108,5627 }, { 109,5627 },
 { 110,5627 }, { 111,5627 }, { 112,5627 }, { 113,5627 }, { 114,5627 },
 { 115,5627 }, { 116,5627 }, { 117,5627 }, { 118,5627 }, { 119,5627 },
 { 120,5627 }, { 121,5627 }, { 122,5627 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5627 }, { 129,5627 },
 { 130,5627 }, { 131,5627 }, { 132,5627 }, { 133,5627 }, { 134,5627 },
 { 135,5627 }, { 136,5627 }, { 137,5627 }, { 138,5627 }, { 139,5627 },
 { 140,5627 }, { 141,5627 }, { 142,5627 }, { 143,5627 }, { 144,5627 },
 { 145,5627 }, { 146,5627 }, { 147,5627 }, { 148,5627 }, { 149,5627 },
 { 150,5627 }, { 151,5627 }, { 152,5627 }, { 153,5627 }, { 154,5627 },

 { 155,5627 }, { 156,5627 }, { 157,5627 }, { 158,5627 }, { 159,5627 },
 { 160,5627 }, { 161,5627 }, { 162,5627 }, { 163,5627 }, { 164,5627 },
 { 165,5627 }, { 166,5627 }, { 167,5627 }, { 168,5627 }, { 169,5627 },
 { 170,5627 }, { 171,5627 }, { 172,5627 }, { 173,5627 }, { 174,5627 },
 { 175,5627 }, { 176,5627 }, { 177,5627 }, { 178,5627 }, { 179,5627 },
 { 180,5627 }, { 181,5627 }, { 182,5627 }, { 183,5627 }, { 184,5627 },
 { 185,5627 }, { 186,5627 }, { 187,5627 }, { 188,5627 }, { 189,5627 },
 { 190,5627 }, { 191,5627 }, { 192,5627 }, { 193,5627 }, { 194,5627 },
 { 195,5627 }, { 196,5627 }, { 197,5627 }, { 198,5627 }, { 199,5627 },
 { 200,5627 }, { 201,5627 }, { 202,5627 }, { 203,5627 }, { 204,5627 },

 { 205,5627 }, { 206,5627 }, { 207,5627 }, { 208,5627 }, { 209,5627 },
 { 210,5627 }, { 211,5627 }, { 212,5627 }, { 213,5627 }, { 214,5627 },
 { 215,5627 }, { 216,5627 }, { 217,5627 }, { 218,5627 }, { 219,5627 },
 { 220,5627 }, { 221,5627 }, { 222,5627 }, { 223,5627 }, { 224,5627 },
 { 225,5627 }, { 226,5627 }, { 227,5627 }, { 228,5627 }, { 229,5627 },
 { 230,5627 }, { 231,5627 }, { 232,5627 }, { 233,5627 }, { 234,5627 },
 { 235,5627 }, { 236,5627 }, { 237,5627 }, { 238,5627 }, { 239,5627 },
 { 240,5627 }, { 241,5627 }, { 242,5627 }, { 243,5627 }, { 244,5627 },
 { 245,5627 }, { 246,5627 }, { 247,5627 }, { 248,5627 }, { 249,5627 },
 { 250,5627 }, { 251,5627 }, { 252,5627 }, { 253,5627 }, { 254,5627 },

 { 255,5627 }, {   0,  74 }, {   0,13196 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5370 }, {   0,   0 },
 {  38,-1767 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,5370 }, {  49,5370 }, {  50,5370 }, {  51,5370 }, {  52,5370 },
 {  53,5370 }, {  54,5370 }, {  55,5370 }, {  56,5370 }, {  57,5370 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,5370 }, {  66,5370 }, {  67,5370 },
 {  68,5370 }, {  69,5370 }, {  70,5370 }, {  71,5370 }, {  72,5370 },
 {  73,5370 }, {  74,5370 }, {  75,5370 }, {  76,5370 }, {  77,5370 },
 {  78,5370 }, {  79,5370 }, {  80,5370 }, {  81,5370 }, {  82,5370 },
 {  83,5370 }, {  84,5370 }, {  85,5370 }, {  86,5370 }, {  87,5370 },
 {  88,5370 }, {  89,5370 }, {  90,5370 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,5370 }, {   0,   0 }, {  97,5370 },

 {  98,5370 }, {  99,5370 }, { 100,5370 }, { 101,5370 }, { 102,5370 },
 { 103,5370 }, { 104,5370 }, { 105,5370 }, { 106,5370 }, { 107,5370 },
 { 108,5370 }, { 109,5370 }, { 110,5370 }, { 111,5370 }, { 112,5370 },
 { 113,5370 }, { 114,5370 }, { 115,5370 }, { 116,5370 }, { 117,5370 },
 { 118,5370 }, { 119,5370 }, { 120,5370 }, { 121,5370 }, { 122,5370 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,5370 }, { 129,5370 }, { 130,5370 }, { 131,5370 }, { 132,5370 },
 { 133,5370 }, { 134,5370 }, { 135,5370 }, { 136,5370 }, { 137,5370 },
 { 138,5370 }, { 139,5370 }, { 140,5370 }, { 141,5370 }, { 142,5370 },
 { 143,5370 }, { 144,5370 }, { 145,5370 }, { 146,5370 }, { 147,5370 },

 { 148,5370 }, { 149,5370 }, { 150,5370 }, { 151,5370 }, { 152,5370 },
 { 153,5370 }, { 154,5370 }, { 155,5370 }, { 156,5370 }, { 157,5370 },
 { 158,5370 }, { 159,5370 }, { 160,5370 }, { 161,5370 }, { 162,5370 },
 { 163,5370 }, { 164,5370 }, { 165,5370 }, { 166,5370 }, { 167,5370 },
 { 168,5370 }, { 169,5370 }, { 170,5370 }, { 171,5370 }, { 172,5370 },
 { 173,5370 }, { 174,5370 }, { 175,5370 }, { 176,5370 }, { 177,5370 },
 { 178,5370 }, { 179,5370 }, { 180,5370 }, { 181,5370 }, { 182,5370 },
 { 183,5370 }, { 184,5370 }, { 185,5370 }, { 186,5370 }, { 187,5370 },
 { 188,5370 }, { 189,5370 }, { 190,5370 }, { 191,5370 }, { 192,5370 },
 { 193,5370 }, { 194,5370 }, { 195,5370 }, { 196,5370 }, { 197,5370 },

 { 198,5370 }, { 199,5370 }, { 200,5370 }, { 201,5370 }, { 202,5370 },
 { 203,5370 }, { 204,5370 }, { 205,5370 }, { 206,5370 }, { 207,5370 },
 { 208,5370 }, { 209,5370 }, { 210,5370 }, { 211,5370 }, { 212,5370 },
 { 213,5370 }, { 214,5370 }, { 215,5370 }, { 216,5370 }, { 217,5370 },
 { 218,5370 }, { 219,5370 }, { 220,5370 }, { 221,5370 }, { 222,5370 },
 { 223,5370 }, { 224,5370 }, { 225,5370 }, { 226,5370 }, { 227,5370 },
 { 228,5370 }, { 229,5370 }, { 230,5370 }, { 231,5370 }, { 232,5370 },
 { 233,5370 }, { 234,5370 }, { 235,5370 }, { 236,5370 }, { 237,5370 },
 { 238,5370 }, { 239,5370 }, { 240,5370 }, { 241,5370 }, { 242,5370 },
 { 243,5370 }, { 244,5370 }, { 245,5370 }, { 246,5370 }, { 247,5370 },

 { 248,5370 }, { 249,5370 }, { 250,5370 }, { 251,5370 }, { 252,5370 },
 { 253,5370 }, { 254,5370 }, { 255,5370 }, {   0,  74 }, {   0,12939 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,5113 }, {   0,   0 }, {   0,   0 }, {  39,-2022 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,5113 }, {  49,5113 }, {  50,5113 },
 {  51,5113 }, {  52,5113 }, {  53,5113 }, {  54,5113 }, {  55,5113 },
 {  56,5113 }, {  57,5113 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5113 },
 {  66,5113 }, {  67,5113 }, {  68,5113 }, {  69,5113 }, {  70,5113 },
 {  71,5113 }, {  72,5113 }, {  73,5113 }, {  74,5113 }, {  75,5113 },
 {  76,5113 }, {  77,5113 }, {  78,5113 }, {  79,5113 }, {  80,5113 },
 {  81,5113 }, {  82,5113 }, {  83,5113 }, {  84,5113 }, {  85,5113 },
 {  86,5113 }, {  87,5113 }, {  88,5113 }, {  89,5113 }, {  90,5113 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5113 },
 {   0,   0 }, {  97,5113 }, {  98,5113 }, {  99,5113 }, { 100,5113 },
 { 101,5113 }, { 102,5113 }, { 103,5113 }, { 104,5113 }, { 105,5113 },
 { 106,5113 }, { 107,5113 }, { 108,5113 }, { 109,5113 }, { 110,5113 },
 { 111,5113 }, { 112,5113 }, { 113,5113 }, { 114,5113 }, { 115,5113 },
 { 116,5113 }, { 117,5113 }, { 118,5113 }, { 119,5113 }, { 120,5113 },
 { 121,5113 }, { 122,5113 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,5113 }, { 129,5113 }, { 130,5113 },
 { 131,5113 }, { 132,5113 }, { 133,5113 }, { 134,5113 }, { 135,5113 },
 { 136,5113 }, { 137,5113 }, { 138,5113 }, { 139,5113 }, { 140,5113 },

 { 141,5113 }, { 142,5113 }, { 143,5113 }, { 144,5113 }, { 145,5113 },
 { 146,5113 }, { 147,5113 }, { 148,5113 }, { 149,5113 }, { 150,5113 },
 { 151,5113 }, { 152,5113 }, { 153,5113 }, { 154,5113 }, { 155,5113 },
 { 156,5113 }, { 157,5113 }, { 158,5113 }, { 159,5113 }, { 160,5113 },
 { 161,5113 }, { 162,5113 }, { 163,5113 }, { 164,5113 }, { 165,5113 },
 { 166,5113 }, { 167,5113 }, { 168,5113 }, { 169,5113 }, { 170,5113 },
 { 171,5113 }, { 172,5113 }, { 173,5113 }, { 174,5113 }, { 175,5113 },
 { 176,5113 }, { 177,5113 }, { 178,5113 }, { 179,5113 }, { 180,5113 },
 { 181,5113 }, { 182,5113 }, { 183,5113 }, { 184,5113 }, { 185,5113 },
 { 186,5113 }, { 187,5113 }, { 188,5113 }, { 189,5113 }, { 190,5113 },

 { 191,5113 }, { 192,5113 }, { 193,5113 }, { 194,5113 }, { 195,5113 },
 { 196,5113 }, { 197,5113 }, { 198,5113 }, { 199,5113 }, { 200,5113 },
 { 201,5113 }, { 202,5113 }, { 203,5113 }, { 204,5113 }, { 205,5113 },
 { 206,5113 }, { 207,5113 }, { 208,5113 }, { 209,5113 }, { 210,5113 },
 { 211,5113 }, { 212,5113 }, { 213,5113 }, { 214,5113 }, { 215,5113 },
 { 216,5113 }, { 217,5113 }, { 218,5113 }, { 219,5113 }, { 220,5113 },
 { 221,5113 }, { 222,5113 }, { 223,5113 }, { 224,5113 }, { 225,5113 },
 { 226,5113 }, { 227,5113 }, { 228,5113 }, { 229,5113 }, { 230,5113 },
 { 231,5113 }, { 232,5113 }, { 233,5113 }, { 234,5113 }, { 235,5113 },
 { 236,5113 }, { 237,5113 }, { 238,5113 }, { 239,5113 }, { 240,5113 },

 { 241,5113 }, { 242,5113 }, { 243,5113 }, { 244,5113 }, { 245,5113 },
 { 246,5113 }, { 247,5113 }, { 248,5113 }, { 249,5113 }, { 250,5113 },
 { 251,5113 }, { 252,5113 }, { 253,5113 }, { 254,5113 }, { 255,5113 },
 {   0,  11 }, {   0,12682 }, {   1,5113 }, {   2,5113 }, {   3,5113 },
 {   4,5113 }, {   5,5113 }, {   6,5113 }, {   7,5113 }, {   8,5113 },
 {   9,5113 }, {  10,5113 }, {  11,5113 }, {  12,5113 }, {  13,5113 },
 {  14,5113 }, {  15,5113 }, {  16,5113 }, {  17,5113 }, {  18,5113 },
 {  19,5113 }, {  20,5113 }, {  21,5113 }, {  22,5113 }, {  23,5113 },
 {  24,5113 }, {  25,5113 }, {  26,5113 }, {  27,5113 }, {  28,5113 },
 {  29,5113 }, {  30,5113 }, {  31,5113 }, {  32,5113 }, {  33,5113 },

 {  34,5113 }, {  35,5113 }, {  36,5113 }, {  37,5113 }, {  38,5113 },
 {   0,   0 }, {  40,5113 }, {  41,5113 }, {  42,5113 }, {  43,5113 },
 {  44,5113 }, {  45,5113 }, {  46,5113 }, {  47,5113 }, {  48,5113 },
 {  49,5113 }, {  50,5113 }, {  51,5113 }, {  52,5113 }, {  53,5113 },
 {  54,5113 }, {  55,5113 }, {  56,5113 }, {  57,5113 }, {  58,5113 },
 {  59,5113 }, {  60,5113 }, {  61,5113 }, {  62,5113 }, {  63,5113 },
 {  64,5113 }, {  65,5113 }, {  66,5113 }, {  67,5113 }, {  68,5113 },
 {  69,5113 }, {  70,5113 }, {  71,5113 }, {  72,5113 }, {  73,5113 },
 {  74,5113 }, {  75,5113 }, {  76,5113 }, {  77,5113 }, {  78,5113 },
 {  79,5113 }, {  80,5113 }, {  81,5113 }, {  82,5113 }, {  83,5113 },

 {  84,5113 }, {  85,5113 }, {  86,5113 }, {  87,5113 }, {  88,5113 },
 {  89,5113 }, {  90,5113 }, {  91,5113 }, {  92,5113 }, {  93,5113 },
 {  94,5113 }, {  95,5113 }, {  96,5113 }, {  97,5113 }, {  98,5113 },
 {  99,5113 }, { 100,5113 }, { 101,5113 }, { 102,5113 }, { 103,5113 },
 { 104,5113 }, { 105,5113 }, { 106,5113 }, { 107,5113 }, { 108,5113 },
 { 109,5113 }, { 110,5113 }, { 111,5113 }, { 112,5113 }, { 113,5113 },
 { 114,5113 }, { 115,5113 }, { 116,5113 }, { 117,5113 }, { 118,5113 },
 { 119,5113 }, { 120,5113 }, { 121,5113 }, { 122,5113 }, { 123,5113 },
 { 124,5113 }, { 125,5113 }, { 126,5113 }, { 127,5113 }, { 128,5113 },
 { 129,5113 }, { 130,5113 }, { 131,5113 }, { 132,5113 }, { 133,5113 },

 { 134,5113 }, { 135,5113 }, { 136,5113 }, { 137,5113 }, { 138,5113 },
 { 139,5113 }, { 140,5113 }, { 141,5113 }, { 142,5113 }, { 143,5113 },
 { 144,5113 }, { 145,5113 }, { 146,5113 }, { 147,5113 }, { 148,5113 },
 { 149,5113 }, { 150,5113 }, { 151,5113 }, { 152,5113 }, { 153,5113 },
 { 154,5113 }, { 155,5113 }, { 156,5113 }, { 157,5113 }, { 158,5113 },
 { 159,5113 }, { 160,5113 }, { 161,5113 }, { 162,5113 }, { 163,5113 },
 { 164,5113 }, { 165,5113 }, { 166,5113 }, { 167,5113 }, { 168,5113 },
 { 169,5113 }, { 170,5113 }, { 171,5113 }, { 172,5113 }, { 173,5113 },
 { 174,5113 }, { 175,5113 }, { 176,5113 }, { 177,5113 }, { 178,5113 },
 { 179,5113 }, { 180,5113 }, { 181,5113 }, { 182,5113 }, { 183,5113 },

 { 184,5113 }, { 185,5113 }, { 186,5113 }, { 187,5113 }, { 188,5113 },
 { 189,5113 }, { 190,5113 }, { 191,5113 }, { 192,5113 }, { 193,5113 },
 { 194,5113 }, { 195,5113 }, { 196,5113 }, { 197,5113 }, { 198,5113 },
 { 199,5113 }, { 200,5113 }, { 201,5113 }, { 202,5113 }, { 203,5113 },
 { 204,5113 }, { 205,5113 }, { 206,5113 }, { 207,5113 }, { 208,5113 },
 { 209,5113 }, { 210,5113 }, { 211,5113 }, { 212,5113 }, { 213,5113 },
 { 214,5113 }, { 215,5113 }, { 216,5113 }, { 217,5113 }, { 218,5113 },
 { 219,5113 }, { 220,5113 }, { 221,5113 }, { 222,5113 }, { 223,5113 },
 { 224,5113 }, { 225,5113 }, { 226,5113 }, { 227,5113 }, { 228,5113 },
 { 229,5113 }, { 230,5113 }, { 231,5113 }, { 232,5113 }, { 233,5113 },

 { 234,5113 }, { 235,5113 }, { 236,5113 }, { 237,5113 }, { 238,5113 },
 { 239,5113 }, { 240,5113 }, { 241,5113 }, { 242,5113 }, { 243,5113 },
 { 244,5113 }, { 245,5113 }, { 246,5113 }, { 247,5113 }, { 248,5113 },
 { 249,5113 }, { 250,5113 }, { 251,5113 }, { 252,5113 }, { 253,5113 },
 { 254,5113 }, { 255,5113 }, { 256,5113 }, {   0,   6 }, {   0,12424 },
 {   1,5113 }, {   2,5113 }, {   3,5113 }, {   4,5113 }, {   5,5113 },
 {   6,5113 }, {   7,5113 }, {   8,5113 }, {   9,5113 }, {  10,5113 },
 {  11,5113 }, {  12,5113 }, {  13,5113 }, {  14,5113 }, {  15,5113 },
 {  16,5113 }, {  17,5113 }, {  18,5113 }, {  19,5113 }, {  20,5113 },
 {  21,5113 }, {  22,5113 }, {  23,5113 }, {  24,5113 }, {  25,5113 },

 {  26,5113 }, {  27,5113 }, {  28,5113 }, {  29,5113 }, {  30,5113 },
 {  31,5113 }, {  32,5113 }, {  33,5113 }, {  34,5113 }, {  35,5113 },
 {  36,5113 }, {  37,5113 }, {  38,5113 }, {  39,5113 }, {  40,5113 },
 {  41,5113 }, {   0,   0 }, {  43,5113 }, {  44,5113 }, {  45,5113 },
 {  46,5113 }, {   0,   0 }, {  48,5113 }, {  49,5113 }, {  50,5113 },
 {  51,5113 }, {  52,5113 }, {  53,5113 }, {  54,5113 }, {  55,5113 },
 {  56,5113 }, {  57,5113 }, {  58,5113 }, {  59,5113 }, {  60,5113 },
 {  61,5113 }, {  62,5113 }, {  63,5113 }, {  64,5113 }, {  65,5113 },
 {  66,5113 }, {  67,5113 }, {  68,5113 }, {  69,5113 }, {  70,5113 },
 {  71,5113 }, {  72,5113 }, {  73,5113 }, {  74,5113 }, {  75,5113 },

 {  76,5113 }, {  77,5113 }, {  78,5113 }, {  79,5113 }, {  80,5113 },
 {  81,5113 }, {  82,5113 }, {  83,5113 }, {  84,5113 }, {  85,5113 },
 {  86,5113 }, {  87,5113 }, {  88,5113 }, {  89,5113 }, {  90,5113 },
 {  91,5113 }, {  92,5113 }, {  93,5113 }, {  94,5113 }, {  95,5113 },
 {  96,5113 }, {  97,5113 }, {  98,5113 }, {  99,5113 }, { 100,5113 },
 { 101,5113 }, { 102,5113 }, { 103,5113 }, { 104,5113 }, { 105,5113 },
 { 106,5113 }, { 107,5113 }, { 108,5113 }, { 109,5113 }, { 110,5113 },
 { 111,5113 }, { 112,5113 }, { 113,5113 }, { 114,5113 }, { 115,5113 },
 { 116,5113 }, { 117,5113 }, { 118,5113 }, { 119,5113 }, { 120,5113 },
 { 121,5113 }, { 122,5113 }, { 123,5113 }, { 124,5113 }, { 125,5113 },

 { 126,5113 }, { 127,5113 }, { 128,5113 }, { 129,5113 }, { 130,5113 },
 { 131,5113 }, { 132,5113 }, { 133,5113 }, { 134,5113 }, { 135,5113 },
 { 136,5113 }, { 137,5113 }, { 138,5113 }, { 139,5113 }, { 140,5113 },
 { 141,5113 }, { 142,5113 }, { 143,5113 }, { 144,5113 }, { 145,5113 },
 { 146,5113 }, { 147,5113 }, { 148,5113 }, { 149,5113 }, { 150,5113 },
 { 151,5113 }, { 152,5113 }, { 153,5113 }, { 154,5113 }, { 155,5113 },
 { 156,5113 }, { 157,5113 }, { 158,5113 }, { 159,5113 }, { 160,5113 },
 { 161,5113 }, { 162,5113 }, { 163,5113 }, { 164,5113 }, { 165,5113 },
 { 166,5113 }, { 167,5113 }, { 168,5113 }, { 169,5113 }, { 170,5113 },
 { 171,5113 }, { 172,5113 }, { 173,5113 }, { 174,5113 }, { 175,5113 },

 { 176,5113 }, { 177,5113 }, { 178,5113 }, { 179,5113 }, { 180,5113 },
 { 181,5113 }, { 182,5113 }, { 183,5113 }, { 184,5113 }, { 185,5113 },
 { 186,5113 }, { 187,5113 }, { 188,5113 }, { 189,5113 }, { 190,5113 },
 { 191,5113 }, { 192,5113 }, { 193,5113 }, { 194,5113 }, { 195,5113 },
 { 196,5113 }, { 197,5113 }, { 198,5113 }, { 199,5113 }, { 200,5113 },
 { 201,5113 }, { 202,5113 }, { 203,5113 }, { 204,5113 }, { 205,5113 },
 { 206,5113 }, { 207,5113 }, { 208,5113 }, { 209,5113 }, { 210,5113 },
 { 211,5113 }, { 212,5113 }, { 213,5113 }, { 214,5113 }, { 215,5113 },
 { 216,5113 }, { 217,5113 }, { 218,5113 }, { 219,5113 }, { 220,5113 },
 { 221,5113 }, { 222,5113 }, { 223,5113 }, { 224,5113 }, { 225,5113 },

 { 226,5113 }, { 227,5113 }, { 228,5113 }, { 229,5113 }, { 230,5113 },
 { 231,5113 }, { 232,5113 }, { 233,5113 }, { 234,5113 }, { 235,5113 },
 { 236,5113 }, { 237,5113 }, { 238,5113 }, { 239,5113 }, { 240,5113 },
 { 241,5113 }, { 242,5113 }, { 243,5113 }, { 244,5113 }, { 245,5113 },
 { 246,5113 }, { 247,5113 }, { 248,5113 }, { 249,5113 }, { 250,5113 },
 { 251,5113 }, { 252,5113 }, { 253,5113 }, { 254,5113 }, { 255,5113 },
 { 256,5113 }, {   0,   6 }, {   0,12166 }, {   1,4855 }, {   2,4855 },
 {   3,4855 }, {   4,4855 }, {   5,4855 }, {   6,4855 }, {   7,4855 },
 {   8,4855 }, {   9,4855 }, {  10,4855 }, {  11,4855 }, {  12,4855 },
 {  13,4855 }, {  14,4855 }, {  15,4855 }, {  16,4855 }, {  17,4855 },

 {  18,4855 }, {  19,4855 }, {  20,4855 }, {  21,4855 }, {  22,4855 },
 {  23,4855 }, {  24,4855 }, {  25,4855 }, {  26,4855 }, {  27,4855 },
 {  28,4855 }, {  29,4855 }, {  30,4855 }, {  31,4855 }, {  32,4855 },
 {  33,4855 }, {  34,4855 }, {  35,4855 }, {  36,4855 }, {  37,4855 },
 {  38,4855 }, {  39,4855 }, {  40,4855 }, {  41,4855 }, {   0,   0 },
 {  43,4855 }, {  44,4855 }, {  45,4855 }, {  46,4855 }, {   0,   0 },
 {  48,4855 }, {  49,4855 }, {  50,4855 }, {  51,4855 }, {  52,4855 },
 {  53,4855 }, {  54,4855 }, {  55,4855 }, {  56,4855 }, {  57,4855 },
 {  58,4855 }, {  59,4855 }, {  60,4855 }, {  61,4855 }, {  62,4855 },
 {  63,4855 }, {  64,4855 }, {  65,4855 }, {  66,4855 }, {  67,4855 },

 {  68,4855 }, {  69,4855 }, {  70,4855 }, {  71,4855 }, {  72,4855 },
 {  73,4855 }, {  74,4855 }, {  75,4855 }, {  76,4855 }, {  77,4855 },
 {  78,4855 }, {  79,4855 }, {  80,4855 }, {  81,4855 }, {  82,4855 },
 {  83,4855 }, {  84,4855 }, {  85,4855 }, {  86,4855 }, {  87,4855 },
 {  88,4855 }, {  89,4855 }, {  90,4855 }, {  91,4855 }, {  92,4855 },
 {  93,4855 }, {  94,4855 }, {  95,4855 }, {  96,4855 }, {  97,4855 },
 {  98,4855 }, {  99,4855 }, { 100,4855 }, { 101,4855 }, { 102,4855 },
 { 103,4855 }, { 104,4855 }, { 105,4855 }, { 106,4855 }, { 107,4855 },
 { 108,4855 }, { 109,4855 }, { 110,4855 }, { 111,4855 }, { 112,4855 },
 { 113,4855 }, { 114,4855 }, { 115,4855 }, { 116,4855 }, { 117,4855 },

 { 118,4855 }, { 119,4855 }, { 120,4855 }, { 121,4855 }, { 122,4855 },
 { 123,4855 }, { 124,4855 }, { 125,4855 }, { 126,4855 }, { 127,4855 },
 { 128,4855 }, { 129,4855 }, { 130,4855 }, { 131,4855 }, { 132,4855 },
 { 133,4855 }, { 134,4855 }, { 135,4855 }, { 136,4855 }, { 137,4855 },
 { 138,4855 }, { 139,4855 }, { 140,4855 }, { 141,4855 }, { 142,4855 },
 { 143,4855 }, { 144,4855 }, { 145,4855 }, { 146,4855 }, { 147,4855 },
 { 148,4855 }, { 149,4855 }, { 150,4855 }, { 151,4855 }, { 152,4855 },
 { 153,4855 }, { 154,4855 }, { 155,4855 }, { 156,4855 }, { 157,4855 },
 { 158,4855 }, { 159,4855 }, { 160,4855 }, { 161,4855 }, { 162,4855 },
 { 163,4855 }, { 164,4855 }, { 165,4855 }, { 166,4855 }, { 167,4855 },

 { 168,4855 }, { 169,4855 }, { 170,4855 }, { 171,4855 }, { 172,4855 },
 { 173,4855 }, { 174,4855 }, { 175,4855 }, { 176,4855 }, { 177,4855 },
 { 178,4855 }, { 179,4855 }, { 180,4855 }, { 181,4855 }, { 182,4855 },
 { 183,4855 }, { 184,4855 }, { 185,4855 }, { 186,4855 }, { 187,4855 },
 { 188,4855 }, { 189,4855 }, { 190,4855 }, { 191,4855 }, { 192,4855 },
 { 193,4855 }, { 194,4855 }, { 195,4855 }, { 196,4855 }, { 197,4855 },
 { 198,4855 }, { 199,4855 }, { 200,4855 }, { 201,4855 }, { 202,4855 },
 { 203,4855 }, { 204,4855 }, { 205,4855 }, { 206,4855 }, { 207,4855 },
 { 208,4855 }, { 209,4855 }, { 210,4855 }, { 211,4855 }, { 212,4855 },
 { 213,4855 }, { 214,4855 }, { 215,4855 }, { 216,4855 }, { 217,4855 },

 { 218,4855 }, { 219,4855 }, { 220,4855 }, { 221,4855 }, { 222,4855 },
 { 223,4855 }, { 224,4855 }, { 225,4855 }, { 226,4855 }, { 227,4855 },
 { 228,4855 }, { 229,4855 }, { 230,4855 }, { 231,4855 }, { 232,4855 },
 { 233,4855 }, { 234,4855 }, { 235,4855 }, { 236,4855 }, { 237,4855 },
 { 238,4855 }, { 239,4855 }, { 240,4855 }, { 241,4855 }, { 242,4855 },
 { 243,4855 }, { 244,4855 }, { 245,4855 }, { 246,4855 }, { 247,4855 },
 { 248,4855 }, { 249,4855 }, { 250,4855 }, { 251,4855 }, { 252,4855 },
 { 253,4855 }, { 254,4855 }, { 255,4855 }, { 256,4855 }, {   0,  44 },
 {   0,11908 }, {   1,4983 }, {   2,4983 }, {   3,4983 }, {   4,4983 },
 {   5,4983 }, {   6,4983 }, {   7,4983 }, {   8,4983 }, {   9,4983 },

 {  10,4983 }, {  11,4983 }, {  12,4983 }, {  13,4983 }, {  14,4983 },
 {  15,4983 }, {  16,4983 }, {  17,4983 }, {  18,4983 }, {  19,4983 },
 {  20,4983 }, {  21,4983 }, {  22,4983 }, {  23,4983 }, {  24,4983 },
 {  25,4983 }, {  26,4983 }, {  27,4983 }, {  28,4983 }, {  29,4983 },
 {  30,4983 }, {  31,4983 }, {  32,4983 }, {  33,4983 }, {   0,   0 },
 {  35,4983 }, {  36,4983 }, {  37,4983 }, {  38,4983 }, {  39,4983 },
 {  40,4983 }, {  41,4983 }, {  42,4983 }, {  43,4983 }, {  44,4983 },
 {  45,4983 }, {  46,4983 }, {  47,4983 }, {  48,4983 }, {  49,4983 },
 {  50,4983 }, {  51,4983 }, {  52,4983 }, {  53,4983 }, {  54,4983 },
 {  55,4983 }, {  56,4983 }, {  57,4983 }, {  58,4983 }, {  59,4983 },

 {  60,4983 }, {  61,4983 }, {  62,4983 }, {  63,4983 }, {  64,4983 },
 {  65,4983 }, {  66,4983 }, {  67,4983 }, {  68,4983 }, {  69,4983 },
 {  70,4983 }, {  71,4983 }, {  72,4983 }, {  73,4983 }, {  74,4983 },
 {  75,4983 }, {  76,4983 }, {  77,4983 }, {  78,4983 }, {  79,4983 },
 {  80,4983 }, {  81,4983 }, {  82,4983 }, {  83,4983 }, {  84,4983 },
 {  85,4983 }, {  86,4983 }, {  87,4983 }, {  88,4983 }, {  89,4983 },
 {  90,4983 }, {  91,4983 }, {  92,4983 }, {  93,4983 }, {  94,4983 },
 {  95,4983 }, {  96,4983 }, {  97,4983 }, {  98,4983 }, {  99,4983 },
 { 100,4983 }, { 101,4983 }, { 102,4983 }, { 103,4983 }, { 104,4983 },
 { 105,4983 }, { 106,4983 }, { 107,4983 }, { 108,4983 }, { 109,4983 },

 { 110,4983 }, { 111,4983 }, { 112,4983 }, { 113,4983 }, { 114,4983 },
 { 115,4983 }, { 116,4983 }, { 117,4983 }, { 118,4983 }, { 119,4983 },
 { 120,4983 }, { 121,4983 }, { 122,4983 }, { 123,4983 }, { 124,4983 },
 { 125,4983 }, { 126,4983 }, { 127,4983 }, { 128,4983 }, { 129,4983 },
 { 130,4983 }, { 131,4983 }, { 132,4983 }, { 133,4983 }, { 134,4983 },
 { 135,4983 }, { 136,4983 }, { 137,4983 }, { 138,4983 }, { 139,4983 },
 { 140,4983 }, { 141,4983 }, { 142,4983 }, { 143,4983 }, { 144,4983 },
 { 145,4983 }, { 146,4983 }, { 147,4983 }, { 148,4983 }, { 149,4983 },
 { 150,4983 }, { 151,4983 }, { 152,4983 }, { 153,4983 }, { 154,4983 },
 { 155,4983 }, { 156,4983 }, { 157,4983 }, { 158,4983 }, { 159,4983 },

 { 160,4983 }, { 161,4983 }, { 162,4983 }, { 163,4983 }, { 164,4983 },
 { 165,4983 }, { 166,4983 }, { 167,4983 }, { 168,4983 }, { 169,4983 },
 { 170,4983 }, { 171,4983 }, { 172,4983 }, { 173,4983 }, { 174,4983 },
 { 175,4983 }, { 176,4983 }, { 177,4983 }, { 178,4983 }, { 179,4983 },
 { 180,4983 }, { 181,4983 }, { 182,4983 }, { 183,4983 }, { 184,4983 },
 { 185,4983 }, { 186,4983 }, { 187,4983 }, { 188,4983 }, { 189,4983 },
 { 190,4983 }, { 191,4983 }, { 192,4983 }, { 193,4983 }, { 194,4983 },
 { 195,4983 }, { 196,4983 }, { 197,4983 }, { 198,4983 }, { 199,4983 },
 { 200,4983 }, { 201,4983 }, { 202,4983 }, { 203,4983 }, { 204,4983 },
 { 205,4983 }, { 206,4983 }, { 207,4983 }, { 208,4983 }, { 209,4983 },

 { 210,4983 }, { 211,4983 }, { 212,4983 }, { 213,4983 }, { 214,4983 },
 { 215,4983 }, { 216,4983 }, { 217,4983 }, { 218,4983 }, { 219,4983 },
 { 220,4983 }, { 221,4983 }, { 222,4983 }, { 223,4983 }, { 224,4983 },
 { 225,4983 }, { 226,4983 }, { 227,4983 }, { 228,4983 }, { 229,4983 },
 { 230,4983 }, { 231,4983 }, { 232,4983 }, { 233,4983 }, { 234,4983 },
 { 235,4983 }, { 236,4983 }, { 237,4983 }, { 238,4983 }, { 239,4983 },
 { 240,4983 }, { 241,4983 }, { 242,4983 }, { 243,4983 }, { 244,4983 },
 { 245,4983 }, { 246,4983 }, { 247,4983 }, { 248,4983 }, { 249,4983 },
 { 250,4983 }, { 251,4983 }, { 252,4983 }, { 253,4983 }, { 254,4983 },
 { 255,4983 }, { 256,4983 }, {   0,  10 }, {   0,11650 }, {   1,4983 },

 {   2,4983 }, {   3,4983 }, {   4,4983 }, {   5,4983 }, {   6,4983 },
 {   7,4983 }, {   8,4983 }, {   9,4983 }, {  10,4983 }, {  11,4983 },
 {  12,4983 }, {  13,4983 }, {  14,4983 }, {  15,4983 }, {  16,4983 },
 {  17,4983 }, {  18,4983 }, {  19,4983 }, {  20,4983 }, {  21,4983 },
 {  22,4983 }, {  23,4983 }, {  24,4983 }, {  25,4983 }, {  26,4983 },
 {  27,4983 }, {  28,4983 }, {  29,4983 }, {  30,4983 }, {  31,4983 },
 {  32,4983 }, {  33,4983 }, {  34,4983 }, {  35,4983 }, {  36,4983 },
 {  37,4983 }, {  38,4983 }, {   0,   0 }, {  40,4983 }, {  41,4983 },
 {  42,4983 }, {  43,4983 }, {  44,4983 }, {  45,4983 }, {  46,4983 },
 {  47,4983 }, {  48,4983 }, {  49,4983 }, {  50,4983 }, {  51,4983 },

 {  52,4983 }, {  53,4983 }, {  54,4983 }, {  55,4983 }, {  56,4983 },
 {  57,4983 }, {  58,4983 }, {  59,4983 }, {  60,4983 }, {  61,4983 },
 {  62,4983 }, {  63,4983 }, {  64,4983 }, {  65,4983 }, {  66,4983 },
 {  67,4983 }, {  68,4983 }, {  69,4983 }, {  70,4983 }, {  71,4983 },
 {  72,4983 }, {  73,4983 }, {  74,4983 }, {  75,4983 }, {  76,4983 },
 {  77,4983 }, {  78,4983 }, {  79,4983 }, {  80,4983 }, {  81,4983 },
 {  82,4983 }, {  83,4983 }, {  84,4983 }, {  85,4983 }, {  86,4983 },
 {  87,4983 }, {  88,4983 }, {  89,4983 }, {  90,4983 }, {  91,4983 },
 {  92,4983 }, {  93,4983 }, {  94,4983 }, {  95,4983 }, {  96,4983 },
 {  97,4983 }, {  98,4983 }, {  99,4983 }, { 100,4983 }, { 101,4983 },

 { 102,4983 }, { 103,4983 }, { 104,4983 }, { 105,4983 }, { 106,4983 },
 { 107,4983 }, { 108,4983 }, { 109,4983 }, { 110,4983 }, { 111,4983 },
 { 112,4983 }, { 113,4983 }, { 114,4983 }, { 115,4983 }, { 116,4983 },
 { 117,4983 }, { 118,4983 }, { 119,4983 }, { 120,4983 }, { 121,4983 },
 { 122,4983 }, { 123,4983 }, { 124,4983 }, { 125,4983 }, { 126,4983 },
 { 127,4983 }, { 128,4983 }, { 129,4983 }, { 130,4983 }, { 131,4983 },
 { 132,4983 }, { 133,4983 }, { 134,4983 }, { 135,4983 }, { 136,4983 },
 { 137,4983 }, { 138,4983 }, { 139,4983 }, { 140,4983 }, { 141,4983 },
 { 142,4983 }, { 143,4983 }, { 144,4983 }, { 145,4983 }, { 146,4983 },
 { 147,4983 }, { 148,4983 }, { 149,4983 }, { 150,4983 }, { 151,4983 },

 { 152,4983 }, { 153,4983 }, { 154,4983 }, { 155,4983 }, { 156,4983 },
 { 157,4983 }, { 158,4983 }, { 159,4983 }, { 160,4983 }, { 161,4983 },
 { 162,4983 }, { 163,4983 }, { 164,4983 }, { 165,4983 }, { 166,4983 },
 { 167,4983 }, { 168,4983 }, { 169,4983 }, { 170,4983 }, { 171,4983 },
 { 172,4983 }, { 173,4983 }, { 174,4983 }, { 175,4983 }, { 176,4983 },
 { 177,4983 }, { 178,4983 }, { 179,4983 }, { 180,4983 }, { 181,4983 },
 { 182,4983 }, { 183,4983 }, { 184,4983 }, { 185,4983 }, { 186,4983 },
 { 187,4983 }, { 188,4983 }, { 189,4983 }, { 190,4983 }, { 191,4983 },
 { 192,4983 }, { 193,4983 }, { 194,4983 }, { 195,4983 }, { 196,4983 },
 { 197,4983 }, { 198,4983 }, { 199,4983 }, { 200,4983 }, { 201,4983 },

 { 202,4983 }, { 203,4983 }, { 204,4983 }, { 205,4983 }, { 206,4983 },
 { 207,4983 }, { 208,4983 }, { 209,4983 }, { 210,4983 }, { 211,4983 },
 { 212,4983 }, { 213,4983 }, { 214,4983 }, { 215,4983 }, { 216,4983 },
 { 217,4983 }, { 218,4983 }, { 219,4983 }, { 220,4983 }, { 221,4983 },
 { 222,4983 }, { 223,4983 }, { 224,4983 }, { 225,4983 }, { 226,4983 },
 { 227,4983 }, { 228,4983 }, { 229,4983 }, { 230,4983 }, { 231,4983 },
 { 232,4983 }, { 233,4983 }, { 234,4983 }, { 235,4983 }, { 236,4983 },
 { 237,4983 }, { 238,4983 }, { 239,4983 }, { 240,4983 }, { 241,4983 },
 { 242,4983 }, { 243,4983 }, { 244,4983 }, { 245,4983 }, { 246,4983 },
 { 247,4983 }, { 248,4983 }, { 249,4983 }, { 250,4983 }, { 251,4983 },

 { 252,4983 }, { 253,4983 }, { 254,4983 }, { 255,4983 }, { 256,4983 },
 {   0,  22 }, {   0,11392 }, {   1,4983 }, {   2,4983 }, {   3,4983 },
 {   4,4983 }, {   5,4983 }, {   6,4983 }, {   7,4983 }, {   8,4983 },
 {   9,4983 }, {  10,4983 }, {  11,4983 }, {  12,4983 }, {  13,4983 },
 {  14,4983 }, {  15,4983 }, {  16,4983 }, {  17,4983 }, {  18,4983 },
 {  19,4983 }, {  20,4983 }, {  21,4983 }, {  22,4983 }, {  23,4983 },
 {  24,4983 }, {  25,4983 }, {  26,4983 }, {  27,4983 }, {  28,4983 },
 {  29,4983 }, {  30,4983 }, {  31,4983 }, {  32,4983 }, {  33,4983 },
 {  34,4983 }, {  35,4983 }, {  36,4983 }, {  37,4983 }, {  38,4983 },
 {   0,   0 }, {  40,4983 }, {  41,4983 }, {  42,4983 }, {  43,4983 },

 {  44,4983 }, {  45,4983 }, {  46,4983 }, {  47,4983 }, {  48,4983 },
 {  49,4983 }, {  50,4983 }, {  51,4983 }, {  52,4983 }, {  53,4983 },
 {  54,4983 }, {  55,4983 }, {  56,4983 }, {  57,4983 }, {  58,4983 },
 {  59,4983 }, {  60,4983 }, {  61,4983 }, {  62,4983 }, {  63,4983 },
 {  64,4983 }, {  65,4983 }, {  66,4983 }, {  67,4983 }, {  68,4983 },
 {  69,4983 }, {  70,4983 }, {  71,4983 }, {  72,4983 }, {  73,4983 },
 {  74,4983 }, {  75,4983 }, {  76,4983 }, {  77,4983 }, {  78,4983 },
 {  79,4983 }, {  80,4983 }, {  81,4983 }, {  82,4983 }, {  83,4983 },
 {  84,4983 }, {  85,4983 }, {  86,4983 }, {  87,4983 }, {  88,4983 },
 {  89,4983 }, {  90,4983 }, {  91,4983 }, {  92,4983 }, {  93,4983 },

 {  94,4983 }, {  95,4983 }, {  96,4983 }, {  97,4983 }, {  98,4983 },
 {  99,4983 }, { 100,4983 }, { 101,4983 }, { 102,4983 }, { 103,4983 },
 { 104,4983 }, { 105,4983 }, { 106,4983 }, { 107,4983 }, { 108,4983 },
 { 109,4983 }, { 110,4983 }, { 111,4983 }, { 112,4983 }, { 113,4983 },
 { 114,4983 }, { 115,4983 }, { 116,4983 }, { 117,4983 }, { 118,4983 },
 { 119,4983 }, { 120,4983 }, { 121,4983 }, { 122,4983 }, { 123,4983 },
 { 124,4983 }, { 125,4983 }, { 126,4983 }, { 127,4983 }, { 128,4983 },
 { 129,4983 }, { 130,4983 }, { 131,4983 }, { 132,4983 }, { 133,4983 },
 { 134,4983 }, { 135,4983 }, { 136,4983 }, { 137,4983 }, { 138,4983 },
 { 139,4983 }, { 140,4983 }, { 141,4983 }, { 142,4983 }, { 143,4983 },

 { 144,4983 }, { 145,4983 }, { 146,4983 }, { 147,4983 }, { 148,4983 },
 { 149,4983 }, { 150,4983 }, { 151,4983 }, { 152,4983 }, { 153,4983 },
 { 154,4983 }, { 155,4983 }, { 156,4983 }, { 157,4983 }, { 158,4983 },
 { 159,4983 }, { 160,4983 }, { 161,4983 }, { 162,4983 }, { 163,4983 },
 { 164,4983 }, { 165,4983 }, { 166,4983 }, { 167,4983 }, { 168,4983 },
 { 169,4983 }, { 170,4983 }, { 171,4983 }, { 172,4983 }, { 173,4983 },
 { 174,4983 }, { 175,4983 }, { 176,4983 }, { 177,4983 }, { 178,4983 },
 { 179,4983 }, { 180,4983 }, { 181,4983 }, { 182,4983 }, { 183,4983 },
 { 184,4983 }, { 185,4983 }, { 186,4983 }, { 187,4983 }, { 188,4983 },
 { 189,4983 }, { 190,4983 }, { 191,4983 }, { 192,4983 }, { 193,4983 },

 { 194,4983 }, { 195,4983 }, { 196,4983 }, { 197,4983 }, { 198,4983 },
 { 199,4983 }, { 200,4983 }, { 201,4983 }, { 202,4983 }, { 203,4983 },
 { 204,4983 }, { 205,4983 }, { 206,4983 }, { 207,4983 }, { 208,4983 },
 { 209,4983 }, { 210,4983 }, { 211,4983 }, { 212,4983 }, { 213,4983 },
 { 214,4983 }, { 215,4983 }, { 216,4983 }, { 217,4983 }, { 218,4983 },
 { 219,4983 }, { 220,4983 }, { 221,4983 }, { 222,4983 }, { 223,4983 },
 { 224,4983 }, { 225,4983 }, { 226,4983 }, { 227,4983 }, { 228,4983 },
 { 229,4983 }, { 230,4983 }, { 231,4983 }, { 232,4983 }, { 233,4983 },
 { 234,4983 }, { 235,4983 }, { 236,4983 }, { 237,4983 }, { 238,4983 },
 { 239,4983 }, { 240,4983 }, { 241,4983 }, { 242,4983 }, { 243,4983 },

 { 244,4983 }, { 245,4983 }, { 246,4983 }, { 247,4983 }, { 248,4983 },
 { 249,4983 }, { 250,4983 }, { 251,4983 }, { 252,4983 }, { 253,4983 },
 { 254,4983 }, { 255,4983 }, { 256,4983 }, {   0,  19 }, {   0,11134 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  19 }, {   0,11129 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,4983 }, {  10,4988 },
 {   0,   0 }, {  12,4983 }, {  13,4988 }, {   9,4999 }, {  10,4999 },
 {   0,   0 }, {  12,4999 }, {  13,4999 }, {   0,   0 }, {   0,  19 },
 {   0,11113 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,4983 },
 {  10,4983 }, {  32,4983 }, {  12,4983 }, {  13,4983 }, {   0,   0 },

 {   0,   0 }, {  32,4999 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-3785 }, {  45,-3807 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-3812 },
 {   0,   0 }, {   0,   0 }, {  32,4983 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-3801 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  45,-3828 }, {   0,  23 }, {   0,11066 }, {   1,4983 }, {   2,4983 },
 {   3,4983 }, {   4,4983 }, {   5,4983 }, {   6,4983 }, {   7,4983 },
 {   8,4983 }, {   9,4983 }, {  10,4983 }, {  11,4983 }, {  12,4983 },
 {  13,4983 }, {  14,4983 }, {  15,4983 }, {  16,4983 }, {  17,4983 },

 {  18,4983 }, {  19,4983 }, {  20,4983 }, {  21,4983 }, {  22,4983 },
 {  23,4983 }, {  24,4983 }, {  25,4983 }, {  26,4983 }, {  27,4983 },
 {  28,4983 }, {  29,4983 }, {  30,4983 }, {  31,4983 }, {  32,4983 },
 {  33,4983 }, {  34,4983 }, {  35,4983 }, {  36,4983 }, {  37,4983 },
 {  38,4983 }, {   0,   0 }, {  40,4983 }, {  41,4983 }, {  42,4983 },
 {  43,4983 }, {  44,4983 }, {  45,4983 }, {  46,4983 }, {  47,4983 },
 {  48,4983 }, {  49,4983 }, {  50,4983 }, {  51,4983 }, {  52,4983 },
 {  53,4983 }, {  54,4983 }, {  55,4983 }, {  56,4983 }, {  57,4983 },
 {  58,4983 }, {  59,4983 }, {  60,4983 }, {  61,4983 }, {  62,4983 },
 {  63,4983 }, {  64,4983 }, {  65,4983 }, {  66,4983 }, {  67,4983 },

 {  68,4983 }, {  69,4983 }, {  70,4983 }, {  71,4983 }, {  72,4983 },
 {  73,4983 }, {  74,4983 }, {  75,4983 }, {  76,4983 }, {  77,4983 },
 {  78,4983 }, {  79,4983 }, {  80,4983 }, {  81,4983 }, {  82,4983 },
 {  83,4983 }, {  84,4983 }, {  85,4983 }, {  86,4983 }, {  87,4983 },
 {  88,4983 }, {  89,4983 }, {  90,4983 }, {  91,4983 }, {   0,   0 },
 {  93,4983 }, {  94,4983 }, {  95,4983 }, {  96,4983 }, {  97,4983 },
 {  98,4983 }, {  99,4983 }, { 100,4983 }, { 101,4983 }, { 102,4983 },
 { 103,4983 }, { 104,4983 }, { 105,4983 }, { 106,4983 }, { 107,4983 },
 { 108,4983 }, { 109,4983 }, { 110,4983 }, { 111,4983 }, { 112,4983 },
 { 113,4983 }, { 114,4983 }, { 115,4983 }, { 116,4983 }, { 117,4983 },

 { 118,4983 }, { 119,4983 }, { 120,4983 }, { 121,4983 }, { 122,4983 },
 { 123,4983 }, { 124,4983 }, { 125,4983 }, { 126,4983 }, { 127,4983 },
 { 128,4983 }, { 129,4983 }, { 130,4983 }, { 131,4983 }, { 132,4983 },
 { 133,4983 }, { 134,4983 }, { 135,4983 }, { 136,4983 }, { 137,4983 },
 { 138,4983 }, { 139,4983 }, { 140,4983 }, { 141,4983 }, { 142,4983 },
 { 143,4983 }, { 144,4983 }, { 145,4983 }, { 146,4983 }, { 147,4983 },
 { 148,4983 }, { 149,4983 }, { 150,4983 }, { 151,4983 }, { 152,4983 },
 { 153,4983 }, { 154,4983 }, { 155,4983 }, { 156,4983 }, { 157,4983 },
 { 158,4983 }, { 159,4983 }, { 160,4983 }, { 161,4983 }, { 162,4983 },
 { 163,4983 }, { 164,4983 }, { 165,4983 }, { 166,4983 }, { 167,4983 },

 { 168,4983 }, { 169,4983 }, { 170,4983 }, { 171,4983 }, { 172,4983 },
 { 173,4983 }, { 174,4983 }, { 175,4983 }, { 176,4983 }, { 177,4983 },
 { 178,4983 }, { 179,4983 }, { 180,4983 }, { 181,4983 }, { 182,4983 },
 { 183,4983 }, { 184,4983 }, { 185,4983 }, { 186,4983 }, { 187,4983 },
 { 188,4983 }, { 189,4983 }, { 190,4983 }, { 191,4983 }, { 192,4983 },
 { 193,4983 }, { 194,4983 }, { 195,4983 }, { 196,4983 }, { 197,4983 },
 { 198,4983 }, { 199,4983 }, { 200,4983 }, { 201,4983 }, { 202,4983 },
 { 203,4983 }, { 204,4983 }, { 205,4983 }, { 206,4983 }, { 207,4983 },
 { 208,4983 }, { 209,4983 }, { 210,4983 }, { 211,4983 }, { 212,4983 },
 { 213,4983 }, { 214,4983 }, { 215,4983 }, { 216,4983 }, { 217,4983 },

 { 218,4983 }, { 219,4983 }, { 220,4983 }, { 221,4983 }, { 222,4983 },
 { 223,4983 }, { 224,4983 }, { 225,4983 }, { 226,4983 }, { 227,4983 },
 { 228,4983 }, { 229,4983 }, { 230,4983 }, { 231,4983 }, { 232,4983 },
 { 233,4983 }, { 234,4983 }, { 235,4983 }, { 236,4983 }, { 237,4983 },
 { 238,4983 }, { 239,4983 }, { 240,4983 }, { 241,4983 }, { 242,4983 },
 { 243,4983 }, { 244,4983 }, { 245,4983 }, { 246,4983 }, { 247,4983 },
 { 248,4983 }, { 249,4983 }, { 250,4983 }, { 251,4983 }, { 252,4983 },
 { 253,4983 }, { 254,4983 }, { 255,4983 }, { 256,4983 }, {   0,  23 },
 {   0,10808 }, {   1,4725 }, {   2,4725 }, {   3,4725 }, {   4,4725 },
 {   5,4725 }, {   6,4725 }, {   7,4725 }, {   8,4725 }, {   9,4725 },

 {  10,4725 }, {  11,4725 }, {  12,4725 }, {  13,4725 }, {  14,4725 },
 {  15,4725 }, {  16,4725 }, {  17,4725 }, {  18,4725 }, {  19,4725 },
 {  20,4725 }, {  21,4725 }, {  22,4725 }, {  23,4725 }, {  24,4725 },
 {  25,4725 }, {  26,4725 }, {  27,4725 }, {  28,4725 }, {  29,4725 },
 {  30,4725 }, {  31,4725 }, {  32,4725 }, {  33,4725 }, {  34,4725 },
 {  35,4725 }, {  36,4725 }, {  37,4725 }, {  38,4725 }, {   0,   0 },
 {  40,4725 }, {  41,4725 }, {  42,4725 }, {  43,4725 }, {  44,4725 },
 {  45,4725 }, {  46,4725 }, {  47,4725 }, {  48,4725 }, {  49,4725 },
 {  50,4725 }, {  51,4725 }, {  52,4725 }, {  53,4725 }, {  54,4725 },
 {  55,4725 }, {  56,4725 }, {  57,4725 }, {  58,4725 }, {  59,4725 },

 {  60,4725 }, {  61,4725 }, {  62,4725 }, {  63,4725 }, {  64,4725 },
 {  65,4725 }, {  66,4725 }, {  67,4725 }, {  68,4725 }, {  69,4725 },
 {  70,4725 }, {  71,4725 }, {  72,4725 }, {  73,4725 }, {  74,4725 },
 {  75,4725 }, {  76,4725 }, {  77,4725 }, {  78,4725 }, {  79,4725 },
 {  80,4725 }, {  81,4725 }, {  82,4725 }, {  83,4725 }, {  84,4725 },
 {  85,4725 }, {  86,4725 }, {  87,4725 }, {  88,4725 }, {  89,4725 },
 {  90,4725 }, {  91,4725 }, {   0,   0 }, {  93,4725 }, {  94,4725 },
 {  95,4725 }, {  96,4725 }, {  97,4725 }, {  98,4725 }, {  99,4725 },
 { 100,4725 }, { 101,4725 }, { 102,4725 }, { 103,4725 }, { 104,4725 },
 { 105,4725 }, { 106,4725 }, { 107,4725 }, { 108,4725 }, { 109,4725 },

 { 110,4725 }, { 111,4725 }, { 112,4725 }, { 113,4725 }, { 114,4725 },
 { 115,4725 }, { 116,4725 }, { 117,4725 }, { 118,4725 }, { 119,4725 },
 { 120,4725 }, { 121,4725 }, { 122,4725 }, { 123,4725 }, { 124,4725 },
 { 125,4725 }, { 126,4725 }, { 127,4725 }, { 128,4725 }, { 129,4725 },
 { 130,4725 }, { 131,4725 }, { 132,4725 }, { 133,4725 }, { 134,4725 },
 { 135,4725 }, { 136,4725 }, { 137,4725 }, { 138,4725 }, { 139,4725 },
 { 140,4725 }, { 141,4725 }, { 142,4725 }, { 143,4725 }, { 144,4725 },
 { 145,4725 }, { 146,4725 }, { 147,4725 }, { 148,4725 }, { 149,4725 },
 { 150,4725 }, { 151,4725 }, { 152,4725 }, { 153,4725 }, { 154,4725 },
 { 155,4725 }, { 156,4725 }, { 157,4725 }, { 158,4725 }, { 159,4725 },

 { 160,4725 }, { 161,4725 }, { 162,4725 }, { 163,4725 }, { 164,4725 },
 { 165,4725 }, { 166,4725 }, { 167,4725 }, { 168,4725 }, { 169,4725 },
 { 170,4725 }, { 171,4725 }, { 172,4725 }, { 173,4725 }, { 174,4725 },
 { 175,4725 }, { 176,4725 }, { 177,4725 }, { 178,4725 }, { 179,4725 },
 { 180,4725 }, { 181,4725 }, { 182,4725 }, { 183,4725 }, { 184,4725 },
 { 185,4725 }, { 186,4725 }, { 187,4725 }, { 188,4725 }, { 189,4725 },
 { 190,4725 }, { 191,4725 }, { 192,4725 }, { 193,4725 }, { 194,4725 },
 { 195,4725 }, { 196,4725 }, { 197,4725 }, { 198,4725 }, { 199,4725 },
 { 200,4725 }, { 201,4725 }, { 202,4725 }, { 203,4725 }, { 204,4725 },
 { 205,4725 }, { 206,4725 }, { 207,4725 }, { 208,4725 }, { 209,4725 },

 { 210,4725 }, { 211,4725 }, { 212,4725 }, { 213,4725 }, { 214,4725 },
 { 215,4725 }, { 216,4725 }, { 217,4725 }, { 218,4725 }, { 219,4725 },
 { 220,4725 }, { 221,4725 }, { 222,4725 }, { 223,4725 }, { 224,4725 },
 { 225,4725 }, { 226,4725 }, { 227,4725 }, { 228,4725 }, { 229,4725 },
 { 230,4725 }, { 231,4725 }, { 232,4725 }, { 233,4725 }, { 234,4725 },
 { 235,4725 }, { 236,4725 }, { 237,4725 }, { 238,4725 }, { 239,4725 },
 { 240,4725 }, { 241,4725 }, { 242,4725 }, { 243,4725 }, { 244,4725 },
 { 245,4725 }, { 246,4725 }, { 247,4725 }, { 248,4725 }, { 249,4725 },
 { 250,4725 }, { 251,4725 }, { 252,4725 }, { 253,4725 }, { 254,4725 },
 { 255,4725 }, { 256,4725 }, {   0,  32 }, {   0,10550 }, {   1,-4362 },

 {   2,-4362 }, {   3,-4362 }, {   4,-4362 }, {   5,-4362 }, {   6,-4362 },
 {   7,-4362 }, {   8,-4362 }, {   9,-4362 }, {  10,-4362 }, {  11,-4362 },
 {  12,-4362 }, {  13,-4362 }, {  14,-4362 }, {  15,-4362 }, {  16,-4362 },
 {  17,-4362 }, {  18,-4362 }, {  19,-4362 }, {  20,-4362 }, {  21,-4362 },
 {  22,-4362 }, {  23,-4362 }, {  24,-4362 }, {  25,-4362 }, {  26,-4362 },
 {  27,-4362 }, {  28,-4362 }, {  29,-4362 }, {  30,-4362 }, {  31,-4362 },
 {  32,-4362 }, {  33,-4362 }, {  34,-4362 }, {  35,-4362 }, {  36,-4362 },
 {  37,-4362 }, {  38,-4362 }, {  39,-4362 }, {  40,-4362 }, {  41,-4362 },
 {  42,-4362 }, {  43,-4362 }, {  44,-4362 }, {  45,-4362 }, {  46,-4362 },
 {  47,-4362 }, {  48,4725 }, {  49,4725 }, {  50,4725 }, {  51,4725 },

 {  52,4725 }, {  53,4725 }, {  54,4725 }, {  55,4725 }, {  56,-4362 },
 {  57,-4362 }, {  58,-4362 }, {  59,-4362 }, {  60,-4362 }, {  61,-4362 },
 {  62,-4362 }, {  63,-4362 }, {  64,-4362 }, {  65,-4362 }, {  66,-4362 },
 {  67,-4362 }, {  68,-4362 }, {  69,-4362 }, {  70,-4362 }, {  71,-4362 },
 {  72,-4362 }, {  73,-4362 }, {  74,-4362 }, {  75,-4362 }, {  76,-4362 },
 {  77,-4362 }, {  78,-4362 }, {  79,-4362 }, {  80,-4362 }, {  81,-4362 },
 {  82,-4362 }, {  83,-4362 }, {  84,-4362 }, {  85,4733 }, {  86,-4362 },
 {  87,-4362 }, {  88,-4362 }, {  89,-4362 }, {  90,-4362 }, {  91,-4362 },
 {  92,-4362 }, {  93,-4362 }, {  94,-4362 }, {  95,-4362 }, {  96,-4362 },
 {  97,-4362 }, {  98,-4362 }, {  99,-4362 }, { 100,-4362 }, { 101,-4362 },

 { 102,-4362 }, { 103,-4362 }, { 104,-4362 }, { 105,-4362 }, { 106,-4362 },
 { 107,-4362 }, { 108,-4362 }, { 109,-4362 }, { 110,-4362 }, { 111,-4362 },
 { 112,-4362 }, { 113,-4362 }, { 114,-4362 }, { 115,-4362 }, { 116,-4362 },
 { 117,4756 }, { 118,-4362 }, { 119,-4362 }, { 120,4794 }, { 121,-4362 },
 { 122,-4362 }, { 123,-4362 }, { 124,-4362 }, { 125,-4362 }, { 126,-4362 },
 { 127,-4362 }, { 128,-4362 }, { 129,-4362 }, { 130,-4362 }, { 131,-4362 },
 { 132,-4362 }, { 133,-4362 }, { 134,-4362 }, { 135,-4362 }, { 136,-4362 },
 { 137,-4362 }, { 138,-4362 }, { 139,-4362 }, { 140,-4362 }, { 141,-4362 },
 { 142,-4362 }, { 143,-4362 }, { 144,-4362 }, { 145,-4362 }, { 146,-4362 },
 { 147,-4362 }, { 148,-4362 }, { 149,-4362 }, { 150,-4362 }, { 151,-4362 },

 { 152,-4362 }, { 153,-4362 }, { 154,-4362 }, { 155,-4362 }, { 156,-4362 },
 { 157,-4362 }, { 158,-4362 }, { 159,-4362 }, { 160,-4362 }, { 161,-4362 },
 { 162,-4362 }, { 163,-4362 }, { 164,-4362 }, { 165,-4362 }, { 166,-4362 },
 { 167,-4362 }, { 168,-4362 }, { 169,-4362 }, { 170,-4362 }, { 171,-4362 },
 { 172,-4362 }, { 173,-4362 }, { 174,-4362 }, { 175,-4362 }, { 176,-4362 },
 { 177,-4362 }, { 178,-4362 }, { 179,-4362 }, { 180,-4362 }, { 181,-4362 },
 { 182,-4362 }, { 183,-4362 }, { 184,-4362 }, { 185,-4362 }, { 186,-4362 },
 { 187,-4362 }, { 188,-4362 }, { 189,-4362 }, { 190,-4362 }, { 191,-4362 },
 { 192,-4362 }, { 193,-4362 }, { 194,-4362 }, { 195,-4362 }, { 196,-4362 },
 { 197,-4362 }, { 198,-4362 }, { 199,-4362 }, { 200,-4362 }, { 201,-4362 },

 { 202,-4362 }, { 203,-4362 }, { 204,-4362 }, { 205,-4362 }, { 206,-4362 },
 { 207,-4362 }, { 208,-4362 }, { 209,-4362 }, { 210,-4362 }, { 211,-4362 },
 { 212,-4362 }, { 213,-4362 }, { 214,-4362 }, { 215,-4362 }, { 216,-4362 },
 { 217,-4362 }, { 218,-4362 }, { 219,-4362 }, { 220,-4362 }, { 221,-4362 },
 { 222,-4362 }, { 223,-4362 }, { 224,-4362 }, { 225,-4362 }, { 226,-4362 },
 { 227,-4362 }, { 228,-4362 }, { 229,-4362 }, { 230,-4362 }, { 231,-4362 },
 { 232,-4362 }, { 233,-4362 }, { 234,-4362 }, { 235,-4362 }, { 236,-4362 },
 { 237,-4362 }, { 238,-4362 }, { 239,-4362 }, { 240,-4362 }, { 241,-4362 },
 { 242,-4362 }, { 243,-4362 }, { 244,-4362 }, { 245,-4362 }, { 246,-4362 },
 { 247,-4362 }, { 248,-4362 }, { 249,-4362 }, { 250,-4362 }, { 251,-4362 },

 { 252,-4362 }, { 253,-4362 }, { 254,-4362 }, { 255,-4362 }, { 256,-4362 },
 {   0,  36 }, {   0,10292 }, {   1,4640 }, {   2,4640 }, {   3,4640 },
 {   4,4640 }, {   5,4640 }, {   6,4640 }, {   7,4640 }, {   8,4640 },
 {   9,4640 }, {  10,4640 }, {  11,4640 }, {  12,4640 }, {  13,4640 },
 {  14,4640 }, {  15,4640 }, {  16,4640 }, {  17,4640 }, {  18,4640 },
 {  19,4640 }, {  20,4640 }, {  21,4640 }, {  22,4640 }, {  23,4640 },
 {  24,4640 }, {  25,4640 }, {  26,4640 }, {  27,4640 }, {  28,4640 },
 {  29,4640 }, {  30,4640 }, {  31,4640 }, {  32,4640 }, {  33,4640 },
 {  34,4640 }, {  35,4640 }, {   0,   0 }, {  37,4640 }, {  38,4640 },
 {  39,4640 }, {  40,4640 }, {  41,4640 }, {  42,4640 }, {  43,4640 },

 {  44,4640 }, {  45,4640 }, {  46,4640 }, {  47,4640 }, {  48,4640 },
 {  49,4640 }, {  50,4640 }, {  51,4640 }, {  52,4640 }, {  53,4640 },
 {  54,4640 }, {  55,4640 }, {  56,4640 }, {  57,4640 }, {  58,4640 },
 {  59,4640 }, {  60,4640 }, {  61,4640 }, {  62,4640 }, {  63,4640 },
 {  64,4640 }, {  65,4640 }, {  66,4640 }, {  67,4640 }, {  68,4640 },
 {  69,4640 }, {  70,4640 }, {  71,4640 }, {  72,4640 }, {  73,4640 },
 {  74,4640 }, {  75,4640 }, {  76,4640 }, {  77,4640 }, {  78,4640 },
 {  79,4640 }, {  80,4640 }, {  81,4640 }, {  82,4640 }, {  83,4640 },
 {  84,4640 }, {  85,4640 }, {  86,4640 }, {  87,4640 }, {  88,4640 },
 {  89,4640 }, {  90,4640 }, {  91,4640 }, {  92,4640 }, {  93,4640 },

 {  94,4640 }, {  95,4640 }, {  96,4640 }, {  97,4640 }, {  98,4640 },
 {  99,4640 }, { 100,4640 }, { 101,4640 }, { 102,4640 }, { 103,4640 },
 { 104,4640 }, { 105,4640 }, { 106,4640 }, { 107,4640 }, { 108,4640 },
 { 109,4640 }, { 110,4640 }, { 111,4640 }, { 112,4640 }, { 113,4640 },
 { 114,4640 }, { 115,4640 }, { 116,4640 }, { 117,4640 }, { 118,4640 },
 { 119,4640 }, { 120,4640 }, { 121,4640 }, { 122,4640 }, { 123,4640 },
 { 124,4640 }, { 125,4640 }, { 126,4640 }, { 127,4640 }, { 128,4640 },
 { 129,4640 }, { 130,4640 }, { 131,4640 }, { 132,4640 }, { 133,4640 },
 { 134,4640 }, { 135,4640 }, { 136,4640 }, { 137,4640 }, { 138,4640 },
 { 139,4640 }, { 140,4640 }, { 141,4640 }, { 142,4640 }, { 143,4640 },

 { 144,4640 }, { 145,4640 }, { 146,4640 }, { 147,4640 }, { 148,4640 },
 { 149,4640 }, { 150,4640 }, { 151,4640 }, { 152,4640 }, { 153,4640 },
 { 154,4640 }, { 155,4640 }, { 156,4640 }, { 157,4640 }, { 158,4640 },
 { 159,4640 }, { 160,4640 }, { 161,4640 }, { 162,4640 }, { 163,4640 },
 { 164,4640 }, { 165,4640 }, { 166,4640 }, { 167,4640 }, { 168,4640 },
 { 169,4640 }, { 170,4640 }, { 171,4640 }, { 172,4640 }, { 173,4640 },
 { 174,4640 }, { 175,4640 }, { 176,4640 }, { 177,4640 }, { 178,4640 },
 { 179,4640 }, { 180,4640 }, { 181,4640 }, { 182,4640 }, { 183,4640 },
 { 184,4640 }, { 185,4640 }, { 186,4640 }, { 187,4640 }, { 188,4640 },
 { 189,4640 }, { 190,4640 }, { 191,4640 }, { 192,4640 }, { 193,4640 },

 { 194,4640 }, { 195,4640 }, { 196,4640 }, { 197,4640 }, { 198,4640 },
 { 199,4640 }, { 200,4640 }, { 201,4640 }, { 202,4640 }, { 203,4640 },
 { 204,4640 }, { 205,4640 }, { 206,4640 }, { 207,4640 }, { 208,4640 },
 { 209,4640 }, { 210,4640 }, { 211,4640 }, { 212,4640 }, { 213,4640 },
 { 214,4640 }, { 215,4640 }, { 216,4640 }, { 217,4640 }, { 218,4640 },
 { 219,4640 }, { 220,4640 }, { 221,4640 }, { 222,4640 }, { 223,4640 },
 { 224,4640 }, { 225,4640 }, { 226,4640 }, { 227,4640 }, { 228,4640 },
 { 229,4640 }, { 230,4640 }, { 231,4640 }, { 232,4640 }, { 233,4640 },
 { 234,4640 }, { 235,4640 }, { 236,4640 }, { 237,4640 }, { 238,4640 },
 { 239,4640 }, { 240,4640 }, { 241,4640 }, { 242,4640 }, { 243,4640 },

 { 244,4640 }, { 245,4640 }, { 246,4640 }, { 247,4640 }, { 248,4640 },
 { 249,4640 }, { 250,4640 }, { 251,4640 }, { 252,4640 }, { 253,4640 },
 { 254,4640 }, { 255,4640 }, { 256,4640 }, {   0,  36 }, {   0,10034 },
 {   1,4382 }, {   2,4382 }, {   3,4382 }, {   4,4382 }, {   5,4382 },
 {   6,4382 }, {   7,4382 }, {   8,4382 }, {   9,4382 }, {  10,4382 },
 {  11,4382 }, {  12,4382 }, {  13,4382 }, {  14,4382 }, {  15,4382 },
 {  16,4382 }, {  17,4382 }, {  18,4382 }, {  19,4382 }, {  20,4382 },
 {  21,4382 }, {  22,4382 }, {  23,4382 }, {  24,4382 }, {  25,4382 },
 {  26,4382 }, {  27,4382 }, {  28,4382 }, {  29,4382 }, {  30,4382 },
 {  31,4382 }, {  32,4382 }, {  33,4382 }, {  34,4382 }, {  35,4382 },

 {   0,   0 }, {  37,4382 }, {  38,4382 }, {  39,4382 }, {  40,4382 },
 {  41,4382 }, {  42,4382 }, {  43,4382 }, {  44,4382 }, {  45,4382 },
 {  46,4382 }, {  47,4382 }, {  48,4382 }, {  49,4382 }, {  50,4382 },
 {  51,4382 }, {  52,4382 }, {  53,4382 }, {  54,4382 }, {  55,4382 },
 {  56,4382 }, {  57,4382 }, {  58,4382 }, {  59,4382 }, {  60,4382 },
 {  61,4382 }, {  62,4382 }, {  63,4382 }, {  64,4382 }, {  65,4382 },
 {  66,4382 }, {  67,4382 }, {  68,4382 }, {  69,4382 }, {  70,4382 },
 {  71,4382 }, {  72,4382 }, {  73,4382 }, {  74,4382 }, {  75,4382 },
 {  76,4382 }, {  77,4382 }, {  78,4382 }, {  79,4382 }, {  80,4382 },
 {  81,4382 }, {  82,4382 }, {  83,4382 }, {  84,4382 }, {  85,4382 },

 {  86,4382 }, {  87,4382 }, {  88,4382 }, {  89,4382 }, {  90,4382 },
 {  91,4382 }, {  92,4382 }, {  93,4382 }, {  94,4382 }, {  95,4382 },
 {  96,4382 }, {  97,4382 }, {  98,4382 }, {  99,4382 }, { 100,4382 },
 { 101,4382 }, { 102,4382 }, { 103,4382 }, { 104,4382 }, { 105,4382 },
 { 106,4382 }, { 107,4382 }, { 108,4382 }, { 109,4382 }, { 110,4382 },
 { 111,4382 }, { 112,4382 }, { 113,4382 }, { 114,4382 }, { 115,4382 },
 { 116,4382 }, { 117,4382 }, { 118,4382 }, { 119,4382 }, { 120,4382 },
 { 121,4382 }, { 122,4382 }, { 123,4382 }, { 124,4382 }, { 125,4382 },
 { 126,4382 }, { 127,4382 }, { 128,4382 }, { 129,4382 }, { 130,4382 },
 { 131,4382 }, { 132,4382 }, { 133,4382 }, { 134,4382 }, { 135,4382 },

 { 136,4382 }, { 137,4382 }, { 138,4382 }, { 139,4382 }, { 140,4382 },
 { 141,4382 }, { 142,4382 }, { 143,4382 }, { 144,4382 }, { 145,4382 },
 { 146,4382 }, { 147,4382 }, { 148,4382 }, { 149,4382 }, { 150,4382 },
 { 151,4382 }, { 152,4382 }, { 153,4382 }, { 154,4382 }, { 155,4382 },
 { 156,4382 }, { 157,4382 }, { 158,4382 }, { 159,4382 }, { 160,4382 },
 { 161,4382 }, { 162,4382 }, { 163,4382 }, { 164,4382 }, { 165,4382 },
 { 166,4382 }, { 167,4382 }, { 168,4382 }, { 169,4382 }, { 170,4382 },
 { 171,4382 }, { 172,4382 }, { 173,4382 }, { 174,4382 }, { 175,4382 },
 { 176,4382 }, { 177,4382 }, { 178,4382 }, { 179,4382 }, { 180,4382 },
 { 181,4382 }, { 182,4382 }, { 183,4382 }, { 184,4382 }, { 185,4382 },

 { 186,4382 }, { 187,4382 }, { 188,4382 }, { 189,4382 }, { 190,4382 },
 { 191,4382 }, { 192,4382 }, { 193,4382 }, { 194,4382 }, { 195,4382 },
 { 196,4382 }, { 197,4382 }, { 198,4382 }, { 199,4382 }, { 200,4382 },
 { 201,4382 }, { 202,4382 }, { 203,4382 }, { 204,4382 }, { 205,4382 },
 { 206,4382 }, { 207,4382 }, { 208,4382 }, { 209,4382 }, { 210,4382 },
 { 211,4382 }, { 212,4382 }, { 213,4382 }, { 214,4382 }, { 215,4382 },
 { 216,4382 }, { 217,4382 }, { 218,4382 }, { 219,4382 }, { 220,4382 },
 { 221,4382 }, { 222,4382 }, { 223,4382 }, { 224,4382 }, { 225,4382 },
 { 226,4382 }, { 227,4382 }, { 228,4382 }, { 229,4382 }, { 230,4382 },
 { 231,4382 }, { 232,4382 }, { 233,4382 }, { 234,4382 }, { 235,4382 },

 { 236,4382 }, { 237,4382 }, { 238,4382 }, { 239,4382 }, { 240,4382 },
 { 241,4382 }, { 242,4382 }, { 243,4382 }, { 244,4382 }, { 245,4382 },
 { 246,4382 }, { 247,4382 }, { 248,4382 }, { 249,4382 }, { 250,4382 },
 { 251,4382 }, { 252,4382 }, { 253,4382 }, { 254,4382 }, { 255,4382 },
 { 256,4382 }, {   0,  38 }, {   0,9776 }, {   0,   1 }, {   0,9774 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 },
 {   0,   0 }, {  12,   0 }, {  13,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  32,   0 }, {   0,   0 }, {  36,-5116 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,4382 }, {  66,4382 }, {  67,4382 },
 {  68,4382 }, {  69,4382 }, {  70,4382 }, {  71,4382 }, {  72,4382 },
 {  73,4382 }, {  74,4382 }, {  75,4382 }, {  76,4382 }, {  77,4382 },

 {  78,4382 }, {  79,4382 }, {  80,4382 }, {  81,4382 }, {  82,4382 },
 {  83,4382 }, {  84,4382 }, {  85,4382 }, {  86,4382 }, {  87,4382 },
 {  88,4382 }, {  89,4382 }, {  90,4382 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,4382 }, {   0,   0 }, {  97,4382 },
 {  98,4382 }, {  99,4382 }, { 100,4382 }, { 101,4382 }, { 102,4382 },
 { 103,4382 }, { 104,4382 }, { 105,4382 }, { 106,4382 }, { 107,4382 },
 { 108,4382 }, { 109,4382 }, { 110,4382 }, { 111,4382 }, { 112,4382 },
 { 113,4382 }, { 114,4382 }, { 115,4382 }, { 116,4382 }, { 117,4382 },
 { 118,4382 }, { 119,4382 }, { 120,4382 }, { 121,4382 }, { 122,4382 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 { 128,4382 }, { 129,4382 }, { 130,4382 }, { 131,4382 }, { 132,4382 },
 { 133,4382 }, { 134,4382 }, { 135,4382 }, { 136,4382 }, { 137,4382 },
 { 138,4382 }, { 139,4382 }, { 140,4382 }, { 141,4382 }, { 142,4382 },
 { 143,4382 }, { 144,4382 }, { 145,4382 }, { 146,4382 }, { 147,4382 },
 { 148,4382 }, { 149,4382 }, { 150,4382 }, { 151,4382 }, { 152,4382 },
 { 153,4382 }, { 154,4382 }, { 155,4382 }, { 156,4382 }, { 157,4382 },
 { 158,4382 }, { 159,4382 }, { 160,4382 }, { 161,4382 }, { 162,4382 },
 { 163,4382 }, { 164,4382 }, { 165,4382 }, { 166,4382 }, { 167,4382 },
 { 168,4382 }, { 169,4382 }, { 170,4382 }, { 171,4382 }, { 172,4382 },
 { 173,4382 }, { 174,4382 }, { 175,4382 }, { 176,4382 }, { 177,4382 },

 { 178,4382 }, { 179,4382 }, { 180,4382 }, { 181,4382 }, { 182,4382 },
 { 183,4382 }, { 184,4382 }, { 185,4382 }, { 186,4382 }, { 187,4382 },
 { 188,4382 }, { 189,4382 }, { 190,4382 }, { 191,4382 }, { 192,4382 },
 { 193,4382 }, { 194,4382 }, { 195,4382 }, { 196,4382 }, { 197,4382 },
 { 198,4382 }, { 199,4382 }, { 200,4382 }, { 201,4382 }, { 202,4382 },
 { 203,4382 }, { 204,4382 }, { 205,4382 }, { 206,4382 }, { 207,4382 },
 { 208,4382 }, { 209,4382 }, { 210,4382 }, { 211,4382 }, { 212,4382 },
 { 213,4382 }, { 214,4382 }, { 215,4382 }, { 216,4382 }, { 217,4382 },
 { 218,4382 }, { 219,4382 }, { 220,4382 }, { 221,4382 }, { 222,4382 },
 { 223,4382 }, { 224,4382 }, { 225,4382 }, { 226,4382 }, { 227,4382 },

 { 228,4382 }, { 229,4382 }, { 230,4382 }, { 231,4382 }, { 232,4382 },
 { 233,4382 }, { 234,4382 }, { 235,4382 }, { 236,4382 }, { 237,4382 },
 { 238,4382 }, { 239,4382 }, { 240,4382 }, { 241,4382 }, { 242,4382 },
 { 243,4382 }, { 244,4382 }, { 245,4382 }, { 246,4382 }, { 247,4382 },
 { 248,4382 }, { 249,4382 }, { 250,4382 }, { 251,4382 }, { 252,4382 },
 { 253,4382 }, { 254,4382 }, { 255,4382 }, {   0,  55 }, {   0,9519 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  53 },
 {   0,9508 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  56 }, {   0,9491 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  33,   0 }, {   0,   0 }, {  35,   0 },
 {   0,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,   0 }, {  43,   0 }, {  33, -11 }, {  45,   0 },
 {  35, -11 }, {  47,   0 }, {  37, -11 }, {  38, -11 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42, -11 }, {  43, -11 }, {   0,   0 },
 {  45, -11 }, {   0,   0 }, {  47, -11 }, {   0,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  60, -11 }, {  61, -11 }, {  62, -11 }, {  63, -11 }, {  64, -11 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  34 },
 {   0,9428 }, {   0,   0 }, {   0,   0 }, {  94,   0 }, {   0,   0 },
 {  96,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94, -11 },
 {   0,   0 }, {  96, -11 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,   0 }, {   0,   0 },
 { 126,   0 }, {  36,-5802 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124, -11 },
 {   0,   0 }, { 126, -11 }, {   0,   0 }, {  48,4373 }, {  49,4373 },
 {  50,4373 }, {  51,4373 }, {  52,4373 }, {  53,4373 }, {  54,4373 },
 {  55,4373 }, {  56,4373 }, {  57,4373 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,4373 }, {  66,4373 }, {  67,4373 }, {  68,4373 }, {  69,4373 },
 {  70,4373 }, {  71,4373 }, {  72,4373 }, {  73,4373 }, {  74,4373 },
 {  75,4373 }, {  76,4373 }, {  77,4373 }, {  78,4373 }, {  79,4373 },

 {  80,4373 }, {  81,4373 }, {  82,4373 }, {  83,4373 }, {  84,4373 },
 {  85,4373 }, {  86,4373 }, {  87,4373 }, {  88,4373 }, {  89,4373 },
 {  90,4373 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,4373 }, {   0,   0 }, {  97,4373 }, {  98,4373 }, {  99,4373 },
 { 100,4373 }, { 101,4373 }, { 102,4373 }, { 103,4373 }, { 104,4373 },
 { 105,4373 }, { 106,4373 }, { 107,4373 }, { 108,4373 }, { 109,4373 },
 { 110,4373 }, { 111,4373 }, { 112,4373 }, { 113,4373 }, { 114,4373 },
 { 115,4373 }, { 116,4373 }, { 117,4373 }, { 118,4373 }, { 119,4373 },
 { 120,4373 }, { 121,4373 }, { 122,4373 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,4373 }, { 129,4373 },

 { 130,4373 }, { 131,4373 }, { 132,4373 }, { 133,4373 }, { 134,4373 },
 { 135,4373 }, { 136,4373 }, { 137,4373 }, { 138,4373 }, { 139,4373 },
 { 140,4373 }, { 141,4373 }, { 142,4373 }, { 143,4373 }, { 144,4373 },
 { 145,4373 }, { 146,4373 }, { 147,4373 }, { 148,4373 }, { 149,4373 },
 { 150,4373 }, { 151,4373 }, { 152,4373 }, { 153,4373 }, { 154,4373 },
 { 155,4373 }, { 156,4373 }, { 157,4373 }, { 158,4373 }, { 159,4373 },
 { 160,4373 }, { 161,4373 }, { 162,4373 }, { 163,4373 }, { 164,4373 },
 { 165,4373 }, { 166,4373 }, { 167,4373 }, { 168,4373 }, { 169,4373 },
 { 170,4373 }, { 171,4373 }, { 172,4373 }, { 173,4373 }, { 174,4373 },
 { 175,4373 }, { 176,4373 }, { 177,4373 }, { 178,4373 }, { 179,4373 },

 { 180,4373 }, { 181,4373 }, { 182,4373 }, { 183,4373 }, { 184,4373 },
 { 185,4373 }, { 186,4373 }, { 187,4373 }, { 188,4373 }, { 189,4373 },
 { 190,4373 }, { 191,4373 }, { 192,4373 }, { 193,4373 }, { 194,4373 },
 { 195,4373 }, { 196,4373 }, { 197,4373 }, { 198,4373 }, { 199,4373 },
 { 200,4373 }, { 201,4373 }, { 202,4373 }, { 203,4373 }, { 204,4373 },
 { 205,4373 }, { 206,4373 }, { 207,4373 }, { 208,4373 }, { 209,4373 },
 { 210,4373 }, { 211,4373 }, { 212,4373 }, { 213,4373 }, { 214,4373 },
 { 215,4373 }, { 216,4373 }, { 217,4373 }, { 218,4373 }, { 219,4373 },
 { 220,4373 }, { 221,4373 }, { 222,4373 }, { 223,4373 }, { 224,4373 },
 { 225,4373 }, { 226,4373 }, { 227,4373 }, { 228,4373 }, { 229,4373 },

 { 230,4373 }, { 231,4373 }, { 232,4373 }, { 233,4373 }, { 234,4373 },
 { 235,4373 }, { 236,4373 }, { 237,4373 }, { 238,4373 }, { 239,4373 },
 { 240,4373 }, { 241,4373 }, { 242,4373 }, { 243,4373 }, { 244,4373 },
 { 245,4373 }, { 246,4373 }, { 247,4373 }, { 248,4373 }, { 249,4373 },
 { 250,4373 }, { 251,4373 }, { 252,4373 }, { 253,4373 }, { 254,4373 },
 { 255,4373 }, {   0,   2 }, {   0,9171 }, {   1,4373 }, {   2,4373 },
 {   3,4373 }, {   4,4373 }, {   5,4373 }, {   6,4373 }, {   7,4373 },
 {   8,4373 }, {   9,4373 }, {   0,   0 }, {  11,4373 }, {  12,4373 },
 {   0,   0 }, {  14,4373 }, {  15,4373 }, {  16,4373 }, {  17,4373 },
 {  18,4373 }, {  19,4373 }, {  20,4373 }, {  21,4373 }, {  22,4373 },

 {  23,4373 }, {  24,4373 }, {  25,4373 }, {  26,4373 }, {  27,4373 },
 {  28,4373 }, {  29,4373 }, {  30,4373 }, {  31,4373 }, {  32,4373 },
 {  33,4631 }, {  34,4373 }, {  35,4631 }, {  36,4373 }, {  37,4631 },
 {  38,4631 }, {  39,4373 }, {  40,4373 }, {  41,4373 }, {  42,4631 },
 {  43,4631 }, {  44,4373 }, {  45,4631 }, {  46,4373 }, {  47,4631 },
 {  48,4373 }, {  49,4373 }, {  50,4373 }, {  51,4373 }, {  52,4373 },
 {  53,4373 }, {  54,4373 }, {  55,4373 }, {  56,4373 }, {  57,4373 },
 {  58,4373 }, {  59,4373 }, {  60,4631 }, {  61,4631 }, {  62,4631 },
 {  63,4631 }, {  64,4631 }, {  65,4373 }, {  66,4373 }, {  67,4373 },
 {  68,4373 }, {  69,4373 }, {  70,4373 }, {  71,4373 }, {  72,4373 },

 {  73,4373 }, {  74,4373 }, {  75,4373 }, {  76,4373 }, {  77,4373 },
 {  78,4373 }, {  79,4373 }, {  80,4373 }, {  81,4373 }, {  82,4373 },
 {  83,4373 }, {  84,4373 }, {  85,4373 }, {  86,4373 }, {  87,4373 },
 {  88,4373 }, {  89,4373 }, {  90,4373 }, {  91,4373 }, {  92,4373 },
 {  93,4373 }, {  94,4631 }, {  95,4373 }, {  96,4631 }, {  97,4373 },
 {  98,4373 }, {  99,4373 }, { 100,4373 }, { 101,4373 }, { 102,4373 },
 { 103,4373 }, { 104,4373 }, { 105,4373 }, { 106,4373 }, { 107,4373 },
 { 108,4373 }, { 109,4373 }, { 110,4373 }, { 111,4373 }, { 112,4373 },
 { 113,4373 }, { 114,4373 }, { 115,4373 }, { 116,4373 }, { 117,4373 },
 { 118,4373 }, { 119,4373 }, { 120,4373 }, { 121,4373 }, { 122,4373 },

 { 123,4373 }, { 124,4631 }, { 125,4373 }, { 126,4631 }, { 127,4373 },
 { 128,4373 }, { 129,4373 }, { 130,4373 }, { 131,4373 }, { 132,4373 },
 { 133,4373 }, { 134,4373 }, { 135,4373 }, { 136,4373 }, { 137,4373 },
 { 138,4373 }, { 139,4373 }, { 140,4373 }, { 141,4373 }, { 142,4373 },
 { 143,4373 }, { 144,4373 }, { 145,4373 }, { 146,4373 }, { 147,4373 },
 { 148,4373 }, { 149,4373 }, { 150,4373 }, { 151,4373 }, { 152,4373 },
 { 153,4373 }, { 154,4373 }, { 155,4373 }, { 156,4373 }, { 157,4373 },
 { 158,4373 }, { 159,4373 }, { 160,4373 }, { 161,4373 }, { 162,4373 },
 { 163,4373 }, { 164,4373 }, { 165,4373 }, { 166,4373 }, { 167,4373 },
 { 168,4373 }, { 169,4373 }, { 170,4373 }, { 171,4373 }, { 172,4373 },

 { 173,4373 }, { 174,4373 }, { 175,4373 }, { 176,4373 }, { 177,4373 },
 { 178,4373 }, { 179,4373 }, { 180,4373 }, { 181,4373 }, { 182,4373 },
 { 183,4373 }, { 184,4373 }, { 185,4373 }, { 186,4373 }, { 187,4373 },
 { 188,4373 }, { 189,4373 }, { 190,4373 }, { 191,4373 }, { 192,4373 },
 { 193,4373 }, { 194,4373 }, { 195,4373 }, { 196,4373 }, { 197,4373 },
 { 198,4373 }, { 199,4373 }, { 200,4373 }, { 201,4373 }, { 202,4373 },
 { 203,4373 }, { 204,4373 }, { 205,4373 }, { 206,4373 }, { 207,4373 },
 { 208,4373 }, { 209,4373 }, { 210,4373 }, { 211,4373 }, { 212,4373 },
 { 213,4373 }, { 214,4373 }, { 215,4373 }, { 216,4373 }, { 217,4373 },
 { 218,4373 }, { 219,4373 }, { 220,4373 }, { 221,4373 }, { 222,4373 },

 { 223,4373 }, { 224,4373 }, { 225,4373 }, { 226,4373 }, { 227,4373 },
 { 228,4373 }, { 229,4373 }, { 230,4373 }, { 231,4373 }, { 232,4373 },
 { 233,4373 }, { 234,4373 }, { 235,4373 }, { 236,4373 }, { 237,4373 },
 { 238,4373 }, { 239,4373 }, { 240,4373 }, { 241,4373 }, { 242,4373 },
 { 243,4373 }, { 244,4373 }, { 245,4373 }, { 246,4373 }, { 247,4373 },
 { 248,4373 }, { 249,4373 }, { 250,4373 }, { 251,4373 }, { 252,4373 },
 { 253,4373 }, { 254,4373 }, { 255,4373 }, { 256,4373 }, {   0,  64 },
 {   0,8913 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,4631 }, {  49,4631 },
 {  50,4631 }, {  51,4631 }, {  52,4631 }, {  53,4631 }, {  54,4631 },
 {  55,4631 }, {  56,4631 }, {  57,4631 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  65,-5977 }, {  66,-5977 }, {  67,-5977 }, {  68,-5977 }, {  69,4888 },
 {  70,-5977 }, {  71,-5977 }, {  72,-5977 }, {  73,-5977 }, {  74,-5977 },
 {  75,-5977 }, {  76,-5977 }, {  77,-5977 }, {  78,-5977 }, {  79,-5977 },
 {  80,-5977 }, {  81,-5977 }, {  82,-5977 }, {  83,-5977 }, {  84,-5977 },
 {  85,-5977 }, {  86,-5977 }, {  87,-5977 }, {  88,-5977 }, {  89,-5977 },
 {  90,-5977 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,4898 }, {   0,   0 }, {  97,-5977 }, {  98,-5977 }, {  99,-5977 },
 { 100,-5977 }, { 101,4888 }, { 102,-5977 }, { 103,-5977 }, { 104,-5977 },
 { 105,-5977 }, { 106,-5977 }, { 107,-5977 }, { 108,-5977 }, { 109,-5977 },
 { 110,-5977 }, { 111,-5977 }, { 112,-5977 }, { 113,-5977 }, { 114,-5977 },

 { 115,-5977 }, { 116,-5977 }, { 117,-5977 }, { 118,-5977 }, { 119,-5977 },
 { 120,-5977 }, { 121,-5977 }, { 122,-5977 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-5977 }, { 129,-5977 },
 { 130,-5977 }, { 131,-5977 }, { 132,-5977 }, { 133,-5977 }, { 134,-5977 },
 { 135,-5977 }, { 136,-5977 }, { 137,-5977 }, { 138,-5977 }, { 139,-5977 },
 { 140,-5977 }, { 141,-5977 }, { 142,-5977 }, { 143,-5977 }, { 144,-5977 },
 { 145,-5977 }, { 146,-5977 }, { 147,-5977 }, { 148,-5977 }, { 149,-5977 },
 { 150,-5977 }, { 151,-5977 }, { 152,-5977 }, { 153,-5977 }, { 154,-5977 },
 { 155,-5977 }, { 156,-5977 }, { 157,-5977 }, { 158,-5977 }, { 159,-5977 },
 { 160,-5977 }, { 161,-5977 }, { 162,-5977 }, { 163,-5977 }, { 164,-5977 },

 { 165,-5977 }, { 166,-5977 }, { 167,-5977 }, { 168,-5977 }, { 169,-5977 },
 { 170,-5977 }, { 171,-5977 }, { 172,-5977 }, { 173,-5977 }, { 174,-5977 },
 { 175,-5977 }, { 176,-5977 }, { 177,-5977 }, { 178,-5977 }, { 179,-5977 },
 { 180,-5977 }, { 181,-5977 }, { 182,-5977 }, { 183,-5977 }, { 184,-5977 },
 { 185,-5977 }, { 186,-5977 }, { 187,-5977 }, { 188,-5977 }, { 189,-5977 },
 { 190,-5977 }, { 191,-5977 }, { 192,-5977 }, { 193,-5977 }, { 194,-5977 },
 { 195,-5977 }, { 196,-5977 }, { 197,-5977 }, { 198,-5977 }, { 199,-5977 },
 { 200,-5977 }, { 201,-5977 }, { 202,-5977 }, { 203,-5977 }, { 204,-5977 },
 { 205,-5977 }, { 206,-5977 }, { 207,-5977 }, { 208,-5977 }, { 209,-5977 },
 { 210,-5977 }, { 211,-5977 }, { 212,-5977 }, { 213,-5977 }, { 214,-5977 },

 { 215,-5977 }, { 216,-5977 }, { 217,-5977 }, { 218,-5977 }, { 219,-5977 },
 { 220,-5977 }, { 221,-5977 }, { 222,-5977 }, { 223,-5977 }, { 224,-5977 },
 { 225,-5977 }, { 226,-5977 }, { 227,-5977 }, { 228,-5977 }, { 229,-5977 },
 { 230,-5977 }, { 231,-5977 }, { 232,-5977 }, { 233,-5977 }, { 234,-5977 },
 { 235,-5977 }, { 236,-5977 }, { 237,-5977 }, { 238,-5977 }, { 239,-5977 },
 { 240,-5977 }, { 241,-5977 }, { 242,-5977 }, { 243,-5977 }, { 244,-5977 },
 { 245,-5977 }, { 246,-5977 }, { 247,-5977 }, { 248,-5977 }, { 249,-5977 },
 { 250,-5977 }, { 251,-5977 }, { 252,-5977 }, { 253,-5977 }, { 254,-5977 },
 { 255,-5977 }, {   0,   3 }, {   0,8656 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  64 }, {   0,8624 },
 {  33,4666 }, {   0,   0 }, {  35,4666 }, {   0,   0 }, {  37,4666 },
 {  38,4666 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,4666 },
 {  43,4666 }, {   0,   0 }, {  45,4666 }, {   0,   0 }, {  47,4666 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  60,4666 }, {  61,4666 }, {  62,4666 },
 {  63,4666 }, {  64,4666 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  46,-6264 }, {   0,   0 }, {  48,4700 }, {  49,4700 }, {  50,4700 },
 {  51,4700 }, {  52,4700 }, {  53,4700 }, {  54,4700 }, {  55,4700 },
 {  56,4700 }, {  57,4700 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,4666 }, {   0,   0 }, {  96,4666 }, {  65,-6266 },
 {  66,-6266 }, {  67,-6266 }, {  68,-6266 }, {  69,4599 }, {  70,-6266 },
 {  71,-6266 }, {  72,-6266 }, {  73,-6266 }, {  74,-6266 }, {  75,-6266 },

 {  76,-6266 }, {  77,-6266 }, {  78,-6266 }, {  79,-6266 }, {  80,-6266 },
 {  81,-6266 }, {  82,-6266 }, {  83,-6266 }, {  84,-6266 }, {  85,-6266 },
 {  86,-6266 }, {  87,-6266 }, {  88,-6266 }, {  89,-6266 }, {  90,-6266 },
 {   0,   0 }, { 124,4666 }, {   0,   0 }, { 126,4666 }, {  95,-6266 },
 {   0,   0 }, {  97,-6266 }, {  98,-6266 }, {  99,-6266 }, { 100,-6266 },
 { 101,4599 }, { 102,-6266 }, { 103,-6266 }, { 104,-6266 }, { 105,-6266 },
 { 106,-6266 }, { 107,-6266 }, { 108,-6266 }, { 109,-6266 }, { 110,-6266 },
 { 111,-6266 }, { 112,-6266 }, { 113,-6266 }, { 114,-6266 }, { 115,-6266 },
 { 116,-6266 }, { 117,-6266 }, { 118,-6266 }, { 119,-6266 }, { 120,-6266 },
 { 121,-6266 }, { 122,-6266 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 128,-6266 }, { 129,-6266 }, { 130,-6266 },
 { 131,-6266 }, { 132,-6266 }, { 133,-6266 }, { 134,-6266 }, { 135,-6266 },
 { 136,-6266 }, { 137,-6266 }, { 138,-6266 }, { 139,-6266 }, { 140,-6266 },
 { 141,-6266 }, { 142,-6266 }, { 143,-6266 }, { 144,-6266 }, { 145,-6266 },
 { 146,-6266 }, { 147,-6266 }, { 148,-6266 }, { 149,-6266 }, { 150,-6266 },
 { 151,-6266 }, { 152,-6266 }, { 153,-6266 }, { 154,-6266 }, { 155,-6266 },
 { 156,-6266 }, { 157,-6266 }, { 158,-6266 }, { 159,-6266 }, { 160,-6266 },
 { 161,-6266 }, { 162,-6266 }, { 163,-6266 }, { 164,-6266 }, { 165,-6266 },
 { 166,-6266 }, { 167,-6266 }, { 168,-6266 }, { 169,-6266 }, { 170,-6266 },
 { 171,-6266 }, { 172,-6266 }, { 173,-6266 }, { 174,-6266 }, { 175,-6266 },

 { 176,-6266 }, { 177,-6266 }, { 178,-6266 }, { 179,-6266 }, { 180,-6266 },
 { 181,-6266 }, { 182,-6266 }, { 183,-6266 }, { 184,-6266 }, { 185,-6266 },
 { 186,-6266 }, { 187,-6266 }, { 188,-6266 }, { 189,-6266 }, { 190,-6266 },
 { 191,-6266 }, { 192,-6266 }, { 193,-6266 }, { 194,-6266 }, { 195,-6266 },
 { 196,-6266 }, { 197,-6266 }, { 198,-6266 }, { 199,-6266 }, { 200,-6266 },
 { 201,-6266 }, { 202,-6266 }, { 203,-6266 }, { 204,-6266 }, { 205,-6266 },
 { 206,-6266 }, { 207,-6266 }, { 208,-6266 }, { 209,-6266 }, { 210,-6266 },
 { 211,-6266 }, { 212,-6266 }, { 213,-6266 }, { 214,-6266 }, { 215,-6266 },
 { 216,-6266 }, { 217,-6266 }, { 218,-6266 }, { 219,-6266 }, { 220,-6266 },
 { 221,-6266 }, { 222,-6266 }, { 223,-6266 }, { 224,-6266 }, { 225,-6266 },

 { 226,-6266 }, { 227,-6266 }, { 228,-6266 }, { 229,-6266 }, { 230,-6266 },
 { 231,-6266 }, { 232,-6266 }, { 233,-6266 }, { 234,-6266 }, { 235,-6266 },
 { 236,-6266 }, { 237,-6266 }, { 238,-6266 }, { 239,-6266 }, { 240,-6266 },
 { 241,-6266 }, { 242,-6266 }, { 243,-6266 }, { 244,-6266 }, { 245,-6266 },
 { 246,-6266 }, { 247,-6266 }, { 248,-6266 }, { 249,-6266 }, { 250,-6266 },
 { 251,-6266 }, { 252,-6266 }, { 253,-6266 }, { 254,-6266 }, { 255,-6266 },
 {   0,  57 }, {   0,8367 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  46,-257 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-6859 }, {  66,-6859 }, {  67,-6859 }, {  68,-6859 },

 {  69, 257 }, {  70,-6859 }, {  71,-6859 }, {  72,-6859 }, {  73,-6859 },
 {  74,-6859 }, {  75,-6859 }, {  76,-6859 }, {  77,-6859 }, {  78,-6859 },
 {  79,-6859 }, {  80,-6859 }, {  81,-6859 }, {  82,-6859 }, {  83,-6859 },
 {  84,-6859 }, {  85,-6859 }, {  86,-6859 }, {  87,-6859 }, {  88,-6859 },
 {  89,-6859 }, {  90,-6859 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95, 298 }, {   0,   0 }, {  97,-6859 }, {  98,-6859 },
 {  99,-6859 }, { 100,-6859 }, { 101, 257 }, { 102,-6859 }, { 103,-6859 },
 { 104,-6859 }, { 105,-6859 }, { 106,-6859 }, { 107,-6859 }, { 108,-6859 },
 { 109,-6859 }, { 110,-6859 }, { 111,-6859 }, { 112,-6859 }, { 113,-6859 },
 { 114,-6859 }, { 115,-6859 }, { 116,-6859 }, { 117,-6859 }, { 118,-6859 },

 { 119,-6859 }, { 120,-6859 }, { 121,-6859 }, { 122,-6859 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-6859 },
 { 129,-6859 }, { 130,-6859 }, { 131,-6859 }, { 132,-6859 }, { 133,-6859 },
 { 134,-6859 }, { 135,-6859 }, { 136,-6859 }, { 137,-6859 }, { 138,-6859 },
 { 139,-6859 }, { 140,-6859 }, { 141,-6859 }, { 142,-6859 }, { 143,-6859 },
 { 144,-6859 }, { 145,-6859 }, { 146,-6859 }, { 147,-6859 }, { 148,-6859 },
 { 149,-6859 }, { 150,-6859 }, { 151,-6859 }, { 152,-6859 }, { 153,-6859 },
 { 154,-6859 }, { 155,-6859 }, { 156,-6859 }, { 157,-6859 }, { 158,-6859 },
 { 159,-6859 }, { 160,-6859 }, { 161,-6859 }, { 162,-6859 }, { 163,-6859 },
 { 164,-6859 }, { 165,-6859 }, { 166,-6859 }, { 167,-6859 }, { 168,-6859 },

 { 169,-6859 }, { 170,-6859 }, { 171,-6859 }, { 172,-6859 }, { 173,-6859 },
 { 174,-6859 }, { 175,-6859 }, { 176,-6859 }, { 177,-6859 }, { 178,-6859 },
 { 179,-6859 }, { 180,-6859 }, { 181,-6859 }, { 182,-6859 }, { 183,-6859 },
 { 184,-6859 }, { 185,-6859 }, { 186,-6859 }, { 187,-6859 }, { 188,-6859 },
 { 189,-6859 }, { 190,-6859 }, { 191,-6859 }, { 192,-6859 }, { 193,-6859 },
 { 194,-6859 }, { 195,-6859 }, { 196,-6859 }, { 197,-6859 }, { 198,-6859 },
 { 199,-6859 }, { 200,-6859 }, { 201,-6859 }, { 202,-6859 }, { 203,-6859 },
 { 204,-6859 }, { 205,-6859 }, { 206,-6859 }, { 207,-6859 }, { 208,-6859 },
 { 209,-6859 }, { 210,-6859 }, { 211,-6859 }, { 212,-6859 }, { 213,-6859 },
 { 214,-6859 }, { 215,-6859 }, { 216,-6859 }, { 217,-6859 }, { 218,-6859 },

 { 219,-6859 }, { 220,-6859 }, { 221,-6859 }, { 222,-6859 }, { 223,-6859 },
 { 224,-6859 }, { 225,-6859 }, { 226,-6859 }, { 227,-6859 }, { 228,-6859 },
 { 229,-6859 }, { 230,-6859 }, { 231,-6859 }, { 232,-6859 }, { 233,-6859 },
 { 234,-6859 }, { 235,-6859 }, { 236,-6859 }, { 237,-6859 }, { 238,-6859 },
 { 239,-6859 }, { 240,-6859 }, { 241,-6859 }, { 242,-6859 }, { 243,-6859 },
 { 244,-6859 }, { 245,-6859 }, { 246,-6859 }, { 247,-6859 }, { 248,-6859 },
 { 249,-6859 }, { 250,-6859 }, { 251,-6859 }, { 252,-6859 }, { 253,-6859 },
 { 254,-6859 }, { 255,-6859 }, {   0,  68 }, {   0,8110 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  62 }, {   0,8100 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  61 }, {   0,8092 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  68 }, {   0,8069 },
 {   0,   0 }, {  43,4445 }, {   0,   0 }, {  45,4445 }, {   0,   0 },
 {   0,   0 }, {  48,4700 }, {  49,4700 }, {  50,4700 }, {  51,4700 },
 {  52,4700 }, {  53,4700 }, {  54,4700 }, {  55,4700 }, {  56,4700 },
 {  57,4700 }, {  48,4947 }, {  49,4947 }, {  50,4947 }, {  51,4947 },

 {  52,4947 }, {  53,4947 }, {  54,4947 }, {  55,4947 }, {  48,5196 },
 {  49,5196 }, {  50,5196 }, {  51,5196 }, {  52,5196 }, {  53,5196 },
 {  54,5196 }, {  55,5196 }, {  56,5196 }, {  57,5196 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,5196 }, {  66,5196 }, {  67,5196 }, {  68,5196 },
 {  69,5196 }, {  70,5196 }, {  48,5468 }, {  49,5468 }, {  50,5468 },
 {  51,5468 }, {  52,5468 }, {  53,5468 }, {  54,5468 }, {  55,5468 },
 {  56,5468 }, {  57,5468 }, {   0,  50 }, {   0,8010 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,4955 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  52 }, {   0,7999 },

 {   0,   0 }, {  95,5453 }, {   0,   0 }, {  97,5196 }, {  98,5196 },
 {  99,5196 }, { 100,5196 }, { 101,5196 }, { 102,5196 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  33,-1509 }, {   0,   0 }, {  35,-1509 }, {   0,   0 },
 {  37,-1509 }, {  38,-1509 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,-1509 }, {  43,-1509 }, {  33,-1520 }, {  45,-1509 }, {  35,-1520 },
 {  47,-1509 }, {  37,-1520 }, {  38,-1520 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,-1520 }, {  43,-1520 }, {   0,   0 }, {  45,-1520 },
 {   0,   0 }, {  47,-1520 }, {   0,   0 }, {  60,-1509 }, {  61,-1509 },

 {  62,-1509 }, {  63,-1509 }, {  64,-1509 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,-1520 },
 {  61,-1520 }, {  62,-1520 }, {  63,-1520 }, {  64,-1520 }, {   0,   0 },
 {   0,  49 }, {   0,7932 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,-1509 }, {   0,   0 }, {  96,-1509 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-1520 }, {   0,   0 },
 {  96,-1520 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,-1587 },

 {   0,   0 }, {  35,-1587 }, {   0,   0 }, {  37,-1587 }, {  38,-1587 },
 {   0,  51 }, {   0,7892 }, {   0,   0 }, {  42,-1587 }, {  43,-1587 },
 {   0,   0 }, {  45,-1587 }, { 124,-1509 }, {  47,-1587 }, { 126,-1509 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,-1520 }, {   0,   0 },
 { 126,-1520 }, {  60,-1587 }, {  61,-1587 }, {  62,-1587 }, {  63,-1587 },
 {  64,-1587 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,-1627 },
 {   0,   0 }, {  35,-1627 }, {   0,   0 }, {  37,-1627 }, {  38,-1627 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,-1627 }, {  43,-1627 },

 {   0,   0 }, {  45,-1627 }, {   0,   0 }, {  47,-1627 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,-1587 }, {   0,   0 }, {  96,-1587 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  60,-1627 }, {  61,-1627 }, {  62,-1627 }, {  63,-1627 },
 {  64,-1627 }, {   0,  74 }, {   0,7826 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 124,-1587 }, {   0,   0 }, { 126,-1587 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  94,-1627 }, {   0,   0 }, {  96,-1627 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 { 124,-1627 }, {   0,   0 }, { 126,-1627 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },

 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },

 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },

 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  11 }, {   0,7569 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 },
 {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },

 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },

 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },

 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },

 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },

 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,   6 }, {   0,7311 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },

 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 }, {   0,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },

 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },

 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },

 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },

 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,   4 },
 {   0,7053 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,4709 }, {   0,   0 },
 {  35,4709 }, {   0,   0 }, {  37,4709 }, {  38,4709 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,4709 }, {  43,4709 }, {   0,   0 },
 {  45,4709 }, {   0,   0 }, {  47,4709 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,4709 }, {  61,4709 }, {  62,4709 }, {  63,4709 }, {  64,4709 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,4709 },
 {   0,   0 }, {  96,4709 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,4709 },
 {   0,   0 }, { 126,4709 }, {   0,  44 }, {   0,6925 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 },
 {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },

 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {   0,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 },
 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },
 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },

 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },

 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },

 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },

 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,  10 }, {   0,6667 }, {   1,   0 }, {   2,   0 }, {   3,   0 },
 {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 },
 {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 },
 {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 },

 {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 },
 {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 },
 {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 },
 {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 },
 {   0,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 },
 {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 },
 {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },
 {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },

 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 },
 {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },

 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 },
 { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },

 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },

 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  22 }, {   0,6409 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 },

 {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },

 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },

 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },

 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },

 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,  19 }, {   0,6151 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,  19 }, {   0,6146 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   9,   0 }, {  10,   5 }, {   0,   0 }, {  12,   0 },
 {  13,   5 }, {   9,  16 }, {  10,  16 }, {   0,   0 }, {  12,  16 },
 {  13,  16 }, {   0,   0 }, {   0,  19 }, {   0,6130 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 }, {  32,   0 },
 {  12,   0 }, {  13,   0 }, {   0,   0 }, {   0,   0 }, {  32,  16 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,-8768 }, {  45,-8790 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  45,-8795 }, {   0,   0 }, {   0,   0 },

 {  32,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-8784 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-8811 }, {   0,  23 },
 {   0,6083 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },
 {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 },

 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },

 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {   0,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },

 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },

 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },

 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,  30 }, {   0,5825 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  28 }, {   0,5817 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0,5794 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,3483 }, {  49,3483 }, {  50,3483 }, {  51,3483 },
 {  52,3483 }, {  53,3483 }, {  54,3483 }, {  55,3483 }, {  48,3490 },
 {  49,3490 }, {  50,3490 }, {  51,3490 }, {  52,3490 }, {  53,3490 },
 {  54,3490 }, {  55,3490 }, {  56,3490 }, {  57,3490 }, {   0,   0 },
 {   0,   0 }, {   0,  29 }, {   0,5756 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,3490 }, {  66,3490 }, {  67,3490 }, {  68,3490 },

 {  69,3490 }, {  70,3490 }, {  48,3529 }, {  49,3529 }, {  50,3529 },
 {  51,3529 }, {  52,3529 }, {  53,3529 }, {  54,3529 }, {  55,3529 },
 {  56,3529 }, {  57,3529 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3529 },
 {  66,3529 }, {  67,3529 }, {  68,3529 }, {  69,3529 }, {  70,3529 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,3490 }, {  98,3490 },
 {  99,3490 }, { 100,3490 }, { 101,3490 }, { 102,3490 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,3514 }, {  49,3514 }, {  50,3514 }, {  51,3514 }, {  52,3514 },
 {  53,3514 }, {  54,3514 }, {  55,3514 }, {  56,3514 }, {  57,3514 },

 {   0,   0 }, {  97,3529 }, {  98,3529 }, {  99,3529 }, { 100,3529 },
 { 101,3529 }, { 102,3529 }, {  65,3514 }, {  66,3514 }, {  67,3514 },
 {  68,3514 }, {  69,3514 }, {  70,3514 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,3514 },
 {  98,3514 }, {  99,3514 }, { 100,3514 }, { 101,3514 }, { 102,3514 },
 {   0,  36 }, {   0,5652 }, {   1,   0 }, {   2,   0 }, {   3,   0 },

 {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 },
 {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 },
 {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 },
 {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 },
 {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 },
 {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 },
 {  34,   0 }, {  35,   0 }, {   0,   0 }, {  37,   0 }, {  38,   0 },
 {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 },
 {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },

 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 },
 {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },
 {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 },
 {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },

 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 },
 { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },

 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },

 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },

 { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  37 }, {   0,5394 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-9498 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  48,3211 }, {  49,3211 }, {  50,3211 },
 {  51,3211 }, {  52,3211 }, {  53,3211 }, {  54,3211 }, {  55,3211 },
 {  56,3211 }, {  57,3211 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3211 },
 {  66,3211 }, {  67,3211 }, {  68,3211 }, {  69,3211 }, {  70,3211 },
 {  71,3211 }, {  72,3211 }, {  73,3211 }, {  74,3211 }, {  75,3211 },
 {  76,3211 }, {  77,3211 }, {  78,3211 }, {  79,3211 }, {  80,3211 },
 {  81,3211 }, {  82,3211 }, {  83,3211 }, {  84,3211 }, {  85,3211 },
 {  86,3211 }, {  87,3211 }, {  88,3211 }, {  89,3211 }, {  90,3211 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,3211 },

 {   0,   0 }, {  97,3211 }, {  98,3211 }, {  99,3211 }, { 100,3211 },
 { 101,3211 }, { 102,3211 }, { 103,3211 }, { 104,3211 }, { 105,3211 },
 { 106,3211 }, { 107,3211 }, { 108,3211 }, { 109,3211 }, { 110,3211 },
 { 111,3211 }, { 112,3211 }, { 113,3211 }, { 114,3211 }, { 115,3211 },
 { 116,3211 }, { 117,3211 }, { 118,3211 }, { 119,3211 }, { 120,3211 },
 { 121,3211 }, { 122,3211 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,3211 }, { 129,3211 }, { 130,3211 },
 { 131,3211 }, { 132,3211 }, { 133,3211 }, { 134,3211 }, { 135,3211 },
 { 136,3211 }, { 137,3211 }, { 138,3211 }, { 139,3211 }, { 140,3211 },
 { 141,3211 }, { 142,3211 }, { 143,3211 }, { 144,3211 }, { 145,3211 },

 { 146,3211 }, { 147,3211 }, { 148,3211 }, { 149,3211 }, { 150,3211 },
 { 151,3211 }, { 152,3211 }, { 153,3211 }, { 154,3211 }, { 155,3211 },
 { 156,3211 }, { 157,3211 }, { 158,3211 }, { 159,3211 }, { 160,3211 },
 { 161,3211 }, { 162,3211 }, { 163,3211 }, { 164,3211 }, { 165,3211 },
 { 166,3211 }, { 167,3211 }, { 168,3211 }, { 169,3211 }, { 170,3211 },
 { 171,3211 }, { 172,3211 }, { 173,3211 }, { 174,3211 }, { 175,3211 },
 { 176,3211 }, { 177,3211 }, { 178,3211 }, { 179,3211 }, { 180,3211 },
 { 181,3211 }, { 182,3211 }, { 183,3211 }, { 184,3211 }, { 185,3211 },
 { 186,3211 }, { 187,3211 }, { 188,3211 }, { 189,3211 }, { 190,3211 },
 { 191,3211 }, { 192,3211 }, { 193,3211 }, { 194,3211 }, { 195,3211 },

 { 196,3211 }, { 197,3211 }, { 198,3211 }, { 199,3211 }, { 200,3211 },
 { 201,3211 }, { 202,3211 }, { 203,3211 }, { 204,3211 }, { 205,3211 },
 { 206,3211 }, { 207,3211 }, { 208,3211 }, { 209,3211 }, { 210,3211 },
 { 211,3211 }, { 212,3211 }, { 213,3211 }, { 214,3211 }, { 215,3211 },
 { 216,3211 }, { 217,3211 }, { 218,3211 }, { 219,3211 }, { 220,3211 },
 { 221,3211 }, { 222,3211 }, { 223,3211 }, { 224,3211 }, { 225,3211 },
 { 226,3211 }, { 227,3211 }, { 228,3211 }, { 229,3211 }, { 230,3211 },
 { 231,3211 }, { 232,3211 }, { 233,3211 }, { 234,3211 }, { 235,3211 },
 { 236,3211 }, { 237,3211 }, { 238,3211 }, { 239,3211 }, { 240,3211 },
 { 241,3211 }, { 242,3211 }, { 243,3211 }, { 244,3211 }, { 245,3211 },

 { 246,3211 }, { 247,3211 }, { 248,3211 }, { 249,3211 }, { 250,3211 },
 { 251,3211 }, { 252,3211 }, { 253,3211 }, { 254,3211 }, { 255,3211 },
 {   0,  28 }, {   0,5137 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0,5114 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,3211 },
 {  49,3211 }, {  50,3211 }, {  51,3211 }, {  52,3211 }, {  53,3211 },
 {  54,3211 }, {  55,3211 }, {  56,3211 }, {  57,3211 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,3211 }, {  66,3211 }, {  67,3211 }, {  68,3211 },
 {  69,3211 }, {  70,3211 }, {  48,3211 }, {  49,3211 }, {  50,3211 },
 {  51,3211 }, {  52,3211 }, {  53,3211 }, {  54,3211 }, {  55,3211 },
 {  56,3211 }, {  57,3211 }, {   0,  34 }, {   0,5055 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3211 },

 {  66,3211 }, {  67,3211 }, {  68,3211 }, {  69,3211 }, {  70,3211 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,3211 }, {  98,3211 },
 {  99,3211 }, { 100,3211 }, { 101,3211 }, { 102,3211 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-10175 },
 {   0,   0 }, {  97,3211 }, {  98,3211 }, {  99,3211 }, { 100,3211 },
 { 101,3211 }, { 102,3211 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },

 {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },

 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },

 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },

 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,   2 },

 {   0,4798 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },
 {   0,   0 }, {  11,   0 }, {  12,   0 }, {   0,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },

 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },

 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },

 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },

 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },

 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,   2 }, {   0,4540 }, {   1,-258 },
 {   2,-258 }, {   3,-258 }, {   4,-258 }, {   5,-258 }, {   6,-258 },
 {   7,-258 }, {   8,-258 }, {   9,-258 }, {   0,   0 }, {  11,-258 },
 {  12,-258 }, {   0,   0 }, {  14,-258 }, {  15,-258 }, {  16,-258 },
 {  17,-258 }, {  18,-258 }, {  19,-258 }, {  20,-258 }, {  21,-258 },
 {  22,-258 }, {  23,-258 }, {  24,-258 }, {  25,-258 }, {  26,-258 },
 {  27,-258 }, {  28,-258 }, {  29,-258 }, {  30,-258 }, {  31,-258 },
 {  32,-258 }, {  33,   0 }, {  34,-258 }, {  35,   0 }, {  36,-258 },
 {  37,   0 }, {  38,   0 }, {  39,-258 }, {  40,-258 }, {  41,-258 },

 {  42,   0 }, {  43,   0 }, {  44,-258 }, {  45,   0 }, {  46,-258 },
 {  47,   0 }, {  48,-258 }, {  49,-258 }, {  50,-258 }, {  51,-258 },
 {  52,-258 }, {  53,-258 }, {  54,-258 }, {  55,-258 }, {  56,-258 },
 {  57,-258 }, {  58,-258 }, {  59,-258 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,-258 }, {  66,-258 },
 {  67,-258 }, {  68,-258 }, {  69,-258 }, {  70,-258 }, {  71,-258 },
 {  72,-258 }, {  73,-258 }, {  74,-258 }, {  75,-258 }, {  76,-258 },
 {  77,-258 }, {  78,-258 }, {  79,-258 }, {  80,-258 }, {  81,-258 },
 {  82,-258 }, {  83,-258 }, {  84,-258 }, {  85,-258 }, {  86,-258 },
 {  87,-258 }, {  88,-258 }, {  89,-258 }, {  90,-258 }, {  91,-258 },

 {  92,-258 }, {  93,-258 }, {  94,   0 }, {  95,-258 }, {  96,   0 },
 {  97,-258 }, {  98,-258 }, {  99,-258 }, { 100,-258 }, { 101,-258 },
 { 102,-258 }, { 103,-258 }, { 104,-258 }, { 105,-258 }, { 106,-258 },
 { 107,-258 }, { 108,-258 }, { 109,-258 }, { 110,-258 }, { 111,-258 },
 { 112,-258 }, { 113,-258 }, { 114,-258 }, { 115,-258 }, { 116,-258 },
 { 117,-258 }, { 118,-258 }, { 119,-258 }, { 120,-258 }, { 121,-258 },
 { 122,-258 }, { 123,-258 }, { 124,   0 }, { 125,-258 }, { 126,   0 },
 { 127,-258 }, { 128,-258 }, { 129,-258 }, { 130,-258 }, { 131,-258 },
 { 132,-258 }, { 133,-258 }, { 134,-258 }, { 135,-258 }, { 136,-258 },
 { 137,-258 }, { 138,-258 }, { 139,-258 }, { 140,-258 }, { 141,-258 },

 { 142,-258 }, { 143,-258 }, { 144,-258 }, { 145,-258 }, { 146,-258 },
 { 147,-258 }, { 148,-258 }, { 149,-258 }, { 150,-258 }, { 151,-258 },
 { 152,-258 }, { 153,-258 }, { 154,-258 }, { 155,-258 }, { 156,-258 },
 { 157,-258 }, { 158,-258 }, { 159,-258 }, { 160,-258 }, { 161,-258 },
 { 162,-258 }, { 163,-258 }, { 164,-258 }, { 165,-258 }, { 166,-258 },
 { 167,-258 }, { 168,-258 }, { 169,-258 }, { 170,-258 }, { 171,-258 },
 { 172,-258 }, { 173,-258 }, { 174,-258 }, { 175,-258 }, { 176,-258 },
 { 177,-258 }, { 178,-258 }, { 179,-258 }, { 180,-258 }, { 181,-258 },
 { 182,-258 }, { 183,-258 }, { 184,-258 }, { 185,-258 }, { 186,-258 },
 { 187,-258 }, { 188,-258 }, { 189,-258 }, { 190,-258 }, { 191,-258 },

 { 192,-258 }, { 193,-258 }, { 194,-258 }, { 195,-258 }, { 196,-258 },
 { 197,-258 }, { 198,-258 }, { 199,-258 }, { 200,-258 }, { 201,-258 },
 { 202,-258 }, { 203,-258 }, { 204,-258 }, { 205,-258 }, { 206,-258 },
 { 207,-258 }, { 208,-258 }, { 209,-258 }, { 210,-258 }, { 211,-258 },
 { 212,-258 }, { 213,-258 }, { 214,-258 }, { 215,-258 }, { 216,-258 },
 { 217,-258 }, { 218,-258 }, { 219,-258 }, { 220,-258 }, { 221,-258 },
 { 222,-258 }, { 223,-258 }, { 224,-258 }, { 225,-258 }, { 226,-258 },
 { 227,-258 }, { 228,-258 }, { 229,-258 }, { 230,-258 }, { 231,-258 },
 { 232,-258 }, { 233,-258 }, { 234,-258 }, { 235,-258 }, { 236,-258 },
 { 237,-258 }, { 238,-258 }, { 239,-258 }, { 240,-258 }, { 241,-258 },

 { 242,-258 }, { 243,-258 }, { 244,-258 }, { 245,-258 }, { 246,-258 },
 { 247,-258 }, { 248,-258 }, { 249,-258 }, { 250,-258 }, { 251,-258 },
 { 252,-258 }, { 253,-258 }, { 254,-258 }, { 255,-258 }, { 256,-258 },
 {   0,  64 }, {   0,4282 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-10608 }, {  66,-10608 }, {  67,-10608 }, {  68,-10608 },
 {  69, 257 }, {  70,-10608 }, {  71,-10608 }, {  72,-10608 }, {  73,-10608 },
 {  74,-10608 }, {  75,-10608 }, {  76,-10608 }, {  77,-10608 }, {  78,-10608 },
 {  79,-10608 }, {  80,-10608 }, {  81,-10608 }, {  82,-10608 }, {  83,-10608 },

 {  84,-10608 }, {  85,-10608 }, {  86,-10608 }, {  87,-10608 }, {  88,-10608 },
 {  89,-10608 }, {  90,-10608 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95, 267 }, {   0,   0 }, {  97,-10608 }, {  98,-10608 },
 {  99,-10608 }, { 100,-10608 }, { 101, 257 }, { 102,-10608 }, { 103,-10608 },
 { 104,-10608 }, { 105,-10608 }, { 106,-10608 }, { 107,-10608 }, { 108,-10608 },
 { 109,-10608 }, { 110,-10608 }, { 111,-10608 }, { 112,-10608 }, { 113,-10608 },
 { 114,-10608 }, { 115,-10608 }, { 116,-10608 }, { 117,-10608 }, { 118,-10608 },
 { 119,-10608 }, { 120,-10608 }, { 121,-10608 }, { 122,-10608 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-10608 },
 { 129,-10608 }, { 130,-10608 }, { 131,-10608 }, { 132,-10608 }, { 133,-10608 },

 { 134,-10608 }, { 135,-10608 }, { 136,-10608 }, { 137,-10608 }, { 138,-10608 },
 { 139,-10608 }, { 140,-10608 }, { 141,-10608 }, { 142,-10608 }, { 143,-10608 },
 { 144,-10608 }, { 145,-10608 }, { 146,-10608 }, { 147,-10608 }, { 148,-10608 },
 { 149,-10608 }, { 150,-10608 }, { 151,-10608 }, { 152,-10608 }, { 153,-10608 },
 { 154,-10608 }, { 155,-10608 }, { 156,-10608 }, { 157,-10608 }, { 158,-10608 },
 { 159,-10608 }, { 160,-10608 }, { 161,-10608 }, { 162,-10608 }, { 163,-10608 },
 { 164,-10608 }, { 165,-10608 }, { 166,-10608 }, { 167,-10608 }, { 168,-10608 },
 { 169,-10608 }, { 170,-10608 }, { 171,-10608 }, { 172,-10608 }, { 173,-10608 },
 { 174,-10608 }, { 175,-10608 }, { 176,-10608 }, { 177,-10608 }, { 178,-10608 },
 { 179,-10608 }, { 180,-10608 }, { 181,-10608 }, { 182,-10608 }, { 183,-10608 },

 { 184,-10608 }, { 185,-10608 }, { 186,-10608 }, { 187,-10608 }, { 188,-10608 },
 { 189,-10608 }, { 190,-10608 }, { 191,-10608 }, { 192,-10608 }, { 193,-10608 },
 { 194,-10608 }, { 195,-10608 }, { 196,-10608 }, { 197,-10608 }, { 198,-10608 },
 { 199,-10608 }, { 200,-10608 }, { 201,-10608 }, { 202,-10608 }, { 203,-10608 },
 { 204,-10608 }, { 205,-10608 }, { 206,-10608 }, { 207,-10608 }, { 208,-10608 },
 { 209,-10608 }, { 210,-10608 }, { 211,-10608 }, { 212,-10608 }, { 213,-10608 },
 { 214,-10608 }, { 215,-10608 }, { 216,-10608 }, { 217,-10608 }, { 218,-10608 },
 { 219,-10608 }, { 220,-10608 }, { 221,-10608 }, { 222,-10608 }, { 223,-10608 },
 { 224,-10608 }, { 225,-10608 }, { 226,-10608 }, { 227,-10608 }, { 228,-10608 },
 { 229,-10608 }, { 230,-10608 }, { 231,-10608 }, { 232,-10608 }, { 233,-10608 },

 { 234,-10608 }, { 235,-10608 }, { 236,-10608 }, { 237,-10608 }, { 238,-10608 },
 { 239,-10608 }, { 240,-10608 }, { 241,-10608 }, { 242,-10608 }, { 243,-10608 },
 { 244,-10608 }, { 245,-10608 }, { 246,-10608 }, { 247,-10608 }, { 248,-10608 },
 { 249,-10608 }, { 250,-10608 }, { 251,-10608 }, { 252,-10608 }, { 253,-10608 },
 { 254,-10608 }, { 255,-10608 }, {   0,  72 }, {   0,4025 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  72 }, {   0,4015 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   3 }, {   0,3990 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  43, 360 }, {   0,   0 }, {  45, 360 }, {   0,   0 },
 {   0,   0 }, {  48, 615 }, {  49, 615 }, {  50, 615 }, {  51, 615 },
 {  52, 615 }, {  53, 615 }, {  54, 615 }, {  55, 615 }, {  56, 615 },
 {  57, 615 }, {  48,-267 }, {  49,-267 }, {  50,-267 }, {  51,-267 },
 {  52,-267 }, {  53,-267 }, {  54,-267 }, {  55,-267 }, {  56,-267 },
 {  57,-267 }, {  33,   0 }, {   0,   0 }, {  35,   0 }, {   0,   0 },
 {  37,   0 }, {  38,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  42,   0 }, {  43,   0 }, {   0,   0 }, {  45,   0 }, {   0,   0 },
 {  47,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {   0,  64 }, {   0,3924 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  94,   0 }, {   0,   0 }, {  96,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,2059 }, {  49,2059 }, {  50,2059 },
 {  51,2059 }, {  52,2059 }, {  53,2059 }, {  54,2059 }, {  55,2059 },
 {  56,2059 }, {  57,2059 }, { 124,   0 }, {   0,   0 }, { 126,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-10966 },
 {  66,-10966 }, {  67,-10966 }, {  68,-10966 }, {  69,-101 }, {  70,-10966 },
 {  71,-10966 }, {  72,-10966 }, {  73,-10966 }, {  74,-10966 }, {  75,-10966 },

 {  76,-10966 }, {  77,-10966 }, {  78,-10966 }, {  79,-10966 }, {  80,-10966 },
 {  81,-10966 }, {  82,-10966 }, {  83,-10966 }, {  84,-10966 }, {  85,-10966 },
 {  86,-10966 }, {  87,-10966 }, {  88,-10966 }, {  89,-10966 }, {  90,-10966 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,2316 },
 {   0,   0 }, {  97,-10966 }, {  98,-10966 }, {  99,-10966 }, { 100,-10966 },
 { 101,-101 }, { 102,-10966 }, { 103,-10966 }, { 104,-10966 }, { 105,-10966 },
 { 106,-10966 }, { 107,-10966 }, { 108,-10966 }, { 109,-10966 }, { 110,-10966 },
 { 111,-10966 }, { 112,-10966 }, { 113,-10966 }, { 114,-10966 }, { 115,-10966 },
 { 116,-10966 }, { 117,-10966 }, { 118,-10966 }, { 119,-10966 }, { 120,-10966 },
 { 121,-10966 }, { 122,-10966 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 128,-10966 }, { 129,-10966 }, { 130,-10966 },
 { 131,-10966 }, { 132,-10966 }, { 133,-10966 }, { 134,-10966 }, { 135,-10966 },
 { 136,-10966 }, { 137,-10966 }, { 138,-10966 }, { 139,-10966 }, { 140,-10966 },
 { 141,-10966 }, { 142,-10966 }, { 143,-10966 }, { 144,-10966 }, { 145,-10966 },
 { 146,-10966 }, { 147,-10966 }, { 148,-10966 }, { 149,-10966 }, { 150,-10966 },
 { 151,-10966 }, { 152,-10966 }, { 153,-10966 }, { 154,-10966 }, { 155,-10966 },
 { 156,-10966 }, { 157,-10966 }, { 158,-10966 }, { 159,-10966 }, { 160,-10966 },
 { 161,-10966 }, { 162,-10966 }, { 163,-10966 }, { 164,-10966 }, { 165,-10966 },
 { 166,-10966 }, { 167,-10966 }, { 168,-10966 }, { 169,-10966 }, { 170,-10966 },
 { 171,-10966 }, { 172,-10966 }, { 173,-10966 }, { 174,-10966 }, { 175,-10966 },

 { 176,-10966 }, { 177,-10966 }, { 178,-10966 }, { 179,-10966 }, { 180,-10966 },
 { 181,-10966 }, { 182,-10966 }, { 183,-10966 }, { 184,-10966 }, { 185,-10966 },
 { 186,-10966 }, { 187,-10966 }, { 188,-10966 }, { 189,-10966 }, { 190,-10966 },
 { 191,-10966 }, { 192,-10966 }, { 193,-10966 }, { 194,-10966 }, { 195,-10966 },
 { 196,-10966 }, { 197,-10966 }, { 198,-10966 }, { 199,-10966 }, { 200,-10966 },
 { 201,-10966 }, { 202,-10966 }, { 203,-10966 }, { 204,-10966 }, { 205,-10966 },
 { 206,-10966 }, { 207,-10966 }, { 208,-10966 }, { 209,-10966 }, { 210,-10966 },
 { 211,-10966 }, { 212,-10966 }, { 213,-10966 }, { 214,-10966 }, { 215,-10966 },
 { 216,-10966 }, { 217,-10966 }, { 218,-10966 }, { 219,-10966 }, { 220,-10966 },
 { 221,-10966 }, { 222,-10966 }, { 223,-10966 }, { 224,-10966 }, { 225,-10966 },

 { 226,-10966 }, { 227,-10966 }, { 228,-10966 }, { 229,-10966 }, { 230,-10966 },
 { 231,-10966 }, { 232,-10966 }, { 233,-10966 }, { 234,-10966 }, { 235,-10966 },
 { 236,-10966 }, { 237,-10966 }, { 238,-10966 }, { 239,-10966 }, { 240,-10966 },
 { 241,-10966 }, { 242,-10966 }, { 243,-10966 }, { 244,-10966 }, { 245,-10966 },
 { 246,-10966 }, { 247,-10966 }, { 248,-10966 }, { 249,-10966 }, { 250,-10966 },
 { 251,-10966 }, { 252,-10966 }, { 253,-10966 }, { 254,-10966 }, { 255,-10966 },
 {   0,  60 }, {   0,3667 }, {   0,  67 }, {   0,3665 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  48, 255 }, {  49, 255 }, {  50, 255 }, {  51, 255 },
 {  52, 255 }, {  53, 255 }, {  54, 255 }, {  55, 255 }, {  56, 255 },
 {  57, 255 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-11201 }, {  66,-11201 }, {  67,-11201 }, {  68,-11201 },

 {  69,-11201 }, {  70,-11201 }, {  71,-11201 }, {  72,-11201 }, {  73,-11201 },
 {  74,-11201 }, {  75,-11201 }, {  76,-11201 }, {  77,-11201 }, {  78,-11201 },
 {  79,-11201 }, {  80,-11201 }, {  81,-11201 }, {  82,-11201 }, {  83,-11201 },
 {  84,-11201 }, {  85,-11201 }, {  86,-11201 }, {  87,-11201 }, {  88,-11201 },
 {  89,-11201 }, {  90,-11201 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,-11196 }, {   0,   0 }, {  97,-11201 }, {  98,-11201 },
 {  99,-11201 }, { 100,-11201 }, { 101,-11201 }, { 102,-11201 }, { 103,-11201 },
 { 104,-11201 }, { 105,-11201 }, { 106,-11201 }, { 107,-11201 }, { 108,-11201 },
 { 109,-11201 }, { 110,-11201 }, { 111,-11201 }, { 112,-11201 }, { 113,-11201 },
 { 114,-11201 }, { 115,-11201 }, { 116,-11201 }, { 117,-11201 }, { 118,-11201 },

 { 119,-11201 }, { 120,-11201 }, { 121,-11201 }, { 122,-11201 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-11201 },
 { 129,-11201 }, { 130,-11201 }, { 131,-11201 }, { 132,-11201 }, { 133,-11201 },
 { 134,-11201 }, { 135,-11201 }, { 136,-11201 }, { 137,-11201 }, { 138,-11201 },
 { 139,-11201 }, { 140,-11201 }, { 141,-11201 }, { 142,-11201 }, { 143,-11201 },
 { 144,-11201 }, { 145,-11201 }, { 146,-11201 }, { 147,-11201 }, { 148,-11201 },
 { 149,-11201 }, { 150,-11201 }, { 151,-11201 }, { 152,-11201 }, { 153,-11201 },
 { 154,-11201 }, { 155,-11201 }, { 156,-11201 }, { 157,-11201 }, { 158,-11201 },
 { 159,-11201 }, { 160,-11201 }, { 161,-11201 }, { 162,-11201 }, { 163,-11201 },
 { 164,-11201 }, { 165,-11201 }, { 166,-11201 }, { 167,-11201 }, { 168,-11201 },

 { 169,-11201 }, { 170,-11201 }, { 171,-11201 }, { 172,-11201 }, { 173,-11201 },
 { 174,-11201 }, { 175,-11201 }, { 176,-11201 }, { 177,-11201 }, { 178,-11201 },
 { 179,-11201 }, { 180,-11201 }, { 181,-11201 }, { 182,-11201 }, { 183,-11201 },
 { 184,-11201 }, { 185,-11201 }, { 186,-11201 }, { 187,-11201 }, { 188,-11201 },
 { 189,-11201 }, { 190,-11201 }, { 191,-11201 }, { 192,-11201 }, { 193,-11201 },
 { 194,-11201 }, { 195,-11201 }, { 196,-11201 }, { 197,-11201 }, { 198,-11201 },
 { 199,-11201 }, { 200,-11201 }, { 201,-11201 }, { 202,-11201 }, { 203,-11201 },
 { 204,-11201 }, { 205,-11201 }, { 206,-11201 }, { 207,-11201 }, { 208,-11201 },
 { 209,-11201 }, { 210,-11201 }, { 211,-11201 }, { 212,-11201 }, { 213,-11201 },
 { 214,-11201 }, { 215,-11201 }, { 216,-11201 }, { 217,-11201 }, { 218,-11201 },

 { 219,-11201 }, { 220,-11201 }, { 221,-11201 }, { 222,-11201 }, { 223,-11201 },
 { 224,-11201 }, { 225,-11201 }, { 226,-11201 }, { 227,-11201 }, { 228,-11201 },
 { 229,-11201 }, { 230,-11201 }, { 231,-11201 }, { 232,-11201 }, { 233,-11201 },
 { 234,-11201 }, { 235,-11201 }, { 236,-11201 }, { 237,-11201 }, { 238,-11201 },
 { 239,-11201 }, { 240,-11201 }, { 241,-11201 }, { 242,-11201 }, { 243,-11201 },
 { 244,-11201 }, { 245,-11201 }, { 246,-11201 }, { 247,-11201 }, { 248,-11201 },
 { 249,-11201 }, { 250,-11201 }, { 251,-11201 }, { 252,-11201 }, { 253,-11201 },
 { 254,-11201 }, { 255,-11201 }, {   0,  66 }, {   0,3410 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,1812 }, {  49,1812 }, {  50,1812 }, {  51,1812 },
 {  52,1812 }, {  53,1812 }, {  54,1812 }, {  55,1812 }, {  56,1812 },
 {  57,1812 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-11451 }, {  66,-11451 },
 {  67,-11451 }, {  68,-11451 }, {  69,-11451 }, {  70,-11451 }, {  71,-11451 },
 {  72,-11451 }, {  73,-11451 }, {  74,-11451 }, {  75,-11451 }, {  76,-11451 },
 {  77,-11451 }, {  78,-11451 }, {  79,-11451 }, {  80,-11451 }, {  81,-11451 },
 {  82,-11451 }, {  83,-11451 }, {  84,-11451 }, {  85,-11451 }, {  86,-11451 },
 {  87,-11451 }, {  88,-11451 }, {  89,-11451 }, {  90,-11451 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,2069 }, {   0,   0 },
 {  97,-11451 }, {  98,-11451 }, {  99,-11451 }, { 100,-11451 }, { 101,-11451 },
 { 102,-11451 }, { 103,-11451 }, { 104,-11451 }, { 105,-11451 }, { 106,-11451 },
 { 107,-11451 }, { 108,-11451 }, { 109,-11451 }, { 110,-11451 }, { 111,-11451 },

 { 112,-11451 }, { 113,-11451 }, { 114,-11451 }, { 115,-11451 }, { 116,-11451 },
 { 117,-11451 }, { 118,-11451 }, { 119,-11451 }, { 120,-11451 }, { 121,-11451 },
 { 122,-11451 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,-11451 }, { 129,-11451 }, { 130,-11451 }, { 131,-11451 },
 { 132,-11451 }, { 133,-11451 }, { 134,-11451 }, { 135,-11451 }, { 136,-11451 },
 { 137,-11451 }, { 138,-11451 }, { 139,-11451 }, { 140,-11451 }, { 141,-11451 },
 { 142,-11451 }, { 143,-11451 }, { 144,-11451 }, { 145,-11451 }, { 146,-11451 },
 { 147,-11451 }, { 148,-11451 }, { 149,-11451 }, { 150,-11451 }, { 151,-11451 },
 { 152,-11451 }, { 153,-11451 }, { 154,-11451 }, { 155,-11451 }, { 156,-11451 },
 { 157,-11451 }, { 158,-11451 }, { 159,-11451 }, { 160,-11451 }, { 161,-11451 },

 { 162,-11451 }, { 163,-11451 }, { 164,-11451 }, { 165,-11451 }, { 166,-11451 },
 { 167,-11451 }, { 168,-11451 }, { 169,-11451 }, { 170,-11451 }, { 171,-11451 },
 { 172,-11451 }, { 173,-11451 }, { 174,-11451 }, { 175,-11451 }, { 176,-11451 },
 { 177,-11451 }, { 178,-11451 }, { 179,-11451 }, { 180,-11451 }, { 181,-11451 },
 { 182,-11451 }, { 183,-11451 }, { 184,-11451 }, { 185,-11451 }, { 186,-11451 },
 { 187,-11451 }, { 188,-11451 }, { 189,-11451 }, { 190,-11451 }, { 191,-11451 },
 { 192,-11451 }, { 193,-11451 }, { 194,-11451 }, { 195,-11451 }, { 196,-11451 },
 { 197,-11451 }, { 198,-11451 }, { 199,-11451 }, { 200,-11451 }, { 201,-11451 },
 { 202,-11451 }, { 203,-11451 }, { 204,-11451 }, { 205,-11451 }, { 206,-11451 },
 { 207,-11451 }, { 208,-11451 }, { 209,-11451 }, { 210,-11451 }, { 211,-11451 },

 { 212,-11451 }, { 213,-11451 }, { 214,-11451 }, { 215,-11451 }, { 216,-11451 },
 { 217,-11451 }, { 218,-11451 }, { 219,-11451 }, { 220,-11451 }, { 221,-11451 },
 { 222,-11451 }, { 223,-11451 }, { 224,-11451 }, { 225,-11451 }, { 226,-11451 },
 { 227,-11451 }, { 228,-11451 }, { 229,-11451 }, { 230,-11451 }, { 231,-11451 },
 { 232,-11451 }, { 233,-11451 }, { 234,-11451 }, { 235,-11451 }, { 236,-11451 },
 { 237,-11451 }, { 238,-11451 }, { 239,-11451 }, { 240,-11451 }, { 241,-11451 },
 { 242,-11451 }, { 243,-11451 }, { 244,-11451 }, { 245,-11451 }, { 246,-11451 },
 { 247,-11451 }, { 248,-11451 }, { 249,-11451 }, { 250,-11451 }, { 251,-11451 },
 { 252,-11451 }, { 253,-11451 }, { 254,-11451 }, { 255,-11451 }, {   0,  59 },
 {   0,3153 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,  62 }, {   0,3145 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },

 {  55,   0 }, {  48,  -8 }, {  49,  -8 }, {  50,  -8 }, {  51,  -8 },
 {  52,  -8 }, {  53,  -8 }, {  54,  -8 }, {  55,  -8 }, {   0,   0 },
 {  65,-11706 }, {  66,-11706 }, {  67,-11706 }, {  68,-11706 }, {  69,-11706 },
 {  70,-11706 }, {  71,-11706 }, {  72,-11706 }, {  73,-11706 }, {  74,-11706 },
 {  75,-11706 }, {  76,-11706 }, {  77,-11706 }, {  78,-11706 }, {  79,-11706 },
 {  80,-11706 }, {  81,-11706 }, {  82,-11706 }, {  83,-11706 }, {  84,-11706 },
 {  85,-11706 }, {  86,-11706 }, {  87,-11706 }, {  88,-11706 }, {  89,-11706 },
 {  90,-11706 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,1822 }, {   0,   0 }, {  97,-11706 }, {  98,-11706 }, {  99,-11706 },
 { 100,-11706 }, { 101,-11706 }, { 102,-11706 }, { 103,-11706 }, { 104,-11706 },

 { 105,-11706 }, { 106,-11706 }, { 107,-11706 }, { 108,-11706 }, { 109,-11706 },
 { 110,-11706 }, { 111,-11706 }, { 112,-11706 }, { 113,-11706 }, { 114,-11706 },
 { 115,-11706 }, { 116,-11706 }, { 117,-11706 }, { 118,-11706 }, { 119,-11706 },
 { 120,-11706 }, { 121,-11706 }, { 122,-11706 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-11706 }, { 129,-11706 },
 { 130,-11706 }, { 131,-11706 }, { 132,-11706 }, { 133,-11706 }, { 134,-11706 },
 { 135,-11706 }, { 136,-11706 }, { 137,-11706 }, { 138,-11706 }, { 139,-11706 },
 { 140,-11706 }, { 141,-11706 }, { 142,-11706 }, { 143,-11706 }, { 144,-11706 },
 { 145,-11706 }, { 146,-11706 }, { 147,-11706 }, { 148,-11706 }, { 149,-11706 },
 { 150,-11706 }, { 151,-11706 }, { 152,-11706 }, { 153,-11706 }, { 154,-11706 },

 { 155,-11706 }, { 156,-11706 }, { 157,-11706 }, { 158,-11706 }, { 159,-11706 },
 { 160,-11706 }, { 161,-11706 }, { 162,-11706 }, { 163,-11706 }, { 164,-11706 },
 { 165,-11706 }, { 166,-11706 }, { 167,-11706 }, { 168,-11706 }, { 169,-11706 },
 { 170,-11706 }, { 171,-11706 }, { 172,-11706 }, { 173,-11706 }, { 174,-11706 },
 { 175,-11706 }, { 176,-11706 }, { 177,-11706 }, { 178,-11706 }, { 179,-11706 },
 { 180,-11706 }, { 181,-11706 }, { 182,-11706 }, { 183,-11706 }, { 184,-11706 },
 { 185,-11706 }, { 186,-11706 }, { 187,-11706 }, { 188,-11706 }, { 189,-11706 },
 { 190,-11706 }, { 191,-11706 }, { 192,-11706 }, { 193,-11706 }, { 194,-11706 },
 { 195,-11706 }, { 196,-11706 }, { 197,-11706 }, { 198,-11706 }, { 199,-11706 },
 { 200,-11706 }, { 201,-11706 }, { 202,-11706 }, { 203,-11706 }, { 204,-11706 },

 { 205,-11706 }, { 206,-11706 }, { 207,-11706 }, { 208,-11706 }, { 209,-11706 },
 { 210,-11706 }, { 211,-11706 }, { 212,-11706 }, { 213,-11706 }, { 214,-11706 },
 { 215,-11706 }, { 216,-11706 }, { 217,-11706 }, { 218,-11706 }, { 219,-11706 },
 { 220,-11706 }, { 221,-11706 }, { 222,-11706 }, { 223,-11706 }, { 224,-11706 },
 { 225,-11706 }, { 226,-11706 }, { 227,-11706 }, { 228,-11706 }, { 229,-11706 },
 { 230,-11706 }, { 231,-11706 }, { 232,-11706 }, { 233,-11706 }, { 234,-11706 },
 { 235,-11706 }, { 236,-11706 }, { 237,-11706 }, { 238,-11706 }, { 239,-11706 },
 { 240,-11706 }, { 241,-11706 }, { 242,-11706 }, { 243,-11706 }, { 244,-11706 },
 { 245,-11706 }, { 246,-11706 }, { 247,-11706 }, { 248,-11706 }, { 249,-11706 },
 { 250,-11706 }, { 251,-11706 }, { 252,-11706 }, { 253,-11706 }, { 254,-11706 },

 { 255,-11706 }, {   0,  58 }, {   0,2896 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,1573 }, {  66,1573 }, {  67,1573 },
 {  68,1573 }, {  69,1573 }, {  70,1573 }, {  71,-11957 }, {  72,-11957 },
 {  73,-11957 }, {  74,-11957 }, {  75,-11957 }, {  76,-11957 }, {  77,-11957 },
 {  78,-11957 }, {  79,-11957 }, {  80,-11957 }, {  81,-11957 }, {  82,-11957 },
 {  83,-11957 }, {  84,-11957 }, {  85,-11957 }, {  86,-11957 }, {  87,-11957 },
 {  88,-11957 }, {  89,-11957 }, {  90,-11957 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,1830 }, {   0,   0 }, {  97,1573 },

 {  98,1573 }, {  99,1573 }, { 100,1573 }, { 101,1573 }, { 102,1573 },
 { 103,-11957 }, { 104,-11957 }, { 105,-11957 }, { 106,-11957 }, { 107,-11957 },
 { 108,-11957 }, { 109,-11957 }, { 110,-11957 }, { 111,-11957 }, { 112,-11957 },
 { 113,-11957 }, { 114,-11957 }, { 115,-11957 }, { 116,-11957 }, { 117,-11957 },
 { 118,-11957 }, { 119,-11957 }, { 120,-11957 }, { 121,-11957 }, { 122,-11957 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-11957 }, { 129,-11957 }, { 130,-11957 }, { 131,-11957 }, { 132,-11957 },
 { 133,-11957 }, { 134,-11957 }, { 135,-11957 }, { 136,-11957 }, { 137,-11957 },
 { 138,-11957 }, { 139,-11957 }, { 140,-11957 }, { 141,-11957 }, { 142,-11957 },
 { 143,-11957 }, { 144,-11957 }, { 145,-11957 }, { 146,-11957 }, { 147,-11957 },

 { 148,-11957 }, { 149,-11957 }, { 150,-11957 }, { 151,-11957 }, { 152,-11957 },
 { 153,-11957 }, { 154,-11957 }, { 155,-11957 }, { 156,-11957 }, { 157,-11957 },
 { 158,-11957 }, { 159,-11957 }, { 160,-11957 }, { 161,-11957 }, { 162,-11957 },
 { 163,-11957 }, { 164,-11957 }, { 165,-11957 }, { 166,-11957 }, { 167,-11957 },
 { 168,-11957 }, { 169,-11957 }, { 170,-11957 }, { 171,-11957 }, { 172,-11957 },
 { 173,-11957 }, { 174,-11957 }, { 175,-11957 }, { 176,-11957 }, { 177,-11957 },
 { 178,-11957 }, { 179,-11957 }, { 180,-11957 }, { 181,-11957 }, { 182,-11957 },
 { 183,-11957 }, { 184,-11957 }, { 185,-11957 }, { 186,-11957 }, { 187,-11957 },
 { 188,-11957 }, { 189,-11957 }, { 190,-11957 }, { 191,-11957 }, { 192,-11957 },
 { 193,-11957 }, { 194,-11957 }, { 195,-11957 }, { 196,-11957 }, { 197,-11957 },

 { 198,-11957 }, { 199,-11957 }, { 200,-11957 }, { 201,-11957 }, { 202,-11957 },
 { 203,-11957 }, { 204,-11957 }, { 205,-11957 }, { 206,-11957 }, { 207,-11957 },
 { 208,-11957 }, { 209,-11957 }, { 210,-11957 }, { 211,-11957 }, { 212,-11957 },
 { 213,-11957 }, { 214,-11957 }, { 215,-11957 }, { 216,-11957 }, { 217,-11957 },
 { 218,-11957 }, { 219,-11957 }, { 220,-11957 }, { 221,-11957 }, { 222,-11957 },
 { 223,-11957 }, { 224,-11957 }, { 225,-11957 }, { 226,-11957 }, { 227,-11957 },
 { 228,-11957 }, { 229,-11957 }, { 230,-11957 }, { 231,-11957 }, { 232,-11957 },
 { 233,-11957 }, { 234,-11957 }, { 235,-11957 }, { 236,-11957 }, { 237,-11957 },
 { 238,-11957 }, { 239,-11957 }, { 240,-11957 }, { 241,-11957 }, { 242,-11957 },
 { 243,-11957 }, { 244,-11957 }, { 245,-11957 }, { 246,-11957 }, { 247,-11957 },

 { 248,-11957 }, { 249,-11957 }, { 250,-11957 }, { 251,-11957 }, { 252,-11957 },
 { 253,-11957 }, { 254,-11957 }, { 255,-11957 }, {   0,  61 }, {   0,2639 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  57 }, {   0,2601 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-257 }, {  49,-257 }, {  50,-257 },
 {  51,-257 }, {  52,-257 }, {  53,-257 }, {  54,-257 }, {  55,-257 },
 {  56,-257 }, {  57,-257 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-257 },
 {  66,-257 }, {  67,-257 }, {  68,-257 }, {  69,-257 }, {  70,-257 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46,1573 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },

 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {  97,-257 }, {  98,-257 }, {  99,-257 }, { 100,-257 },
 { 101,-257 }, { 102,-257 }, {  65,-12625 }, {  66,-12625 }, {  67,-12625 },
 {  68,-12625 }, {  69,-5509 }, {  70,-12625 }, {  71,-12625 }, {  72,-12625 },
 {  73,-12625 }, {  74,-12625 }, {  75,-12625 }, {  76,-12625 }, {  77,-12625 },
 {  78,-12625 }, {  79,-12625 }, {  80,-12625 }, {  81,-12625 }, {  82,-12625 },
 {  83,-12625 }, {  84,-12625 }, {  85,-12625 }, {  86,-12625 }, {  87,-12625 },
 {  88,-12625 }, {  89,-12625 }, {  90,-12625 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,-5468 }, {   0,   0 }, {  97,-12625 },
 {  98,-12625 }, {  99,-12625 }, { 100,-12625 }, { 101,-5509 }, { 102,-12625 },

 { 103,-12625 }, { 104,-12625 }, { 105,-12625 }, { 106,-12625 }, { 107,-12625 },
 { 108,-12625 }, { 109,-12625 }, { 110,-12625 }, { 111,-12625 }, { 112,-12625 },
 { 113,-12625 }, { 114,-12625 }, { 115,-12625 }, { 116,-12625 }, { 117,-12625 },
 { 118,-12625 }, { 119,-12625 }, { 120,-12625 }, { 121,-12625 }, { 122,-12625 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-12625 }, { 129,-12625 }, { 130,-12625 }, { 131,-12625 }, { 132,-12625 },
 { 133,-12625 }, { 134,-12625 }, { 135,-12625 }, { 136,-12625 }, { 137,-12625 },
 { 138,-12625 }, { 139,-12625 }, { 140,-12625 }, { 141,-12625 }, { 142,-12625 },
 { 143,-12625 }, { 144,-12625 }, { 145,-12625 }, { 146,-12625 }, { 147,-12625 },
 { 148,-12625 }, { 149,-12625 }, { 150,-12625 }, { 151,-12625 }, { 152,-12625 },

 { 153,-12625 }, { 154,-12625 }, { 155,-12625 }, { 156,-12625 }, { 157,-12625 },
 { 158,-12625 }, { 159,-12625 }, { 160,-12625 }, { 161,-12625 }, { 162,-12625 },
 { 163,-12625 }, { 164,-12625 }, { 165,-12625 }, { 166,-12625 }, { 167,-12625 },
 { 168,-12625 }, { 169,-12625 }, { 170,-12625 }, { 171,-12625 }, { 172,-12625 },
 { 173,-12625 }, { 174,-12625 }, { 175,-12625 }, { 176,-12625 }, { 177,-12625 },
 { 178,-12625 }, { 179,-12625 }, { 180,-12625 }, { 181,-12625 }, { 182,-12625 },
 { 183,-12625 }, { 184,-12625 }, { 185,-12625 }, { 186,-12625 }, { 187,-12625 },
 { 188,-12625 }, { 189,-12625 }, { 190,-12625 }, { 191,-12625 }, { 192,-12625 },
 { 193,-12625 }, { 194,-12625 }, { 195,-12625 }, { 196,-12625 }, { 197,-12625 },
 { 198,-12625 }, { 199,-12625 }, { 200,-12625 }, { 201,-12625 }, { 202,-12625 },

 { 203,-12625 }, { 204,-12625 }, { 205,-12625 }, { 206,-12625 }, { 207,-12625 },
 { 208,-12625 }, { 209,-12625 }, { 210,-12625 }, { 211,-12625 }, { 212,-12625 },
 { 213,-12625 }, { 214,-12625 }, { 215,-12625 }, { 216,-12625 }, { 217,-12625 },
 { 218,-12625 }, { 219,-12625 }, { 220,-12625 }, { 221,-12625 }, { 222,-12625 },
 { 223,-12625 }, { 224,-12625 }, { 225,-12625 }, { 226,-12625 }, { 227,-12625 },
 { 228,-12625 }, { 229,-12625 }, { 230,-12625 }, { 231,-12625 }, { 232,-12625 },
 { 233,-12625 }, { 234,-12625 }, { 235,-12625 }, { 236,-12625 }, { 237,-12625 },
 { 238,-12625 }, { 239,-12625 }, { 240,-12625 }, { 241,-12625 }, { 242,-12625 },
 { 243,-12625 }, { 244,-12625 }, { 245,-12625 }, { 246,-12625 }, { 247,-12625 },
 { 248,-12625 }, { 249,-12625 }, { 250,-12625 }, { 251,-12625 }, { 252,-12625 },

 { 253,-12625 }, { 254,-12625 }, { 255,-12625 }, {   0,   4 }, {   0,2344 },
 {   0,  30 }, {   0,2342 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  28 }, {   0,2327 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  33,   0 }, {   0,   0 }, {  35,   0 },
 {   0,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,   0 }, {  43,   0 }, {   0,   0 }, {  45,   0 },

 {   0,   0 }, {  47,   0 }, {   0,   0 }, {   0,   0 }, {  48,-12509 },
 {  49,-12509 }, {  50,-12509 }, {  51,-12509 }, {  52,-12509 }, {  53,-12509 },
 {  54,-12509 }, {  55,-12509 }, {   0,   0 }, {   0,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  48,1556 },
 {  49,1556 }, {  50,1556 }, {  51,1556 }, {  52,1556 }, {  53,1556 },
 {  54,1556 }, {  55,1556 }, {  56,1556 }, {  57,1556 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0,2265 }, {   0,   0 },
 {   0,   0 }, {  65,1556 }, {  66,1556 }, {  67,1556 }, {  68,1556 },
 {  69,1556 }, {  70,1556 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,   0 }, {   0,   0 },

 {  96,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  31 }, {   0,2242 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,1556 }, {  98,1556 },
 {  99,1556 }, { 100,1556 }, { 101,1556 }, { 102,1556 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,   0 }, {   0,   0 },
 { 126,   0 }, {  48,1517 }, {  49,1517 }, {  50,1517 }, {  51,1517 },
 {  52,1517 }, {  53,1517 }, {  54,1517 }, {  55,1517 }, {  56,1517 },
 {  57,1517 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1517 }, {  66,1517 },

 {  67,1517 }, {  68,1517 }, {  69,1517 }, {  70,1517 }, {  48,-12598 },
 {  49,-12598 }, {  50,-12598 }, {  51,-12598 }, {  52,-12598 }, {  53,-12598 },
 {  54,-12598 }, {  55,-12598 }, {  56,-12598 }, {  57,-12598 }, {   0,  37 },
 {   0,2183 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-12598 }, {  66,-12598 }, {  67,-12598 }, {  68,-12598 },
 {  69,-12598 }, {  70,-12598 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,1517 }, {  98,1517 }, {  99,1517 }, { 100,1517 }, { 101,1517 },
 { 102,1517 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  36,-12709 }, {   0,   0 }, {  97,-12598 }, {  98,-12598 },
 {  99,-12598 }, { 100,-12598 }, { 101,-12598 }, { 102,-12598 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },

 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },

 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },

 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },

 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, {   0,  28 }, {   0,1926 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  28 },
 {   0,1903 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,1216 }, {  49,1216 }, {  50,1216 }, {  51,1216 }, {  52,1216 },
 {  53,1216 }, {  54,1216 }, {  55,1216 }, {  56,1216 }, {  57,1216 },
 {   0,   0 }, {   0,   0 }, {   0,  64 }, {   0,1865 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,1216 }, {  66,1216 }, {  67,1216 },
 {  68,1216 }, {  69,1216 }, {  70,1216 }, {  48,1216 }, {  49,1216 },
 {  50,1216 }, {  51,1216 }, {  52,1216 }, {  53,1216 }, {  54,1216 },

 {  55,1216 }, {  56,1216 }, {  57,1216 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,1216 }, {  66,1216 }, {  67,1216 }, {  68,1216 }, {  69,1216 },
 {  70,1216 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,1216 },
 {  98,1216 }, {  99,1216 }, { 100,1216 }, { 101,1216 }, { 102,1216 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {   0,   0 }, {  97,1216 }, {  98,1216 }, {  99,1216 },
 { 100,1216 }, { 101,1216 }, { 102,1216 }, {  65,-13025 }, {  66,-13025 },

 {  67,-13025 }, {  68,-13025 }, {  69,-2160 }, {  70,-13025 }, {  71,-13025 },
 {  72,-13025 }, {  73,-13025 }, {  74,-13025 }, {  75,-13025 }, {  76,-13025 },
 {  77,-13025 }, {  78,-13025 }, {  79,-13025 }, {  80,-13025 }, {  81,-13025 },
 {  82,-13025 }, {  83,-13025 }, {  84,-13025 }, {  85,-13025 }, {  86,-13025 },
 {  87,-13025 }, {  88,-13025 }, {  89,-13025 }, {  90,-13025 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95, 257 }, {   0,   0 },
 {  97,-13025 }, {  98,-13025 }, {  99,-13025 }, { 100,-13025 }, { 101,-2160 },
 { 102,-13025 }, { 103,-13025 }, { 104,-13025 }, { 105,-13025 }, { 106,-13025 },
 { 107,-13025 }, { 108,-13025 }, { 109,-13025 }, { 110,-13025 }, { 111,-13025 },
 { 112,-13025 }, { 113,-13025 }, { 114,-13025 }, { 115,-13025 }, { 116,-13025 },

 { 117,-13025 }, { 118,-13025 }, { 119,-13025 }, { 120,-13025 }, { 121,-13025 },
 { 122,-13025 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,-13025 }, { 129,-13025 }, { 130,-13025 }, { 131,-13025 },
 { 132,-13025 }, { 133,-13025 }, { 134,-13025 }, { 135,-13025 }, { 136,-13025 },
 { 137,-13025 }, { 138,-13025 }, { 139,-13025 }, { 140,-13025 }, { 141,-13025 },
 { 142,-13025 }, { 143,-13025 }, { 144,-13025 }, { 145,-13025 }, { 146,-13025 },
 { 147,-13025 }, { 148,-13025 }, { 149,-13025 }, { 150,-13025 }, { 151,-13025 },
 { 152,-13025 }, { 153,-13025 }, { 154,-13025 }, { 155,-13025 }, { 156,-13025 },
 { 157,-13025 }, { 158,-13025 }, { 159,-13025 }, { 160,-13025 }, { 161,-13025 },
 { 162,-13025 }, { 163,-13025 }, { 164,-13025 }, { 165,-13025 }, { 166,-13025 },

 { 167,-13025 }, { 168,-13025 }, { 169,-13025 }, { 170,-13025 }, { 171,-13025 },
 { 172,-13025 }, { 173,-13025 }, { 174,-13025 }, { 175,-13025 }, { 176,-13025 },
 { 177,-13025 }, { 178,-13025 }, { 179,-13025 }, { 180,-13025 }, { 181,-13025 },
 { 182,-13025 }, { 183,-13025 }, { 184,-13025 }, { 185,-13025 }, { 186,-13025 },
 { 187,-13025 }, { 188,-13025 }, { 189,-13025 }, { 190,-13025 }, { 191,-13025 },
 { 192,-13025 }, { 193,-13025 }, { 194,-13025 }, { 195,-13025 }, { 196,-13025 },
 { 197,-13025 }, { 198,-13025 }, { 199,-13025 }, { 200,-13025 }, { 201,-13025 },
 { 202,-13025 }, { 203,-13025 }, { 204,-13025 }, { 205,-13025 }, { 206,-13025 },
 { 207,-13025 }, { 208,-13025 }, { 209,-13025 }, { 210,-13025 }, { 211,-13025 },
 { 212,-13025 }, { 213,-13025 }, { 214,-13025 }, { 215,-13025 }, { 216,-13025 },

 { 217,-13025 }, { 218,-13025 }, { 219,-13025 }, { 220,-13025 }, { 221,-13025 },
 { 222,-13025 }, { 223,-13025 }, { 224,-13025 }, { 225,-13025 }, { 226,-13025 },
 { 227,-13025 }, { 228,-13025 }, { 229,-13025 }, { 230,-13025 }, { 231,-13025 },
 { 232,-13025 }, { 233,-13025 }, { 234,-13025 }, { 235,-13025 }, { 236,-13025 },
 { 237,-13025 }, { 238,-13025 }, { 239,-13025 }, { 240,-13025 }, { 241,-13025 },
 { 242,-13025 }, { 243,-13025 }, { 244,-13025 }, { 245,-13025 }, { 246,-13025 },
 { 247,-13025 }, { 248,-13025 }, { 249,-13025 }, { 250,-13025 }, { 251,-13025 },
 { 252,-13025 }, { 253,-13025 }, { 254,-13025 }, { 255,-13025 }, {   0,  72 },
 {   0,1608 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  66 },

 {   0,1598 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-257 }, {  49,-257 },
 {  50,-257 }, {  51,-257 }, {  52,-257 }, {  53,-257 }, {  54,-257 },
 {  55,-257 }, {  56,-257 }, {  57,-257 }, {  48,   0 }, {  49,   0 },

 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-13263 }, {  66,-13263 }, {  67,-13263 }, {  68,-13263 }, {  69,-13263 },
 {  70,-13263 }, {  71,-13263 }, {  72,-13263 }, {  73,-13263 }, {  74,-13263 },
 {  75,-13263 }, {  76,-13263 }, {  77,-13263 }, {  78,-13263 }, {  79,-13263 },
 {  80,-13263 }, {  81,-13263 }, {  82,-13263 }, {  83,-13263 }, {  84,-13263 },
 {  85,-13263 }, {  86,-13263 }, {  87,-13263 }, {  88,-13263 }, {  89,-13263 },
 {  90,-13263 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95, 257 }, {   0,   0 }, {  97,-13263 }, {  98,-13263 }, {  99,-13263 },

 { 100,-13263 }, { 101,-13263 }, { 102,-13263 }, { 103,-13263 }, { 104,-13263 },
 { 105,-13263 }, { 106,-13263 }, { 107,-13263 }, { 108,-13263 }, { 109,-13263 },
 { 110,-13263 }, { 111,-13263 }, { 112,-13263 }, { 113,-13263 }, { 114,-13263 },
 { 115,-13263 }, { 116,-13263 }, { 117,-13263 }, { 118,-13263 }, { 119,-13263 },
 { 120,-13263 }, { 121,-13263 }, { 122,-13263 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-13263 }, { 129,-13263 },
 { 130,-13263 }, { 131,-13263 }, { 132,-13263 }, { 133,-13263 }, { 134,-13263 },
 { 135,-13263 }, { 136,-13263 }, { 137,-13263 }, { 138,-13263 }, { 139,-13263 },
 { 140,-13263 }, { 141,-13263 }, { 142,-13263 }, { 143,-13263 }, { 144,-13263 },
 { 145,-13263 }, { 146,-13263 }, { 147,-13263 }, { 148,-13263 }, { 149,-13263 },

 { 150,-13263 }, { 151,-13263 }, { 152,-13263 }, { 153,-13263 }, { 154,-13263 },
 { 155,-13263 }, { 156,-13263 }, { 157,-13263 }, { 158,-13263 }, { 159,-13263 },
 { 160,-13263 }, { 161,-13263 }, { 162,-13263 }, { 163,-13263 }, { 164,-13263 },
 { 165,-13263 }, { 166,-13263 }, { 167,-13263 }, { 168,-13263 }, { 169,-13263 },
 { 170,-13263 }, { 171,-13263 }, { 172,-13263 }, { 173,-13263 }, { 174,-13263 },
 { 175,-13263 }, { 176,-13263 }, { 177,-13263 }, { 178,-13263 }, { 179,-13263 },
 { 180,-13263 }, { 181,-13263 }, { 182,-13263 }, { 183,-13263 }, { 184,-13263 },
 { 185,-13263 }, { 186,-13263 }, { 187,-13263 }, { 188,-13263 }, { 189,-13263 },
 { 190,-13263 }, { 191,-13263 }, { 192,-13263 }, { 193,-13263 }, { 194,-13263 },
 { 195,-13263 }, { 196,-13263 }, { 197,-13263 }, { 198,-13263 }, { 199,-13263 },

 { 200,-13263 }, { 201,-13263 }, { 202,-13263 }, { 203,-13263 }, { 204,-13263 },
 { 205,-13263 }, { 206,-13263 }, { 207,-13263 }, { 208,-13263 }, { 209,-13263 },
 { 210,-13263 }, { 211,-13263 }, { 212,-13263 }, { 213,-13263 }, { 214,-13263 },
 { 215,-13263 }, { 216,-13263 }, { 217,-13263 }, { 218,-13263 }, { 219,-13263 },
 { 220,-13263 }, { 221,-13263 }, { 222,-13263 }, { 223,-13263 }, { 224,-13263 },
 { 225,-13263 }, { 226,-13263 }, { 227,-13263 }, { 228,-13263 }, { 229,-13263 },
 { 230,-13263 }, { 231,-13263 }, { 232,-13263 }, { 233,-13263 }, { 234,-13263 },
 { 235,-13263 }, { 236,-13263 }, { 237,-13263 }, { 238,-13263 }, { 239,-13263 },
 { 240,-13263 }, { 241,-13263 }, { 242,-13263 }, { 243,-13263 }, { 244,-13263 },
 { 245,-13263 }, { 246,-13263 }, { 247,-13263 }, { 248,-13263 }, { 249,-13263 },

 { 250,-13263 }, { 251,-13263 }, { 252,-13263 }, { 253,-13263 }, { 254,-13263 },
 { 255,-13263 }, {   0,  73 }, {   0,1341 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  70 }, {   0,1331 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  58 },
 {   0,1323 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-257 }, {  49,-257 }, {  50,-257 }, {  51,-257 }, {  52,-257 },
 {  53,-257 }, {  54,-257 }, {  55,-257 }, {  56,-257 }, {  57,-257 },
 {  48,-1822 }, {  49,-1822 }, {  50,-1822 }, {  51,-1822 }, {  52,-1822 },
 {  53,-1822 }, {  54,-1822 }, {  55,-1822 }, {  48,-1573 }, {  49,-1573 },
 {  50,-1573 }, {  51,-1573 }, {  52,-1573 }, {  53,-1573 }, {  54,-1573 },
 {  55,-1573 }, {  56,-1573 }, {  57,-1573 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,-13530 }, {  72,-13530 }, {  73,-13530 }, {  74,-13530 },

 {  75,-13530 }, {  76,-13530 }, {  77,-13530 }, {  78,-13530 }, {  79,-13530 },
 {  80,-13530 }, {  81,-13530 }, {  82,-13530 }, {  83,-13530 }, {  84,-13530 },
 {  85,-13530 }, {  86,-13530 }, {  87,-13530 }, {  88,-13530 }, {  89,-13530 },
 {  90,-13530 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95, 257 }, {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,-13530 }, { 104,-13530 },
 { 105,-13530 }, { 106,-13530 }, { 107,-13530 }, { 108,-13530 }, { 109,-13530 },
 { 110,-13530 }, { 111,-13530 }, { 112,-13530 }, { 113,-13530 }, { 114,-13530 },
 { 115,-13530 }, { 116,-13530 }, { 117,-13530 }, { 118,-13530 }, { 119,-13530 },
 { 120,-13530 }, { 121,-13530 }, { 122,-13530 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-13530 }, { 129,-13530 },
 { 130,-13530 }, { 131,-13530 }, { 132,-13530 }, { 133,-13530 }, { 134,-13530 },
 { 135,-13530 }, { 136,-13530 }, { 137,-13530 }, { 138,-13530 }, { 139,-13530 },
 { 140,-13530 }, { 141,-13530 }, { 142,-13530 }, { 143,-13530 }, { 144,-13530 },
 { 145,-13530 }, { 146,-13530 }, { 147,-13530 }, { 148,-13530 }, { 149,-13530 },
 { 150,-13530 }, { 151,-13530 }, { 152,-13530 }, { 153,-13530 }, { 154,-13530 },
 { 155,-13530 }, { 156,-13530 }, { 157,-13530 }, { 158,-13530 }, { 159,-13530 },
 { 160,-13530 }, { 161,-13530 }, { 162,-13530 }, { 163,-13530 }, { 164,-13530 },
 { 165,-13530 }, { 166,-13530 }, { 167,-13530 }, { 168,-13530 }, { 169,-13530 },
 { 170,-13530 }, { 171,-13530 }, { 172,-13530 }, { 173,-13530 }, { 174,-13530 },

 { 175,-13530 }, { 176,-13530 }, { 177,-13530 }, { 178,-13530 }, { 179,-13530 },
 { 180,-13530 }, { 181,-13530 }, { 182,-13530 }, { 183,-13530 }, { 184,-13530 },
 { 185,-13530 }, { 186,-13530 }, { 187,-13530 }, { 188,-13530 }, { 189,-13530 },
 { 190,-13530 }, { 191,-13530 }, { 192,-13530 }, { 193,-13530 }, { 194,-13530 },
 { 195,-13530 }, { 196,-13530 }, { 197,-13530 }, { 198,-13530 }, { 199,-13530 },
 { 200,-13530 }, { 201,-13530 }, { 202,-13530 }, { 203,-13530 }, { 204,-13530 },
 { 205,-13530 }, { 206,-13530 }, { 207,-13530 }, { 208,-13530 }, { 209,-13530 },
 { 210,-13530 }, { 211,-13530 }, { 212,-13530 }, { 213,-13530 }, { 214,-13530 },
 { 215,-13530 }, { 216,-13530 }, { 217,-13530 }, { 218,-13530 }, { 219,-13530 },
 { 220,-13530 }, { 221,-13530 }, { 222,-13530 }, { 223,-13530 }, { 224,-13530 },

 { 225,-13530 }, { 226,-13530 }, { 227,-13530 }, { 228,-13530 }, { 229,-13530 },
 { 230,-13530 }, { 231,-13530 }, { 232,-13530 }, { 233,-13530 }, { 234,-13530 },
 { 235,-13530 }, { 236,-13530 }, { 237,-13530 }, { 238,-13530 }, { 239,-13530 },
 { 240,-13530 }, { 241,-13530 }, { 242,-13530 }, { 243,-13530 }, { 244,-13530 },
 { 245,-13530 }, { 246,-13530 }, { 247,-13530 }, { 248,-13530 }, { 249,-13530 },
 { 250,-13530 }, { 251,-13530 }, { 252,-13530 }, { 253,-13530 }, { 254,-13530 },
 { 255,-13530 }, {   0,  69 }, {   0,1066 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  64 },
 {   0,1028 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-1830 }, {  49,-1830 }, {  50,-1830 }, {  51,-1830 }, {  52,-1830 },
 {  53,-1830 }, {  54,-1830 }, {  55,-1830 }, {  56,-1830 }, {  57,-1830 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-1830 }, {  66,-1830 }, {  67,-1830 },

 {  68,-1830 }, {  69,-1830 }, {  70,-1830 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-2896 }, {  49,-2896 },
 {  50,-2896 }, {  51,-2896 }, {  52,-2896 }, {  53,-2896 }, {  54,-2896 },
 {  55,-2896 }, {  56,-2896 }, {  57,-2896 }, {   0,   0 }, {  97,-1830 },
 {  98,-1830 }, {  99,-1830 }, { 100,-1830 }, { 101,-1830 }, { 102,-1830 },
 {  65,-13862 }, {  66,-13862 }, {  67,-13862 }, {  68,-13862 }, {  69,-2997 },
 {  70,-13862 }, {  71,-13862 }, {  72,-13862 }, {  73,-13862 }, {  74,-13862 },
 {  75,-13862 }, {  76,-13862 }, {  77,-13862 }, {  78,-13862 }, {  79,-13862 },

 {  80,-13862 }, {  81,-13862 }, {  82,-13862 }, {  83,-13862 }, {  84,-13862 },
 {  85,-13862 }, {  86,-13862 }, {  87,-13862 }, {  88,-13862 }, {  89,-13862 },
 {  90,-13862 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,-13862 }, {   0,   0 }, {  97,-13862 }, {  98,-13862 }, {  99,-13862 },
 { 100,-13862 }, { 101,-2997 }, { 102,-13862 }, { 103,-13862 }, { 104,-13862 },
 { 105,-13862 }, { 106,-13862 }, { 107,-13862 }, { 108,-13862 }, { 109,-13862 },
 { 110,-13862 }, { 111,-13862 }, { 112,-13862 }, { 113,-13862 }, { 114,-13862 },
 { 115,-13862 }, { 116,-13862 }, { 117,-13862 }, { 118,-13862 }, { 119,-13862 },
 { 120,-13862 }, { 121,-13862 }, { 122,-13862 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-13862 }, { 129,-13862 },

 { 130,-13862 }, { 131,-13862 }, { 132,-13862 }, { 133,-13862 }, { 134,-13862 },
 { 135,-13862 }, { 136,-13862 }, { 137,-13862 }, { 138,-13862 }, { 139,-13862 },
 { 140,-13862 }, { 141,-13862 }, { 142,-13862 }, { 143,-13862 }, { 144,-13862 },
 { 145,-13862 }, { 146,-13862 }, { 147,-13862 }, { 148,-13862 }, { 149,-13862 },
 { 150,-13862 }, { 151,-13862 }, { 152,-13862 }, { 153,-13862 }, { 154,-13862 },
 { 155,-13862 }, { 156,-13862 }, { 157,-13862 }, { 158,-13862 }, { 159,-13862 },
 { 160,-13862 }, { 161,-13862 }, { 162,-13862 }, { 163,-13862 }, { 164,-13862 },
 { 165,-13862 }, { 166,-13862 }, { 167,-13862 }, { 168,-13862 }, { 169,-13862 },
 { 170,-13862 }, { 171,-13862 }, { 172,-13862 }, { 173,-13862 }, { 174,-13862 },
 { 175,-13862 }, { 176,-13862 }, { 177,-13862 }, { 178,-13862 }, { 179,-13862 },

 { 180,-13862 }, { 181,-13862 }, { 182,-13862 }, { 183,-13862 }, { 184,-13862 },
 { 185,-13862 }, { 186,-13862 }, { 187,-13862 }, { 188,-13862 }, { 189,-13862 },
 { 190,-13862 }, { 191,-13862 }, { 192,-13862 }, { 193,-13862 }, { 194,-13862 },
 { 195,-13862 }, { 196,-13862 }, { 197,-13862 }, { 198,-13862 }, { 199,-13862 },
 { 200,-13862 }, { 201,-13862 }, { 202,-13862 }, { 203,-13862 }, { 204,-13862 },
 { 205,-13862 }, { 206,-13862 }, { 207,-13862 }, { 208,-13862 }, { 209,-13862 },
 { 210,-13862 }, { 211,-13862 }, { 212,-13862 }, { 213,-13862 }, { 214,-13862 },
 { 215,-13862 }, { 216,-13862 }, { 217,-13862 }, { 218,-13862 }, { 219,-13862 },
 { 220,-13862 }, { 221,-13862 }, { 222,-13862 }, { 223,-13862 }, { 224,-13862 },
 { 225,-13862 }, { 226,-13862 }, { 227,-13862 }, { 228,-13862 }, { 229,-13862 },

 { 230,-13862 }, { 231,-13862 }, { 232,-13862 }, { 233,-13862 }, { 234,-13862 },
 { 235,-13862 }, { 236,-13862 }, { 237,-13862 }, { 238,-13862 }, { 239,-13862 },
 { 240,-13862 }, { 241,-13862 }, { 242,-13862 }, { 243,-13862 }, { 244,-13862 },
 { 245,-13862 }, { 246,-13862 }, { 247,-13862 }, { 248,-13862 }, { 249,-13862 },
 { 250,-13862 }, { 251,-13862 }, { 252,-13862 }, { 253,-13862 }, { 254,-13862 },
 { 255,-13862 }, {   0,  28 }, {   0, 771 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  28 },

 {   0, 748 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48, 143 }, {  49, 143 }, {  50, 143 }, {  51, 143 }, {  52, 143 },
 {  53, 143 }, {  54, 143 }, {  55, 143 }, {  56, 143 }, {  57, 143 },
 {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0, 710 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65, 143 }, {  66, 143 }, {  67, 143 },
 {  68, 143 }, {  69, 143 }, {  70, 143 }, {  48, 143 }, {  49, 143 },

 {  50, 143 }, {  51, 143 }, {  52, 143 }, {  53, 143 }, {  54, 143 },
 {  55, 143 }, {  56, 143 }, {  57, 143 }, {   0,   0 }, {   0,   0 },
 {   0,  28 }, {   0, 687 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65, 143 }, {  66, 143 }, {  67, 143 }, {  68, 143 }, {  69, 143 },
 {  70, 143 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 143 },
 {  98, 143 }, {  99, 143 }, { 100, 143 }, { 101, 143 }, { 102, 143 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48, 143 }, {  49, 143 }, {  50, 143 }, {  51, 143 },
 {  52, 143 }, {  53, 143 }, {  54, 143 }, {  55, 143 }, {  56, 143 },
 {  57, 143 }, {   0,   0 }, {  97, 143 }, {  98, 143 }, {  99, 143 },

 { 100, 143 }, { 101, 143 }, { 102, 143 }, {  65, 143 }, {  66, 143 },
 {  67, 143 }, {  68, 143 }, {  69, 143 }, {  70, 143 }, {  48, 143 },
 {  49, 143 }, {  50, 143 }, {  51, 143 }, {  52, 143 }, {  53, 143 },
 {  54, 143 }, {  55, 143 }, {  56, 143 }, {  57, 143 }, {   0,  28 },
 {   0, 628 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65, 143 }, {  66, 143 }, {  67, 143 }, {  68, 143 },
 {  69, 143 }, {  70, 143 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97, 143 }, {  98, 143 }, {  99, 143 }, { 100, 143 }, { 101, 143 },
 { 102, 143 }, {   0,   0 }, {   0,  28 }, {   0, 605 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 143 }, {  98, 143 },
 {  99, 143 }, { 100, 143 }, { 101, 143 }, { 102, 143 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48, 143 }, {  49, 143 },
 {  50, 143 }, {  51, 143 }, {  52, 143 }, {  53, 143 }, {  54, 143 },
 {  55, 143 }, {  56, 143 }, {  57, 143 }, {   0,   0 }, {   0,   0 },
 {   0,  28 }, {   0, 567 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65, 143 }, {  66, 143 }, {  67, 143 }, {  68, 143 }, {  69, 143 },
 {  70, 143 }, {  48,-14226 }, {  49,-14226 }, {  50,-14226 }, {  51,-14226 },
 {  52,-14226 }, {  53,-14226 }, {  54,-14226 }, {  55,-14226 }, {  56,-14226 },

 {  57,-14226 }, {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0, 544 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-14226 }, {  66,-14226 },
 {  67,-14226 }, {  68,-14226 }, {  69,-14226 }, {  70,-14226 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97, 143 }, {  98, 143 }, {  99, 143 },
 { 100, 143 }, { 101, 143 }, { 102, 143 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48, 105 },
 {  49, 105 }, {  50, 105 }, {  51, 105 }, {  52, 105 }, {  53, 105 },
 {  54, 105 }, {  55, 105 }, {  56, 105 }, {  57, 105 }, {   0,   0 },
 {  97,-14226 }, {  98,-14226 }, {  99,-14226 }, { 100,-14226 }, { 101,-14226 },
 { 102,-14226 }, {  65, 105 }, {  66, 105 }, {  67, 105 }, {  68, 105 },

 {  69, 105 }, {  70, 105 }, {  48,-14283 }, {  49,-14283 }, {  50,-14283 },
 {  51,-14283 }, {  52,-14283 }, {  53,-14283 }, {  54,-14283 }, {  55,-14283 },
 {  56,-14283 }, {  57,-14283 }, {   0,  28 }, {   0, 485 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-14283 },
 {  66,-14283 }, {  67,-14283 }, {  68,-14283 }, {  69,-14283 }, {  70,-14283 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 105 }, {  98, 105 },
 {  99, 105 }, { 100, 105 }, { 101, 105 }, { 102, 105 }, {   0,   0 },
 {   0,  28 }, {   0, 462 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  97,-14283 }, {  98,-14283 }, {  99,-14283 }, { 100,-14283 },
 { 101,-14283 }, { 102,-14283 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,  61 }, {  49,  61 }, {  50,  61 }, {  51,  61 },
 {  52,  61 }, {  53,  61 }, {  54,  61 }, {  55,  61 }, {  56,  61 },
 {  57,  61 }, {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0, 424 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,  61 }, {  66,  61 },
 {  67,  61 }, {  68,  61 }, {  69,  61 }, {  70,  61 }, {  48,  61 },
 {  49,  61 }, {  50,  61 }, {  51,  61 }, {  52,  61 }, {  53,  61 },
 {  54,  61 }, {  55,  61 }, {  56,  61 }, {  57,  61 }, {   0,   0 },
 {   0,   0 }, {   0,  28 }, {   0, 401 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  65,  61 }, {  66,  61 }, {  67,  61 }, {  68,  61 },
 {  69,  61 }, {  70,  61 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,  61 }, {  98,  61 }, {  99,  61 }, { 100,  61 }, { 101,  61 },
 { 102,  61 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,  82 }, {  49,  82 }, {  50,  82 },
 {  51,  82 }, {  52,  82 }, {  53,  82 }, {  54,  82 }, {  55,  82 },
 {  56,  82 }, {  57,  82 }, {   0,   0 }, {  97,  61 }, {  98,  61 },
 {  99,  61 }, { 100,  61 }, { 101,  61 }, { 102,  61 }, {  65,  82 },
 {  66,  82 }, {  67,  82 }, {  68,  82 }, {  69,  82 }, {  70,  82 },
 {  48,  82 }, {  49,  82 }, {  50,  82 }, {  51,  82 }, {  52,  82 },

 {  53,  82 }, {  54,  82 }, {  55,  82 }, {  56,  82 }, {  57,  82 },
 {   0,  28 }, {   0, 342 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,  82 }, {  66,  82 }, {  67,  82 },
 {  68,  82 }, {  69,  82 }, {  70,  82 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,  82 }, {  98,  82 }, {  99,  82 }, { 100,  82 },
 { 101,  82 }, { 102,  82 }, {   0,   0 }, {   0,  28 }, {   0, 319 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,  82 },
 {  98,  82 }, {  99,  82 }, { 100,  82 }, { 101,  82 }, { 102,  82 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,  61 },
 {  49,  61 }, {  50,  61 }, {  51,  61 }, {  52,  61 }, {  53,  61 },
 {  54,  61 }, {  55,  61 }, {  56,  61 }, {  57,  61 }, {   0,   0 },
 {   0,   0 }, {   0,  28 }, {   0, 281 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,  61 }, {  66,  61 }, {  67,  61 }, {  68,  61 },
 {  69,  61 }, {  70,  61 }, {  48,  61 }, {  49,  61 }, {  50,  61 },
 {  51,  61 }, {  52,  61 }, {  53,  61 }, {  54,  61 }, {  55,  61 },
 {  56,  61 }, {  57,  61 }, {   0,   0 }, {   0,   0 }, {   0,  28 },
 {   0, 258 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,  61 },
 {  66,  61 }, {  67,  61 }, {  68,  61 }, {  69,  61 }, {  70,  61 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,  61 }, {  98,  61 },
 {  99,  61 }, { 100,  61 }, { 101,  61 }, { 102,  61 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-14550 }, {  49,-14550 }, {  50,-14550 }, {  51,-14550 }, {  52,-14550 },
 {  53,-14550 }, {  54,-14550 }, {  55,-14550 }, {  56,-14550 }, {  57,-14550 },
 {   0,   0 }, {  97,  61 }, {  98,  61 }, {  99,  61 }, { 100,  61 },
 { 101,  61 }, { 102,  61 }, {  65,-14550 }, {  66,-14550 }, {  67,-14550 },
 {  68,-14550 }, {  69,-14550 }, {  70,-14550 }, {  48,-14569 }, {  49,-14569 },
 {  50,-14569 }, {  51,-14569 }, {  52,-14569 }, {  53,-14569 }, {  54,-14569 },
 {  55,-14569 }, {  56,-14569 }, {  57,-14569 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-14569 }, {  66,-14569 }, {  67,-14569 }, {  68,-14569 }, {  69,-14569 },
 {  70,-14569 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-14550 },
 {  98,-14550 }, {  99,-14550 }, { 100,-14550 }, { 101,-14550 }, { 102,-14550 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,-14569 }, {  98,-14569 }, {  99,-14569 },
 { 100,-14569 }, { 101,-14569 }, { 102,-14569 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 257,  77 }, {   1,   0 },    };

static __thread const struct yy_trans_info *yy_start_state_list[25] =
    {
    &yy_transition[1],
    &yy_transition[3],
    &yy_transition[261],
    &yy_transition[519],
    &yy_transition[777],
    &yy_transition[1035],
    &yy_transition[1293],
    &yy_transition[1551],
    &yy_transition[1809],
    &yy_transition[2067],
    &yy_transition[2325],
    &yy_transition[2583],
    &yy_transition[2841],
    &yy_transition[3099],
    &yy_transition[3357],
    &yy_transition[3615],
    &yy_transition[3873],
    &yy_transition[4131],
    &yy_transition[4389],
    &yy_transition[4647],
    &yy_transition[4905],
    &yy_transition[5163],
    &yy_transition[5421],
    &yy_transition[5679],
    &yy_transition[5937],

    }
;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "scan.l"

#line 49 "scan.l"

/* LCOV_EXCL_START */

/* Avoid exit() on fatal scanner errors (a bit ugly -- see yy_fatal_error) */
#undef fprintf
#define fprintf(file, fmt, msg)  fprintf_to_ereport(fmt, msg)

static void
fprintf_to_ereport(const char *fmt, const char *msg)
{
	ereport(ERROR, (errmsg_internal("%s", msg)));
}

/*
 * GUC variables.  This is a DIRECT violation of the warning given at the
 * head of gram.y, ie flex/bison code must not depend on any GUC variables;
 * as such, changing their values can induce very unintuitive behavior.
 * But we shall have to live with it until we can remove these variables.
 */
__thread int			backslash_quote = BACKSLASH_QUOTE_SAFE_ENCODING;

__thread bool		escape_string_warning = true;

__thread bool		standard_conforming_strings = true;


/*
 * Constant data exported from this file.  This array maps from the
 * zero-based keyword numbers returned by ScanKeywordLookup to the
 * Bison token numbers needed by gram.y.  This is exported because
 * callers need to pass it to scanner_init, if they are using the
 * standard keyword list ScanKeywords.
 */
#define PG_KEYWORD(kwname, value, category, collabel) value,

const uint16 ScanKeywordTokens[] = {
#include "parser/kwlist.h"
};

#undef PG_KEYWORD

/*
 * Set the type of YYSTYPE.
 */
#define YYSTYPE core_YYSTYPE

/*
 * Set the type of yyextra.  All state variables used by the scanner should
 * be in yyextra, *not* statically allocated.
 */
#define YY_EXTRA_TYPE core_yy_extra_type *

/*
 * Each call to yylex must set yylloc to the location of the found token
 * (expressed as a byte offset from the start of the input text).
 * When we parse a token that requires multiple lexer rules to process,
 * this should be done in the first such rule, else yylloc will point
 * into the middle of the token.
 */
#define SET_YYLLOC()  (*(yylloc) = yytext - yyextra->scanbuf)

/*
 * Advance yylloc by the given number of bytes.
 */
#define ADVANCE_YYLLOC(delta)  ( *(yylloc) += (delta) )

/*
 * Sometimes, we do want yylloc to point into the middle of a token; this is
 * useful for instance to throw an error about an escape sequence within a
 * string literal.  But if we find no error there, we want to revert yylloc
 * to the token start, so that that's the location reported to the parser.
 * Use PUSH_YYLLOC/POP_YYLLOC to save/restore yylloc around such code.
 * (Currently the implied "stack" is just one location, but someday we might
 * need to nest these.)
 */
#define PUSH_YYLLOC()	(yyextra->save_yylloc = *(yylloc))
#define POP_YYLLOC()	(*(yylloc) = yyextra->save_yylloc)

#define startlit()	( yyextra->literallen = 0 )
static void addlit(char *ytext, int yleng, core_yyscan_t yyscanner);
static void addlitchar(unsigned char ychar, core_yyscan_t yyscanner);
static char *litbufdup(core_yyscan_t yyscanner);
static unsigned char unescape_single_char(unsigned char c, core_yyscan_t yyscanner);
static int	process_integer_literal(const char *token, YYSTYPE *lval, int base);
static void addunicode(pg_wchar c, yyscan_t yyscanner);

#define yyerror(msg)  scanner_yyerror(msg, yyscanner)

#define lexer_errposition()  scanner_errposition(*(yylloc), yyscanner)

static void check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner);
static void check_escape_warning(core_yyscan_t yyscanner);

/*
 * Work around a bug in flex 2.5.35: it emits a couple of functions that
 * it forgets to emit declarations for.  Since we use -Wmissing-prototypes,
 * this would cause warnings.  Providing our own declarations should be
 * harmless even when the bug gets fixed.
 */
extern int	core_yyget_column(yyscan_t yyscanner);
extern void core_yyset_column(int column_no, yyscan_t yyscanner);

#line 5510 "scan.c"
#define YY_NO_INPUT 1
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xh> hexadecimal byte string
 *  <xq> standard quoted strings
 *  <xqs> quote stop (detect continued strings)
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 *  <xeu> Unicode surrogate pair in extended quoted string
 *
 * Remember to add an <<EOF>> case whenever you add a new exclusive state!
 * The default one is probably not the right thing.
 */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  Comments that start with -- and extend to the next
 * newline are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * XXX perhaps \f (formfeed) should be treated as a newline as well?
 *
 * XXX if you change the set of whitespace characters, fix scanner_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* If we see {quote} then {quotecontinue}, the quoted string continues */
/*
 * {quotecontinuefail} is needed to avoid lexer backup when we fail to match
 * {quotecontinue}.  It might seem that this could just be {whitespace}*,
 * but if there's a dash after {whitespace_with_newline}, it must be consumed
 * to see if there's another dash --- which would start a {comment} and thus
 * allow continuation of the {quotecontinue} token.
 */
/* Bit string
 * It is tempting to scan the string for only those characters
 * which are allowed. However, this leads to silently swallowed
 * characters if illegal characters are included in the string.
 * For example, if xbinside is [01] then B'ABCD' is interpreted
 * as a zero-length string, and the ABCD' is lost!
 * Better to pass the string forward and let the input routines
 * validate the contents.
 */
/* Hexadecimal byte string */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* error rule to avoid backup */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/*
 * Numbers
 *
 * Unary minus is not part of a number here.  Instead we pass it separately to
 * the parser, and there it gets coerced via doNegate().
 *
 * {numericfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail} is added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
#line 5660 "scan.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xh 4
#define xq 5
#define xqs 6
#define xe 7
#define xdolq 8
#define xui 9
#define xus 10
#define xeu 11

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    yy_size_t yy_n_chars;
    yy_size_t yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    YYLTYPE * yylloc_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
    #    define yylloc yyg->yylloc_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			yy_size_t yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

       YYLTYPE *yyget_lloc ( yyscan_t yyscanner );
    
        void yyset_lloc ( YYLTYPE * yylloc_param , yyscan_t yyscanner );
    
/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		yy_size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

    yylloc = yylloc_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 439 "scan.l"


#line 5956 "scan.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start_state_list[yyg->yy_start];
yy_match:
		{
		const struct yy_trans_info *yy_trans_info;

		YY_CHAR yy_c;

		for ( yy_c = YY_SC_TO_UI(*yy_cp);
		      (yy_trans_info = &yy_current_state[yy_c])->
		yy_verify == yy_c;
		      yy_c = YY_SC_TO_UI(*++yy_cp) )
			yy_current_state += yy_trans_info->yy_nxt;
		}

yy_find_action:
		yy_act = yy_current_state[-1].yy_nxt;

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 441 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 445 "scan.l"
{
					SET_YYLLOC();
					return SQL_COMMENT;
				}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 450 "scan.l"
{
					/* Set location in case of syntax error in comment */
					SET_YYLLOC();
					yyextra->xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK

case 4:
YY_RULE_SETUP
#line 460 "scan.l"
{
					(yyextra->xcdepth)++;
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 466 "scan.l"
{
					if (yyextra->xcdepth <= 0)
					{
						BEGIN(INITIAL);
						yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
						return C_COMMENT;
					}
					else
						(yyextra->xcdepth)--;
				}
	YY_BREAK
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 477 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 481 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 485 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case YY_STATE_EOF(xc):
#line 489 "scan.l"
{
					yyerror("unterminated /* comment");
				}
	YY_BREAK
/* <xc> */
case 9:
YY_RULE_SETUP
#line 494 "scan.l"
{
					/* Binary bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "b" on the string
					 * to mark it for the input routine as a binary string.
					 */
					SET_YYLLOC();
					BEGIN(xb);
					startlit();
					addlitchar('b', yyscanner);
				}
	YY_BREAK
case 10:
/* rule 10 can match eol */
#line 507 "scan.l"
case 11:
/* rule 11 can match eol */
YY_RULE_SETUP
#line 507 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xb):
#line 510 "scan.l"
{ yyerror("unterminated bit string literal"); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 512 "scan.l"
{
					/* Hexadecimal bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "x" on the string
					 * to mark it for the input routine as a hex string.
					 */
					SET_YYLLOC();
					BEGIN(xh);
					startlit();
					addlitchar('x', yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 524 "scan.l"
{ yyerror("unterminated hexadecimal string literal"); }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 526 "scan.l"
{
					/* National character.
					 * We will pass this along as a normal character string,
					 * but preceded with an internally-generated "NCHAR".
					 */
					int		kwnum;

					SET_YYLLOC();
					yyless(1);	/* eat only 'n' this time */

					kwnum = ScanKeywordLookup("nchar",
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}
					else
					{
						/* If NCHAR isn't a keyword, just return "n" */
						yylval->str = pstrdup("n");
						yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
						return IDENT;
					}
				}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 553 "scan.l"
{
					yyextra->warn_on_first_escape = true;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					if (yyextra->standard_conforming_strings)
						BEGIN(xq);
					else
						BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 563 "scan.l"
{
					yyextra->warn_on_first_escape = false;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 570 "scan.l"
{
					SET_YYLLOC();
					if (!yyextra->standard_conforming_strings)
						ereport(ERROR,
								(errcode(ERRCODE_FEATURE_NOT_SUPPORTED),
								 errmsg("unsafe use of string constant with Unicode escapes"),
								 errdetail("String constants with Unicode escapes cannot be used when standard_conforming_strings is off."),
								 lexer_errposition()));
					BEGIN(xus);
					startlit();
				}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 582 "scan.l"
{
					/*
					 * When we are scanning a quoted string and see an end
					 * quote, we must look ahead for a possible continuation.
					 * If we don't see one, we know the end quote was in fact
					 * the end of the string.  To reduce the lexer table size,
					 * we use a single "xqs" state to do the lookahead for all
					 * types of strings.
					 */
					yyextra->state_before_str_stop = YYSTATE;
					BEGIN(xqs);
				}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 594 "scan.l"
{
					/*
					 * Found a quote continuation, so return to the in-quote
					 * state and continue scanning the literal.  Nothing is
					 * added to the literal's contents.
					 */
					BEGIN(yyextra->state_before_str_stop);
				}
	YY_BREAK
case 19:
/* rule 19 can match eol */
#line 603 "scan.l"
case 20:
/* rule 20 can match eol */
#line 604 "scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xqs):
#line 604 "scan.l"
{
					/*
					 * Failed to see a quote continuation.  Throw back
					 * everything after the end quote, and handle the string
					 * according to the state we were in previously.
					 */
					yyless(0);
					BEGIN(INITIAL);

					switch (yyextra->state_before_str_stop)
					{
						case xb:
							yylval->str = litbufdup(yyscanner);
							yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
							return BCONST;
						case xh:
							yylval->str = litbufdup(yyscanner);
							yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
							return XCONST;
						case xq:
						case xe:
							/*
							 * Check that the data remains valid, if it might
							 * have been made invalid by unescaping any chars.
							 */
							if (yyextra->saw_non_ascii)
								pg_verifymbstr(yyextra->literalbuf,
											   yyextra->literallen,
											   false);
							yylval->str = litbufdup(yyscanner);
							yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
							return SCONST;
						case xus:
							yylval->str = litbufdup(yyscanner);
							yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
							return USCONST;
						default:
							yyerror("unhandled previous state in xqs");
					}
				}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 645 "scan.l"
{
					addlitchar('\'', yyscanner);
				}
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 648 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 651 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 654 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/*
					 * For consistency with other productions, issue any
					 * escape warning with cursor pointing to start of string.
					 * We might want to change that, someday.
					 */
					check_escape_warning(yyscanner);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (is_utf16_surrogate_first(c))
					{
						yyextra->utf16_first_part = c;
						BEGIN(xeu);
					}
					else if (is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");
					else
						addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();
				}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 682 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (!is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");

					c = surrogate_pair_to_codepoint(yyextra->utf16_first_part, c);

					addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();

					BEGIN(xe);
				}
	YY_BREAK
case 26:
#line 703 "scan.l"
case 27:
/* rule 27 can match eol */
#line 704 "scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xeu):
#line 704 "scan.l"
{
					/* Set the error cursor to point at missing esc seq */
					SET_YYLLOC();
					yyerror("invalid Unicode surrogate pair");
				}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 709 "scan.l"
{
					/* Set the error cursor to point at malformed esc seq */
					SET_YYLLOC();
					ereport(ERROR,
							(errcode(ERRCODE_INVALID_ESCAPE_SEQUENCE),
							 errmsg("invalid Unicode escape"),
							 errhint("Unicode escapes must be \\uXXXX or \\UXXXXXXXX."),
							 lexer_errposition()));
				}
	YY_BREAK
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 718 "scan.l"
{
					if (yytext[1] == '\'')
					{
						if (yyextra->backslash_quote == BACKSLASH_QUOTE_OFF ||
							(yyextra->backslash_quote == BACKSLASH_QUOTE_SAFE_ENCODING &&
							 PG_ENCODING_IS_CLIENT_ONLY(pg_get_client_encoding())))
							ereport(ERROR,
									(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
									 errmsg("unsafe use of \\' in a string literal"),
									 errhint("Use '' to write quotes in strings. \\' is insecure in client-only encodings."),
									 lexer_errposition()));
					}
					check_string_escape_warning(yytext[1], yyscanner);
					addlitchar(unescape_single_char(yytext[1], yyscanner),
							   yyscanner);
				}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 734 "scan.l"
{
					unsigned char c = strtoul(yytext + 1, NULL, 8);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 742 "scan.l"
{
					unsigned char c = strtoul(yytext + 2, NULL, 16);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 750 "scan.l"
{
					/* This is only needed for \ just before EOF */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xus):
#line 754 "scan.l"
{ yyerror("unterminated quoted string"); }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 756 "scan.l"
{
					SET_YYLLOC();
					yyextra->dolqstart = pstrdup(yytext);
					BEGIN(xdolq);
					startlit();
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 762 "scan.l"
{
					SET_YYLLOC();
					/* throw back all but the initial "$" */
					yyless(1);
					/* and treat it as {other} */
					return yytext[0];
				}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 769 "scan.l"
{
					if (strcmp(yytext, yyextra->dolqstart) == 0)
					{
						pfree(yyextra->dolqstart);
						yyextra->dolqstart = NULL;
						BEGIN(INITIAL);
						yylval->str = litbufdup(yyscanner);
						yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
						return SCONST;
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						addlit(yytext, yyleng - 1, yyscanner);
						yyless(yyleng - 1);
					}
				}
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 790 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 793 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 796 "scan.l"
{
					/* This is only needed for $ inside the quoted text */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 800 "scan.l"
{ yyerror("unterminated dollar-quoted string"); }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 802 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 807 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xui);
					startlit();
				}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 812 "scan.l"
{
					char	   *ident;

					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					ident = litbufdup(yyscanner);
					if (yyextra->literallen >= NAMEDATALEN)
						truncate_identifier(ident, yyextra->literallen, true);
					yylval->str = ident;
					yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
					return IDENT;
				}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 825 "scan.l"
{
					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					/* can't truncate till after we de-escape the ident */
					yylval->str = litbufdup(yyscanner);
					yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
					return UIDENT;
				}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 834 "scan.l"
{
					addlitchar('"', yyscanner);
				}
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 837 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xui):
#line 840 "scan.l"
{ yyerror("unterminated quoted identifier"); }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 842 "scan.l"
{
					char	   *ident;

					SET_YYLLOC();
					/* throw back all but the initial u/U */
					yyless(1);
					/* and treat it as {identifier} */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
					return IDENT;
				}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 855 "scan.l"
{
					SET_YYLLOC();
					return TYPECAST;
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 860 "scan.l"
{
					SET_YYLLOC();
					return DOT_DOT;
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 865 "scan.l"
{
					SET_YYLLOC();
					return COLON_EQUALS;
				}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 870 "scan.l"
{
					SET_YYLLOC();
					return EQUALS_GREATER;
				}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 875 "scan.l"
{
					SET_YYLLOC();
					return LESS_EQUALS;
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 880 "scan.l"
{
					SET_YYLLOC();
					return GREATER_EQUALS;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 885 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 891 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 897 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 902 "scan.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					SET_YYLLOC();

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
						/*
						 * If what we have left is only one char, and it's
						 * one of the characters matching "self", then
						 * return it as a character token the same way
						 * that the "self" rule would have.
						 */
						if (nchars == 1 &&
							strchr(",()[].;:+-*/%^<>=", yytext[0]))
							return yytext[0];
						/*
						 * Likewise, if what we have left is two chars, and
						 * those match the tokens ">=", "<=", "=>", "<>" or
						 * "!=", then we must return the appropriate token
						 * rather than the generic Op.
						 */
						if (nchars == 2)
						{
							if (yytext[0] == '=' && yytext[1] == '>')
								return EQUALS_GREATER;
							if (yytext[0] == '>' && yytext[1] == '=')
								return GREATER_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '=')
								return LESS_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '>')
								return NOT_EQUALS;
							if (yytext[0] == '!' && yytext[1] == '=')
								return NOT_EQUALS;
						}
					}

					/*
					 * Complain if operator is too long.  Unlike the case
					 * for identifiers, we make this an error not a notice-
					 * and-truncate, because the odds are we are looking at
					 * a syntactic mistake anyway.
					 */
					if (nchars >= NAMEDATALEN)
						yyerror("operator too long");

					yylval->str = pstrdup(yytext);
					return Op;
				}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 1010 "scan.l"
{
					SET_YYLLOC();
					yylval->ival = atol(yytext + 1);
					return PARAM;
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 1016 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 10);
				}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 1020 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 16);
				}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 1024 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 8);
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 1028 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 2);
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 1032 "scan.l"
{
					SET_YYLLOC();
					yyerror("invalid hexadecimal integer");
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 1036 "scan.l"
{
					SET_YYLLOC();
					yyerror("invalid octal integer");
				}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 1040 "scan.l"
{
					SET_YYLLOC();
					yyerror("invalid binary integer");
				}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 1044 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 1049 "scan.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 10);
				}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 1055 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 1060 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 1064 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 1068 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 1072 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 1076 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 1080 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 1084 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 1090 "scan.l"
{
					int			kwnum;
					char	   *ident;

					SET_YYLLOC();

					/* Is it a keyword? */
					kwnum = ScanKeywordLookup(yytext,
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}

					/*
					 * No.  Convert the identifier to lower case, and truncate
					 * if necessary.
					 */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
					return IDENT;
				}
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 1116 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 1121 "scan.l"
{
					SET_YYLLOC();
					yyterminate();
				}
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 1126 "scan.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 6979 "scan.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yy_start_state_list[yyg->yy_start];

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		yy_current_state += yy_current_state[(*yy_cp ? YY_SC_TO_UI(*yy_cp) : 256)].yy_nxt;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */

	int yy_c = 256;
	const struct yy_trans_info *yy_trans_info;

	yy_trans_info = &yy_current_state[(unsigned int) yy_c];
	yy_current_state += yy_trans_info->yy_nxt;
	yy_is_jam = (yy_trans_info->yy_verify != yy_c);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			yy_size_t offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
   


/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */


/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */


/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */


/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */


#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        yy_size_t yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */


/** Get the current line number.
 * @param yyscanner The scanner object.
 */


/** Get the current column number.
 * @param yyscanner The scanner object.
 */


/** Get the input stream.
 * @param yyscanner The scanner object.
 */


/** Get the output stream.
 * @param yyscanner The scanner object.
 */


/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */


/** Get the current token.
 * @param yyscanner The scanner object.
 */



/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */


/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */


/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */








/* Accessor methods for yylval and yylloc */






    

    
/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */


static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */


/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 1126 "scan.l"


/* LCOV_EXCL_STOP */

/*
 * Arrange access to yyextra for subroutines of the main yylex() function.
 * We expect each subroutine to have a yyscanner parameter.  Rather than
 * use the yyget_xxx functions, which might or might not get inlined by the
 * compiler, we cheat just a bit and cast yyscanner to the right type.
 */
#undef yyextra
#define yyextra  (((struct yyguts_t *) yyscanner)->yyextra_r)

/* Likewise for a couple of other things we need. */
#undef yylloc
#define yylloc	(((struct yyguts_t *) yyscanner)->yylloc_r)
#undef yyleng
#define yyleng	(((struct yyguts_t *) yyscanner)->yyleng_r)


/*
 * scanner_errposition
 *		Report a lexer or grammar error cursor position, if possible.
 *
 * This is expected to be used within an ereport() call, or via an error
 * callback such as setup_scanner_errposition_callback().  The return value
 * is a dummy (always 0, in fact).
 *
 * Note that this can only be used for messages emitted during raw parsing
 * (essentially, scan.l, parser.c, and gram.y), since it requires the
 * yyscanner struct to still be available.
 */
int
scanner_errposition(int location, core_yyscan_t yyscanner)
{
	int			pos;

	if (location < 0)
		return 0;				/* no-op if location is unknown */

	/* Convert byte offset to character number */
	pos = pg_mbstrlen_with_len(yyextra->scanbuf, location) + 1;
	/* And pass it to the ereport mechanism */
	return errposition(pos);
}

/*
 * Error context callback for inserting scanner error location.
 *
 * Note that this will be called for *any* error occurring while the
 * callback is installed.  We avoid inserting an irrelevant error location
 * if the error is a query cancel --- are there any other important cases?
 */
static void
scb_error_callback(void *arg)
{
	ScannerCallbackState *scbstate = (ScannerCallbackState *) arg;

	if (geterrcode() != ERRCODE_QUERY_CANCELED)
		(void) scanner_errposition(scbstate->location, scbstate->yyscanner);
}

/*
 * setup_scanner_errposition_callback
 *		Arrange for non-scanner errors to report an error position
 *
 * Sometimes the scanner calls functions that aren't part of the scanner
 * subsystem and can't reasonably be passed the yyscanner pointer; yet
 * we would like any errors thrown in those functions to be tagged with an
 * error location.  Use this function to set up an error context stack
 * entry that will accomplish that.  Usage pattern:
 *
 *		declare a local variable "ScannerCallbackState scbstate"
 *		...
 *		setup_scanner_errposition_callback(&scbstate, yyscanner, location);
 *		call function that might throw error;
 *		cancel_scanner_errposition_callback(&scbstate);
 */
void
setup_scanner_errposition_callback(ScannerCallbackState *scbstate,
								   core_yyscan_t yyscanner,
								   int location)
{
	/* Setup error traceback support for ereport() */
	scbstate->yyscanner = yyscanner;
	scbstate->location = location;
	scbstate->errcallback.callback = scb_error_callback;
	scbstate->errcallback.arg = (void *) scbstate;
	scbstate->errcallback.previous = error_context_stack;
	error_context_stack = &scbstate->errcallback;
}

/*
 * Cancel a previously-set-up errposition callback.
 */
void
cancel_scanner_errposition_callback(ScannerCallbackState *scbstate)
{
	/* Pop the error context stack */
	error_context_stack = scbstate->errcallback.previous;
}

/*
 * scanner_yyerror
 *		Report a lexer or grammar error.
 *
 * The message's cursor position is whatever YYLLOC was last set to,
 * ie, the start of the current token if called within yylex(), or the
 * most recently lexed token if called from the grammar.
 * This is OK for syntax error messages from the Bison parser, because Bison
 * parsers report error as soon as the first unparsable token is reached.
 * Beware of using yyerror for other purposes, as the cursor position might
 * be misleading!
 */
void
scanner_yyerror(const char *message, core_yyscan_t yyscanner)
{
	const char *loc = yyextra->scanbuf + *yylloc;

	if (*loc == YY_END_OF_BUFFER_CHAR)
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: %s is typically the translation of "syntax error" */
				 errmsg("%s at end of input", _(message)),
				 lexer_errposition()));
	}
	else
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: first %s is typically the translation of "syntax error" */
				 errmsg("%s at or near \"%s\"", _(message), loc),
				 lexer_errposition()));
	}
}


/*
 * Called before any actual parsing is done
 */
core_yyscan_t
scanner_init(const char *str,
			 core_yy_extra_type *yyext,
			 const ScanKeywordList *keywordlist,
			 const uint16 *keyword_tokens)
{
	Size		slen = strlen(str);
	yyscan_t	scanner;

	if (yylex_init(&scanner) != 0)
		elog(ERROR, "yylex_init() failed: %m");

	core_yyset_extra(yyext, scanner);

	yyext->keywordlist = keywordlist;
	yyext->keyword_tokens = keyword_tokens;

	yyext->backslash_quote = backslash_quote;
	yyext->escape_string_warning = escape_string_warning;
	yyext->standard_conforming_strings = standard_conforming_strings;

	/*
	 * Make a scan buffer with special termination needed by flex.
	 */
	yyext->scanbuf = (char *) palloc(slen + 2);
	yyext->scanbuflen = slen;
	memcpy(yyext->scanbuf, str, slen);
	yyext->scanbuf[slen] = yyext->scanbuf[slen + 1] = YY_END_OF_BUFFER_CHAR;
	yy_scan_buffer(yyext->scanbuf, slen + 2, scanner);

	/* initialize literal buffer to a reasonable but expansible size */
	yyext->literalalloc = 1024;
	yyext->literalbuf = (char *) palloc(yyext->literalalloc);
	yyext->literallen = 0;

	return scanner;
}


/*
 * Called after parsing is done to clean up after scanner_init()
 */
void
scanner_finish(core_yyscan_t yyscanner)
{
	/*
	 * We don't bother to call yylex_destroy(), because all it would do is
	 * pfree a small amount of control storage.  It's cheaper to leak the
	 * storage until the parsing context is destroyed.  The amount of space
	 * involved is usually negligible compared to the output parse tree
	 * anyway.
	 *
	 * We do bother to pfree the scanbuf and literal buffer, but only if they
	 * represent a nontrivial amount of space.  The 8K cutoff is arbitrary.
	 */
	if (yyextra->scanbuflen >= 8192)
		pfree(yyextra->scanbuf);
	if (yyextra->literalalloc >= 8192)
		pfree(yyextra->literalbuf);
}


static void
addlit(char *ytext, int yleng, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + yleng) >= yyextra->literalalloc)
	{
		yyextra->literalalloc = pg_nextpower2_32(yyextra->literallen + yleng + 1);
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	memcpy(yyextra->literalbuf + yyextra->literallen, ytext, yleng);
	yyextra->literallen += yleng;
}


static void
addlitchar(unsigned char ychar, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + 1) >= yyextra->literalalloc)
	{
		yyextra->literalalloc *= 2;
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	yyextra->literalbuf[yyextra->literallen] = ychar;
	yyextra->literallen += 1;
}


/*
 * Create a palloc'd copy of literalbuf, adding a trailing null.
 */
static char *
litbufdup(core_yyscan_t yyscanner)
{
	int			llen = yyextra->literallen;
	char	   *new;

	new = palloc(llen + 1);
	memcpy(new, yyextra->literalbuf, llen);
	new[llen] = '\0';
	return new;
}

/*
 * Process {decinteger}, {hexinteger}, etc.  Note this will also do the right
 * thing with {numeric}, ie digits and a decimal point.
 */
static int
process_integer_literal(const char *token, YYSTYPE *lval, int base)
{
	ErrorSaveContext escontext = {T_ErrorSaveContext};
	int32		val;

	val = pg_strtoint32_safe(token, (Node *) &escontext);
	if (escontext.error_occurred)
	{
		/* integer too large (or contains decimal pt), treat it as a float */
		lval->str = pstrdup(token);
		return FCONST;
	}
	lval->ival = val;
	return ICONST;
}

static void
addunicode(pg_wchar c, core_yyscan_t yyscanner)
{
	ScannerCallbackState scbstate;
	char		buf[MAX_UNICODE_EQUIVALENT_STRING + 1];

	if (!is_valid_unicode_codepoint(c))
		yyerror("invalid Unicode escape value");

	/*
	 * We expect that pg_unicode_to_server() will complain about any
	 * unconvertible code point, so we don't have to set saw_non_ascii.
	 */
	setup_scanner_errposition_callback(&scbstate, yyscanner, *(yylloc));
	pg_unicode_to_server(c, (unsigned char *) buf);
	cancel_scanner_errposition_callback(&scbstate);
	addlit(buf, strlen(buf), yyscanner);
}

static unsigned char
unescape_single_char(unsigned char c, core_yyscan_t yyscanner)
{
	switch (c)
	{
		case 'b':
			return '\b';
		case 'f':
			return '\f';
		case 'n':
			return '\n';
		case 'r':
			return '\r';
		case 't':
			return '\t';
		default:
			/* check for backslash followed by non-7-bit-ASCII */
			if (c == '\0' || IS_HIGHBIT_SET(c))
				yyextra->saw_non_ascii = true;

			return c;
	}
}

static void
check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner)
{
	if (ychar == '\'')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\' in a string literal"),
					 errhint("Use '' to write quotes in strings, or use the escape string syntax (E'...')."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else if (ychar == '\\')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\\\ in a string literal"),
					 errhint("Use the escape string syntax for backslashes, e.g., E'\\\\'."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else
		check_escape_warning(yyscanner);
}

static void
check_escape_warning(core_yyscan_t yyscanner)
{
	if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
		ereport(WARNING,
				(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
				 errmsg("nonstandard use of escape in a string literal"),
		errhint("Use the escape string syntax for escapes, e.g., E'\\r\\n'."),
				 lexer_errposition()));
	yyextra->warn_on_first_escape = false;		/* warn only once per string */
}

/*
 * Interface functions to make flex use palloc() instead of malloc().
 * It'd be better to make these static, but flex insists otherwise.
 */

void *
core_yyalloc(yy_size_t bytes, core_yyscan_t yyscanner)
{
	return palloc(bytes);
}

void *
core_yyrealloc(void *ptr, yy_size_t bytes, core_yyscan_t yyscanner)
{
	if (ptr)
		return repalloc(ptr, bytes);
	else
		return palloc(bytes);
}



