# 2021-07-27 Triage Log

A very quiet week with only improvements. There was one possible regression, but it was removed from consideration due to only barely impacting a somewhat noisy stress-test benchmark. Untriaged pull requests continue to pile up, but there is still not a good process for dealing with them. 

Triage done by **@rylev**.
Revision range: [5c0ca08c662399c1c864310d1a20867d3ab68027..998cfe5aad7c21eb19a4bca50f05a13354706970](https://perf.rust-lang.org/?start=5c0ca08c662399c1c864310d1a20867d3ab68027&end=998cfe5aad7c21eb19a4bca50f05a13354706970&absolute=false&stat=instructions%3Au)

0 Regressions, 3 Improvements, 0 Mixed; 0 of them in rollups

#### Regressions

Support HIR wf checking for function signatures [#87265](https://github.com/rust-lang/rust/issues/87265)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=7db08eeb0057de86ea2bdbd4c3a085cb8516b653&end=7c89e389d00cfc7e86ae7e1b45880da4f5f5c9f5&stat=instructions:u) (up to 1.1% on `full` builds of `externs-opt`)
- Given that this only impacts the somewhat noisy `externs` stress-test benchmark, it's not clear that we should treat this as an actual regression. 


#### Improvements

 Improve caching during trait evaluation  [#86946](https://github.com/rust-lang/rust/issues/86946)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=32c9b7b091534f6d80e7e85da0cd425acb6c9a79&end=602150f21fd8a9bd3e903039c0d8c008d85aa7f1&stat=instructions:u) (up to -3.7% on `full` builds of `hyper-2-check`)


 Make mir borrowck's use of opaque types independent of the typeck query's result [#87287](https://github.com/rust-lang/rust/issues/87287)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=027187094ee05011d6602f5742f550851ccc7fd6&end=b2b7c859c1aae39d26884e760201f5e6c7feeff9&stat=instructions:u) (up to -1.6% on `full` builds of `deeply-nested-async-check`)


Store all HIR owners in the same container [#83723](https://github.com/rust-lang/rust/issues/83723)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=71a6c7c80398143a67e27b01412f4b2ec12bde8b&end=6489ee10410f7be70dbefad322d1a3e1533ab282&stat=instructions:u) (up to -4.4% on `incr-unchanged` builds of `unicode_normalization-check`)


#### Mixed


#### Untriaged Pull Requests

- [#87244 Better diagnostics with mismatched types due to implicit static lifetime](https://github.com/rust-lang/rust/pull/87244)
- [#86777 Include terminators in instance size estimate](https://github.com/rust-lang/rust/pull/86777)
- [#86698 Move OnDiskCache to rustc_query_impl.](https://github.com/rust-lang/rust/pull/86698)
- [#86588 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/86588)
- [#86034 Change entry point to 🛡️ against 💥 💥-payloads](https://github.com/rust-lang/rust/pull/86034)
- [#84560 Inline Iterator as IntoIterator.](https://github.com/rust-lang/rust/pull/84560)

#### Nags requiring follow up
