8.3 Scales

# Scales

Sonic Pi has support for a wide range of scales. How about
playing a C3 major scale?

```
play_pattern_timed scale(:c3, :major), 0.125, release: 0.1
```

We can even ask for more octaves:

```
play_pattern_timed scale(:c3, :major, num_octaves: 3), 0.125, release: 0.1
```

How about all the notes in a pentatonic scale?

```
play_pattern_timed scale(:c3, :major_pentatonic, num_octaves: 3), 0.125, release: 0.1
```

## Random notes

Chords and scales are great ways of constraining a random choice to
something meaningful. Have a play with this example which picks random
notes from the chord E3 minor:

```
use_synth :tb303
loop do
  play choose(chord(:E3, :minor)), release: 0.3, cutoff: rrand(60, 120)
  sleep 0.25
end
```

Try switching in different chord names and cutoff ranges.

## Discovering Chords and Scales

To find out which scales and chords are supported by Sonic Pi simply
click the Lang button on the far left of this tutorial and then choose
either chord or scale in the API list. In the information in the main
panel, scroll down until you see a long list of chords or scales
(depending on which you're looking at).

Have fun and remember: there are no mistakes, only opportunities.
