/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.AngularDistanceComputer;
import cds.healpix.CompassPoint;
import cds.healpix.ConeOrdinalHashComputer;
import cds.healpix.HashComputer;
import cds.healpix.Healpix;
import cds.healpix.NewtonMethod;
import cds.healpix.VerticesAndPathComputer;
import cds.healpix.common.math.Math;
import java.util.EnumMap;

final class RegularConeOrdinalHashComputer
implements ConeOrdinalHashComputer {
    public static final RegularConeOrdinalHashComputer UI = new RegularConeOrdinalHashComputer();

    private RegularConeOrdinalHashComputer() {
    }

    @Override
    public int computeOrdinalHash(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, long hashCenterAtSmallestDepth, VerticesAndPathComputer verticesComputerAtSmallestDepth, EnumMap<CompassPoint.Cardinal, double[]> vertices, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, long[] result) {
        int resultSize = 0;
        resultSize = Healpix.isLatInNorthPolarCap(coneCenterLatRad) ? this.edgesNEWinNPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, result, resultSize) : (Healpix.isLatInSouthPolarCap(coneCenterLatRad + coneRadiusRad) ? this.edgesNEWinSPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, result, resultSize) : this.edgesNEWinEQR(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, result, resultSize));
        resultSize = Healpix.isLatInNorthPolarCap(coneCenterLatRad - coneRadiusRad) ? this.edgesSEWinNPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, result, resultSize) : (Healpix.isLatInSouthPolarCap(coneCenterLatRad) ? this.edgesSEWinSPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, result, resultSize) : this.edgesSEWinEQR(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, result, resultSize));
        return resultSize;
    }

    private final int edgesNEWinEQR(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, long[] result, int resultSize) {
        double zDxDyEq1 = NewtonMethod.newtonSolveEquatorialZone(java.lang.Math.sin(coneCenterLatRad + coneRadiusRad * 0.9), sinConeCenterLat, twoSineOfHalfConeRadius, false, relativePrecision, nIterMax);
        double latRad = Math.asin(zDxDyEq1);
        if (Healpix.isLatInNorthPolarCap(latRad)) {
            resultSize = this.edgesNEWinNPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, result, resultSize);
        } else if (Healpix.isLatInSouthPolarCap(latRad)) {
            resultSize = this.edgesNEWinSPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, result, resultSize);
        } else {
            double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
        }
        return resultSize;
    }

    private final int edgesSEWinEQR(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, long[] result, int resultSize) {
        double zDxDyEq1 = NewtonMethod.newtonSolveEquatorialZone(java.lang.Math.sin(coneCenterLatRad - coneRadiusRad * 0.9), sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
        double latRad = Math.asin(zDxDyEq1);
        if (Healpix.isLatInNorthPolarCap(latRad)) {
            resultSize = this.edgesSEWinNPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, result, resultSize);
        } else if (Healpix.isLatInSouthPolarCap(latRad)) {
            resultSize = this.edgesSEWinSPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, result, resultSize);
        } else {
            double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
        }
        return resultSize;
    }

    private final int edgesNEWinNPC(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, long[] result, int resultSize) {
        boolean containsNorthPole;
        double coneCenterLonModHalfPi = coneCenterLonRad % 1.5707963267948966;
        boolean bl = containsNorthPole = coneCenterLatRad + coneRadiusRad > 1.5707963267948966;
        if (containsNorthPole) {
            double dCN = 1.5707963267948966 - coneCenterLatRad;
            double d1 = coneRadiusRad + dCN;
            double d2 = coneRadiusRad - dCN;
            double cosL = java.lang.Math.cos(coneCenterLonModHalfPi);
            double sinL = java.lang.Math.sin(coneCenterLonModHalfPi);
            double latStart = 0.5 * (d1 * cosL + d2 * sinL);
            double zStart = java.lang.Math.sin(latStart);
            double zDxDyEq1 = NewtonMethod.newtonSolveNorthPolarCapZone(zStart, true, coneCenterLonModHalfPi - 1.5707963267948966, sinConeCenterLat, twoSineOfHalfConeRadius, false, relativePrecision, nIterMax);
            double latRad = Math.asin(zDxDyEq1);
            double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
            latStart = 0.5 * (d2 * cosL + d1 * sinL);
            zStart = java.lang.Math.sin(latStart);
            zDxDyEq1 = NewtonMethod.newtonSolveNorthPolarCapZone(zStart, false, 1.5707963267948966 + coneCenterLonModHalfPi, sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
            latRad = Math.asin(zDxDyEq1);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
        } else {
            double zStart = java.lang.Math.sin(coneCenterLatRad + coneRadiusRad * 0.9);
            double zDxDyEq1 = NewtonMethod.newtonSolveNorthPolarCapZone(zStart, true, coneCenterLonModHalfPi, sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
            double latRad = Math.asin(zDxDyEq1);
            double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
            if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi + deltaLon <= 1.5707963267948966) {
                result[resultSize++] = hashComputer.hash(coneCenterLonRad + deltaLon, latRad);
            } else {
                zDxDyEq1 = NewtonMethod.newtonSolveNorthPolarCapZone(zStart, true, coneCenterLonModHalfPi - 1.5707963267948966, sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
                latRad = Math.asin(zDxDyEq1);
                deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
                if (Math.isFinite(deltaLon)) {
                    result[resultSize++] = hashComputer.hash(coneCenterLonRad + deltaLon, latRad);
                } else {
                    zDxDyEq1 = NewtonMethod.newtonSolveNorthPolarCapZone(sinConeCenterLat, true, coneCenterLonModHalfPi - 1.5707963267948966, sinConeCenterLat, twoSineOfHalfConeRadius, false, relativePrecision, nIterMax);
                    latRad = Math.asin(zDxDyEq1);
                    deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
                    result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
                }
            }
            zDxDyEq1 = NewtonMethod.newtonSolveNorthPolarCapZone(zStart, false, coneCenterLonModHalfPi, sinConeCenterLat, twoSineOfHalfConeRadius, false, relativePrecision, nIterMax);
            latRad = Math.asin(zDxDyEq1);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
            if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi - deltaLon >= 0.0) {
                result[resultSize++] = hashComputer.hash(coneCenterLonRad - deltaLon, latRad);
            } else {
                zDxDyEq1 = NewtonMethod.newtonSolveNorthPolarCapZone(zStart, false, 1.5707963267948966 + coneCenterLonModHalfPi, sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
                latRad = Math.asin(zDxDyEq1);
                deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
                if (Math.isFinite(deltaLon)) {
                    result[resultSize++] = hashComputer.hash(coneCenterLonRad - deltaLon, latRad);
                } else {
                    zDxDyEq1 = NewtonMethod.newtonSolveNorthPolarCapZone(sinConeCenterLat, false, 1.5707963267948966 + coneCenterLonModHalfPi, sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
                    latRad = Math.asin(zDxDyEq1);
                    deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
                    result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
                }
            }
        }
        return resultSize;
    }

    private final int edgesSEWinNPC(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, long[] result, int resultSize) {
        double coneCenterLonModHalfPi = coneCenterLonRad % 1.5707963267948966;
        double zStart = java.lang.Math.sin(coneCenterLatRad - coneRadiusRad * 0.9);
        double zDxDyEq1 = NewtonMethod.newtonSolveNorthPolarCapZone(zStart, true, coneCenterLonModHalfPi, sinConeCenterLat, twoSineOfHalfConeRadius, false, relativePrecision, nIterMax);
        double latRad = Math.asin(zDxDyEq1);
        double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
        if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi + deltaLon <= 1.5707963267948966) {
            result[resultSize++] = hashComputer.hash(coneCenterLonRad + deltaLon, latRad);
        } else {
            zDxDyEq1 = NewtonMethod.newtonSolveNorthPolarCapZone(sinConeCenterLat, true, coneCenterLonModHalfPi - 1.5707963267948966, sinConeCenterLat, twoSineOfHalfConeRadius, false, relativePrecision, nIterMax);
            latRad = Math.asin(zDxDyEq1);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
        }
        zDxDyEq1 = NewtonMethod.newtonSolveNorthPolarCapZone(zStart, false, coneCenterLonModHalfPi, sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
        latRad = Math.asin(zDxDyEq1);
        deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
        if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi - deltaLon >= 0.0) {
            result[resultSize++] = hashComputer.hash(coneCenterLonRad - deltaLon, latRad);
        } else {
            zDxDyEq1 = NewtonMethod.newtonSolveNorthPolarCapZone(sinConeCenterLat, false, 1.5707963267948966 + coneCenterLonModHalfPi, sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
            latRad = Math.asin(zDxDyEq1);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
        }
        return resultSize;
    }

    private final int edgesSEWinSPC(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, long[] result, int resultSize) {
        boolean containsSouthPole;
        double coneCenterLonModHalfPi = coneCenterLonRad % 1.5707963267948966;
        boolean bl = containsSouthPole = coneRadiusRad - cosConeCenterLat > 1.5707963267948966;
        if (containsSouthPole) {
            double dSC = 1.5707963267948966 + coneCenterLatRad;
            double d1 = coneRadiusRad + dSC;
            double d2 = coneRadiusRad - dSC;
            double cosL = java.lang.Math.cos(coneCenterLonModHalfPi);
            double sinL = java.lang.Math.sin(coneCenterLonModHalfPi);
            double latStart = 0.5 * (d1 * cosL + d2 * sinL);
            double zStart = java.lang.Math.sin(latStart);
            double zDxDyEq1 = -NewtonMethod.newtonSolveNorthPolarCapZone(zStart, true, coneCenterLonModHalfPi - 1.5707963267948966, -sinConeCenterLat, twoSineOfHalfConeRadius, false, relativePrecision, nIterMax);
            double latRad = Math.asin(zDxDyEq1);
            double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
            latStart = 0.5 * (d2 * cosL + d1 * sinL);
            zStart = java.lang.Math.sin(latStart);
            zDxDyEq1 = -NewtonMethod.newtonSolveNorthPolarCapZone(zStart, false, 1.5707963267948966 + coneCenterLonModHalfPi, -sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
            latRad = Math.asin(zDxDyEq1);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
        } else {
            double zStart = java.lang.Math.sin(-coneCenterLatRad + coneRadiusRad * 0.9);
            double zDxDyEq1 = -NewtonMethod.newtonSolveNorthPolarCapZone(zStart, true, coneCenterLonModHalfPi, -sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
            double latRad = Math.asin(zDxDyEq1);
            double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi + deltaLon <= 1.5707963267948966) {
                result[resultSize++] = hashComputer.hash(coneCenterLonRad + deltaLon, latRad);
            } else {
                zDxDyEq1 = -NewtonMethod.newtonSolveNorthPolarCapZone(zStart, true, coneCenterLonModHalfPi - 1.5707963267948966, -sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
                latRad = Math.asin(zDxDyEq1);
                deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
                if (Math.isFinite(deltaLon)) {
                    result[resultSize++] = hashComputer.hash(coneCenterLonRad + deltaLon, latRad);
                } else {
                    zDxDyEq1 = -NewtonMethod.newtonSolveNorthPolarCapZone(-sinConeCenterLat, true, coneCenterLonModHalfPi - 1.5707963267948966, -sinConeCenterLat, twoSineOfHalfConeRadius, false, relativePrecision, nIterMax);
                    latRad = Math.asin(zDxDyEq1);
                    deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
                    result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
                }
            }
            zDxDyEq1 = -NewtonMethod.newtonSolveNorthPolarCapZone(zStart, false, coneCenterLonModHalfPi, -sinConeCenterLat, twoSineOfHalfConeRadius, false, relativePrecision, nIterMax);
            latRad = Math.asin(zDxDyEq1);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
            if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi - deltaLon >= 0.0) {
                result[resultSize++] = hashComputer.hash(coneCenterLonRad - deltaLon, latRad);
            } else {
                zDxDyEq1 = -NewtonMethod.newtonSolveNorthPolarCapZone(zStart, false, 1.5707963267948966 + coneCenterLonModHalfPi, -sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
                latRad = Math.asin(zDxDyEq1);
                deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
                if (Math.isFinite(deltaLon)) {
                    result[resultSize++] = hashComputer.hash(coneCenterLonRad - deltaLon, latRad);
                } else {
                    zDxDyEq1 = -NewtonMethod.newtonSolveNorthPolarCapZone(-sinConeCenterLat, false, 1.5707963267948966 + coneCenterLonModHalfPi, -sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
                    latRad = Math.asin(zDxDyEq1);
                    deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
                    result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
                }
            }
        }
        return resultSize;
    }

    private final int edgesNEWinSPC(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, long[] result, int resultSize) {
        double coneCenterLonModHalfPi = coneCenterLonRad % 1.5707963267948966;
        double zStart = java.lang.Math.sin(-coneCenterLatRad - coneRadiusRad * 0.9);
        double zDxDyEq1 = -NewtonMethod.newtonSolveNorthPolarCapZone(zStart, true, coneCenterLonModHalfPi, -sinConeCenterLat, twoSineOfHalfConeRadius, false, relativePrecision, nIterMax);
        double latRad = Math.asin(zDxDyEq1);
        double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
        if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi + deltaLon <= 1.5707963267948966) {
            result[resultSize++] = hashComputer.hash(coneCenterLonRad + deltaLon, latRad);
        } else {
            zDxDyEq1 = -NewtonMethod.newtonSolveNorthPolarCapZone(-sinConeCenterLat, true, coneCenterLonModHalfPi - 1.5707963267948966, -sinConeCenterLat, twoSineOfHalfConeRadius, false, relativePrecision, nIterMax);
            latRad = Math.asin(zDxDyEq1);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
        }
        zDxDyEq1 = -NewtonMethod.newtonSolveNorthPolarCapZone(zStart, false, coneCenterLonModHalfPi, -sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
        latRad = Math.asin(zDxDyEq1);
        deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
        if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi - deltaLon >= 0.0) {
            result[resultSize++] = hashComputer.hash(coneCenterLonRad - deltaLon, latRad);
        } else {
            zDxDyEq1 = -NewtonMethod.newtonSolveNorthPolarCapZone(-sinConeCenterLat, false, 1.5707963267948966 + coneCenterLonModHalfPi, -sinConeCenterLat, twoSineOfHalfConeRadius, true, relativePrecision, nIterMax);
            latRad = Math.asin(zDxDyEq1);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
        }
        return resultSize;
    }
}

