.\"
.\" these macros are used in addition to the -ms macros.
.so tmac.wrprc
.\"
.\" $(TBL) thisfile | $(TROFF) $(MSMACROS) > output
.\"
.\" revision date - change whenever this file is edited
.ds RD 13 December 1996
.\"
.EH 'WRPRC2 Configuration File Reference'- % -''
.OH ''- % -'WRPRC2 Configuration File Reference'
.OF 'Revision date:\0\0\*(RD''Printed:\0\0\n(dy \*(MO 19\n(yr'
.EF 'Revision date:\0\0\*(RD''Printed:\0\0\n(dy \*(MO 19\n(yr'
.\"
.TL
WRPRC2 imake Configuration File Reference
.AU
Paul DuBois
dubois@primate.wisc.edu
.AI
Wisconsin Regional Primate Research Center
Revision date:\0\0\*(RD
.\"
.LP
This document describes in some detail the contents of the Release 2
WRPRC
.I imake
configuration files.
The first part of this document describes the contents of each of the
configuration files.
The second part discusses various aspects of their use.
A tutorial document is also available that describes how to write Imakefiles
that use the WRPRC2 configuration files.
.\"
.Ah "Imake.tmpl"
.\"
.LP
.I Imake.tmpl
is a template file that defines the
architecture of the configuration files.
It serves to
.Cw #include
the other configuration files in the correct order, as well as the
.I Imakefile
from the current directory, and it adds some default
.I Makefile
target entries.
.I Imake.tmpl
looks like this:
.sp .5v
.\".nr PS \n(PS-2
.\".nr VS \n(VS-2
.ps -2
.vs -2
.TS
box tab (%) ;
l   _   l
l | l | l
l | l | l
l   _   l
l   _   l
l | l | l
l | l | l
l | l | l
l | l | l
l   _   l
l   _   l
l | l | l
l | l | l
l   _   l
l   _   l
l | l | l
l | l | l
l | l | l
l | l | l
l   _   l
l   _   l
l | l | l
l | l | l
l   _   l
l   _   l
l | l | l
l | l | l
l   _   l
l   _   l
l | l | l
l   _   l
l   lw(2.2i)   s .
%
.Cw
%#include <Imake.p-cf>
%#include <Imake.cf>
%
%
%#define BeforeVendorCF
%#include <site.p-def>
%#include <site.def>
%#undef BeforeVendorCF
%
%
%#include ProjectVendorIncludeFile
%#include VendorIncludeFile
%
%
%#define AfterVendorCF
%#include <site.p-def>
%#include <site.def>
%#undef AfterVendorCF
%
%
%#include <Imake.p-params>
%#include <Imake.params>
%
%
%#include <Imake.p-rules>
%#include <Imake.rules>
%
%
%#include INCLUDE_IMAKEFILE
%
.R
%default \fIMakefile\fP target entries
.TE
.br
.\".nr PS \n(PS+2
.\".nr VS \n(VS+2
.vs
.ps
.LP
.Cw Project\%Vendor\%Include\%File
and
.Cw Vendor\%Include\%File
are defined in
.I Imake.cf
as the names of the vendor-specific configuration files appropriate for your
system, e.g.,
.I sun.p-cf
and
.I sun.cf .
.Cw INCLUDE_IMAKEFILE
represents the
.I Imakefile .
.LP
Configuration files are processed in pairs.
The second member of each pair is a file
located in the public configuration directory (e.g.,
.I /usr/local/lib/config/WRPRC2 ),
and is shared among all projects that use the WRPRC2 files.
These shared files define the standard baseline configuration provided by
the WRPRC2 files.
.LP
The first member of each pair is a project-specific file.
When a project has configuration requirements such that it needs to override
(or extend) the baseline information in the public file,
it provides the necessary information in the project-specific
file in its private
.I config
directory under the project root (the root directory of the project
source tree).
To prevent file inclusion errors when a project doesn't provide particular
project-specific files, the public directory also contains
empty dummy copies of these files.
That way, the project provides only those files it needs, and
any it does provide take precedence over the dummy copies.
.LP
The following sections describe primarily the shared files because the default
project-specific files are all empty.
However, when it's likely you may want to override something in the shared
files, that's pointed out.
This means that you create a
.I *.p-*
file in the project's
.I config
directory and put the information there.
You do
.I not
modify the dummy copy in the public configuration file directory.
For instance, if you need to specify HP-specific information for your
project, create
.I hp.p-cf
in your project's
.I config
directory.
Don't modify the
.I hp.p-cf
file in the
.I /usr/local/lib/config/WRPRC2
directory.
.\"
.Ah "Imake.cf"
.\"
.LP
.I Imake.cf
contains vendor blocks that determine the type of system you're using and
define the macros
.Cw Vendor\%Include\%File
and
.Cw Project\%Vendor\%Include\%File
as the names of the vendor-specific configuration files appropriately.
They also define symbols you can test
to determine software and/or hardware type if necessary
(e.g., in an
.I Imakefile ).
.LP
For instance, the Sun vendor block defines the vendor file names as
.I sun.cf
and
.I sun.p-cf .
It defines
.Cw Sun\%Architecture
(meaning the software is SunOS), and, depending on the hardware type,
defines one of the symbols
.Cw Sparc\%Architecture ,
.Cw Sun3\%Architecture ,
or
.Cw i386\%Architecture .
.LP
If you port the WRPRC2 configuration files to a new platform, you must
make sure there's an appropriate vendor block in
.I Imake.cf
and write a vendor file.
.\"
.Ah "site.def"
.\"
.LP
.I site.def
contains site-specific definitions.
This file is the primary candidate for modification when you install the
WRPRC2 files, because you use it to express preferences for parameters such
as your usual directory for installing user programs, etc.
(You leave most of the other configuration files alone.)
.LP
The project-specific file
.I site.p-def
can be used when you want to override parameters on a site-specific basis
for a particular project.
Example:
If
.Cw Local\%Bin\%Dir
is set in
.I site.def
at your site to
.I /usr/local/bin ,
but you want to install programs built by a particular project into your own
.I bin
directory
.I /u/you/bin
instead, you could put the following in the project's
.I site.p-def :
.Ps
#ifndef LocalBinDir
#define LocalBinDir /u/you/bin
#endif
.Pe 0
.\"
.Bh "Overriding Values in site.def"
.\"
.LP
.I site.def
and
.I site.p-def
are each split into two parts, like this:
.Ps
#ifdef BeforeVendorCF
	/* stuff processed before vendor file */
#endif /* BeforeVendorCF
.sp .3v
#ifdef AfterVendorCF
	/* stuff processed after vendor file */
#endif /* AfterVendorCF
.Pe
Definitions are usually added to the
.Cw After\%VendorCF
part of the site files.
However, if you're trying to specify a parameter that's already defined
in a vendor file, a definition in the
.Cw After\%VendorCF
part of a site file will be overridden by the definition in the vendor file.
Consider whether or not this is what you want.
If not, then perhaps you should
specify the parameter in the
.Cw Before\%VendorCF
part of the site file instead.
Alternatively, modify the value in the vendor file.
.\"
.Ah "vendor.cf"
.\"
.LP
Other than
.I Imake.cf ,
files with names of the form
.I *.cf
are vendor-specific files, e.g.,
.I sun.cf ,
.I ultrix.cf ,
.I osf1.cf .
They're used to override the defaults for parameters specified in
.I Imake.params
when those defaults are incorrect.
.LP
A vendor file might also override the default definition of rules specified
in
.I Imake.rules
if rules don't work properly on a given system.
For example,
.I Mips.cf
overrides
.Cw Install\%Man\%File() ,
the rule that installs manual pages.
Under Mips RISC/os, manual pages must be installed already
.I nroff 'ed,
rather than in source form.
So the rule is defined to run the manual page through
.I nroff
and install the result.
An additional complication is that
.I nroff
does not by default come with RISC/os.
Consequently, the rule is defined as a null operation if
.I nroff
isn't present on the system.
.LP
Project-specific
.I *.p-cf
files are usually used when you define new project parameters in
.I Imake.p-params
but need to override defaults for a particular platform.
This is analogous to the way
.I *.cf
files override defaults specified in
.I Imake.params .
.\"
.Ah "Imake.params"
.\"
.LP
This file specifies default values for the general system and
project parameters.
Usually a parameter value is expressed as a
.I cpp
macro set to a default value that can be overridden in vendor or
site files, and a
.I make
variable set to the value of the macro.
For example:
.Ps
#ifndef MvCmd
#define MvCmd mv
#endif
.sp .3v
MV = MvCmd
.Pe
.I Imake.params
contains several kinds of information, described in the following sections.
.\"
.Bh "General System Characteristics, Feature Symbols"
.\"
.LP
This section describes the system type in broad terms and lists some particular
features the system either does or doesn't have.
The symbols
.Cw SystemV
and
.Cw SystemV4
indicate whether or not your system is based on System V Release 2 or 3, or
System V Release 4.
The default for both is
.Cw NO
(i.e., not based on System V at all).
If that is incorrect for your system, override the defaults by defining the
appropriate symbol as
.Cw YES
in the vendor file.
.LP
The
.Cw Has\fIXXX\fP
symbols indicate whether or not your system possesses certain capabilities
or features.
The defaults should be overridden in the vendor file as necessary.
.\"
.Bh "Configuration File and Project Information"
.\"
.LP
The symbols in this section describe the name, location, and release number
of the WRPRC2 configuration files, the name and release number of the
project, and the location of the project's private configuration files.
.LP
.Cw Config\%Root\%Dir
must be the same as the value used by
.I imboot
for the configuration file root directory (the directory under which
sets of configuration files are installed).
Check your copy of
.I imboot
to see where it expects this directory to be.
If
.Cw Config\%Root\%Dir
in
.I Imake.params
is incorrect for your system, override it in
.I site.def .
.LP
The project name and release defaults are meaningless
.Cw no-project-name "" (
and
.Cw 0 ).
Override them in the project's private
.I Imake.p-params
if you want them to be accurate for your project.
.\"
.Bh "General System Layout"
.\"
.LP
This section defines things such as program, library, and administrative
directories.
One set of parameters describes the standard system layout \*- where such
things as libraries, administrative files, user programs, and temporary files
are found or created.
However,
many sites maintain a second set of directories into which locally installed
files are put.
For instance, you may put locally installed libraries and header files into
.I /usr/local/lib
and
.I /usr/local/include .
To accommodate this, another
set of parameters describes the ``local'' system layout.
.LP
In general, when you write Imakefiles, you should use the
local parameters because you can redefine them on a per-project basis
in
.I Imake.p-params
or
.I site.p-def
without changing where the standard system directories are expected to be.
.LP
.Cw Adm\%Dir
.IP
Directory for administrative programs and files.
Default
.I /usr/adm .
.LP
.Cw Bin\%Dir
.IP
The usual user program directory, default
.I /usr/bin .
.LP
.Cw Etc\%Dir
.IP
Directory for servers and system maintenance tools.
Default
.I /usr/etc ;
likely override value
.I /etc .
.LP
.Cw Include\%Root
.IP
Top of system include file hierarchy.
Default
.I /usr/include .
.LP
.Cw Lint\%Lib\%Dir
.IP
Directory for lint libraries.
Default
.I /usr/lib/lint .
.LP
.Cw Tmp\%Dir
.IP
Directory for creation of temporary files.
Default
.I /tmp ;
likely override values are
.I /usr/tmp
or
.I /var/tmp .
.LP
.Cw UsrLibDir
.IP
Directory for libraries and library files.
Default
.I /usr/lib .
.LP
.Cw LocalRootDir
.br
.Cw LocalAdmDir
.br
.Cw LocalBinDir
.br
.Cw LocalEtcDir
.br
.Cw LocalIncludeRoot
.br
.Cw LocalLintLibDir
.br
.Cw LocalUsrLibDir
.IP
Local directories corresponding to standard system directories.
.Cw Local\%Root\%Dir
is the root of the local directory hierarchy.
The others are defined in terms of it, so
you can move all of them by redefining it.
To move just some of them, redefine individual
.Cw Local\%\fIXXX\fP\%Dir
parameters.
If you want to make these directories
equivalent to the corresponding standard system directories, define
.Cw Local\%Bin\%Dir
as
.Cw $(BINDIR) ,
.Cw Local\%Usr\%Lib\%Dir
as
.Cw $(USRLIBDIR) ,
etc.
.\"
.Bh "Manual Page Directory Layout"
.\"
.LP
The parameters in this section define the layout of the manual page
hierarchy on your system.
In the simplest (default) case, this consists simply of the
.I man?
directories under
.I /usr/man .
Some systems are more complex; see
.I Mips.cf
for an example.
.LP
.Cw Man\%Root
defines the root of the manual page hierarchy.
.Cw Man\%Source\%Path
defines the name used to construct manual page section directories.
The names of the individual directories are constructed by concatenating
.Cw Man\%Source\%Path
with a suffix.
The suffixes are given by the
.Cw Man?Suffix
parameters, and the directory names are given by the
.Cw Man?Dir
parameters, where
.I ?
is 1, 2, 3, 4, 5, 6, 7, 8,
.I l
(el), or
.I n .
The parameters
.Cw Man\%Suffix
and
.Cw Man\%Dir
indicate the ``usual'' suffix and directory (where user program manual
pages are typically installed on your system.
.LP
There is no
.Cw Local\%Man\%Root ,
just
.Cw Man\%Root .
This is because the manual page hierarchy already includes sections for local
stuff
.I manl "" (
and
.I mann ).
On the other hand, you may want to install local
stuff into an entirely separate manual page hierarchy, e.g., under
.I /usr/local/man .
If so, override
.Cw Man\%Root
in
.I site.def
and set
.Cw Man\%Suffix
to
.Cw $(MANSUFFIX) .
.\"
.Bh "Programs and Flags"
.\"
.LP
This section defines parameters for programs like the C compiler, the loader,
.I rm ,
etc., and flags that they use.
.LP
The complexity of
.Cw CFLAGS
is worthy of note; its structure is discussed a bit in the section
"The Program-Building Model."
.\"
.Bh "Installation Support"
.\"
.LP
This section defines parameters for installing various kinds of files.
.Cw Install\%Cmd
is the name of the program for installing things.
By default it's
.I install .
That's suitable if your
.I install
is the BSD version,
but if you have a System V
.I install ,
.Cw Install\%Cmd
is overridden as
.I bsdinst
or
.I install.sh
(shell scripts that emulate BSD behavior).
.LP
The other installation parameters define install flags and combinations of
flags.
The single flags are listed below.
These are all
.I cpp
macros and all have corresponding uppercase
.I make
variables.
.LP
.Cw InstCopy
.IP
Flag for whether to copy file without removing original.
Default is
.I \-c ;
override as the empty value if you want originals removed.
This takes less disk space, but forces more rebuilds after install
operations.
.LP
.Cw InstStrip
.IP
Flag for stripping executable binaries.
Default is
.I \-s ;
override as the empty value if you don't want binaries stripped (which
takes more space, but allows better debugging).
.LP
.Cw InstOwner
.br
.Cw InstGroup
.IP
Owner and group names of installed files.
The defaults are empty, since it's hard to choose good default ownerships
that make sense across different systems.
If you want files to be owned by a particular user or group, override the
defaults.
Note that you must include the
.I \-o
or
.I \-g
options with the name if you specify non-empty values:
.Ps
#ifndef InstOwner
#define InstOwner -o \f(CIname\fP
#endif
#ifndef InstGroup
#define InstGroup -g \f(CIname\fP
#endif
.Pe
Also note that ownership specifications likely will be ineffective if you're not
.I root
when you install files.
.LP
.Cw InstProgMode
.br
.Cw InstUidProgMode
.br
.Cw InstGidProgMode
.br
.Cw InstUGidProgMode
.br
.Cw InstScriptMode
.br
.Cw InstLibMode
.br
.Cw InstDatMode
.br
.Cw InstManMode
.br
.Cw InstIncMode
.IP
Mode flags for installing programs, setuid programs, setgid programs,
setuid/setgid programs, executable scripts, libraries, data
(non-executable)
files, manual pages, and include (header) files.
Installation of setuid and/or setgid programs may be ineffective
unless you are
.I root
if you are not the installed owner and/or group.
.LP
The parameters below specify combinations of flags and
provide a convenience notation for concatenating common groups of flags.
All of them reference
.Cw INST\%OWNER
and
.Cw INST\%GROUP ,
and all the flags for executable binaries reference
.Cw INST\%STRIP .
In addition, each references a mode parameter for the appropriate type of
file.
.LP
.Cw InstProgFlags
.br
.Cw InstUidProgFlags
.br
.Cw InstGidProgFlags
.br
.Cw InstUGidProgFlags
.br
.Cw InstScriptFlags
.br
.Cw InstLibFlags
.br
.Cw InstDatFlags
.br
.Cw InstManFlags
.br
.Cw InstIncFlags
.IP
Installation flags for installing programs, setuid programs, setgid programs,
setuid/setgid programs, executable scripts, libraries, data
(non-executable)
files, manual pages, and include (header) files.
.\"
.Bh "Document Preparation"
.\"
.LP
This section defines parameters for programs used to format documents,
such as
.I troff ,
.I tbl ,
and
.I soelim ,
and parameters for common
.I troff
macro packages.
.\"
.Bh "WRPRC Libraries"
.\"
.LP
At WRPRC, several locally-developed libraries are commonly used to build
programs.
The WRPRC2 configuration files provide link and dependency specifiers for
them.
The following table lists
the specifiers provided by the WRPRC2 configuration files.
For every library
.Ci XXX ,
there is an
.Ci XXX\f(CWLib\fP
variable for link purposes and a
.Ci \f(CWDep\fPXXX\f(CWLib\fP
variable for dependency purposes.
There are
.I make
variables corresponding to each of these, which is what you refer to in
Imakefiles.
.br
.ne 1.5i
.ps -1
.vs -1
.TS
tab(:);
lfB | lfB | lfB
lfB | lfB | lfB
l | lfCW | lfCW .
Library:Link:Dependency
Name:Specifier:Specifier
_
\fIrefer\fP record manipulation library:BibStuffLib:DepBibStuffLib
Exception and termination manager library:EtmLib:DepEtmLib
Form processing library:FplLib:DepFplLib
Form query library:FqlLib:DepFqlLib
GECOS library:GecosLib:DepGecosLib
Simple log manager library:LogMgrLib:DepLogMgrLib
Simple memory manager library:MemMgrLib:DepMemMgrLib
Network database service library:NdsLib:DepNdsLib
Network I/O library:NioLib:DepNioLib
Order processing library:OrderLib:DepOrderLib
Sequence number library:SeqNumLib:DepSeqNumLib
Simple screen-management library:SimScrLib:DepSimScrLib
Temporary file manager library:TfmLib:DepTfmLib
Token scanning library:TsLib:DepTsLib
_
.TE
.vs +1
.ps +1
.sp .5v
By default, the link specifiers are of the form
.I \-lname
and the dependency specifiers are empty.
This reflects the assumption that all the libraries are installed in a system
directory (e.g.,
.Cw LOCAL\%USR\%LIB\%DIR )
on your machine.
If you have a project that builds one of these libraries, you'll notice that
it has an
.I Imake.p-params
file that overrides the specifiers for that particular library to point into
the project tree.
That's because the project can't assume the library is installed, and if
it also builds applications that use the library, it must find the library
within the project.
.LP
You'll also notice that the link specifier includes a reference to
.Cw LOADER\%LIB\%PREFIX .
Link libraries are typically specified in one of two ways, either by
pathname or using
.I \-l
notation (e.g.,
.I \-lmylib ).
When a library is specified using a pathname, on most
systems the pathname is sufficient.
However, on Cray systems running UNICOS, it's necessary to use
.I \-l
even for libraries specified by pathname.
Thus, to write a reference to a library specified by pathname, you write it
like this:
.Ps
$(LOADERLIBPREFIX)$(TOP)/lib/libmylib.a
.Pe
The variable
.Cw LOADER\%LIB\%PREFIX
gets its value from the
macro
.Cw Loader\%Lib\%Prefix ,
which is normally empty.
The default reflects that no prefix to the pathname is necessary in most
cases.
But
.I cray.cf
defines the macro as
.I \-l
so the proper flag precedes the path.
This is a good example of how the exigencies of one kind of system can affect
the way you write configuration files.
.\"
.Ah "Imake.rules"
.\"
.LP
The main function of
.I Imake.rules
is to define macros that generate
.I Makefile
target entries.
.LP
One motif that appears throughout the WRPRC2 rules is the implementation
of rules in terms of other rules.
One form of this is the construction of a rule as a concatentation of
invocations of other rules.
Another form is the implementation of groups of similar rules in terms of
a single underlying general-purpose rule.
An example of rule concatenation is
.Cw Build\%Program() ,
which invokes
.Cw All\%Target() ,
.Cw Remove\%Target() ,
.Cw Stuff\%To\%Clean() ,
and
.Cw Lint\%Sources() .
An example of use of a general-purpose rule is
.Cw Install\%Man\%File() ,
which provides a general interface to manual page installation.
All the other man page installation rules are defined in terms of
.Cw Install\%Man\%File() .
.LP
The reasons this technique is used so much are:
(i) to avoid writing a construct as the same literal text over and over when
a rule is simpler to invoke;
(ii) when a bug is found in a construct, it's easier to fix the rule that
generates it than to fix multiple literal instances of the text;
(iii) it's easier to change the behavior of rules that use the construct
(e.g., by providing an alternate definition in a vendor file).
.\"
.Bh "Non-Rule Macros"
.\"
.LP
.I Imake.rules
defines some macros which are not rules.
.LP
.Cw NullArg
.IP
This macro evaluates to nothing.
Use it in rule invocations to specify an empty argument.
(Don't just leave an argument empty, because some
.I cpp 's
complain or fail when an argument is expected but none is specified.)
.LP
.Cw NullParameter
.IP
Like
.Cw Null\%Arg ;
provided to satisfy X11 habits.
.LP
.Cw DirFailPrefix
.IP
This macro is normally empty, but may be defined as
.Cw -
for those
systems which have a shell that doesn't evaluate the following constructs
properly:
.Ps
if [ -d ] ...
if [ ! -d ] ...
.Pe
Normally
.Cw Dir\%Fail\%Prefix
is defined in vendor files as necessary, and is not of concern to the
.I Imakefile
writer.
.\"
.Bh "Rule Macros"
.\"
.LP
Rules are listed by sections, paralleling the layout by which
.I Imake.rules
is organized.
Within sections, rules are described in the order they appear within
.I Imake.rules ,
rather than alphabetically.
.\"
.Bh "Directory-Making Rules"
.\"
.LP
.Cw MakeDir(\f(CIdir\fP)
.IP
.Cw MakeDir()
generates commands to
check whether the given directory exists and to create it if not.
This rule is used tab-indented as a command line; it's
usually used within other rule definitions, rather than
in Imakefiles.
.LP
.Cw MakeDirectories(\f(CItarget,dirs\fP)
.IP
This rule generates a target entry
.Ci target
that creates the named directories if they don't exist.
Unlike
.Cw Make\%Dir() ,
the rule may be used standalone, so it's suitable for use in Imakefiles.
.\"
.Bh "Rules for Building Executable Programs"
.\"
.LP
.Cw BuildProgram(\f(CIprog,srcs,objs,linklibs,deplibs\fP)
.IP
.Cw BuildProgram()
is the general interface for building programs.
It generates entries to build, remove, and
lint a single program, and it may be invoked multiple times in the same
.I Imakefile .
.sp .5v
.Ci prog
is the program name,
.Ci srcs
and
.Ci objs
list the program's source and object files,
.Ci linklibs
lists the libraries needed to link the program, and
.Ci deplibs
lists the libraries to check as dependencies.
Dependency libraries must be given as pathnames.
.sp .5v
.Cw BuildProgram()
produces several targets.
A
.Ci prog
target builds the program.
An
.Cw all
target builds the program and any others in the
.I Imakefile .
A
.Cw clean
target removes the program and cleans up,
.Cw lint.\f(CIprog\fP
.I lint 's
the sources for
.Ci prog ,
and
.Cw lint
.I lint 's
the sources for all programs in the
.I Imakefile .
.LP
.Cw BuildSimpleProgram(\f(CIname,linklibs,deplibs\fP)
.IP
.Cw BuildSimpleProgram()
is a simplified version of
.Cw BuildProgram()
that makes a number of assumptions, namely that you want to build a single
program consisting of a single source file
.Ci name\fI.c\fP ,
that the manual page, if there is one, is named
.Ci name\fI.man\fP ,
and that you want to install the
program in
.Cw LOCAL\%BIN\%DIR
and the manual page in
.Cw MAN\%DIR .
.Cw link\%libs
and
.Cw dep\%libs
are as for
.Cw Build\%Program() .
.sp .5v
.Cw BuildSimpleProgram()
sets the
.I make
variables
.Cw SRCS
and
.Cw OBJS ,
invokes
.Cw Build\%Program() ,
as well as installation and manpage installation rules,
and invokes
.Cw Depend\%Target() .
.sp .5v
.Cw BuildSimpleProgram()
may be invoked only once per
.I Imake\%file ,
and should not be used with any other program or library-building rules.
.sp .5v
If you want to install the program in a different directory, you can
assign a different value to
.Cw LOCAL\%BIN\%DIR
in the
.I Imake\%file :
.Ps
LOCALBINDIR = /some/other/directory
.sp .3v
BuildSimpleProgram(prog,NullArg,NullArg)
.Pe 0
.LP
.Cw SpecialObjectTarget(\f(CIdst,src,flags,depends\fP)
.IP
This rule allows you to specify special flags for compiling a particular
object file.
.Ci dst
is the object file name,
.Ci src
is the source file name,
.Cw flags
is the special flags to use when compiling it,
and
.Ci depends
is any special dependencies for
.Ci obj
(other than
.Ci src ).
.LP
.Cw SpecialCObjectTarget(\f(CIbasename,flags,depends\fP)
.IP
This rule allows you to specify special flags for compiling a particular
object file from a C source file.
.Ci basename
is the object file basename (no extension),
.Cw flags
is the special flags to use when compiling it,
and
.Ci depends
is any special dependencies for the object files
.Ci obj
(other than then source file).
.Cw Special\%CObject\%Target()
determines the name of the source file as
\f(CIbasename\f(CW.c\fR
and the name of the object file using the suffix appropriate
for your system (e.g.,
.Cw \&.o
for UNIX and
.Cw \&.obj
for Windows NT.
.\"
.Bh "Library-Building Rules"
.\"
.LP
The WRPRC2 rules support only ``normal'' (static) libraries;
there is no support for shared, debugging, or profiled libraries.
.LP
.Cw NormalLibraryObjectRule()
.IP
This rule redefines the
.I .c
\(->
.I .o
transformation
.I make
uses to compile C source files for building objects in libraries.
It should be invoked exactly once in any
.I Imakefile
in which you invoke
.Cw BuildNormalLibrary() .
Since this rule may change the default transformation,
it's best not to build programs and libraries in the same directory.
.LP
.Cw BuildNormalLibrary(\f(CIname,srcs,objs\fP)
.IP
.Cw BuildNormalLibrary()
generates a target entry to build a library from
the named object files.
When you use it, invoke
.Cw Normal\%Library\%Object\%Rule()
as well.
.sp .5v
.Ci name
is the library basename (e.g., for a library
.I libxxx.a ,
the basename is
.I xxx ).
.Ci srcs
and
.Ci objs
list the library's source and object files.
.sp .5v
A
.Cw lib\f(CIname\fP.a
target is produced that builds the library.
An
.Cw all
target builds all libraries in the
.I Imake\%file .
A
.Cw clean
target cleans up.
.Cw lint.lib\f(CIname\fP.a
and
.Cw lint
targets lint the sources for the
.Ci name
library and all libraries in the
.I Imakefile ,
respectively.
.LP
.Cw BuildLintLibrary(\f(CIname,srcs\fP)
.IP
Build a
.I lint
library for the given library based on the given source files.
.Ci srcs
should name the same file as the
.Ci srcs
argument to
.Cw Build\%Normal\%Library() .
.sp .5v
Generates
.Cw llib-l\f(CIname\fP.ln
and
.Cw lintlib
targets that build the
.Ci name
.I lint
library and
.I lint
library for all libraries in the
.I Imakefile ,
respectively, and a
.Cw clean
target to clean up.
.\"
.Bh "Rules for Building Targets by Running Templates through Filters"
.\"
.LP
The WRPRC2 rules allow you to generate files from templates by running them
through some filter program to process the template.
The filter may be arbitrary, but for convenience, rules are provided that
assume either
.I msub
or
.I cpp
as the filter.
.LP
The output file may be either executable (i.e., scripts) or non-executable.
Executable scripts may be produced that, when run, are executed by an
arbitrary script processor (not just the shell).
.LP
For all the rules,
.Ci dst
is the target file to produce,
.Ci src
is the input template, and
.Ci deps
names any dependencies that must exist before processing the template.
For those rules that take a
.Ci filter
argument, it's the filter program that should process the template.
For those rules that take a
.Ci prog
argument, it's the processor that executes the output script when it's
run.
.Ci prog
must be a full pathname.
.LP
Rules that build executable scripts act differently according to whether
.Cw Has\%Execable\%Scripts
is
.Cw YES
or
.Cw NO .
If it's
.Cw YES ,
the rule writes a line like this at the beginning of the script, where
.Ci prog
is the script processor:
.Ps
#!\f(CIprog\fP
.Pe
If
.Cw Has\%Execable\%Scripts
is
.Cw NO ,
the rule writes a shell script that writes your script to a temporary file,
passes the file to the script processor as a separate command, and removes
the file.
This means the script template
contains no
.Cw #!
line at the beginning.
It's added if necessary by the rule that generates the script.
(This contrasts, for instance, with the X11 rules to generate scripts from
.I cpp
templates.
For those rules, the
.Cw #!
line must be present in the template and is removed if necessary.)
.\"
.LP
.Cw FileFromTemplate(\f(CIdst,src,filter,deps\fP)
.IP
Produce a non-executable file from a template.
.LP
.Cw ScriptFromTemplate(\f(CIprog,dst,src,filter,deps\fP)
.IP
Produce an executable script from a template.
.LP
.Cw FileFromMsubTemplate(\f(CIdst,src,deps\fP)
.IP
Produce a non-executable file from a template, assuming
.I msub
as the filter program.
.LP
.Cw ScriptFromMsubTemplate(\f(CIprog,dst,src,deps\fP)
.IP
Produce an executable script from a template, assuming
.I msub
as the filter program.
.LP
.Cw ShScriptFromMsubTemplate(\f(CIdst,src,deps\fP)
.IP
Produce an executable script from a template, assuming
.I msub
as the filter program and the shell as the script processor.
.LP
.Cw ScriptFromMsubTemplateWithFlags(\f(CIprog,dst,src,flags,deps\fP)
.br
.Cw ShScriptFromMsubTemplateWithFlags(\f(CIdst,src,flags,deps\fP)
.IP
Like
.Cw Script\%From\%Msub\%Template()
and
.Cw ShScript\%From\%Msub\%Template() ,
but these rules allow you to specify flags that are passed to
.I msub .
This is useful when you want to redefine the variable reference delimiters that
.I msub
recognizes.
(See the
.I msub
manual page.)
.LP
.Cw FileFromCppTemplate(\f(CIdst,src,defs,deps\fP)
.IP
Produce a non-executable file from a template, assuming
.I cpp
as the filter program.
.Ci defs
contains any
.I \-D 's
or
.I \-U 's
you want to pass to
.I cpp .
.LP
.Cw ScriptFromCppTemplate(\f(CIprog,dst,src,defs,deps\fP)
.IP
Produce an executable script from a template, assuming
.I cpp
as the filter program.
.Ci defs
is as for
.Cw File\%From\%Cpp\%Template() .
.LP
.Cw ShScriptFromCppTemplate(\f(CIdst,src,defs,deps\fP)
.IP
Produce an executable script from a template, assuming
.I cpp
as the filter program and the shell as the script processor.
.Ci defs
is as for
.Cw File\%From\%Cpp\%Template() .
.\"
.Bh "Miscellaneous Target-Building Rules"
.\"
.LP
.Cw BuildFakeFile(\f(CItarget\fP)
.IP
Generates a target entry that simply announces that target isn't built.
.LP
.Cw LinkTarget(\f(CItarget,linkto\fP)
.IP
Generates a target entry
.Ci target
that creates a link
.Ci target
to the file
.Ci linkto .
.LP
.Cw FileFromIntermediary(\f(CIdst,inter,src\fP)
.IP
Generates
.Ci inter
from
.Ci src ,
then updates
.Ci dst
if
.Ci dst
differs from
.Ci inter
or doesn't exist.
Otherwise does not update
.Ci dst .
(See also the
.Cw Update\%If\%Changed()
rule.)
.LP
.Cw SimpleWorldTarget(\f(CIproject,release\fP)
.IP
Generates a simple
.Cw World
target entry so that you can say
.I make
.I World
to build your entire project from scratch.
Used only in the
.I Imakefile
in the project's root.
.sp .5v
The
.Cw World
target is preceded by an empty
.Cw all
target so that
.Cw all
rather than
.Cw World
is the default target if no other rule precedes
.Cw Simple\%World\%Target()
in the
.I Imakefile
(which might be the case for a multiple-directory project).
.sp .5v
Caveat:
This rule uses a simple configure-clean-depend-build model of project
building.
If your project has any special requirements, you'll probably need to write
your own
.Cw World
entry.
.\"
.Bh "Installation Rules"
.\"
.LP
Generally, the installation rules make use of the
.Cw INST*FLAGS
parameters, although there is no requirement for this.
You can invoke
.Cw Install\%File()
and pass it any set of flags you want, e.g., for a
.I root "" setuid-
program, you can write this:
.Ps
InstallFile(install,myprog,myprog,$(LOCALETCDIR),-o root $(INSTUIDMODE) $(INSTSTRIP))
.Pe
See the section that describes the
.I Imake.params
file for a discussion of the installation parameters that are available.
.LP
For all installation rules, the destination directory is created if it doesn't
exist.
That means if you're in any doubt about where targets will be installed,
it's prudent to run
.I make
.I \-n
.I install
(or
.I make
.I \-n
.I install.man )
before you run
.I make
.I install
(or
.I make
.I install.man ).
.LP
.Cw InstallFile(\f(CItarget,dstfile,srcfile,dir,flags\fP)
.IP
This rule is the general interface for installing files other than manual
pages.
Most other installation rules are trivial and simply invoke
.Cw Install\%File()
with arguments appropriate for different types of files.
.sp .5v
.Ci target
is the name of the target to produce, typically
.Cw install .
.Ci dstfile
is the name of the installed file,
.Ci srcfile
is the name of the file to install,
.Ci dir
is the directory in which to install the file, and
.Ci flags
is the installation flags.
.sp .5v
Besides the
.Ci target
target, an
.Ci \f(CWi.\fPdstfile
target is generated so that you can install individual files.
Typically
.Ci target
is
.Cw install
so that
.I make
.I install
installs everything.
.sp .5v
Generally,
.Ci dstfile
and
.Ci srcfile
are identical.
Two parameters are provided so you can install a file and rename it at the
same time if you want.
However, none of the rules in
.I Imake.rules
do so.
You can provide such a rule in
.I Imake.p-rules
if your project requires it.
.LP
.Cw InstallProgram(\f(CIfile,dir\fP)
.IP
Install an executable (binary) program.
.LP
.Cw InstallUidProgram(\f(CIfile,dir\fP)
.IP
Install a setuid executable (binary) program.
.LP
.Cw InstallGidProgram(\f(CIfile,dir\fP)
.IP
Install a setgid executable (binary) program.
.LP
.Cw InstallUGidProgram(\f(CIfile,dir\fP)
.IP
Install a setuid/setgid executable (binary) program.
.LP
.Cw InstallScript(\f(CIfile,dir\fP)
.IP
Install an executable script.
Differs from
.Cw Install\%Program()
in that the flag for stripping binaries isn't passed to
.I install .
Some versions of
.I install
complain if they're told to strip non-binary executables.
.LP
.Cw InstallDataFile(\f(CIfile,dir\fP)
.IP
Install a non-executable file.
.LP
.Cw InstallIncludeFile(\f(CIfile,dir\fP)
.IP
Install a C header file.
.LP
.Cw InstallLibrary(\f(CIname,dir\fP)
.IP
Install a library (as
.Ci \fIlib\fPname\fP.a ),
and run
.I ranlib
on the installed image if you have it on your system.
.LP
.Cw InstallLintLibrary(\f(CIname,dir\fP)
.IP
Install a
.I lint
library (as
.Ci \fIllib-l\fPname\fP.a ).
Generates targets
.Cw install.lint
and
.Cw i.llib-l\f(CIname\fP.a .
The former installs all
.I lint
libraries in the directory, the latter installs only
.Ci \fIllib-l\fPname\fP.a .
.LP
.Cw InstallLink(\f(CItarget,linkto,dir\fP)
.IP
Make a link from
.Ci dir/target
to
.Ci dir/linkto .
.LP
.Cw InstallMultipleDataFiles(\f(CItarget,files,dir\fP)
.IP
Install a set of non-executables named by
.Ci files
into
.Ci dir .
.Ci target
is the name of the target entry, usually
.Cw install .
.\"
.Ch "Rules for Installing Manual Pages"
.\"
.LP
.Cw InstallManFile(\f(CItarget,name,dstsuffix,dir\fP)
.IP
This is the general interface for manual page installation.
.Cw target
is the name of the target entry, usually
.Cw install.man .
In addition, an
.Cw i.\f(CIname\fP.man
entry is generated so you can install individual manual pages.
.Ci name
is the name of the manual page.
The manual page file must end with a
.I .man
suffix, but you specify the name in the rule without the suffix.
.Ci dstsuffix
is the suffix to be given to the installed manual page.
.Ci dir
is the directory in which to install the manual page.
It's created if it doesn't exist.
.LP
.Cw InstallMan1Page(\f(CIfile\fP)
.br
.Cw InstallMan2Page(\f(CIfile\fP)
.br
.Cw InstallMan3Page(\f(CIfile\fP)
.br
.Cw InstallMan4Page(\f(CIfile\fP)
.br
.Cw InstallMan5Page(\f(CIfile\fP)
.br
.Cw InstallMan6Page(\f(CIfile\fP)
.br
.Cw InstallMan7Page(\f(CIfile\fP)
.br
.Cw InstallMan8Page(\f(CIfile\fP)
.br
.Cw InstallManLPage(\f(CIfile\fP)
.br
.Cw InstallManNPage(\f(CIfile\fP)
.IP
Install a manual page in the section 1, 2, 3, 4, 5, 6, 7, 8,
.I l
(el, for local), or
.I n
directory.
.LP
.Cw InstallManPage(\f(CIfile\fP)
.IP
Install a manual page in the ``usual''
manual page directory.
By default, this is section
.I l
(el),
but may be different at your site.
It's changed by changing the value of
.Cw MAN\%SUFFIX .
.\"
.Ch "Pseudo-Installation Rules"
.\"
.LP
These rules generate
.Cw install
target entries that simply announce the target isn't installed anywhere.
This has the function of making it explicit in the
.I Imake\%file
that the target is not
intended to be installed, and that you didn't just forget to invoke
an installation rule in the
.I Imake\%file .
.LP
.Cw FakeInstallFile(\f(CIfile\fP)
.IP
Generate a fake
.Cw install
target for a file.
Also generates an
.Ci \f(CWi.\fPfile
entry.
.LP
.Cw FakeInstallLibrary(\f(CIname\fP)
.IP
Generate a fake
.Cw install
target for a library.
Also generates an
.Cw i.lib\f(CIname\fP.a
entry.
.\"
.Bh "Rules That Generate Recursive Target Entries"
.\"
.LP
The rules in this section generate target entries that run a given
.I make
operation in a set of subdirectories.
They're convenient for constructing directory-traversing operations.
Executed in a project root, they will traverse the entire project tree.
Executed in some subdirectory of the project, they will traverse the project
subtree under that subdirectory.
.LP
Many of these rules are invoked automatically by the last section of
.I Imake.tmpl
and thus need not be invoked in individual Imakefiles.
.LP
.Cw NamedTargetSubdirs(\f(CIop,dirs,verb,flags\fP)
.IP
This rule is the general interface to recursive entry generation; it's
invoked by most of the other recursive rules to do the work.
.Ci op
is the
.I make
operation to generate a recursive entry for,
.Ci dirs
names the directories to process,
.Ci verb
is the word that
.I make
uses to announce what it's doing as it processes the entry (e.g., ``cleaning'',
``installing''), and
.Ci flags
is any flags that should be passed to
.I make
in subdirectories.
.sp .5v
Note:
The WRPRC version of
.Cw Named\%Target\%Subdirs()
is like the X11 rule of the same name, but has one fewer argument.
.LP
.Cw MakeSubdirs(\f(CIdirs\fP)
.IP
Generate a recursive
.Cw all
target entry for building targets.
.LP
.Cw DependSubdirs(\f(CIdirs\fP)
.IP
Generate a recursive
.Cw depend
target entry for generating header-file dependencies.
.LP
.Cw InstallSubdirs(\f(CIdirs\fP)
.IP
Generate a recursive
.Cw install
target entry for installing programs and other non-manual-page files.
.LP
.Cw InstallManSubdirs(\f(CIdirs\fP)
.IP
Generate a recursive
.Cw install.man
target entry for installing manual pages.
.LP
.Cw CleanSubdirs(\f(CIdirs\fP)
.IP
Generate a recursive
.Cw clean
target entry for removing garbage files.
.LP
.Cw TagSubdirs(\f(CIdirs\fP)
.IP
Generate a recursive
.Cw tags
target entry for generating
.I TAGS
files.
.\"
.Bh "Makefile-Generating Rules"
.\"
.LP
.Cw MakefileTarget()
.IP
Generates a
.Cw Makefile
target entry to rebuild the
.I Make\%file
in the current directory.
This rule invokes
.I imboot ,
which is more portable than generating an
.I imake
command, since
.I imboot
takes care of knowing where the configuration file directories are on
your machine.
As such,
.I make
.I Make\%file
usually works to bootstrap a
.I Make\%file
even when you move a project to a different machine, which would not be
true were the entry to invoke
.I imake
directly.
.LP
.Cw MakefileSubdirs(\f(CIdirs\fP)
.IP
Generate a recursive
.Cw Make\%files
target entry for building Makefiles.
The operation of this is described in a later section.
.\"
.Bh "Document-Formatting Rules"
.\"
.LP
These rules generate target entries that process
.I troff
documents to produce PostScript
files, which reflects my preferred output format.
It would be easy enough to adapt the rules to produce plain text, RTF, etc.,
or to send the output directly to a printer.
.LP
.Cw TROFF\%OPTS
may be set on the
.I make
command line to pass additional options to
.I troff .
For instance, if you want to format only pages 7 through 10 of a document, you
can do this:
.Ps
% make doc.ps "TROFFOPTS=-o7-10"
.Pe
.Cw TroffToPostScript(\f(CIdst,src,formatter,filters,deps\fP)
.IP
This rule is the general interface to document processing.
.Ci dst
is the name of the output file,
.Ci src
is the name of the input file or files,
.Ci formatter
is the formatting program and its options (usually some
.I troff
program),
.Ci filters
names any preprocessors, and
.Ci deps
names any dependencies that must exist before processing the document.
.sp .5v
.Ci filters
can either be
.Cw Null\%Arg
if there are no preprocessors, or else a piece of a command pipeline such
as
.Cw |$(TBL)
or
.Cw |$(TBL)|$(EQN) .
Note the use of the
.Cw |
character; if non-empty,
.Ci filters
must begin with one.
.sp .5v
This rule generates a
.Ci dst
target to produce the formatted output file, and a
.Cw clean
target to remove it.
.LP
.Cw TroffManToPostScript(\f(CIdst,src,filters,deps\fP)
.br
.Cw TroffMeToPostScript(\f(CIdst,src,filters,deps\fP)
.br
.Cw TroffMmToPostScript(\f(CIdst,src,filters,deps\fP)
.br
.Cw TroffMsToPostScript(\f(CIdst,src,filters,deps\fP)
.IP
These rules simply invoke
.Cw Troff\%To\%Post\%Script() ,
passing their arguments to it and adding the appropriate macro package
argument
.I \-man , (
.I \-me ,
.I \-mm ,
or
.I \-ms ).
.\"
.Bh "Odds and Ends"
.\"
.LP
.Cw RemoveTarget(\f(CItarget\fP)
.IP
This rule generates commands to remove the target (a file).
This rule is used tab-indented as a command line; it's
usually used within other rule definitions, rather than
in Imakefiles.
.LP
.Cw RanLibrary(\f(CIargs\fP)
.IP
This rule generates commands to run
.I ranlib
if it exists on your system, or an empty command otherwise.
.Ci args
lists any flags to be passed to
.I ranlib .
This rule is used tab-indented as a command line; it's
usually used within other rule definitions, rather than
in Imakefiles.
.LP
.Cw UpdateIfDifferent(\f(CIdst,src\fP)
.IP
Updates
.Ci dst
from
.Ci src
if
.Ci dst
doesn't exist or is different than
.Ci src .
Otherwise does nothing.
This rule is used tab-indented as a command line; it's
usually used within other rule definitions, rather than
in Imakefiles.
.LP
.Cw StuffToClean(\f(CIstuff\fP)
.IP
This rule generates a
.Cw clean
entry with
.Ci stuff
as the dependency (multiple files may be listed).
It is used in rules that build targets that should be removed when
.I make
.I clean
is executed.
You can invoke it explicitly in your
.I Imakefile
to make sure a given file is removed when the
.Cw clean
operation is performed.
.LP
.Cw AllTarget(\f(CItarget\fP)
.IP
This rule generates an
.Cw all
entry with
.Ci target
as the dependency.
It is used in rules that build targets which should be built when
.I make
.I all
is executed.
It may be used in an
.I Imakefile
to indicate additional targets you want to make sure get built when the
.Cw all
operation is performed.
.LP
.Cw LintSources(\f(CIprog,srcs\fP)
.IP
Generates a
.Cw lint.\f(CIprog\fP
target entry to run the sources for
.Ci prog
through
.I lint .
.Ci srcs
should name the program's source files.
Also generates a
.Cw lint
target entry;
.I make
.I lint
runs
.I lint
for all programs in the
.I Imake\%file .
.LP
.Cw DependTarget()
.IP
Generates a
.Cw depend
target entry to generate header-file dependencies.
.I make
.I depend
should be run after building or rebuilding the
.I Makefile .
.sp .5v
This rule assumes the
.I make
variable
.Cw SRCS
is set to the names of the source files to be processed.
.LP
.Cw CleanTarget()
.IP
Generates a
.Cw clean
target entry to remove garbage files.
This is invoked by
.I Imake.tmpl ,
so you don't need to.
The files that are removed are defined by
.Cw Files\%To\%Clean .
.LP
.Cw TagsTarget()
.IP
Generates a
.Cw tags
target entry to create a
.I TAGS
file.
.LP
.Cw FiFiiSuffixRule()
.IP
Generates a suffix rule describing the transformation used to run
.I figen
to produce a
.I .fii
file from a
.I .fi
file.
You should invoke this one with no arguments in any
.I Imakefile
which builds targets that need
.I .fii
files.
You should also do two other things.
First, make sure that the
.Cw depend
target causes any
.I .fii
files you need to be generated.
You can do that like this:
.Ps
depend:: file1.fii file2.fii ...
.Pe
Second, make sure the
.I .fii
files are removed by
.I make
.I clean :
.Ps
StuffToClean(*.fii)
.Pe 0
.\"
.LP
.Cw HelpAuxTarget(\f(CItarget\fP,\fPdescription\fP)
.IP
The intent of the
.Cw Help\%Aux\%Target()
rule is to help generate Makefiles that are ``self-documenting''
in the sense that the user can run the command:
.Ps
% \f(CBmake help\fP
.Pe
and find out what
.I make
commands build what targets.
.IP
This rule generates a
.Cw help_aux
target entry that prints a message describing the
.I make
command that builds
.Ci target .
For example, the following invocation:
.Ps
HelpAuxTarget(myprog,build the myprog program)
.Pe
generates a target entry that, when
.I make
.I help
is run, prints the message:
.Ps
\&'make myprog' to build the myprog program
.Pe
.Cw Help\%Aux\%Target()
is invoked from within most of the WRPRC2 target-generating rules.
You can use it within your own rules to help users discover how to
build the targets produced by the rules.
.\"
.Ah "How the WRPRC2 MakefileSubdirs() Rule Works"
.\"
.LP
The
.Cw MakefileSubdirs()
rule is the trickiest rule in
.I Imake.rules .
Briefly, it works like this:
for every directory it operates on, it changes from the current directory
(the parent) into the subdirectory (the child), generates a
.I Makefile
there, runs
.I make
.I Makefiles
with the new
.I Makefile
in case the child has subdirectories of its own, then returns to the
parent directory.
.LP
Changing directories is relatively easy.
A
.I cd
changes into the child, and the return to the parent is achieved by enclosing
within parentheses the
.I cd
and the commands that run in the child, so that the commands run in a subshell.
This way the
.I cd
applies only in the subshell and the current directory again becomes the
parent when the subshell terminates.
.LP
The
.I Makefile
in the child is generated by running
.I imboot
and passing to it the values of the project root directory and the current
directory within the project that are correct for the child.
These are derived from the values of
.Cw TOP
and
.Cw CURRENT_DIR
in the parent directory.
If
.Cw TOP
is an absolute path, then the value in the child is the same as the value
in the parent.
However, if
.Cw TOP
is a relative path from the parent to the project root, its value must
be adjusted by prepending the path from the child to the parent.
.LP
The adjustment value is
.Cw ../ '', ``
.Cw ../../ '', ``
.Cw ../../../ '', ``
or
.Cw ../../../../ '', ``
depending on how many levels below the parent the child is located.
The adjustment is determined from how many
.Cw / '' ``
characters are in the subdirectory's
name.
One complication is that if the name begins with
.Cw ./ '', ``
then that
.Cw / '' ``
doesn't count.
.LP
The location of the child within the project is easy to derive.
.Cw CURRENT_DIR
is the location of the parent within the project, so the location of
any child
.I xyz
is
.Cw $(CURRENT_DIR)\fI/xyz\fP .
.LP
Note that child directory names passed to
.Cw MakefileSubdirs()
must be specified as relative paths from the parent or this rule will
not work.
(But it would be absurd to specify them as absolute paths, anyway.)
.LP
The WRPRC2
.Cw MakefileSubdirs()
rule is simpler than its counterpart in X11 Releases 1\-5.
Of course, by using
.I imboot ,
the rule incurs the cost of invoking an additional shell script.
However, some difficulties are avoided.
For example, some alternative approaches are to invoke
.I imake
directly, or to run
.I make
recursively to execute a subsidiary target that itself generates an
.I imake
command.
The success of either approach hinges on getting the values of the
macros
.Cw TOPDIR
and
.Cw CURDIR
set properly in the child so that
.Cw TOP
and
.Cw CURRENT_DIR
are correct.
Conceptually this is no different than figuring out the proper values
of the project root and the current directory to
pass to
.I imboot
in the child, but in practice is more difficult because it involves heavy
interaction between use of
.I make
variables to set
.I cpp
macros and vice-versa.
Using
.I imboot
involves none of this.
An additional complication is that if the
.I imake
command specifies a configuration directory located within the project (i.e.,
specified in terms of
.Cw TOP ),
the
.I \-I
argument giving that location must usually be adjusted, too.
This is ugly because the adjustment value must be inserted into the
middle of the argument.
.LP
An additional simplification gained by using
.I imboot
involves the handling of existing Makefiles.
Typically,
.I Makefile -generating
operations remove any existing
.I Makefile.bak ,
then rename any existing
.I Makefile
to
.I Makefile.bak
before generating a new
.I Makefile .
If the
.I Makefile
target entry generates an
.I imake
command itself, it must also take care of this removing and renaming.
This is unnecessary when
.I imboot
is used instead, since
.I imboot
handles
.I Makefile
and
.I Makefile.bak
itself.
(The X11R5 rule
.Cw Make\%Nsubdir\%Make\%files()
illustrates clearly why you want the removing and renaming stuff in
.I imboot
and not in your
.I Makefile .)
.\"
.Ah "The Program-Building Model"
.\"
.LP
A program is built by compiling its source files, then linking the resulting
object files together (along with any libraries that may be needed) to
produce the final executable.
This section explains the model used by the WRPRC2 files to implement
this process, with particular emphasis on compilation and loader parameters.
.\"
.Bh "Compilation Parameters"
.\"
.LP
The model for compiling C object files looks like this:
.Ps
$(CC) $(CFLAGS) -c file.c
.Pe
The
.I make
variable
.Cw CFLAGS
indicates several types of information, but
you don't set
.Cw CFLAGS
directly.
Instead, you set the parameters that
.Cw CFLAGS
is defined in terms of.
Two types of parameters of general interest are
.I \-I 's
to specify where to look for include files, and
.I \-D 's
and
.I \-U 's
to define or undefine macros.
The configuration parameters for these are shown in the table below.
Mixed-case parameter names are
.I cpp
macros and uppercase names are
.I make
variables.
.sp .5v
.ps -1
.vs -1
.TS
tab(:);
cfB | cfB | cfB | cfB
cfB | cfB | cfB | cfB
l | lfCW | lfCW | lfCW .
Type of:Global:Per-project:Per-Directory
Information:Parameters:Parameters:Parameters
_
Include files:StandardIncludes:ProjectIncludes
\^:STD_INCLUDES:PROJECT_INCLUDES:INCLUDES
_
Defines:StandardDefines:ProjectDefines
\^:STD_DEFINES:PROJECT_DEFINES:DEFINES
_
.TE
.vs +1
.ps +1
.sp .5v
For instance, to specify include file directories, values may be assigned
to the
.I make
variables
.Cw STD_INCLUDES ,
.Cw PROJECT_INCLUDES ,
and
.Cw INCLUDES .
The three parameters are related, but have different functions:
.Ls B
.Li
.Cw STD_INCLUDES
is intended as a global parameter.
It's the most far-reaching and applies to all projects configured with the
WRPRC2 files.
.Cw STD_INCLUDES
gets its value from
.Cw Standard\%Includes ,
which
should be given a default value that's appropriate for your system when you
install the configuration files.
You might, for instance,
keep locally-installed header files under
.Cw LOCAL\%INCLUDE\%ROOT
rather than under the standard include hierarchy root.
This is information that's likely to be needed by many or most projects
compiled on your system.
To make sure that
.Cw \fI\-I\fP$(LOCALINCLUDEROOT)
is passed to all
.I cc
commands that compile source files,
.Cw StandardIncludes
can be written like this:
.Ps
#ifndef StandardIncludes
#define StandardIncludes -I$(LOCALINCLUDEROOT)
#endif
.Pe
That is in fact the default value given in
.I Imake.params
in the WRPRC2 distribution.
If you need to pass other directories in addition to
.Cw LOCAL\%INCLUDE\%ROOT ,
e.g.,
.I /var/include ,
override the default value of
.Cw Standard\%Includes
in
.I site.def :
.Ps
#ifndef StandardIncludes
#define StandardIncludes -I$(LOCALINCLUDEROOT) -I/var/include
#endif
.Pe
Or, if you install local include files in the usual system include hierarchy
(not recommended), you can redefine
.Cw Standard\%Includes
to be empty:
.Ps
#ifndef StandardIncludes
#define StandardIncludes /**/
#endif
.Pe 0
.Li
.Cw PROJECT_INCLUDES
is intended to specify include directories particular to a given project.
It applies in every directory of your project.
Its value comes from
.Cw Project\%Includes ,
which is empty by default.
If necessary, override the default in
.I Imake.p-params
in your project's
.I config
directory.
.sp .5v
For instance, if your project has project-specific
header files in
.I include
under the project root,
you might write something like this to
make sure the directory is passed to all compiler commands for the project:
.Ps
#ifndef ProjectIncludes
#define ProjectIncludes -I$(TOP)/include
#endif
.Pe 0
.Li
.Cw INCLUDES
is intended to specify include directories that are particular to an
individual directory.
You assign it a value directly in the directory's
.I Imakefile :
.Ps
INCLUDES = -I\f(CIsomedir\fP
.Pe 0
.Le
For specifying
.I \-D 's
and
.I \-U 's,
the three parameters
.Cw STD_DEFINES ,
.Cw PROJECT_DEFINES ,
and
.Cw DEFINES
are used.
They're given values in a manner very similar to the way you specify include
directory parameters.
The defaults for the project- and
.I Imakefile -specific
parameters are empty.
The default value of
.Cw Standard\%Defines
is
.Cw -DSYSV
or
.Cw -DSVR4
if your system is SVR2/SRV3 or SVR4, respectively, or empty if it's not based
on System V.
If
.Cw Standard\%Defines
needs to have a value that is different than the default,
it's generally defined in your vendor file when you
install the configuration files, rather than in
.I site.def .
That's because
defines needed on a system-wide basis tend to reflect peculiarities of your
vendor's compiler rather than characteristics of your site's file system layout.
.LP
Parameters for include directories and defines become part of the value of
.Cw CFLAGS .
Since the
.I Imakefile
is most specific, parameters specified in it should have the highest priority.
Conversely, the global parameters are least specific, so parameters
specified there should have the lowest priority.
Project-specific parameters are in between.
.LP
For include directory parameters, earlier
.I \-I 's
on a
.I cc
command take precedence over later ones,
so, within the value of
.Cw CFLAGS ,
include file parameters are ordered like this:
.Ps
$(INCLUDES) $(PROJECT_INCLUDES) $(STD_INCLUDES)
.Pe
On the other hand, later
.I \-D 's
and
.I \-U 's
take precedence over earlier ones, so defines are ordered like this:
.Ps
$(STD_DEFINES) $(PROJECT_DEFINES) $(DEFINES)
.Pe 0
.\"
.Bh "Loader Parameters"
.\"
.LP
The model for linking executable programs looks like this:
.Ps
$(CC) -o prog objects loader-flags link-libraries extra-libraries
.Pe
.Cw prog ,
.Cw objects ,
and
.Cw link-libraries
generally come from the invocation of the rule that builds the program
(e.g., see the
.Cw Build\%Program()
rule).
.Cw loader-flags
and
.Cw extra-libraries
come from the configuration files.
.Ls B
.Li
.Cw loader-flags
specifies any special flags the loader needs in order to produce a final
executable.
For example,
the linker looks for libraries in certain system directories by default.
If you keep local libraries somewhere other than those directories,
you need to specify search directories
for the linker using
.I \-L
arguments.
.Li
.Cw extra-libraries
is used to compensate for compatibility problems or library
deficiencies on your system.
For example, a non-BSD version of UNIX may allow programs that use BSD
functions to be built by providing a BSD compatibility library (accessed,
e.g., as
.I \-lbsd ).
This means on some systems you must add
.I \-lbsd
to the link command.
.sp .5v
.Cw extra-libraries
is not intended to be use for specifying libraries that you know you'll
need on all platforms.
For instance, if you're building a program
.I myprog
using
.Cw Build\%Simple\%Program()
and you know you'll need to link in the ETM library, specify that
like this:
.Ps
BuildSimpleProgram(myprog,$(ETMLIB),$(DEPETMLIB))
.Pe 0
.Le
Like includes and defines, loader flags and extra libraries
may be specified at three levels, as summarized in the following table.
.sp .5v
.ps -1
.vs -1
.TS
tab(:);
cfB | cfB | cfB | cfB
cfB | cfB | cfB | cfB
l | lfCW | lfCW | lfCW .
Type of:Global:Per-project:Per-Directory
Information:Parameters:Parameters:Parameters
_
Loader flags:StandardLoadFlags:ProjectLoadFlags
\^:STD_LDFLAGS:PROJECT_LDFLAGS:LDFLAGS
_
Extra libraries:StandardLoadLibs:ProjectLoadLibs
\^:STD_LDLIBS:PROJECT_LDLIBS:LDLIBS
_
.TE
.vs +1
.ps +1
.sp .5v
Loader
flags are given in the same order as include directories (i.e.,
.I Imakefile -specific
first, global last):
.Ps
$(LDFLAGS) $(PROJECT_LDFLAGS) $(STD_LDFLAGS)
.Pe
Extra libraries are specified after other libraries,
.I Imakefile -specific
libraries first:
.Ps
$(LDLIBS) $(PROJECT_LDLIBS) $(STD_LDLIBS)
.Pe
.Cw Standard\%Load\%Flags
and
.Cw Standard\%Load\%Libs
are normally specified in the shared configuration files.
.Cw Project\%Load\%Flags
and
.Cw Project\%Load\%Libs
are given empty default values in the shared files;
they're intended to be overridden as necessary in the project-specific
configuration files.
.Cw LDFLAGS
and
.Cw LDLIBS
may be specified in individual Imakefiles
on a directory-specific basis.
.\"
.Ah "Tertiarities in the WRPRC2 Architecture"
.\"
.LP
The WRPRC2 configuration file architecture (that is, the order in which
configuration files are processed, and the locations in which to look for
them) is designed explicitly to allow for a two-level specification
of information:
a standard baseline configuration specified by the shared files in the public
directory, and project-specific configuration information specified
in private files in the project's
.I config
directory.
.LP
However, the discussion in the previous section illustrates that in
some instances there is allowance for a tertiary (three-level)
configuration specification, e.g., in the way you specify include-file
directories and preprocessor defines.
The third level in these cases is
.I Imakefile , per-
that is, you can specify directories or defines that apply within a given
.I Imakefile
but nowhere else.
