/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _is_sealed;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	gboolean* _is_singleton;
	ValaList* base_types;
	ValaHashMap* implicit_implementations;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};

static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static guint _vala_symbol_hash_func_ghash_func (gconstpointer key);
static gboolean _vala_symbol_equal_func_gequal_func (gconstpointer a,
                                              gconstpointer b);
static void vala_class_set_default_construction_method (ValaClass* self,
                                                 ValaCreationMethod* value);
static void vala_class_set_constructor (ValaClass* self,
                                 ValaConstructor* value);
static void vala_class_set_class_constructor (ValaClass* self,
                                       ValaConstructor* value);
static void vala_class_set_static_constructor (ValaClass* self,
                                        ValaConstructor* value);
static void vala_class_set_destructor (ValaClass* self,
                                ValaDestructor* value);
static void vala_class_set_static_destructor (ValaClass* self,
                                       ValaDestructor* value);
static void vala_class_set_class_destructor (ValaClass* self,
                                      ValaDestructor* value);
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_class_finalize (ValaCodeNode * obj);
static GType vala_class_get_type_once (void);

static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}

ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}

gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_class_get_is_sealed (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_sealed;
	return result;
}

void
vala_class_set_is_sealed (ValaClass* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_sealed = value;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_compact (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_compact;
	result = *_tmp11_;
	return result;
}

void
vala_class_set_is_compact (ValaClass* self,
                           gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", value, NULL);
}

gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_immutable (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_immutable;
	result = *_tmp11_;
	return result;
}

void
vala_class_set_is_immutable (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}

gboolean
vala_class_get_is_singleton (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_singleton;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SingleInstance");
		_tmp2_ = _tmp1_ != NULL;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_is_singleton);
		self->priv->_is_singleton = _tmp3_;
	}
	_tmp4_ = self->priv->_is_singleton;
	result = *_tmp4_;
	return result;
}

void
vala_class_set_is_singleton (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_singleton);
	self->priv->_is_singleton = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "SingleInstance", value, NULL);
}

gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}

void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}

gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}

static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}

static guint
_vala_symbol_hash_func_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_symbol_hash_func ((ValaSymbol*) key);
	return result;
}

static gboolean
_vala_symbol_equal_func_gequal_func (gconstpointer a,
                                     gconstpointer b)
{
	gboolean result;
	result = vala_symbol_equal_func ((ValaSymbol*) a, (ValaSymbol*) b);
	return result;
}

ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	result = _tmp0_ != NULL;
	return result;
}

/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}

/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}

/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp25_ = FALSE;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != VALA_MEMBER_BINDING_STATIC) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaParameter* _tmp15_;
		ValaParameter* _tmp16_;
		ValaScope* _tmp17_;
		ValaScope* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		ValaParameter* _tmp23_;
		ValaParameter* _tmp24_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_parameter_new ("this", _tmp12_, _tmp14_);
		_tmp16_ = _tmp15_;
		vala_method_set_this_parameter (m, _tmp16_);
		_vala_code_node_unref0 (_tmp16_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_method_get_this_parameter (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_method_get_this_parameter (m);
		_tmp24_ = _tmp23_;
		vala_scope_add (_tmp18_, _tmp22_, (ValaSymbol*) _tmp24_);
	}
	_tmp26_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp27_ = _tmp26_;
	if (!VALA_IS_VOID_TYPE (_tmp27_)) {
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp28_ = vala_method_get_postconditions (m);
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp25_ = _tmp30_ > 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		ValaLocalVariable* _tmp48_;
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		if (_tmp32_ != NULL) {
			ValaScope* _tmp33_;
			ValaScope* _tmp34_;
			ValaLocalVariable* _tmp35_;
			ValaLocalVariable* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			_tmp33_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_symbol_get_name ((ValaSymbol*) _tmp36_);
			_tmp38_ = _tmp37_;
			vala_scope_remove (_tmp34_, _tmp38_);
		}
		_tmp39_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_copy (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_local_variable_new (_tmp42_, "result", NULL, _tmp44_);
		_tmp46_ = _tmp45_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp46_);
		_vala_code_node_unref0 (_tmp46_);
		_vala_code_node_unref0 (_tmp42_);
		_tmp47_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp48_ = _tmp47_;
		vala_local_variable_set_is_result (_tmp48_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		ValaCreationMethod* cm = NULL;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gboolean _tmp69_ = FALSE;
		gboolean _tmp70_;
		_tmp49_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp50_ = _tmp49_;
		if (_tmp50_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_tmp68_ = _tmp67_;
			vala_report_error (_tmp61_, _tmp68_);
			_g_free0 (_tmp68_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
		_tmp70_ = self->priv->_is_abstract;
		if (_tmp70_) {
			ValaCreationMethod* _tmp71_;
			ValaSymbolAccessibility _tmp72_;
			ValaSymbolAccessibility _tmp73_;
			_tmp71_ = cm;
			_tmp72_ = vala_symbol_get_access ((ValaSymbol*) _tmp71_);
			_tmp73_ = _tmp72_;
			_tmp69_ = _tmp73_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		} else {
			_tmp69_ = FALSE;
		}
		if (_tmp69_) {
			gboolean _tmp74_;
			gboolean _tmp75_;
			_tmp74_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp75_ = _tmp74_;
			if (_tmp75_) {
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp77_ = _tmp76_;
				vala_report_warning (_tmp77_, "Creation method of abstract class cannot be public.");
			} else {
				ValaSourceReference* _tmp78_;
				ValaSourceReference* _tmp79_;
				_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp79_ = _tmp78_;
				vala_report_error (_tmp79_, "Creation method of abstract class cannot be public.");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				return;
			}
		}
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
vala_class_get_implicit_implementations (ValaClass* self)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	ValaHashMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->implicit_implementations;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaField* _tmp16_;
	ValaField* _tmp17_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_property_get_binding (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp2_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", _tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		vala_property_set_this_parameter (prop, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp3_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_property_get_this_parameter (prop);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_property_get_this_parameter (prop);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp16_ = vala_property_get_field (prop);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaField* _tmp18_;
		ValaField* _tmp19_;
		_tmp18_ = vala_property_get_field (prop);
		_tmp19_ = _tmp18_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp19_);
	}
}

static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaConstructor* _tmp2_;
			ValaConstructor* _tmp3_;
			_tmp2_ = vala_class_get_constructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a constructor");
			}
			vala_class_set_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaConstructor* _tmp6_;
			ValaConstructor* _tmp7_;
			_tmp6_ = vala_class_get_class_constructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaConstructor* _tmp10_;
			ValaConstructor* _tmp11_;
			_tmp10_ = vala_class_get_static_constructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_constructor_get_binding (c);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		ValaScope* _tmp30_;
		ValaScope* _tmp31_;
		ValaParameter* _tmp32_;
		ValaParameter* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ValaParameter* _tmp36_;
		ValaParameter* _tmp37_;
		_tmp16_ = vala_constructor_get_this_parameter (c);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) c);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_constructor_get_this_parameter (c);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) c, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_parameter_new ("this", _tmp25_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_constructor_set_this_parameter (c, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) c);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_constructor_get_this_parameter (c);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_constructor_get_this_parameter (c);
		_tmp37_ = _tmp36_;
		vala_scope_add (_tmp31_, _tmp35_, (ValaSymbol*) _tmp37_);
	}
}

static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaDestructor* _tmp2_;
			ValaDestructor* _tmp3_;
			_tmp2_ = vala_class_get_destructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a destructor");
			}
			vala_class_set_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaDestructor* _tmp6_;
			ValaDestructor* _tmp7_;
			_tmp6_ = vala_class_get_class_destructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaDestructor* _tmp10_;
			ValaDestructor* _tmp11_;
			_tmp10_ = vala_class_get_static_destructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_destructor_get_binding (d);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		ValaScope* _tmp30_;
		ValaScope* _tmp31_;
		ValaParameter* _tmp32_;
		ValaParameter* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ValaParameter* _tmp36_;
		ValaParameter* _tmp37_;
		_tmp16_ = vala_destructor_get_this_parameter (d);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) d);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_destructor_get_this_parameter (d);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) d, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_parameter_new ("this", _tmp25_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_destructor_set_this_parameter (d, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) d);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_destructor_get_this_parameter (d);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_destructor_get_this_parameter (d);
		_tmp37_ = _tmp36_;
		vala_scope_add (_tmp31_, _tmp35_, (ValaSymbol*) _tmp37_);
	}
}

static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp10_;
	ValaConstructor* _tmp11_;
	ValaConstructor* _tmp14_;
	ValaConstructor* _tmp15_;
	ValaConstructor* _tmp18_;
	ValaConstructor* _tmp19_;
	ValaDestructor* _tmp22_;
	ValaDestructor* _tmp23_;
	ValaDestructor* _tmp26_;
	ValaDestructor* _tmp27_;
	ValaDestructor* _tmp30_;
	ValaDestructor* _tmp31_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			_type_index = _type_index + 1;
			_tmp5_ = _type_index;
			_tmp6_ = _type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_list;
			_tmp8_ = vala_list_get (_tmp7_, _type_index);
			type = (ValaDataType*) _tmp8_;
			_tmp9_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
	_tmp10_ = vala_class_get_constructor (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaConstructor* _tmp12_;
		ValaConstructor* _tmp13_;
		_tmp12_ = vala_class_get_constructor (self);
		_tmp13_ = _tmp12_;
		vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
	}
	_tmp14_ = vala_class_get_class_constructor (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaConstructor* _tmp16_;
		ValaConstructor* _tmp17_;
		_tmp16_ = vala_class_get_class_constructor (self);
		_tmp17_ = _tmp16_;
		vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
	}
	_tmp18_ = vala_class_get_static_constructor (self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaConstructor* _tmp20_;
		ValaConstructor* _tmp21_;
		_tmp20_ = vala_class_get_static_constructor (self);
		_tmp21_ = _tmp20_;
		vala_code_node_accept ((ValaCodeNode*) _tmp21_, visitor);
	}
	_tmp22_ = vala_class_get_destructor (self);
	_tmp23_ = _tmp22_;
	if (_tmp23_ != NULL) {
		ValaDestructor* _tmp24_;
		ValaDestructor* _tmp25_;
		_tmp24_ = vala_class_get_destructor (self);
		_tmp25_ = _tmp24_;
		vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
	}
	_tmp26_ = vala_class_get_static_destructor (self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != NULL) {
		ValaDestructor* _tmp28_;
		ValaDestructor* _tmp29_;
		_tmp28_ = vala_class_get_static_destructor (self);
		_tmp29_ = _tmp28_;
		vala_code_node_accept ((ValaCodeNode*) _tmp29_, visitor);
	}
	_tmp30_ = vala_class_get_class_destructor (self);
	_tmp31_ = _tmp30_;
	if (_tmp31_ != NULL) {
		ValaDestructor* _tmp32_;
		ValaDestructor* _tmp33_;
		_tmp32_ = vala_class_get_class_destructor (self);
		_tmp33_ = _tmp32_;
		vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
	}
}

static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}

gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			ValaDataType* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			_base_type_index = _base_type_index + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = vala_list_get (_tmp7_, _base_type_index);
			base_type = (ValaDataType*) _tmp8_;
			_tmp11_ = base_type;
			_tmp12_ = vala_data_type_get_type_symbol (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				ValaDataType* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				_tmp14_ = base_type;
				_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp10_ = _tmp16_ != G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ValaDataType* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				ValaTypeSymbol* _tmp19_;
				_tmp17_ = base_type;
				_tmp18_ = vala_data_type_get_type_symbol (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp9_ = vala_typesymbol_is_subtype_of (_tmp19_, t);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->base_types;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->base_types;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->base_types;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prereq_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prereq_list = _tmp1_;
		_tmp2_ = _prereq_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prereq_size = _tmp4_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			_prereq_index = _prereq_index + 1;
			_tmp5_ = _prereq_index;
			_tmp6_ = _prereq_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prereq_list;
			_tmp8_ = vala_list_get (_tmp7_, _prereq_index);
			prereq = (ValaDataType*) _tmp8_;
			_tmp9_ = prereq;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (_tmp11_);
			type = _tmp12_;
			_tmp13_ = type;
			if (_tmp13_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp14_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp14_);
			_tmp15_ = type;
			if (VALA_IS_INTERFACE (_tmp15_)) {
				ValaTypeSymbol* _tmp16_;
				_tmp16_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}

gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_base_type_index = _base_type_index + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = vala_list_get (_tmp7_, _base_type_index);
			base_type = (ValaDataType*) _tmp8_;
			_tmp9_ = base_type;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			if (VALA_IS_CLASS (_tmp11_)) {
				ValaDataType* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				_tmp12_ = base_type;
				_tmp13_ = vala_data_type_get_type_symbol (_tmp12_);
				_tmp14_ = _tmp13_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = base_type;
				_tmp16_ = vala_data_type_get_type_symbol (_tmp15_);
				_tmp17_ = _tmp16_;
				if (_tmp17_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_base_type_index = _base_type_index + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = vala_list_get (_tmp7_, _base_type_index);
			base_type = (ValaDataType*) _tmp8_;
			_tmp9_ = base_type;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	gboolean _tmp80_ = FALSE;
	ValaClass* _tmp81_;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_;
	gboolean _tmp96_;
	gboolean _tmp106_ = FALSE;
	gboolean _tmp107_;
	gboolean _tmp108_;
	gboolean _tmp120_ = FALSE;
	ValaClass* _tmp121_;
	gboolean _tmp133_;
	ValaConstructor* _tmp242_;
	ValaConstructor* _tmp243_;
	ValaConstructor* _tmp246_;
	ValaConstructor* _tmp247_;
	ValaConstructor* _tmp250_;
	ValaConstructor* _tmp251_;
	ValaDestructor* _tmp254_;
	ValaDestructor* _tmp255_;
	ValaDestructor* _tmp258_;
	ValaDestructor* _tmp259_;
	ValaDestructor* _tmp262_;
	ValaDestructor* _tmp263_;
	gboolean _tmp306_;
	gboolean _tmp307_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp352_;
	ValaArrayList* _tmp353_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp370_;
	ValaArrayList* _tmp371_;
	ValaList* _tmp386_;
	gint _tmp387_;
	gint _tmp388_;
	ValaSourceFileType _tmp413_;
	ValaSourceFileType _tmp414_;
	ValaSemanticAnalyzer* _tmp647_;
	ValaSemanticAnalyzer* _tmp648_;
	ValaSourceFile* _tmp649_;
	ValaSemanticAnalyzer* _tmp650_;
	ValaSemanticAnalyzer* _tmp651_;
	ValaSymbol* _tmp652_;
	gboolean _tmp653_;
	gboolean _tmp654_;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	if (!VALA_CODE_NODE_CLASS (vala_class_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), context)) {
		result = FALSE;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		ValaList* _tmp25_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_base_type_reference_list = _tmp25_;
		_tmp26_ = _base_type_reference_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_base_type_reference_size = _tmp28_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp31_;
			gpointer _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp34_;
			ValaSemanticAnalyzer* _tmp44_;
			ValaSemanticAnalyzer* _tmp45_;
			ValaDataType* _tmp46_;
			ValaDataType* _tmp56_;
			_base_type_reference_index = _base_type_reference_index + 1;
			_tmp29_ = _base_type_reference_index;
			_tmp30_ = _base_type_reference_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _base_type_reference_list;
			_tmp32_ = vala_list_get (_tmp31_, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp32_;
			_tmp33_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp33_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp34_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp34_)) {
				ValaSourceReference* _tmp35_;
				ValaSourceReference* _tmp36_;
				ValaDataType* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp36_ = _tmp35_;
				_tmp37_ = base_type_reference;
				_tmp38_ = vala_code_node_to_string ((ValaCodeNode*) _tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strdup_printf ("base type `%s' of class `%s' is not an object type", _tmp39_, _tmp41_);
				_tmp43_ = _tmp42_;
				vala_report_error (_tmp36_, _tmp43_);
				_g_free0 (_tmp43_);
				_g_free0 (_tmp41_);
				_g_free0 (_tmp39_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp44_ = vala_code_context_get_analyzer (context);
			_tmp45_ = _tmp44_;
			_tmp46_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp45_, (ValaSymbol*) self, _tmp46_)) {
				ValaSourceReference* _tmp47_;
				ValaSourceReference* _tmp48_;
				ValaDataType* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp48_ = _tmp47_;
				_tmp49_ = base_type_reference;
				_tmp50_ = vala_code_node_to_string ((ValaCodeNode*) _tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp53_ = _tmp52_;
				_tmp54_ = g_strdup_printf ("base type `%s' is less accessible than class `%s'", _tmp51_, _tmp53_);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp48_, _tmp55_);
				_g_free0 (_tmp55_);
				_g_free0 (_tmp53_);
				_g_free0 (_tmp51_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp56_ = base_type_reference;
			if (!vala_data_type_check_type_arguments (_tmp56_, context, FALSE)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp57_;
		ValaList* _tmp58_;
		gint _type_size = 0;
		ValaList* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint _type_index = 0;
		_tmp57_ = self->priv->base_types;
		_tmp58_ = _vala_iterable_ref0 (_tmp57_);
		_type_list = _tmp58_;
		_tmp59_ = _type_list;
		_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
		_tmp61_ = _tmp60_;
		_type_size = _tmp61_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp62_;
			gint _tmp63_;
			ValaDataType* type = NULL;
			ValaList* _tmp64_;
			gpointer _tmp65_;
			ValaDataType* _tmp66_;
			ValaSemanticAnalyzer* _tmp67_;
			ValaSemanticAnalyzer* _tmp68_;
			ValaDataType* _tmp69_;
			_type_index = _type_index + 1;
			_tmp62_ = _type_index;
			_tmp63_ = _type_size;
			if (!(_tmp62_ < _tmp63_)) {
				break;
			}
			_tmp64_ = _type_list;
			_tmp65_ = vala_list_get (_tmp64_, _type_index);
			type = (ValaDataType*) _tmp65_;
			_tmp66_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp66_, context);
			_tmp67_ = vala_code_context_get_analyzer (context);
			_tmp68_ = _tmp67_;
			_tmp69_ = type;
			vala_semantic_analyzer_check_type (_tmp68_, _tmp69_);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp70_;
		ValaList* _tmp71_;
		gint _p_size = 0;
		ValaList* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _p_index = 0;
		_tmp70_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_tmp71_ = _vala_iterable_ref0 (_tmp70_);
		_p_list = _tmp71_;
		_tmp72_ = _p_list;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
		_tmp74_ = _tmp73_;
		_p_size = _tmp74_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp75_;
			gint _tmp76_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp77_;
			gpointer _tmp78_;
			ValaTypeParameter* _tmp79_;
			_p_index = _p_index + 1;
			_tmp75_ = _p_index;
			_tmp76_ = _p_size;
			if (!(_tmp75_ < _tmp76_)) {
				break;
			}
			_tmp77_ = _p_list;
			_tmp78_ = vala_list_get (_tmp77_, _p_index);
			p = (ValaTypeParameter*) _tmp78_;
			_tmp79_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp79_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp81_ = self->priv->_base_class;
	if (_tmp81_ != NULL) {
		ValaClass* _tmp82_;
		gboolean _tmp83_;
		gboolean _tmp84_;
		_tmp82_ = self->priv->_base_class;
		_tmp83_ = vala_class_get_is_singleton (_tmp82_);
		_tmp84_ = _tmp83_;
		_tmp80_ = _tmp84_;
	} else {
		_tmp80_ = FALSE;
	}
	if (_tmp80_) {
		ValaSourceReference* _tmp85_;
		ValaSourceReference* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		ValaClass* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = self->priv->_base_class;
		_tmp90_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp89_);
		_tmp91_ = _tmp90_;
		_tmp92_ = g_strdup_printf ("`%s' cannot inherit from SingleInstance class `%s'", _tmp88_, _tmp91_);
		_tmp93_ = _tmp92_;
		vala_report_error (_tmp86_, _tmp93_);
		_g_free0 (_tmp93_);
		_g_free0 (_tmp91_);
		_g_free0 (_tmp88_);
	}
	_tmp95_ = vala_class_get_is_singleton (self);
	_tmp96_ = _tmp95_;
	if (_tmp96_) {
		ValaSemanticAnalyzer* _tmp97_;
		ValaSemanticAnalyzer* _tmp98_;
		ValaClass* _tmp99_;
		_tmp97_ = vala_code_context_get_analyzer (context);
		_tmp98_ = _tmp97_;
		_tmp99_ = _tmp98_->object_type;
		_tmp94_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp99_);
	} else {
		_tmp94_ = FALSE;
	}
	if (_tmp94_) {
		ValaSourceReference* _tmp100_;
		ValaSourceReference* _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		gchar* _tmp105_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp100_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp101_ = _tmp100_;
		_tmp102_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp103_ = _tmp102_;
		_tmp104_ = g_strdup_printf ("SingleInstance class `%s' requires inheritance from `GLib.Object'", _tmp103_);
		_tmp105_ = _tmp104_;
		vala_report_error (_tmp101_, _tmp105_);
		_g_free0 (_tmp105_);
		_g_free0 (_tmp103_);
	}
	_tmp107_ = vala_class_get_is_singleton (self);
	_tmp108_ = _tmp107_;
	if (_tmp108_) {
		ValaConstructor* _tmp109_;
		ValaConstructor* _tmp110_;
		_tmp109_ = vala_class_get_constructor (self);
		_tmp110_ = _tmp109_;
		_tmp106_ = _tmp110_ == NULL;
	} else {
		_tmp106_ = FALSE;
	}
	if (_tmp106_) {
		ValaConstructor* c = NULL;
		ValaSourceReference* _tmp111_;
		ValaSourceReference* _tmp112_;
		ValaConstructor* _tmp113_;
		ValaConstructor* _tmp114_;
		ValaSourceReference* _tmp115_;
		ValaSourceReference* _tmp116_;
		ValaBlock* _tmp117_;
		ValaBlock* _tmp118_;
		ValaConstructor* _tmp119_;
		_tmp111_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_constructor_new (_tmp112_);
		c = _tmp113_;
		_tmp114_ = c;
		_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_block_new (_tmp116_);
		_tmp118_ = _tmp117_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp114_, _tmp118_);
		_vala_code_node_unref0 (_tmp118_);
		_tmp119_ = c;
		vala_symbol_add_constructor ((ValaSymbol*) self, _tmp119_);
		_vala_code_node_unref0 (c);
	}
	_tmp121_ = self->priv->_base_class;
	if (_tmp121_ != NULL) {
		ValaClass* _tmp122_;
		gboolean _tmp123_;
		_tmp122_ = self->priv->_base_class;
		_tmp123_ = _tmp122_->priv->_is_sealed;
		_tmp120_ = _tmp123_;
	} else {
		_tmp120_ = FALSE;
	}
	if (_tmp120_) {
		ValaSourceReference* _tmp124_;
		ValaSourceReference* _tmp125_;
		gchar* _tmp126_;
		gchar* _tmp127_;
		ValaClass* _tmp128_;
		gchar* _tmp129_;
		gchar* _tmp130_;
		gchar* _tmp131_;
		gchar* _tmp132_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp127_ = _tmp126_;
		_tmp128_ = self->priv->_base_class;
		_tmp129_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp128_);
		_tmp130_ = _tmp129_;
		_tmp131_ = g_strdup_printf ("`%s' cannot inherit from sealed class `%s'", _tmp127_, _tmp130_);
		_tmp132_ = _tmp131_;
		vala_report_error (_tmp125_, _tmp132_);
		_g_free0 (_tmp132_);
		_g_free0 (_tmp130_);
		_g_free0 (_tmp127_);
	}
	_tmp133_ = self->priv->_is_sealed;
	if (_tmp133_) {
		gboolean _tmp134_;
		gboolean _tmp135_;
		gboolean _tmp142_;
		gboolean _tmp149_;
		gboolean _tmp150_;
		_tmp134_ = vala_class_get_is_compact (self);
		_tmp135_ = _tmp134_;
		if (_tmp135_) {
			ValaSourceReference* _tmp136_;
			ValaSourceReference* _tmp137_;
			gchar* _tmp138_;
			gchar* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp137_ = _tmp136_;
			_tmp138_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp139_ = _tmp138_;
			_tmp140_ = g_strdup_printf ("Sealed class `%s' cannot be compact", _tmp139_);
			_tmp141_ = _tmp140_;
			vala_report_error (_tmp137_, _tmp141_);
			_g_free0 (_tmp141_);
			_g_free0 (_tmp139_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp142_ = self->priv->_is_abstract;
		if (_tmp142_) {
			ValaSourceReference* _tmp143_;
			ValaSourceReference* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp146_ = _tmp145_;
			_tmp147_ = g_strdup_printf ("Sealed class `%s' cannot be abstract", _tmp146_);
			_tmp148_ = _tmp147_;
			vala_report_error (_tmp144_, _tmp148_);
			_g_free0 (_tmp148_);
			_g_free0 (_tmp146_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp149_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp150_ = _tmp149_;
		if (!_tmp150_) {
			ValaSourceReference* _tmp151_;
			ValaSourceReference* _tmp152_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp152_ = _tmp151_;
			vala_report_error (_tmp152_, "Sealed classes are not fully supported yet");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp153_;
		ValaList* _tmp154_;
		gint _en_size = 0;
		ValaList* _tmp155_;
		gint _tmp156_;
		gint _tmp157_;
		gint _en_index = 0;
		_tmp153_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_tmp154_ = _vala_iterable_ref0 (_tmp153_);
		_en_list = _tmp154_;
		_tmp155_ = _en_list;
		_tmp156_ = vala_collection_get_size ((ValaCollection*) _tmp155_);
		_tmp157_ = _tmp156_;
		_en_size = _tmp157_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp158_;
			gint _tmp159_;
			ValaEnum* en = NULL;
			ValaList* _tmp160_;
			gpointer _tmp161_;
			ValaEnum* _tmp162_;
			_en_index = _en_index + 1;
			_tmp158_ = _en_index;
			_tmp159_ = _en_size;
			if (!(_tmp158_ < _tmp159_)) {
				break;
			}
			_tmp160_ = _en_list;
			_tmp161_ = vala_list_get (_tmp160_, _en_index);
			en = (ValaEnum*) _tmp161_;
			_tmp162_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp162_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp163_;
		ValaList* _tmp164_;
		gint _f_size = 0;
		ValaList* _tmp165_;
		gint _tmp166_;
		gint _tmp167_;
		gint _f_index = 0;
		_tmp163_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_tmp164_ = _vala_iterable_ref0 (_tmp163_);
		_f_list = _tmp164_;
		_tmp165_ = _f_list;
		_tmp166_ = vala_collection_get_size ((ValaCollection*) _tmp165_);
		_tmp167_ = _tmp166_;
		_f_size = _tmp167_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp168_;
			gint _tmp169_;
			ValaField* f = NULL;
			ValaList* _tmp170_;
			gpointer _tmp171_;
			gboolean _tmp172_ = FALSE;
			gboolean _tmp173_;
			gboolean _tmp174_;
			ValaField* _tmp192_;
			_f_index = _f_index + 1;
			_tmp168_ = _f_index;
			_tmp169_ = _f_size;
			if (!(_tmp168_ < _tmp169_)) {
				break;
			}
			_tmp170_ = _f_list;
			_tmp171_ = vala_list_get (_tmp170_, _f_index);
			f = (ValaField*) _tmp171_;
			_tmp173_ = vala_class_get_is_compact (self);
			_tmp174_ = _tmp173_;
			if (_tmp174_) {
				ValaField* _tmp175_;
				ValaMemberBinding _tmp176_;
				ValaMemberBinding _tmp177_;
				_tmp175_ = f;
				_tmp176_ = vala_field_get_binding (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp172_ = _tmp177_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp172_ = FALSE;
			}
			if (_tmp172_) {
				gboolean _tmp178_ = FALSE;
				gboolean _tmp179_;
				gboolean _tmp180_;
				ValaField* _tmp186_;
				ValaMemberBinding _tmp187_;
				ValaMemberBinding _tmp188_;
				_tmp179_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp180_ = _tmp179_;
				if (!_tmp180_) {
					ValaField* _tmp181_;
					ValaSymbolAccessibility _tmp182_;
					ValaSymbolAccessibility _tmp183_;
					_tmp181_ = f;
					_tmp182_ = vala_symbol_get_access ((ValaSymbol*) _tmp181_);
					_tmp183_ = _tmp182_;
					_tmp178_ = _tmp183_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp178_ = FALSE;
				}
				if (_tmp178_) {
					ValaSourceReference* _tmp184_;
					ValaSourceReference* _tmp185_;
					_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp185_ = _tmp184_;
					vala_report_error (_tmp185_, "private fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp186_ = f;
				_tmp187_ = vala_field_get_binding (_tmp186_);
				_tmp188_ = _tmp187_;
				if (_tmp188_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp189_;
					ValaSourceReference* _tmp190_;
					ValaSourceReference* _tmp191_;
					_tmp189_ = f;
					_tmp190_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp189_);
					_tmp191_ = _tmp190_;
					vala_report_error (_tmp191_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp192_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp192_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp193_;
		ValaList* _tmp194_;
		gint _c_size = 0;
		ValaList* _tmp195_;
		gint _tmp196_;
		gint _tmp197_;
		gint _c_index = 0;
		_tmp193_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_tmp194_ = _vala_iterable_ref0 (_tmp193_);
		_c_list = _tmp194_;
		_tmp195_ = _c_list;
		_tmp196_ = vala_collection_get_size ((ValaCollection*) _tmp195_);
		_tmp197_ = _tmp196_;
		_c_size = _tmp197_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp198_;
			gint _tmp199_;
			ValaConstant* c = NULL;
			ValaList* _tmp200_;
			gpointer _tmp201_;
			ValaConstant* _tmp202_;
			_c_index = _c_index + 1;
			_tmp198_ = _c_index;
			_tmp199_ = _c_size;
			if (!(_tmp198_ < _tmp199_)) {
				break;
			}
			_tmp200_ = _c_list;
			_tmp201_ = vala_list_get (_tmp200_, _c_index);
			c = (ValaConstant*) _tmp201_;
			_tmp202_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp202_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp203_;
		ValaList* _tmp204_;
		gint _m_size = 0;
		ValaList* _tmp205_;
		gint _tmp206_;
		gint _tmp207_;
		gint _m_index = 0;
		_tmp203_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_tmp204_ = _vala_iterable_ref0 (_tmp203_);
		_m_list = _tmp204_;
		_tmp205_ = _m_list;
		_tmp206_ = vala_collection_get_size ((ValaCollection*) _tmp205_);
		_tmp207_ = _tmp206_;
		_m_size = _tmp207_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp208_;
			gint _tmp209_;
			ValaMethod* m = NULL;
			ValaList* _tmp210_;
			gpointer _tmp211_;
			ValaMethod* _tmp212_;
			_m_index = _m_index + 1;
			_tmp208_ = _m_index;
			_tmp209_ = _m_size;
			if (!(_tmp208_ < _tmp209_)) {
				break;
			}
			_tmp210_ = _m_list;
			_tmp211_ = vala_list_get (_tmp210_, _m_index);
			m = (ValaMethod*) _tmp211_;
			_tmp212_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp212_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp213_;
		ValaList* _tmp214_;
		gint _prop_size = 0;
		ValaList* _tmp215_;
		gint _tmp216_;
		gint _tmp217_;
		gint _prop_index = 0;
		_tmp213_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_tmp214_ = _vala_iterable_ref0 (_tmp213_);
		_prop_list = _tmp214_;
		_tmp215_ = _prop_list;
		_tmp216_ = vala_collection_get_size ((ValaCollection*) _tmp215_);
		_tmp217_ = _tmp216_;
		_prop_size = _tmp217_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp218_;
			gint _tmp219_;
			ValaProperty* prop = NULL;
			ValaList* _tmp220_;
			gpointer _tmp221_;
			gboolean _tmp222_ = FALSE;
			ValaProperty* _tmp223_;
			ValaAttribute* _tmp224_;
			ValaProperty* _tmp231_;
			_prop_index = _prop_index + 1;
			_tmp218_ = _prop_index;
			_tmp219_ = _prop_size;
			if (!(_tmp218_ < _tmp219_)) {
				break;
			}
			_tmp220_ = _prop_list;
			_tmp221_ = vala_list_get (_tmp220_, _prop_index);
			prop = (ValaProperty*) _tmp221_;
			_tmp223_ = prop;
			_tmp224_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp223_, "NoAccessorMethod");
			if (_tmp224_ != NULL) {
				ValaSemanticAnalyzer* _tmp225_;
				ValaSemanticAnalyzer* _tmp226_;
				ValaClass* _tmp227_;
				_tmp225_ = vala_code_context_get_analyzer (context);
				_tmp226_ = _tmp225_;
				_tmp227_ = _tmp226_->object_type;
				_tmp222_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp227_);
			} else {
				_tmp222_ = FALSE;
			}
			if (_tmp222_) {
				ValaProperty* _tmp228_;
				ValaSourceReference* _tmp229_;
				ValaSourceReference* _tmp230_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp228_ = prop;
				_tmp229_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp228_);
				_tmp230_ = _tmp229_;
				vala_report_error (_tmp230_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp231_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp231_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp232_;
		ValaList* _tmp233_;
		gint _sig_size = 0;
		ValaList* _tmp234_;
		gint _tmp235_;
		gint _tmp236_;
		gint _sig_index = 0;
		_tmp232_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_tmp233_ = _vala_iterable_ref0 (_tmp232_);
		_sig_list = _tmp233_;
		_tmp234_ = _sig_list;
		_tmp235_ = vala_collection_get_size ((ValaCollection*) _tmp234_);
		_tmp236_ = _tmp235_;
		_sig_size = _tmp236_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp237_;
			gint _tmp238_;
			ValaSignal* sig = NULL;
			ValaList* _tmp239_;
			gpointer _tmp240_;
			ValaSignal* _tmp241_;
			_sig_index = _sig_index + 1;
			_tmp237_ = _sig_index;
			_tmp238_ = _sig_size;
			if (!(_tmp237_ < _tmp238_)) {
				break;
			}
			_tmp239_ = _sig_list;
			_tmp240_ = vala_list_get (_tmp239_, _sig_index);
			sig = (ValaSignal*) _tmp240_;
			_tmp241_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp241_, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp242_ = vala_class_get_constructor (self);
	_tmp243_ = _tmp242_;
	if (_tmp243_ != NULL) {
		ValaConstructor* _tmp244_;
		ValaConstructor* _tmp245_;
		_tmp244_ = vala_class_get_constructor (self);
		_tmp245_ = _tmp244_;
		vala_code_node_check ((ValaCodeNode*) _tmp245_, context);
	}
	_tmp246_ = vala_class_get_class_constructor (self);
	_tmp247_ = _tmp246_;
	if (_tmp247_ != NULL) {
		ValaConstructor* _tmp248_;
		ValaConstructor* _tmp249_;
		_tmp248_ = vala_class_get_class_constructor (self);
		_tmp249_ = _tmp248_;
		vala_code_node_check ((ValaCodeNode*) _tmp249_, context);
	}
	_tmp250_ = vala_class_get_static_constructor (self);
	_tmp251_ = _tmp250_;
	if (_tmp251_ != NULL) {
		ValaConstructor* _tmp252_;
		ValaConstructor* _tmp253_;
		_tmp252_ = vala_class_get_static_constructor (self);
		_tmp253_ = _tmp252_;
		vala_code_node_check ((ValaCodeNode*) _tmp253_, context);
	}
	_tmp254_ = vala_class_get_destructor (self);
	_tmp255_ = _tmp254_;
	if (_tmp255_ != NULL) {
		ValaDestructor* _tmp256_;
		ValaDestructor* _tmp257_;
		_tmp256_ = vala_class_get_destructor (self);
		_tmp257_ = _tmp256_;
		vala_code_node_check ((ValaCodeNode*) _tmp257_, context);
	}
	_tmp258_ = vala_class_get_static_destructor (self);
	_tmp259_ = _tmp258_;
	if (_tmp259_ != NULL) {
		ValaDestructor* _tmp260_;
		ValaDestructor* _tmp261_;
		_tmp260_ = vala_class_get_static_destructor (self);
		_tmp261_ = _tmp260_;
		vala_code_node_check ((ValaCodeNode*) _tmp261_, context);
	}
	_tmp262_ = vala_class_get_class_destructor (self);
	_tmp263_ = _tmp262_;
	if (_tmp263_ != NULL) {
		ValaDestructor* _tmp264_;
		ValaDestructor* _tmp265_;
		_tmp264_ = vala_class_get_class_destructor (self);
		_tmp265_ = _tmp264_;
		vala_code_node_check ((ValaCodeNode*) _tmp265_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp266_;
		ValaList* _tmp267_;
		gint _cl_size = 0;
		ValaList* _tmp268_;
		gint _tmp269_;
		gint _tmp270_;
		gint _cl_index = 0;
		_tmp266_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_tmp267_ = _vala_iterable_ref0 (_tmp266_);
		_cl_list = _tmp267_;
		_tmp268_ = _cl_list;
		_tmp269_ = vala_collection_get_size ((ValaCollection*) _tmp268_);
		_tmp270_ = _tmp269_;
		_cl_size = _tmp270_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp271_;
			gint _tmp272_;
			ValaClass* cl = NULL;
			ValaList* _tmp273_;
			gpointer _tmp274_;
			ValaClass* _tmp275_;
			_cl_index = _cl_index + 1;
			_tmp271_ = _cl_index;
			_tmp272_ = _cl_size;
			if (!(_tmp271_ < _tmp272_)) {
				break;
			}
			_tmp273_ = _cl_list;
			_tmp274_ = vala_list_get (_tmp273_, _cl_index);
			cl = (ValaClass*) _tmp274_;
			_tmp275_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp275_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp276_;
		ValaList* _tmp277_;
		gint _iface_size = 0;
		ValaList* _tmp278_;
		gint _tmp279_;
		gint _tmp280_;
		gint _iface_index = 0;
		_tmp276_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_tmp277_ = _vala_iterable_ref0 (_tmp276_);
		_iface_list = _tmp277_;
		_tmp278_ = _iface_list;
		_tmp279_ = vala_collection_get_size ((ValaCollection*) _tmp278_);
		_tmp280_ = _tmp279_;
		_iface_size = _tmp280_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp281_;
			gint _tmp282_;
			ValaInterface* iface = NULL;
			ValaList* _tmp283_;
			gpointer _tmp284_;
			ValaInterface* _tmp285_;
			_iface_index = _iface_index + 1;
			_tmp281_ = _iface_index;
			_tmp282_ = _iface_size;
			if (!(_tmp281_ < _tmp282_)) {
				break;
			}
			_tmp283_ = _iface_list;
			_tmp284_ = vala_list_get (_tmp283_, _iface_index);
			iface = (ValaInterface*) _tmp284_;
			_tmp285_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp285_, context);
			_vala_code_node_unref0 (iface);
		}
		_vala_iterable_unref0 (_iface_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp286_;
		ValaList* _tmp287_;
		gint _st_size = 0;
		ValaList* _tmp288_;
		gint _tmp289_;
		gint _tmp290_;
		gint _st_index = 0;
		_tmp286_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_tmp287_ = _vala_iterable_ref0 (_tmp286_);
		_st_list = _tmp287_;
		_tmp288_ = _st_list;
		_tmp289_ = vala_collection_get_size ((ValaCollection*) _tmp288_);
		_tmp290_ = _tmp289_;
		_st_size = _tmp290_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp291_;
			gint _tmp292_;
			ValaStruct* st = NULL;
			ValaList* _tmp293_;
			gpointer _tmp294_;
			ValaStruct* _tmp295_;
			_st_index = _st_index + 1;
			_tmp291_ = _st_index;
			_tmp292_ = _st_size;
			if (!(_tmp291_ < _tmp292_)) {
				break;
			}
			_tmp293_ = _st_list;
			_tmp294_ = vala_list_get (_tmp293_, _st_index);
			st = (ValaStruct*) _tmp294_;
			_tmp295_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp295_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp296_;
		ValaList* _tmp297_;
		gint _d_size = 0;
		ValaList* _tmp298_;
		gint _tmp299_;
		gint _tmp300_;
		gint _d_index = 0;
		_tmp296_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_tmp297_ = _vala_iterable_ref0 (_tmp296_);
		_d_list = _tmp297_;
		_tmp298_ = _d_list;
		_tmp299_ = vala_collection_get_size ((ValaCollection*) _tmp298_);
		_tmp300_ = _tmp299_;
		_d_size = _tmp300_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp301_;
			gint _tmp302_;
			ValaDelegate* d = NULL;
			ValaList* _tmp303_;
			gpointer _tmp304_;
			ValaDelegate* _tmp305_;
			_d_index = _d_index + 1;
			_tmp301_ = _d_index;
			_tmp302_ = _d_size;
			if (!(_tmp301_ < _tmp302_)) {
				break;
			}
			_tmp303_ = _d_list;
			_tmp304_ = vala_list_get (_tmp303_, _d_index);
			d = (ValaDelegate*) _tmp304_;
			_tmp305_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp305_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp306_ = vala_class_get_is_compact (self);
	_tmp307_ = _tmp306_;
	if (_tmp307_) {
		gboolean _tmp326_ = FALSE;
		gboolean _tmp327_ = FALSE;
		gboolean _tmp328_ = FALSE;
		gboolean _tmp329_;
		gboolean _tmp330_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp308_;
			ValaList* _tmp309_;
			gint _base_type_size = 0;
			ValaList* _tmp310_;
			gint _tmp311_;
			gint _tmp312_;
			gint _base_type_index = 0;
			_tmp308_ = vala_class_get_base_types (self);
			_tmp309_ = _vala_iterable_ref0 (_tmp308_);
			_base_type_list = _tmp309_;
			_tmp310_ = _base_type_list;
			_tmp311_ = vala_collection_get_size ((ValaCollection*) _tmp310_);
			_tmp312_ = _tmp311_;
			_base_type_size = _tmp312_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp313_;
				gint _tmp314_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp315_;
				gpointer _tmp316_;
				ValaDataType* _tmp317_;
				ValaTypeSymbol* _tmp318_;
				ValaTypeSymbol* _tmp319_;
				_base_type_index = _base_type_index + 1;
				_tmp313_ = _base_type_index;
				_tmp314_ = _base_type_size;
				if (!(_tmp313_ < _tmp314_)) {
					break;
				}
				_tmp315_ = _base_type_list;
				_tmp316_ = vala_list_get (_tmp315_, _base_type_index);
				base_type = (ValaDataType*) _tmp316_;
				_tmp317_ = base_type;
				_tmp318_ = vala_data_type_get_type_symbol (_tmp317_);
				_tmp319_ = _tmp318_;
				if (VALA_IS_INTERFACE (_tmp319_)) {
					ValaSourceReference* _tmp320_;
					ValaSourceReference* _tmp321_;
					gchar* _tmp322_;
					gchar* _tmp323_;
					gchar* _tmp324_;
					gchar* _tmp325_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp320_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp321_ = _tmp320_;
					_tmp322_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp323_ = _tmp322_;
					_tmp324_ = g_strdup_printf ("compact classes `%s' may not implement interfaces", _tmp323_);
					_tmp325_ = _tmp324_;
					vala_report_error (_tmp321_, _tmp325_);
					_g_free0 (_tmp325_);
					_g_free0 (_tmp323_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp329_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp330_ = _tmp329_;
		if (!_tmp330_) {
			gboolean _tmp331_;
			gboolean _tmp332_;
			_tmp331_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp332_ = _tmp331_;
			_tmp328_ = !_tmp332_;
		} else {
			_tmp328_ = FALSE;
		}
		if (_tmp328_) {
			ValaClass* _tmp333_;
			_tmp333_ = self->priv->_base_class;
			_tmp327_ = _tmp333_ != NULL;
		} else {
			_tmp327_ = FALSE;
		}
		if (_tmp327_) {
			ValaClass* _tmp334_;
			ValaSemanticAnalyzer* _tmp335_;
			ValaSemanticAnalyzer* _tmp336_;
			ValaClass* _tmp337_;
			_tmp334_ = self->priv->_base_class;
			_tmp335_ = vala_code_context_get_analyzer (context);
			_tmp336_ = _tmp335_;
			_tmp337_ = _tmp336_->gsource_type;
			_tmp326_ = _tmp334_ != _tmp337_;
		} else {
			_tmp326_ = FALSE;
		}
		if (_tmp326_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp338_;
				ValaList* _tmp339_;
				gint _f_size = 0;
				ValaList* _tmp340_;
				gint _tmp341_;
				gint _tmp342_;
				gint _f_index = 0;
				_tmp338_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_tmp339_ = _vala_iterable_ref0 (_tmp338_);
				_f_list = _tmp339_;
				_tmp340_ = _f_list;
				_tmp341_ = vala_collection_get_size ((ValaCollection*) _tmp340_);
				_tmp342_ = _tmp341_;
				_f_size = _tmp342_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp343_;
					gint _tmp344_;
					ValaField* f = NULL;
					ValaList* _tmp345_;
					gpointer _tmp346_;
					ValaField* _tmp347_;
					ValaMemberBinding _tmp348_;
					ValaMemberBinding _tmp349_;
					_f_index = _f_index + 1;
					_tmp343_ = _f_index;
					_tmp344_ = _f_size;
					if (!(_tmp343_ < _tmp344_)) {
						break;
					}
					_tmp345_ = _f_list;
					_tmp346_ = vala_list_get (_tmp345_, _f_index);
					f = (ValaField*) _tmp346_;
					_tmp347_ = f;
					_tmp348_ = vala_field_get_binding (_tmp347_);
					_tmp349_ = _tmp348_;
					if (_tmp349_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp350_;
						ValaSourceReference* _tmp351_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp350_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp351_ = _tmp350_;
						vala_report_error (_tmp351_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp352_ = g_direct_equal;
	_tmp353_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp352_);
	prerequisites = (ValaList*) _tmp353_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp354_;
		ValaList* _tmp355_;
		gint _base_type_size = 0;
		ValaList* _tmp356_;
		gint _tmp357_;
		gint _tmp358_;
		gint _base_type_index = 0;
		_tmp354_ = vala_class_get_base_types (self);
		_tmp355_ = _vala_iterable_ref0 (_tmp354_);
		_base_type_list = _tmp355_;
		_tmp356_ = _base_type_list;
		_tmp357_ = vala_collection_get_size ((ValaCollection*) _tmp356_);
		_tmp358_ = _tmp357_;
		_base_type_size = _tmp358_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp359_;
			gint _tmp360_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp361_;
			gpointer _tmp362_;
			ValaDataType* _tmp363_;
			ValaTypeSymbol* _tmp364_;
			ValaTypeSymbol* _tmp365_;
			_base_type_index = _base_type_index + 1;
			_tmp359_ = _base_type_index;
			_tmp360_ = _base_type_size;
			if (!(_tmp359_ < _tmp360_)) {
				break;
			}
			_tmp361_ = _base_type_list;
			_tmp362_ = vala_list_get (_tmp361_, _base_type_index);
			base_type = (ValaDataType*) _tmp362_;
			_tmp363_ = base_type;
			_tmp364_ = vala_data_type_get_type_symbol (_tmp363_);
			_tmp365_ = _tmp364_;
			if (VALA_IS_INTERFACE (_tmp365_)) {
				ValaDataType* _tmp366_;
				ValaTypeSymbol* _tmp367_;
				ValaTypeSymbol* _tmp368_;
				ValaList* _tmp369_;
				_tmp366_ = base_type;
				_tmp367_ = vala_data_type_get_type_symbol (_tmp366_);
				_tmp368_ = _tmp367_;
				_tmp369_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp368_, VALA_TYPE_INTERFACE, ValaInterface), _tmp369_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp370_ = g_str_equal;
	_tmp371_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp370_);
	missing_prereqs = (ValaList*) _tmp371_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp372_;
		ValaList* _tmp373_;
		gint _prereq_size = 0;
		ValaList* _tmp374_;
		gint _tmp375_;
		gint _tmp376_;
		gint _prereq_index = 0;
		_tmp372_ = prerequisites;
		_tmp373_ = _vala_iterable_ref0 (_tmp372_);
		_prereq_list = _tmp373_;
		_tmp374_ = _prereq_list;
		_tmp375_ = vala_collection_get_size ((ValaCollection*) _tmp374_);
		_tmp376_ = _tmp375_;
		_prereq_size = _tmp376_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp377_;
			gint _tmp378_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp379_;
			gpointer _tmp380_;
			ValaTypeSymbol* _tmp381_;
			_prereq_index = _prereq_index + 1;
			_tmp377_ = _prereq_index;
			_tmp378_ = _prereq_size;
			if (!(_tmp377_ < _tmp378_)) {
				break;
			}
			_tmp379_ = _prereq_list;
			_tmp380_ = vala_list_get (_tmp379_, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp380_;
			_tmp381_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp381_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp382_;
				ValaTypeSymbol* _tmp383_;
				gchar* _tmp384_;
				gchar* _tmp385_;
				_tmp382_ = missing_prereqs;
				_tmp383_ = prereq;
				_tmp384_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp383_);
				_tmp385_ = _tmp384_;
				vala_list_insert (_tmp382_, 0, _tmp385_);
				_g_free0 (_tmp385_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp386_ = missing_prereqs;
	_tmp387_ = vala_collection_get_size ((ValaCollection*) _tmp386_);
	_tmp388_ = _tmp387_;
	if (_tmp388_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp389_;
		gchar* _tmp390_;
		gchar* _tmp391_;
		gchar* _tmp392_;
		gboolean first = FALSE;
		const gchar* _tmp408_;
		gchar* _tmp409_;
		ValaSourceReference* _tmp410_;
		ValaSourceReference* _tmp411_;
		const gchar* _tmp412_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp389_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp390_ = _tmp389_;
		_tmp391_ = g_strdup_printf ("%s: some prerequisites (", _tmp390_);
		_tmp392_ = _tmp391_;
		_g_free0 (_tmp390_);
		error_string = _tmp392_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp393_;
			ValaList* _tmp394_;
			gint _s_size = 0;
			ValaList* _tmp395_;
			gint _tmp396_;
			gint _tmp397_;
			gint _s_index = 0;
			_tmp393_ = missing_prereqs;
			_tmp394_ = _vala_iterable_ref0 (_tmp393_);
			_s_list = _tmp394_;
			_tmp395_ = _s_list;
			_tmp396_ = vala_collection_get_size ((ValaCollection*) _tmp395_);
			_tmp397_ = _tmp396_;
			_s_size = _tmp397_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp398_;
				gint _tmp399_;
				gchar* s = NULL;
				ValaList* _tmp400_;
				gpointer _tmp401_;
				_s_index = _s_index + 1;
				_tmp398_ = _s_index;
				_tmp399_ = _s_size;
				if (!(_tmp398_ < _tmp399_)) {
					break;
				}
				_tmp400_ = _s_list;
				_tmp401_ = vala_list_get (_tmp400_, _s_index);
				s = (gchar*) _tmp401_;
				if (first) {
					const gchar* _tmp402_;
					const gchar* _tmp403_;
					gchar* _tmp404_;
					_tmp402_ = error_string;
					_tmp403_ = s;
					_tmp404_ = g_strdup_printf ("%s`%s'", _tmp402_, _tmp403_);
					_g_free0 (error_string);
					error_string = _tmp404_;
					first = FALSE;
				} else {
					const gchar* _tmp405_;
					const gchar* _tmp406_;
					gchar* _tmp407_;
					_tmp405_ = error_string;
					_tmp406_ = s;
					_tmp407_ = g_strdup_printf ("%s, `%s'", _tmp405_, _tmp406_);
					_g_free0 (error_string);
					error_string = _tmp407_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp408_ = error_string;
		_tmp409_ = g_strconcat (_tmp408_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp409_;
		_tmp410_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp411_ = _tmp410_;
		_tmp412_ = error_string;
		vala_report_error (_tmp411_, _tmp412_);
		_g_free0 (error_string);
	}
	_tmp413_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp414_ = _tmp413_;
	if (_tmp414_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp575_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp415_;
			ValaList* _tmp416_;
			gint _base_type_size = 0;
			ValaList* _tmp417_;
			gint _tmp418_;
			gint _tmp419_;
			gint _base_type_index = 0;
			_tmp415_ = vala_class_get_base_types (self);
			_tmp416_ = _vala_iterable_ref0 (_tmp415_);
			_base_type_list = _tmp416_;
			_tmp417_ = _base_type_list;
			_tmp418_ = vala_collection_get_size ((ValaCollection*) _tmp417_);
			_tmp419_ = _tmp418_;
			_base_type_size = _tmp419_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp420_;
				gint _tmp421_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp422_;
				gpointer _tmp423_;
				ValaDataType* _tmp424_;
				ValaTypeSymbol* _tmp425_;
				ValaTypeSymbol* _tmp426_;
				_base_type_index = _base_type_index + 1;
				_tmp420_ = _base_type_index;
				_tmp421_ = _base_type_size;
				if (!(_tmp420_ < _tmp421_)) {
					break;
				}
				_tmp422_ = _base_type_list;
				_tmp423_ = vala_list_get (_tmp422_, _base_type_index);
				base_type = (ValaDataType*) _tmp423_;
				_tmp424_ = base_type;
				_tmp425_ = vala_data_type_get_type_symbol (_tmp424_);
				_tmp426_ = _tmp425_;
				if (VALA_IS_INTERFACE (_tmp426_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp427_;
					ValaTypeSymbol* _tmp428_;
					ValaTypeSymbol* _tmp429_;
					gboolean _tmp430_ = FALSE;
					ValaClass* _tmp431_;
					_tmp427_ = base_type;
					_tmp428_ = vala_data_type_get_type_symbol (_tmp427_);
					_tmp429_ = _tmp428_;
					iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp429_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp431_ = self->priv->_base_class;
					if (_tmp431_ != NULL) {
						ValaClass* _tmp432_;
						ValaInterface* _tmp433_;
						_tmp432_ = self->priv->_base_class;
						_tmp433_ = iface;
						_tmp430_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp432_, (ValaTypeSymbol*) _tmp433_);
					} else {
						_tmp430_ = FALSE;
					}
					if (_tmp430_) {
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp434_;
						ValaList* _tmp435_;
						ValaList* _tmp436_;
						gint _m_size = 0;
						ValaList* _tmp437_;
						gint _tmp438_;
						gint _tmp439_;
						gint _m_index = 0;
						_tmp434_ = iface;
						_tmp435_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp434_);
						_tmp436_ = _vala_iterable_ref0 (_tmp435_);
						_m_list = _tmp436_;
						_tmp437_ = _m_list;
						_tmp438_ = vala_collection_get_size ((ValaCollection*) _tmp437_);
						_tmp439_ = _tmp438_;
						_m_size = _tmp439_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp440_;
							gint _tmp441_;
							ValaMethod* m = NULL;
							ValaList* _tmp442_;
							gpointer _tmp443_;
							ValaMethod* _tmp444_;
							gboolean _tmp445_;
							gboolean _tmp446_;
							_m_index = _m_index + 1;
							_tmp440_ = _m_index;
							_tmp441_ = _m_size;
							if (!(_tmp440_ < _tmp441_)) {
								break;
							}
							_tmp442_ = _m_list;
							_tmp443_ = vala_list_get (_tmp442_, _m_index);
							m = (ValaMethod*) _tmp443_;
							_tmp444_ = m;
							_tmp445_ = vala_method_get_is_abstract (_tmp444_);
							_tmp446_ = _tmp445_;
							if (_tmp446_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								implemented = FALSE;
								base_class = self;
								while (TRUE) {
									gboolean _tmp447_ = FALSE;
									ValaClass* _tmp448_;
									ValaClass* _tmp502_;
									ValaClass* _tmp503_;
									_tmp448_ = base_class;
									if (_tmp448_ != NULL) {
										_tmp447_ = !implemented;
									} else {
										_tmp447_ = FALSE;
									}
									if (!_tmp447_) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp449_;
										ValaList* _tmp450_;
										ValaList* _tmp451_;
										gint _impl_size = 0;
										ValaList* _tmp452_;
										gint _tmp453_;
										gint _tmp454_;
										gint _impl_index = 0;
										_tmp449_ = base_class;
										_tmp450_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp449_);
										_tmp451_ = _vala_iterable_ref0 (_tmp450_);
										_impl_list = _tmp451_;
										_tmp452_ = _impl_list;
										_tmp453_ = vala_collection_get_size ((ValaCollection*) _tmp452_);
										_tmp454_ = _tmp453_;
										_impl_size = _tmp454_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp455_;
											gint _tmp456_;
											ValaMethod* impl = NULL;
											ValaList* _tmp457_;
											gpointer _tmp458_;
											gboolean _tmp459_ = FALSE;
											ValaMethod* _tmp460_;
											ValaMethod* _tmp461_;
											ValaMethod* _tmp462_;
											ValaMethod* _tmp463_;
											_impl_index = _impl_index + 1;
											_tmp455_ = _impl_index;
											_tmp456_ = _impl_size;
											if (!(_tmp455_ < _tmp456_)) {
												break;
											}
											_tmp457_ = _impl_list;
											_tmp458_ = vala_list_get (_tmp457_, _impl_index);
											impl = (ValaMethod*) _tmp458_;
											_tmp460_ = impl;
											_tmp461_ = vala_method_get_base_interface_method (_tmp460_);
											_tmp462_ = _tmp461_;
											_tmp463_ = m;
											if (_tmp462_ == _tmp463_) {
												_tmp459_ = TRUE;
											} else {
												gboolean _tmp464_ = FALSE;
												gboolean _tmp465_ = FALSE;
												gboolean _tmp466_ = FALSE;
												gboolean _tmp467_ = FALSE;
												ValaClass* _tmp468_;
												_tmp468_ = base_class;
												if (_tmp468_ != self) {
													ValaMethod* _tmp469_;
													ValaMethod* _tmp470_;
													ValaMethod* _tmp471_;
													_tmp469_ = impl;
													_tmp470_ = vala_method_get_base_interface_method (_tmp469_);
													_tmp471_ = _tmp470_;
													_tmp467_ = _tmp471_ == NULL;
												} else {
													_tmp467_ = FALSE;
												}
												if (_tmp467_) {
													ValaMethod* _tmp472_;
													const gchar* _tmp473_;
													const gchar* _tmp474_;
													ValaMethod* _tmp475_;
													const gchar* _tmp476_;
													const gchar* _tmp477_;
													_tmp472_ = impl;
													_tmp473_ = vala_symbol_get_name ((ValaSymbol*) _tmp472_);
													_tmp474_ = _tmp473_;
													_tmp475_ = m;
													_tmp476_ = vala_symbol_get_name ((ValaSymbol*) _tmp475_);
													_tmp477_ = _tmp476_;
													_tmp466_ = g_strcmp0 (_tmp474_, _tmp477_) == 0;
												} else {
													_tmp466_ = FALSE;
												}
												if (_tmp466_) {
													gboolean _tmp478_ = FALSE;
													ValaMethod* _tmp479_;
													ValaDataType* _tmp480_;
													ValaDataType* _tmp481_;
													_tmp479_ = impl;
													_tmp480_ = vala_method_get_base_interface_type (_tmp479_);
													_tmp481_ = _tmp480_;
													if (_tmp481_ == NULL) {
														_tmp478_ = TRUE;
													} else {
														ValaMethod* _tmp482_;
														ValaDataType* _tmp483_;
														ValaDataType* _tmp484_;
														ValaTypeSymbol* _tmp485_;
														ValaTypeSymbol* _tmp486_;
														ValaInterface* _tmp487_;
														_tmp482_ = impl;
														_tmp483_ = vala_method_get_base_interface_type (_tmp482_);
														_tmp484_ = _tmp483_;
														_tmp485_ = vala_data_type_get_type_symbol (_tmp484_);
														_tmp486_ = _tmp485_;
														_tmp487_ = iface;
														_tmp478_ = _tmp486_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp487_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
													}
													_tmp465_ = _tmp478_;
												} else {
													_tmp465_ = FALSE;
												}
												if (_tmp465_) {
													ValaMethod* _tmp488_;
													ValaMethod* _tmp489_;
													_tmp488_ = impl;
													_tmp489_ = m;
													_tmp464_ = vala_method_compatible_no_error (_tmp488_, _tmp489_);
												} else {
													_tmp464_ = FALSE;
												}
												_tmp459_ = _tmp464_;
											}
											if (_tmp459_) {
												ValaMethod* _tmp490_;
												ValaVersionAttribute* _tmp491_;
												ValaVersionAttribute* _tmp492_;
												ValaSourceReference* _tmp493_;
												ValaSourceReference* _tmp494_;
												ValaMethod* _tmp495_;
												ValaMethod* _tmp496_;
												ValaMethod* _tmp497_;
												ValaMethod* _tmp498_;
												_tmp490_ = impl;
												_tmp491_ = vala_symbol_get_version ((ValaSymbol*) _tmp490_);
												_tmp492_ = _tmp491_;
												_tmp493_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp494_ = _tmp493_;
												vala_version_attribute_check (_tmp492_, _tmp494_);
												_tmp495_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp495_, TRUE);
												implemented = TRUE;
												_tmp496_ = impl;
												_tmp497_ = vala_method_get_base_interface_method (_tmp496_);
												_tmp498_ = _tmp497_;
												if (_tmp498_ == NULL) {
													ValaHashMap* _tmp499_;
													ValaMethod* _tmp500_;
													ValaMethod* _tmp501_;
													_tmp499_ = self->priv->implicit_implementations;
													_tmp500_ = m;
													_tmp501_ = impl;
													vala_map_set ((ValaMap*) _tmp499_, _tmp500_, _tmp501_);
												}
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp502_ = base_class;
									_tmp503_ = _tmp502_->priv->_base_class;
									base_class = _tmp503_;
								}
								if (!implemented) {
									ValaSourceReference* _tmp504_;
									ValaSourceReference* _tmp505_;
									gchar* _tmp506_;
									gchar* _tmp507_;
									ValaMethod* _tmp508_;
									gchar* _tmp509_;
									gchar* _tmp510_;
									gchar* _tmp511_;
									gchar* _tmp512_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp504_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp505_ = _tmp504_;
									_tmp506_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp507_ = _tmp506_;
									_tmp508_ = m;
									_tmp509_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp508_);
									_tmp510_ = _tmp509_;
									_tmp511_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp507_, _tmp510_);
									_tmp512_ = _tmp511_;
									vala_report_error (_tmp505_, _tmp512_);
									_g_free0 (_tmp512_);
									_g_free0 (_tmp510_);
									_g_free0 (_tmp507_);
								}
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp513_;
						ValaList* _tmp514_;
						ValaList* _tmp515_;
						gint _prop_size = 0;
						ValaList* _tmp516_;
						gint _tmp517_;
						gint _tmp518_;
						gint _prop_index = 0;
						_tmp513_ = iface;
						_tmp514_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp513_);
						_tmp515_ = _vala_iterable_ref0 (_tmp514_);
						_prop_list = _tmp515_;
						_tmp516_ = _prop_list;
						_tmp517_ = vala_collection_get_size ((ValaCollection*) _tmp516_);
						_tmp518_ = _tmp517_;
						_prop_size = _tmp518_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp519_;
							gint _tmp520_;
							ValaProperty* prop = NULL;
							ValaList* _tmp521_;
							gpointer _tmp522_;
							ValaProperty* _tmp523_;
							gboolean _tmp524_;
							gboolean _tmp525_;
							_prop_index = _prop_index + 1;
							_tmp519_ = _prop_index;
							_tmp520_ = _prop_size;
							if (!(_tmp519_ < _tmp520_)) {
								break;
							}
							_tmp521_ = _prop_list;
							_tmp522_ = vala_list_get (_tmp521_, _prop_index);
							prop = (ValaProperty*) _tmp522_;
							_tmp523_ = prop;
							_tmp524_ = vala_property_get_is_abstract (_tmp523_);
							_tmp525_ = _tmp524_;
							if (_tmp525_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaSymbol* _tmp538_;
								sym = NULL;
								base_class = self;
								while (TRUE) {
									gboolean _tmp526_ = FALSE;
									ValaClass* _tmp527_;
									ValaClass* _tmp529_;
									ValaScope* _tmp530_;
									ValaScope* _tmp531_;
									ValaProperty* _tmp532_;
									const gchar* _tmp533_;
									const gchar* _tmp534_;
									ValaSymbol* _tmp535_;
									ValaClass* _tmp536_;
									ValaClass* _tmp537_;
									_tmp527_ = base_class;
									if (_tmp527_ != NULL) {
										ValaSymbol* _tmp528_;
										_tmp528_ = sym;
										_tmp526_ = !VALA_IS_PROPERTY (_tmp528_);
									} else {
										_tmp526_ = FALSE;
									}
									if (!_tmp526_) {
										break;
									}
									_tmp529_ = base_class;
									_tmp530_ = vala_symbol_get_scope ((ValaSymbol*) _tmp529_);
									_tmp531_ = _tmp530_;
									_tmp532_ = prop;
									_tmp533_ = vala_symbol_get_name ((ValaSymbol*) _tmp532_);
									_tmp534_ = _tmp533_;
									_tmp535_ = vala_scope_lookup (_tmp531_, _tmp534_);
									_vala_code_node_unref0 (sym);
									sym = _tmp535_;
									_tmp536_ = base_class;
									_tmp537_ = _tmp536_->priv->_base_class;
									base_class = _tmp537_;
								}
								_tmp538_ = sym;
								if (VALA_IS_PROPERTY (_tmp538_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp539_;
									ValaProperty* _tmp540_;
									gchar* invalid_match = NULL;
									gboolean _tmp541_ = FALSE;
									ValaProperty* _tmp542_;
									gboolean _tmp543_;
									gboolean _tmp544_;
									ValaSymbol* _tmp560_;
									ValaVersionAttribute* _tmp561_;
									ValaVersionAttribute* _tmp562_;
									ValaSourceReference* _tmp563_;
									ValaSourceReference* _tmp564_;
									ValaSymbol* _tmp565_;
									_tmp539_ = sym;
									_tmp540_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp539_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp540_;
									invalid_match = NULL;
									_tmp542_ = base_prop;
									_tmp543_ = vala_symbol_get_hides ((ValaSymbol*) _tmp542_);
									_tmp544_ = _tmp543_;
									if (!_tmp544_) {
										ValaProperty* _tmp545_;
										ValaProperty* _tmp546_;
										gchar* _tmp547_ = NULL;
										gboolean _tmp548_;
										_tmp545_ = base_prop;
										_tmp546_ = prop;
										_tmp548_ = vala_property_compatible (_tmp545_, _tmp546_, &_tmp547_);
										_g_free0 (invalid_match);
										invalid_match = _tmp547_;
										_tmp541_ = !_tmp548_;
									} else {
										_tmp541_ = FALSE;
									}
									if (_tmp541_) {
										ValaSourceReference* _tmp549_;
										ValaSourceReference* _tmp550_;
										ValaProperty* _tmp551_;
										gchar* _tmp552_;
										gchar* _tmp553_;
										ValaProperty* _tmp554_;
										gchar* _tmp555_;
										gchar* _tmp556_;
										const gchar* _tmp557_;
										gchar* _tmp558_;
										gchar* _tmp559_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp549_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp550_ = _tmp549_;
										_tmp551_ = prop;
										_tmp552_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp551_);
										_tmp553_ = _tmp552_;
										_tmp554_ = base_prop;
										_tmp555_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp554_);
										_tmp556_ = _tmp555_;
										_tmp557_ = invalid_match;
										_tmp558_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp553_, _tmp556_, _tmp557_);
										_tmp559_ = _tmp558_;
										vala_report_error (_tmp550_, _tmp559_);
										_g_free0 (_tmp559_);
										_g_free0 (_tmp556_);
										_g_free0 (_tmp553_);
									}
									_tmp560_ = sym;
									_tmp561_ = vala_symbol_get_version (_tmp560_);
									_tmp562_ = _tmp561_;
									_tmp563_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp564_ = _tmp563_;
									vala_version_attribute_check (_tmp562_, _tmp564_);
									_tmp565_ = sym;
									vala_symbol_set_used (_tmp565_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp566_;
									ValaSourceReference* _tmp567_;
									gchar* _tmp568_;
									gchar* _tmp569_;
									ValaProperty* _tmp570_;
									gchar* _tmp571_;
									gchar* _tmp572_;
									gchar* _tmp573_;
									gchar* _tmp574_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp566_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp567_ = _tmp566_;
									_tmp568_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp569_ = _tmp568_;
									_tmp570_ = prop;
									_tmp571_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp570_);
									_tmp572_ = _tmp571_;
									_tmp573_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp569_, _tmp572_);
									_tmp574_ = _tmp573_;
									vala_report_error (_tmp567_, _tmp574_);
									_g_free0 (_tmp574_);
									_g_free0 (_tmp572_);
									_g_free0 (_tmp569_);
								}
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp575_ = self->priv->_is_abstract;
		if (!_tmp575_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp576_;
			_tmp576_ = self->priv->_base_class;
			base_class = _tmp576_;
			while (TRUE) {
				gboolean _tmp577_ = FALSE;
				ValaClass* _tmp578_;
				ValaClass* _tmp645_;
				ValaClass* _tmp646_;
				_tmp578_ = base_class;
				if (_tmp578_ != NULL) {
					ValaClass* _tmp579_;
					gboolean _tmp580_;
					_tmp579_ = base_class;
					_tmp580_ = _tmp579_->priv->_is_abstract;
					_tmp577_ = _tmp580_;
				} else {
					_tmp577_ = FALSE;
				}
				if (!_tmp577_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp581_;
					ValaList* _tmp582_;
					ValaList* _tmp583_;
					gint _base_method_size = 0;
					ValaList* _tmp584_;
					gint _tmp585_;
					gint _tmp586_;
					gint _base_method_index = 0;
					_tmp581_ = base_class;
					_tmp582_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp581_);
					_tmp583_ = _vala_iterable_ref0 (_tmp582_);
					_base_method_list = _tmp583_;
					_tmp584_ = _base_method_list;
					_tmp585_ = vala_collection_get_size ((ValaCollection*) _tmp584_);
					_tmp586_ = _tmp585_;
					_base_method_size = _tmp586_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp587_;
						gint _tmp588_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp589_;
						gpointer _tmp590_;
						ValaMethod* _tmp591_;
						gboolean _tmp592_;
						gboolean _tmp593_;
						_base_method_index = _base_method_index + 1;
						_tmp587_ = _base_method_index;
						_tmp588_ = _base_method_size;
						if (!(_tmp587_ < _tmp588_)) {
							break;
						}
						_tmp589_ = _base_method_list;
						_tmp590_ = vala_list_get (_tmp589_, _base_method_index);
						base_method = (ValaMethod*) _tmp590_;
						_tmp591_ = base_method;
						_tmp592_ = vala_method_get_is_abstract (_tmp591_);
						_tmp593_ = _tmp592_;
						if (_tmp593_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp594_;
							const gchar* _tmp595_;
							const gchar* _tmp596_;
							ValaSymbol* _tmp597_;
							ValaMethod* _tmp598_;
							gboolean _tmp599_ = FALSE;
							ValaMethod* _tmp600_;
							_tmp594_ = base_method;
							_tmp595_ = vala_symbol_get_name ((ValaSymbol*) _tmp594_);
							_tmp596_ = _tmp595_;
							_tmp597_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp596_);
							_tmp598_ = VALA_IS_METHOD (_tmp597_) ? ((ValaMethod*) _tmp597_) : NULL;
							if (_tmp598_ == NULL) {
								_vala_code_node_unref0 (_tmp597_);
							}
							override_method = _tmp598_;
							_tmp600_ = override_method;
							if (_tmp600_ == NULL) {
								_tmp599_ = TRUE;
							} else {
								ValaMethod* _tmp601_;
								gboolean _tmp602_;
								gboolean _tmp603_;
								_tmp601_ = override_method;
								_tmp602_ = vala_method_get_overrides (_tmp601_);
								_tmp603_ = _tmp602_;
								_tmp599_ = !_tmp603_;
							}
							if (_tmp599_) {
								ValaSourceReference* _tmp604_;
								ValaSourceReference* _tmp605_;
								gchar* _tmp606_;
								gchar* _tmp607_;
								ValaMethod* _tmp608_;
								gchar* _tmp609_;
								gchar* _tmp610_;
								gchar* _tmp611_;
								gchar* _tmp612_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp604_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp605_ = _tmp604_;
								_tmp606_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp607_ = _tmp606_;
								_tmp608_ = base_method;
								_tmp609_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp608_);
								_tmp610_ = _tmp609_;
								_tmp611_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp607_, _tmp610_);
								_tmp612_ = _tmp611_;
								vala_report_error (_tmp605_, _tmp612_);
								_g_free0 (_tmp612_);
								_g_free0 (_tmp610_);
								_g_free0 (_tmp607_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp613_;
					ValaList* _tmp614_;
					ValaList* _tmp615_;
					gint _base_property_size = 0;
					ValaList* _tmp616_;
					gint _tmp617_;
					gint _tmp618_;
					gint _base_property_index = 0;
					_tmp613_ = base_class;
					_tmp614_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp613_);
					_tmp615_ = _vala_iterable_ref0 (_tmp614_);
					_base_property_list = _tmp615_;
					_tmp616_ = _base_property_list;
					_tmp617_ = vala_collection_get_size ((ValaCollection*) _tmp616_);
					_tmp618_ = _tmp617_;
					_base_property_size = _tmp618_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp619_;
						gint _tmp620_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp621_;
						gpointer _tmp622_;
						ValaProperty* _tmp623_;
						gboolean _tmp624_;
						gboolean _tmp625_;
						_base_property_index = _base_property_index + 1;
						_tmp619_ = _base_property_index;
						_tmp620_ = _base_property_size;
						if (!(_tmp619_ < _tmp620_)) {
							break;
						}
						_tmp621_ = _base_property_list;
						_tmp622_ = vala_list_get (_tmp621_, _base_property_index);
						base_property = (ValaProperty*) _tmp622_;
						_tmp623_ = base_property;
						_tmp624_ = vala_property_get_is_abstract (_tmp623_);
						_tmp625_ = _tmp624_;
						if (_tmp625_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp626_;
							const gchar* _tmp627_;
							const gchar* _tmp628_;
							ValaSymbol* _tmp629_;
							ValaProperty* _tmp630_;
							gboolean _tmp631_ = FALSE;
							ValaProperty* _tmp632_;
							_tmp626_ = base_property;
							_tmp627_ = vala_symbol_get_name ((ValaSymbol*) _tmp626_);
							_tmp628_ = _tmp627_;
							_tmp629_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp628_);
							_tmp630_ = VALA_IS_PROPERTY (_tmp629_) ? ((ValaProperty*) _tmp629_) : NULL;
							if (_tmp630_ == NULL) {
								_vala_code_node_unref0 (_tmp629_);
							}
							override_property = _tmp630_;
							_tmp632_ = override_property;
							if (_tmp632_ == NULL) {
								_tmp631_ = TRUE;
							} else {
								ValaProperty* _tmp633_;
								gboolean _tmp634_;
								gboolean _tmp635_;
								_tmp633_ = override_property;
								_tmp634_ = vala_property_get_overrides (_tmp633_);
								_tmp635_ = _tmp634_;
								_tmp631_ = !_tmp635_;
							}
							if (_tmp631_) {
								ValaSourceReference* _tmp636_;
								ValaSourceReference* _tmp637_;
								gchar* _tmp638_;
								gchar* _tmp639_;
								ValaProperty* _tmp640_;
								gchar* _tmp641_;
								gchar* _tmp642_;
								gchar* _tmp643_;
								gchar* _tmp644_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp636_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp637_ = _tmp636_;
								_tmp638_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp639_ = _tmp638_;
								_tmp640_ = base_property;
								_tmp641_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp640_);
								_tmp642_ = _tmp641_;
								_tmp643_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp639_, _tmp642_);
								_tmp644_ = _tmp643_;
								vala_report_error (_tmp637_, _tmp644_);
								_g_free0 (_tmp644_);
								_g_free0 (_tmp642_);
								_g_free0 (_tmp639_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp645_ = base_class;
				_tmp646_ = _tmp645_->priv->_base_class;
				base_class = _tmp646_;
			}
		}
	}
	_tmp647_ = vala_code_context_get_analyzer (context);
	_tmp648_ = _tmp647_;
	_tmp649_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp648_, _tmp649_);
	_tmp650_ = vala_code_context_get_analyzer (context);
	_tmp651_ = _tmp650_;
	_tmp652_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp651_, _tmp652_);
	_tmp653_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp654_ = _tmp653_;
	result = !_tmp654_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_class_class_init (ValaClassClass * klass,
                       gpointer klass_data)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}

static void
vala_class_instance_init (ValaClass * self,
                          gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_symbol_hash_func_ghash_func, _vala_symbol_equal_func_gequal_func, _tmp2_);
	self->priv->implicit_implementations = _tmp3_;
}

static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_g_free0 (self->priv->_is_singleton);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_map_unref0 (self->priv->implicit_implementations);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
static GType
vala_class_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
	GType vala_class_type_id;
	vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
	ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
	return vala_class_type_id;
}

GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		GType vala_class_type_id;
		vala_class_type_id = vala_class_get_type_once ();
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}

