--- texk/xdvik/tounimap2h.lua.orig	2015-07-19 18:49:42 UTC
+++ texk/xdvik/tounimap2h.lua
@@ -0,0 +1,80 @@
+-- Copyright (c) 2011-2013 Hironori KITAGAWA
+--
+-- Permission is hereby granted, free of charge, to any person
+-- obtaining a copy of this software and associated documentation
+-- files (the "Software"), to deal in the Software without
+-- restriction, including without limitation the rights to use, copy,
+-- modify, merge, publish, distribute, sublicense, and/or sell copies
+-- of the Software, and to permit persons to whom the Software is
+-- furnished to do so, subject to the following conditions:
+--
+-- The above copyright notice and this permission notice shall be
+-- included in all copies or substantial portions of the Software.
+--
+-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
+-- EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
+-- MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
+-- NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
+-- BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
+-- ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
+-- CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
+-- SOFTWARE.
+
+-- usage: tounimap2h.lua <ToUniCode> <function name> <end cid number>
+
+local result = {}
+print("/* This file was generated by tounimap2h.lua.\n"
+	     .. "Used ToUnicode table is: " .. arg[1] .. ".*/\n")
+local line = io.read("*l")
+local function info(a) io.stderr:write(a) end
+
+local function bfchar() 
+   info('*')
+   line = io.read("*l")
+   while  line and line ~= "endbfchar" do
+      if string.len(line) == 13 then
+	 local cid = tonumber(string.sub(line,2,5), 16); 
+	 local code = tonumber(string.sub(line,9,12), 16); 
+	 result[cid] = code
+      end
+      line = io.read()
+   end
+end
+local function bfrange() 
+   info('+')
+   line = io.read("*l")
+   while  line and line ~= "endbfrange" do
+      if string.len(line) == 20 then
+	 local cidb = tonumber(string.sub(line,2,5), 16); 
+	 local cide = tonumber(string.sub(line,9,12), 16); 
+	 local code = tonumber(string.sub(line,16,19), 16); 
+	 for x = cidb, cide do result[x] = code+x-cidb end
+      end
+      line = io.read()
+   end
+end
+
+while  line do
+   if string.match(line,"beginbfchar") then
+      bfchar()
+   elseif string.match(line,"beginbfrange") then
+      bfrange()
+   elseif line~="" then 
+      info("-")
+   end
+   line = io.read()
+end
+
+info("\n")
+
+print("static unsigned short " .. arg[2] .. "2uni_table[] = {")
+
+for x=0,arg[3] do 
+   if x%10==0 then io.write("  ") end
+   io.write((result[x] or 0) .. ', ')
+   if x%10 == 9 then io.write("\n")  end
+end
+
+print("}; \n")
+
+print("#define " .. arg[2] .. "2uni(cid) (" .. arg[2] .. "2uni_table[cid])\n")
