/*-
 * Copyright (C) 1988-1998 Specialix International.
 *
 * Download code for SI/XIO host cards.
 *
 * Redistribution and use in binary forms (this file is a binary form), with
 * or without modification, are permitted provided that the following
 * conditions are met:
 * 1. Redistributions in binary form must reproduce the above copyright
 *    notices, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 2. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Specialix International.
 * 3. The name of Specialix International may not be used to endorse or
 *    promote products derived from this software without specific prior
 *    written permission.
 * 4. No attempt is made to decompile, reverse engineer or otherwise
 *    discover the source code of the contents of this file. The source
 *    code is regarded as an unpublished trade secret held by Specialix
 *    International.
 *
 * THIS SOFTWARE IS PROVIDED BY ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHORS BE LIABLE.
 *
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/7/sys/dev/si/si2_z280.c 154087 2006-01-06 20:17:48Z jhb $");

#include <sys/param.h>
#include <sys/bus.h>
#include <dev/si/sivar.h>

/* SI2_Z280.C Version, Bootstrap and Download Code Arrays... */

/* SI2_Z280 embedded version... 

	Copyright (c) Specialix Research Ltd 1988-1998
	Z280 Download Code Version 1.42
	

*/

unsigned char si2_z280_download[] =
{
	0x00,0xC3,0x86,0x00,0x02,0x00,0x08,0x01,	/* 0000: .Æ..... */
	0x00,0x00,0x88,0x18,0x00,0x00,0x8C,0x18,	/* 0008: ...... */
	0x00,0x00,0xF6,0x1A,0x00,0x00,0xC5,0x04,	/* 0010: ...... */
	0x02,0x00,0x08,0x01,0x02,0x00,0x08,0x01,	/* 0018: ........ */
	0x02,0x00,0x08,0x01,0x02,0x00,0x08,0x01,	/* 0020: ........ */
	0x02,0x00,0x08,0x01,0x00,0x00,0xED,0x0F,	/* 0028: ....... */
	0x00,0x00,0x0C,0x10,0x02,0x00,0x08,0x01,	/* 0030: ........ */
	0x02,0x00,0x08,0x01,0x00,0x00,0x00,0x00,	/* 0038: ........ */
	0x20,0x00,0x00,0x01,0x00,0x3C,0x00,0x00,	/* 0040:  ....<.. */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 0048: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 0050: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 0058: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 0060: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 0068: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 0070: ........ */
	0x00,0x3A,0x47,0x00,0xFE,0x00,0xC2,0x08,	/* 0078: .:G... */
	0x01,0xDD,0x3E,0x48,0x00,0x01,0x31,0xBF,	/* 0080: .>H..1 */
	0x00,0xC3,0x2A,0x13,0xFF,0xFF,0xFF,0xFF,	/* 0088: .*. */
	0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xCC,	/* 0090: ...... */
	0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,	/* 0098:  */
	0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,	/* 00A0:  */
	0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,	/* 00A8:  */
	0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,	/* 00B0:  */
	0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x3A,	/* 00B8: : */
	0x41,0x00,0xFE,0x00,0xC2,0x2A,0x13,0x21,	/* 00C0: A..*.! */
	0x00,0x08,0x0E,0xF0,0xED,0xBF,0x00,0x00,	/* 00C8: ..... */
	0x00,0x21,0x40,0x00,0x0E,0x12,0xED,0x6E,	/* 00D0: .!@...n */
	0x3A,0x92,0x00,0xFE,0x01,0x20,0x05,0x21,	/* 00D8: :.. .! */
	0xC2,0x05,0x18,0x03,0x21,0x8C,0x18,0x7D,	/* 00E0: ...!.} */
	0xE6,0xF0,0x6F,0x3E,0x00,0x46,0x23,0x3D,	/* 00E8: o>.F#= */
	0xFE,0x00,0x20,0xF9,0x21,0x80,0x00,0x0E,	/* 00F0: . !.. */
	0x12,0xED,0x6E,0xDD,0x3E,0x47,0x00,0x01,	/* 00F8: .n>G.. */
	0xCD,0x15,0x01,0x00,0x18,0xFE,0x00,0x00,	/* 0100: ...... */
	0xDD,0xD1,0x06,0x01,0xED,0x55,0xDD,0x3E,	/* 0108: ..U> */
	0x00,0x00,0xFE,0x76,0xC9,0xCD,0xF9,0x01,	/* 0110: ..v. */
	0xFE,0x01,0x20,0x03,0xCD,0x89,0x04,0xC9,	/* 0118: . .͉. */
	0xE0,0x81,0x80,0x80,0x00,0x00,0x00,0x00,	/* 0120: .... */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 0128: ........ */
	0x8C,0x00,0xF0,0xD0,0x00,0xF0,0x00,0xC0,	/* 0130: ... */
	0x00,0x00,0xF0,0xD0,0x00,0xF0,0x00,0xC0,	/* 0138: .... */
	0x00,0x00,0x21,0x0D,0x00,0x0E,0xFF,0xED,	/* 0140: ..!... */
	0x6E,0x21,0xF8,0x2F,0x11,0x0E,0x80,0x01,	/* 0148: n!.... */
	0x08,0x00,0xED,0xB0,0x2A,0x43,0x00,0x0E,	/* 0150: ..*C.. */
	0xFF,0xED,0x6E,0xDD,0x3E,0x16,0x80,0x00,	/* 0158: n>.. */
	0xC9,0x79,0xFE,0x00,0x28,0x2A,0xED,0x2D,	/* 0160: y.(*- */
	0xA0,0xFF,0xED,0x2A,0x00,0x00,0x3A,0x2F,	/* 0168: *..:. */
	0x01,0xFE,0x40,0x20,0x07,0xFD,0xED,0xF6,	/* 0170: .@ . */
	0xA0,0x18,0x18,0x05,0xFD,0xED,0xF6,0xA0,	/* 0178: ... */
	0x02,0xDD,0x2A,0x24,0x01,0xED,0x2D,0x00,	/* 0180: .*$.-. */
	0x00,0xE5,0xDD,0xE1,0xDD,0x22,0x24,0x01,	/* 0188: ."$. */
	0x78,0x32,0x2F,0x01,0xED,0x2A,0x00,0x00,	/* 0190: x2..*.. */
	0xDD,0x01,0x00,0x00,0xDD,0x73,0x08,0xDD,	/* 0198: ...s. */
	0x36,0x1C,0x00,0xDD,0x36,0x1D,0x00,0x7B,	/* 01A0: 6..6..{ */
	0xE6,0x0F,0xDD,0x77,0x02,0xDD,0x71,0x03,	/* 01A8: .w.q. */
	0xFD,0xED,0x2D,0x06,0x00,0x7B,0xE6,0xE0,	/* 01B0: -..{ */
	0xFE,0x00,0x20,0x08,0xDD,0x36,0x04,0x00,	/* 01B8: . .6.. */
	0xFD,0x36,0x40,0xFF,0xDD,0xE5,0xFD,0x7E,	/* 01C0: 6@~ */
	0x7F,0xDD,0x77,0x1E,0x3E,0x08,0xED,0x2A,	/* 01C8: w.>.* */
	0x0A,0x00,0xDD,0xED,0x2A,0x60,0x01,0xDD,	/* 01D0: ..*`. */
	0xE5,0xDD,0xC1,0x3D,0x28,0x0C,0xDD,0xED,	/* 01D8: =(. */
	0x2A,0x00,0x03,0xFD,0xED,0xF6,0x02,0x00,	/* 01E0: *.... */
	0x18,0xED,0xDD,0xE1,0xED,0x2A,0x00,0x00,	/* 01E8: .*.. */
	0xFD,0xED,0xF6,0x60,0x01,0xE5,0xDD,0xE1,	/* 01F0: `. */
	0xC9,0x21,0x40,0x00,0x5E,0xDD,0x11,0x02,	/* 01F8: !@.^.. */
	0x80,0xFF,0xFF,0xDD,0x3E,0x06,0x80,0x01,	/* 0200: >.. */
	0xDD,0x3E,0x82,0x80,0x00,0xDD,0x21,0x80,	/* 0208: >.! */
	0x80,0xDD,0x22,0x24,0x01,0xFD,0x21,0x00,	/* 0210: "$.!. */
	0x70,0xFD,0x22,0x28,0x01,0x0E,0x00,0x16,	/* 0218: p"(.... */
	0x01,0xE5,0x2A,0x30,0x01,0x7E,0xDD,0x13,	/* 0220: .*0.~. */
	0x30,0x01,0xE1,0xFE,0xFF,0xCA,0x76,0x03,	/* 0228: 0.v. */
	0x5F,0xFE,0x04,0x28,0x10,0xFE,0x24,0x28,	/* 0230: _.(.$( */
	0x0C,0x06,0x08,0xDD,0x3E,0x2E,0x01,0x08,	/* 0238: ...>... */
	0xCD,0x61,0x01,0x18,0x0C,0x06,0x04,0xDD,	/* 0240: a..... */
	0x3E,0x2E,0x01,0x04,0xCD,0x61,0x01,0x18,	/* 0248: >...a.. */
	0x00,0x21,0xA0,0x02,0xDD,0x0E,0x00,0x2B,	/* 0250: .!...+ */
	0xFD,0xED,0xF7,0xA0,0xFF,0x20,0xF5,0xFD,	/* 0258:   */
	0xED,0x2D,0xA2,0xFF,0xDD,0x36,0xC2,0xFF,	/* 0260: -6 */
	0x7B,0xE6,0xE0,0xDD,0x77,0xC4,0xFE,0x00,	/* 0268: {w. */
	0x20,0x2A,0xED,0x32,0x00,0x00,0xCB,0x9D,	/* 0270:  *2..˝ */
	0xFD,0x36,0x02,0x0A,0xFD,0x1E,0x04,0x00,	/* 0278: 6..... */
	0xE0,0xFD,0x1E,0x05,0x00,0x00,0xCD,0xD3,	/* 0280: .... */
	0x1D,0xFD,0x7B,0x0E,0x00,0xFD,0x1E,0x0D,	/* 0288: .{.... */
	0x00,0x00,0xFD,0x36,0x02,0x90,0xDD,0x36,	/* 0290: ..6.6 */
	0xA6,0x01,0x18,0x00,0xDD,0x36,0xAE,0x10,	/* 0298: ...6. */
	0xDD,0x36,0xBF,0x01,0xDD,0x72,0xAF,0x2A,	/* 02A0: 6.r* */
	0x24,0x01,0xED,0x2D,0xA4,0xFF,0x3A,0x2E,	/* 02A8: $.-:. */
	0x01,0x90,0xDD,0x77,0xA7,0xFE,0x04,0xFA,	/* 02B0: .w. */
	0xC9,0x02,0xFD,0x7E,0x7F,0xE6,0xF0,0xCB,	/* 02B8: .~ */
	0x3F,0xCB,0x3F,0xCB,0x3F,0xCB,0x3F,0x18,	/* 02C0: ????. */
	0x05,0xFD,0x7E,0x7F,0xE6,0x0F,0xDD,0x77,	/* 02C8: .~.w */
	0xC4,0x21,0x32,0x01,0xC5,0x4F,0xE6,0x07,	/* 02D0: !2.O. */
	0xFE,0x05,0x20,0x17,0x78,0xFE,0x08,0x28,	/* 02D8: . .x.( */
	0x04,0xFE,0x04,0x20,0x0E,0xDD,0x36,0xC7,	/* 02E0: .. .6 */
	0x01,0x3E,0x08,0x90,0xFD,0x77,0x7F,0xFD,	/* 02E8: .>.w */
	0x36,0x4B,0x80,0x06,0x00,0xED,0xC6,0x7E,	/* 02F0: 6K..~ */
	0xDD,0x77,0xC6,0xC1,0x05,0x20,0x23,0x2A,	/* 02F8: w. #* */
	0x28,0x01,0xFD,0xED,0xF6,0x80,0x00,0x22,	/* 0300: (.." */
	0x28,0x01,0xFD,0x2A,0x28,0x01,0x2A,0x20,	/* 0308: (.*(.*  */
	0x01,0xED,0x2D,0xA0,0xFF,0xED,0x2A,0x00,	/* 0310: .-*. */
	0x00,0xFD,0xED,0xF6,0x00,0x04,0x0C,0xC3,	/* 0318: .... */
	0x1F,0x02,0xED,0x2A,0x00,0x00,0xFD,0xED,	/* 0320: ..*.. */
	0xF6,0x00,0x03,0xED,0x2D,0xA0,0xFF,0xE5,	/* 0328: ..- */
	0xDD,0xE1,0xED,0x32,0x00,0x00,0x3A,0x2E,	/* 0330: 2..:. */
	0x01,0xFE,0x08,0x20,0x14,0x7B,0xFE,0x28,	/* 0338: .. .{( */
	0xCA,0x51,0x02,0xFE,0x48,0xCA,0x51,0x02,	/* 0340: Q.HQ. */
	0xFD,0xED,0xF6,0x08,0x00,0xCB,0x02,0x18,	/* 0348: .... */
	0x1F,0x7B,0xFE,0x24,0xCA,0x51,0x02,0x78,	/* 0350: .{$Q.x */
	0xFE,0x02,0x20,0x09,0xFD,0xED,0xF6,0x08,	/* 0358: . .. */
	0x00,0xCB,0x02,0x18,0x0B,0xFD,0xED,0xF6,	/* 0360: .... */
	0x18,0x00,0xCB,0x02,0xCB,0x02,0xCB,0x02,	/* 0368: ..... */
	0xE5,0xFD,0xE1,0xC3,0x51,0x02,0xCD,0x42,	/* 0370: Q.B */
	0x01,0xDD,0x11,0x04,0x80,0x42,0x01,0xDD,	/* 0378: ...B. */
	0x3E,0x00,0x80,0x01,0x3E,0x01,0xC9,0xFD,	/* 0380: >..>. */
	0xED,0x2C,0xA2,0xFF,0xCD,0x8D,0x0E,0x18,	/* 0388: ,͍.. */
	0x05,0xFD,0xED,0x2C,0xA2,0xFF,0xCD,0xE4,	/* 0390: ., */
	0x0D,0x26,0x00,0xC3,0xF1,0x05,0xFD,0xED,	/* 0398: .&.. */
	0x2C,0xA2,0xFF,0xCD,0x8D,0x0E,0x26,0x00,	/* 03A0: ,͍.&. */
	0xC3,0xF1,0x05,0xFD,0xED,0x2C,0xA2,0xFF,	/* 03A8: ., */
	0xCD,0x11,0x0E,0x26,0x00,0xC3,0xF1,0x05,	/* 03B0: ..&.. */
	0xFD,0xED,0x2C,0xA2,0xFF,0xCD,0x2E,0x0E,	/* 03B8: ,.. */
	0x26,0x00,0xC3,0xF1,0x05,0xFD,0xED,0x2C,	/* 03C0: &.., */
	0xA2,0xFF,0xFD,0x36,0x02,0x60,0xDD,0x36,	/* 03C8: 6.`6 */
	0xAE,0x12,0xDD,0x3E,0xC3,0x05,0x01,0x26,	/* 03D0: .>..& */
	0x00,0xC3,0xF1,0x05,0xFD,0xED,0x2C,0xA2,	/* 03D8: .., */
	0xFF,0xFD,0x36,0x02,0x75,0xDD,0x36,0xAE,	/* 03E0: 6.u6 */
	0x00,0xDD,0x3E,0xC3,0x05,0x01,0x26,0x00,	/* 03E8: .>..&. */
	0xC3,0xF1,0x05,0x26,0x00,0xC3,0xF1,0x05,	/* 03F0: .&.. */
	0xFD,0xED,0x2C,0xA2,0xFF,0xDD,0x7E,0xAD,	/* 03F8: ,~ */
	0xDD,0x77,0xAC,0xDD,0x7E,0xB5,0xE6,0x10,	/* 0400: w~. */
	0x28,0x25,0xED,0x32,0x00,0x00,0xCB,0x5D,	/* 0408: (%2..] */
	0x28,0x0A,0xCB,0x9D,0xFD,0x7B,0x0D,0x00,	/* 0410: (.˝{.. */
	0xCB,0x2F,0x18,0x06,0xFD,0x7B,0x0D,0x00,	/* 0418: ...{.. */
	0xCB,0x27,0x2F,0xE6,0x02,0x20,0x08,0xFD,	/* 0420: '.. . */
	0x36,0x02,0x30,0xFD,0x36,0x02,0x04,0xDD,	/* 0428: 6.06.. */
	0x7E,0xA8,0xE6,0x06,0xFE,0x06,0x20,0x0E,	/* 0430: ~.. . */
	0xDD,0xCB,0xA8,0x96,0xDD,0xCB,0xA9,0x4E,	/* 0438: ˨˩N */
	0x20,0x04,0xDD,0xCB,0xA3,0xA6,0xDD,0x36,	/* 0440:  .ˣ6 */
	0xAE,0x00,0xDD,0x3E,0xC3,0x05,0x01,0x26,	/* 0448: .>..& */
	0x00,0xC3,0xF1,0x05,0xFD,0xED,0x2C,0xA2,	/* 0450: .., */
	0xFF,0xDD,0x7E,0xAB,0xDD,0x77,0xAA,0xDD,	/* 0458: ~w */
	0x36,0xAE,0x00,0xDD,0x3E,0xC3,0x05,0x01,	/* 0460: 6.>.. */
	0x26,0x00,0xC3,0xF1,0x05,0xDD,0xCB,0xA8,	/* 0468: &..˨ */
	0x4E,0x28,0x08,0xDD,0xCB,0xA8,0xD6,0xDD,	/* 0470: N(.˨ */
	0xCB,0xA3,0xE6,0xDD,0x36,0xAE,0x00,0xDD,	/* 0478: ˣ6. */
	0x3E,0xC3,0x05,0x01,0x26,0x00,0xC3,0xF1,	/* 0480: >..&. */
	0x05,0xDD,0x2A,0x20,0x01,0x21,0xFE,0x00,	/* 0488: .* .!. */
	0x0E,0x08,0xED,0x6E,0x3E,0x28,0xD3,0xE0,	/* 0490: ..n>( */
	0x2A,0x02,0x80,0x01,0xE2,0x00,0xED,0xBF,	/* 0498: *... */
	0x3E,0xE0,0xD3,0xE1,0x3A,0x06,0x80,0x32,	/* 04A0: >:.2 */
	0xC2,0x04,0x21,0xFF,0x00,0x0E,0x08,0xED,	/* 04A8: .!... */
	0x6E,0x26,0x00,0x3A,0x93,0x00,0xFE,0x01,	/* 04B0: n&.:.. */
	0xC2,0xF6,0x05,0xD9,0x26,0x00,0xD9,0xC3,	/* 04B8: .&. */
	0x12,0x0D,0x00,0x00,0x00,0xDD,0xD1,0xC3,	/* 04C0: ..... */
	0x04,0xF5,0xC5,0xE5,0xDD,0xE5,0xFD,0xE5,	/* 04C8: . */
	0x3A,0x16,0x80,0xFE,0x01,0x20,0x08,0xCD,	/* 04D0: :.. . */
	0x42,0x01,0xDD,0x3E,0xC3,0x05,0x01,0x3A,	/* 04D8: B.>..: */
	0x93,0x00,0xFE,0x01,0x28,0x2C,0xDD,0x21,	/* 04E0: ..(,! */
	0xE0,0x81,0x18,0x10,0xDD,0xED,0x2C,0xA0,	/* 04E8: .., */
	0xFF,0xED,0x2A,0x00,0x00,0xFD,0xED,0xF7,	/* 04F0: *.. */
	0xE0,0x81,0x28,0x16,0xDD,0x7E,0xAE,0xFE,	/* 04F8: (.~ */
	0x00,0x20,0xE9,0xFD,0xED,0x2C,0xA2,0xFF,	/* 0500: . , */
	0xDD,0x46,0xA9,0xCB,0x68,0x28,0xDD,0xC3,	/* 0508: Fh( */
	0x72,0x08,0x21,0xFE,0x00,0x0E,0x08,0xED,	/* 0510: r.!... */
	0x6E,0x2A,0x02,0x80,0x01,0xE2,0x00,0xED,	/* 0518: n*... */
	0xBF,0x3E,0x00,0xD3,0xE1,0x3E,0xE0,0xD3,	/* 0520: >.> */
	0xE1,0x3A,0x93,0x00,0xFE,0x01,0x28,0x03,	/* 0528: :..(. */
	0xED,0x7F,0x01,0xDD,0x13,0x0A,0x80,0xDD,	/* 0530: ... */
	0x3C,0x0C,0x80,0x3A,0xC3,0x05,0xFE,0x00,	/* 0538: <.:.. */
	0x20,0x0E,0x3A,0xC2,0x05,0xFE,0x00,0x28,	/* 0540:  .:..( */
	0x27,0x3A,0xC2,0x04,0xFE,0x00,0x20,0x20,	/* 0548: ':..   */
	0xDD,0x3E,0x01,0xF0,0x01,0xDD,0x3E,0xC2,	/* 0550: >..> */
	0x05,0x00,0x3A,0x08,0x80,0xFE,0x01,0x28,	/* 0558: ..:..( */
	0x0A,0xDD,0x3E,0x0C,0x80,0x00,0xDD,0x3E,	/* 0560: .>..> */
	0x08,0x80,0x01,0xDD,0x3E,0xC3,0x05,0x00,	/* 0568: ..>.. */
	0xF3,0x3A,0xC2,0x04,0xFE,0x00,0x20,0x06,	/* 0570: :.. . */
	0x3A,0x06,0x80,0x32,0xC2,0x04,0xDD,0x3D,	/* 0578: :.2.= */
	0xC2,0x04,0x21,0xFF,0x00,0x0E,0x08,0xED,	/* 0580: .!... */
	0x6E,0xFD,0xE1,0xDD,0xE1,0xE1,0xC1,0xF1,	/* 0588: n */
	0xED,0x55,0xC4,0x05,0x9E,0x03,0x87,0x03,	/* 0590: U... */
	0x91,0x03,0x9E,0x03,0xAB,0x03,0xC5,0x03,	/* 0598: .... */
	0xDC,0x03,0xF3,0x03,0xF3,0x03,0xB8,0x03,	/* 05A0: .... */
	0x2F,0x04,0xF8,0x03,0x54,0x04,0x6D,0x04,	/* 05A8: ...T.m. */
	0xF3,0x03,0xF3,0x03,0xF3,0x03,0x29,0x10,	/* 05B0: ...). */
	0xFD,0x10,0xF3,0x03,0xF3,0x03,0xC7,0x11,	/* 05B8: .... */
	0x29,0x10,0x00,0x00,0xFD,0xED,0x2C,0xA2,	/* 05C0: )..., */
	0xFF,0xFD,0x4C,0xFD,0x5E,0x01,0xCB,0x61,	/* 05C8: L^.a */
	0x20,0x38,0xCB,0x53,0x28,0x17,0xDD,0x6E,	/* 05D0:  8S(.n */
	0xAC,0xDD,0x7E,0xAD,0x95,0x28,0x0E,0xE6,	/* 05D8: ~(. */
	0x3F,0xCA,0x27,0x07,0xDD,0x79,0xFD,0x77,	/* 05E0: ?'.yw */
	0x03,0x2C,0xDD,0x75,0xAC,0xCB,0x43,0x20,	/* 05E8: .,uC  */
	0x52,0xDD,0x7E,0xA1,0xDD,0x67,0xDD,0x7E,	/* 05F0: R~g~ */
	0xAE,0xFE,0x00,0x28,0xC7,0xFE,0x10,0x28,	/* 05F8: .(.( */
	0xF0,0x6F,0xFD,0xED,0xF6,0x92,0x05,0xED,	/* 0600: o. */
	0x26,0xE9,0xDD,0x4E,0xA8,0xDD,0x46,0xA9,	/* 0608: &NF */
	0xCB,0x53,0x28,0x25,0xCB,0x71,0xC2,0xDC,	/* 0610: S(%q */
	0x06,0xCB,0x51,0x20,0x1C,0xDD,0x6E,0xAC,	/* 0618: .Q .n */
	0xDD,0x7E,0xAD,0x95,0x28,0x13,0xE6,0x3F,	/* 0620: ~(.? */
	0xCA,0x00,0x07,0xDD,0x79,0xFE,0x0A,0xCA,	/* 0628: ..y. */
	0xE3,0x06,0xFD,0x77,0x03,0x2C,0xDD,0x75,	/* 0630: .w.,u */
	0xAC,0xCB,0x43,0x20,0x0C,0xCB,0x61,0x20,	/* 0638: C .a  */
	0x6A,0x18,0xAE,0xDD,0x4E,0xA8,0xDD,0x46,	/* 0640: j.NF */
	0xA9,0xFD,0x36,0x02,0x40,0xFD,0x7E,0x03,	/* 0648: 6.@~. */
	0xDD,0xA6,0xC3,0xFE,0x00,0xCA,0x10,0x08,	/* 0650: ݦ... */
	0xCB,0x49,0x20,0x34,0x08,0xDD,0x6E,0xAA,	/* 0658: I 4.n */
	0x7D,0x3C,0xDD,0x96,0xAB,0xCB,0x7F,0x28,	/* 0660: }<ݖ( */
	0x05,0xFE,0xFE,0xF2,0xED,0x08,0x08,0x26,	/* 0668: ...& */
	0x01,0xCB,0x78,0xC2,0x2F,0x08,0xED,0x0B,	/* 0670: .x... */
	0x26,0x00,0x2C,0xDD,0x75,0xAA,0xDD,0x3E,	/* 0678: &.,u> */
	0xC2,0x05,0x01,0xCB,0x59,0xCA,0xED,0x08,	/* 0680: ..Y. */
	0x08,0xFE,0xC0,0xCA,0x96,0x07,0x18,0x23,	/* 0688: .ʖ..# */
	0xCB,0x41,0xCA,0xE6,0x07,0xCB,0x51,0xC2,	/* 0690: A.Q */
	0xEC,0x07,0xDD,0xBE,0xB1,0x20,0xBD,0xCB,	/* 0698: .ݾ  */
	0xD1,0xDD,0xCB,0xA3,0xE6,0xDD,0x71,0xA8,	/* 06A0: ˣq */
	0xC3,0xED,0x08,0xDD,0x6E,0xAA,0x7D,0x3C,	/* 06A8: .n}< */
	0xDD,0x96,0xAB,0xCB,0x7F,0xC2,0xED,0x08,	/* 06B0: ݖ. */
	0xFE,0x40,0xF2,0xED,0x08,0xCB,0x79,0xC2,	/* 06B8: @.y */
	0xC2,0x07,0xCB,0x69,0xCA,0xED,0x08,0xCB,	/* 06C0: .i. */
	0xA1,0xCB,0xF1,0xDD,0x71,0xA8,0xDD,0xCB,	/* 06C8: q */
	0xB4,0x7E,0xCA,0xED,0x08,0xFD,0x36,0x02,	/* 06D0: ~.6. */
	0x80,0xC3,0xED,0x08,0xCB,0x79,0xC2,0x7E,	/* 06D8: .y~ */
	0x07,0x18,0x6B,0xCB,0x50,0xCA,0x32,0x06,	/* 06E0: ..kP2. */
	0xCB,0x40,0x20,0x0C,0xFD,0x36,0x03,0x0D,	/* 06E8: @ .6.. */
	0xCB,0xC0,0xDD,0x70,0xA9,0xC3,0x39,0x06,	/* 06F0: p9. */
	0xCB,0x80,0xDD,0x70,0xA9,0xC3,0x32,0x06,	/* 06F8: ˀp2. */
	0xDD,0x7E,0xAD,0x95,0xFE,0x40,0x20,0x12,	/* 0700: ~@ . */
	0xCB,0x58,0xCA,0x2B,0x06,0xCB,0x98,0xDD,	/* 0708: X+.˘ */
	0x70,0xA9,0xDD,0x3E,0xC3,0x05,0x01,0xC3,	/* 0710: p>.. */
	0x2B,0x06,0xFE,0xC0,0xC2,0x2B,0x06,0xCB,	/* 0718: +.+. */
	0xD8,0xDD,0x70,0xA9,0xC3,0x2B,0x06,0xDD,	/* 0720: p+. */
	0x7E,0xAD,0x95,0xFE,0x40,0x20,0x13,0xDD,	/* 0728: ~@ . */
	0xCB,0xA9,0x5E,0xCA,0xE4,0x05,0xDD,0xCB,	/* 0730: ˩^. */
	0xA9,0x9E,0xDD,0x3E,0xC3,0x05,0x01,0xC3,	/* 0738: >.. */
	0xE4,0x05,0xFE,0xC0,0xC2,0xE4,0x05,0xDD,	/* 0740: .. */
	0xCB,0xA9,0xDE,0xC3,0xE4,0x05,0xDD,0xCB,	/* 0748: ˩. */
	0xBA,0x5E,0x28,0x06,0xDD,0x56,0xB2,0xFD,	/* 0750: ^(.V */
	0x72,0x03,0xDD,0xCB,0xB4,0x7E,0x28,0x04,	/* 0758: r.˴~(. */
	0xFD,0x36,0x02,0x80,0xCB,0xB1,0xCB,0xA9,	/* 0760: 6.˱˩ */
	0xCB,0xA1,0xDD,0x71,0xA8,0xCB,0x48,0xC2,	/* 0768: ˡqH */
	0x39,0x06,0xCB,0x51,0xC2,0x39,0x06,0xDD,	/* 0770: 9.Q9. */
	0xCB,0xA3,0xA6,0xC3,0x39,0x06,0xDD,0xCB,	/* 0778: ˣ9. */
	0xBA,0x5E,0x28,0x06,0xDD,0x56,0xB3,0xFD,	/* 0780: ^(.V */
	0x72,0x03,0xCB,0xE9,0xCB,0xB9,0xCB,0xB1,	/* 0788: r.˹˱ */
	0xDD,0x71,0xA8,0xC3,0x39,0x06,0xCB,0x69,	/* 0790: q9.i */
	0x20,0x0F,0xCB,0xF9,0xCB,0xF1,0xCB,0xE1,	/* 0798:  . */
	0xDD,0xCB,0xA3,0xE6,0xDD,0x71,0xA8,0x18,	/* 07A0: ˣq. */
	0x02,0xCB,0xB1,0xDD,0xCB,0xB4,0x7E,0xCA,	/* 07A8: .˱˴~ */
	0xED,0x08,0xFD,0x36,0x02,0x90,0xCB,0xE1,	/* 07B0: .6. */
	0xDD,0xCB,0xA3,0xE6,0xDD,0x71,0xA8,0xC3,	/* 07B8: ˣq */
	0xED,0x08,0xCB,0xB9,0xCB,0xB1,0xCB,0xA1,	/* 07C0: .˹˱ˡ */
	0xDD,0x71,0xA8,0xDD,0xCB,0xB4,0x7E,0x28,	/* 07C8: q˴~( */
	0x04,0xFD,0x36,0x02,0x80,0xCB,0x48,0xC2,	/* 07D0: .6.H */
	0xED,0x08,0xCB,0x51,0xC2,0xED,0x08,0xDD,	/* 07D8: .Q. */
	0xCB,0xA3,0xA6,0xC3,0xED,0x08,0xDD,0xBE,	/* 07E0: ˣ.ݾ */
	0xB0,0xC2,0x9A,0x06,0xCB,0x91,0xCB,0x48,	/* 07E8: .ˑH */
	0x20,0x0C,0xCB,0x61,0x20,0x08,0xCB,0x71,	/* 07F0:  .a .q */
	0x20,0x04,0xDD,0xCB,0xA3,0xA6,0xDD,0x71,	/* 07F8:  .ˣq */
	0xA8,0xDD,0xBE,0xB0,0xCA,0xED,0x08,0xDD,	/* 0800: ݾ. */
	0xBE,0xB1,0xCA,0xED,0x08,0xC3,0x5C,0x06,	/* 0808: .\. */
	0xCB,0x7B,0xCA,0x58,0x06,0xDD,0xCB,0xC1,	/* 0810: {X. */
	0x46,0xC2,0xED,0x08,0xDD,0xCB,0xC1,0x4E,	/* 0818: F.N */
	0xCA,0x58,0x06,0xDD,0xCB,0xB9,0xC6,0xDD,	/* 0820: X.˹ */
	0x3E,0xC3,0x05,0x01,0xC3,0xED,0x08,0x57,	/* 0828: >...W */
	0x7B,0xE6,0x70,0x7A,0x20,0x0E,0xDD,0xCB,	/* 0830: {pz . */
	0xC1,0x56,0xCA,0x76,0x06,0xFE,0xFF,0x28,	/* 0838: Vv.( */
	0x27,0xC3,0x76,0x06,0xDD,0xCB,0xC1,0x5E,	/* 0840: 'v.^ */
	0x28,0x05,0x26,0x00,0xC3,0xED,0x08,0xDD,	/* 0848: (.&.. */
	0xCB,0xC1,0x56,0x20,0x06,0xDD,0x0E,0x00,	/* 0850: V ... */
	0xC3,0x78,0x06,0xDD,0x0E,0xFF,0x2C,0xDD,	/* 0858: x.., */
	0x0E,0x00,0x2C,0xED,0x0B,0xC3,0x78,0x06,	/* 0860: ..,.x. */
	0xDD,0x0E,0xFF,0x2C,0xDD,0x0E,0xFF,0xC3,	/* 0868: .,. */
	0x78,0x06,0xED,0x32,0x00,0x00,0xCB,0x5D,	/* 0870: x.2..] */
	0x28,0x0A,0xCB,0x9D,0xFD,0x7B,0x0D,0x00,	/* 0878: (.˝{.. */
	0xCB,0x2F,0x18,0x06,0xFD,0x7B,0x0D,0x00,	/* 0880: ...{.. */
	0xCB,0x27,0x26,0x00,0x2F,0xCB,0x60,0x20,	/* 0888: '&..`  */
	0x04,0xE6,0x26,0x18,0x02,0xE6,0x24,0xDD,	/* 0890: .&..$ */
	0xBE,0xB8,0xCA,0xEC,0x04,0xF5,0xDD,0xAE,	/* 0898: .ݮ */
	0xB8,0xE6,0x04,0x20,0x10,0xF1,0xDD,0x77,	/* 08A0: . .w */
	0xB8,0xDD,0xCB,0xB9,0xCE,0xDD,0x3E,0xC3,	/* 08A8: ˹> */
	0x05,0x01,0xC3,0xEC,0x04,0xDD,0xCB,0xB5,	/* 08B0: ...˵ */
	0x66,0x28,0xEA,0xF1,0xF5,0xFD,0x36,0x02,	/* 08B8: f(6. */
	0x10,0xFD,0x36,0x02,0x30,0xFD,0x36,0x02,	/* 08C0: .6.06. */
	0x20,0xCB,0x57,0x28,0x0F,0xFD,0x7E,0x00,	/* 08C8:  W(.~. */
	0xDD,0x7E,0xB5,0xFD,0x77,0x00,0xFD,0x36,	/* 08D0: ~w.6 */
	0x02,0x05,0x18,0xC9,0xFD,0x7E,0x00,0xDD,	/* 08D8: ...~. */
	0x7E,0xB5,0xE6,0xEF,0xFD,0x77,0x00,0xFD,	/* 08E0: ~w. */
	0x36,0x02,0x05,0x18,0xB8,0xFD,0x5E,0x01,	/* 08E8: 6...^. */
	0xC3,0xED,0x05,0xFD,0xED,0x2C,0xA2,0xFF,	/* 08F0: ., */
	0xDD,0x7E,0xA7,0xFD,0x77,0x7F,0xE6,0x03,	/* 08F8: ~w. */
	0xFD,0x77,0x68,0xC9,0xF5,0xC5,0xDD,0x7E,	/* 0900: wh~ */
	0xC6,0xFD,0x46,0x6C,0xA0,0x47,0x0E,0x00,	/* 0908: FlG.. */
	0xCB,0x78,0x28,0x02,0xCB,0xD1,0xFD,0x7E,	/* 0910: x(.~ */
	0x09,0xDD,0xCB,0xB5,0x66,0x28,0x04,0xF6,	/* 0918: .˵f(. */
	0x02,0x18,0x02,0xE6,0xFD,0xFD,0x77,0x09,	/* 0920: ...w. */
	0xCB,0x68,0x28,0x02,0xCB,0xF1,0xCB,0x60,	/* 0928: h(.` */
	0x28,0x02,0xCB,0xE9,0xCB,0x70,0x28,0x02,	/* 0930: (.p(. */
	0xCB,0xC9,0xDD,0x71,0xB8,0xC1,0xF1,0xC9,	/* 0938: q */
	0xCD,0xF3,0x08,0xDD,0x7E,0xBF,0xFE,0x01,	/* 0940: .~. */
	0x20,0x22,0xED,0x2C,0xA4,0xFF,0xDD,0x7E,	/* 0948:  ",~ */
	0xA7,0xFE,0x04,0xF2,0x61,0x09,0xFD,0x1C,	/* 0950: .a.. */
	0x1C,0x00,0xF6,0x08,0xFD,0x77,0x7F,0x18,	/* 0958: ...w. */
	0x2D,0xFD,0x1C,0x1D,0x00,0xF6,0x20,0xFD,	/* 0960: -...  */
	0x77,0x7F,0x18,0x22,0xDD,0x7E,0xC5,0xFE,	/* 0968: w."~ */
	0x01,0x28,0x1B,0xDD,0xCB,0xA9,0x4E,0x20,	/* 0970: .(.˩N  */
	0x15,0xDD,0xCB,0xA9,0xC6,0xDD,0x7E,0xC7,	/* 0978: .˩~ */
	0xFE,0x01,0x28,0x05,0xFD,0x36,0x06,0x92,	/* 0980: .(.6. */
	0xC9,0xFD,0x36,0x06,0x94,0xC9,0xDD,0x36,	/* 0988: 6.6 */
	0xBF,0x00,0xFD,0x7E,0x05,0xFE,0x00,0xC0,	/* 0990: .~.. */
	0xDD,0x7E,0xC5,0xFE,0x01,0xCA,0x62,0x0B,	/* 0998: ~.b. */
	0xDD,0x7E,0xC7,0xFE,0x01,0x20,0x19,0xFD,	/* 09A0: ~. . */
	0x7E,0x40,0xFE,0x42,0x28,0x07,0xFD,0x36,	/* 09A8: ~@B(.6 */
	0x72,0x31,0xC3,0xD9,0x0A,0xFD,0x36,0x76,	/* 09B0: r1.6v */
	0x00,0xFD,0x36,0x72,0x42,0xC3,0xD9,0x0A,	/* 09B8: .6rB. */
	0xDD,0x7E,0xB6,0xE6,0x0F,0xCB,0x27,0x4F,	/* 09C0: ~.'O */
	0x06,0x00,0xFD,0x7E,0x40,0xFE,0x42,0x28,	/* 09C8: ..~@B( */
	0x05,0x21,0x68,0x18,0x18,0x03,0x21,0x4C,	/* 09D0: .!h...!L */
	0x18,0xED,0xC6,0x46,0xFD,0x70,0x72,0x23,	/* 09D8: .Fpr# */
	0x46,0xFD,0x70,0x76,0xDD,0x7E,0xB6,0xE6,	/* 09E0: Fpv~ */
	0xF0,0xCB,0x3F,0xCB,0x3F,0xCB,0x3F,0x4F,	/* 09E8: ???O */
	0x06,0x00,0xFD,0x7E,0x40,0xFE,0x42,0x28,	/* 09F0: ..~@B( */
	0x05,0x21,0x68,0x18,0x18,0x03,0x21,0x4C,	/* 09F8: .!h...!L */
	0x18,0xED,0xC6,0x46,0xFD,0x70,0x78,0x23,	/* 0A00: .Fpx# */
	0x46,0xFD,0x70,0x7C,0xDD,0x7E,0xBB,0xFD,	/* 0A08: Fp|~ */
	0x77,0x1A,0xDD,0x7E,0xBC,0xFD,0x77,0x1B,	/* 0A10: w.~w. */
	0xDD,0x7E,0xBD,0xFD,0x77,0x1C,0xDD,0x7E,	/* 0A18: ~w.~ */
	0xBE,0xFD,0x77,0x1D,0xDD,0x36,0xB9,0x00,	/* 0A20: w.6. */
	0xDD,0x7E,0xB4,0xE6,0x03,0x47,0xDD,0x7E,	/* 0A28: ~.G~ */
	0xB4,0xE6,0x14,0xFE,0x10,0x28,0x0C,0xFE,	/* 0A30: ..(. */
	0x04,0x28,0x04,0x3E,0x40,0x18,0x06,0x3E,	/* 0A38: .(.>@..> */
	0xC0,0x18,0x02,0x3E,0x00,0xB0,0x47,0xDD,	/* 0A40: ..>.G */
	0x7E,0xBA,0xE6,0x80,0x20,0x04,0x78,0xF6,	/* 0A48: ~ .x */
	0x10,0x47,0xDD,0x7E,0xB5,0xE6,0x0F,0xFE,	/* 0A50: .G~. */
	0x07,0x78,0x20,0x04,0xF6,0x00,0x18,0x02,	/* 0A58: .x .... */
	0xF6,0x08,0xFD,0x77,0x08,0xDD,0x7E,0xB5,	/* 0A60: .w.~ */
	0xE6,0x10,0x28,0x04,0x06,0x02,0x18,0x02,	/* 0A68: .(..... */
	0x06,0x00,0xDD,0x7E,0xB5,0xE6,0x80,0x28,	/* 0A70: ..~( */
	0x04,0x3E,0x10,0xB0,0x47,0xDD,0x7E,0xBA,	/* 0A78: .>.G~ */
	0xE6,0x02,0x28,0x11,0xDD,0x7E,0xBA,0xE6,	/* 0A80: .(.~ */
	0x01,0x28,0x06,0x3E,0xC0,0xB0,0x47,0x18,	/* 0A88: .(.>G. */
	0x04,0x3E,0x40,0xB0,0x47,0xFD,0x70,0x09,	/* 0A90: .>@Gp. */
	0xDD,0x7E,0xBA,0xE6,0x02,0x28,0x06,0xFD,	/* 0A98: ~.(. */
	0x36,0x0A,0x36,0x18,0x04,0xFD,0x36,0x0A,	/* 0AA0: 6.6..6. */
	0x06,0xDD,0xCB,0xC0,0x5E,0x28,0x04,0x06,	/* 0AA8: .^(.. */
	0x02,0x18,0x0C,0xDD,0xCB,0xC0,0x56,0x28,	/* 0AB0: ...V( */
	0x04,0x06,0x04,0x18,0x02,0x06,0x03,0xDD,	/* 0AB8: ....... */
	0xCB,0xC0,0x46,0x28,0x04,0x3E,0x18,0x18,	/* 0AC0: F(.>.. */
	0x0C,0xDD,0xCB,0xC0,0x4E,0x28,0x04,0x3E,	/* 0AC8: .N(.> */
	0x00,0x18,0x02,0x3E,0x08,0xB0,0xFD,0x77,	/* 0AD0: ...>.w */
	0x1E,0xDD,0x7E,0xBA,0xE6,0x04,0x28,0x16,	/* 0AD8: .~.(. */
	0xDD,0x7E,0xC7,0xFE,0x01,0x20,0x07,0xFD,	/* 0AE0: ~. . */
	0x7E,0x40,0xFE,0x42,0x28,0x08,0x06,0x02,	/* 0AE8: ~@B(... */
	0xDD,0xCB,0xA9,0x96,0x18,0x02,0x06,0x00,	/* 0AF0: ˩.... */
	0xDD,0x7E,0xC2,0xFE,0xFF,0x28,0x04,0x3E,	/* 0AF8: ~(.> */
	0x80,0xB0,0x47,0xFD,0x70,0x1F,0xDD,0x7E,	/* 0B00: Gp.~ */
	0xBA,0xDD,0xCB,0xB4,0x7E,0x20,0x06,0xDD,	/* 0B08: ˴~ . */
	0xCB,0xBA,0x76,0x28,0x02,0xF6,0x08,0x4F,	/* 0B10: ˺v(..O */
	0xDD,0xAE,0xA8,0xE6,0x9B,0x47,0xDD,0x7E,	/* 0B18: ݮG~ */
	0xA8,0xA8,0xCB,0x5F,0x28,0x02,0xE6,0x0F,	/* 0B20: _(.. */
	0x47,0xDD,0x70,0xA8,0x79,0xE6,0xFB,0xDD,	/* 0B28: Gpy */
	0xAE,0xA9,0xE6,0xA4,0x47,0xDD,0x7E,0xA9,	/* 0B30: G~ */
	0xA8,0xDD,0x77,0xA9,0xDD,0x7E,0xC7,0xFE,	/* 0B38: w~ */
	0x01,0x20,0x12,0xFD,0x7E,0x40,0xFE,0x42,	/* 0B40: . .~@B */
	0x20,0x0B,0xDD,0x7E,0xBA,0xE6,0x04,0x28,	/* 0B48:  .~.( */
	0x04,0xDD,0xCB,0xA9,0xD6,0xFD,0x36,0x21,	/* 0B50: .˩6! */
	0x02,0xFD,0x36,0x05,0x4E,0xDD,0x36,0xC5,	/* 0B58: .6.N6 */
	0x01,0xC9,0xDD,0x36,0xC5,0x00,0xDD,0xCB,	/* 0B60: .6. */
	0xA8,0x86,0xDD,0x7E,0xC7,0xFE,0x01,0xCA,	/* 0B68: ~. */
	0x1D,0x0C,0xFD,0x36,0x05,0x1A,0xDD,0xCB,	/* 0B70: ..6.. */
	0xB7,0x46,0x20,0x06,0xDD,0xCB,0xB4,0x7E,	/* 0B78: F .˴~ */
	0x28,0x13,0xDD,0x7E,0xC4,0xE6,0x08,0x20,	/* 0B80: (.~.  */
	0x06,0xFD,0x36,0x6C,0x01,0x18,0x17,0xFD,	/* 0B88: .6l... */
	0x36,0x6D,0x02,0x18,0x11,0xDD,0x7E,0xC4,	/* 0B90: 6m...~ */
	0xE6,0x08,0x20,0x06,0xFD,0x36,0x6C,0x00,	/* 0B98: . .6l. */
	0x18,0x04,0xFD,0x36,0x6D,0x00,0xDD,0xCB,	/* 0BA0: ..6m. */
	0xB7,0x4E,0x20,0x06,0xDD,0xCB,0xBA,0x76,	/* 0BA8: N .˺v */
	0x28,0x13,0xDD,0x7E,0xC4,0xE6,0x08,0x20,	/* 0BB0: (.~.  */
	0x06,0xFD,0x36,0x6D,0x02,0x18,0x17,0xFD,	/* 0BB8: .6m... */
	0x36,0x6C,0x01,0x18,0x11,0xDD,0x7E,0xC4,	/* 0BC0: 6l...~ */
	0xE6,0x08,0x20,0x06,0xFD,0x36,0x6D,0x00,	/* 0BC8: . .6m. */
	0x18,0x04,0xFD,0x36,0x6C,0x00,0xDD,0xCB,	/* 0BD0: ..6l. */
	0xBA,0x6E,0x28,0x15,0xCD,0x04,0x09,0xDD,	/* 0BD8: n(... */
	0x7E,0xB5,0xE6,0x10,0x28,0x04,0x3E,0xB0,	/* 0BE0: ~.(.> */
	0x18,0x02,0x3E,0xF0,0xDD,0xA6,0xC6,0x18,	/* 0BE8: ..>ݦ. */
	0x06,0x3E,0x00,0xDD,0x36,0xB8,0x24,0xFD,	/* 0BF0: .>.6$ */
	0x77,0x16,0xDD,0xCB,0xBA,0x76,0x28,0x0A,	/* 0BF8: w.˺v(. */
	0xDD,0xCB,0xC4,0x5E,0x20,0x04,0xF6,0x08,	/* 0C00: ^ .. */
	0x18,0x0E,0xDD,0xCB,0xB4,0x7E,0x28,0x08,	/* 0C08: ..˴~(. */
	0xDD,0xCB,0xC4,0x5E,0x28,0x02,0xF6,0x08,	/* 0C10: ^(.. */
	0xFD,0x77,0x15,0x18,0x0C,0xFD,0x36,0x15,	/* 0C18: w...6. */
	0x00,0xFD,0x36,0x16,0x00,0xFD,0x36,0x05,	/* 0C20: .6..6. */
	0x18,0xFD,0x36,0x06,0x90,0xDD,0x36,0xAE,	/* 0C28: .6.6 */
	0x00,0xDD,0x3E,0xC3,0x05,0x01,0xC9,0xCD,	/* 0C30: .>.. */
	0xF3,0x08,0xFD,0x7E,0x6C,0xE6,0x80,0x28,	/* 0C38: .~l( */
	0x0A,0xDD,0x36,0xAE,0x00,0xDD,0x3E,0xC3,	/* 0C40: .6.> */
	0x05,0x01,0xC9,0xDD,0x36,0xAE,0x06,0xC9,	/* 0C48: ..6. */
	0xCD,0x40,0x09,0x18,0x05,0xFD,0xED,0x2C,	/* 0C50: @..., */
	0xA2,0xFF,0xCD,0x37,0x0C,0x26,0x00,0xC3,	/* 0C58: 7.&. */
	0x12,0x0D,0xCD,0x40,0x09,0x26,0x00,0xC3,	/* 0C60: ..@.&. */
	0x12,0x0D,0xCD,0xFC,0x1C,0x26,0x00,0xC3,	/* 0C68: ...&. */
	0x12,0x0D,0xCD,0xFC,0x1C,0x26,0x00,0xC3,	/* 0C70: ...&. */
	0x12,0x0D,0x26,0x00,0xC3,0x12,0x0D,0xCD,	/* 0C78: ..&... */
	0xF3,0x08,0xFD,0x7E,0x05,0xFE,0x00,0x28,	/* 0C80: .~..( */
	0x05,0x26,0x00,0xC3,0x12,0x0D,0xDD,0x7E,	/* 0C88: .&...~ */
	0xAD,0xDD,0x77,0xAC,0xFD,0x36,0x05,0x82,	/* 0C90: w6. */
	0xCD,0xF3,0x08,0xDD,0x7E,0xC7,0xFE,0x01,	/* 0C98: .~. */
	0x28,0x08,0xFD,0x7E,0x0B,0xE6,0xFB,0xFD,	/* 0CA0: (.~. */
	0x77,0x0B,0xDD,0x36,0xAE,0x00,0xDD,0x3E,	/* 0CA8: w.6.> */
	0xC3,0x05,0x01,0x26,0x00,0x18,0x5B,0xFD,	/* 0CB0: ..&..[ */
	0xED,0x2C,0xA2,0xFF,0xDD,0x7E,0xAB,0xDD,	/* 0CB8: ,~ */
	0x77,0xAA,0xDD,0x36,0xAE,0x00,0xDD,0x3E,	/* 0CC0: w6.> */
	0xC3,0x05,0x01,0x26,0x00,0x18,0x43,0xCD,	/* 0CC8: ..&..C */
	0xF3,0x08,0xFD,0x7E,0x0B,0xF6,0x04,0xFD,	/* 0CD0: .~.. */
	0x77,0x0B,0xDD,0x36,0xAE,0x00,0xDD,0x3E,	/* 0CD8: w.6.> */
	0xC3,0x05,0x01,0x26,0x00,0x18,0x2B,0xCD,	/* 0CE0: ..&..+ */
	0x84,0x1B,0x26,0x00,0x18,0x24,0x7A,0x0C,	/* 0CE8: .&..$z. */
	0x62,0x0C,0x50,0x0C,0x55,0x0C,0x62,0x0C,	/* 0CF0: b.P.U.b. */
	0x6A,0x0C,0x3F,0x1C,0x9B,0x1C,0x7A,0x0C,	/* 0CF8: j.?..z. */
	0x7A,0x0C,0x72,0x0C,0x98,0x0C,0x7F,0x0C,	/* 0D00: z.r... */
	0xB7,0x0C,0xCF,0x0C,0xE7,0x0C,0x7A,0x0C,	/* 0D08: ...z. */
	0x7A,0x0C,0xED,0x7F,0x17,0xDD,0x7E,0xA1,	/* 0D10: z..~ */
	0xDD,0x67,0xDD,0x7E,0xAE,0xFE,0x00,0xF3,	/* 0D18: g~. */
	0xC2,0xB7,0x0D,0xDD,0x46,0xA8,0xCB,0x40,	/* 0D20: ·.F@ */
	0xCA,0xC4,0x0D,0xCB,0x60,0x28,0xE3,0xCD,	/* 0D28: .`( */
	0xF3,0x08,0xCB,0x78,0x28,0x16,0xFD,0x7E,	/* 0D30: .x(.~ */
	0x05,0xFE,0x00,0x20,0xD5,0xFD,0x36,0x05,	/* 0D38: .. 6. */
	0x24,0xCB,0xE8,0xCB,0xB8,0xCB,0xB0,0xDD,	/* 0D40: $˸˰ */
	0x70,0xA8,0x18,0xC6,0xDD,0x6E,0xAA,0x7D,	/* 0D48: p.n} */
	0xDD,0x96,0xAB,0xCB,0x7F,0x20,0xBB,0xFE,	/* 0D50: ݖ  */
	0x40,0xF2,0x12,0x0D,0xDD,0xCB,0xBA,0x5E,	/* 0D58: @..˺^ */
	0x28,0x0B,0xFD,0x7E,0x05,0xFE,0x00,0x20,	/* 0D60: (.~..  */
	0xA9,0xFD,0x36,0x05,0x23,0xDD,0xCB,0xB4,	/* 0D68: 6.#˴ */
	0x7E,0x28,0x19,0xDD,0x7E,0xC4,0xE6,0x08,	/* 0D70: ~(.~. */
	0x20,0x06,0xFD,0x36,0x6C,0x01,0x18,0x0C,	/* 0D78:  .6l... */
	0xFD,0x36,0x6D,0x02,0xFD,0x7E,0x15,0xF6,	/* 0D80: 6m.~. */
	0x08,0xFD,0x77,0x15,0xDD,0xCB,0xBA,0x76,	/* 0D88: .w.˺v */
	0x28,0x19,0xDD,0x7E,0xC4,0xE6,0x08,0x20,	/* 0D90: (.~.  */
	0x0E,0xFD,0x36,0x6D,0x02,0xFD,0x7E,0x15,	/* 0D98: .6m.~. */
	0xF6,0x08,0xFD,0x77,0x15,0x18,0x04,0xFD,	/* 0DA0: .w... */
	0x36,0x6C,0x01,0xCB,0xB0,0xCB,0xA8,0xCB,	/* 0DA8: 6l.˰˨ */
	0xA0,0xDD,0x70,0xA8,0xC3,0x12,0x0D,0xFE,	/* 0DB0: p.. */
	0x10,0xCA,0x12,0x0D,0x6F,0xFD,0xED,0x3C,	/* 0DB8: ...o< */
	0xEE,0x0C,0xFD,0xE9,0xDD,0x6E,0xAC,0xDD,	/* 0DC0: .n */
	0x7E,0xAD,0x95,0xCA,0x2B,0x0D,0xDD,0xCB,	/* 0DC8: ~+. */
	0xA8,0xC6,0xCD,0xF3,0x08,0xFD,0x7E,0x06,	/* 0DD0: .~. */
	0xF6,0x04,0xFD,0x77,0x06,0xDD,0x36,0xC9,	/* 0DD8: .w.6 */
	0x01,0xC3,0x2B,0x0D,0xED,0x32,0x00,0x00,	/* 0DE0: .+.2.. */
	0xCB,0x5D,0x28,0x0B,0xCB,0x9D,0xFD,0x7B,	/* 0DE8: ](.˝{ */
	0x0D,0x00,0x2F,0xE6,0x08,0x18,0x07,0xFD,	/* 0DF0: ...... */
	0x7B,0x0D,0x00,0x2F,0xE6,0x02,0xFE,0x00,	/* 0DF8: {..... */
	0x28,0x0A,0xDD,0x36,0xAE,0x00,0xDD,0x3E,	/* 0E00: (.6.> */
	0xC3,0x05,0x01,0xC9,0xDD,0x36,0xAE,0x06,	/* 0E08: ..6. */
	0xC9,0x26,0x00,0xDD,0x7E,0xAC,0xDD,0x96,	/* 0E10: &.~ݖ */
	0xAD,0x28,0x04,0xF1,0xC3,0xC4,0x05,0xDD,	/* 0E18: (.. */
	0x7E,0xBF,0xFE,0x01,0x28,0x08,0xFD,0x7E,	/* 0E20: ~.(.~ */
	0x01,0xCB,0x5F,0xC8,0x18,0x10,0xDD,0x36,	/* 0E28: ._..6 */
	0xAA,0x00,0xDD,0x36,0xAB,0x00,0xDD,0x36,	/* 0E30: .6.6 */
	0xAC,0x00,0xDD,0x36,0xAD,0x00,0xFD,0xED,	/* 0E38: .6. */
	0x2C,0xA2,0xFF,0xDD,0xCB,0xB7,0x46,0x20,	/* 0E40: ,˷F  */
	0x04,0xFD,0x36,0x02,0x90,0xFD,0x36,0x02,	/* 0E48: .6.6. */
	0x30,0xFD,0x36,0x02,0x20,0xDD,0x36,0xBF,	/* 0E50: 06. 6 */
	0x01,0xDD,0xCB,0xB7,0x4E,0x20,0x24,0xFD,	/* 0E58: .˷N $ */
	0xE5,0xED,0x32,0x00,0x00,0x7D,0xE6,0x80,	/* 0E60: 2..} */
	0x6F,0xFD,0xED,0x2C,0xA4,0xFF,0xFD,0x7E,	/* 0E68: o,~ */
	0x04,0x47,0xDD,0x7E,0xAF,0x2F,0xA0,0xFD,	/* 0E70: .G~. */
	0x77,0x04,0xE5,0xFD,0xE1,0x2F,0xFD,0x77,	/* 0E78: w..w */
	0x40,0xFD,0xE1,0xDD,0x36,0xAE,0x10,0xDD,	/* 0E80: @6. */
	0x3E,0xC3,0x05,0x01,0xC9,0xDD,0x7E,0xBF,	/* 0E88: >..~ */
	0xFE,0x01,0x28,0x06,0xFD,0x7E,0x01,0xCB,	/* 0E90: .(.~. */
	0x5F,0xC8,0xDD,0x36,0xBF,0x00,0xFD,0x36,	/* 0E98: _6.6 */
	0x02,0x18,0xDD,0x7E,0xB4,0xE6,0x7F,0xFD,	/* 0EA0: ..~ */
	0x77,0x00,0xDD,0xCB,0xB4,0x7E,0x20,0x12,	/* 0EA8: w.˴~ . */
	0xDD,0xCB,0xB7,0x46,0x20,0x06,0xFD,0x36,	/* 0EB0: ˷F .6 */
	0x02,0x90,0x18,0x0A,0xFD,0x36,0x02,0x80,	/* 0EB8: ...6. */
	0x18,0x04,0xFD,0x36,0x02,0x80,0xDD,0x7E,	/* 0EC0: ..6.~ */
	0xB5,0xFD,0x77,0x00,0xCB,0x67,0x20,0x06,	/* 0EC8: w.g . */
	0xDD,0xCB,0xA9,0xA6,0x18,0x04,0xDD,0xCB,	/* 0ED0: ˩.. */
	0xA9,0xE6,0xFD,0xE5,0xED,0x32,0x00,0x00,	/* 0ED8: 2.. */
	0x7D,0xE6,0x80,0x6F,0xFD,0xED,0x2C,0xA4,	/* 0EE0: }o, */
	0xFF,0xFD,0x7E,0x04,0xDD,0xCB,0xB7,0x4E,	/* 0EE8: ~.˷N */
	0x28,0x05,0xDD,0xB6,0xAF,0x18,0x06,0x47,	/* 0EF0: (.ݶ..G */
	0xDD,0x7E,0xAF,0x2F,0xA0,0xFD,0x77,0x04,	/* 0EF8: ~.w. */
	0xE5,0xFD,0xE1,0x2F,0xFD,0x77,0x40,0xFD,	/* 0F00: .w@ */
	0xE1,0xDD,0x7E,0xB6,0xFD,0x77,0x01,0xDD,	/* 0F08: ~w. */
	0x36,0xB9,0x00,0xDD,0x7E,0xBB,0xDD,0x77,	/* 0F10: 6.~w */
	0xB0,0xDD,0x7E,0xBC,0xDD,0x77,0xB1,0xDD,	/* 0F18: ~w */
	0x7E,0xBD,0xDD,0x77,0xB2,0xDD,0x7E,0xBE,	/* 0F20: ~w~ */
	0xDD,0x77,0xB3,0xDD,0x36,0xB9,0x00,0xDD,	/* 0F28: w6. */
	0x7E,0xBA,0xDD,0xCB,0xB4,0x7E,0x28,0x02,	/* 0F30: ~˴~(. */
	0xF6,0x08,0x4F,0xDD,0xAE,0xA8,0xE6,0xDB,	/* 0F38: .Oݮ */
	0x47,0xDD,0x7E,0xA8,0xA8,0xCB,0x48,0x28,	/* 0F40: G~H( */
	0x02,0xCB,0x97,0xCB,0x5F,0x28,0x02,0xE6,	/* 0F48: .˗_(. */
	0x0F,0x47,0x79,0xE6,0x54,0x20,0x0A,0xDD,	/* 0F50: .GyT . */
	0xCB,0xA9,0x8E,0xDD,0xCB,0xA3,0xA6,0x18,	/* 0F58: ˩ˣ. */
	0x08,0xDD,0xCB,0xA3,0xE6,0xDD,0xCB,0xA9,	/* 0F60: .ˣ˩ */
	0xCE,0xDD,0x70,0xA8,0x79,0xDD,0xAE,0xA9,	/* 0F68: pyݮ */
	0xE6,0xA4,0x47,0xDD,0x7E,0xA9,0xA8,0xCB,	/* 0F70: G~ */
	0x50,0x28,0x02,0xCB,0x87,0xDD,0x77,0xA9,	/* 0F78: P(.ˇw */
	0xCB,0x6F,0x20,0x06,0xDD,0x36,0xB8,0x24,	/* 0F80: o .6$ */
	0x18,0x39,0xED,0x32,0x00,0x00,0xCB,0x5D,	/* 0F88: .92..] */
	0x28,0x0A,0xCB,0x9D,0xFD,0x7B,0x0D,0x00,	/* 0F90: (.˝{.. */
	0xCB,0x2F,0x18,0x06,0xFD,0x7B,0x0D,0x00,	/* 0F98: ...{.. */
	0xCB,0x27,0x2F,0xDD,0xCB,0xA9,0x66,0x20,	/* 0FA0: '.˩f  */
	0x04,0xE6,0x26,0x18,0x13,0xE6,0x24,0xDD,	/* 0FA8: .&..$ */
	0x77,0xB8,0xCB,0x57,0x18,0x0D,0xDD,0x7E,	/* 0FB0: wW..~ */
	0xB5,0xE6,0xEF,0xFD,0x77,0x00,0x18,0x03,	/* 0FB8: w... */
	0xDD,0x77,0xB8,0xDD,0x7E,0xC0,0xDD,0x77,	/* 0FC0: w~w */
	0xC1,0xDD,0x7E,0xC2,0xDD,0x77,0xC3,0xFD,	/* 0FC8: ~w */
	0x36,0x02,0x05,0xDD,0x36,0xAE,0x00,0xDD,	/* 0FD0: 6..6. */
	0x3E,0xC3,0x05,0x01,0xC9,0x45,0x6E,0x64,	/* 0FD8: >..End */
	0x20,0x6F,0x66,0x20,0x74,0x61,0x20,0x63,	/* 0FE0:  of ta c */
	0x6F,0x64,0x65,0x00,0x00,0xDD,0xD1,0xEB,	/* 0FE8: ode.. */
	0x0F,0xE5,0xDD,0xE5,0xC5,0xDD,0x2A,0x2A,	/* 0FF0: .** */
	0x01,0x0E,0x15,0xED,0xB7,0x21,0x00,0x00,	/* 0FF8: ...!.. */
	0xED,0xBF,0xDD,0x36,0xAE,0x2A,0xC1,0xDD,	/* 1000: 6* */
	0xE1,0xE1,0xED,0x55,0xDD,0xD1,0xEB,0x0F,	/* 1008: U. */
	0xE5,0xDD,0xE5,0xC5,0xDD,0x2A,0x2C,0x01,	/* 1010: *,. */
	0x0E,0x1D,0x21,0x00,0x00,0xED,0xBF,0xDD,	/* 1018: ..!.. */
	0x36,0xAE,0x2A,0xC1,0xDD,0xE1,0xE1,0xED,	/* 1020: 6* */
	0x55,0xFD,0xED,0x2C,0xA2,0xFF,0xDD,0x7E,	/* 1028: U,~ */
	0xB2,0xE6,0x0C,0x20,0x25,0xDD,0x7E,0xB2,	/* 1030: . %~ */
	0xE6,0x10,0x28,0x1E,0xFD,0x36,0x00,0x0F,	/* 1038: .(.6.. */
	0xFD,0x36,0x00,0x01,0xFD,0x36,0x00,0x07,	/* 1040: 6..6.. */
	0xFD,0x36,0x00,0x03,0xDD,0x7E,0xB3,0xF6,	/* 1048: 6..~ */
	0x09,0xFD,0x36,0x00,0x05,0xFD,0x77,0x00,	/* 1050: .6..w. */
	0x18,0x0C,0xDD,0x7E,0xB3,0xF6,0x08,0xFD,	/* 1058: ..~. */
	0x36,0x00,0x05,0xFD,0x77,0x00,0xED,0x32,	/* 1060: 6..w.2 */
	0x02,0x00,0x7C,0xF6,0xF0,0x67,0xDD,0x7E,	/* 1068: ..|g~ */
	0xA7,0xFE,0x01,0x20,0x44,0x0E,0x10,0xED,	/* 1070: . D.. */
	0xBF,0x21,0x0F,0x80,0x0E,0x11,0xED,0xBF,	/* 1078: !... */
	0xED,0x2A,0x00,0x00,0x7C,0xF6,0xF0,0x67,	/* 1080: *..|g */
	0x0E,0x12,0xED,0xBF,0xDD,0x7C,0xE6,0x7F,	/* 1088: ..| */
	0xF6,0x0F,0x6F,0x26,0x00,0x0E,0x13,0xED,	/* 1090: .o&... */
	0xBF,0xED,0x2C,0xAA,0xFF,0x0E,0x14,0xED,	/* 1098: ,.. */
	0xBF,0x21,0x84,0x88,0x0E,0x15,0xED,0xBF,	/* 10A0: !.. */
	0xFD,0x36,0x00,0x01,0xFD,0x36,0x00,0xC0,	/* 10A8: 6..6. */
	0x26,0x00,0xDD,0x36,0xAE,0x28,0xC3,0xF1,	/* 10B0: &.6( */
	0x05,0x0E,0x18,0xED,0xBF,0x21,0x0F,0x80,	/* 10B8: ...!. */
	0x0E,0x19,0xED,0xBF,0xED,0x2A,0x00,0x00,	/* 10C0: ..*.. */
	0x7C,0xF6,0xF0,0x67,0x0E,0x1A,0xED,0xBF,	/* 10C8: |g.. */
	0xDD,0x7C,0xE6,0x7F,0xF6,0x0F,0x6F,0x26,	/* 10D0: |.o& */
	0x00,0x0E,0x1B,0xED,0xBF,0xED,0x2C,0xAA,	/* 10D8: ..., */
	0xFF,0x0E,0x1C,0xED,0xBF,0x21,0x84,0x88,	/* 10E0: ..! */
	0x0E,0x1D,0xED,0xBF,0xFD,0x36,0x00,0x01,	/* 10E8: ..6.. */
	0xFD,0x36,0x00,0xC0,0x26,0x00,0xDD,0x36,	/* 10F0: 6.&.6 */
	0xAE,0x28,0xC3,0xF1,0x05,0xFD,0xED,0x2C,	/* 10F8: (., */
	0xA2,0xFF,0xDD,0x7E,0xB2,0xE6,0x0C,0x20,	/* 1100: ~.  */
	0x15,0xDD,0x7E,0xB2,0xE6,0x10,0x28,0x0E,	/* 1108: .~.(. */
	0xDD,0x7E,0xB1,0xF6,0x11,0xFD,0x36,0x00,	/* 1110: ~.6. */
	0x03,0xFD,0x77,0x00,0x18,0x0C,0xDD,0x7E,	/* 1118: .w...~ */
	0xB1,0xF6,0x01,0xFD,0x36,0x00,0x03,0xFD,	/* 1120: .6.. */
	0x77,0x00,0xED,0x32,0x02,0x00,0x7C,0xF6,	/* 1128: w.2..| */
	0xF0,0x67,0xDD,0x7E,0xA7,0xFE,0x01,0x20,	/* 1130: g~.  */
	0x47,0x0E,0x12,0xED,0xBF,0x21,0x0F,0x80,	/* 1138: G..!. */
	0x0E,0x13,0xED,0xBF,0xED,0x2A,0x00,0x0C,	/* 1140: ..*.. */
	0x7C,0xF6,0xF0,0x67,0x0E,0x10,0xED,0xBF,	/* 1148: |g.. */
	0xED,0x2A,0x00,0x0C,0x7C,0xE6,0x7F,0xF6,	/* 1150: *..| */
	0x0F,0x6F,0x26,0x00,0x0E,0x11,0xED,0xBF,	/* 1158: .o&... */
	0xED,0x2C,0xAA,0xFF,0x0E,0x14,0xED,0xBF,	/* 1160: ,.. */
	0x21,0x80,0xA0,0x0E,0x15,0xED,0xBF,0xFD,	/* 1168: !.. */
	0x36,0x00,0x01,0xFD,0x36,0x00,0xE0,0x26,	/* 1170: 6..6.& */
	0x00,0xDD,0x36,0xAE,0x28,0xC3,0xF1,0x05,	/* 1178: .6(. */
	0x0E,0x1A,0xED,0xBF,0x21,0x0F,0x80,0x0E,	/* 1180: ..!.. */
	0x1B,0xED,0xBF,0xED,0x2A,0x00,0x0C,0x7C,	/* 1188: .*..| */
	0xF6,0xF0,0x67,0x0E,0x18,0xED,0xBF,0xED,	/* 1190: g.. */
	0x2A,0x00,0x0C,0x7C,0xE6,0x7F,0xF6,0x0F,	/* 1198: *..|. */
	0x6F,0x26,0x00,0x0E,0x19,0xED,0xBF,0xED,	/* 11A0: o&... */
	0x2C,0xAA,0xFF,0x0E,0x1C,0xED,0xBF,0x21,	/* 11A8: ,..! */
	0x80,0xA0,0x0E,0x1D,0xED,0xBF,0xFD,0x36,	/* 11B0: ..6 */
	0x00,0x01,0xFD,0x36,0x00,0xE0,0x26,0x00,	/* 11B8: ..6.&. */
	0xDD,0x36,0xAE,0x28,0xC3,0xF1,0x05,0xFD,	/* 11C0: 6(. */
	0xED,0x2C,0xA2,0xFF,0xDD,0x7E,0xB1,0xFD,	/* 11C8: ,~ */
	0x36,0x00,0x03,0xFD,0x77,0x00,0xDD,0x7E,	/* 11D0: 6..w.~ */
	0xB2,0xFD,0x36,0x00,0x04,0xFD,0x77,0x00,	/* 11D8: 6..w. */
	0xDD,0x7E,0xB3,0xFD,0x36,0x00,0x05,0xFD,	/* 11E0: ~6.. */
	0x77,0x00,0xDD,0x7E,0xB4,0xFD,0x36,0x00,	/* 11E8: w.~6. */
	0x06,0xFD,0x77,0x00,0xDD,0x7E,0xB5,0xFD,	/* 11F0: .w.~ */
	0x36,0x00,0x07,0xFD,0x77,0x00,0xDD,0x7E,	/* 11F8: 6..w.~ */
	0xB8,0xFD,0x36,0x00,0x0A,0xFD,0x77,0x00,	/* 1200: 6..w. */
	0xDD,0x7E,0xBA,0xFD,0x36,0x00,0x0C,0xFD,	/* 1208: ~6.. */
	0x77,0x00,0xDD,0x7E,0xBB,0xFD,0x36,0x00,	/* 1210: w.~6. */
	0x0D,0xFD,0x77,0x00,0xDD,0x36,0xAE,0x2A,	/* 1218: .w.6* */
	0xDD,0x3E,0xC3,0x05,0x01,0x26,0x00,0xC3,	/* 1220: >..&. */
	0xF1,0x05,0x08,0x00,0x18,0x00,0x28,0x00,	/* 1228: .....(. */
	0x38,0x00,0x48,0x00,0x58,0x00,0x68,0x00,	/* 1230: 8.H.X.h. */
	0x08,0x80,0x08,0x00,0x18,0x00,0x28,0x00,	/* 1238: .....(. */
	0x38,0x00,0x48,0x00,0x58,0x00,0x68,0x00,	/* 1240: 8.H.X.h. */
	0x78,0x00,0x08,0x00,0x18,0x00,0x28,0x00,	/* 1248: x.....(. */
	0x38,0x00,0x48,0x00,0x58,0x00,0x68,0x00,	/* 1250: 8.H.X.h. */
	0x08,0x80,0x08,0x00,0x18,0x00,0x28,0x00,	/* 1258: .....(. */
	0x38,0x00,0x48,0x00,0x58,0x00,0x68,0x00,	/* 1260: 8.H.X.h. */
	0x78,0x00,0x7A,0x00,0x6A,0x00,0xFA,0x00,	/* 1268: x.z.j.. */
	0xAA,0x00,0xBA,0x00,0xCA,0x00,0x08,0x80,	/* 1270: .... */
	0x08,0x80,0x08,0x00,0x18,0x00,0x28,0x00,	/* 1278: .....(. */
	0x38,0x00,0x48,0x00,0x58,0x00,0x68,0x00,	/* 1280: 8.H.X.h. */
	0x08,0x01,0x7A,0x00,0x6A,0x00,0xFA,0x00,	/* 1288: ..z.j.. */
	0xAA,0x00,0xBA,0x00,0xCA,0x00,0x08,0x80,	/* 1290: .... */
	0x08,0x80,0x08,0x00,0x18,0x00,0x28,0x00,	/* 1298: .....(. */
	0x38,0x00,0x48,0x00,0x58,0x00,0x68,0x00,	/* 12A0: 8.H.X.h. */
	0x08,0x01,0x6A,0x00,0x7A,0x00,0xFA,0x00,	/* 12A8: ..j.z.. */
	0x9A,0x00,0xAA,0x00,0xBA,0x00,0x08,0x80,	/* 12B0: .... */
	0x08,0x80,0x08,0x00,0x18,0x00,0x28,0x00,	/* 12B8: .....(. */
	0x38,0x00,0x48,0x00,0x58,0x00,0x68,0x00,	/* 12C0: 8.H.X.h. */
	0x08,0x01,0x6A,0x00,0x7A,0x00,0xFA,0x00,	/* 12C8: ..j.z.. */
	0x9A,0x00,0xAA,0x00,0xBA,0x00,0x08,0x80,	/* 12D0: .... */
	0x08,0x80,0x08,0x00,0x18,0x00,0x28,0x00,	/* 12D8: .....(. */
	0x38,0x00,0x48,0x00,0x58,0x00,0x68,0x00,	/* 12E0: 8.H.X.h. */
	0x08,0x01,0x8A,0x00,0x9A,0x00,0xFA,0x00,	/* 12E8: ..... */
	0xBA,0x00,0xCA,0x00,0xDA,0x00,0x08,0x80,	/* 12F0: .... */
	0x08,0x80,0x08,0x00,0x18,0x00,0x28,0x00,	/* 12F8: .....(. */
	0x38,0x00,0x48,0x00,0x58,0x00,0x68,0x00,	/* 1300: 8.H.X.h. */
	0x08,0x01,0x8A,0x00,0x9A,0x00,0xFA,0x00,	/* 1308: ..... */
	0xBA,0x00,0xCA,0x00,0xDA,0x00,0x08,0x80,	/* 1310: .... */
	0x08,0x80,0x08,0x00,0x18,0x00,0x28,0x00,	/* 1318: .....(. */
	0x38,0x00,0x48,0x00,0x58,0x00,0x68,0x00,	/* 1320: 8.H.X.h. */
	0x08,0x01,0x3A,0x41,0x00,0xFE,0x00,0x20,	/* 1328: ..:A..  */
	0xF9,0x3A,0x00,0x80,0x2F,0x47,0x32,0x00,	/* 1330: :..G2. */
	0x80,0x3A,0x00,0x80,0xB8,0x28,0x07,0xDD,	/* 1338: :.(. */
	0x3E,0x01,0x00,0x20,0x18,0x05,0xDD,0x3E,	/* 1340: >.. ..> */
	0x01,0x00,0x40,0x3A,0x42,0x00,0xFE,0x01,	/* 1348: ..@:B.. */
	0x20,0x06,0xDD,0x11,0x28,0x13,0x08,0x40,	/* 1350:  ..(..@ */
	0x2A,0x43,0x00,0x0E,0xFF,0xED,0x6E,0x2A,	/* 1358: *C..n* */
	0x45,0x00,0x0E,0x02,0xED,0x6E,0x21,0x60,	/* 1360: E...n!` */
	0x00,0x0E,0x12,0xED,0x6E,0x21,0x02,0x00,	/* 1368: ...n!.. */
	0x0E,0x00,0xED,0x6E,0x21,0xFF,0x00,0x0E,	/* 1370: ..n!.. */
	0x08,0xED,0x6E,0x21,0x00,0x00,0x0E,0x16,	/* 1378: .n!.... */
	0xED,0x6E,0x3E,0x3F,0xD3,0xE8,0x0E,0x1F,	/* 1380: n>?.. */
	0x21,0x00,0x00,0xED,0xBF,0xED,0x4E,0x3E,	/* 1388: !..N> */
	0x00,0x0E,0xF5,0xDD,0x21,0x2A,0x12,0xED,	/* 1390: ..!*. */
	0x2C,0x00,0x00,0xD3,0xF1,0xED,0xBF,0x3C,	/* 1398: ,..< */
	0xDD,0x23,0xDD,0x23,0xFE,0x20,0x20,0xEF,	/* 13A0: ##   */
	0x21,0x00,0x08,0x0E,0xF0,0xED,0xBF,0x00,	/* 13A8: !.... */
	0x00,0x00,0xDD,0x21,0x8C,0x00,0xFD,0x21,	/* 13B0: ..!.! */
	0x00,0x70,0x21,0x80,0x00,0x0E,0x00,0xFD,	/* 13B8: .p!... */
	0xE5,0x06,0x04,0xFD,0x7E,0x0D,0xE6,0xA0,	/* 13C0: ..~. */
	0xFE,0xA0,0x20,0x44,0xE5,0xED,0x32,0x00,	/* 13C8:  D2. */
	0x00,0xFD,0xED,0xF6,0x10,0x00,0xE5,0xFD,	/* 13D0: ... */
	0xE1,0xE1,0x10,0xE7,0xFD,0xE1,0xFD,0x7E,	/* 13D8: .~ */
	0x01,0xFE,0xFF,0xCA,0x92,0x14,0xDD,0x3E,	/* 13E0: .ʒ.> */
	0x92,0x00,0x01,0x3A,0x93,0x00,0xFE,0x01,	/* 13E8: ..:.. */
	0xCA,0xDA,0x14,0xFD,0x7E,0x40,0xE6,0x01,	/* 13F0: .~@. */
	0x20,0x0B,0xDD,0x36,0x00,0x08,0xFD,0xED,	/* 13F8:  .6.. */
	0xF6,0x00,0x19,0x18,0x76,0xDD,0x36,0x00,	/* 1400: ...v6. */
	0x04,0xFD,0xED,0xF6,0x00,0x0D,0x18,0x6B,	/* 1408: ....k */
	0xFD,0xE1,0xFD,0x36,0x7F,0x08,0xDD,0x3E,	/* 1410: 6.> */
	0x93,0x00,0x01,0x3A,0x92,0x00,0xFE,0x01,	/* 1418: ..:.. */
	0xCA,0xDA,0x14,0xCD,0x82,0x15,0xFD,0x36,	/* 1420: .͂.6 */
	0x7F,0x10,0xFD,0x7E,0x7F,0xE6,0xF0,0xFE,	/* 1428: .~ */
	0xF0,0x20,0x0B,0xDD,0x36,0x00,0x24,0xFD,	/* 1430:  .6.$ */
	0xED,0xF6,0x00,0x0D,0x18,0x3D,0xFD,0x36,	/* 1438: ...=6 */
	0x7F,0x34,0xCD,0x82,0x15,0xFD,0x36,0x7F,	/* 1440: 4͂.6 */
	0x40,0xFD,0x36,0x7F,0x00,0xFD,0x36,0x68,	/* 1448: @6.6h */
	0x00,0xFD,0x36,0x18,0x00,0xFD,0x36,0x7F,	/* 1450: .6..6 */
	0x04,0xFD,0x36,0x68,0x00,0xFD,0x36,0x18,	/* 1458: .6h.6. */
	0x55,0xFD,0x36,0x7F,0x00,0xFD,0x7E,0x18,	/* 1460: U6.~. */
	0xFE,0x55,0x20,0x06,0xDD,0x36,0x00,0x48,	/* 1468: U .6.H */
	0x18,0x04,0xDD,0x36,0x00,0x28,0xFD,0xED,	/* 1470: ..6.( */
	0xF6,0x00,0x19,0xDD,0x23,0xE5,0xED,0x32,	/* 1478: ..#2 */
	0x00,0x00,0xFD,0xED,0xF6,0x80,0x00,0xE5,	/* 1480: ... */
	0xFD,0xE1,0xE1,0x0C,0x79,0xFE,0x04,0xC2,	/* 1488: .y. */
	0xBF,0x13,0x79,0xFE,0x00,0x28,0x43,0xE5,	/* 1490: .y.(C */
	0x21,0xDD,0x0F,0xFD,0xED,0xF7,0x00,0x10,	/* 1498: !... */
	0xE1,0xF2,0xAB,0x14,0x3A,0x91,0x00,0xFE,	/* 14A0: .:. */
	0x01,0x20,0x05,0xDD,0x3E,0x94,0x00,0x01,	/* 14A8: . .>.. */
	0x3A,0x01,0x00,0xFE,0x40,0x28,0x39,0x22,	/* 14B0: :..@(9" */
	0x95,0x00,0x21,0x00,0x80,0x3A,0x94,0x00,	/* 14B8: .!.:. */
	0xFE,0x01,0x20,0x07,0xFD,0xED,0xFE,0x00,	/* 14C0: . .. */
	0x20,0x18,0x05,0xFD,0xED,0xFE,0x00,0x10,	/* 14C8:  .... */
	0xDD,0xED,0xDE,0x95,0x00,0xFA,0xE8,0x14,	/* 14D0: ޕ.. */
	0x18,0x16,0xDD,0x3E,0x00,0x00,0xFF,0x18,	/* 14D8: ..>... */
	0x0E,0xDD,0x3E,0x00,0x00,0x02,0x18,0x07,	/* 14E0: .>..... */
	0xDD,0x3E,0x00,0x00,0x03,0x18,0x00,0x76,	/* 14E8: >.....v */
	0x21,0x00,0x00,0x0E,0xF0,0xED,0xBF,0x00,	/* 14F0: !.... */
	0x00,0x00,0x01,0xF0,0x1D,0x21,0x00,0x00,	/* 14F8: ....!.. */
	0x3A,0x01,0x00,0xFE,0x20,0x20,0x14,0x3A,	/* 1500: :..  .: */
	0x94,0x00,0xFE,0x01,0x20,0x05,0x11,0x00,	/* 1508: .. ... */
	0x60,0x18,0x0B,0x01,0xDD,0x0F,0x11,0x00,	/* 1510: `...... */
	0x70,0x18,0x03,0x11,0x00,0x80,0xED,0xB0,	/* 1518: p.... */
	0x3A,0x01,0x00,0xFE,0x20,0x20,0x12,0x3A,	/* 1520: :..  .: */
	0x94,0x00,0xFE,0x01,0x28,0x0B,0x01,0xF0,	/* 1528: ..(.. */
	0x0D,0x11,0x00,0x60,0x21,0x00,0x10,0xED,	/* 1530: ...`!.. */
	0xB0,0x3A,0x01,0x00,0xFE,0x20,0x20,0x05,	/* 1538: :..  . */
	0x21,0x70,0x00,0x18,0x03,0x21,0x80,0x00,	/* 1540: !p...!. */
	0x0E,0x06,0xED,0x6E,0x3A,0x01,0x00,0xFE,	/* 1548: ..n:.. */
	0x20,0x20,0x13,0x3A,0x94,0x00,0xFE,0x01,	/* 1550:   .:.. */
	0x20,0x06,0xDD,0x21,0xAA,0x12,0x18,0x0A,	/* 1558:  .!... */
	0xDD,0x21,0x6A,0x12,0x18,0x04,0xDD,0x21,	/* 1560: !j...! */
	0xEA,0x12,0x3E,0x00,0x0E,0xF5,0xED,0x2C,	/* 1568: .>.., */
	0x00,0x00,0xD3,0xF1,0xED,0xBF,0x3C,0xDD,	/* 1570: ..< */
	0x23,0xDD,0x23,0xFE,0x20,0x20,0xEF,0xC3,	/* 1578: ##   */
	0xC7,0x00,0xF5,0xC5,0xE5,0xFD,0x36,0x66,	/* 1580: .6f */
	0x01,0xFD,0x36,0x68,0x03,0xFD,0x36,0x74,	/* 1588: .6h.6t */
	0x00,0xFD,0x36,0x68,0x02,0xFD,0x36,0x74,	/* 1590: .6h.6t */
	0x00,0xFD,0x36,0x68,0x01,0xFD,0x36,0x74,	/* 1598: .6h.6t */
	0x00,0xFD,0x36,0x68,0x00,0xFD,0x36,0x74,	/* 15A0: .6h.6t */
	0x00,0xFD,0x36,0x68,0x03,0xFD,0x36,0x7A,	/* 15A8: .6h.6z */
	0x00,0xFD,0x36,0x68,0x02,0xFD,0x36,0x7A,	/* 15B0: .6h.6z */
	0x00,0xFD,0x36,0x68,0x01,0xFD,0x36,0x7A,	/* 15B8: .6h.6z */
	0x00,0xFD,0x36,0x68,0x00,0xFD,0x36,0x7A,	/* 15C0: .6h.6z */
	0x00,0xFD,0x36,0x68,0x04,0xFD,0x36,0x6D,	/* 15C8: .6h.6m */
	0xA8,0xFD,0x36,0x6E,0x00,0xFD,0x36,0x6F,	/* 15D0: 6n.6o */
	0x00,0xFD,0x36,0x6C,0x01,0xFD,0x36,0x66,	/* 15D8: .6l.6f */
	0x03,0xFD,0x36,0x66,0x03,0xFD,0x36,0x66,	/* 15E0: .6f.6f */
	0x03,0xFD,0x36,0x68,0x04,0xFD,0x36,0x6D,	/* 15E8: .6h.6m */
	0xA8,0xFD,0x36,0x6E,0x20,0xFD,0x36,0x6F,	/* 15F0: 6n 6o */
	0x00,0xFD,0x36,0x66,0x03,0xFD,0x36,0x66,	/* 15F8: .6f.6f */
	0x03,0xFD,0x36,0x66,0x03,0xFD,0x36,0x6C,	/* 1600: .6f.6l */
	0x00,0x06,0x0F,0xFD,0x36,0x66,0x03,0x10,	/* 1608: ...6f.. */
	0xFA,0xFD,0x36,0x68,0x04,0xFD,0x36,0x6D,	/* 1610: 6h.6m */
	0x00,0xFD,0x36,0x6E,0x20,0xFD,0x36,0x6F,	/* 1618: .6n 6o */
	0x03,0xFD,0x36,0x6C,0x01,0xFD,0x36,0x66,	/* 1620: .6l.6f */
	0x03,0xFD,0x36,0x66,0x03,0xFD,0x36,0x66,	/* 1628: .6f.6f */
	0x03,0xFD,0x36,0x66,0x03,0xFD,0x36,0x6C,	/* 1630: .6f.6l */
	0x00,0xFD,0x36,0x66,0x00,0xFD,0x36,0x68,	/* 1638: .6f.6h */
	0x00,0x21,0xFF,0x7F,0x2B,0xFD,0xED,0xF7,	/* 1640: .!+ */
	0x00,0x00,0x20,0xF8,0xFD,0x36,0x40,0x00,	/* 1648: .. 6@. */
	0xFD,0x36,0x05,0x81,0x21,0xFF,0x7F,0xFD,	/* 1650: 6.! */
	0x7E,0x40,0xFE,0x00,0x28,0xF9,0xFD,0x36,	/* 1658: ~@.(6 */
	0x4B,0x00,0xFD,0x36,0x7E,0xC3,0x06,0x04,	/* 1660: K.6~.. */
	0x05,0xFD,0x70,0x68,0xFD,0x36,0x18,0x00,	/* 1668: .ph6.. */
	0x78,0xFE,0x00,0x20,0xF3,0xE1,0xC1,0xF1,	/* 1670: x.  */
	0xC9,0x43,0x6F,0x70,0x79,0x72,0x69,0x67,	/* 1678: Copyrig */
	0x68,0x74,0x20,0x28,0x63,0x29,0x20,0x53,	/* 1680: ht (c) S */
	0x70,0x65,0x63,0x69,0x61,0x6C,0x69,0x78,	/* 1688: pecialix */
	0x20,0x52,0x65,0x73,0x65,0x61,0x72,0x63,	/* 1690:  Researc */
	0x68,0x20,0x4C,0x74,0x64,0x20,0x31,0x39,	/* 1698: h Ltd 19 */
	0x38,0x38,0x2D,0x31,0x39,0x39,0x38,0x0D,	/* 16A0: 88-1998. */
	0x0A,0x5A,0x32,0x38,0x30,0x20,0x44,0x6F,	/* 16A8: .Z280 Do */
	0x77,0x6E,0x6C,0x6F,0x61,0x64,0x20,0x43,	/* 16B0: wnload C */
	0x6F,0x64,0x65,0x20,0x56,0x65,0x72,0x73,	/* 16B8: ode Vers */
	0x69,0x6F,0x6E,0x20,0x31,0x2E,0x34,0x32,	/* 16C0: ion 1.42 */
	0x0D,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,	/* 16C8: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 16D0: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 16D8: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 16E0: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 16E8: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 16F0: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 16F8: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1700: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1708: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1710: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1718: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1720: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1728: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1730: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1738: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1740: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1748: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1750: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1758: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1760: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1768: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1770: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1778: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1780: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1788: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1790: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1798: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 17A0: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 17A8: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 17B0: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 17B8: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 17C0: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 17C8: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 17D0: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 17D8: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 17E0: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 17E8: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 17F0: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 17F8: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1800: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1808: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1810: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1818: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1820: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1828: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1830: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1838: ........ */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 1840: ........ */
	0x00,0x00,0x42,0x41,0x82,0x04,0x16,0x00,	/* 1848: ..BA... */
	0x41,0x00,0x41,0x04,0x82,0x03,0x41,0x03,	/* 1850: A.A..A. */
	0x82,0x02,0x4E,0x02,0x41,0x02,0x82,0x01,	/* 1858: .N.A.. */
	0x57,0x02,0x41,0x01,0x82,0x00,0x2B,0x00,	/* 1860: W.A..+. */
	0xA3,0x04,0x1B,0x00,0x51,0x00,0x51,0x04,	/* 1868: ...Q.Q. */
	0xA3,0x03,0x51,0x03,0xA3,0x02,0x62,0x02,	/* 1870: .Q..b. */
	0x51,0x02,0xA3,0x01,0x6D,0x02,0x51,0x01,	/* 1878: Q..m.Q. */
	0xA3,0x00,0x36,0x00,0x49,0x4E,0x00,0x00,	/* 1880: .6.IN.. */
	0x1E,0x01,0x18,0x02,0x1E,0x00,0xDD,0xD1,	/* 1888: ...... */
	0x86,0x18,0xF5,0xDD,0xE5,0x21,0x80,0x80,	/* 1890: .! */
	0x54,0xFD,0x7B,0x08,0x00,0xFD,0xED,0x3C,	/* 1898: T{..< */
	0x06,0x00,0xFE,0x24,0x28,0x04,0x06,0x04,	/* 18A0: ..$(... */
	0x18,0x02,0x06,0x00,0xFD,0x70,0x7F,0xCB,	/* 18A8: ....p */
	0x43,0x20,0x05,0xFD,0x7E,0x6A,0x18,0x03,	/* 18B0: C .~j.. */
	0xFD,0x7E,0x6B,0x4F,0xCB,0x7F,0xCA,0x56,	/* 18B8: ~kOV */
	0x19,0xE6,0x03,0xFD,0x77,0x68,0xED,0x3A,	/* 18C0: ..wh: */
	0x08,0x00,0xB0,0xCB,0x27,0x85,0x6F,0xDD,	/* 18C8: ..'o */
	0xED,0x3C,0x02,0x00,0xCB,0x43,0xC2,0x88,	/* 18D0: <..C */
	0x19,0xD9,0xDD,0x6E,0xAC,0xDD,0x7E,0xAD,	/* 18D8: .n~ */
	0x95,0x4F,0xE6,0x0C,0xFE,0x0C,0x28,0x06,	/* 18E0: O..(. */
	0x79,0xE6,0x30,0xCA,0xC1,0x1A,0xDD,0x7E,	/* 18E8: y0.~ */
	0xA9,0xE6,0x05,0xC2,0x6E,0x1A,0x79,0xCB,	/* 18F0: .n.y */
	0x7F,0x20,0x05,0xFE,0x0C,0xFA,0xB2,0x1A,	/* 18F8:  ... */
	0xDD,0x79,0xFD,0x77,0x63,0x2C,0xDD,0x79,	/* 1900: ywc,y */
	0xFD,0x77,0x63,0x2C,0xDD,0x79,0xFD,0x77,	/* 1908: wc,yw */
	0x63,0x2C,0xDD,0x79,0xFD,0x77,0x63,0x2C,	/* 1910: c,ywc, */
	0xDD,0x79,0xFD,0x77,0x63,0x2C,0xDD,0x79,	/* 1918: ywc,y */
	0xFD,0x77,0x63,0x2C,0xDD,0x79,0xFD,0x77,	/* 1920: wc,yw */
	0x63,0x2C,0xDD,0x79,0xFD,0x77,0x63,0x2C,	/* 1928: c,ywc, */
	0xDD,0x79,0xFD,0x77,0x63,0x2C,0xDD,0x79,	/* 1930: ywc,y */
	0xFD,0x77,0x63,0x2C,0xDD,0x79,0xFD,0x77,	/* 1938: wc,yw */
	0x63,0x2C,0xDD,0x79,0xFD,0x77,0x63,0x2C,	/* 1940: c,ywc, */
	0xDD,0x75,0xAC,0xD9,0x79,0xE6,0x3F,0xCB,	/* 1948: uy? */
	0x43,0x20,0x30,0xFD,0x77,0x6A,0x62,0x2E,	/* 1950: C 0wjb. */
	0x80,0xCB,0x50,0x28,0x05,0x06,0x00,0xC3,	/* 1958: P(... */
	0xAC,0x18,0xDD,0xED,0x3A,0x02,0x00,0xDD,	/* 1960: .:.. */
	0x66,0xFF,0xFD,0xED,0xF7,0x80,0x00,0xC2,	/* 1968: f. */
	0x98,0x18,0xDD,0xE1,0xF1,0xED,0x55,0xFD,	/* 1970: .U */
	0x7E,0x62,0xED,0x0B,0x2C,0x10,0xF8,0x18,	/* 1978: ~b.,.. */
	0x2A,0x49,0x4E,0xFD,0x77,0x6B,0x18,0xCE,	/* 1980: *INwk. */
	0xD9,0xFD,0x7E,0x43,0xFE,0x07,0x28,0x57,	/* 1988: ~C.(W */
	0x26,0x01,0xDD,0x7E,0xAB,0xDD,0x6E,0xAA,	/* 1990: &.~n */
	0x95,0x3D,0x4F,0xFD,0x46,0x0E,0x58,0xCB,	/* 1998: =OF.X */
	0x7F,0x20,0x04,0xB8,0xFA,0xD3,0x19,0x16,	/* 19A0:  ... */
	0x00,0x18,0xCC,0xDD,0x3E,0xC2,0x05,0x01,	/* 19A8: ..>.. */
	0x7A,0xFE,0x00,0x20,0x2A,0xDD,0xCB,0xA8,	/* 19B0: z. *˨ */
	0x5E,0x28,0x10,0x79,0xCB,0x7F,0x20,0x0B,	/* 19B8: ^(.y . */
	0xFE,0x40,0xFA,0xCB,0x19,0x93,0xFE,0x40,	/* 19C0: @.@ */
	0xFA,0xF8,0x19,0xDD,0x75,0xAA,0x26,0x00,	/* 19C8: .u&. */
	0xC3,0x4B,0x19,0xFE,0x00,0x28,0x09,0x16,	/* 19D0: K..(.. */
	0x01,0x78,0x91,0x5F,0x41,0x18,0x98,0x43,	/* 19D8: .x_A.C */
	0xFD,0x7E,0x62,0x10,0xFB,0x18,0xE4,0xDD,	/* 19E0: ~b.. */
	0xCB,0xB9,0xC6,0xDD,0x3E,0xC3,0x05,0x01,	/* 19E8: ˹>.. */
	0xFD,0x7E,0x62,0xFD,0x7E,0x62,0x18,0xD6,	/* 19F0: ~b~b. */
	0xDD,0xCB,0xBA,0x5E,0x28,0x1F,0xDD,0xCB,	/* 19F8: ˺^(. */
	0xA8,0x6E,0x20,0x19,0xFD,0x7E,0x05,0xFE,	/* 1A00: n .~. */
	0x00,0x20,0x0A,0xFD,0x36,0x05,0x24,0xDD,	/* 1A08: . .6.$ */
	0xCB,0xA8,0xEE,0x18,0x08,0xDD,0xCB,0xA8,	/* 1A10: ˨..˨ */
	0xFE,0xDD,0xCB,0xA8,0xF6,0xDD,0xCB,0xA8,	/* 1A18: ˨˨ */
	0xE6,0xDD,0xCB,0xB4,0x7E,0x28,0x19,0xDD,	/* 1A20: ˴~(. */
	0x7E,0xC4,0xE6,0x08,0x20,0x06,0xFD,0x36,	/* 1A28: ~. .6 */
	0x6C,0x00,0x18,0x0C,0xFD,0x7E,0x15,0xE6,	/* 1A30: l...~. */
	0xF0,0xFD,0x77,0x15,0xFD,0x36,0x6D,0x00,	/* 1A38: w.6m. */
	0xDD,0xCB,0xBA,0x76,0x28,0x85,0xDD,0x7E,	/* 1A40: ˺v(~ */
	0xC4,0xE6,0x08,0x20,0x0E,0xFD,0x7E,0x15,	/* 1A48: . .~. */
	0xE6,0xF0,0xFD,0x77,0x15,0xFD,0x36,0x6D,	/* 1A50: w.6m */
	0x00,0x18,0x04,0xFD,0x36,0x6C,0x00,0xDD,	/* 1A58: ...6l. */
	0xCB,0xA8,0xEE,0xDD,0xCB,0xA8,0xBE,0xDD,	/* 1A60: ˨˨ */
	0xCB,0xA8,0xB6,0xC3,0xCB,0x19,0xDD,0xCB,	/* 1A68: ˨. */
	0xA9,0x46,0x28,0x13,0xDD,0xCB,0xA9,0xCE,	/* 1A70: F(.˩ */
	0xDD,0xCB,0xA9,0x86,0xFD,0x7E,0x06,0xE6,	/* 1A78: ˩~. */
	0xF9,0xFD,0x77,0x06,0xC3,0x48,0x19,0x79,	/* 1A80: w.H.y */
	0xCB,0x7F,0x20,0x0C,0xFE,0x0C,0xF2,0x98,	/* 1A88:  .. */
	0x1A,0xFE,0x00,0x28,0x52,0x47,0x18,0x02,	/* 1A90: ..(RG.. */
	0x06,0x0C,0xDD,0x79,0xFE,0x0A,0x28,0x08,	/* 1A98: ..y.(. */
	0xFD,0x77,0x63,0x2C,0x10,0xF4,0x18,0x3F,	/* 1AA0: wc,..? */
	0xFD,0x36,0x63,0x0D,0xFD,0x36,0x63,0x0A,	/* 1AA8: 6c.6c. */
	0x18,0xF1,0xFE,0x00,0x28,0x31,0x47,0xDD,	/* 1AB0: ..(1G */
	0x79,0xFD,0x77,0x63,0x2C,0x10,0xF8,0x18,	/* 1AB8: ywc,.. */
	0x26,0x79,0xE6,0xC0,0xFE,0x40,0x20,0x13,	/* 1AC0: &y@ . */
	0xDD,0xCB,0xA9,0x5E,0xCA,0xEE,0x18,0xDD,	/* 1AC8: ˩^. */
	0xCB,0xA9,0x9E,0xDD,0x3E,0xC3,0x05,0x01,	/* 1AD0: ˩>.. */
	0xC3,0xEE,0x18,0xFE,0xC0,0xC2,0xEE,0x18,	/* 1AD8: .. */
	0xDD,0xCB,0xA9,0xDE,0xC3,0xEE,0x18,0xFD,	/* 1AE0: ˩. */
	0x7E,0x06,0xE6,0xF9,0xFD,0x77,0x06,0xDD,	/* 1AE8: ~.w. */
	0xCB,0xA8,0x86,0xC3,0x48,0x19,0xDD,0xD1,	/* 1AF0: ˨H. */
	0x86,0x18,0xF5,0xC5,0xD5,0xE5,0xFD,0xE5,	/* 1AF8: . */
	0xDD,0xE5,0x21,0x80,0x80,0x54,0xFD,0x7B,	/* 1B00: !T{ */
	0x08,0x00,0xFD,0xED,0x3C,0x06,0x00,0xFE,	/* 1B08: ..<.. */
	0x24,0x28,0x04,0x06,0x04,0x18,0x02,0x06,	/* 1B10: $(...... */
	0x00,0x78,0xED,0x3B,0x1A,0x00,0xFD,0x70,	/* 1B18: .x;..p */
	0x7F,0xFD,0x7E,0x69,0xCB,0x7F,0x28,0x2C,	/* 1B20: ~i(, */
	0xFD,0x5E,0x68,0xE6,0x03,0xFD,0x77,0x68,	/* 1B28: ^h.wh */
	0xED,0x3A,0x0A,0x00,0xB0,0xCB,0x27,0x85,	/* 1B30: :..' */
	0x6F,0xED,0x26,0xE5,0xDD,0xE1,0xC5,0xCD,	/* 1B38: o& */
	0x04,0x09,0xDD,0x3E,0xC3,0x05,0x01,0xDD,	/* 1B40: ..>.. */
	0xCB,0xB9,0xCE,0xFD,0x7E,0x69,0xE6,0x3F,	/* 1B48: ˹~i? */
	0xFD,0x77,0x69,0xC1,0x62,0x2E,0x80,0xCB,	/* 1B50: wib. */
	0x50,0x28,0x04,0x06,0x00,0x18,0xBA,0xE5,	/* 1B58: P(.... */
	0xDD,0xE1,0xDD,0x66,0x01,0xFD,0xED,0xF7,	/* 1B60: f. */
	0x80,0x00,0x20,0x99,0xDD,0xE1,0xFD,0xE1,	/* 1B68: .  */
	0xE1,0xD1,0xC1,0xF1,0xED,0x55,0xE5,0x21,	/* 1B70: U! */
	0xE8,0x03,0x2B,0xFD,0xED,0xF7,0x00,0x00,	/* 1B78: .+.. */
	0x20,0xF8,0xE1,0xC9,0xCD,0xF3,0x08,0xDD,	/* 1B80:  . */
	0x7E,0xC7,0xFE,0x01,0xC2,0x28,0x1C,0xFD,	/* 1B88: ~.(. */
	0x36,0x6F,0x03,0xCD,0x76,0x1B,0xFD,0x7E,	/* 1B90: 6o.v.~ */
	0x6F,0xE6,0x20,0x20,0x07,0xDD,0x36,0xC8,	/* 1B98: o  .6 */
	0x09,0xC3,0x28,0x1C,0xFD,0x36,0x6F,0x02,	/* 1BA0: .(.6o. */
	0xCD,0x76,0x1B,0xFD,0x7E,0x6F,0xE6,0x20,	/* 1BA8: v.~o  */
	0x28,0x06,0xDD,0x36,0xC8,0x0A,0x18,0x70,	/* 1BB0: (.6..p */
	0xFD,0x36,0x6F,0x06,0xCD,0x76,0x1B,0xFD,	/* 1BB8: 6o.v. */
	0x7E,0x6F,0xE6,0x10,0x20,0x06,0xDD,0x36,	/* 1BC0: ~o. .6 */
	0xC8,0x0B,0x18,0x5C,0xFD,0x36,0x6F,0x02,	/* 1BC8: ..\6o. */
	0xCD,0x76,0x1B,0xFD,0x7E,0x6F,0xE6,0x20,	/* 1BD0: v.~o  */
	0x28,0x06,0xDD,0x36,0xC8,0x0A,0x18,0x48,	/* 1BD8: (.6..H */
	0x06,0x08,0xFD,0x36,0x6F,0x02,0xCD,0x76,	/* 1BE0: ..6o.v */
	0x1B,0xFD,0x36,0x6F,0x00,0xCD,0x76,0x1B,	/* 1BE8: .6o.v. */
	0xFD,0x7E,0x6F,0xE6,0x80,0x20,0x28,0x10,	/* 1BF0: ~o (. */
	0xE9,0xFD,0x36,0x6F,0x02,0xCD,0x76,0x1B,	/* 1BF8: 6o.v. */
	0xFD,0x36,0x6F,0x00,0x21,0xE8,0x03,0xFD,	/* 1C00: 6o.!. */
	0x7E,0x6F,0xE6,0x40,0x20,0x16,0x2B,0xFD,	/* 1C08: ~o@ .+ */
	0xED,0xF7,0x00,0x00,0x20,0xF1,0xDD,0x36,	/* 1C10: .. 6 */
	0xC8,0x0D,0xDD,0x77,0xB8,0x18,0x09,0xDD,	/* 1C18: .w.. */
	0x70,0xC8,0x18,0x04,0xDD,0x36,0xC8,0x00,	/* 1C20: p..6. */
	0xCD,0x76,0x1B,0xFD,0x36,0x6F,0x02,0xCD,	/* 1C28: v.6o. */
	0x76,0x1B,0xFD,0x36,0x6F,0x00,0xFD,0x36,	/* 1C30: v.6o.6 */
	0x05,0x80,0xDD,0x36,0xAE,0x00,0xC9,0xCD,	/* 1C38: .6. */
	0xF3,0x08,0xDD,0xCB,0xA9,0x4E,0x20,0x23,	/* 1C40: .˩N # */
	0xDD,0xCB,0xA9,0xC6,0xDD,0x7E,0xC7,0xFE,	/* 1C48: ˩~ */
	0x01,0x28,0x0F,0xFD,0x7E,0x06,0xF6,0x02,	/* 1C50: .(.~.. */
	0xE6,0xFB,0xFD,0x77,0x06,0x26,0x00,0xC3,	/* 1C58: w.&. */
	0x12,0x0D,0xFD,0x36,0x06,0x84,0x26,0x00,	/* 1C60: ..6.&. */
	0xC3,0x12,0x0D,0xFD,0x7E,0x06,0xE6,0xF9,	/* 1C68: ..~. */
	0xFD,0x77,0x06,0xFD,0x7E,0x09,0xF6,0x20,	/* 1C70: w.~.  */
	0xFD,0x77,0x09,0xFD,0x7E,0x50,0xFD,0x77,	/* 1C78: w.~Pw */
	0x65,0xFD,0x36,0x63,0x00,0xFD,0x36,0x63,	/* 1C80: e6c.6c */
	0x81,0xFD,0x36,0x12,0x02,0xDD,0x36,0xAE,	/* 1C88: 6..6 */
	0x12,0xDD,0x3E,0xC3,0x05,0x01,0x26,0x00,	/* 1C90: .>..&. */
	0xC3,0x12,0x0D,0xCD,0xF3,0x08,0xDD,0x7E,	/* 1C98: ...~ */
	0xC5,0xFE,0x01,0x28,0x27,0xFD,0x7E,0x12,	/* 1CA0: .('~. */
	0xFE,0x00,0x28,0x05,0x26,0x00,0xC3,0x12,	/* 1CA8: .(.&.. */
	0x0D,0xFD,0x7E,0x50,0xFD,0x77,0x65,0xFD,	/* 1CB0: .~Pwe */
	0x36,0x63,0x00,0xFD,0x36,0x63,0x83,0xFD,	/* 1CB8: 6c.6c */
	0x36,0x12,0x02,0xDD,0x36,0xC5,0x01,0x26,	/* 1CC0: 6..6.& */
	0x00,0xC3,0x12,0x0D,0xFD,0x7E,0x12,0xFE,	/* 1CC8: ...~. */
	0x00,0x28,0x05,0x26,0x00,0xC3,0x12,0x0D,	/* 1CD0: .(.&... */
	0xFD,0x7E,0x06,0xF6,0x04,0xE6,0xFD,0xFD,	/* 1CD8: ~.. */
	0x77,0x06,0xFD,0x7E,0x09,0xE6,0xDF,0xFD,	/* 1CE0: w.~. */
	0x77,0x09,0xDD,0x36,0xAE,0x00,0xDD,0x3E,	/* 1CE8: w.6.> */
	0xC3,0x05,0x01,0xDD,0x36,0xC5,0x00,0x26,	/* 1CF0: ..6.& */
	0x00,0xC3,0x12,0x0D,0x26,0x00,0xDD,0x7E,	/* 1CF8: ...&.~ */
	0xAC,0xDD,0x96,0xAD,0x28,0x04,0xF1,0xC3,	/* 1D00: ݖ(. */
	0x23,0x0D,0xCD,0xF3,0x08,0xDD,0x7E,0xBF,	/* 1D08: #..~ */
	0xFE,0x01,0x28,0x4D,0xDD,0xCB,0xA9,0x4E,	/* 1D10: .(M˩N */
	0x28,0x26,0xED,0x2C,0xA4,0xFF,0xDD,0x7E,	/* 1D18: (&,~ */
	0xA7,0xFE,0x04,0xF2,0x33,0x1D,0xFD,0x1D,	/* 1D20: .3.. */
	0x1C,0x00,0x20,0x35,0xF6,0x10,0xFD,0x77,	/* 1D28: .. 5.w */
	0x7F,0x18,0x2E,0xFD,0x1D,0x1D,0x00,0x20,	/* 1D30: .....  */
	0x28,0xF6,0x40,0xFD,0x77,0x7F,0x18,0x21,	/* 1D38: (@w.! */
	0xDD,0x7E,0xC9,0xFE,0x01,0x20,0x10,0xDD,	/* 1D40: ~. . */
	0xCB,0xA9,0xC6,0xDD,0x7E,0xC7,0xFE,0x01,	/* 1D48: ˩~. */
	0x28,0x0A,0xFD,0x36,0x06,0x92,0xC9,0xDD,	/* 1D50: (.6. */
	0xCB,0xA9,0xCE,0xC9,0xFD,0x36,0x06,0x94,	/* 1D58: ˩6. */
	0xC9,0xDD,0x36,0xAA,0x00,0xDD,0x36,0xAB,	/* 1D60: 6.6 */
	0x00,0xDD,0x36,0xAC,0x00,0xDD,0x36,0xAD,	/* 1D68: .6.6 */
	0x00,0xDD,0x36,0xC9,0x00,0xCD,0xF3,0x08,	/* 1D70: .6.. */
	0xFD,0x7E,0x05,0xFE,0x00,0xC0,0xDD,0xCB,	/* 1D78: ~.. */
	0xA9,0x8E,0xDD,0x7E,0xC7,0xFE,0x01,0x20,	/* 1D80: ~.  */
	0x06,0xFD,0x36,0x05,0x14,0x18,0x32,0xDD,	/* 1D88: .6...2 */
	0xCB,0xB7,0x46,0x20,0x11,0xDD,0x7E,0xC4,	/* 1D90: ˷F .~ */
	0xE6,0x08,0x20,0x06,0xFD,0x36,0x6C,0x00,	/* 1D98: . .6l. */
	0x18,0x04,0xFD,0x36,0x6D,0x00,0xDD,0xCB,	/* 1DA0: ..6m. */
	0xB7,0x4E,0x20,0x11,0xDD,0x7E,0xC4,0xE6,	/* 1DA8: N .~ */
	0x08,0x20,0x06,0xFD,0x36,0x6D,0x00,0x18,	/* 1DB0: . .6m.. */
	0x04,0xFD,0x36,0x6C,0x00,0xFD,0x36,0x05,	/* 1DB8: .6l.6. */
	0x80,0xFD,0x36,0x06,0x00,0xDD,0x36,0xBF,	/* 1DC0: 6..6 */
	0x01,0xDD,0x36,0xAE,0x10,0xDD,0x3E,0xC3,	/* 1DC8: .6.> */
	0x05,0x01,0xC9,0x3A,0x49,0x00,0xFE,0x01,	/* 1DD0: ..:I.. */
	0x28,0x0B,0xFD,0x1E,0x06,0x00,0x00,0xFD,	/* 1DD8: (..... */
	0x1E,0x07,0x00,0x02,0xC9,0xFD,0x1E,0x06,	/* 1DE0: ...... */
	0x00,0x09,0xFD,0x1E,0x07,0x00,0x00,0xC9,	/* 1DE8: ...... */
	0x02,0x44,0x02,0x44,0x02,0x40,0x02,0x40,	/* 1DF0: .D.D.@.@ */
	0x02,0x40,0x02,0x40,0x02,0x44,0x02,0x44,	/* 1DF8: .@.@.D.D */
	0x02,0x44,0x02,0x44,0x02,0x44,0x02,0x40,	/* 1E00: .D.D.D.@ */
	0x02,0x40,0x02,0x44,0x02,0x44,0x20,0x1E,	/* 1E08: .@.D.D . */
	0x44,0x03,0x44,0x02,0x44,0x02,0x44,0x01,	/* 1E10: D.D.D.D. */
	0x40,0x20,0x14,0x44,0x03,0x40,0x12,0x44,	/* 1E18: @ .D.@.D */
	0x05,0x40,0x03,0x40,0x16,0x44,0x02,0x40,	/* 1E20: .@.@.D.@ */
	0x07,0x44,0x0A,0x40,0x05,0x40,0x11,0x40,	/* 1E28: .D.@.@.@ */
	0x20,0x03,0x40,0x18,0x44,0x12,0x44,0x09,	/* 1E30:  .@.D.D. */
	0x44,0x02,0x44,0x20,0x46,0x40,0x17,0x44,	/* 1E38: D.D F@.D */
	0x06,0x44,0x06,0x44,0x03,0x44,0x04,0x44,	/* 1E40: .D.D.D.D */
	0x0D,0x44,0x02,0x44,0x06,0x44,0x02,0x44,	/* 1E48: .D.D.D.D */
	0x20,0x18,0x40,0x1F,0x44,0x05,0x44,0x07,	/* 1E50:  .@.D.D. */
	0x44,0x18,0x44,0x20,0x0C,0x44,0x06,0x44,	/* 1E58: D.D .D.D */
	0x02,0x44,0x01,0x44,0x0F,0x44,0x15,0x44,	/* 1E60: .D.D.D.D */
	0x08,0x44,0x03,0x44,0x0D,0x44,0x1D,0x44,	/* 1E68: .D.D.D.D */
	0x01,0x44,0x14,0x40,0x08,0x40,0x03,0x44,	/* 1E70: .D.@.@.D */
	0x06,0x40,0x03,0x44,0x06,0x40,0x03,0x44,	/* 1E78: .@.D.@.D */
	0x06,0x40,0x03,0x44,0x0F,0x44,0x04,0x44,	/* 1E80: .@.D.D.D */
	0x0F,0x44,0x04,0x44,0x03,0x44,0x20,0x34,	/* 1E88: .D.D.D 4 */
	0x44,0x04,0x44,0x11,0x44,0x04,0x44,0x14,	/* 1E90: D.D.D.D. */
	0x44,0x04,0x44,0x02,0x40,0x1B,0x44,0x0A,	/* 1E98: D.D.@.D. */
	0x40,0x03,0x44,0x05,0x40,0x05,0x44,0x0F,	/* 1EA0: @.D.@.D. */
	0x40,0x02,0x44,0x02,0x40,0x20,0x0E,0x44,	/* 1EA8: @.D.@ .D */
	0x18,0x40,0x10,0x44,0x05,0x44,0x05,0x44,	/* 1EB0: .@.D.D.D */
	0x0B,0x44,0x14,0x44,0x03,0x44,0x08,0x44,	/* 1EB8: .D.D.D.D */
	0x02,0x44,0x10,0x44,0x44,0x44,0x44,0x44,	/* 1EC0: .D.DDDDD */
	0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,	/* 1EC8: DDDDDDDD */
	0x44,0x44,0x44,0x44,0x44,0x40,0x40,0x44,	/* 1ED0: DDDDD@@D */
	0x44,0x40,0x40,0x20,0x00,0x44,0x20,0x01,	/* 1ED8: D@@ .D . */
	0x44,0x10,0x44,0x10,0x44,0x05,0x44,0x20,	/* 1EE0: D.D.D.D  */
	0x04,0x44,0x14,0x44,0x06,0x44,0x0A,0x44,	/* 1EE8: .D.D.D.D */
	0x04,0x44,0x04,0x44,0x05,0x44,0x03,0x44,	/* 1EF0: .D.D.D.D */
	0x0F,0x44,0x0B,0x44,0x03,0x44,0x03,0x44,	/* 1EF8: .D.D.D.D */
	0x03,0x44,0x0C,0x44,0x05,0x44,0x03,0x44,	/* 1F00: .D.D.D.D */
	0x05,0x44,0x0E,0x44,0x06,0x44,0x0B,0x44,	/* 1F08: .D.D.D.D */
	0x07,0x44,0x02,0x44,0x03,0x44,0x06,0x44,	/* 1F10: .D.D.D.D */
	0x0D,0x44,0x06,0x44,0x02,0x44,0x03,0x44,	/* 1F18: .D.D.D.D */
	0x05,0x44,0x20,0x02,0x44,0x03,0x44,0x05,	/* 1F20: .D .D.D. */
	0x44,0x16,0x44,0x1A,0x44,0x0E,0x44,0x16,	/* 1F28: D.D.D.D. */
	0x44,0x03,0x44,0x05,0x44,0x04,0x44,0x19,	/* 1F30: D.D.D.D. */
	0x44,0x04,0x44,0x01,0x44,0x03,0x44,0x05,	/* 1F38: D.D.D.D. */
	0x44,0x05,0x44,0x06,0x44,0x02,0x44,0x0C,	/* 1F40: D.D.D.D. */
	0x44,0x05,0x44,0x09,0x44,0x0A,0x44,0x0B,	/* 1F48: D.D.D.D. */
	0x44,0x08,0x44,0x20,0x09,0x44,0x12,0x44,	/* 1F50: D.D .D.D */
	0x02,0x44,0x20,0x1C,0x44,0x20,0x2E,0x44,	/* 1F58: .D .D .D */
	0x11,0x44,0x20,0x28,0x44,0x13,0x44,0x09,	/* 1F60: .D (D.D. */
	0x44,0x12,0x40,0x03,0x40,0x20,0x01,0x40,	/* 1F68: D.@.@ .@ */
	0x03,0x40,0x21,0x4F,0x44,0x20,0x4B,0x44,	/* 1F70: .@!OD KD */
	0x20,0x34,0x40,0x03,0x44,0x0D,0x40,0x08,	/* 1F78:  4@.D.@. */
	0x44,0x08,0x44,0x03,0x44,0x01,0x44,0x03,	/* 1F80: D.D.D.D. */
	0x44,0x01,0x40,0x03,0x44,0x01,0x40,0x03,	/* 1F88: D.@.D.@. */
	0x44,0x03,0x44,0x01,0x44,0x0A,0x44,0x0B,	/* 1F90: D.D.D.D. */
	0x44,0x15,0x40,0x16,0x40,0x06,0x44,0x0E,	/* 1F98: D.@.@.D. */
	0x40,0x06,0x40,0x04,0x44,0x44,0x44,0x44,	/* 1FA0: @.@.DDDD */
	0x44,0x44,0x40,0x40,0x44,0x44,0x44,0x44,	/* 1FA8: DD@@DDDD */
	0x44,0x44,0x44,0x44,0x44,0x44,0x0F,0x44,	/* 1FB0: DDDDDD.D */
	0x06,0x44,0x05,0x44,0x20,0x08,0x44,0x20,	/* 1FB8: .D.D .D  */
	0x39,0x44,0x03,0x44,0x04,0x44,0x0A,0x44,	/* 1FC0: 9D.D.D.D */
	0x05,0x44,0x0D,0x44,0x20,0x04,0x40,0x13,	/* 1FC8: .D.D .@. */
	0x40,0x20,0x4A,0x40,0x21,0x2E,0x40,0x14,	/* 1FD0: @ J@!.@. */
	0x44,0x06,0x40,0x15,0x44,0x06,0x40,0x20,	/* 1FD8: D.@.D.@  */
	0x7F,0x40,0x20,0x22,0x40,0x20,0x61,0x40,	/* 1FE0: @ "@ a@ */
	0x20,0x25,0x40,0x20,0x3B,0x40,0x04,0x40,	/* 1FE8:  %@ ;@.@ */
	0x20,0xE1,0x40,0x1F,0x40,0x06,0x44,0x03,	/* 1FF0:  @.@.D. */
	0x40,0x05,0x40,0x20,0x13,0x44,0x1D,0x40,	/* 1FF8: @.@ .D.@ */
	0x20,0x0E,0x44,0x02,0x40,0x02,0x40,0x03,	/* 2000:  .D.@.@. */
	0x44,0x20,0x05,0x40,0x02,0x40,0x03,0x44,	/* 2008: D .@.@.D */
	0x01,0x44,0x1D,0x44,0x20,0x2B,0x44,0x07,	/* 2010: .D.D +D. */
	0x40,0x07,0x44,0x01,0x40,0x06,0x40,0x09,	/* 2018: @.D.@.@. */
	0x40,0x04,0x40,0x13,0x40,0x01,0x44,0x20,	/* 2020: @.@.@.D  */
	0x03,0x44,0x0B,0x40,0x0A,0x40,0x12,0x40,	/* 2028: .D.@.@.@ */
	0x05,0x44,0x20,0x03,0x40,0x06,0x44,0x04,	/* 2030: .D .@.D. */
	0x44,0x04,0x44,0x16,0x40,0x22,0xEE,0x44,	/* 2038: D.D.@"D */
	0x20,0x0D,0x44,0x16,0x44,0x13,0x44,0x06,	/* 2040:  .D.D.D. */
	0x44,0x08,0x44,0x20,0x40,0x44,0x0E,0x44,	/* 2048: D.D @D.D */
	0x20,0x13,0x44,0x06,0x40,0x14,0x44,0x04,	/* 2050:  .D.@.D. */
	0x44,0x06,0x44,0x1A,0x40,0x20,0x5D,0x44,	/* 2058: D.D.@ ]D */
	0x17,0x44,0x08,0x44,0x20,0x1C,0x44,0x06,	/* 2060: .D.D .D. */
	0x40,0x02,0x44,0x03,0x44,0x05,0x44,0x0D,	/* 2068: @.D.D.D. */
	0x44,0x02,0x44,0x20,0x26,0x40,0x02,0x40,	/* 2070: D.D &@.@ */
	0x20,0x1F,0x40,0x06,0x44,0x05,0x44,0x0C,	/* 2078:  .@.D.D. */
	0x44,0x05,0x44,0x12,0x44,0x12,0x44,0x14,	/* 2080: D.D.D.D. */
	0x44,0x05,0x44,0x0E,0x44,0x20,0x09,0x44,	/* 2088: D.D.D .D */
	0x05,0x44,0x0E,0x40,0x1E,0x40,0x07,0x40,	/* 2090: .D.@.@.@ */
	0x20,0x08,0x40,0x04,0x40,0x01,0x40,0x11,	/* 2098:  .@.@.@. */
	0x40,0x19,0x40,0x0A,0x40,0x18,0x40,0x08,	/* 20A0: @.@.@.@. */
	0x40,0x0C,0x40,0x01,0x40,0x17,0x44,0x20,	/* 20A8: @.@.@.D  */
	0x30,0x40,0x20,0x37,0x40,0x03,0x40,0x00,	/* 20B0: 0@ 7@.@. */
	0x00                                    	/* 20B8: .        */

};
int si2_z280_dsize = sizeof(si2_z280_download);		/* 0x20B9 (8377) */

unsigned short si2_z280_downloadaddr = 0x0000;

/* End of SI2_Z280.C */
