#!/usr/bin/perl

use CGI qw(:standard);

sub gen_rgb {
if($_[2] < 0) {$_[2] += 1;}
if($_[2] > 1) {$_[2] -= 1;}
if (6 * $_[2] < 1) {
   return $_[0] + ($_[1] - $_[0]) * 6 * $_[2];
}
if (2 * $_[2] < 1) {
   return $_[1];
}
if (3 * $_[2] < 2) {
   return $_[0] + ($_[1] - $_[0]) * ((2 / 3) - $_[2]) * 6;
}
return $_[0];
}


# process the parameters (get the color values from it)
if (param("colorchoice") ne "") {
$colorchoice = param("colorchoice");
} else {
$colorchoice = "";
}

@names = param;
foreach $name (@names) {
   if($name =~ /^(.*)\.x$/) {
      if ($1 eq "red") {
         $red = param($name);
         $green = param("color" . $colorchoice . "G");
         $blue = param("color" . $colorchoice . "B");
      } elsif ($1 eq "green") {
         $red = param("color" . $colorchoice . "R");
         $green = param($name);
         $blue = param("color" . $colorchoice . "B");
      } elsif ($1 eq "blue") { 
         $red = param("color" . $colorchoice . "R");
         $green = param("color" . $colorchoice . "G");
         $blue = param($name);
      } elsif ($1 eq "done") {
      $command = param("cgiscript") . "?";
      foreach $name (@names) {
         $command = $command . "$name";
         if(param($name) ne "") {
            $command = $command . "=" . param($name);
         }
         $command = $command . "&";
      }
      chop $command;
         print "Content-type: text/html\n\n";
         print "<html><head>";
         print "<meta HTTP-EQUIV='Refresh' CONTENT='0;URL=http://www.cooltext.com$command'>";
         print "</head><body></body></html>";
#         exec('/home/httpd/html' . param("cgiscript"));
         die; 
      } elsif (($1 eq "hue") || ($1 eq "sat") || ($1 eq "lum")) {
         $red = param("color" . $colorchoice . "R");
         $green = param("color" . $colorchoice . "G");
         $blue = param("color" . $colorchoice . "B");
      } else {
         $colorchoice = $1;
         $red = param("color" . $colorchoice . "R");
         $green = param("color" . $colorchoice . "G");
         $blue = param("color" . $colorchoice . "B");
      }
   }
}


# check for red, green, and blue values.
#if (param("red.x") ne "") {
#$red = param("red.x");
#} else {
#$red = "color" . param("colorchoice") . "R";
#} 
#if (param("green.x") ne "") {
#$green = param("green.x");
#} else {
#$green = param("1");
#} 
#if (param("blue.x") ne "") {
#$blue = param("blue.x");
#} else {
#$blue = param("BI");
#} #else {
#   # return to main form. 

#}

# calculate HSL values from RBG (http://blas.cis.mcmaster.ca/~monger/hsl-rgb.html)
$temp_red = $red/255;
$temp_green = $green/255;
$temp_blue = $blue/255;

$min_color = $temp_red;
if($min_color > $temp_green) {$min_color = $temp_green;}
if($min_color > $temp_blue) {$min_color = $temp_blue;}

$max_color = $temp_red;
if($max_color < $temp_green) {$max_color = $temp_green;}
if($max_color < $temp_blue) {$max_color = $temp_blue;}

if($min_color == $max_color) {
   $hue = 0;
   $sat = 0;
   $lum = $red;
} else {
   $lum = ($min_color + $max_color)/2;
   if($lum < .5) {
      $sat = ($max_color - $min_color)/($max_color + $min_color);
   } else {
      $sat = ($max_color - $min_color)/(2 - $max_color - $min_color);
   }
   if($max_color == $temp_red) {
      $hue = ($temp_green - $temp_blue)/($max_color - $min_color);
   } else {
      if($max_color == $temp_green) {
         $hue = 2 + ($temp_blue - $temp_red)/($max_color - $min_color);
      } else {
         $hue = 4 + ($temp_red - $temp_green)/($max_color - $min_color);
      }
   }
   if($hue < 0) {$hue += 6;} # This is used for the reddish purples which tend
   $hue = int(($hue/6) * 255);    # ...to go negative
   $sat = int($sat * 255);
   $lum = int($lum * 255);
}

# check for clicks on HSL scales and convert to RGBs if you find a new one.
if ((param("hue.x") ne "") || (param("sat.x") ne "") || (param("lum.x") ne "")) {
   if (param("hue.x") ne "") {
      $hue = param("hue.x");
   }
   if (param("sat.x") ne "") {
      $sat = param("sat.x");
   }
   if (param("lum.x") ne "") {
      $lum = param("lum.x");
   }
   if($sat == 0) {
      $red = $green = $blue = $lum;
   } else {
      $temp_hue = $hue/255;
      $temp_sat = $sat/255;
      $temp_lum = $lum/255;
      if($temp_lum < .5) {
         $temp_2 = $temp_lum * (1 + $temp_sat);
      } else {
         $temp_2 = $temp_lum + $temp_sat - ($temp_lum * $temp_sat);
      }
      $temp_1 = 2 * $temp_lum - $temp_2;       
      $temp_3_red = $temp_hue + 1 / 3; 
      $temp_3_green = $temp_hue;
      $temp_3_blue = $temp_hue - 1 / 3;

      $red = int(gen_rgb($temp_1,$temp_2,$temp_hue + 1 / 3) * 255);
      $green = int(gen_rgb($temp_1,$temp_2,$temp_hue) * 255);
      $blue = int(gen_rgb($temp_1,$temp_2,$temp_hue - 1 / 3) * 255);
   }
}


# Print out the new page
print "Content-type: text/html\n\n";

print <<END;

<html>
<head>
<title>Color Picker</title>
</head>
<body bgcolor="#000000" text="#BFBFBF" links="00AAFF" vlink="#B0E4FF">
<font face="arial, helvetica, sans-serif"> 
<form type=post action=/cgi-bin/color_picker.pl> 
END

@names = param;
$ct = 0;
$num_params = @names;
#if ($ct < 20) { 
#   ct = 21;
#}
while ($ct < $num_params) {
   if($names[$ct] ne "color" . $colorchoice . "R") {
      if($names[$ct] !~ /(.*)\.[xy]/) { 
         print "<input type=hidden name=$names[$ct] value=" . param($names[$ct]) . ">";
      }
      $ct++;
   } else {
      $ct += 3;

print <<END;
<center>
<table cellpadding=5 cellspacing=0 border=0>
<tr>
<td colspan=3>
<font face="arial, helvetica, sans-serif">
<input type=image name=red border=0 src=/images/redscale.gif width=255 height=20>
<b>R:</b> 
END

print "<input type=text name=color${colorchoice}R value=$red size=4>";

print <<END;
</td>
</tr>
<tr>
<td colspan=3>
<font face="arial, helvetica, sans-serif">
<input type=image name=green border=0 src=/images/greenscale.gif width=255 height=20>
<b>G:</b>
END

print "<input type=text name=color${colorchoice}G value=$green size=4>";

print <<END;
</td>
</tr>
<tr>
<td colspan=3>
<font face="arial, helvetica, sans-serif">
<input type=image name=blue border=0 src=/images/bluescale.gif width=255 height=20>
<b>B:</b>
END

print "<input type=text name=color${colorchoice}B value=$blue size=4>";

print <<END;
</td>
</tr>
<tr>
<td colspan=3>
<font face="arial, helvetica, sans-serif">
<input type=image name=hue border=0 src=/images/huescale.gif width=255 height=20>
<b>H:
END

print " $hue";

print <<END;
</b>
</td>
</tr>
<tr>
<td colspan=3>
<font face="arial, helvetica, sans-serif">
<input type=image name=sat border=0 src=/images/satscale.gif width=255 height=20>
<b>S:
END

print " $sat";

print <<END;
</b>
</td>
</tr>
<tr>
<td colspan=3>
<font face="arial, helvetica, sans-serif">
<input type=image name=lum border=0 src=/images/grayscale.gif width=255 height=20>
<b>L:
END

print " $lum";

print <<END;
</b>
</td>
<tr>
<td align=left valign=bottom>
<font face="arial, helvetica, sans-serif">
<b>Hex:
END

printf " #%02X%02X%02X", $red, $green, $blue;

print <<END;
</b></font>
</td>
<td 
END

printf "bgcolor=#%02X%02X%02X", $red, $green, $blue;

print <<END;
 width=70>
<br>
</td>
<td valign=bottom>
<center><input type=image src=/images/done.gif name=done border=0></center>
</td>
</tr>

</table>
END

} #else statment
} #while loop

if (param("colorchoice") eq "") {
print "<input type=hidden name=colorchoice value=" . $colorchoice . ">";
}

print <<END;
</form>

</font>
</body>
</html>

END

