#!/usr/bin/perl
# Written by Bryan Livingston for Net-fu
# If there is any cooltext.com formating in this please remove it before using.

# The purpose of this program is to take the net-fu commands through STANDARD CGI and pass them
# to the script-fu server, then output the file to the user

# You will need to change the values IP_ADDR and IP_PORT below.

use IO::Socket;
use CGI qw(:standard);

$MAGIC =   'G';
$IP_ADDR = "209.63.126.138";
$IP_PORT = "10008";

# connect to the server
$remote = IO::Socket::INET->new(
	Proto => "tcp",
	PeerAddr => $IP_ADDR,
	PeerPort => $IP_PORT
) || print_error("Unable to connect to server");
$remote->autoflush(1);

# check if they clicked on an image to get here.
# if so then call the color picker.
@names = param;
$ct = 1;
$num_params = @names;
while ($ct < $num_params) {
   if($names[$ct] =~ /^(.*)\.x$/) {
      $command = "/home/httpd/cgi-bin/color_picker.pl";
#      foreach $name (@names) {
#         $command = $command . "$name";
#         if(param($name) ne "") {
#            $command = $command . "=" . param($name);
#         }
#         $command = $command . "&";
#      }     
#      $command = $command . "colorchoice=$1\"";
#       $ENV{'QUERY_STRING'} = $ENV{'QUERY_STRING'} . "colorchoice=$1";
#      print_error($command);
      exec($command);
      die;
   }
   $ct++;
}

# check params
if(length(param("text")) > 30) {
   print_error("Text string is too long, 30 letter max.");
}
if((param("fontsize") > 150) || (param("fontsize") < 5)) {
   print_error("Font size is too large or small.");
}

# build the command
$command = param("script") . " \"" . param("text") . "\" " . param("fontsize") 
 . " \"" . param("fontname") . "\" ";
@names = param;
#$ct = 5;
$ct = 1;
while (($names[$ct] ne "fontsize") && ($ct < $num_params)) {
    $ct++;
}
$ct++;
$num_params = @names;
while ($ct < $num_params) {
   if($names[$ct] =~ /^color/) {
      $command = $command . "'(" . param($names[$ct]) . " " . param($names[$ct + 1]) . " " . param($names[$ct + 2]) . ") ";
      $ct += 3;
   } elsif ($names[$ct] =~ /^cgiscript/) {
      $ct++;
   } elsif ($names[$ct] =~ /^valuestart/) {
      $ct++;
   } elsif ($names[$ct] =~ /^valueend/) {
      $ct++;
   } elsif ($names[$ct] =~ /^valuestep/) {
      $ct++;
   } elsif ($names[$ct] =~ /^toggle/) {
      if (param($names[$ct]) eq "on") {
         $command = $command . "TRUE ";
      } else {
         $command = $command . "FALSE ";
      }
      $ct++;
   } else {
      if(param($names[$ct]) =~ /[^0-9\-]/) {
         $command = $command . "\"" . param($names[$ct]) . "\" ";
      } else {
         $command = $command . param($names[$ct]) . " ";
      }
      $ct++;
   }
}

# send the command
$len = length($command) + 9;
printf $remote "$MAGIC%c%c(net-fu-$command)",$len >> 8,$len & 0xFF;

# get the results
#if(getc($remote) != $MAGIC) { print_error; }
getc($remote);
getc($remote);
getc($remote);
$len = ord getc($remote);

$command = "";

while ($len > 0) {
   $command = $command . getc($remote);
   $len--;
}

# send the results
if($command =~ /.*\/(.*)$/) {
   print_result($1);
} else {
   print_error("Incorrect results returned");
}

close $remote;

sub print_error {
print header,start_html;
print <<out_head;
<HEAD><TITLE>results</TITLE><style>a {text-decoration:none;}</style></HEAD>
<BODY BGCOLOR=#000000 TEXT=#FFFFFF link=#00AAFF vlink=#B0E4FF> 
<FONT face="arial, helvetica, sans-serif">
out_head

print "An error has occoured: $_[0]<br>Please check your parameters and try again.";
print end_html;
die;
}

sub print_result {
print header;
print <<out_head;
<HEAD><TITLE>results</TITLE><style>a {text-decoration:none;}</style></HEAD>
<BODY BGCOLOR=#000000 TEXT=#BFBFBF link=#00AAFF vlink=#B0E4FF> 
<FONT face="arial, helvetica, sans-serif">
<BR><center>
</center><BR><CENTER>
out_head

print "<img src=http://$IP_ADDR/net-fu/tmp/$_[0]>";
print "<br><a href=http://$IP_ADDR/net-fu/tmp/$_[0]>(Shift-)Click here</a> to download.";

print <<END;
<br>
<br><b>WARNING!!!</b>
<br>The generated image file will only be kept on the server for less than an hour. 
<br>You <b>MUST</b> download it.  You cannot have it hosted here.
<br>

</CENTER>
<A href=http://www.gimp.org><IMG align=right border=0 SRC=/images/gfx_gimp.gif></A>
</BODY></HTML>
END
}

