#include <gtk/gtk.h>
#include "gdk_bitmap_create_from_pixmap.h"


int
main (int argc, char **argv)
{
  GtkWidget *win;
  GdkPixmap *map;
  GtkWidget *pixmap;
  GdkBitmap *mask;

  gtk_init (&argc, &argv);

  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (win, 200, 200);
  gtk_signal_connect (GTK_OBJECT (win), "destroy",
		      GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_widget_realize (win);

  /* Load a back-pixmap */
  map = gdk_pixmap_create_from_xpm (win->window,
				    &mask,
				    NULL,
				    "marble.xpm");
  win->style->bg_pixmap[GTK_STATE_NORMAL] = map;


  /* Create a pixmap from scratch */
  map = gdk_pixmap_new (win->window, 100, 100, -1);

  /* Do some drawing on it */
  gdk_draw_rectangle (map,
		      win->style->bg_gc[GTK_STATE_NORMAL],
		      TRUE,
		      0, 0,
		      100, 100);
  gdk_draw_arc (map,
		win->style->fg_gc[GTK_STATE_SELECTED],
		TRUE,
		10, 10,
		80, 80,
		0, 360 * 64);
  gdk_draw_rectangle (map,
		      win->style->bg_gc[GTK_STATE_NORMAL],
		      TRUE,
		      25, 25,
		      50, 50);

  /* Now we create the bit-mask with the desired transparent color */
  mask = gdk_bitmap_create_from_pixmap (win->window,
					&win->style->bg[GTK_STATE_NORMAL],
					map);
  if (mask == NULL)
    g_error ("Something is going wrong !");

  /* Set mask to NULL, to see what you get without the mask */
  pixmap = gtk_pixmap_new (map, mask);
  gtk_container_add (GTK_CONTAINER (win), pixmap);
  
  gtk_widget_show (pixmap);
  gtk_widget_show (win);
  gtk_main ();
  gtk_exit (0);
  return 0;
}
