#!/bin/env python
#
# Tests of python-Gtk
#

import sys
from Gtkinter import *

def hello():
	pass
	
class GMessageBox(GtkWindow):
	info=0
	warning=1
	error=2
	cancel=0
	ok=1	
	def __init__(self, message, cb=None, type=info,title=""):
		GtkWindow.__init__(self, title="")
		self._cb=cb
		self.borderWidth(3)
		
		self._v1=GtkVBox()
		self._v1.set_spacing(8)
		self._h1=GtkHBox()
		self._h1.set_spacing(4)
		self._h2=GtkHButtonBox()
		self._h2.set_spacing(16)
		if(type==self.info):
			#self._btm=GtkLabel(label="(info) pixmap?")
			self._btm = GtkPixmap(self, 'question.xpm')
		elif(type==self.warning):
			#self._btm=GtkLabel(label="(warning) pixmap?")
			self._btm = GtkPixmap(self, 'gnu-animal.xpm')
		elif(type==self.error):
			#self._btm=GtkLabel(label="(error) pixmap?")
			self._btm = GtkPixmap(self, 'bomb.xpm')
		else:
			self._btm=GtkLabel(label="(unknown) pixmap?")
		self._msg=GtkLabel(label=message)
		self._b_ok=GtkButton(label='OK')
		self._b_ok.connect('clicked', self.process_ok)
		self._b_cancel=GtkButton(label='Cancel')
		self._b_cancel.connect('clicked', self.process_cancel)

		self._h1.add(self._btm)
		self._btm.show()
		self._h1.add(self._msg)	
		self._msg.show()
		self._v1.add(self._h1)
		self._h1.show()
		self._h2.add(self._b_ok)
		self._b_ok.show()
		self._h2.add(self._b_cancel)
		self._b_cancel.show()
		self._v1.add(self._h2)
		self._h2.show()
		self._v1.show()
		self.add(self._v1)
		
	def process_ok(self, args):
		if(self._cb!=None):
			self._cb(self.ok)
		self.destroy()
	def process_cancel(self, args):
		if(self._cb!=None):
			self._cb(self.cancel)
		self.destroy()
		
		
class GFileSelection(GtkFileSelection):
	def __init__(self, cb=None):
		GtkFileSelection.__init__(self)
		self._cb=cb	
		self.ok_button.connect('clicked', self.process_ok)
		self.cancel_button.connect('clicked', self.process_cancel)
		self.help_button.connect('clicked', self.process_help)
	
	def process_ok(self, args):
		if(self._cb!=None):
			self._cb(self.get_filename())
		self.destroy()
					
	def process_cancel(self, args):
		self.destroy()

	def process_help(self, args):
		print "GFileSelection: help"
				
class Application:		
	def __init__(self, argv):
		self.w_window=GtkWindow(title="Test Application")
		self.w_window.border_width(10)		
		self.w_vbox=GtkVBox()

		self.init_menu()
		self.init_canvas()
		
		self.w_window.add(self.w_vbox)
		self.w_vbox.show()
		self.w_window.show()		
		
	def mainloop(self):
		mainloop()

	def init_menu(self):
		self.w_menubar=GtkMenuBar()
		
		# file menu
		self.w_filemenu=GtkMenu()
		
		filemenu=GtkMenuItem('File')
		filemenu.set_submenu(self.w_filemenu)
		filemenu.show()
		
		
		item=GtkMenuItem('New'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_new); item.show()
		item=GtkMenuItem('Open...'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_open); item.show()
		item=GtkMenuItem('Save'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_save); item.show()
		item=GtkMenuItem('Save As...'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_save_as); item.show()
		item=GtkMenuItem('Close'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_close); item.show()
		item=GtkMenuItem('Exit'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_exit); item.show()	

		# edit menu
		self.w_editmenu=GtkMenu()
		editmenu=GtkMenuItem('Edit')
		editmenu.set_submenu(self.w_editmenu)
		editmenu.show()
		
		item=GtkMenuItem('Cut'); self.w_editmenu.append(item)
		item.connect('activate', self.process_edit_cut); item.show()
		item=GtkMenuItem('Copy'); self.w_editmenu.append(item)
		item.connect('activate', self.process_edit_copy); item.show()
		item=GtkMenuItem('Paste'); self.w_editmenu.append(item)
		item.connect('activate', self.process_edit_paste); item.show()

		# help menu
		self.w_helpmenu=GtkMenu()
		helpmenu=GtkMenuItem('Help')
		helpmenu.set_submenu(self.w_helpmenu)
		helpmenu.show()

		item=GtkMenuItem('About'); self.w_helpmenu.append(item)
		item.connect('activate', self.process_help_about); item.show()
		
		self.w_menubar.append(filemenu)
		self.w_menubar.append(editmenu)
		self.w_menubar.append(helpmenu)
		self.w_vbox.pack_start(self.w_menubar, expand=FALSE)
		self.w_menubar.show()
		

	def init_canvas(self):		
		self.w_canvas=GtkDrawingArea()
		self.w_canvas.size(350,250)
		self.w_canvas.show()
		self.w_vbox.pack_start(self.w_canvas)
				
		self.w_canvas.connect("button_press_event", self.process_button)
		self.w_canvas.connect("motion_notify_event", self.process_motion)
		self.w_canvas.connect("key_press_event", self.process_key)
		# XXX replace with 'gdk' constants or deduce automatically from
		# the connected signals ?
		self.w_canvas.set_events(0x07FFFF)
					
	def process_file_new(self, args):
		print "process_file_new"
		
	def process_file_open(self, args):
		print "process_file_open"
		fs=GFileSelection(self.process_file_open_finalize)
		fs.show()

	def process_file_open_finalize(self, file_name):
		print "process_file_open_finalize", file_name
		
	def process_file_save(self, args):
		print "process_file_save"
		dlg=GMessageBox("Not implemented", type=GMessageBox.error)
		dlg.show()
				
	def process_file_save_as(self, args):
		print "process_file_save_as"
		fs=GFileSelection(self.process_file_save_as_finalize)
		fs.show()

	def process_file_save_as_finalize(self, file_name):
		print "process_file_save_as_finalize", file_name
				
	def process_file_close(self, args):
		print "process_file_close"

	def process_file_exit(self, args):
		mainquit()
		
	def process_edit_cut(self, args):
		print "process_edit_cut"
		
	def process_edit_copy(self, args):
		print "process_edit_copy"
		
	def process_edit_paste(self, args):
		print "process_edit_paste"

	def process_help_about(self, args):
		dlg=GMessageBox("""Test Application for Python-Gtk.
		This is free software.
		This application tests mouse and key press events.
		""", type=GMessageBox.info)
		dlg.show()
		
	def process_button(self, win, event):
		print event, "b =", event.button, "x =", event.x, "y =", event.y
		
	def process_motion(self, win, event):
		print event, "is_hint =", event.is_hint, "x =", event.x, "y =", event.y
		
	def process_key(self, win, event):
		print event, "keyval =", event.keyval, "state =", event.state
		
			
if(__name__=="__main__"):
	use_defaults=1
	for arg in sys.argv:
		if(arg=="-d"):
			import pdb
			pdb.set_trace()

		if(arg=="-n"):
			use_defaults=0
			
#	if(use_defaults==1):
#		rc_parse("defaults.rc")
	
	app=Application(sys.argv)
	app.mainloop()
	
