#!/usr/bin/env python
#
# Tests of python-Gtk
#

import sys
from Gtkinter import *
import GtkExtra

class Application:		
	def __init__(self, argv):
		self.w_window=GtkWindow(title="Test Application")
		self.w_window.border_width(10)		
		self.w_vbox=GtkVBox()

		self.init_menu()
		self.init_canvas()
		
		self.w_window.add(self.w_vbox)
		self.w_vbox.show()
		self.w_window.show()		
		
	def mainloop(self):
		mainloop()

	def init_menu(self):
		self.w_menubar=GtkExtra.MenuFactory()

		self.w_menubar.add_entries([
			('File/New',        None, self.process_file_new),
			('File/Open...',    None, self.process_file_open),
			('File/Save',       None, self.process_file_save),
			('File/Save As...', None, self.process_file_save_as),
			('File/Close',      None, self.process_file_close),
			('File/<separator>',None, None),
			('File/Exit',       None, self.process_file_exit),

			('Edit/Cut',   None, self.process_edit_cut),
			('Edit/Copy',  None, self.process_edit_copy),
			('Edit/Paste', None, self.process_edit_paste),

			('Help/About', None, self.process_help_about)
		])
		self.w_vbox.pack_start(self.w_menubar, expand=FALSE)
		self.w_menubar.show()
		return

	def init_canvas(self):		
		self.w_canvas=GtkDrawingArea()
		self.w_canvas.size(350,250)
		self.w_canvas.show()
		self.w_vbox.pack_start(self.w_canvas)
				
		self.w_canvas.connect("button_press_event", self.process_button)
		self.w_canvas.connect("motion_notify_event", self.process_motion)
		self.w_canvas.connect("key_press_event", self.process_key)
		self.w_canvas.set_events(GDK.BUTTON_PRESS_MASK |
					 GDK.POINTER_MOTION_MASK |
					 GDK.POINTER_MOTION_HINT_MASK |
					 GDK.KEY_PRESS_MASK)
					
	def process_file_new(self, args):
		print "process_file_new"
		
	def process_file_open(self, args):
		print "process_file_open"
		print GtkExtra.file_open_box(modal=FALSE), "chosen"

	def process_file_save(self, args):
		print "process_file_save"
		dlg=GtkExtra.message_box("Test Application", "Not implemented",
				("OK",), pixmap='bomb.xpm')
				
	def process_file_save_as(self, args):
		print "process_file_save_as"
		print GtkExtra.file_save_box(modal=FALSE), "chosen"
				
	def process_file_close(self, args):
		print "process_file_close"

	def process_file_exit(self, args):
		mainquit()
		
	def process_edit_cut(self, args):
		print "process_edit_cut"
		
	def process_edit_copy(self, args):
		print "process_edit_copy"
		
	def process_edit_paste(self, args):
		print "process_edit_paste"

	def process_help_about(self, args):
		dlg=GtkExtra.message_box("Test Application",
					 "Test Application for Python-Gtk.\n" +
					 "This is free software.\n" +
					 "This application tests mouse and " +
					 "key press events.", ("OK",),
					 pixmap='question.xpm')
		
	def process_button(self, win, event):
		print event, "b =", event.button, "x =", event.x, "y =", event.y
		
	def process_motion(self, win, event):
		print event, "is_hint =", event.is_hint, "x =", event.x, "y =", event.y
		
	def process_key(self, win, event):
		print event, "keyval =", event.keyval, "state =", event.state
		
			
if(__name__=="__main__"):
	use_defaults=1
	for arg in sys.argv:
		if(arg=="-d"):
			import pdb
			pdb.set_trace()

		if(arg=="-n"):
			use_defaults=0
			
#	if(use_defaults==1):
#		rc_parse("defaults.rc")
	
	app=Application(sys.argv)
	app.mainloop()
	
