/* GimpPluginWindow Widget 
 * Copyright (C) 1998-1999 Shawn T. Amundson
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.             
 *                                                                              
 * This library is distributed in the hope that it will be useful,              
 * but WITHOUT ANY WARRANTY; without even the implied warranty of               
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU            
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */                                                                             

#ifndef __GIMP_PLUGIN_WINDOW_H__
#define __GIMP_PLUGIN_WINDOW_H__

#include <gtk/gtk.h>
/*
#ifdef __cplusplus
extern "C" {
#endif *//* __cplusplus */

#define GIMP_TYPE_PLUGIN_WINDOW
#define GIMP_PLUGIN_WINDOW(obj)            (GTK_CHECK_CAST ((obj), GIMP_TYPE_PLUGIN_WINDOW, GimpPluginWindow))
#define GIMP_PLUGIN_WINDOW_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GIMP_TYPE_PLUGIN_WINDOW, GimpPluginWindowClass))
#define GIMP_IS_PLUGIN_WINDOW(obj)         (GTK_CHECK_TYPE ((obj), GIMP_TYPE_PLUGIN_WINDOW))
#define GIMP_IS_PLUGIN_WINDOW_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GIMP_TYPE_PLUGIN_WINDOW))

typedef struct _GimpPluginWindow      GimpPluginWindow;
typedef struct _GimpPluginWindowClass GimpPluginWindowClass;

struct _GimpPluginWindow {
  GtkWindow parent;

  GtkWidget *child_container;
  GtkWidget *preview;

  GDrawable *drawable;

};

struct _GimpPluginWindowClass {
  GtkWindowClass parent_class;

  void (* clicked_ok)           (GimpPluginWindow *window);
  gint (* clicked_cancel)       (GimpPluginWindow *window);
};

typedef enum {
  GIMP_PLUGIN_NORMAL
} GimpPluginWindowType;

GtkType    gimp_plugin_window_get_type (void);
GtkWidget* gimp_plugin_window_new      (GimpPluginWindowType type, 
				        const char *title,
					GDrawable *drawable);

/*
#ifdef __cplusplus
}
#endif *//* __cplusplus */


#endif /* __GIMP_PLUGIN_WINDOW_H__ */
