#include <gtk/gtk.h>

#include <signal.h>

#include "at_main.h"
#include "at_interface.h"
#include "at_com.h"
#include "at_track.h"

int main (int argc, char *argv[])
{
    struct sigaction sig;
    
    sig.sa_handler = SIG_IGN;
    sig.sa_flags = SA_NOCLDSTOP | SA_NOMASK;
    sigaction(SIGCHLD, &sig, NULL);
    
    gtk_init (&argc, &argv);

    /* initialize play/record server interface */
    at_com_init();
    
    /* initialize user interface */
    at_interface_init();

    gtk_main ();

    at_com_cleanup();
    
    return 0;
}








