#include <gtk/gtk.h>
#include "region.h"
#include "at_type.h"
#include "at_track.h"
#include "at_view.h"
#include "at_clip.h"
#include "libatech.h"
#include "at_mix.h"

#define MIX_CHUNK_SIZE 512


static gint
at_idle_mix (gpointer data);

static void 
at_mix_complete (Clip *clip);


/* Yes, I know, there is nothing in here with offsets.  I'll have to add
 * it in later, but it works much better than the old code IMHO */

void
at_mix_tracks_in_clip (Clip *clip, size_t offset, size_t length)
{
    Track  *track;
    size_t  x1, x2;
    GSList  *list = clip->tracks;
    GSList  *track_list = NULL;
    gint track_count = 0;
    TmpRegion *mix_dest;
    Mix *mix_data = &clip->mix;
    gint mix_needed = FALSE;
    gint clip_length = 0;

    /* check for dirty tracks to see if we require remixing. */
    while (list) {
	track = (Track *) list->data;

	/* we ignore the composite track.. */
	if (track->dirty && !track->is_composite)
	    mix_needed = TRUE;

	list = list->next;
    }

    if (!mix_needed && !clip->dirty)
	return;

    g_print ("mixing tracks.... \n");

    /* if we're already in the process of mixing, kill it,
       and restart. */
    if (clip->mixing)
	at_mix_stop_idle_mix(clip);

    /* Create a list of all tracks that need mixing */
    /* we also determine the length needed for the composite here.
       It should NOT be resized anywhere else from now on, because
       we are mixing on an idle, which means you could be resising
       the composite while it's mmap'd. */
    list = clip->tracks;
    while (list) {
	track = (Track *) list->data;
      
	if (!track->mute && !track->is_composite) {
	    track_list = g_slist_prepend (track_list, track);
	    track_count ++;
	    /* determine length composite */
	    if (track->length > clip_length) {
		clip_length = track->length;
	    }
	}
      
	list = list->next;
    }

    if (track_count == 0)
	return;

    /* resize the region, and set clip->length to match */
    region_resize (clip->composite, 0, clip_length);
    clip->length = clip->composite->length;

  

    /* zero out the composition track */
    mix_dest = tmp_region_new (clip->composite, 0, clip->length);
    tmp_region_zero (mix_dest);

    mix_data->track_count = track_count;
    mix_data->track_list = track_list;
    mix_data->list = track_list;
    mix_data->position = 0;
    mix_data->current_track = NULL;
    mix_data->composite_region = mix_dest;
    mix_data->bps = clip->composite->bps;

    /* set up the idle to mix the tracks */
    mix_data->record_tag = gtk_idle_add (at_idle_mix, clip);

    clip->mixing = TRUE;
  
}

/* this is going to get big.... */

static gint
at_idle_mix (gpointer data)
{
    Clip *clip = data;
    Mix *mix = &clip->mix;
    Track *track = NULL;
    gint track_done = FALSE;
    gint count, i;
    atdata *dest_data, *src_data;
    gint track_size;
    
    /* check if there's a track on the queue */
    if (!mix->current_track) {

	/* if we're at the end of the track list, 
	   we're done mixing */
	if (mix->list == NULL) {
	    /* we have now completed the mixing */
	    dest_data = mix->composite_region->data;
	    track_size = mix->composite_region->bps * mix->composite_region->length / 
		sizeof (atdata);
	    
	    g_print ("Idle mixing completed... \n");
	    
	    g_slist_free (mix->track_list);
	    tmp_region_destroy (mix->composite_region);
      
	    at_mix_complete(clip);
      
	    gtk_idle_remove (mix->record_tag);
	    return (FALSE);
	}

	/* get next track from linked list */
	mix->current_track = mix->list->data;

	track = mix->current_track;

	g_print ("queuing track '%s' for mixing ..\n", track->data->filename);

	/* map track */
	mix->track_region = tmp_region_new (track->data, 0,
					    track->length);
	/* since this is a new track, set the position to 0 */
	mix->position = 0;
	mix->list = mix->list->next;
    }
    
    track = mix->current_track;

    track_size = track->data->bps * track->length / sizeof (atdata);

    count = MIX_CHUNK_SIZE * mix->bps;

    /*
      g_print ("Mixing - chunk count %d - position %d - track size %d\n", 
      count, mix->position, track_size);
    */
    if (count + mix->position > track_size) {
	count = track_size - mix->position;
	track_done = TRUE;
    }

    dest_data = mix->composite_region->data;
    dest_data += mix->position;
    src_data = mix->track_region->data;
    src_data += mix->position;
  
    mix->position += count;

    /* perform the actual mixing */
    /* FIXME: handle number of channels correctly */
    for (i=0; i < count; i++) {
	dest_data[i] += (src_data[i] * track->volume);
    }


    if (track_done) {
	tmp_region_destroy (mix->track_region);
	track->dirty = FALSE;
	track->change = AT_TRACK_CHANGED_NONE;
	mix->current_track = NULL;
    }

    return (TRUE);
}

void
at_mix_stop_idle_mix(Clip *clip)
{
    Mix *mix;
    mix = &clip->mix;

    if (clip->mixing == FALSE)
	return;
  
    clip->mixing = FALSE;

    /* since mixing was not complete, we remark as dirty */
    clip->dirty = TRUE;


    if (mix->composite_region)
	tmp_region_destroy (mix->composite_region);
  
    g_slist_free (mix->track_list);
    gtk_idle_remove (mix->record_tag);
}


static void 
at_mix_complete (Clip *clip)
{
    clip->composite_track->length = clip->composite->length;
    at_track_build_preview (clip->composite_track);
    at_track_adjust_volume_of_preview (clip->composite_track, 1.0, 
				       clip->composite_track->volume); 
    at_track_update_preview (clip->composite_track);
    clip->mixing = FALSE;
}





