/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "memory_shm.h"

typedef struct _GimpShm GimpShm;
typedef struct _GimpShmSeg GimpShmSeg;


/* a portion of an OS shm segment */
struct _GimpShm
{
  /* the segment we are in */
  GimpShmSeg * segment;

  /* the data location */
  gint offset;
  gint size;

  /* the number of ptrs attached to us */
  gint ptrcount;

  /* the number of uses by all ptrs */
  gint usecount;
};


/* an OS shm segment.  data is volatile and may change when usecount
   touches 0 */
struct _GimpShmSeg
{
  /* the segment id */
  gint shmid;

  /* permissions */
  gint perms;

  /* the size of this segment */
  gint size;

  /* the current attach point */
  void * data;

  /* the number of GimpShms attached to us */
  gint ptrcount;

  /* the number of uses by all GimpShms */
  gint usecount;
};


/* this singleton tracks all registered shm segments (GimpShmSeg) and
   defined ranges (GimpShm) in the system.  Each is assigned a unique
   GimpShmId */
struct _GimpShmMgr
{
  int foo;
};




