#ifndef _ASM_HARDIRQ_H
#define _ASM_HARDIRQ_H

#include <linux/threads.h>
#include <linux/irq.h>
#include <asm/exceptions.h>

/* assembly code in softirq.h is sensitive to the offsets of these fields */
typedef struct {
	unsigned int	__softirq_pending;
	unsigned long	idle_timestamp;
	unsigned int	__syscall_count;
	unsigned int	__nmi_count;	/* arch dependent */
	unsigned int	__irq_count;	/* arch dependent */
} irq_cpustat_t;

#include <linux/irq_cpustat.h>	/* Standard mappings for irq_cpustat_t above */

extern void ack_bad_irq(unsigned int irq);

/*
 * manipulate stubs in the MN10300 CPU Trap/Interrupt Vector table
 * - these should jump to __common_exception in entry.S unless there's a good
 *   reason to do otherwise (see trap_preinit() in traps.c)
 */
typedef void (*intr_stub_fnx)(struct pt_regs * regs, exception_code_t intcode);
extern void set_intr_stub(exception_code_t code, void *handler);

/*
 * manipulate pointers in the Exception table (see entry.S)
 * - these are indexed by decoding the lower 24 bits of the TBR register
 * - note that the MN103E010 doesn't always trap through the correct vector,
 *   but does always set the TBR correctly
 */
extern asmlinkage void set_excp_vector(exception_code_t code, intr_stub_fnx handler);

#endif /* _ASM_HARDIRQ_H */
