/* pgalloc.h: page and page table/directory allocation
 *
 * Copyright (C) 2001 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 */

#ifndef _ASM_PGALLOC_H
#define _ASM_PGALLOC_H

#include <asm/processor.h>
#include <asm/page.h>
#include <linux/threads.h>
#include <linux/sched.h>
#include <linux/errno.h>

struct mm_struct;
struct page;

/*
 * Allocate and free page tables.
 */

extern pgd_t *pgd_alloc(struct mm_struct *);
extern void pgd_free(pgd_t *pgd);

extern pte_t *pte_alloc_one_kernel(struct mm_struct *, unsigned long);
extern struct page *pte_alloc_one(struct mm_struct *, unsigned long);

static inline void pte_free_kernel(pte_t *pte)
{
	free_page((unsigned long) pte);
}

static inline void pte_free(struct page *pte)
{
	__free_page(pte);
}


#define __pte_free_tlb(tlb, pte) tlb_remove_page((tlb), (pte))

#endif /* _ASM_PGALLOC_H */
