/* semaphore.h: semaphores for the MN10300
 *
 * Copyright (C) 2003,5 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#ifndef _ASM_SEMAPHORE_H
#define _ASM_SEMAPHORE_H

#ifndef __ASSEMBLY__

#include <linux/linkage.h>
#include <linux/wait.h>

#define _LVM_H_INCLUDE			/* get the definition of list_head */
#include <linux/list.h>

#define SEMAPHORE_DEBUG		WAITQUEUE_DEBUG

/*
 * the semaphore definition
 * - if counter is >0 then there are tokens available on the semaphore for down to collect
 * - if counter is <=0 then there are no spare tokens, and anyone that wants one must wait
 * - if wait_list is not empty, then there are processes waiting for the semaphore
 */
struct semaphore {
	unsigned		counter;
	int			dummy_lock;
	struct list_head	wait_list;
#if SEMAPHORE_DEBUG
	unsigned		__magic;
#endif
};


#endif /* __ASSEMBLY__ */

#endif
